(********************************************************)
(* cerrors.pas    			    1995-07-25  *)
(*                                                      *)
(* Error handling for CTOOLS        			*)
(*                                                      *)
(* Copyright (C) 1995  Jochen Metzinger			*)
(*                                                      *)
(* This file is distributed WITHOUT ANY WARRANTY;	*)
(* without even the implied warranty of MERCHANTABILITY *)
(* or FITNESS FOR A PARTICULAR PURPOSE.        		*)
(********************************************************)

UNIT Cerrors;

INTERFACE

TYPE
 ErrorType =
  (E_NONE, E_INTERN, E_FULL, E_DIRFULL,
   E_COMMAND, E_PARAM, E_NOFILE, E_FILE, E_IMAGE,
   E_TRKSEC, E_SEC, E_READ, E_WRITE,
   E_DIR, E_FILEWILD, E_OPEN);

VAR
 errno: ErrorType;
 err_p1, err_p2: LongInt;
 err_s: STRING;

PROCEDURE error(err: ErrorType);
(* set error condition *)
FUNCTION is_err: BOOLEAN;
(* test for an error *)
PROCEDURE err_recover;
(* print out error and continue *)
PROCEDURE FATAL(err: ErrorType);
(* print out error and stop program *)
PROCEDURE err_stop;
(* if is_err then FATAL() *)

IMPLEMENTATION

PROCEDURE error(err: ErrorType);
BEGIN
 errno := err;
END; (* error *)

FUNCTION is_err: BOOLEAN;
BEGIN
  is_err := errno <> E_NONE;
END; (* is_err *)

PROCEDURE out_error(typ: STRING);
BEGIN
 IF errno = E_NONE THEN EXIT;
 Write(typ,': ');
 CASE errno OF
  E_INTERN: WriteLn('INTERN #',err_p1);
  E_COMMAND: WriteLn('unknown command "', err_s,'"');
  E_PARAM: IF err_p1 < 2
            THEN WriteLn(err_p1,' parameter expected')
            ELSE WriteLn(err_p1,' parameters expected');
  E_FULL: WriteLn('disk full');
  E_DIRFULL: WriteLn('directory full');
  E_NOFILE: WriteLn('file not found');
  E_FILE: WriteLn('file found');
  E_IMAGE: WriteLn('not a single sided C=128 CP/M image');
  E_TRKSEC: WriteLn('illegal track and sector ',err_p1,' ',err_p2);
  E_SEC: WriteLn('illegal sector ',err_p1);
  E_READ: WriteLn('read file');
  E_WRITE: WriteLn('write file');
  E_DIR: WriteLn('directory corrupted');
  E_FILEWILD: WriteLn('wildcards in filename');
  E_OPEN: WriteLn('unable to open file');
  ELSE WriteLn('unknown ',ORD(errno));
 END;
END; (* out_error *)

PROCEDURE err_recover;
(* gibt den Fehlertext aus *)
BEGIN
 out_error('ERROR');
 errno := E_NONE;
END; (* err_recover *)

PROCEDURE FATAL(err: ErrorType);
BEGIN
 errno := err;
 out_error('FATAL');
 HALT(1);
END; (* FATAL *)

PROCEDURE err_stop;
BEGIN
 IF is_err THEN FATAL(errno);
END; (* err_stop *)

BEGIN
 errno := E_NONE;
END. (* Cerrors *)