(********************************************************)
(* cdevice.pas    			    1995-07-25  *)
(*                                                      *)
(* Device interface of CTOOLS          			*)
(*                                                      *)
(* Copyright (C) 1995  Jochen Metzinger			*)
(*                                                      *)
(* This file is distributed WITHOUT ANY WARRANTY;	*)
(* without even the implied warranty of MERCHANTABILITY *)
(* or FITNESS FOR A PARTICULAR PURPOSE.        		*)
(********************************************************)

UNIT Cdevice;

INTERFACE

CONST
 NR_SECTOR   =  170; (* CP/M sectors *)
 SECTOR_SIZE = 1024; (* = 4*C1541_SIZE *)
 SECTOR_DIR  =   32; (* dir-entries in a sector *)
 DIR_SECTOR  =    2; (* dir-sectors *)
 DIR_ENTRIES =   64; (* = SECTOR_DIR * DIR_SECTOR *)

TYPE
 SECTOR      = ARRAY [0..SECTOR_SIZE-1] OF BYTE;

PROCEDURE dev_open(fname: STRING);
(* open device *)
PROCEDURE dev_close;
(* close device *)
PROCEDURE dev_read(nr: WORD; VAR sek: SECTOR);
(* read a sector *)
PROCEDURE dev_write(nr: WORD; VAR sek: SECTOR);
(* write a sector *)

IMPLEMENTATION

USES Cerrors, C1541;

TYPE
 REGION =
  RECORD
   von, snr, max: WORD;
   add, skew: WORD;
  END;

CONST
 geometry: ARRAY [1..4] OF REGION =
  ((von: 01; snr: 21; max: 357; add: 2; skew: 5),
   (von: 18; snr: 19; max: 133; add: 1; skew: 5),
   (von: 25; snr: 18; max: 108; add: 0; skew: 5),
   (von: 31; snr: 17; max:  85; add: 0; skew: 5));

VAR drv: C1541_DRV;

PROCEDURE dev_open(fname: STRING);
 VAR boot: C1541_BLOCK;
BEGIN
 C1541_init(fname,drv);
 drv.open(fname);
 err_stop;
 drv.read(1,0,boot);
 err_stop;
 IF (boot[0] <> $43) OR (boot[1] <> $42) OR (boot[2] <> $4D) THEN
  FATAL(E_IMAGE);
 IF boot[$FF] = $FF THEN
  FATAL(E_IMAGE);
END; (* dev_open *)

PROCEDURE dev_close;
BEGIN
 drv.close;
END; (* dev_close *)

PROCEDURE cpm_1541 (qs: WORD; VAR trk, sect: WORD);
 VAR i: BYTE;
BEGIN
 error(E_NONE);
 err_p1 := qs DIV 4;
 FOR i := 1 TO 4 DO
  WITH geometry[i] DO BEGIN
   qs := qs + add;
   IF qs < max THEN BEGIN
    trk  := von + (qs DIV snr);
    sect := (skew*qs) MOD snr;
    EXIT;
   END; (* if *)
   qs := qs - max
  END; (* with *)
 error(E_SEC);
END; (* cpm_1541 *)

PROCEDURE dev_read(nr: WORD; VAR sek: SECTOR);
 VAR w, tr, sk: WORD;
  both: ARRAY [0..3] OF C1541_BLOCK ABSOLUTE sek;
BEGIN
 FOR w := 0 TO 3 DO BEGIN
  cpm_1541(4*nr+w, tr, sk);
  IF is_err THEN EXIT;
  drv.read(tr,sk,both[w]);
  IF is_err THEN EXIT;
 END;
END; (* dev_read *)

PROCEDURE dev_write(nr: WORD; VAR sek: SECTOR);
 VAR w, tr, sk: WORD;
  both: ARRAY [0..3] OF C1541_BLOCK ABSOLUTE sek;
BEGIN
 FOR w := 0 TO 3 DO BEGIN
  cpm_1541(4*nr+w, tr, sk);
  IF is_err THEN EXIT;
  drv.write(tr,sk,both[w]);
  IF is_err THEN EXIT;
 END;
END; (* dev_write *)

END. (* Cdevice *)