(********************************************************)
(* c1541.pas    			    1995-07-25  *)
(*                                                      *)
(* Accessing C=1541 (image) for CTOOLS 			*)
(*                                                      *)
(* Copyright (C) 1995  Jochen Metzinger			*)
(*                                                      *)
(* This file is distributed WITHOUT ANY WARRANTY;	*)
(* without even the implied warranty of MERCHANTABILITY *)
(* or FITNESS FOR A PARTICULAR PURPOSE.        		*)
(********************************************************)

UNIT C1541;

INTERFACE

CONST
 BLOCK_SIZE  = 256; (* size of a C=64 block *)
 C1541_SIZE  = 683; (* blocks on a disk *)

TYPE
 C1541_BLOCK = ARRAY [0..BLOCK_SIZE-1] OF BYTE;

 C1541_DRV = RECORD
  	      open: PROCEDURE(fname: STRING);
              close: PROCEDURE;
	      read: PROCEDURE(tr, sk: BYTE; VAR bl: C1541_BLOCK);
	      write: PROCEDURE(tr, sk: BYTE; VAR bl: C1541_BLOCK);
	     END; (* C1541_DRV *)

PROCEDURE C1541_init(fname: STRING; VAR drv: C1541_DRV);

IMPLEMENTATION

USES Cerrors;

TYPE
 REGION = RECORD von, bis, snr: BYTE; offs: WORD; END;

CONST
 geometry: ARRAY [1..4] OF REGION =
  ((von: 01; bis: 17; snr: 21; offs: 000),
   (von: 18; bis: 24; snr: 19; offs: 357),
   (von: 25; bis: 30; snr: 18; offs: 490),
   (von: 31; bis: 35; snr: 17; offs: 598));

VAR
 D64_disk: FILE OF C1541_BLOCK;

PROCEDURE D64_seek(tr, sk: BYTE; et: ErrorType);
 VAR i: BYTE; pos: WORD;
BEGIN
 error(E_NONE);
 FOR i := 1 TO 4 DO
  IF tr <= geometry[i].bis THEN BEGIN
   IF sk >= geometry[i].snr THEN BEGIN
    err_p1 := tr; err_p2 := sk;
    error(E_TRKSEC); EXIT;
   END; (* if *)
   WITH geometry[i] DO
    pos := offs + snr*(tr - von) + sk;
   (*$I-*)
   Seek(D64_disk,pos);
   (*$I+*)
   IF IOResult <> 0 THEN error(et);
   EXIT;
  END; (* if *)
 err_p1 := tr; err_p2 := sk;
 error(E_TRKSEC);
END; (* D64_seek *)

{$F+}
PROCEDURE D64_read(tr, sk: BYTE; VAR bl: C1541_BLOCK);
BEGIN
 D64_seek(tr,sk,E_READ);
 IF is_err THEN EXIT;
 (*$I-*)
 Read(D64_disk,bl);
 (*$I+*)
 IF IOResult <> 0 THEN FATAL(E_READ);
END; (* D64_read *)
{$F-}

{$F+}
PROCEDURE D64_write(tr, sk: BYTE; VAR bl: C1541_BLOCK);
BEGIN
 D64_seek(tr,sk,E_WRITE);
 IF is_err THEN EXIT;
 (*$I-*)
 Write(D64_disk,bl);
 (*$I+*)
 IF IOResult <> 0 THEN FATAL(E_WRITE);
END; (* D64_write *)
{$F-}

{$F+}
PROCEDURE D64_open(fname: STRING);
 VAR BAM: C1541_BLOCK;
BEGIN
 (*$I-*)
 Assign(D64_disk, fname);
 Reset(D64_disk);
 (*$I+*)
 IF IOResult <> 0 THEN
  FATAL(E_NOFILE);
 IF FileSize(D64_disk) <> C1541_SIZE THEN
  FATAL(E_IMAGE);
 D64_read(18,0,BAM);
 IF is_err THEN FATAL(errno);
 IF (BAM[2] <> 65) OR (BAM[165] <> 50) OR (BAM[166] <> 65) THEN
  FATAL(E_IMAGE);
END; (* D64_open *)
{$F-}

{$F+}
PROCEDURE D64_close;
BEGIN
 Close(D64_disk);
END; (* D64_close *)
{$F-}

PROCEDURE C1541_init(fname: STRING; VAR drv: C1541_DRV);
BEGIN
 WITH drv DO BEGIN
  open := D64_open;
  close := D64_close;
  read := D64_read;
  write := D64_write;
 END;
END; (* C1541_init *)

END. (* C1541 *)