#include <stdlib.h>
#include <math.h>

/* This is getting ugly.  It needs a major re-write methinks. */
#define bright 1.0
#define contrast 1.0

int out_red[16], out_green[16], out_blue[16];

void convert_from_RGB()
{
    int red2[4096], blue2[4096], green2[4096], mapper[4][4096];
    int num_compare = 16;
    int xpixsize = 1, partpix;
    int dither = 1, maplevel, yd = 0;
    int vi = 0, x;
    /* bright */
    for (x = 0; x < 16; x++)
    {
	out_red[x] = (double) ((double) reds[x] / bright);
	out_green[x] = (double) ((double) greens[x] / bright);
	out_blue[x] = (double) ((double) blues[x] / bright);
    }
    /* contrast */
    for (x = 0; x < 16; x++)
    {
	out_red[x] = (double) (((double) out_red[x] - 0x80) / contrast) + 0x80;
	out_green[x] = (double) (((double) out_green[x] - 0x80) / contrast) + 0x80;
	out_blue[x] = (double) (((double) out_blue[x] - 0x80) / contrast) + 0x80;
    }

    printf("\n\nWould you like dithered output? (y/n)\n");
    do
    {
	x = getchar();
    }
    while (x != 'y' && x != 'n');
    if (x == 'n')
	dither = 0;

    printf("\n\nWould you like pixel doubled output? (y/n)\n");
    do
    {
	x = getchar();
    }
    while (x != 'y' && x != 'n');
    if (x == 'y')
	xpixsize = 2;
    if (dither != 0)
    {
	printf("\n\nWould you like simple, simple-modulated, new modulated, complex, or alt-complex dither (s,m,n,c,a)?\n");
	do
	{
	    x = getchar();
	}
	while (x != 's' && x != 'm' && x != 'c' && x != 'n' && (x != 'a'));
	if (x == 'm')
	    vi = 1;
	if (x == 'c')
	    dither = 2;
	if (x == 'n')
	    dither = 4;
	if (x == 'a')
	    dither = 5;
    }
/* seperate complex dither for the moment. (which is when dither == 2
 * This should be #define'd, but it isnt, so there :P.
 */
    if (dither != 2 && dither != 4)
    {
	int x;
	double *error;
	double *nexterror;
	double *tmp;

	/* allocate error */
	error = (double *) malloc((10000) * sizeof(double));
	nexterror = (double *) malloc((10000) * sizeof(double));

	if (error == NULL || nexterror == NULL)
	    abort();

	for (x = 0; x < 10000; x++)
	    error[x] = nexterror[x] = 0;

	/* create the color table */
	if (dither == 0)
	    for (x = 0; x < 16; x++)	/* just copy the std. 16 color */
	    {
		maplevel = 1;
		red2[x] = out_red[x];
		blue2[x] = out_blue[x];
		green2[x] = out_green[x];
		mapper[0][x] = x;
	} else if (dither == 1 || dither == 5)	/* assume std.  dither */
	{
	    num_compare = 0;
	    maplevel = 2;
	    for (x = 0; x < 16; x++)
		for (y = 0; y < 16; y++)
		{
		    int d, pr, pg, pb, q;
		    q = 0;
		    pr = (out_red[x] + out_red[y]) / 2;
		    pg = (out_green[x] + out_green[y]) / 2;
		    pb = (out_blue[x] + out_blue[y]) / 2;

		    for (d = 0; d < num_compare; d++)
			if (pr == red2[d] && pg == green2[d] && pb == blue2[d])
			    q = 1;

		    if (q == 0 || x == y)
		    {
                       int c1,c2;
/*			mapper[0][num_compare] = x;
			mapper[1][num_compare] = y;*/
                        /* check to swap mappers */                        
                        c1=out_red[x]+out_green[x]+out_blue[x];
                        c2=out_red[y]+out_green[y]+out_blue[y];
                        if(c1<c2) 
                        {
                           mapper[0][num_compare] = x;
                           mapper[1][num_compare] = y;
                        }                        
                        else
                        {
                           mapper[0][num_compare] = y;
                           mapper[1][num_compare] = x;                        
                        }
			red2[num_compare] = pr;
			blue2[num_compare] = pb;
			green2[num_compare] = pg;
			num_compare++;

		    }
		}
	}
	for (y = 0; y < ysize; y++)
	{
	    tmp = error;
	    error = nexterror;
	    nexterror = tmp;
	    for (x = 0; x < 10000; x++)
		nexterror[x] = 0;
	    for (x = 0; x < xsize; x += xpixsize)
	    {
		int d[256], c, r, g, b, max = 999999, maxc;                
		/* perform the comparison between the computed colors and the <x>
		 * pixels involved */
		for (c = 0; c < num_compare; c++)
		{
		    d[c] = 0;
		    for (partpix = 0; partpix < xpixsize; partpix++)
		    {
			r = abs(RgbOut[0][y][x + partpix] - red2[c]);
			g = abs(RgbOut[1][y][x + partpix] - green2[c]);
			b = abs(RgbOut[2][y][x + partpix] - blue2[c]);
			d[c] += (r + g + b);
		    }
		    d[c] /= xpixsize;
		}



		for (c = 0; c < num_compare; c++)
		    if (d[c] < max)
		    {
			maxc = c;
			max = d[c];
		    }
		{
		    int max1, max2, val, d1, d2;
		    double pc, tr;
		    max1 = red2[mapper[0][maxc]] + green2[mapper[0][maxc]] + blue2[mapper[0][maxc]];
		    max2 = red2[mapper[1][maxc]] + green2[mapper[1][maxc]] + blue2[mapper[1][maxc]];
		    val = RgbOut[0][y][x] + RgbOut[1][y][x] + RgbOut[2][y][x];
		    d1 = abs(max1 - val);
		    d2 = abs(max2 - val);

		    pc = (double)d2 / (double)(d1 + d2);
                    if((d1+d2)==0) pc=0;   
                    if(pc>1 || pc <0) printf("diff: %d, %d, %d, %f\n",d1+d2,d1,d2,pc);


		    /* write out the final pixel(s) */
		    for (partpix = 0; partpix < xpixsize; partpix++)
		    {
			if (dither == 0)
			    OutPixels[y][x + partpix] = maxc;
			else if (dither == 1)
			{
			    if ((((x / xpixsize) + y) & 1 == 1 /*&& pc < 0.75*/)/* || pc < 0.25*/)
				OutPixels[y][x + partpix] = mapper[0][maxc];
			    else
				OutPixels[y][x + partpix] = mapper[1][maxc];
    
			} else if (dither == 5)
			{
			    double newval, cerror;
			    int tv;
			    newval = pc + error[x / xpixsize];
                                                        
			    newval = floor(newval + 0.5);
                            tv=newval;
                            //printf("pc=%f, tv=%d, x=%d\n",pc,tv,x);
			    if (tv < 0)
                                tv = 0;
			    if (tv > 1)
				tv = 1;
                            //printf("%d\n",max1-max2);
                            
                            
			    cerror = pc + error[x / xpixsize] - tv;
                            
			    //if(cerror>1) printf("%f -> %f -> %f\n",cerror, pc+error[x], error[x]);
			    nexterror[x / xpixsize] += cerror * 5 / 16;
			    error[x / xpixsize + 1] += cerror * 7 / 16;
			    nexterror[x / xpixsize + 1] += cerror * 1 / 16;
			    if (x != 0)
			    {
				nexterror[x / xpixsize - 1] += cerror * 3 / 16;
			    }
			    for (partpix = 0; partpix < xpixsize; partpix++)
				if (tv == 0)
				    OutPixels[y][x + partpix] = mapper[0][maxc];
				else
				    OutPixels[y][x + partpix] = mapper[1][maxc];
			}
		    }
		}
	    }
	}
    } else
/*  "Complex" dither 
 * 
 * Floyd-Steinberg dither at the moment
 * 
 * 
 */
    {
	int x;
	double *error;
	double *nexterror;
	double *tmp;

	/* allocate error */
	error = (double *) malloc((10000) * sizeof(double));
	nexterror = (double *) malloc((10000) * sizeof(double));

	if (error == NULL || nexterror == NULL)
	    abort();

	for (x = 0; x < 10000; x++)
	    error[x] = nexterror[x] = 0;



	num_compare = 16;
	maplevel = 2;

	for (y = 0; y < ysize; y++)
	{
	    tmp = error;
	    error = nexterror;
	    nexterror = tmp;
	    for (x = 0; x < 10000; x++)
		nexterror[x] = 0;
//           printf("y==%d\n",y);
	    for (x = 0; x < xsize; x += xpixsize)
	    {
		int c, r, g, b, maxc, maxc2, max1, max2, val;
		double pc, tr, d[256], d2[256], max = 99999, min = -999999;
		/* perform the comparison between the computed colors and the <x>
		 * pixels involved */


		/* perform the comparison between the computed colors and the <x>
		 * pixels involved */
		for (c = 0; c < num_compare; c++)
		{
		    d[c] = 0;
		    d2[c] = 0;
		    for (partpix = 0; partpix < xpixsize; partpix++)
		    {
			r = (RgbOut[0][y][x + partpix] - out_red[c]);
			g = (RgbOut[1][y][x + partpix] - out_green[c]);
			b = (RgbOut[2][y][x + partpix] - out_blue[c]);
			d[c] += (r + g + b);
			d2[c] += (abs(r) + abs(g) + abs(b));
		    }
		    d[c] /= (double) xpixsize;
		}
		val = 0;
		for (partpix = 0; partpix < xpixsize; partpix++)
		    val += abs(RgbOut[0][y][x + partpix] + RgbOut[1][y][x + partpix] + RgbOut[2][y][x + partpix]);
		val /= partpix;

		maxc = 1;
		maxc2 = 0;
		max = 9999999;
		min = 0 - 999999;
		for (c = 0; c < num_compare; c++)
		{
		    if (d[c] > 0)
		    {
			if (d2[c] < max)
			{
			    maxc = c;
			    max = d2[c];
			}
		    } else
		    {
			if ((0 - d2[c]) > min)
			{
			    maxc2 = c;
			    min = (0 - d2[c]);
			}
		    }

		}
		r = out_red[maxc];
		g = out_blue[maxc];
		b = out_green[maxc];
		max1 = r + g + b;

		r = out_red[maxc2];
		g = out_blue[maxc2];
		b = out_green[maxc2];
		max2 = r + g + b;

		if (max1 > max2)
		{
		    pc = val - max2;
		    pc /= (double) (max1 - max2);
		    pc = 1 - pc;
                    if((max1-max2)==0) pc=1;
		} else
		{
		    pc = val - max1;
		    pc /= (double) (max2 - max1);
                    if((max1-max2)==0) pc=0;
		}

//                if(pc<0 || pc>1) printf("Doh!! PC error!, %f\n", pc);

		tr = random();
		tr /= (double) RAND_MAX;

		if (tr > 1)
		    tr -= 1;
		/* test for no -> just use color 2 */
		/* write out the final pixel(s) */
		if (dither == 2)	/* complex */
		{
		    double newval, cerror;
		    int tv;
                                        
		    newval = pc + error[x / xpixsize];
		    newval = floor(newval + 0.5);
		    if (newval < 0)
			newval = 0;
		    if (newval > 1)
			newval = 1;
		    tv = newval;

		    cerror = pc + error[x / xpixsize] - tv;

		    //if(cerror>1) printf("%f -> %f -> %f\n",cerror, pc+error[x], error[x]);
		    nexterror[x / xpixsize] += cerror * 5 / 16;
		    error[x / xpixsize + 1] += cerror * 7 / 16;
		    nexterror[x / xpixsize + 1] += cerror * 1 / 16;
		    if (x != 0)
		    {
			nexterror[x / xpixsize - 1] += cerror * 3 / 16;
		    }
		    for (partpix = 0; partpix < xpixsize; partpix++)
			if (tv == 0)
			{
			    OutPixels[y][x + partpix] = maxc;
			} else
			{
			    OutPixels[y][x + partpix] = maxc2;
			}
		} else
		    /* simple */
		{
		    for (partpix = 0; partpix < xpixsize; partpix++)
			if ((((x / xpixsize) + y) & 1 == 1 && pc < 0.75) || pc < 0.25)
			    OutPixels[y][x + partpix] = maxc;
			else
			    OutPixels[y][x + partpix] = maxc2;

		}
	    }
	}
	free(error);
	free(nexterror);
    }
}
