/* Truevision Targa Import plugin
 * for WOW painter
 * (c) 1997, A Life in Hell & Warriors of the Wasteland
 */

#include <stdio.h>
#include <math.h>

int main(int argc, char **argv);
void putWord(int input, FILE * where);

int reds[16] =
{0x00, 0xff, 0xcc, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x88, 0xff, 0x44, 0x88, 0x88, 0x88, 0xcc};
int greens[16] =
{0x00, 0xff, 0x00, 0xff, 0x00, 0xcc, 0x00, 0xff, 0x88, 0x44, 0x88, 0x44, 0x88, 0xff, 0x88, 0xcc};
int blues[16] =
{0x00, 0xff, 0x00, 0xcc, 0xff, 0x00, 0xcc, 0x00, 0x00, 0x00, 0x88, 0x44, 0x88, 0x88, 0xff, 0xcc};
unsigned char *fid = "WoWPaint!!";
void convert_from_RGB();
int colors;

unsigned char RgbOut[3][2000][3200];
unsigned char OutPixels[2000][3200];

FILE *infile;
FILE *outfile;
int length;
int y;
int id;
int imagetype;
int cmaptype;
int x;
int xsize, ysize;
int lof(FILE * what);
int pm;


int main(int argc, char **argv)
{
    printf("Entered: %s\n", argv[1]);
    if (infile = fopen(argv[1], "rb"))
    {
	printf("%s opened succesfully!\n", argv[1]);
	outfile = fopen("res/middle", "wb");
	fprintf(outfile, fid);
	length = lof(infile);

	id = fgetc(infile);
	cmaptype = fgetc(infile);
	printf("Color map: %d\n", cmaptype);

	imagetype = fgetc(infile);
	printf("Image Type: %d\n", imagetype);
/* skip color map stuff */
	for (x = 0; x < 9; x++)
	    fgetc(infile);

	/* get xsize & ysize */
	xsize = fgetc(infile) + 256 * fgetc(infile);
	ysize = fgetc(infile) + 256 * fgetc(infile);

	printf("Length: %d\n", length);

	printf("X: %d Y: %d\n", xsize, ysize);
	pm = 3;

	if (cmaptype == 0 && imagetype == 2)
	{
	    int c;
	    for (x = 0; x < 45; x++)
		fgetc(infile);
	    /* decided that it definantly is a targa.
	     * show options to user!
	     */
	    for (y = 0; y < ysize; y++)
		for (x = 0; x < xsize; x++)
		{
		    RgbOut[1][y][x] = fgetc(infile);
		    RgbOut[0][y][x] = fgetc(infile);
		    RgbOut[2][y][x] = fgetc(infile);
		}


	    convert_from_RGB();

	    fputc('Y', outfile);


	    /* for the moment, set the targa as 320x200 ffli -later, more colors */

	    /* always 320x200 */
	    putWord(xsize, outfile);
	    putWord(ysize, outfile);

	    /* double pixel */
	    fputc('N', outfile);

	    /* FFLI */
	    fputc('F', outfile);

	    /* How ever big u want */
	    fputc('Y', outfile);

	    /* and the byte for whatever i forgot :P */
	    fputc('R', outfile);

	    /* is it h-interlace? */
	    fputc('N', outfile);

	    printf("1....");
	    for (y = 0; y < ysize; y++)
		for (x = 0; x < xsize; x++)
		    fputc(OutPixels[y][x], outfile);
	    printf("2....");

	    fclose(infile);
	    fclose(outfile);
	} else
	{
	    printf("Cant Load!\n");
	    fputc('N', outfile);
	    fclose(outfile);
	    fclose(infile);
	}
    } else
    {
	printf("Couldn't open file!! oops!!\n");
    }
    return 0;
}

void putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);

    fputc(input & 255, where);
}

int lof(FILE * what)
{
    fpos_t moo;
    fseek(what, 0, 2);
    fgetpos(what, &moo);
    fseek(what, 0, 0);
    return moo;
}

#include "rgbout.c"
