/* MCI Importer
 * for WoW Painter
 * (c) 1998, Warriors of the Wasteland
 * by A Life in Hell/WoW!
 * 
 * Yes, this is a quick/dirty hack on the gunpaint importer!
 */

#include <stdio.h>

int main(int argc, char **argv);
int lof(FILE * what);
void putWord(int input, FILE * where);
unsigned char map2colors(unsigned char thePix, int lyne, int row, int cols);
void read_ifli_pixels();
unsigned char *id = "WoWPaint!!";

unsigned char d800[0x800];
unsigned char colors[0x800];
unsigned char bits[0x4000];

unsigned char pixels[200][320];
unsigned char bg;
char inid[50];
int main(int argc, char **argv)
{
    FILE *infile;
    FILE *outfile;
    int start;
    int length;
    int x;
    int y;
    printf("MCI importer\n");
    if (infile = fopen(argv[1], "rb"))
    {
	printf("%s opened succesfully!\n", argv[1]);
	outfile = fopen("res/middle", "wb");
	fprintf(outfile, id);
	length = lof(infile);
	printf("Length: %d\n", length);
	start = fgetc(infile);
	start += (fgetc(infile) << 8);
	printf("Start Address: %d\n", start);
	if (start == 16384 && length == 25578)
	{
	    /* put as YES this is an FLI */
	    fputc('Y', outfile);

	    /* always 320x200 */
	    putWord(320, outfile);
	    putWord(200, outfile);

	    /* Not double-pixel */
	    fputc('N', outfile);

	    /* FLI's are 16 color */
	    fputc('F', outfile);

	    /* FLI's are single screen */
	    fputc('N', outfile);

	    /* and the byte for border :P */
	    fputc('R', outfile);

	    /* and interlace */
	    fputc('H', outfile);

/* even frame */
	    fseek(infile, 8192+2, 0);
	    /* next is the color plane */
		for (x = 0; x < 1024; x++)
		{
		    colors[x] = fgetc(infile);
		}
	    fseek(infile, 2, 0);            
	    /* and the first 8192 byte bit table */
	    for (x = 0; x < 0x1F4F; x++)
	    {
		bits[x] = fgetc(infile);
	    }
            
            fseek(infile,2+8192+1024+1000,0);
            bg=fgetc(infile);

	    /* first is a $d800 color map */
            fseek(infile,8192+2+1024,0);
	    for (x = 0; x < 1000; x++)
	    {
		d800[x] = fgetc(infile);
	    }	    

/* odd frame */
   		fseek(infile,16384+2+8192,0);
	    /* next is the 8 color planes */
		for (x = 0; x < 1024; x++)
		{
		    colors[x + 1000] = fgetc(infile);
		}
                
                fseek(infile,16384+2,0);
	    /* and the first 8192 byte bit table */
	    for (x = 0; x < 0x2000; x++)
	    {
		bits[x + 0x2000] = fgetc(infile);
	    }

	    /* first is a $d800 color map */
/*        for (x=0;x<1024;x++) */
/*        { */
/*                d800[x+1000]=fgetc(infile); */
/*        } */
	    for (x = 0; x < 1024; x++)
	    {
		d800[x + 1000] = d800[x];
	    }

	    read_ifli_pixels();
	    fwrite(pixels, 1, 64000, outfile);
	} else
	{
	    printf("Not a gun paint\n");
	}

	fclose(infile);
	fclose(outfile);
    } else
    {
	printf("Oops!!\n");
    }
    return 0;
}

int lof(FILE * what)
{
    fpos_t moo;
    fseek(what, 0, 2);
    fgetpos(what, &moo);
    fseek(what, 0, 0);
    return moo;
}


void putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);
    fputc(input & 255, where);
}



/* a modded version of koala filter's read_multicolor_pixels! */

void read_ifli_pixels()
{
    int rows;
    int cols;
    int lyn;
    int thisLyne;

    unsigned char this_pixel;
/* even pixels */
    for (rows = 0; rows < 25; rows++)
	for (cols = 0; cols < 40; cols++)
	    for (lyn = 0; lyn < 8; lyn++)
	    {
		int thiscolor;
		thiscolor = rows * 40 + cols;
		thisLyne = bits[(lyn + cols * 8) + (rows * 320)];

		this_pixel = thisLyne & 3;
		this_pixel = map2colors(this_pixel, lyn, rows, cols);
		pixels[lyn + rows * 8][cols * 8 + 6] = this_pixel;

		this_pixel = (thisLyne >> 2) & 3;
		this_pixel = map2colors(this_pixel, lyn, rows, cols);
		pixels[lyn + rows * 8][cols * 8 + 4] = this_pixel;

		this_pixel = (thisLyne >> 4) & 3;
		this_pixel = map2colors(this_pixel, lyn, rows, cols);
		pixels[lyn + rows * 8][cols * 8 + 2] = this_pixel;

		this_pixel = (thisLyne >> 6) & 3;
		this_pixel = map2colors(this_pixel, lyn, rows, cols);
		pixels[lyn + rows * 8][cols * 8] = this_pixel;
	    }
/* odd pixels */
    for (rows = 0; rows < 25; rows++)
	for (cols = 0; cols < 40; cols++)
	    for (lyn = 0; lyn < 8; lyn++)
	    {
		int thiscolor;
		thiscolor = rows * 40 + cols;
		thisLyne = bits[(lyn + cols * 8) + (rows * 320) + 0x2000];

		this_pixel = thisLyne & 3;
		this_pixel = map2colors(this_pixel, lyn, rows + 25, cols);
		pixels[lyn + rows * 8][cols * 8 + 7] = this_pixel;

		this_pixel = (thisLyne >> 2) & 3;
		this_pixel = map2colors(this_pixel, lyn, rows + 25, cols);
		pixels[lyn + rows * 8][cols * 8 + 5] = this_pixel;

		this_pixel = (thisLyne >> 4) & 3;
		this_pixel = map2colors(this_pixel, lyn, rows + 25, cols);
		pixels[lyn + rows * 8][cols * 8 + 3] = this_pixel;

		this_pixel = (thisLyne >> 6) & 3;
		this_pixel = map2colors(this_pixel, lyn, rows + 25, cols);
		pixels[lyn + rows * 8][cols * 8 + 1] = this_pixel;
	    }

}


unsigned char map2colors(unsigned char thePix, int lyne, int row, int cols)
{
    switch (thePix)
    {
    case 0:
	return bg;

    case 1:
	return (colors[row * 40 + cols] >> 4) & 15;
	return (int) 0;
    case 2:
	return colors[row * 40 + cols] & 15;
	return (int) 0;

    case 3:
	return d800[row * 40 + cols] & 15;
	return (int) 0;
    }

    return thePix;
}
