/* Generic Hires Import plugin
 * for WOW painter
 * (c) 1997, A Life in Hell & Warriors of the Wasteland
 */

#include <stdio.h>

int main(int argc, char **argv);
void putWord(int input, FILE * where);
void read_colors(int start, FILE * infile);
void read_hires_pixels(int start, FILE * infile);
unsigned char map2colors(unsigned char pixel, unsigned char c01);
void setup_format(int start, int length, int colors, int bitmap);
void depak(char *filename);

unsigned char *id = "WoWPaint!!";
int numFormats = 0;
FILE *infile;
FILE *outfile;
int start;
int file_length;
unsigned char colors[2000];
unsigned char pixels[200][320];
int x;
int lof(FILE * what);

struct
{
    int start;
    int length;
    int colors;
    int bitmap;
}
sub_format[20];
int format = 888;
int back = 0;
int main(int argc, char **argv)
{
    printf("Entered: %s\n", argv[1]);

    if (infile = fopen(argv[1], "rb"))
    {
	printf("%s opened succesfully!\n", argv[1]);
	outfile = fopen("res/middle", "wb");
	fprintf(outfile, id);
	file_length = lof(infile);
	start = fgetc(infile);
	start += (fgetc(infile) << 8);
	printf("Start Address: %d\n", start);
	/* get format */
	/* put as a "maybe" - a $4000 start addy is small info :P */
	setup_format(0, 9194, 8195, 10);		/* generic */
	printf("Checking file format\n");
	for (x = 0; x < numFormats; x++)
	{
	    if ((sub_format[x].start == 0 || sub_format[x].start == start) &&
		(sub_format[x].length == 0 || sub_format[x].length == file_length))
		format = x;
	}
	if (format == 888)
	{
	    /* try de-packing */
	    fclose(infile);
	    fclose(outfile);
	    depak(argv[1]);
	    infile = fopen("res/depak", "rb");
	    outfile = fopen("res/middle", "wb");
	    fprintf(outfile, id);
	    file_length = lof(infile);
	    start = fgetc(infile);
	    start += (fgetc(infile) << 8);
	    for (x = 0; x < numFormats; x++)
	    {
		if ((sub_format[x].start == 0 || sub_format[x].start == start) &&
		    (sub_format[x].length == 0 || sub_format[x].length == file_length))
		    format = x;
	    }
	}
	if (format != 888)
	{
	    fputc('Y', outfile);
            
	    /* always 320x200 */
	    putWord(320, outfile);
	    putWord(200, outfile);

	    /* not double-pixel */
	    fputc('N', outfile);

	    /* Hires */
	    fputc('H', outfile);

	    /* Koala's are single screen */
	    fputc('N', outfile);

	    /* and the byte for whatever i forgot :P */
	    fputc('R', outfile);

	    /* and interlace */
	    fputc('N', outfile);


	    /* read the color matix */
	    read_colors(sub_format[format].colors, infile);

	    /* Read the pixels in! */
	    read_hires_pixels(sub_format[format].bitmap, infile);

	    /* and dump em out */
	    fwrite(pixels, 1, 64000, outfile);

	    fclose(infile);
	    fclose(outfile);
	} else
	{
	    /* this is not a koala - move on! */
	    printf("Not a koala!\n");
	    fputc('N', outfile);
	    fclose(outfile);
	    fclose(infile);
	}
    } else
    {
	printf("Couldn't open file!! oops!!\n");
    }
    return 0;
}

void putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);

    fputc(input & 255, where);
}

void read_colors(int start, FILE * infile)
{
    int x;
    fseek(infile, start, 0);
    for (x = 0; x < 1000; x++)
    {
	colors[x] = fgetc(infile);
    }
}


/*
 * This will load c=64 bitmapped pixels from a file
 * (ie. Packed 8 per byte, in sets of 8 rows)
 * standardised routine, 'coz i dont wanna write this 
 * beastie 50 trillion times :P
 */
void read_hires_pixels(int start, FILE * infile)
{
    int rows;
    int cols;
    int lyn;
    int thisLyne;
    int bit;
    unsigned char this_pixel;
    fseek(infile, start, 0);
    for (rows = 0; rows < 25; rows++)
	for (cols = 0; cols < 40; cols++)
	    for (lyn = 0; lyn < 8; lyn++)
	    {
		int thiscolor;
		thiscolor = rows * 40 + cols;
		thisLyne = fgetc(infile);
                for(bit=0;bit<8;bit++)
                {
                	this_pixel=((thisLyne&(1<<bit))>>bit);
                        this_pixel=map2colors(this_pixel,colors[thiscolor]);
              		pixels[lyn + rows * 8][cols * 8 + (7-bit)] = this_pixel;
                }
	    }
}

unsigned char map2colors(unsigned char pixel, unsigned char c01)
{
    switch (pixel)
    {
    case 0:
	return (c01 >> 4) & 15;
    case 1:
	return (c01 & 15);
    }
    printf("oops!\n");
    return 4;
}

int lof(FILE * what)
{
    fpos_t moo;
    fseek(what, 0, 2);
    fgetpos(what, &moo);
    fseek(what, 0, 0);
    printf("Len: %d\n", moo);
    return moo;
}

void setup_format(int start, int length,int colors, int bitmap)
{
    /* koala painter */
    sub_format[numFormats].start = start;
    sub_format[numFormats].length = length;
    sub_format[numFormats].colors = colors;
    sub_format[numFormats].bitmap = bitmap;
    numFormats++;
}

void depak(char *filename)
{
    FILE *infile;
    FILE *outfile;
    int flen;
    int cbyte;
    int pbyte;
    int qbyte;
    int x;
    int y;
    if (infile = fopen(filename, "rb"))
    {
	outfile = fopen("res/depak", "wb");
	printf("opened! depacking...\n");
	flen = lof(infile);

	/* skip the start address. */
/*                fgetc(infile);
 * fgetc(infile); */
	for (x = 0; x < flen; x++)
	{
	    cbyte = fgetc(infile);
	    if (cbyte != 0xc2)
		fputc(cbyte, outfile);
	    else
	    {
		pbyte = fgetc(infile);
		x++;
		if (pbyte == 0)
		{
		    printf("DOH!!!!\n");
		} else
		{
		    qbyte = fgetc(infile);
		    x++;
		    for (y = 0; y < pbyte; y++)
			fputc(qbyte, outfile);
		}
	    }
	}
	fclose(infile);
	fclose(outfile);
    } else
    {
	printf("doh!\n");
    }
}
