/* FLI file importer
 * for WoW Painter
 * (c) 1997, Warriors of the Wasteland
 * by A Life in Hell/WoW!
 */

#include <stdio.h>

int main(int argc, char **argv);
int lof(FILE * what);
void putWord(int input, FILE * where);
unsigned char map2colors(unsigned char thePix, int lyne, int row, int cols);
void read_fli_pixels();
unsigned char *id = "WoWPaint!!";

unsigned char d800[0x400];
unsigned char colors[8][0x400];
unsigned char bits[0x2000];

unsigned char pixels[200][320];
unsigned char moose[200];

int main(int argc, char **argv)
{
    FILE *infile;
    FILE *outfile;
    int start;
    int length;
    int x;
    int y;
    printf("FLI importer\n");
    if (infile = fopen(argv[1], "rb"))
    {
	printf("%s opened succesfully!\n", argv[1]);
	outfile = fopen("res/middle", "wb");
	fprintf(outfile, id);
	length = lof(infile);
	printf("Length: %d\n", length);
	start = fgetc(infile);
	start += (fgetc(infile) << 8);
	printf("Start Address: %d\n", start);
	if (start == 15360 && length == 17409)
	{
	    /* put as YES this is an FLI */
	    fputc('Y', outfile);

	    /* always 320x200 */
	    putWord(320, outfile);
	    putWord(200, outfile);

	    /* always double-pixel */
	    fputc('Y', outfile);

	    /* FLI's are 16 color */
	    fputc('F', outfile);

	    /* FLI's are single screen */
	    fputc('N', outfile);

	    /* and the byte for whatever i forgot :P */
	    fputc('R', outfile);

	    /* and interlace */
	    fputc('N', outfile);


	    /* first is a $d800 color map */
	    for (x = 0; x < 0x400; x++)
	    {
		d800[x] = fgetc(infile);
	    }

	    /* next is the 8 color planes */
	    for (y = 0; y < 8; y++)
		for (x = 0; x < 0x400; x++)
		{
		    colors[y][x] = fgetc(infile);
		}


	    /* and the 8192 byte bit table */
	    for (x = 0; x < 0x2000; x++)
	    {
		bits[x] = fgetc(infile);
	    }
	    read_fli_pixels();
	    fwrite(pixels, 1, 64000, outfile);
	} else
	{
	    printf("Not a fli1!\n");
	}

	fclose(infile);
	fclose(outfile);
    } else
    {
	printf("\n\n\n\n\n\n\nOOps!!\n\n\n\n\n");
    }
    return 0;
}

int lof(FILE * what)
{
    fpos_t moo;
    fseek(what, 0, 2);
    fgetpos(what, &moo);
    fseek(what, 0, 0);
    return moo;
}


void putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);
    fputc(input & 255, where);
}



/* a modded version of koala filter's read_multicolor_pixels! */

void read_fli_pixels()
{
    int rows;
    int cols;
    int lyn;
    int thisLyne;

    unsigned char this_pixel;
    for (rows = 0; rows < 25; rows++)
	for (cols = 0; cols < 40; cols++)
	    for (lyn = 0; lyn < 8; lyn++)
	    {
		int thiscolor;
		thiscolor = rows * 40 + cols;

		thisLyne = bits[(lyn + cols * 8) + (rows * 320)];

		this_pixel = thisLyne & 3;
		this_pixel = map2colors(this_pixel, lyn, rows, cols);
		pixels[lyn + rows * 8][cols * 8 + 6] = this_pixel;
		pixels[lyn + rows * 8][cols * 8 + 7] = this_pixel;

		this_pixel = (thisLyne >> 2) & 3;
		this_pixel = map2colors(this_pixel, lyn, rows, cols);
		pixels[lyn + rows * 8][cols * 8 + 4] = this_pixel;
		pixels[lyn + rows * 8][cols * 8 + 5] = this_pixel;

		this_pixel = (thisLyne >> 4) & 3;
		this_pixel = map2colors(this_pixel, lyn, rows, cols);
		pixels[lyn + rows * 8][cols * 8 + 2] = this_pixel;
		pixels[lyn + rows * 8][cols * 8 + 3] = this_pixel;

		this_pixel = (thisLyne >> 6) & 3;
		this_pixel = map2colors(this_pixel, lyn, rows, cols);
		pixels[lyn + rows * 8][cols * 8] = this_pixel;
		pixels[lyn + rows * 8][cols * 8 + 1] = this_pixel;
	    }
}

unsigned char map2colors(unsigned char thePix, int lyne, int row, int cols)
{
    switch (thePix)
    {
    case 0:
	return (int) 0;
	return (d800[row * 40 + cols] >> 4) & 15;
    case 1:
	return (colors[lyne][row * 40 + cols] >> 4) & 15;
	return (int) 0;
    case 2:
	return colors[lyne][row * 40 + cols] & 15;
	return (int) 0;

    case 3:
	return d800[row * 40 + cols] & 15;
	return (int) 0;
    }

    return thePix;
}
