/* Drazlace Import plugin
 * for WOW painter
 * (c) 1997, A Life in Hell & Warriors of the Wasteland
 */

#include <stdio.h>

int main(int argc, char **argv);
void putWord(int input, FILE * where);
void read_colors(int start, FILE * infile);
void read_multicolor_pixels(int start, FILE * infile);
void read_d800(int start, FILE * infile);
void read_multicolor_pixels_odd(int start, FILE * infile);
unsigned char map2colors(unsigned char pixel, unsigned char c01, unsigned char c2);
unsigned char *id = "WoWPaint!!";

FILE *infile;
FILE *outfile;
int start;
int length;
unsigned char colors[2000];
unsigned char pixels[200][320];
int x;
int lof(FILE * what);

int main(int argc, char **argv)
{
    printf("Entered: %s\n", argv[1]);

    if (infile = fopen(argv[1], "rb"))
    {
	printf("%s opened succesfully!\n", argv[1]);
	outfile = fopen("res/middle", "wb");
	fprintf(outfile, id);
	length = lof(infile);
	start = fgetc(infile);
	start += (fgetc(infile) << 8);
	printf("Start Address: %d\n", start);
	if (length == 18242 && start == 22528)
	{
	    /* put as a "maybe" - a $4000 start addy is small info :P */
	    fputc('Y', outfile);

	    printf("Infile: %x", x);
	    /* always 320x200 */
	    putWord(320, outfile);
	    putWord(200, outfile);

	    /* always double-pixel */
	    fputc('Y', outfile);

	    /* Koala's are multicolor */
	    fputc('4', outfile);

	    /* Koala's are single screen */
	    fputc('N', outfile);

	    /* and the byte for whatever i forgot :P */
	    fputc('R', outfile);

	    /* and interlace */
	    fputc('H', outfile);


	    /* read the color matix */
	    read_d800(2, infile);
	    read_colors(1026, infile);

	    /* Read the pixels in! */
	    read_multicolor_pixels(2050, infile);

/*      read_colors(10242,infile); */
	    read_multicolor_pixels_odd(10242, infile);
	    /* and dump em out */
	    fwrite(pixels, 1, 64000, outfile);

	    fclose(infile);
	    fclose(outfile);
	} else
	{
	    /* this is not a koala - move on! */
	    printf("Not a koala!\n");
	    fputc('N', outfile);
	    fclose(outfile);
	    fclose(infile);
	}
    } else
    {
	printf("Couldn't open file!! oops!!\n");
    }
    return 0;
}

void putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);

    fputc(input & 255, where);
}

void read_colors(int start, FILE * infile)
{
    int x;
    fseek(infile, start, 0);
    for (x = 0; x < 1000; x++)
    {
	colors[x] = fgetc(infile);
    }
}
void read_d800(int start, FILE * infile)
{
    int x;
    fseek(infile, start, 0);
    for (x = 0; x < 1000; x++)
    {
	colors[x + 1000] = fgetc(infile);
    }
}


/*
 * This will load c=64 bitmapped pixels from a file
 * (ie. Packed 8 per byte, in sets of 8 rows)
 * standardised routine, 'coz i dont wanna write this 
 * beastie 50 trillion times :P
 */
void read_multicolor_pixels(int start, FILE * infile)
{
    int rows;
    int cols;
    int lyn;
    int thisLyne;

    unsigned char this_pixel;
    fseek(infile, start, 0);
    for (rows = 0; rows < 25; rows++)
	for (cols = 0; cols < 40; cols++)
	    for (lyn = 0; lyn < 8; lyn++)
	    {
		int thiscolor;
		thiscolor = rows * 40 + cols;

		thisLyne = fgetc(infile);
		this_pixel = thisLyne & 3;
		this_pixel = map2colors(this_pixel, colors[thiscolor], colors[thiscolor + 1000]);
		pixels[lyn + rows * 8][cols * 8 + 6] = this_pixel;
		this_pixel = (thisLyne >> 2) & 3;
		this_pixel = map2colors(this_pixel, colors[thiscolor], colors[thiscolor + 1000]);
		pixels[lyn + rows * 8][cols * 8 + 4] = this_pixel;
		this_pixel = (thisLyne >> 4) & 3;
		this_pixel = map2colors(this_pixel, colors[thiscolor], colors[thiscolor + 1000]);
		pixels[lyn + rows * 8][cols * 8 + 2] = this_pixel;
		this_pixel = (thisLyne >> 6) & 3;
		this_pixel = map2colors(this_pixel, colors[thiscolor], colors[thiscolor + 1000]);
		pixels[lyn + rows * 8][cols * 8] = this_pixel;
	    }
}

void read_multicolor_pixels_odd(int start, FILE * infile)
{
    int rows;
    int cols;
    int lyn;
    int thisLyne;

    unsigned char this_pixel;
    fseek(infile, start, 0);
    for (rows = 0; rows < 25; rows++)
	for (cols = 0; cols < 40; cols++)
	    for (lyn = 0; lyn < 8; lyn++)
	    {
		int thiscolor;
		thiscolor = rows * 40 + cols;

		thisLyne = fgetc(infile);
		this_pixel = thisLyne & 3;
		this_pixel = map2colors(this_pixel, colors[thiscolor], colors[thiscolor + 1000]);
		pixels[lyn + rows * 8][cols * 8 + 7] = this_pixel;
		this_pixel = (thisLyne >> 2) & 3;
		this_pixel = map2colors(this_pixel, colors[thiscolor], colors[thiscolor + 1000]);
		pixels[lyn + rows * 8][cols * 8 + 5] = this_pixel;
		this_pixel = (thisLyne >> 4) & 3;
		this_pixel = map2colors(this_pixel, colors[thiscolor], colors[thiscolor + 1000]);
		pixels[lyn + rows * 8][cols * 8 + 3] = this_pixel;
		this_pixel = (thisLyne >> 6) & 3;
		this_pixel = map2colors(this_pixel, colors[thiscolor], colors[thiscolor + 1000]);
		pixels[lyn + rows * 8][cols * 8 + 1] = this_pixel;
	    }
}


unsigned char map2colors(unsigned char pixel, unsigned char c01, unsigned char c2)
{
    switch (pixel)
    {
    case 0:
/*         return (c2>>4)&15; */
	return (int) 0;
    case 1:
	return (c01 >> 4) & 15;
    case 2:
	return (c01 & 15);
    case 3:
	return (c2 & 15);
    }
    printf("oops!\n");
    return 4;
}

int lof(FILE * what)
{
    fpos_t moo;
    fseek(what, 0, 2);
    fgetpos(what, &moo);
    fseek(what, 0, 0);
    printf("Len: %d\n", moo);
    return moo;
}
