/* FLI file importer
 * for WoW Painter
 * (c) 1997, Warriors of the Wasteland
 * by A Life in Hell/WoW!
 */

#include <stdio.h>

int main(int argc, char **argv);
int lof(FILE * what);
void putWord(int input, FILE * where);
void read_fli_pixels();

unsigned char *id = "WoWPaint!!";
unsigned char d800[0x800];
unsigned char colors[8][0x800];
unsigned char bitmap[0x4000];
unsigned char bg[400];
unsigned char pixels[400][320];

int main(int argc, char **argv)
{
    FILE *infile;
    FILE *outfile;
    int start;
    int length;
    int x;
    int y;
    printf("FLI importer\n");
    if (infile = fopen(argv[1], "rb"))
    {
	printf("%s opened succesfully!\n", argv[1]);
	outfile = fopen("res/middle", "wb");
	fprintf(outfile, id);
	length = lof(infile);
	printf("Length: %d\n", length);
	start = fgetc(infile);
	start += (fgetc(infile) << 8);
	printf("Start Address: %d\n", start);
	if (start == 15359 && length == 33795)
	{
	    /* put as YES this is an BFLI */
	    fputc('Y', outfile);

	    /* always 320x400 */
	    putWord(320, outfile);
	    putWord(400, outfile);

	    /* always double-pixel */
	    fputc('Y', outfile);

	    /* FLI's are 16 color */
	    fputc('F', outfile);

	    /* FLI's are single screen */
	    fputc('N', outfile);

	    /* and the byte for whatever i forgot :P */
	    fputc('R', outfile);

	    /* and interlace */
	    fputc('N', outfile);

	    /* Color mem is strange */
	    fread(d800, 1, 1024, infile);

	    /* 1st FLI color mem */
	    fread(colors[0], 1, 1000, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[1], 1, 1000, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[2], 1, 1000, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[3], 1, 1000, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[4], 1, 1000, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[5], 1, 1000, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[6], 1, 1000, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[7], 1, 1000, infile);
	    fread(bg, 1, 25, infile);

	    /* 1st gfx mem */
	    fread(bitmap, 1, 8000, infile);
	    fread(bg, 1, 191, infile);

	    /* 2nd FLI color mem */
	    fread(colors[0] + 1024, 1, 976, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[0] + 1000, 1, 24, infile);
	    fread(colors[1] + 1024, 1, 976, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[1] + 1000, 1, 24, infile);
	    fread(colors[2] + 1024, 1, 976, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[2] + 1000, 1, 24, infile);
	    fread(colors[3] + 1024, 1, 976, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[3] + 1000, 1, 24, infile);
	    fread(colors[4] + 1024, 1, 976, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[4] + 1000, 1, 24, infile);
	    fread(colors[5] + 1024, 1, 976, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[5] + 1000, 1, 24, infile);
	    fread(colors[6] + 1024, 1, 976, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[6] + 1000, 1, 24, infile);
	    fread(colors[7] + 1024, 1, 976, infile);
	    fread(bg, 1, 24, infile);
	    fread(colors[7] + 1000, 1, 24, infile);

	    /* 2nd gfx mem */
	    fread(bitmap + 8192, 1, 7808, infile);
	    fread(bg, 1, 192, infile);
	    fread(bitmap + 8000, 1, 192, infile);


	    read_fli_pixels();
	    fwrite(pixels, 1, 128000, outfile);
	} else
	{
	    printf("Not a bfli!\n");
	}

	fclose(infile);
	fclose(outfile);
    } else
    {
	printf("\n\n\n\n\n\n\nOOps!!\n\n\n\n\n");
    }
    return 0;

}

int lof(FILE * what)
{
    fpos_t moo;
    fseek(what, 0, 2);
    fgetpos(what, &moo);
    fseek(what, 0, 0);
    return moo;
}


void putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);
    fputc(input & 255, where);
}



/* a modded version of koala filter's read_multicolor_pixels! */

void read_fli_pixels()
{
    int x, y, ind, pos, bits, ysize = 400, xsize = 160;
    unsigned char a, b;
    const unsigned char bitmask[4] =
    {0xc0, 0x30, 0x0c, 0x03};
    const unsigned char bitshift[4] =
    {0x40, 0x10, 0x04, 0x01};
    for (y = 0; y < 400; y++)
	for (x = 0; x < 160; x++)
	{
	    ind = (x >> 2) + (y >> 3) * 40;	/* color memory index */
	    pos = (y & 7) + (x >> 2) * 8 + (y >> 3) * 320 - 8;	/* grafix memory byte */
	    bits = (x & 3);	/* bit numbers */


	    a = (bitmap[pos] & bitmask[bits]) / bitshift[bits];

	    if (x < 12)
	    {
		switch (a)
		{
		case 0:
		    b = 0;
		    break;
		case 1:
		    b = 15;
		    break;
		case 2:
		    b = 15;
		    break;
		case 3:
		    b = 9;
		    break;
		}
	    } else
	    {
		switch (a)
		{
		case 0:
		    b = 0;
		    break;
		case 1:
		    b = colors[y % 8][ind] / 16;
		    break;
		case 2:
		    b = colors[y % 8][ind] % 16;
		    break;
		case 3:
		    b = d800[(ind & 1023)] % 16;
		    break;
		}
	    }
	    pixels[y][x * 2] = b;
	    pixels[y][x * 2 + 1] = b;
	}

}
