/* Antialias Plugin for WOW Painter 1.00
 * (c) 1998, A Life in hell / WOW
 * Todo:  must re-write this to use malloc()........
 * Todo:  re-write pallate conversion (pc -> c64).
 */

#include <stdio.h>
int getWord(FILE * in);
void putWord(int input, FILE * where);
int x, y;
int xsize, ysize;
unsigned char InPixels[1000][1600];
unsigned char RgbPixels[3][1000][1600];
unsigned char RgbOut[3][1000][1600];
unsigned char OutPixels[1000][1600];
FILE *infile;
int reds[16] =
{0x00, 0xff, 0xcc, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x88, 0xff, 0x44, 0x88, 0x88, 0x88, 0xcc};
int greens[16] =
{0x00, 0xff, 0x00, 0xff, 0x00, 0xcc, 0x00, 0xff, 0x88, 0x44, 0x88, 0x44, 0x88, 0xff, 0x88, 0xcc};
int blues[16] =
{0x00, 0xff, 0x00, 0xcc, 0xff, 0x00, 0xcc, 0x00, 0x00, 0x00, 0x88, 0x44, 0x88, 0x88, 0xff, 0xcc};
int lev;
int main();
void convert_to_RGB();
void do_antialias();
void convert_from_RGB();

int main()
{
    printf("Anti-alias Plugin 1.00\n");
    /* get xsize,ysize */
    infile = fopen("res/middle", "rb");
    fseek(infile, 7, 0);
    xsize = getWord(infile);
    ysize = getWord(infile);
    printf("xsize=%d, ysize=%d\n", xsize, ysize);
    for (y = 0; y < ysize; y++)
	for (x = 0; x < xsize; x++)
	{
	    InPixels[y][x] = fgetc(infile);
	}
    fclose(infile);
    lev = 0;
    do
    {
	printf("\nEnter Level (must be odd.... 3 -> xsize/2-1\n");
	scanf("%d", &lev);
    }
    while ((lev & 1) == 0);
    convert_to_RGB();
    do_antialias();
    convert_from_RGB();
    /* write it out to the disk */
    infile = fopen("res/middle", "wb");
    fprintf(infile, "WOW-RGB");
    putWord(xsize, infile);
    putWord(ysize, infile);
    for (y = 0; y < ysize; y++)
	for (x = 0; x < xsize; x++)
	    fputc(OutPixels[y][x], infile);
    fclose(infile);
    x = getchar();
    return 0;
}

void convert_to_RGB()
{
    for (y = 0; y < ysize; y++)
	for (x = 0; x < xsize; x++)
	{
	    RgbPixels[0][y][x] = reds[InPixels[y][x]];
	    RgbPixels[1][y][x] = greens[InPixels[y][x]];
	    RgbPixels[2][y][x] = blues[InPixels[y][x]];
	}
}


void do_antialias()
{
    int cmp, stp;
    stp = (lev - 1) / 2;
/* obviously not ;) */
    for (y = stp; y < ysize - stp; y++)
    {
/*    printf("y=%d\n",y); */
	for (x = stp; x < xsize - stp; x++)
	{
	    for (cmp = 0; cmp < 3; cmp++)
	    {
		int ax, ay, tc = 0;
		float ms;
/*      RgbOut[cmp][y][x]=RgbPixels[cmp][y][x]; */
		for (ax = x - stp; ax <= x + stp; ax++)
		    for (ay = y - stp; ay <= y + stp; ay++)
			tc += RgbPixels[cmp][ay][ax];
		ms = tc;
		ms /= (float) (lev * lev);
		tc = ms;
		tc += .5;
/*           tc/=9; */
		RgbOut[cmp][y][x] = tc;
	    }
	}
    }
}

int getWord(FILE * in)
{
    int q;
    q = fgetc(in) << 8;
    q += fgetc(in);
    return q;
}

void putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);

    fputc(input & 255, where);
}

#include "rgbout.c"
