#include <stdio.h>
void putWord(int input, FILE * where);
int getWord(FILE * in);

char id[10];
FILE *infile;
FILE *outfile;
int xsize, ysize, y, x, p, bg = 5;
int mc1[256][256], mc2[256][256], bitmap[1024][256];
int main(int argc, char **argv)
{
    if (argc == 1)
    {
	printf("Koala paint Exporter\n"
	       "For use with the WOW C64 painter\n"
	       "Give it up, man ;)\n");
	return;
    }
    printf("\n\nKoala paint exporter 1.00\n");
    printf("Filename: %s\n", argv[1]);
    if (infile = fopen("res/middle", "rb"))
    {
	printf("Data Opened.\n");
	fgets(id, 7, infile);
	printf("File id: %s\n", id);
	xsize = getWord(infile);
	ysize = getWord(infile);

	printf("Size: %dx%d\n", xsize, ysize);
	if (ysize != 200 || xsize != 320)
	    printf("WARNING: The koala file format only supports 320x200 pics -> you piccy will be cropped to this size\n");

	outfile = fopen(argv[1], "wb");
	fputc(0, outfile);
	fputc(64, outfile);

	/* get bg color */
	bg = fgetc(infile);

	fseek(outfile, 8002, 0);

	for (y = 0; y < (ysize >> 3); y++)
	    for (x = 0; x < (xsize >> 3); x++)
	    {
		int p;
		p = fgetc(infile);
		if (y < 25 && x < 40)
		    fputc(p, outfile);
	    }
	printf("mc's done %d,%d\n", x, y);

	for (y = 0; y < (ysize >> 3); y++)
	    for (x = 0; x < (xsize >> 3); x++)
	    {
		if (y < 25 && x < 40)
		    fputc(fgetc(infile), outfile);
		else
		    fgetc(infile);
	    }
	printf("D800 done %d,%d\n", x, y);


	for (y = 0; y < ysize; y++)
	    for (x = 0; x < (xsize >> 3); x++)
		bitmap[y][x] = fgetc(infile);
	printf("bg==%d\n", bg);
	fputc(bg, outfile);

	fseek(outfile, 2, 0);

	/* write out bit plane #1 */
	for (y = 0; y < 25; y++)	/* row */
	    for (x = 0; x < 40; x++)	/* coloum */
		for (p = 0; p < 8; p++)		/* line */
		    fputc(bitmap[(y << 3) + p][x], outfile);
    } else
    {
	printf("DOH!\n");
    }
    return 0;
}

int getWord(FILE * in)
{
    int q;
    q = fgetc(in) << 8;
    q += fgetc(in);
    return q;
}

void putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);
    fputc(input & 255, where);
}
