/* Gunpaint File exporter 
 * By A Life in Hell
 * (c) 1997, Warriors of the Wasteland inc.
 */
#include <stdio.h>

int getWord(FILE * in);
void putWord(int input, FILE * where);
void put_plane(int which);

FILE *infile;
FILE *outfile;
int ysize;
int fli1[2][1024][40];
int fli2[2][1024][40];
int bg[1024];
int d800[1024][40];
unsigned char bitmaps[2][1024][40];
int x, y, p;

unsigned char id[10];
int main(int argc, char **argv)
{
    if (argc == 1)
    {
	printf("Gunpaint IFLI Exporter\n"
	       "For use with the WOW C64 painter\n"
	       "Give it up, man ;)\n");
	return;
    }
    printf("\n\nGunpaint IFLI exporter 1.00\n");
    printf("Filename: %s\n", argv[1]);
    if (infile = fopen("res/middle", "rb"))
    {
	printf("Data Opened.\n");
	fgets(id, 9, infile);
	printf("File id: %s\n", id);
	ysize = getWord(infile);
	printf("Lines: %d\n", ysize);
	if (ysize != 200)
	    printf("WARNING: The gunpaint file format only supports 200 line pics -> you piccy will be cropped to this size\n");

	/* read bg colors */
	for (y = 0; y < ysize; y++)
	    bg[y] = fgetc(infile);

	/* read d800 color */
	for (y = 0; y < (ysize >> 3); y++)
	    for (x = 0; x < 40; x++)
		d800[y][x] = fgetc(infile);

	printf("read d800 table\n");
	/* read fli color 1 */

	for (p = 0; p < 2; p++)
	{
	    for (y = 0; y < ysize; y++)
		for (x = 0; x < 40; x++)
		    fli1[p][y][x] = fgetc(infile);

	    for (y = 0; y < ysize; y++)
		for (x = 0; x < 40; x++)
		    fli2[p][y][x] = fgetc(infile);
	}
	printf("read fli color table\n");
	/* read the bitmaps */
	fread(bitmaps[0], 1, ysize * 40, infile);
	fread(bitmaps[1], 1, ysize * 40, infile);

	printf("Writing out File %s\n", argv[1]);
	outfile = fopen(argv[1], "wb");

	/* start address */
	fputc(0, outfile);
	fputc(64, outfile);


	put_plane(0);
	/* we are now at 0x4000+8000
	 * /* pad 192 bytes */
	for (x = 0; x < 15; x++)
	    fputc(0, outfile);
	for (x = 0; x < 177; x++)
	    fputc(bg[x], outfile);


	/* write out $d800 table */
	for (y = 0; y < 25; y++)
	    for (x = 0; x < 40; x++)
		fputc(d800[y][x], outfile);


	for (x = 0; x < 24; x++)
	    fputc(bg[x + 177], outfile);

	put_plane(1);
	fputc(0, outfile);

    } else
    {
	printf("\n\nDOH!! either i've fucked up, or u've tried to run this standalone ;)\n\n");
    }
    return 0;
}

int getWord(FILE * in)
{
    int q;
    q = fgetc(in) << 8;
    q += fgetc(in);
    return q;
}

void putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);
    fputc(input & 255, where);
}

void put_plane(int which)
{
    for (p = 0; p < 8; p++)	/* char line */
    {
	for (y = 0; y < 25; y++)	/* row */
	    for (x = 0; x < 40; x++)	/* col */
		fputc((fli1[which][(y << 3) + p][x] + (fli2[which][(y << 3) + p][x] << 4)), outfile);
	/* put gunpaint header here */
	fprintf(outfile, "GUNPAINT (JZ)           ");
    }

    /* write out bit plane #1 */
    for (y = 0; y < 25; y++)	/* row */
	for (x = 0; x < 40; x++)	/* coloum */
	    for (p = 0; p < 8; p++)	/* line */
		fputc(bitmaps[which][(y << 3) + p][x], outfile);
}
