/*
 * Teddy Painter 
 * (c) 1997-98, A Life in Hell.
 * E-mail: alih@wow64.org
 */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "replace.h"
#ifdef linuxp
#include <vga.h>
#include <vgamouse.h>
#include "linux.h"
#define eos 1
#endif

#ifdef xwin
#include "xwin.h"
#define eos 1
#endif

#ifdef dos
#include <allegro.h>
#include <sys/farptr.h>
#include "dos.h"
#define eos 1
#endif

#define true 1
#define false -1
#define boolean int
#define FILL_MAGIC 38

#define multicolor 0
#define MCI 1
#define FLI 2
#define IFLI 3
#define Hires 4
#define AFLI 5
#define none 6

typedef void guiProc(void);

/* Color Defs */
unsigned char reds[16] =
{0x00, 0xff, 0xcc, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0x88, 0xff, 0x44, 0x88, 0x88, 0x88, 0xcc};
unsigned char greens[16] =
{0x00, 0xff, 0x00, 0xff, 0x00, 0xcc, 0x00, 0xff, 0x88, 0x44, 0x88, 0x44, 0x88, 0xff, 0x88, 0xcc};
unsigned char blues[16] =
{0x00, 0xff, 0x00, 0xcc, 0xff, 0x00, 0xcc, 0x00, 0x00, 0x00, 0x88, 0x44, 0x88, 0x88, 0xff, 0xcc};

unsigned char mouse[2][8][8] =
{
    00, 00, 00, 00, 17, 00, 00, 00,
    00, 00, 00, 00, 17, 00, 00, 00,
    00, 00, 00, 00, 00, 00, 00, 00,
    00, 17, 17, 00, 00, 00, 17, 17,
    00, 00, 00, 00, 00, 00, 00, 00,
    00, 00, 00, 00, 17, 00, 00, 00,
    00, 00, 00, 00, 17, 00, 00, 00,
    00, 00, 00, 00, 00, 00, 00, 00,

    16, 16, 16, 16, 16, 16, 16, 16,
    16, 01, 01, 01, 01, 01, 01, 16,
    16, 01, 01, 01, 01, 01, 16, 00,
    16, 01, 01, 01, 01, 16, 00, 00,
    16, 01, 01, 01, 01, 01, 16, 00,
    16, 01, 16, 16, 01, 01, 01, 16,
    16, 16, 16, 00, 16, 01, 01, 16,
    16, 16, 00, 00, 00, 16, 16, 00
};
#define __ 38
unsigned char tools[8][16][16] =
{
    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,
    01, __, __, __, __, __, __, __, __, __, __, 07, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, 07, 07, 07, __, __, 01,
    01, __, __, __, __, __, __, __, __, 07, 07, 07, 07, 07, __, 01,
    01, __, __, __, __, __, __, __, 07, 07, 07, 07, 07, 07, __, 01,
    01, __, __, __, __, __, __, 07, 07, 07, 07, 07, 07, __, __, 01,
    01, __, __, __, __, __, 07, 07, 07, 07, 07, 07, __, __, __, 01,
    01, __, __, __, __, 07, 07, 07, 07, 07, 07, __, __, __, __, 01,
    01, __, __, __, 07, 07, 07, 07, 07, 07, __, __, __, __, __, 01,
    01, __, __, 00, 07, 07, 07, 07, 07, __, __, __, __, __, __, 01,
    01, __, 00, 00, 00, 07, 07, 07, __, __, __, __, __, __, __, 01,
    01, __, 00, 00, 00, 00, 07, __, __, __, __, __, __, __, __, 01,
    01, __, 00, 00, 00, 00, __, __, __, __, __, __, __, __, __, 01,
    01, __, 00, 00, 00, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,

    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, 01, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, 01, __, __, 00, 01,
    01, __, __, __, __, __, __, __, __, __, 01, __, __, 00, __, 01,
    01, __, __, __, __, __, __, __, __, 01, __, __, 00, __, __, 01,
    01, __, __, __, __, __, __, __, 01, __, __, 00, __, __, __, 01,
    01, __, __, __, __, __, __, 01, __, __, 00, __, __, __, __, 01,
    01, __, __, __, __, __, 01, __, __, 00, __, __, __, __, __, 01,
    01, __, __, __, __, 01, __, __, 00, __, __, __, __, __, __, 01,
    01, __, __, __, 01, __, __, 00, __, __, __, __, __, __, __, 01,
    01, __, __, 01, __, __, 00, __, __, __, __, __, __, __, __, 01,
    01, __, 01, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,

    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, 01, 01, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, 01, 01, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, 01, __, __, 01, __, __, __, __, __, 01,
    01, __, __, __, __, __, 01, __, __, 01, __, __, __, __, __, 01,
    01, __, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, __, 01,
    01, __, 01, 01, __, 01, __, __, __, __, 01, __, 01, 01, __, 01,
    01, __, __, __, 01, 01, __, __, __, __, 01, 01, __, __, __, 01,
    01, __, __, __, 01, __, __, 01, 01, __, __, 01, __, __, __, 01,
    01, __, __, 01, __, __, 01, __, __, 01, __, __, 01, __, __, 01,
    01, __, __, 01, 01, 01, __, __, __, __, 01, 01, 01, __, __, 01,
    01, __, 01, 01, __, __, __, __, __, __, __, __, 01, 01, __, 01,
    01, __, 01, __, __, __, __, __, __, __, __, __, __, 01, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,


    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,
    01, __, __, __, __, __, 01, 01, 01, 01, __, __, __, __, __, 01,
    01, __, __, __, 01, 01, __, __, __, __, 01, 01, __, __, __, 01,
    01, __, __, 01, __, __, __, __, 00, 00, 00, 00, 01, __, __, 01,
    01, __, 01, __, __, __, 00, 00, __, __, __, __, 00, 01, __, 01,
    01, __, 01, __, __, 00, __, __, __, __, __, __, __, 01, 00, 01,
    01, 01, __, __, 00, __, __, __, __, __, __, __, __, __, 01, 01,
    01, 01, __, __, 00, __, __, __, __, __, __, __, __, __, 01, 01,
    01, 01, __, 00, __, __, __, __, __, __, __, __, __, __, 01, 01,
    01, 01, __, 00, __, __, __, __, __, __, __, __, __, __, 01, 01,
    01, __, 01, 00, __, __, __, __, __, __, __, __, __, 01, __, 01,
    01, __, 01, 00, __, __, __, __, __, __, __, __, __, 01, __, 01,
    01, __, __, 01, 00, __, __, __, __, __, __, __, 01, __, __, 01,
    01, __, __, __, 01, 01, __, __, __, __, 01, 01, __, __, __, 01,
    01, __, __, __, __, 00, 01, 01, 01, 01, __, __, __, __, 00, 01,
    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,

    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, 01, __, __, __, __, __, __, 01, __, __, __, 01,
    01, __, __, 01, __, __, __, __, __, __, __, __, 01, __, __, 01,
    01, __, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, __, 01,
    01, __, __, 01, __, __, 00, __, __, __, __, __, 01, 00, __, 01,
    01, __, __, __, 01, 00, 00, 00, 00, 00, 00, 01, 00, 00, 00, 01,
    01, __, __, __, __, 00, __, __, __, __, __, __, __, 00, __, 01,
    01, __, __, __, __, __, 00, __, __, __, __, __, 00, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,

    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, 01, 01, 01, __, __, 01, __, __, 01, __, __, __, __, 01,
    01, __, 01, __, __, 01, __, 01, __, __, 01, __, __, __, __, 01,
    01, __, 01, __, 00, 00, 00, 01, __, 00, 01, __, 00, __, __, 01,
    01, __, 01, 01, 00, 01, __, 01, __, 00, 01, __, 00, __, __, 01,
    01, __, 01, __, 00, 01, __, 01, __, 00, 01, __, 00, __, __, 01,
    01, __, 01, __, 00, 01, __, 01, __, 00, 01, __, 00, __, __, 01,
    01, __, 01, __, 00, 01, __, 01, __, 00, 01, __, 00, __, __, 01,
    01, __, 01, __, 00, 01, __, 01, 01, 01, 01, 01, 01, 01, __, 01,
    01, __, __, __, 00, __, __, 00, __, 00, __, __, 00, __, __, 01,
    01, __, __, __, 00, __, __, 00, __, 00, 00, 00, 00, 00, 00, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,

    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,
    01, __, __, __, __, 01, 01, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, 01, 01, 01, 01, __, __, __, __, __, __, __, 01,
    01, __, __, 01, 01, 01, 01, 01, 01, __, __, __, __, __, __, 01,
    01, __, 01, 01, 01, 01, 01, __, 01, 01, __, __, __, __, __, 01,
    01, 01, 01, 01, 01, __, 01, 01, __, 01, __, __, __, __, __, 01,
    01, 01, 01, 01, 01, 01, 01, __, 01, __, __, 01, __, __, __, 01,
    01, __, 01, 01, 01, 01, 01, 01, __, 01, __, __, __, __, __, 01,
    01, __, __, 01, __, 01, __, 01, __, __, __, 01, __, __, __, 01,
    01, __, __, __, 01, __, 01, __, 01, __, __, __, __, __, __, 01,
    01, __, __, __, __, 01, __, 01, __, __, 01, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, 01, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, 01, __, __, __, 01, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,

    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, __, __, __, __, __, __, __, __, __, __, __, __, __, __, 01,
    01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01
};

int numPens = 16;
int color_order[256] =
{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
/*{0, 6, 9, 2, 11, 4, 8, 12, 10, 14, 5, 3, 15, 13, 7, 1}; */

int ptr = 0;
int offsx[2] =
{-4, 0};
int offsy[2] =
{-3, 0};
unsigned char colorbar[1280];

short xres;
short yres;

int gridx = 0;
int gridy = 0;
int gridcolor = 1;
int rgx, rgy;
int fillstep = 1;
int showMenu = 0;

typedef struct
{
    char text[100];
    int *flag;
    guiProc *proc;
}
menuItem;

typedef struct
{
    char title[20];
    int xpos;
    int xsize;
    int msize;
    menuItem items[20];
    int numItems;
}
menu;

unsigned char tc[16] =
{'|', 0, '/', 0, '-', 0, '\\', 0, '|', 0, '/', 0, '-', 0, '\\', 0};
int cc = 0;
typedef struct
{
    unsigned char name[100];
    unsigned char file[100];
}
plugin;

int numMenus = 0;
int c_menu = -1;
int vindex = -1;

menu theMenus[10];
menuItem *currentItem;
menu *menuFile;
menu *menuScreen;
menu *menuType;
menu *menuPicture;
menu *menuGrid;



int numImporters;
plugin theImporters[100];

int numIFLIexporters;
plugin theIFLIexporters[100];

int numFLIexporters;
plugin theFLIexporters[100];

int numAFLIexporters;
plugin theAFLIexporters[100];

int numHiresexporters;
plugin theHiresexporters[100];

int numMCexporters;
plugin theMCexporters[100];

int numMCIexporters;
plugin theMCIexporters[100];

/* Plugin Filter Types */
int numRGBPlugins;
plugin theRGBPlugins[100];

int isLoadable[100];
int isTheOne;
boolean fakeInter = false;
int ildir = 1;
int ilp = 0;
int vlp = 0;
int vtog = 0;
boolean extendedClr = false;
unsigned char *id = "WoWPaint!!";
typedef struct
{
    int xsize;
    int ysize;
    int type;
    boolean doublePix;
    boolean hinterlace;
    boolean vinterlace;
    boolean il3;
    unsigned char pixels[2000][3200];
    /*                 [10x200][10x320] */
}
c64pic;


typedef struct
{
    int xsize;
    int ysize;
    int xpos;
    int ypos;
    int numButtons;
    int numChecks;
    int numTextboxes;
    int textFocus;
    struct
    {
	int xpos;
	int ypos;
	char text[200];
	guiProc *buttonProc;
    }
    buttons[100];
    struct
    {
	int xpos;
	int ypos;
	char status;
	char text[200];
    }
    checks[100];
    char title[200];
    struct
    {
	int xpos;
	int ypos;
	int xsize;
	char text[200];
	char inbox[100];
    }
    textboxes[200];
    int numColorboxes;
    struct
    {
	int xpos;
	int ypos;
	int xsize;
	int ysize;
	int numColors;
	int colors[256];
    }
    colorboxes[200];
}
dlgBox;

dlgBox cod;
dlgBox newPic;
dlgBox dimension;
dlgBox changeRes;
dlgBox setType;
dlgBox save;
dlgBox xdouble;
dlgBox gradient;
dlgBox open_file;
dlgBox *currentDlg = NULL;

void *np_ok();
unsigned char myFont[256][16][8];
unsigned char double_buffer[768 * 2][1024];
unsigned char pic_calc[2][2000][3200];
int dirty = 1;
int dt = 1000;
int db = 0;
int dl = 1000;
int dr = 0;

int main(int argc, char **argv);
double rad_bound(double ang);
void wait_for_button();
void AFLI_save();
void AFLI_write();
void recheck_AFLI();
void check_AFLI();
void set_to_AFLI();
void convert_AFLI();
void Hires_save();
void Hires_write();
void recheck_hires();
void convert_hires();
void check_hires();
void edit_pal();
void load_colors();
void save_colors();
void doCorder();
void set8x8grid();
void set8x1grid();
void set1x1grid();
void set2x1grid();
void setnogrid();
void do_exit();
void open_it();
void do_open();
void addItem(menu * which, char *text, guiProc * where, int *theFlag);
menu *addMenu(char *name);
void toggle_ec();
void set_ec();
void unset_ec();
void do_crop();
void show_xdouble_dlg();
void show_dimension_dlg();
void show_set_type();
void show_res_dlg();
void toggleYinterlace();
void toggleHinterlace();
void do_save();
void zoom_in();
void zoom_out();
void do_new();
void toggle_doublePix();
void set_doublePix();
void unset_doublePix();
void toggleScroll();
void doGradient();
void doDimension();
void doSetType(void);
void doXdouble(void);
void doChangeRes(void);
void set320x200(void);
void set376x282(void);
void set320x400(void);
void clear_buffer(void);
void set_text(void);
void set_pal(void);
void load_pic(char *filename);
void draw_screen(void);
void process_scroll(void);
void left_button();
void process_menu(void);
void set_pixel(int x, int y, int c);
void set_pixel_checked(int x, int y, int c);
void check_multicolor(int x, int y, int c);
void check_FLI(int x, int y, int c);
void setupMenus();
void textOut(char *inString, short xp, short yp);
void menu_click();
void set640x480();
void getPlugs();
void loadBitmap(FILE * infile);
int getWord(FILE * in);
void lyne(int a, int b, int c, int d, int col);
int isgn(int v);
void setHinterlace();
void unsetHinterlace();
void setYinterlace();
void unsetYinterlace();
void draw_dlg();
void wow_window(int x, int y, int xsize, int ysize);
void titleBar(int x, int y, int xsize, char *title);
void button(int x, int y, char *title);
void dialog_click();
void setborder(int c);
void set_to_FLI();
void setfli();
void unsetfli();
void set_mc();
void unset_mc();
void convert_FLI();
void convert_multicolor();
void new_dlg(dlgBox * what);
void setup_dlg();
void dlg_button_click(int button);
void new_check(int xpos, int ypos, char text[100], dlgBox * what);
void draw_check(int x, int y, char *text, char status);
void dlg_check_click(int button);
void new_text(int xpos, int ypos, int xsize, char text[100], dlgBox * what);
void draw_text(int x, int y, int xsize, char *title, char *inbox, char hasFocus);
void clear_current_checks();
void load_myFont();
int lsgn(int v);
void handle_keys(int x);
void add2str(char *what, char newc);
void new_pic();
void set_type(int type);
void check_FLI(int xp, int yp, int c);
void recheck_FLI(int xp, int yp);
void xorlyne(int a, int b, int c, int d, int col);
void checkpixel(int x, int y, int c);
void lynec(int a, int b, int c, int d, int col);
void convert_IFLI();
void set_to_IFLI();
void convert_MCI();
void check_IFLI(int xp, int yp, int c);
void check_MCI(int x, int y, int c);
void recheck_MCI(int x8, int y8);
void recheck_IFLI(int xp, int yp);
void solidfill(int x, int y, int c);
void linefill(int x, int y, int c);
void checkline(int x, int yp, int c, int oc, int *filyesup, int *filyesdn);
int checkdown(int xp, int *yp, int c, int oc, int *fillyesup, int *fillyesdn);
int checkup(int xp, int *yp, int c, int oc, int *fillyesup, int *fillyesdn);
int get_pixel(int x, int y);
void IFLI_save();
void FLI_save();
void save_file();
void putWord(int input, FILE * where);
void IFLI_write();
int plugin_get(plugin * what, char *where);
int get_num();
void MC_save();
void MC_write();
void do_plugin(int nump, plugin * saver, char *plugdir);
void do_plugin_nofile(int nump, plugin * saver, char *plugdir);
void MCI_write();
void FLI_write();
void draw_circle(int xp, int yp, int xrad, int yrad);
void std_circle(int xp, int yp, int xrad, int yrad);
void crop(int x1, int y1, int x2, int y2);
void MCI_save();
void xsquash();
void xstretch();
void call_filter();
void rgb_write();
void rgb_read();
void new_colorbox(int xpos, int ypos, int xsize, int ysize, dlgBox * what);
void colorbox(int num);
void add2cbox(dlgBox * what, int barnum, int cnum);
void colorbox_click(int which, int wherex, int wherey);
void rem_from_cbox(dlgBox * what, int which, int color);
void grad_fill(int x1, int y1, int x2, int y2);
void set_pixel_sized(int x, int y, int c);
void set_pixel_sized_nocheck(int x, int y, int c);
void check_pic();
int getcolor(int c1, int c2, int c3, int c4, int c2r);
void recheck_multicolor(int x8, int y8);
void init_pic(int xs, int ys, int mode);
double dsgn(double v);

c64pic thePixels;

int oxscroll, xscroll = 0;
int oyscroll, yscroll = 0;
int vtop = 0, vleft = 0;
int ypan = 0, xpan = 0;
boolean doscroll = true;

int mousex = 0;
int mousey = 0;
int mouseb = 0;

int pencolor = 0;
int realpencolor = 1;
int realpencolor2 = 1;
int pensize = 1;

int oldx;
int oldy;
int oldb;
int dragx = 0;
int dragy = 0;

#define scroller  20
int xzoom = 0;
int yzoom = 0;

/* Tool Subsystem */
#define freehand_tool 0
#define line_tool 1
#define line_strip 2
#define circle_tool 3
#define line_fill 4
#define solid_fill 5
#define gradient_fill 6

int tool = freehand_tool;
int tlon = false;
int tlx = 0;
int tly = 0;

/* gradient filling parameters */
int numColors;
int gradColors[256];

/* FLI editing parameters */
int flibg[1023];
int fli1[1023][40];
int fli2[1023][40];
int colortab[255][40];

/* second set for IFLI */
int fli1i[1023][40];
int fli2i[1023][40];


/* Multicolor editing parameters */
int bg;
int mc[2][256][256];
int mcd800[256][256];
int alihtrace = 0;
int mci[2][256][256];

double cs = 0;
int oldmode;
int ozoom;
int ogrid;

int quit = 0;

int main(int argc, char **argv)
{
    int x;
    os_init;
    getPlugs();
    load_colors();
    printf("\n\nTeddy Painter\n"
	   "(c) 1998, A Life in Hell.\n"
	   "All rights Preserved, Jellied, and Jammed!\n"
	   "Press the any key :P\n");

    thePixels.xsize = 320;
    thePixels.ysize = 200;
    do
    {
	x = getkey();
    }
    while (x == 0);
    printf("%d\n", x);
    setupMenus();
    setup_dlg();
    if (argc > 1)
	load_pic(argv[1]);
    else
	init_pic(320, 200, multicolor);

    set320x200();
    x = init_mouse;
    clear_buffer();
    load_myFont();
    draw_screen();
    blitIt;
    setpal(16, 0, 0, 0);
    thePixels.type = none;

    do
    {
	draw_screen();
	sync;
	blitIt;
	cc += 2;
	cc = cc & 15;
	mousex = get_mousex;
	mousey = get_mousey;
	mouseb = get_mouseb;
	switch (mouseb)
	{
	case left_mouse:
	    if (currentDlg == NULL)
	    {
		left_button();
	    } else
		dialog_click();
	    showMenu = 0;
	    c_menu = -1;
	    vindex = -1;
	    break;
	case left_mouse + right_mouse:
	    if (mouseb != oldb)
		menu_click();
	case right_mouse:
	    showMenu = 1;
	    oldx = mousex;
	    oldy = mousey;
	    oyscroll = yscroll;
	    oxscroll = xscroll;
	    tlon = false;
	    break;
	case 0:
	    oldx = mousex;
	    oldy = mousey;
	    oyscroll = yscroll;
	    oxscroll = xscroll;
	    showMenu = 0;
	    c_menu = -1;
	    vindex = -1;
	    break;
	default:
	}
	if (showMenu == 1)
	    process_menu();
	else if (doscroll != false)
	    process_scroll();

	x = getkey();
	if (x != 0)
	{
	    handle_keys(x);
	}
	update_mouse;
	oldb = mouseb;
    }
    while (quit == 0);
    save_colors();
    set_text();
    close_mouse;
    os_exit;
    printf("Later!\n");
    return 0;
}

void handle_keys(int x)
{
    if (currentDlg != NULL)
	if (currentDlg->numTextboxes != 0)
	{
	    add2str(currentDlg->textboxes[currentDlg->textFocus].inbox, x);
	}
    if (currentDlg == NULL)
    {
	/* process shortcut keys */
	switch (x)
	{
	case '1':
	    tool = freehand_tool;
	    break;
	case '2':
	    tool = line_tool;
	    break;
	case '3':
	    tool = line_strip;
	    break;
	case '4':
	    tool = circle_tool;
	    break;
	case '5':
	    tool = line_fill;
	    break;
	case '6':
	    tool = solid_fill;
	    break;
	case '7':
	    new_dlg(&gradient);
	    break;
	case 'p':
	    pencolor = FILL_MAGIC;
	    realpencolor = FILL_MAGIC;
	    break;
	case '[':
	    realpencolor--;
	    pencolor = color_order[realpencolor] + 16 * color_order[realpencolor2];
	    break;
	case ']':
	    realpencolor++;
	    pencolor = color_order[realpencolor] + 16 * color_order[realpencolor2];
	    break;

	case '+':
	    pensize++;
	    break;
	case '-':
	    pensize--;
	    break;
	case '*':
	    gridcolor++;
	    dirty = 1;
	    dt = 100;
	    db = 0;
	    dl = 100;
	    dr = 0;
	    break;
	case '/':
	    gridcolor--;
	    dirty = 1;
	    dt = 100;
	    db = 0;
	    dl = 100;
	    dr = 0;
	    break;
	case 'o':
	    new_dlg(&cod);
	    break;
	}
    }
}

void edit_pal()
{
   new_dlg(&cod);
}

void add2str(char *what, char newc)
{
    int c;
    if (newc == backspace)
    {
	for (c = 0; what[c] != 0; c++);
	what[c - 1] = 0;
    } else if (newc == tab)
    {
	currentDlg->textFocus++;
	if (currentDlg->textFocus >= currentDlg->numTextboxes)
	    currentDlg->textFocus = 0;
    } else
    {
	for (c = 0; what[c] != 0; c++);
	what[c] = newc;
	what[c + 1] = 0;
/*      set_text();
 * printf("%d\n",newc);
 * set320x200(); */
    }
}
void
 new_button(int xpos, int ypos, char text[100], dlgBox * what, guiProc * where)
{
    what->buttons[what->numButtons].xpos = xpos;
    what->buttons[what->numButtons].ypos = ypos;
    what->buttons[what->numButtons].buttonProc = where;
    strcpy(what->buttons[what->numButtons].text, text);
    what->numButtons++;
}

void
 new_text(int xpos, int ypos, int xsize, char text[100], dlgBox * what)
{
    what->textboxes[what->numTextboxes].xpos = xpos;
    what->textboxes[what->numTextboxes].ypos = ypos;
    what->textboxes[what->numTextboxes].xsize = xsize;
    strcpy(what->textboxes[what->numTextboxes].text, text);
    what->numTextboxes++;
}

void
 new_check(int xpos, int ypos, char text[100], dlgBox * what)
{
    what->checks[what->numChecks].xpos = xpos;
    what->checks[what->numChecks].ypos = ypos;
    strcpy(what->checks[what->numChecks].text, text);
    what->checks[what->numChecks].status = false;
    what->numChecks++;
}

/* Always Remeber:  for each dialog box, start with 
 * DIALOGBOX.numButtons=0!!!!! 
 * The program WILL DIE otherwise!!!
 */
void
 setup_dlg()
{
    int x;
    /* Set up new picture Dialog Box */
    newPic.numButtons = 0;
    newPic.numChecks = 0;
    newPic.numTextboxes = 0;
    newPic.xsize = 240;
    newPic.ysize = 160;
    newPic.numColorboxes = 0;
    strcpy(newPic.title, "New Picture");

    new_button(165, 125, "Okay", &newPic, &new_pic);
    new_button(90, 125, "Cancel", &newPic, NULL);

    new_check(10, 20, "MC", &newPic);
    new_check(10, 40, "MCI", &newPic);
    new_check(10, 60, "FLI", &newPic);
    new_check(10, 80, "IFLI", &newPic);
    new_check(10,100, "Hires", &newPic);    
    new_check(10,120, "AFLI", &newPic);    
    new_check(10,140, "none", &newPic);    
    
    newPic.checks[0].status = true;

    new_text(150, 20, 80, "X Size", &newPic);
    new_text(150, 45, 80, "Y Size", &newPic);



    /* setup change resolution box */
    changeRes.numButtons = 0;
    changeRes.numChecks = 0;
    changeRes.numTextboxes = 0;
    changeRes.xsize = 200;
    changeRes.ysize = 90;
    changeRes.numColorboxes = 0;
    strcpy(changeRes.title, "Set Res");

    new_check(10, 20, "320x200", &changeRes);
    new_check(10, 40, "320x400", &changeRes);
    new_check(110, 20, "372x284", &changeRes);
    new_check(110, 40, "640x480", &changeRes);
    changeRes.checks[0].status = true;
    new_button(15, 65, "Okay", &changeRes, &doChangeRes);
    new_button(105, 65, "Cancel", &changeRes, NULL);




    /* setup change resolution box */
    xdouble.numButtons = 0;
    xdouble.numChecks = 0;
    xdouble.numTextboxes = 0;
    xdouble.xsize = 100;
    xdouble.ysize = 110;
    xdouble.numColorboxes = 0;

    strcpy(xdouble.title, "Double X");

    new_check(10, 20, "By Expand", &xdouble);
    new_check(10, 40, "By Squash", &xdouble);
    xdouble.checks[0].status = true;
    new_button(10, 60, "Okay", &xdouble, &doXdouble);
    new_button(10, 85, "Cancel", &xdouble, NULL);

    /* Ty[e change resolution box */
    setType.numButtons = 0;
    setType.numChecks = 0;
    setType.numTextboxes = 0;
    setType.xsize = 200;
    setType.ysize = 130;
    setType.numColorboxes = 0;

    strcpy(setType.title, "Image Properties");

    new_check(10, 20, "MC", &setType);
    new_check(10, 40, "MCI", &setType);    
    new_check(110, 20, "FLI", &setType);
    new_check(110, 40, "IFLI", &setType);
    new_check(10, 60, "Hires", &setType);    
    new_check(110, 60, "No Limit", &setType);
    new_check(10,80,"AFLI",&setType);
    
    setType.checks[thePixels.type].status = true;
    new_button(15, 105, "Okay", &setType, &doSetType);
    new_button(105, 105, "Cancel", &setType, NULL);

    /* setup resize Dialog Box */
    dimension.numButtons = 0;
    dimension.numChecks = 0;
    dimension.numTextboxes = 0;
    dimension.xsize = 240;
    dimension.ysize = 100;
    dimension.numColorboxes = 0;

    strcpy(dimension.title, "Crop Picture");
    new_button(165, 75, "Okay", &dimension, &doDimension);
    new_button(90, 75, "Cancel", &dimension, NULL);
    new_text(50, 20, 80, "X Size", &dimension);
    new_text(50, 45, 80, "Y Size", &dimension);


/* save */
    save.numButtons = 0;
    save.numChecks = 0;
    save.numTextboxes = 0;
    save.numColorboxes = 0;
    strcpy(save.title, "Save Picture");
    save.xsize = 240;
    save.ysize = 120;

    new_text(70, 20, 160, "Filename", &save);

    new_check(10, 50, "MC", &save);
    new_check(55, 50, "MCI", &save);
    new_check(100, 50, "FLI", &save);
    new_check(145, 50, "IFLI", &save);
    new_check(190, 50, "Hres", &save);
    
    new_check(10, 70, "AFLI", &save);
    new_check(55, 70, "none", &save);
/*    new_check(100, 70, "FLI", &save);
    new_check(145, 70, "IFLI", &save);
    new_check(190, 70, "Hres", &save);    */

    new_button(165, 95, "Okay", &save, &save_file);
    new_button(90, 95, "Cancel", &save, NULL);

/* open */
    open_file.numButtons = 0;
    open_file.numChecks = 0;
    open_file.numTextboxes = 0;
    open_file.numColorboxes = 0;
    strcpy(open_file.title, "Open Picture");
    open_file.xsize = 240;
    open_file.ysize = 100;

    new_text(70, 20, 160, "Filename", &open_file);

    new_button(165, 75, "Okay", &open_file, &open_it);
    new_button(90, 75, "Cancel", &open_file, NULL);


/* seup gradient fill */
    gradient.numButtons = 0;
    gradient.numChecks = 0;
    gradient.numTextboxes = 0;
    gradient.xsize = 240;
    gradient.ysize = 100;
    gradient.numColorboxes = 0;
    strcpy(gradient.title, "Setup Gradient");
    new_button(165, 75, "Okay", &gradient, doGradient);
    new_colorbox(10, 20, 220, 20, &gradient);
    new_colorbox(10, 50, 220, 20, &gradient);
    /* add color to box #2 */
    for (x = 0; x < 16; x++)
	add2cbox(&gradient, 1, x);


/* setup Color Box */
    cod.numButtons = 0;
    cod.numChecks = 0;
    cod.numTextboxes = 0;
    cod.xsize = 240;
    cod.ysize = 100;
    cod.numColorboxes = 0;
    strcpy(cod.title, "Setup Colors");
    new_button(165, 75, "Okay", &cod, doCorder);
    new_colorbox(10, 20, 220, 20, &cod);
    new_colorbox(10, 50, 220, 20, &cod);

    /* add color to box #1 */
    for (x = 0; x < numPens; x++)
	add2cbox(&cod, 0, color_order[x]);

    /* add color to box #2 */
    for (x = 0; x < 16; x++)
	add2cbox(&cod, 1, x);


}

void doCorder()
{
    int x;
    numPens = currentDlg->colorboxes[0].numColors;
    for (x = 0; x < numPens; x++)
	color_order[x] = currentDlg->colorboxes[0].colors[x];
/*   printf("Pens now: %d\n",numPens); */
    set320x200();
}

void save_colors()
{
    FILE *cini;
    int x;
    if (cini = fopen("colors", "wb"))
    {
	fwrite(&numPens, 1, sizeof(numPens), cini);
	for (x = 0; x < numPens; x++)
	    fputc(color_order[x], cini);
    } else
    {
	printf("Couldn't write config out!!\nD'oh!\n");
    }


}

void load_colors()
{
    FILE *cini;
    int x;
    if (cini = fopen("colors", "rb"))
    {
	fread(&numPens, 1, sizeof(numPens), cini);
	for (x = 0; x < numPens; x++)
	    color_order[x] = fgetc(cini);
    } else
    {
	printf("Couldn't read config!!\nUsing defaults...\n");
    }
    pencolor = color_order[realpencolor] + 16 * color_order[realpencolor2];
}

void
 open_it()
{
    close_mouse;
    set_text();
    load_pic(currentDlg->textboxes[0].inbox);
/*   printf("%s\n",currentDlg->textboxes[0].text); */
    set320x200();
    init_mouse;
}

void
 add2cbox(dlgBox * what, int barnum, int cnum)
{
    what->colorboxes[barnum].colors[what->colorboxes[barnum].numColors] = cnum;
    what->colorboxes[barnum].numColors++;
}

void
 new_colorbox(int xpos, int ypos, int xsize, int ysize, dlgBox * what)
{
    what->colorboxes[what->numColorboxes].xpos = xpos;
    what->colorboxes[what->numColorboxes].ypos = ypos;
    what->colorboxes[what->numColorboxes].xsize = xsize;
    what->colorboxes[what->numColorboxes].ysize = ysize;
    what->colorboxes[what->numColorboxes].numColors = 0;
    what->numColorboxes++;
}

void
 draw_dlg()
{
    if (currentDlg != NULL)
    {
	int x;
	wow_window(currentDlg->xpos, currentDlg->ypos, currentDlg->xsize, currentDlg->ysize);
	titleBar(currentDlg->xpos, currentDlg->ypos, currentDlg->xsize, currentDlg->title);
	for (x = 0; x < currentDlg->numButtons; x++)
	{
	    button(currentDlg->buttons[x].xpos + currentDlg->xpos,
		   currentDlg->buttons[x].ypos + currentDlg->ypos,
		   currentDlg->buttons[x].text);
	}

	for (x = 0; x < currentDlg->numColorboxes; x++)
	{
	    colorbox(x);
	}
	for (x = 0; x < currentDlg->numTextboxes; x++)
	{
	    int thisstate;
	    if (currentDlg->textFocus == x)
		thisstate = true;
	    else
		thisstate = false;
	    draw_text(currentDlg->textboxes[x].xpos + currentDlg->xpos,
		      currentDlg->textboxes[x].ypos + currentDlg->ypos,
		      currentDlg->textboxes[x].xsize, currentDlg->textboxes[x].text, currentDlg->textboxes[x].inbox, thisstate);
	}
	for (x = 0; x < currentDlg->numChecks; x++)
	{
	    draw_check(currentDlg->checks[x].xpos + currentDlg->xpos,
		       currentDlg->checks[x].ypos + currentDlg->ypos,
	       currentDlg->checks[x].text, currentDlg->checks[x].status);
	}
    }
}


void
 new_dlg(dlgBox * what)
{
    int xp, yp;
    currentDlg = what;
    xp = xres / 2;
    xp -= (currentDlg->xsize / 2);
    yp = yres / 2;
    yp -= (currentDlg->ysize / 2);
    currentDlg->xpos = xp;
    currentDlg->ypos = yp;
    currentDlg->textFocus = 0;
    for (xp = 0; xp < currentDlg->numTextboxes; xp++)
	currentDlg->textboxes[xp].inbox[0] = 0;
}

void
 doChangeRes()
{
    if (currentDlg->checks[0].status == true)
	set320x200();
    if (currentDlg->checks[1].status == true)
	set320x400();
    if (currentDlg->checks[1].status == true)
	set376x282();
    if (currentDlg->checks[3].status == true)
	set640x480();
    return;
}

void
 doXdouble()
{
    if (currentDlg->checks[0].status == true)
	xstretch();
    else
	xsquash();
    return;
}

void
 doSetType()
{
    if (currentDlg->checks[0].status == true)
	set_type(multicolor);
    if (currentDlg->checks[1].status == true)
	set_type(MCI);
    if (currentDlg->checks[2].status == true)
	set_type(FLI);
    if (currentDlg->checks[3].status == true)
	set_type(IFLI);        
    if (currentDlg->checks[4].status == true)
	set_type(Hires);        
    if (currentDlg->checks[5].status == true)
	set_type(none);        
    if (currentDlg->checks[6].status == true)
	set_type(AFLI);    
}

void
 doGradient()
{
    int x;
    numColors = currentDlg->colorboxes[0].numColors;
    for (x = 0; x < numColors; x++)
	gradColors[x] = currentDlg->colorboxes[0].colors[x];
    tool = gradient_fill;
    currentDlg = NULL;

}

void
 doDimension()
{
    int xs, ys;
    sscanf(currentDlg->textboxes[0].inbox, "%d", &xs);
    sscanf(currentDlg->textboxes[1].inbox, "%d", &ys);
    crop(xscroll, yscroll, xscroll + xs, yscroll + ys);
}
void
 dlg_button_click(int button)
{
    dt = 100;
    db = 0;
    dl = 100;
    dr = 0;
    dirty = 1;
    if (currentDlg->buttons[button].buttonProc != NULL)
    {
	currentDlg->buttons[button].buttonProc();
    }
    currentDlg = NULL;
    return;
}

void
 xstretch()
{
    int x, y;
    thePixels.xsize *= 2;
    for (y = 0; y < thePixels.ysize; y++)
	for (x = thePixels.xsize; x > 0; x--)
	    thePixels.pixels[y][x] = thePixels.pixels[y][x >> 1];
    check_pic();
}

void
 xsquash()
{
    int x, y;
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < thePixels.xsize; x += 2)
	    thePixels.pixels[y][x + 1] = thePixels.pixels[y][x];
    check_pic();
}

void
 use_filter()
{

    close_mouse;
    set_text();
    printf("Image Filter Plugin System\n");
    clear_screen();
    rgb_write();
    /* put RGB-Write here */
    do_plugin_nofile(numRGBPlugins, theRGBPlugins, "filters");
    rgb_read();
    clear_screen();
    set320x200();
    init_mouse;

    dr = db = 0;
    dt = dl = 10000;
    dirty = 1;
}

void
 rgb_read()
{
    int x, y;
    FILE *infile;
    infile = fopen("res/middle", "rb");
    fseek(infile, 7, 0);
    thePixels.xsize = getWord(infile);
    thePixels.ysize = getWord(infile);
    for (y = 0; y < thePixels.ysize; y++)
    {
	for (x = 0; x < thePixels.xsize; x++)
	    thePixels.pixels[y][x] = fgetc(infile);
    }
    fclose(infile);
}

void
 rgb_write()
{
    int x, y;
    FILE *outfile;
    outfile = fopen("res/middle", "wb");
    fprintf(outfile, "WOW-RGB");
    putWord(thePixels.xsize, outfile);
    putWord(thePixels.ysize, outfile);
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < thePixels.xsize; x++)
	    fputc(thePixels.pixels[y][x], outfile);
    fclose(outfile);
}

void
 save_file()
{
    int x = 0;
    close_mouse;
    set_text();
    clear_screen();
    printf("Saving....\n");
    printf("Save File: %s\n", currentDlg->textboxes[0].inbox);

    if (currentDlg->checks[0].status == true)
    {
	MC_save();
    }
    if (currentDlg->checks[1].status == true)
    {
	MCI_save();
    }
    if (currentDlg->checks[2].status == true)
    {
	FLI_save();
    }
    if (currentDlg->checks[3].status == true)
    {
	IFLI_save();
    }
    if (currentDlg->checks[4].status == true)
    {
      	Hires_save();
    }
    if (currentDlg->checks[5].status == true)
    {
       AFLI_save();
    }    
    currentDlg = NULL;
    printf("Save now completed\n");
/*FIXME    do
 * {
 * x = getkey();
 * }
 * while (x == 0); */

    set320x200();
    init_mouse;
}

void
 MCI_save()
{
    printf("Multicolor Interlacesaver 0.0<insert lost of 0's here>1\n");
    MCI_write();
    do_plugin(numMCIexporters, theMCIexporters, "exp_mci");
}


void
 MC_save()
{
    printf("Multicolor saver 0.0<insert lost of 0's here>1\n");
    MC_write();
    do_plugin(numMCexporters, theMCexporters, "exp_mc");
}
void
 Hires_save()
{
    printf("Hires saver 0.0<insert lost of 0's here>1\n");
    Hires_write();
    do_plugin(numHiresexporters, theHiresexporters, "exp_hir");
}

void
 MC_write()
{
    int x, y, bits, these_bits;
    FILE *outfile;
    convert_multicolor();
    outfile = fopen("res/middle", "wb");
    fprintf(outfile, "WOW-MC");
    putWord(thePixels.xsize, outfile);
    putWord(thePixels.ysize, outfile);
    fputc(bg, outfile);

    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	    fputc((mc[0][y][x] + (mc[1][y][x] * 16)), outfile);


    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	    fputc(mcd800[y][x], outfile);

    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    these_bits = 0;
	    for (bits = 0; bits < 8; bits += 2)
	    {
		if (thePixels.pixels[y][(x << 3) + bits] == mcd800[y >> 3][x])
		    these_bits += (3 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits] == mc[0][y >> 3][x])
		    these_bits += (2 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits] == mc[1][y >> 3][x])
		    these_bits += (1 << (6 - bits));
	    }
	    fputc(these_bits, outfile);
	}

    fclose(outfile);

}

void
 Hires_write()
{
    int x, y, bits, these_bits;
    FILE *outfile;
    convert_hires();
    outfile = fopen("res/middle", "wb");
    fprintf(outfile, "WOW-HR");
    putWord(thePixels.xsize, outfile);
    putWord(thePixels.ysize, outfile);
    fputc(bg, outfile);

    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	    fputc((mc[0][y][x] + (mc[1][y][x] * 16)), outfile);

    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    these_bits = 0;
	    for (bits = 0; bits < 8; bits ++)
	    {
               if (thePixels.pixels[y][(x << 3) + bits] == mc[0][y >> 3][x])
		    these_bits += (1 << (7 - bits));
	    }
	    fputc(these_bits, outfile);
	}

    fclose(outfile);

}


void
 MCI_write()
{
    int x, y, bits, these_bits;
    FILE *outfile;
    convert_MCI();
    outfile = fopen("res/middle", "wb");
    fprintf(outfile, "WOW-MCI");
    putWord(thePixels.xsize, outfile);
    putWord(thePixels.ysize, outfile);
    fputc(bg, outfile);

    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	    fputc((mc[0][y][x] + (mc[1][y][x] * 16)), outfile);


    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	    fputc((mci[0][y][x] + (mci[1][y][x] * 16)), outfile);


    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	    fputc(mcd800[y][x], outfile);

    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    these_bits = 0;
	    for (bits = 0; bits < 8; bits += 2)
	    {
		if (thePixels.pixels[y][(x << 3) + bits] == mcd800[y >> 3][x])
		    these_bits += (3 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits] == mc[0][y >> 3][x])
		    these_bits += (2 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits] == mc[1][y >> 3][x])
		    these_bits += (1 << (6 - bits));
	    }
	    fputc(these_bits, outfile);
	}


    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    these_bits = 0;
	    for (bits = 0; bits < 8; bits += 2)
	    {
		if (thePixels.pixels[y][(x << 3) + bits + 1] == mcd800[y >> 3][x])
		    these_bits += (3 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits + 1] == mci[0][y >> 3][x])
		    these_bits += (2 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits + 1] == mci[1][y >> 3][x])
		    these_bits += (1 << (6 - bits));
	    }
	    fputc(these_bits, outfile);
	}

    fclose(outfile);
}




void
 do_plugin(int nump, plugin * saver, char *plugdir)
{
    char cmdline[100];
    int x;
    printf("Choose Your File Format\n");
  retry:
    for (x = 0; x < nump; x++)
    {
	printf("%d.  %s\n", x + 1, saver[x].name);
    }
    x = get_num();

    if (x > nump || x == 0)
    {
	printf("That is not valid, fool!\n");
	goto retry;
    }
    x--;
    printf("\nSelected format: %s\n", saver[x].name);

    sprintf(cmdline, "plugins/%s/%s %s", plugdir, saver[x].file, currentDlg->textboxes[0].inbox);
    system(cmdline);
}

void
 do_plugin_nofile(int nump, plugin * saver, char *plugdir)
{
    char cmdline[100];
    int x;
    printf("Choose Your Plugin\n");
  retry:
    for (x = 0; x < nump; x++)
    {
	printf("%d.  %s\n", x + 1, saver[x].name);
    }
    x = get_num();

    if (x > nump || x == 0)
    {
	printf("That is not valid, fool!\n");
	goto retry;
    }
    x--;
    printf("\nSelected format: %s\n", saver[x].name);

    sprintf(cmdline, "plugins/%s/%s", plugdir, saver[x].file);
    system(cmdline);
}


void
 IFLI_save()
{
    IFLI_write();
    do_plugin(numIFLIexporters, theIFLIexporters, "exp_ifli");
}

void
 FLI_save()
{
    FLI_write();
    do_plugin(numFLIexporters, theFLIexporters, "exp_fli");
}
void
 AFLI_save()
{
    AFLI_write();
    do_plugin(numAFLIexporters, theAFLIexporters, "exp_afli");
}

void
 IFLI_write()
{
    int x, y, bits, these_bits;
    FILE *outfile;
    set_to_IFLI();
    outfile = fopen("res/middle", "wb");
    /* put an ID -> in this case "WOW-IFLI" */
    fprintf(outfile, "WOW-IFLI");
    /* put the ysize only -> *almost* impossible to pan a IFLI horizontally ;) */
    /* (although it's amazing what crossbow can come up with :) */
    putWord(thePixels.ysize, outfile);
    /* put the (ysize) bg 1 colors */
    for (x = 0; x < thePixels.ysize; x++)
	fputc(flibg[x], outfile);

    /* Multicolors */
    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < 40; x++)
	    fputc(colortab[y][x], outfile);

    /* put fli set 1 */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 40; x++)
	    fputc(fli1[y][x], outfile);
    /* put fli set 2 */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 40; x++)
	    fputc(fli2[y][x], outfile);


    /* put ifli set 1 */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 40; x++)
	    fputc(fli1i[y][x], outfile);
    /* put ifli set 2 */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 40; x++)
	    fputc(fli2i[y][x], outfile);

    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    these_bits = 0;
	    for (bits = 0; bits < 8; bits += 2)
	    {
		if (thePixels.pixels[y][(x << 3) + bits] == colortab[y >> 3][x])
		    these_bits += (3 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits] == fli1[y][x])
		    these_bits += (2 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits] == fli2[y][x])
		    these_bits += (1 << (6 - bits));
	    }
	    fputc(these_bits, outfile);
	}

    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    these_bits = 0;
	    for (bits = 0; bits < 8; bits += 2)
	    {
		if (thePixels.pixels[y][(x << 3) + bits + 1] == colortab[y >> 3][x])
		    these_bits += (3 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits + 1] == fli1i[y][x])
		    these_bits += (2 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits + 1] == fli2i[y][x])
		    these_bits += (1 << (6 - bits));
	    }
	    fputc(these_bits, outfile);
	}
    fclose(outfile);
}


void
 FLI_write()
{
    int x, y, bits, these_bits;
    FILE *outfile;

    set_to_FLI();
    outfile = fopen("res/middle", "wb");
    /* put an ID -> in this case "WOW-IFLI" */
    fprintf(outfile, "WOW-FLI");
    /* put the ysize only -> *almost* impossible to pan a IFLI horizontally ;) */
    /* (although it's amazing what crossbow can come up with :) */
    putWord(thePixels.ysize, outfile);
    /* put the (ysize) bg 1 colors */
    for (x = 0; x < thePixels.ysize; x++)
	fputc(flibg[x], outfile);

    /* Multicolors */
    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < 40; x++)
	    fputc(colortab[y][x], outfile);

    /* put fli set 1 */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 40; x++)
	    fputc(fli1[y][x], outfile);
    /* put fli set 2 */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 40; x++)
	    fputc(fli2[y][x], outfile);


    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    these_bits = 0;
	    for (bits = 0; bits < 8; bits += 2)
	    {
		if (thePixels.pixels[y][(x << 3) + bits] == colortab[y >> 3][x])
		    these_bits += (3 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits] == fli1[y][x])
		    these_bits += (2 << (6 - bits));
		else if (thePixels.pixels[y][(x << 3) + bits] == fli2[y][x])
		    these_bits += (1 << (6 - bits));
	    }
	    fputc(these_bits, outfile);
	}

    fclose(outfile);
}


void
 AFLI_write()
{
    int x, y, bits, these_bits,plane;
    FILE *outfile;

    set_to_AFLI();
    outfile = fopen("res/middle", "wb");
    /* put an ID -> in this case "WOW-IFLI" */
    fprintf(outfile, "WOWAFLI");
    /* put the ysize only -> *almost* impossible to pan a IFLI horizontally ;) */
    /* (although it's amazing what crossbow can come up with :) */
    putWord(thePixels.ysize, outfile);

    
    /* put fli set 1 */
    for(plane=0;plane<8;plane++)
      for (y = 0; y < thePixels.ysize; y+=8)
	for (x = 0; x < 40; x++)
        {
	    fputc((fli1[y+plane][x])+(fli2[y+plane][x]<<4), outfile);
        }
    /* put fli set 2 */
/*    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 40; x++)
	    fputc(fli2[y][x], outfile);*/


    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    these_bits = 0;
	    for (bits = 0; bits < 8; bits ++)
	    {
               if (thePixels.pixels[y][(x << 3) + bits] == fli1[y][x])
		    these_bits += (1 << (7 - bits));
	    }
	    fputc(these_bits, outfile);
	}

    fclose(outfile);
}


void
 putWord(int input, FILE * where)
{
    int z;
    z = (input >> 8);
    fputc(z, where);

    fputc(input & 255, where);
}

void
 set_type(int type)
{
    switch (type)
    {
    case multicolor:
	thePixels.type = multicolor;
	convert_multicolor();
	set_doublePix();
	break;
    case MCI:
	thePixels.type = MCI;
	convert_MCI();
	unset_doublePix();
	break;
    case FLI:
	thePixels.type = FLI;
	set_to_FLI();
	set_doublePix();
	break;
    case IFLI:
	thePixels.type = IFLI;
	set_to_IFLI();
	unset_doublePix();
	break;
    case Hires:
        thePixels.type = Hires;
        convert_hires();
        unset_doublePix();
        break;
    case AFLI:
        thePixels.type = AFLI;
        set_to_AFLI();
        unset_doublePix();
        break;
    case none:
        thePixels.type = none;
        break;
    }
}

void
 new_pic()
{
    int y, x;
    int xsize = 0;
    int ysize = 0;
    /* Interpret the input size */
    sscanf(currentDlg->textboxes[0].inbox, "%d", &xsize);
    sscanf(currentDlg->textboxes[1].inbox, "%d", &ysize);
    thePixels.xsize = xsize;
    thePixels.ysize = ysize;
    /* Why, oh why, does this stop it from crashing?  i guess we will never know............... */
    set_text();
    /*printf("%d,%d",xsize,ysize); */
    /* clear the area */
    /*FIXME */
    for (y = 0; y < ysize; y++)
	for (x = 0; x < xsize; x++)
	    thePixels.pixels[y][x] = 0;
    set320x200();
    /* Set mode here Later today */
    if (currentDlg->checks[0].status == true)
	set_type(multicolor);
    if (currentDlg->checks[1].status == true)
	set_type(MCI);
    if (currentDlg->checks[2].status == true)
	set_type(FLI);
    if (currentDlg->checks[3].status == true)
	set_type(IFLI);
    if (currentDlg->checks[4].status == true)
	set_type(Hires);        
    if (currentDlg->checks[5].status == true)
	set_type(AFLI);
    if (currentDlg->checks[6].status == true)
	set_type(none);                
}

void
 init_pic(int xs, int ys, int mode)
{
    int x, y;
    thePixels.xsize = xs;
    thePixels.ysize = ys;
    /* Why, oh why, does this stop it from crashing?  i guess we will never know............... */
    set_text();
    /*printf("%d,%d",xsize,ysize); */
    /* clear the area */
    for (y = 0; y < ys; y++)
	for (x = 0; x < xs; x++)
	    thePixels.pixels[y][x] = 0;
    set320x200();

    set_type(mode);
}

void
 dialog_click()
{
    int x;

    /* Check for title Drag */
    if (oldb != mouseb && dragx != 0)
    {
	dragx = dragy = 0;
	oldb = mouseb;
    }
    if (mousex >= currentDlg->xpos
	&& mousey >= currentDlg->ypos
	&& mousex <= (currentDlg->xpos + currentDlg->xsize)
	&& mousey <= (currentDlg->ysize + currentDlg->ypos))
    {
	int relx = 0, rely = 0;
	rely = mousey - currentDlg->ypos;
	relx = mousex - currentDlg->xpos;

	/* Check for button Press */
	for (x = 0; x < currentDlg->numButtons; x++)
	{
	    if (relx >= currentDlg->buttons[x].xpos
		&& rely >= currentDlg->buttons[x].ypos
		&& relx <= currentDlg->buttons[x].xpos + 75
		&& rely <= currentDlg->buttons[x].ypos + 20)
	    {
		dlg_button_click(x);
                wait_for_button();
		return;
	    }
	}
	/* Check for checkbox Press */
	for (x = 0; x < currentDlg->numChecks; x++)
	{
	    if (relx >= currentDlg->checks[x].xpos
		&& rely >= currentDlg->checks[x].ypos + 5
		&& relx <= currentDlg->checks[x].xpos + 10
		&& rely <= currentDlg->checks[x].ypos + 15)
	    {
		dlg_check_click(x);
		return;
	    }
	}

	/* Check for textbox Press */
	for (x = 0; x < currentDlg->numTextboxes; x++)
	{
	    if (relx >= currentDlg->textboxes[x].xpos
		&& rely >= currentDlg->textboxes[x].ypos
		&& relx <= currentDlg->textboxes[x].xpos + currentDlg->textboxes[x].xsize
		&& rely <= currentDlg->textboxes[x].ypos + 20)
	    {
		currentDlg->textFocus = x;
		return;
	    }
	}

	for (x = 0; x < currentDlg->numColorboxes; x++)
	{
	    if (relx >= currentDlg->colorboxes[x].xpos
		&& rely >= currentDlg->colorboxes[x].ypos
		&& relx <= currentDlg->colorboxes[x].xpos + currentDlg->colorboxes[x].xsize
		&& rely <= currentDlg->colorboxes[x].ypos + currentDlg->colorboxes[x].ysize)
	    {
		colorbox_click(x, relx, rely);
	    }
	}

	if (rely < 16)
	{
	    /* Title Bar Click */
/*          printf("Click on the Title Bar\n"); */
	    if (oldb != mouseb)
	    {			/* drag action */
		if (dragx == 0)
		{
		    dragx = relx;
		    dragy = rely;
		}
	    }
	}
    }
    if (dragx != 0)
    {
	currentDlg->xpos = mousex - dragx;
	currentDlg->ypos = mousey - dragy;
    }
}

void wait_for_button()
{
	do {
           update_mouse;
           mouseb = get_mouseb;
        } while (mouseb!=0);
}

void
 colorbox_click(int which, int wherex, int wherey)
{
    if (oldb != mouseb)
	if (currentDlg == &gradient)
	    if (which == 1)
	    {
		int barx, xsize, thiscolr;
		barx = wherex - (3 + currentDlg->colorboxes[which].xpos);
		xsize = currentDlg->colorboxes[which].xsize;
		thiscolr = (((barx * 100) / (xsize - 6)) * currentDlg->colorboxes[which].numColors) / 100;
		add2cbox(&gradient, 0, thiscolr);
	    } else
	    {
		int barx, xsize, thiscolr;
		barx = wherex - (3 + currentDlg->colorboxes[which].xpos);
		xsize = currentDlg->colorboxes[which].xsize;
		thiscolr = (((barx * 100) / (xsize - 6)) * currentDlg->colorboxes[which].numColors) / 100;
		rem_from_cbox(&gradient, 0, thiscolr);
	} else if (currentDlg == &cod)
	    if (which == 1)
	    {
		int barx, xsize, thiscolr;
		barx = wherex - (3 + currentDlg->colorboxes[which].xpos);
		xsize = currentDlg->colorboxes[which].xsize;
		thiscolr = (((barx * 100) / (xsize - 6)) * currentDlg->colorboxes[which].numColors) / 100;
		add2cbox(&cod, 0, thiscolr);
	    } else
	    {
		int barx, xsize, thiscolr;
		barx = wherex - (3 + currentDlg->colorboxes[which].xpos);
		xsize = currentDlg->colorboxes[which].xsize;
		thiscolr = (((barx * 100) / (xsize - 6)) * currentDlg->colorboxes[which].numColors) / 100;
		rem_from_cbox(&cod, 0, thiscolr);
	    }
}

void
 rem_from_cbox(dlgBox * what, int which, int color)
{
    int x;
    if (what->colorboxes[which].numColors < 0)
	what->colorboxes[which].numColors = 0;
    for (x = color + 1; x < what->colorboxes[which].numColors; x++)
	what->colorboxes[which].colors[x - 1] = what->colorboxes[which].colors[x];
    what->colorboxes[which].numColors--;
    if (what->colorboxes[which].numColors < 0)
	what->colorboxes[which].numColors = 0;
}

void
 dlg_check_click(int button)
{
    if (currentDlg == &newPic || currentDlg == &changeRes || currentDlg == &setType || currentDlg == &save || currentDlg == &xdouble)
    {
	clear_current_checks();
	currentDlg->checks[button].status = true;
    }
}
void
 clear_current_checks()
{
    int x;
    for (x = 0; x < currentDlg->numChecks; x++)
    {
	currentDlg->checks[x].status = false;
    }
}


void
 do_new()
{
    new_dlg(&newPic);
}

void
 do_save()
{
    new_dlg(&save);
}

void
 zoom_in()
{
    xzoom++;
    yzoom++;
}
void
 zoom_out()
{
    xzoom--;
    yzoom--;
    if (xzoom < 0)
	xzoom = yzoom = 0;
}

void
 show_res_dlg()
{
    new_dlg(&changeRes);
}


void
 show_set_type()
{
    new_dlg(&setType);
}

void
 show_dimension_dlg()
{
    new_dlg(&dimension);
}

void
 do_crop()
{
    crop(xscroll, yscroll, xscroll + xres, yscroll + yres);
}

void
 show_xdouble_dlg()
{
    new_dlg(&xdouble);
}
void
 menu_click()
{
    switch (c_menu)
    {
	/* check if it's colors or toolbar */
    case -1:
	if (mousex < (xres - 16))
	{
	    /* it's colors! */
	    if (extendedClr != true)
	    {
		if (mousey > (yres - 16))
		{
		    realpencolor = ((mousex * numPens) / (xres - 16));
		    pencolor = color_order[realpencolor];
		}
	    } else
	    {
		if (mousey > (yres - 128))
		{
		    realpencolor = ((mousex * numPens) / (xres - 16));
		    realpencolor2 = ((yres - mousey) / (128 / numPens));
		    pencolor = color_order[realpencolor] + 16 * color_order[realpencolor2];
		}
	    }
	} else
	{
	    if (mousey > 16 && mousey < (16 + 8 * 20) && (mousex > (xres - 16)))
	    {
		int p;
		p = (mousey - 16) / 20;
		switch (p)
		{
		case gradient_fill:
		    new_dlg(&gradient);
		    break;

		default:
		    tool = p;
		    break;
		}
	    }
	}
	break;

    default:
	if (theMenus[c_menu].items[vindex].proc != NULL)
	{
	    theMenus[c_menu].items[vindex].proc();
	}
	c_menu = -1;
	break;
    }
}

void
 crop(int x1, int y1, int x2, int y2)
{
    int t, x, y;

    if (x1 == x2)
	return;
    if (y1 == y2)
	return;
    if (x1 > x2)
    {
	t = x1;
	x2 = x1;
	x1 = t;
    };
    if (y1 > y2)
    {
	t = y1;
	y2 = y1;
	y1 = t;
    };

    for (y = y1; y < y2; y++)
	for (x = x1; x < x2; x++)
	{
	    thePixels.pixels[y - y1][x - x1] = thePixels.pixels[y][x];
	}
    thePixels.xsize = (x2 - x1);
    thePixels.ysize = (y2 - y1);

    for (y = 0; y < thePixels.ysize; y++)
	for (x = thePixels.xsize; x < 3200; x++)
	{
	    thePixels.pixels[y][x] = 0;
	}
    for (y = thePixels.ysize; y < 2000; y++)
	for (x = 0; x < 3200; x++)
	{
	    thePixels.pixels[y][x] = 0;
	}
}

void
 set_to_FLI()
{
    int x, y;
    /* size is 320,x (could be 200 or 400 usually.... but i'll allow room for */
    /* that 600 (or more) line SBFLI we are all wating */
    /* for crossbow to develop :) */
    /* (actully, didnt he do a 3-screen FLI in Ice cream castle?  bah :) */

    thePixels.xsize = 320;

    /* move the 320 pixels from the current location to the origion */
    /* could be already there, so use slow copy :) */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 320; x++)
	{
	    thePixels.pixels[y][x] = thePixels.pixels[y][x + xscroll];
	}

    /* clear the first 24 pixels (set 'em to $d021) */
    for (y = 0; y < thePixels.ysize; y++)
    {
	memset(thePixels.pixels[y], 16, 24);
    }
    /*convert to FLI limits (1 $d021 per line, +2 per 8x1+1 per 8x8) */
    convert_FLI();
}

void
 set_to_AFLI()
{
    int x, y;
    /* size is 320,x (could be 200 or 400 usually.... but i'll allow room for */
    /* that 600 (or more) line SBFLI we are all wating */
    /* for crossbow to develop :) */
    /* (actully, didnt he do a 3-screen FLI in Ice cream castle?  bah :) */

    thePixels.xsize = 320;

    /* move the 320 pixels from the current location to the origion */
    /* could be already there, so use slow copy :) */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 320; x++)
	{
	    thePixels.pixels[y][x] = thePixels.pixels[y][x + xscroll];
	}

    /* clear the first 24 pixels (set 'em to $d021) */
    for (y = 0; y < thePixels.ysize; y++)
    {
	memset(thePixels.pixels[y], 16, 24);
    }
    /*convert to FLI limits (1 $d021 per line, +2 per 8x1+1 per 8x8) */
    convert_AFLI();
}

void
 set_to_IFLI()
{
    int x, y;
    /* size is 320,x (200 usually.... 400 for a BFLI varient, but i'll allow room for */
    /* that 600 (or more) line SBIFLI we are all wating */
    /* for crossbow to develop :) */

    thePixels.xsize = 320;

    /* move the 320 pixels from the current location to the origion */
    /* could be already there, so use slow copy :) */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < 320; x++)
	{
	    thePixels.pixels[y][x] = thePixels.pixels[y][x + xscroll];
	}

    /* clear the first 24 pixels (set 'em to $d021) */
    for (y = 0; y < thePixels.ysize; y++)
    {
	memset(thePixels.pixels[y], 16, 24);
    }
    /*convert to FLI limits (1 $d021 per line, +2 per 8x1+1 per 8x8) */
    convert_IFLI();
}


void
 check_FLI(int xp, int yp, int c)
{
    int x8, y8;
    x8 = (xp >> 3);
    y8 = (yp >> 3);
    if (flibg[yp] == c)
	return;
    if (colortab[y8][x8] == c)
	return;
    if (fli1[yp][x8] == c)
	return;
    if (fli2[yp][x8] == c)
	return;

    /* still here - d'oh!!!! find dup's ;). */
    if (flibg[yp] == colortab[y8][x8])
    {
	colortab[y8][x8] = c;
	return;
    }
    if (flibg[yp] == fli1[yp][x8])
    {
	fli1[yp][x8] = c;
	return;
    }
    if (flibg[yp] == fli2[yp][x8])
    {
	fli2[yp][x8] = c;
	return;
    }
    if (colortab[y8][x8] == fli1[yp][x8])
    {
	fli1[yp][x8] = c;
	return;
    }
    if (colortab[y8][x8] == fli2[yp][x8])
    {
	fli2[yp][x8] = c;
	return;
    }
    if (fli1[yp][x8] == fli2[yp][x8])
    {
	fli2[yp][x8] = c;
	return;
    }
    recheck_FLI(x8, y8);
}
void
 check_AFLI(int xp, int yp, int c)
{
    int x8, y8;
    x8 = (xp >> 3);
    y8 = (yp >> 3);

    if (fli1[yp][x8] == c)
	return;
    if (fli2[yp][x8] == c)
	return;

    /* still here - d'oh!!!! find dup's ;). */
    if (fli1[yp][x8] == fli2[yp][x8])
    {
	fli2[yp][x8] = c;
	return;
    }
    recheck_AFLI(x8, y8);
}

void
 check_IFLI(int xp, int yp, int c)
{
    int x8, y8;
    x8 = (xp >> 3);
    y8 = (yp >> 3);
    if ((xp & 1) == 0)
    {
	if (flibg[yp] == c)
	    return;
	if (colortab[y8][x8] == c)
	    return;
	if (fli1[yp][x8] == c)
	    return;
	if (fli2[yp][x8] == c)
	    return;
	/* still here - d'oh!!!! find dup's ;). */
	if (flibg[yp] == colortab[y8][x8])
	{
	    colortab[y8][x8] = c;
	    return;
	}
	if (flibg[yp] == fli1[yp][x8])
	{
	    fli1[yp][x8] = c;
	    return;
	}
	if (flibg[yp] == fli2[yp][x8])
	{
	    fli2[yp][x8] = c;
	    return;
	}
	if (colortab[y8][x8] == fli1[yp][x8])
	{
	    fli1[yp][x8] = c;
	    return;
	}
	if (colortab[y8][x8] == fli2[yp][x8])
	{
	    fli2[yp][x8] = c;
	    return;
	}
	if (fli1[yp][x8] == fli2[yp][x8])
	{
	    fli2[yp][x8] = c;
	    return;
	}
    } else
    {
	if (flibg[yp] == c)
	    return;
	if (colortab[y8][x8] == c)
	    return;
	if (fli1i[yp][x8] == c)
	    return;
	if (fli2i[yp][x8] == c)
	    return;
	/* still here - d'oh!!!! find dup's ;). */
	if (flibg[yp] == colortab[y8][x8])
	{
	    colortab[y8][x8] = c;
	    return;
	}
	if (flibg[yp] == fli1i[y8][x8])
	{
	    fli1i[y8][x8] = c;
	    return;
	}
	if (flibg[yp] == fli2i[y8][x8])
	{
	    fli2i[y8][x8] = c;
	    return;
	}
	if (colortab[y8][x8] == fli1i[y8][x8])
	{
	    fli1i[y8][x8] = c;
	    return;
	}
	if (colortab[y8][x8] == fli2i[y8][x8])
	{
	    fli2i[y8][x8] = c;
	    return;
	}
	if (fli1i[y8][x8] == fli2i[y8][x8])
	{
	    fli2i[y8][x8] = c;
	    return;
	}
    }
    recheck_IFLI(x8, y8);
}

void
 recheck_FLI(int xp, int yp)
{
    int x, y, used[256], c, y2;
    /* first, get the most used color on each line */
    for (y = (yp << 3); y < ((yp << 3) + 8); y++)
    {
	int max = 0, maxc = 0;
	max = 0;
	for (x = 0; x < 17; x++)
	    used[x] = 0;

	/* fill the used table */
	for (x = 24; x < thePixels.xsize; x++)
	    used[thePixels.pixels[y][x]]++;
	/* get the most used */
	for (x = 0; x < 16; x++)
	{
	    if (used[x] > max)
	    {
		max = used[x];
		maxc = x;
	    }
	}

	flibg[y] = maxc;
	flibg[y] = 0;
	for (x = 0; x < 24; x++)
	    thePixels.pixels[y][x] = flibg[y];
    }


    /* Next, get the mose used in each 8x8    */
    for (c = 3; c < 40; c++)
    {
	int max = 0, maxc = 0;
	max = 0;
	for (x = 0; x < 17; x++)
	    used[x] = 0;
	for (x = 0; x < 8; x++)
	    for (y2 = 0; y2 < 8; y2++)
		used[thePixels.pixels[yp + y2][(c << 3) + x]]++;

	for (x = 0; x < 16; x++)
	{
	    if (used[x] > max && x != flibg[y << 3])
	    {
		max = used[x];
		maxc = x;
	    }
	}
	colortab[yp][c] = maxc;
    }



    /* Now, find the 2 most in each 8x1 */
    for (y = (yp << 3); y < ((yp << 3) + 8); y++)
    {
	for (c = 3; c < 40; c++)
	{
	    int max = 0, maxc = 0;
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 0; x < 8; x++)
		used[thePixels.pixels[y][(c << 3) + x]]++;

	    /* get mc1 first */
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }

	    fli1[y][c] = maxc;

	    max = 0;
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != fli1[y][c] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    fli2[y][c] = maxc;
	}
    }

    /* We now have set up the Global Colormap..... no compare each byte, and reset those that dont match up */
    /* For the moment, i am foing to set them to 47, so that i can see them */
    for (y = (yp << 3); y < ((yp << 3) + 8); y++)
	for (x = 24; x < thePixels.xsize; x++)
	{
	    if (thePixels.pixels[y][x] == flibg[y] || thePixels.pixels[y][x] == colortab[y >> 3][x >> 3] || thePixels.pixels[y][x] == fli1[y][x >> 3] || thePixels.pixels[y][x] == fli2[y][x >> 3])
	    {
	    } else
	    {
		thePixels.pixels[y][x] = getcolor(flibg[y], fli1[y][x >> 3], fli2[y][x >> 3], colortab[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}
}

void
 recheck_AFLI(int xp, int yp)
{
    int x, y, used[256], c, y2;


    /* Now, find the 2 most in each 8x1 */
    for (y = (yp << 3); y < ((yp << 3) + 8); y++)
    {
	for (c = 3; c < 40; c++)
	{
	    int max = 0, maxc = 0;
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 0; x < 8; x++)
		used[thePixels.pixels[y][(c << 3) + x]]++;

	    /* get mc1 first */
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max)
		{
		    max = used[x];
		    maxc = x;
		}
	    }

	    fli1[y][c] = maxc;

	    max = 0;
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x!=fli1[y][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    fli2[y][c] = maxc;
	}
    }

    /* We now have set up the Global Colormap..... no compare each byte, and reset those that dont match up */
    /* For the moment, i am foing to set them to 47, so that i can see them */
    for (y = (yp << 3); y < ((yp << 3) + 8); y++)
	for (x = 24; x < thePixels.xsize; x++)
	{
	    if (thePixels.pixels[y][x] == fli1[y][x >> 3] || thePixels.pixels[y][x] == fli2[y][x >> 3])
	    {
	    } else
	    {
		thePixels.pixels[y][x] = getcolor(fli1[y][x >> 3], fli2[y][x >> 3], fli2[y][x >> 3], fli2[y][x >> 3], thePixels.pixels[y][x]);
	    }
	}
}

void
 convert_FLI()
{
    int x, y, c, y2;
    int used[257];

    /* first, get the most used color on each line */
    for (y = 0; y < thePixels.ysize; y++)
    {
	int max = 0, maxc = 0;
	max = 0;
	for (x = 0; x < 17; x++)
	    used[x] = 0;

	/* fill the used table */
	for (x = 24; x < thePixels.xsize; x++)
	    used[thePixels.pixels[y][x]]++;
	/* get the most used */
	for (x = 0; x < 16; x++)
	{
	    if (used[x] > max)
	    {
		max = used[x];
		maxc = x;
	    }
	}
	flibg[y] = maxc;
	flibg[y] = 0;
	for (x = 0; x < 24; x++)
	    thePixels.pixels[y][x] = flibg[y];
    }


    /* Next, get the mose used in each 8x8 */
    for (y = 0; y < (thePixels.ysize >> 3); y++)
    {
	for (c = 3; c < 40; c++)
	{
	    int max = 0, maxc = 0;
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 0; x < 8; x++)
		for (y2 = 0; y2 < 8; y2++)
		    used[thePixels.pixels[(y << 3) + y2][(c << 3) + x]]++;

	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y << 3])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    colortab[y][c] = maxc;
	}
    }



    /* Now, find the 2 most in each 8x1 */
    for (y = 0; y < thePixels.ysize; y++)
    {
	for (c = 3; c < 40; c++)
	{
	    int max = 0, maxc = 0;
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 0; x < 8; x++)
		used[thePixels.pixels[y][(c << 3) + x]]++;

	    /* get mc1 first */
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }

	    fli1[y][c] = maxc;

	    max = 0;
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != fli1[y][c] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    fli2[y][c] = maxc;
	}
    }

    /* We now have set up the Global Colormap..... no compare each byte, and reset those that dont match up */
    /* For the moment, i am foing to set them to 47, so that i can see them */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 24; x < thePixels.xsize; x++)
	{
	    if (thePixels.pixels[y][x] == flibg[y] || thePixels.pixels[y][x] == colortab[y >> 3][x >> 3] || thePixels.pixels[y][x] == fli1[y][x >> 3] || thePixels.pixels[y][x] == fli2[y][x >> 3])
	    {
	    } else
	    {
		thePixels.pixels[y][x] = getcolor(flibg[y], fli1[y][x >> 3], fli2[y][x >> 3], colortab[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}
}


void
 convert_AFLI()
{
    int x, y, c, y2;
    int used[257];


    /* Now, find the 2 most in each 8x1 */
    for (y = 0; y < thePixels.ysize; y++)
    {
	for (c = 3; c < 40; c++)
	{
	    int max = 0, maxc = 0;
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 0; x < 8; x++)
		used[thePixels.pixels[y][(c << 3) + x]]++;

	    /* get mc1 first */
	    for (x = 0; x < 16; x++)
	    {
		if (used[x]>max)
		{
		    max = used[x];
		    maxc = x;
		}
	    }

	    fli1[y][c] = maxc;

	    max = 0;
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != fli1[y][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    fli2[y][c] = maxc;
	}
    }

    /* We now have set up the Global Colormap..... no compare each byte, and reset those that dont match up */
    /* For the moment, i am foing to set them to 47, so that i can see them */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 24; x < thePixels.xsize; x++)
	{
	    if (thePixels.pixels[y][x] == fli1[y][x >> 3] || thePixels.pixels[y][x] == fli2[y][x >> 3])
	    {
	    } else
	    {
		thePixels.pixels[y][x] = getcolor(fli1[y][x >> 3], fli2[y][x >> 3], fli2[y][x >> 3], fli2[y][x >> 3],  thePixels.pixels[y][x]);
	    }
	}
}



/* This is the same as the FLI converter, but for IFLI (duh!) */
void
 convert_IFLI()
{
    int x, y, c, y2;
    int used[257];

    /* first, get the most used color on each line */
    for (y = 0; y < thePixels.ysize; y++)
    {
	int max = 0, maxc = 0;
	max = 0;
	for (x = 0; x < 17; x++)
	    used[x] = 0;

	/* fill the used table */
	for (x = 24; x < thePixels.xsize; x++)
	    used[thePixels.pixels[y][x]]++;
	/* get the most used */
	for (x = 0; x < 16; x++)
	{
	    if (used[x] > max)
	    {
		max = used[x];
		maxc = x;
	    }
	}
	flibg[y] = maxc;
	flibg[y] = 0;
	for (x = 0; x < 24; x++)
	    thePixels.pixels[y][x] = flibg[y];
    }
    /* Next, get the mose used in each 8x8 */
    /* only one of these ;) */
    /* pass 1 */
    for (y = 0; y < (thePixels.ysize >> 3); y++)
    {
	for (c = 3; c < 40; c++)
	{
	    int max = 0, maxc = 0;
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 0; x < 8; x++)
		for (y2 = 0; y2 < 8; y2++)
		    used[thePixels.pixels[(y << 3) + y2][(c << 3) + x]]++;

	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y << 3])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    colortab[y][c] = maxc;
	    max = 0;
	}
    }


    /* Now, find the 2 most in each 8x1 */
    /* pass 1 */
    for (y = 0; y < thePixels.ysize; y++)
    {
	for (c = 3; c < 40; c++)
	{
	    int max = 0, maxc = 0;
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 0; x < 8; x += 2)
		used[thePixels.pixels[y][(c << 3) + x]]++;

	    /* get mc1 first */
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }

	    fli1[y][c] = maxc;

	    max = 0;
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != fli1[y][c] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    fli2[y][c] = maxc;


	    /* pass 2 */
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 1; x < 8; x += 2)
		used[thePixels.pixels[y][(c << 3) + x]]++;

	    /* get mc1 first */
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }

	    fli1i[y][c] = maxc;

	    max = 0;
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != fli1i[y][c] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    fli2i[y][c] = maxc;


	}
    }

    /* We now have set up the Global Colormap..... no compare each byte, and reset those that dont match up */
    /* For the moment, i am foing to set them to 47, so that i can see them */
    for (y = 0; y < thePixels.ysize; y++)
    {
	for (x = 24; x < thePixels.xsize; x += 2)
	{
	    if (thePixels.pixels[y][x] == flibg[y] || thePixels.pixels[y][x] == colortab[y >> 3][x >> 3] || thePixels.pixels[y][x] == fli1[y][x >> 3] || thePixels.pixels[y][x] == fli2[y][x >> 3])
	    {
	    } else
	    {
		thePixels.pixels[y][x] = getcolor(flibg[y], fli1[y][x >> 3], fli2[y][x >> 3], colortab[y >> 3][x >> 3], thePixels.pixels[y][x]);
/*           thePixels.pixels[y][x]=flibg[y];    */
	    }
	}

	for (x = 25; x < thePixels.xsize; x += 2)
	{
	    if (thePixels.pixels[y][x] == flibg[y] || thePixels.pixels[y][x] == colortab[y >> 3][x >> 3] || thePixels.pixels[y][x] == fli1i[y][x >> 3] || thePixels.pixels[y][x] == fli2i[y][x >> 3])
	    {
	    } else
	    {
		thePixels.pixels[y][x] = flibg[y];
		thePixels.pixels[y][x] = getcolor(flibg[y], fli1i[y][x >> 3], fli2i[y][x >> 3], colortab[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}
    }
}


void
 recheck_IFLI(int xp, int yp)
{
    int x, y, c, y2;
    int used[257];

    /* first, get the most used color on each line */
    for (y = yp; y < (yp + 8); y++)
    {
	int max = 0, maxc = 0;
	max = 0;
	for (x = 0; x < 17; x++)
	    used[x] = 0;

	/* fill the used table */
	for (x = 24; x < thePixels.xsize; x++)
	    used[thePixels.pixels[y][x]]++;
	/* get the most used */
	for (x = 0; x < 16; x++)
	{
	    if (used[x] > max)
	    {
		max = used[x];
		maxc = x;
	    }
	}
	flibg[y] = maxc;
	flibg[y] = 0;
	for (x = 0; x < 24; x++)
	    thePixels.pixels[y][x] = flibg[y];

    }
    /* Next, get the mose used in each 8x8 */
    /* pass 1 only */
    y = (yp >> 3);
    {
	for (c = 3; c < 40; c++)
	{
	    int max = 0, maxc = 0;
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 0; x < 8; x++)
		for (y2 = 0; y2 < 8; y2++)
		    used[thePixels.pixels[(y << 3) + y2][(c << 3) + x]]++;

	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y << 3])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    colortab[y][c] = maxc;
	    max = 0;
	}
    }


    /* Now, find the 2 most in each 8x1 */
    /* pass 1 */
    for (y = yp; y < (yp + 8); y++)
    {
	for (c = 3; c < 40; c++)
	{
	    int max = 0, maxc = 0;
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 0; x < 8; x += 2)
		used[thePixels.pixels[y][(c << 3) + x]]++;

	    /* get mc1 first */
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }

	    fli1[y][c] = maxc;

	    max = 0;
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != fli1[y][c] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    fli2[y][c] = maxc;


	    /* pass 2 */
	    max = 0;
	    for (x = 0; x < 17; x++)
		used[x] = 0;

	    for (x = 1; x < 8; x += 2)
		used[thePixels.pixels[y][(c << 3) + x]]++;

	    /* get mc1 first */
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }

	    fli1i[y][c] = maxc;

	    max = 0;
	    for (x = 0; x < 16; x++)
	    {
		if (used[x] > max && x != flibg[y] && x != fli1i[y][c] && x != colortab[y >> 3][c])
		{
		    max = used[x];
		    maxc = x;
		}
	    }
	    fli2i[y][c] = maxc;


	}
    }

    /* We now have set up the Global Colormap..... no compare each byte, and reset those that dont match up */
    /* For the moment, i am foing to set them to 47, so that i can see them */
    for (y = yp; y < (yp + 8); y++)
    {
	for (x = 24; x < thePixels.xsize; x += 2)
	{
	    if (thePixels.pixels[y][x] == flibg[y] || thePixels.pixels[y][x] == colortab[y >> 3][x >> 3] || thePixels.pixels[y][x] == fli1[y][x >> 3] || thePixels.pixels[y][x] == fli2[y][x >> 3])
	    {
	    } else
	    {
		thePixels.pixels[y][x] = getcolor(flibg[y], fli1[y][x >> 3], fli2[y][x >> 3], colortab[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}

	for (x = 25; x < thePixels.xsize; x += 2)
	{
	    if (thePixels.pixels[y][x] == flibg[y] || thePixels.pixels[y][x] == colortab[y >> 3][x >> 3] || thePixels.pixels[y][x] == fli1i[y][x >> 3] || thePixels.pixels[y][x] == fli2i[y][x >> 3])
	    {
	    } else
	    {
		thePixels.pixels[y][x] = getcolor(flibg[y], fli1i[y][x >> 3], fli2i[y][x >> 3], colortab[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}
    }
}

int
 getcolor(int c1, int c2, int c3, int c4, int c2r)
{
    int x = -1;
    do
    {
	x++;
    }
    while (replace[c2r][x] != c1 && replace[c2r][x] != c2 && replace[c2r][x] != c3 && replace[c2r][x] != c4);
    return replace[c2r][x];
}

void convert_hires()
{
    int x, y, x2, y2, c;
    int used[257];
    int max, maxc;

    max = 0;
    maxc = 0;

    for (x = 0; x < 17; x++)
	used[x] = 0;

    /* get the 2 colors for each 8x8 block now */
    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    for (c = 0; c < 17; c++)
		used[c] = 0;
	    for (y2 = 0; y2 < 8; y2++)
		for (x2 = 0; x2 < 8; x2++)
		    used[thePixels.pixels[(y << 3) + y2][(x << 3) + x2]]++;

	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != bg)
		{
		    max = used[c];
		    maxc = c;
		}
	    }

	    mc[0][y][x] = maxc;
	    max = 0;
            
            /* and, color #2 */
	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != mc[0][y][x])
		{
		    max = used[c];
		    maxc = c;
		}
	    }

	    mc[1][y][x] = maxc;
	    max = 0;
        }

    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < thePixels.xsize; x++)
	{
	    if (thePixels.pixels[y][x] != mc[0][y >> 3][x >> 3] && thePixels.pixels[y][x] != mc[1][y >> 3][x >> 3])
	    {
            thePixels.pixels[y][x] = getcolor(mc[0][y >> 3][x >> 3], mc[1][y >> 3][x>>3],mc[1][y >> 3][x>>3], mc[1][y >> 3][x>>3],thePixels.pixels[y][x]);
	    }
	}
}

void convert_multicolor()
{
    int x, y, x2, y2, c;
    int used[257];
    int max, maxc;

    max = 0;
    maxc = 0;

    for (x = 0; x < 17; x++)
	used[x] = 0;
    /* get background color */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < thePixels.xsize; x++)
	{
	    used[thePixels.pixels[y][x]]++;
	}
    for (x = 0; x < 16; x++)
    {
	if (used[x] > max)
	{
	    max = used[x];
	    maxc = x;
	}
	used[x] = 0;
    }
    bg = maxc;
    max = 0;

    /* get the 3 multicolors for each 8x8 block now */
    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    for (c = 0; c < 17; c++)
		used[c] = 0;
	    for (y2 = 0; y2 < 8; y2++)
		for (x2 = 0; x2 < 8; x2++)
		    used[thePixels.pixels[(y << 3) + y2][(x << 3) + x2]]++;

	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != bg)
		{
		    max = used[c];
		    maxc = c;
		}
	    }

	    mcd800[y][x] = maxc;
	    max = 0;

	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != bg && c != mcd800[y][x])
		{
		    max = used[c];
		    maxc = c;
		}
	    }

	    mc[0][y][x] = maxc;
	    max = 0;


	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != bg && c != mcd800[y][x] && c != mc[0][y][x])
		{
		    max = used[c];
		    maxc = c;
		}
	    }

	    mc[1][y][x] = maxc;
	    max = 0;
	}
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < thePixels.xsize; x++)
	{
	    if (thePixels.pixels[y][x] != bg && thePixels.pixels[y][x] != mc[0][y >> 3][x >> 3] && thePixels.pixels[y][x] != mc[1][y >> 3][x >> 3] && thePixels.pixels[y][x] != mcd800[y >> 3][x >> 3])
	    {
		thePixels.pixels[y][x] = getcolor(bg, mc[0][y >> 3][x >> 3], mc[1][y >> 3][x >> 3], mcd800[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}
}
void
 convert_MCI()
{
    int x, y, x2, y2, c;
    int used[257];
    int max, maxc;

    max = 0;
    maxc = 0;

    for (x = 0; x < 17; x++)
	used[x] = 0;
    /* get background color */
    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < thePixels.xsize; x++)
	{
	    used[thePixels.pixels[y][x]]++;
	}
    for (x = 0; x < 16; x += 2)
    {
	if (used[x] > max)
	{
	    max = used[x];
	    maxc = x;
	}
	used[x] = 0;
    }
    bg = maxc;
    max = 0;

    /* get d800 colors (only one set of these.......... */
    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    for (c = 0; c < 17; c++)
		used[c] = 0;
	    for (y2 = 0; y2 < 8; y2++)
		for (x2 = 0; x2 < 8; x2++)
		    used[thePixels.pixels[(y << 3) + y2][(x << 3) + x2]]++;

	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != bg)
		{
		    max = used[c];
		    maxc = c;
		}
	    }
	    mcd800[y][x] = maxc;
	    max = 0;
	}

    /* get the 3 multicolors for each 8x8 block now */
    for (y = 0; y < (thePixels.ysize >> 3); y++)
	for (x = 0; x < (thePixels.xsize >> 3); x++)
	{
	    for (c = 0; c < 17; c++)
		used[c] = 0;
	    for (y2 = 0; y2 < 8; y2++)
		for (x2 = 0; x2 < 8; x2 += 2)
		    used[thePixels.pixels[(y << 3) + y2][(x << 3) + x2]]++;

	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != bg && c != mcd800[y][x])
		{
		    max = used[c];
		    maxc = c;
		}
	    }
	    mc[0][y][x] = maxc;
	    max = 0;
	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != bg && c != mcd800[y][x] && c != mc[0][y][x])
		{
		    max = used[c];
		    maxc = c;
		}
	    }
	    mc[1][y][x] = maxc;
	    max = 0;

	    /* pass 2 */

	    for (c = 0; c < 17; c++)
		used[c] = 0;
	    for (y2 = 0; y2 < 8; y2++)
		for (x2 = 1; x2 < 8; x2 += 2)
		    used[thePixels.pixels[(y << 3) + y2][(x << 3) + x2]]++;

	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != bg && c != mcd800[y][x])
		{
		    max = used[c];
		    maxc = c;
		}
	    }
	    mci[0][y][x] = maxc;
	    max = 0;
	    for (c = 0; c < 16; c++)
	    {
		if (used[c] > max && c != bg && c != mci[0][y][x] && c != mcd800[y][x])
		{
		    max = used[c];
		    maxc = c;
		}
	    }
	    mci[1][y][x] = maxc;
	    max = 0;
	}

    for (y = 0; y < thePixels.ysize; y++)
    {

	for (x = 0; x < thePixels.xsize; x += 2)
	{
	    if (thePixels.pixels[y][x] != bg && thePixels.pixels[y][x] != mc[0][y >> 3][x >> 3] && thePixels.pixels[y][x] != mc[1][y >> 3][x >> 3] && thePixels.pixels[y][x] != mcd800[y >> 3][x >> 3])
	    {
		thePixels.pixels[y][x] = getcolor(bg, mc[0][y >> 3][x >> 3], mc[1][y >> 3][x >> 3], mcd800[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}
	for (x = 1; x < thePixels.xsize; x += 2)
	{
	    if (thePixels.pixels[y][x] != bg && thePixels.pixels[y][x] != mci[0][y >> 3][x >> 3] && thePixels.pixels[y][x] != mci[1][y >> 3][x >> 3] && thePixels.pixels[y][x] != mcd800[y >> 3][x >> 3])
	    {
		thePixels.pixels[y][x] = getcolor(bg, mci[0][y >> 3][x >> 3], mci[1][y >> 3][x >> 3], mcd800[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}

    }
}

menu *
 addMenu(char *name)
{
    strcpy(theMenus[numMenus].title, name);
    theMenus[numMenus].numItems = 0;
    if (numMenus == 0)
    {
	theMenus[numMenus].xpos = 0;
    } else
    {
	theMenus[numMenus].xpos = theMenus[numMenus - 1].xpos + (strlen(theMenus[numMenus - 1].title) * 8) + 8;
    }
    theMenus[numMenus].xsize = strlen(theMenus[numMenus].title) * 8;
    /* required for menu highligthing to work - ooops! :) */
    theMenus[numMenus + 1].xpos = theMenus[numMenus].xpos + theMenus[numMenus].xsize;
    numMenus++;

    return &theMenus[numMenus - 1];
}

void
 addItem(menu * which, char *text, guiProc * where, int *theFlag)
{
    strcpy(which->items[which->numItems].text, text);
    which->items[which->numItems].proc = where;
    which->items[which->numItems].flag = theFlag;
    which->numItems++;
    if (which->msize < strlen(text) * 8 + 16)
	which->msize = strlen(text) * 8 + 16;
}

void
 do_open()
{
    new_dlg(&open_file);
}

void
 do_exit()
{
    quit = 1;
}

void
 setupMenus()
{
    menuFile = addMenu("File");
    addItem(menuFile, "New", do_new, NULL);
    addItem(menuFile, "Open", do_open, NULL);
    addItem(menuFile, "Save", do_save, NULL);
    addItem(menuFile, "Exit", do_exit, NULL);

    menuScreen = addMenu("Screen");
    addItem(menuScreen, "Zoom In", zoom_in, NULL);
    addItem(menuScreen, "Zoom Out", zoom_out, NULL);
    addItem(menuScreen, "Set Res", show_res_dlg, NULL);
    addItem(menuScreen, "Scrolling", toggleScroll, &doscroll);
    addItem(menuScreen, "Extended Color", toggle_ec, &extendedClr);
    addItem(menuScreen, "Palette Editor", edit_pal, NULL);    

    menuType = addMenu("Type");
    addItem(menuType, "$D016 Interlace", toggleHinterlace, &thePixels.hinterlace);
    addItem(menuType, "No $D016 Interlace", toggleYinterlace, &thePixels.vinterlace);
    addItem(menuType, "X Doubling", toggle_doublePix, &thePixels.doublePix);
    addItem(menuType, "Image Properties", show_set_type, NULL);
    

    menuPicture = addMenu("Picture");
    addItem(menuPicture, "Crop from here", show_dimension_dlg, NULL);
    addItem(menuPicture, "Crop to Screen", do_crop, NULL);
    addItem(menuPicture, "Convert to X Doubled", show_xdouble_dlg, NULL);
    addItem(menuPicture, "Plugins.....", use_filter, NULL);

    menuGrid = addMenu("Grid");
    addItem(menuGrid, "8x8", set8x8grid, NULL);
    addItem(menuGrid, "1x1", set1x1grid, NULL);
    addItem(menuGrid, "8x1", set8x1grid, NULL);
    addItem(menuGrid, "2x1", set2x1grid, NULL);
    addItem(menuGrid, "None", setnogrid, NULL);
}

void
 set8x8grid()
{
    gridx = gridy = 8;
    dirty = 1;

}

void
 set1x1grid()
{
    gridx = gridy = 1;
    dirty = 1;
}

void
 set8x1grid()
{
    gridx = 8;
    gridy = 1;
    dirty = 1;
}

void
 set2x1grid()
{
    gridx = 2;
    gridy = 1;
    dirty = 1;
}

void
 setnogrid()
{
    gridx = gridy = 0;
    dirty = 1;
}




void
 out_text(char *text)
{
    printf("%s", text);
}

void
 load_myFont()
{
    FILE *infile;
    int z, y, x;
    infile = fopen("myfont", "rb");
    for (z = 0; z < 256; z++)
    {
	for (y = 0; y < 16; y++)
	    for (x = 0; x < 8; x++)
	    {
		myFont[z][y][x] = fgetc(infile);
	    }
    }
}

void
 process_menu()
{
    int x;
/*  c_menu=numMenus; */
    if (mousey < 18)
    {
/*      c_menu=numMenus; */
	for (x = 0; x <= numMenus; x++)
	    if (mousex < theMenus[x].xpos)
	    {
		c_menu = x - 1;
		x = 999;
	    }
    }
/*    printf("%d: %d,%d\n",x,theMenus[numMenus-1].xpos,mousex); */
    if (mousey > (16 + theMenus[c_menu].numItems * 16))
	c_menu = -1;
    /* now, compute where on the menu */
    if (mousey > 16 && c_menu != -1)
	vindex = (mousey - 16) / 16;
    else
	vindex = -1;

    return;
}
void
 left_button()
{

    /* #define freehand_tool 0
     * #define line_tool 1
     * 
     * int tool=line_tool;
     * int ton=false;
     * int tlx=0;
     * int tly=0; */


    int x1, y1, x2, y2;

    x1 = (oldx >> xzoom) + xscroll;
    x2 = (mousex >> xzoom) + oxscroll;
    y1 = (oldy >> yzoom) + yscroll;
    y2 = (mousey >> yzoom) + oyscroll;


    /*   set_pixel((mousex>>xzoom)+xscroll,(mousey>>yzoom)+yscroll,pencolor); */
    switch (tool)
    {
    case freehand_tool:
	lynec(x1, y1, x2, y2, pencolor);
	break;
    case line_tool:
	if (tlon == false && (oldb != mouseb))
	{
	    tlon = true;
	    tlx = x2;
	    tly = y2;
	} else if (oldb != mouseb)
	{
	    lyne(tlx, tly, x2, y2, pencolor);
	    check_pic();
	    tlon = false;
	}
	break;
    case line_strip:
	if (tlon == false && (oldb != mouseb))
	{
	    tlon = true;
	    tlx = x2;
	    tly = y2;
	} else if (oldb != mouseb)
	{
	    lyne(tlx, tly, x2, y2, pencolor);
	    check_pic();
	    tlx = x2;
	    tly = y2;
	}
	break;
    case circle_tool:
	if (tlon == false && (oldb != mouseb))
	{
	    tlon = true;
	    tlx = x2;
	    tly = y2;
	} else if (oldb != mouseb)
	{
	    draw_circle(tlx, tly, tlx - x2, tly - y2);
	    tlon = false;
	}
	break;
    case line_fill:
	if (y2 > y1)
	{
	    for (tly = y1; tly <= y2; tly++)
		linefill(x2, tly, pencolor);
	} else
	{
	    for (tly = y2; tly <= y1; tly++)
		linefill(x2, tly, pencolor);
	}
	check_pic();
	break;
    case solid_fill:
	if (thePixels.doublePix == true)
	    x2 = (x2 & 0xffffffe);
	solidfill(x2, y2, pencolor);
	/*check_pic(); */
	break;
    case gradient_fill:
	if (oldb != mouseb)
	{
	    if (tlon == false && (oldb != mouseb))
	    {
		tlon = true;
		tlx = x2;
		tly = y2;
	    } else if (oldb != mouseb)
	    {
		int x, y, sta = 0;
		if (thePixels.doublePix == true)
		    x2 = (x2 & 0xffffffe);
		for (x = 0; x < thePixels.xsize; x++)
		    for (y = 0; y < thePixels.ysize; y++)
			if (thePixels.pixels[y][x] == FILL_MAGIC)
			    sta = 1;
		if (sta == 0)
		    solidfill(x2, y2, FILL_MAGIC);
		grad_fill(x2, y2, tlx, tly);
		tlon = false;
/*             check_pic(); */
		break;
	    }
	}
	break;
    }
    oldx = mousex;
    oldy = mousey;
    oxscroll = xscroll;
    oyscroll = yscroll;
}

void
 grad_fill(int x2, int y2, int x1, int y1)
{
    int maxx = 0, minx = 9999, maxy = 0, miny = 9999, step = 1, x, y;
    double line_angle, normal_angle, xscale, yscale;
	double *error;
	double *nexterror;
	double *tmp;

	/* allocate error */
	error = (double *) malloc((10000) * sizeof(double));
	nexterror = (double *) malloc((10000) * sizeof(double));

	if (error == NULL || nexterror == NULL)
	    abort();

	for (x = 0; x < 10000; x++)
	    error[x] = nexterror[x] = 0;    
    
    minx = 999999999;
    miny = 999999999;
    maxx = 0;
    maxy = 0;

    for (y = 0; y < thePixels.ysize; y++)
	for (x = 0; x < thePixels.xsize; x++)
	    if (thePixels.pixels[y][x] == FILL_MAGIC)
	    {
		if (y < miny)
		    miny = y;
		if (x < minx)
		    minx = x;
		if (y > maxy)
		    maxy = y;
		if (x > maxx)
		    maxx = x;

	    }

    /* caluculate line angle */
    {
	int opp, adj;
	adj = y1 - y2;
	opp = x1 - x2;
	line_angle = atan2((double) opp, (double) adj);
    }    
    if(thePixels.doublePix==true)step=2; else step=1;
    /* Normal Angle is line_angle+pi/2 */
    normal_angle=rad_bound(line_angle+(M_PI/2));
    
    for (y = 0; y < thePixels.ysize; y++)    
    {
	    tmp = error;
	    error = nexterror;
	    nexterror = tmp;
	    for (x = 0; x < 10000; x++)
		nexterror[x] = 0;    
       for (x = 0; x < thePixels.xsize; x+=step)       
       {
          int opp, adj;
          double e_angle1,e_angle2;
          double c_angle;
          
          /* find current angle */
          adj = y1 - y;
	  opp = x1 - x;
          e_angle1 = atan2((double) opp, (double) adj);
          /* find difference between it and line_angle */
          e_angle1 = rad_bound(e_angle1-line_angle);
          /* if it is below -pi/2 or above +pi/2, we are before the gradient 
             zone. so plot with color 0.
          */       
          if((e_angle1>(M_PI/2)) || (e_angle1<(-M_PI/2)))
          {
           if(thePixels.pixels[y][x] == FILL_MAGIC)
             set_pixel(x, y, gradColors[0]);                       
          }
          else
          {
             /* do the same check as above, but at the other end of the line */
             adj=y2-y;
             opp=x2-x;
             e_angle2 = atan2((double) opp, (double) adj);
             e_angle2 = rad_bound(e_angle2-line_angle);
             if((e_angle2<(M_PI/2)) && (e_angle2>(-M_PI/2)))
             {
               if(thePixels.pixels[y][x] == FILL_MAGIC)             
                set_pixel(x, y, gradColors[numColors-1]);
             }
             else             
             {   
                /* We are, infact, in the gradient area. */
                int xl,yl;
                double hyp;
                double short_a,long_a;
                double cpos;
                double pc;
                int cc;
                /* get the length of the short segment */
                xl=x1-x;
                yl=y1-y;
                hyp=sqrt(xl*xl+yl*yl);
                short_a=hyp*cos(e_angle1);
                
                /* get the length of the long segment */
                xl=x1-x2;
                yl=y1-y2;
                long_a=sqrt(xl*xl+yl*yl);
                
                /* get the pos that we are at */
                cpos=fabs(short_a/long_a);
                
                /* test -> cpos*16 :) */
                cc=(int)floor(cpos*(numColors-1));
                
                pc=(cpos*(numColors-1))-cc;
                /* dither it, myfriend :) */
                {
		    double newval, cerror;
		    int tv;
                                        
		    newval = pc + error[x / step];
		    newval = floor(newval + 0.5);
		    if (newval < 0)
			newval = 0;
		    if (newval > 1)
			newval = 1;
		    tv = newval;

		    cerror = pc + error[x / step] - tv;		    
		    nexterror[x / step] += cerror * 5 / 16;
		    error[x / step + 1] += cerror * 7 / 16;
		    nexterror[x / step + 1] += cerror * 1 / 16;
		    if (x != 0)
		    {
			nexterror[x / step - 1] += cerror * 3 / 16;
		    }
                    if(thePixels.pixels[y][x] == FILL_MAGIC)
                    {
                    if (tv == 0)
                       set_pixel(x, y, gradColors[cc]);
                    else
                       set_pixel(x, y, gradColors[cc+1]);
                    }
                }
                /*set_pixel(x, y, gradColors[cc+1]);*/
             }
          }
       }
    }

//


/*            pcy=(y-miny);
 * pcx=(rx-minx);
 * 
 * pcy/=(double)(maxy-miny);
 * pcx/=(double)(maxx-minx);            
 * 
 * pc=(pcx*xscale)+(pcy*yscale);            
 * #define dfactor 8
 * #define dpow 256
 * #define ddiv 0.00390625
 * #define dand 255
 * 
 * 
 * pc*=((numColors<<dfactor)-(dand-1));
 * cc2=(int)pc;
 * ccolor=(cc2>>dfactor);
 * pc=(ddiv);
 * pc*=(double)(cc2&dand);
 * ds=pc;            
 * 
 * for(k=0;k<256;k++)
 * {
 * cs+=ds;
 * if (cs>=1.0)
 * {
 * pattern[k]=ccolor+1;
 * cs-=1;
 * }
 * else pattern[k]=ccolor;
 * }
 * 
 * ccolor=pattern[(x+doffs)&255];
 * set_pixel(rx,y,gradColors[ccolor]); */

/*         set_text(); */
}

double rad_bound(double ang)
{
   double work_ang;
   work_ang=ang;
   do {
      if (work_ang > M_PI) work_ang-=(2*M_PI);
      if (work_ang < (-M_PI)) work_ang+=(2*M_PI);      
   } while ((work_ang < (-M_PI)) || (work_ang > M_PI));
   return work_ang;
}

void
 linefill(int x, int y, int c)
{
    int xp, yp, oc, dx;
    /*oc=thePixels.pixels[y][x];   */
    /* This doesnt work with double X on -> and for good reason */
    dx = thePixels.doublePix;
    thePixels.doublePix = false;
    oc = get_pixel(x, y);
    yp = y;
    for (xp = x; oc == get_pixel(xp, yp) && xp < thePixels.xsize; xp++)
	set_pixel(xp, yp, c);

    for (xp = x - 1; oc == get_pixel(xp, yp) && xp > 0; xp--)
	set_pixel(xp, yp, c);

    thePixels.doublePix = dx;
}

void
 solidfill(int x, int y, int c)
{
    int fstack[500000][2];	/* I hope this is big enuf ;) */
    int sp = 0;
    int c2m;
    int xs = 1;
    int mmm = 0;
    if ((thePixels.doublePix == true || thePixels.vinterlace == true) /*&& c != FILL_MAGIC*/)
	xs = 2;
    c2m = get_pixel(x, y);
    if (c2m == c)
	return;
    fstack[sp][0] = x;
    fstack[sp][1] = y;
    sp++;
    do
    {
	int cx, cy;
	sp--;
	cx = fstack[sp][0];
	cy = fstack[sp][1];
/*     printw("%d,%d,%d\n",cx,cy,sp); */

	if (c2m == get_pixel(cx, cy))
	{
	    set_pixel(cx, cy, c);
	    mmm++;
/*	    if (mmm == 10)
	    {
		draw_screen();
		blitIt;
		mmm = 0;
	    }*/
	}
	if (cy > 0)
	    if (c2m == get_pixel(cx, cy - 1))
	    {
		fstack[sp][0] = cx;
		fstack[sp][1] = cy - 1;
		sp++;
	    }
	if (cy < (thePixels.ysize))
	    if (c2m == get_pixel(cx, cy + 1))
	    {
		fstack[sp][0] = cx;
		fstack[sp][1] = cy + 1;
		sp++;
	    }
	if (cx >= xs)
	    if (c2m == get_pixel(cx - xs, cy))
	    {
		fstack[sp][0] = cx - xs;
		fstack[sp][1] = cy;
		sp++;
	    }
	if (cx < thePixels.xsize)
	    if (c2m == get_pixel(cx + xs, cy))
	    {
		fstack[sp][0] = cx + xs;
		fstack[sp][1] = cy;
		sp++;
	    }
    }
    while (sp != 0);
}


void
 check_pic()
{
    switch (thePixels.type)
    {
    case multicolor:
	convert_multicolor();
    case MCI:
	convert_MCI();
	break;
    case FLI:
	convert_FLI();
    case IFLI:
	convert_IFLI();
	break;
    }
}

void
 set_pixel(int x, int y, int c)
{
    if ((x < 0) || (y < 0))
	return;
    if ((thePixels.type == FLI || thePixels.type == IFLI) && x < 24)
	return;
    if (x > thePixels.xsize || y > thePixels.ysize)
	return;

    dirty = 1;
    if (y > db)
	db = y;
    if (y < dt)
	dt = y;

    if (x > dr)
	dr = x;
    if (x < dl)
	dl = x;

    if (c == FILL_MAGIC)
    {
	thePixels.pixels[y][x] = FILL_MAGIC;
	return;
    }
    if (extendedClr == true)
    {
	/*y = y / 2; */
	int moo;
	int c1, c2;
	moo = x + y;
	if ((moo & 1) == 1)
	{
	    c1 = (c & 15);
	    c2 = ((c >> 4) & 15);
	    c = (c1 << 4) + c2;
	}
    } else
    {
	int c1;
	c1 = (c & 15) + ((c & 15) << 4);
	c = c1;
    }
    if (thePixels.doublePix == true)
    {
	if ((x & 1) == 1)
	{
	    int c1, c2;
	    c1 = (c & 15);
	    c2 = ((c >> 4) & 15);
	    c = (c1 << 4) + c2;
	}
	x = x & ~1;
	thePixels.pixels[y][x + 1] = ((c >> 4) & 15);
    }
    thePixels.pixels[y][x] = (c & 15);
}

void
 set_pixel_checked(int x, int y, int c)
{
    if ((x < 0) || (y < 0))
	return;
    if ((thePixels.type == FLI || thePixels.type == IFLI) && x < 24)
	return;
    if (x > thePixels.xsize || y > thePixels.ysize)
	return;

    dirty = 1;
    if (y > db)
	db = y;
    if (y < dt)
	dt = y;

    if (x > dr)
	dr = x;
    if (x < dl)
	dl = x;

    if (c == FILL_MAGIC)
    {
	thePixels.pixels[y][x] = FILL_MAGIC;
	return;
    }
    if (extendedClr == true)
    {
	/*y = y / 2; */
	int moo;
	int c1, c2;
	moo = x + y;
	if ((moo & 1) == 1)
	{
	    c1 = (c & 15);
	    c2 = ((c >> 4) & 15);
	    c = (c1 << 4) + c2;
	}
    } else
    {
	int c1;
	c1 = (c & 15) + ((c & 15) << 4);
	c = c1;
    }
    if (thePixels.doublePix == true)
    {
	if ((x & 1) == 1)
	{
	    int c1, c2;
	    c1 = (c & 15);
	    c2 = ((c >> 4) & 15);
	    c = (c1 << 4) + c2;
	}
	x = x & ~1;
	thePixels.pixels[y][x + 1] = ((c >> 4) & 15);
	checkpixel(x + 1, y, ((c >> 4) & 15));
    }
    thePixels.pixels[y][x] = (c & 15);
    checkpixel(x, y, (c & 15));
}

void
 set_pixel_sized(int x, int y, int c)
{
    int xp;
    int yp;

    for (yp = (-pensize); yp < pensize; yp++)
	for (xp = (-pensize); xp < pensize; xp++)
	{
	    int sx;
	    double sv;
	    sx = (xp * xp + yp * yp);
	    sv = sqrt((double) sx);
	    if (sv < (double) (pensize))
	    {
		set_pixel_checked(xp + x, yp + y, c);
	    }
	}
    set_pixel_checked(x, y, c);
}
void
 set_pixel_sized_nocheck(int x, int y, int c)
{
    int xp;
    int yp;
    for (yp = (-pensize); yp < pensize; yp++)
	for (xp = (-pensize); xp < pensize; xp++)
	{
	    int sx;
	    double sv;
	    sx = (xp * xp + yp * yp);
	    sv = sqrt((double) sx);
	    if (sv < (double) pensize)
	    {

		set_pixel(xp + x, yp + y, c);
	    }
	}
    set_pixel(x, y, c);

}

int
 get_pixel(int x, int y)
{
    int c;
    c = 0;
    if ((thePixels.type == FLI || thePixels.type == IFLI) && x < 24)
	return 0;

    if (extendedClr == true)
    {
	int c1, c2;
	x *= 2;
	x /= 2;
	c = (thePixels.pixels[y][x + 1] >> 4);
	c += thePixels.pixels[y][x];

	if ((y & 1) == 1)
	{
	    c1 = (c & 15);
	    c2 = ((c >> 4) & 15);
	    c = (c1 << 4) + c2;
	}
    } else
    {
	c += thePixels.pixels[y][x];
    }

    return c;
}


void
 checkpixel(int x, int y, int c)
{
    switch (thePixels.type)
    {
    case multicolor:
	check_multicolor(x, y, c);
	break;
    case FLI:
	check_FLI(x, y, c);
	break;
    case AFLI:
	check_AFLI(x, y, c);
	break;        
    case MCI:
	check_MCI(x, y, c);
	break;
    case IFLI:
	check_IFLI(x, y, c);
	break;
    case Hires:
       	check_hires(x,y,c);
        break;
    }
}


void
 draw_screen()
{
    short x, y, p, z;
    int mode, ypan;

    if (vtog == 0)
	vtog = 1;
    else
	vtog = 0;

    if (ilp == 0)
    {
	ilp += 1;
    } else
    {
	ilp -= 1;
    }

    /*  the *new and improved* draw routing..... (will be a lot faster :P) */
#define MODE_ZOOM 1
#define MODE_HINT 2
#define MODE_VINT 4
#define MODE_GRID 8
#define virtx 640
#define virty 2048
    mode = 0;
    if (xzoom != 0)
	mode += MODE_ZOOM;
    if (thePixels.hinterlace == true)
	mode += MODE_HINT;
    if (thePixels.vinterlace == true)
	mode += MODE_VINT;
    if (gridx != 0)
	mode += MODE_GRID;


    if (((mode & MODE_HINT) == 0) && ((mode & MODE_VINT) == 0))
	ilp = 0;

    ypan = ((yscroll) << xzoom);
    xpan = ((xscroll) << xzoom);

    if ((dirty == 1) || (mode != oldmode) || (xzoom != ozoom) || (gridx != ogrid))
    {
	int ys, ye, xs, xe, xsz;
/*   if( ((mode&MODE_ZOOM)==0) && ((mode&MODE_GRID)==0) ) */

	if (db >= dt)
	{
	    ys = dt - 9;
	    ye = db + 9;
	} else
	{
	    ys = 0;
	    ye = thePixels.ysize;
	}



	if (dr >= dl)
	{
	    xs = dl - 9;
	    xe = dr + 9;
	    xsz = xe - xs;
	} else
	{
	    xs = 0;
	    xe = thePixels.xsize;
	    xsz = thePixels.xsize;
	}



	switch (mode)
	{
	    int z, zx, zy, yz, xz, zx2;
	case 0:
	    /* Standard Line draw */
	    for (y = ys; y < ye; y++)
		memcpy(&pic_calc[0][y][xs], &thePixels.pixels[y][xs], xsz);
	    break;

	case MODE_ZOOM:
	    zx = (1 << xzoom);
	    for (y = ys; y < ye; y++)
	    {
		yz = (y << yzoom);
		for (x = xs; x < xe; x++)
		{
		    xz = (x << xzoom);
		    for (zy = 0; zy < zx; zy++)
			memset(&pic_calc[0][yz + zy][xz], thePixels.pixels[y][x], zx);
		}
	    }
	    break;

	case MODE_HINT:	/* ==2 */
	    xs = xs & ~1;
	    xe = xe & ~1;
	    for (y = ys; y < ye; y++)
	    {
		z = y + yscroll;
		for (x = xs; x < xe; x += 2)
		{
		    pic_calc[0][y][x] = pic_calc[0][y][x + 1] = thePixels.pixels[y][x];
		    pic_calc[1][y][x + 1] = pic_calc[1][y][x + 2] = thePixels.pixels[y][x + 1];
		}
	    }
	    break;

	case MODE_HINT + MODE_ZOOM:	/* == 3 */
	    zx = (1 << xzoom);
	    zx2 = zx + zx;
	    xs = xs & ~1;
	    xe = xe & ~1;
	    for (y = ys; y < ye; y++)
	    {
		yz = (y << yzoom);
		for (x = xs; x < xe; x += 2)
		{
		    xz = (x << xzoom);
		    for (zy = 0; zy < zx; zy++)
		    {
			memset(&pic_calc[0][yz + zy][xz], thePixels.pixels[y][x], zx2);
			memset(&pic_calc[1][yz + zy][xz + zx], thePixels.pixels[y][x + 1], zx2);
		    }
		}
	    }
	    break;

	case MODE_VINT:	/* == 4 */
	    xs = xs & ~1;
	    xe = xe & ~1;
	    for (y = ys; y < ye; y++)
	    {
		z = y + yscroll;
		for (x = xs; x < xe; x += 2)
		{
		    pic_calc[0][y][x] = pic_calc[0][y][x + 1] = thePixels.pixels[y][x];
		    pic_calc[1][y][x] = pic_calc[1][y][x + 1] = thePixels.pixels[y][x + 1];
		}
	    }
	    break;
	case MODE_VINT + MODE_ZOOM:
	    zx = (1 << xzoom);
	    zx2 = zx + zx;
	    xs = xs & ~1;
	    xe = xe & ~1;
	    for (y = ys; y < ye; y++)
	    {
		yz = (y << yzoom);
		for (x = xs; x < xe; x += 2)
		{
		    xz = (x << xzoom);
		    for (zy = 0; zy < zx; zy++)
		    {
			memset(&pic_calc[0][yz + zy][xz], thePixels.pixels[y][x], zx2);
			memset(&pic_calc[1][yz + zy][xz], thePixels.pixels[y][x + 1], zx2);
		    }
		}
	    }
	    break;

	case MODE_VINT + MODE_HINT:	/* == 6 */
	case MODE_VINT + MODE_HINT + MODE_ZOOM:	/* == 7 */

	    printf("This should never Happen -> Vinterlace and Hinterlace together?????\n");
	    abort();

	    break;


	case MODE_GRID:	/* == 8 */
	    /* Standard Line draw */
	    for (y = ys; y < ye; y++)
		memcpy(&pic_calc[0][y][xs], &thePixels.pixels[y][xs], xsz);
	    /* now add on the grid */
	    {
		int xstep;
		int ystep;
		int xstart;
		int ystart;
		int xend;
		int yend;

		xstep = (gridx << xzoom);
		ystep = (gridy << yzoom);
		xstart = ((xs - (xs % gridx)) << xzoom);
		ystart = ((ys - (ys % gridy)) << yzoom);
		xend = (xe << xzoom);
		yend = (ye << yzoom);

		for (x = xstart; x < xend; x++)
		    for (y = ystart; y < yend; y += ystep)
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;

		for (x = xstart; x < xend; x += xstep)
		    for (y = ystart; y < yend; y++)
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
	    }
	    break;

	case MODE_GRID + MODE_ZOOM:	/* == 9 */
	    zx = (1 << xzoom);
	    for (y = ys; y < ye; y++)
	    {
		yz = (y << yzoom);
		for (x = xs; x < xe; x++)
		{
		    xz = (x << xzoom);
		    for (zy = 0; zy < zx; zy++)
			memset(&pic_calc[0][yz + zy][xz], thePixels.pixels[y][x], zx);
		}
	    }
	    {
		int xstep;
		int ystep;
		int xstart;
		int ystart;
		int xend;
		int yend;

		xstep = (gridx << xzoom);
		ystep = (gridy << yzoom);
		xstart = ((xs - (xs % gridx)) << xzoom);
		ystart = ((ys - (ys % gridy)) << yzoom);
		xend = (xe << xzoom);
		yend = (ye << yzoom);

		for (x = xstart; x < xend; x++)
		    for (y = ystart; y < yend; y += ystep)
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;

		for (x = xstart; x < xend; x += xstep)
		    for (y = ystart; y < yend; y++)
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
	    }
	    break;


	case MODE_GRID + MODE_HINT:	/* == 10 -> how the fuck do i handle this fucker??? */
	    xs = xs & ~1;
	    xe = xe & ~1;
	    for (y = ys; y < ye; y++)
	    {
		z = y + yscroll;
		for (x = xs; x < xe; x += 2)
		{
		    pic_calc[0][y][x] = pic_calc[0][y][x + 1] = thePixels.pixels[y][x];
		    pic_calc[1][y][x + 1] = pic_calc[1][y][x + 2] = thePixels.pixels[y][x + 1];
		}
	    }
	    {
		int xstep;
		int ystep;
		int xstart;
		int ystart;
		int xend;
		int yend;

		xstep = (gridx << xzoom);
		ystep = (gridy << yzoom);
		xstart = ((xs - (xs % gridx)) << xzoom);
		ystart = ((ys - (ys % gridy)) << yzoom);
		xend = (xe << xzoom);
		yend = (ye << yzoom);

		for (x = xstart; x < xend; x++)
		    for (y = ystart; y < yend; y += ystep)
		    {
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
			pic_calc[1][y][x + 1] = pic_calc[1][y][x] | 64;
		    }

		for (x = xstart; x < xend; x += xstep)
		    for (y = ystart; y < yend; y++)
		    {
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
			pic_calc[1][y][x + 1] = pic_calc[1][y][x] | 64;
		    }
	    }
	    break;

	case MODE_GRID + MODE_HINT + MODE_ZOOM:	/* == 11 -> */
	    zx = (1 << xzoom);
	    zx2 = zx + zx;
	    xs = xs & ~1;
	    xe = xe & ~1;
	    for (y = ys; y < ye; y++)
	    {
		yz = (y << yzoom);
		for (x = xs; x < xe; x += 2)
		{
		    xz = (x << xzoom);
		    for (zy = 0; zy < zx; zy++)
		    {
			memset(&pic_calc[0][yz + zy][xz], thePixels.pixels[y][x], zx2);
			memset(&pic_calc[1][yz + zy][xz + zx], thePixels.pixels[y][x + 1], zx2);
		    }
		}
	    }
	    {
		int xstep;
		int ystep;
		int xstart;
		int ystart;
		int xend;
		int yend;

		xstep = (gridx << xzoom);
		ystep = (gridy << yzoom);
		xstart = ((xs - (xs % gridx)) << xzoom);
		ystart = ((ys - (ys % gridy)) << yzoom);
		xend = (xe << xzoom);
		yend = (ye << yzoom);

		for (x = xstart; x < xend; x++)
		    for (y = ystart; y < yend; y += ystep)
		    {
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
			pic_calc[1][y][x + (1 << xzoom)] = pic_calc[1][y][x] | 64;
		    }

		for (x = xstart; x < xend; x += xstep)
		    for (y = ystart; y < yend; y++)
		    {
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
			pic_calc[1][y][x + (1 << xzoom)] = pic_calc[1][y][x] | 64;
		    }
	    }
	    break;

	case MODE_GRID + MODE_VINT:	/* == 12         */
	    xs = xs & ~1;
	    xe = xe & ~1;
	    for (y = ys; y < ye; y++)
	    {
		z = y + yscroll;
		for (x = xs; x < xe; x += 2)
		{
		    pic_calc[0][y][x] = pic_calc[0][y][x + 1] = thePixels.pixels[y][x];
		    pic_calc[1][y][x] = pic_calc[1][y][x + 1] = thePixels.pixels[y][x + 1];
		}
	    }
	    {
		int xstep;
		int ystep;
		int xstart;
		int ystart;
		int xend;
		int yend;

		xstep = (gridx << xzoom);
		ystep = (gridy << yzoom);
		xstart = ((xs - (xs % gridx)) << xzoom);
		ystart = ((ys - (ys % gridy)) << yzoom);
		xend = (xe << xzoom);
		yend = (ye << yzoom);

		for (x = xstart; x < xend; x++)
		    for (y = ystart; y < yend; y += ystep)
		    {
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
			pic_calc[1][y][x] = pic_calc[1][y][x] | 64;
		    }

		for (x = xstart; x < xend; x += xstep)
		    for (y = ystart; y < yend; y++)
		    {
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
			pic_calc[1][y][x] = pic_calc[1][y][x] | 64;
		    }
	    }
	    break;
	case MODE_GRID + MODE_ZOOM + MODE_VINT:	/* == 13 */
	    zx = (1 << xzoom);
	    zx2 = zx + zx;
	    xs = xs & ~1;
	    xe = xe & ~1;
	    for (y = ys; y < ye; y++)
	    {
		yz = (y << yzoom);
		for (x = xs; x < xe; x += 2)
		{
		    xz = (x << xzoom);
		    for (zy = 0; zy < zx; zy++)
		    {
			memset(&pic_calc[0][yz + zy][xz], thePixels.pixels[y][x], zx2);
			memset(&pic_calc[1][yz + zy][xz], thePixels.pixels[y][x + 1], zx2);
		    }
		}
	    }
	    {
		int xstep;
		int ystep;
		int xstart;
		int ystart;
		int xend;
		int yend;

		xstep = (gridx << xzoom);
		ystep = (gridy << yzoom);
		xstart = ((xs - (xs % gridx)) << xzoom);
		ystart = ((ys - (ys % gridy)) << yzoom);
		xend = (xe << xzoom);
		yend = (ye << yzoom);

		for (x = xstart; x < xend; x++)
		    for (y = ystart; y < yend; y += ystep)
		    {
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
			pic_calc[1][y][x] = pic_calc[1][y][x] | 64;
		    }

		for (x = xstart; x < xend; x += xstep)
		    for (y = ystart; y < yend; y++)
		    {
			pic_calc[0][y][x] = pic_calc[0][y][x] | 64;
			pic_calc[1][y][x] = pic_calc[1][y][x] | 64;
		    }
	    }
	    break;
	}
    }
    dirty = 0;
    oldmode = mode;
    ozoom = xzoom;
    ogrid = gridx;
    db = 0;
    dt = 10000;
    dr = 0;
    dl = 10000;

    for (y = 0; y < yres; y++)
    {
/*      printf("%d\n",y); */
	memcpy(double_buffer[y], &pic_calc[ilp][y + ypan][xpan], xres);
    }
    /* Draw the current tool prv */

    if (tool == freehand_tool && mouseb != 0)
	tlon = false;
    else if (tool == freehand_tool)
	tlon = true;
    if (tlon == true)
	switch (tool)
	{
	    int xp1, xp2, yp1, yp2, xradius, yradius;
	case freehand_tool:
	    for (yp1 = (-(pensize * (xzoom + 1))); yp1 < (pensize * (xzoom + 1)); yp1++)
		for (xp1 = (-(pensize * (xzoom + 1))); xp1 < (pensize * (xzoom + 1)); xp1++)
		{
		    int sx;
		    double sv;
		    sx = (xp1 * xp1 + yp1 * yp1);
		    sv = sqrt((double) sx);
		    if (sv < (double) (pensize * (xzoom + 1)))
			double_buffer[mousey + yp1][mousex + xp1] = ((pencolor + 1) & 15);
		}
	    break;
	case line_tool:
	case line_strip:
	case gradient_fill:
	    xp1 = (tlx - xscroll) << xzoom;

	    xp2 = mousex;
	    yp1 = (tly - yscroll) << yzoom;
	    yp2 = mousey;
	    xorlyne(xp1, yp1, xp2, yp2, pencolor);
	    break;
	case circle_tool:
	    xp1 = (tlx - xscroll) << xzoom;
	    xp2 = mousex;
	    yp1 = (tly - yscroll) << yzoom;
	    yp2 = mousey;
	    xradius = (xp1 - xp2);
	    yradius = (yp1 - yp2);
	    std_circle(xp1, yp1, xradius, yradius);
	    break;
	}
/*}        */
    if (showMenu == 1 || currentDlg != NULL)
	ptr = 1;
    else
	ptr = 0;
    if (showMenu == 1)
    {
	int t;

	/* put on color selecter */
	if (extendedClr != true)
	{
	    for (y = (yres - 16); y < yres; y++)
		memcpy(double_buffer[y], colorbar, (xres - 16));
	    /* dbl fix */

	} else
	{
	    int pb;
	    pb = 128 / numPens;
	    if (vtog == 0)

		for (z = 0; z < numPens; z++)
		{
		    for (y = (yres - (pb * (z + 1))); y < (yres - (pb * z)); y += 2)
		    {
			memcpy(double_buffer[y], colorbar, (xres - 16));
			memset(double_buffer[y + 1], color_order[z], (xres - 16));
		    }
	    } else
		for (z = 0; z < numPens; z++)
		{
		    for (y = (yres - (pb * (z + 1))); y < (yres - (pb * z)); y += 2)
		    {
			memset(double_buffer[y], color_order[z], (xres - 16));
			memcpy(double_buffer[y + 1], colorbar, (xres - 16));
		    }
		}
	}


	for (y = 0; y < 16; y++)
	    memset(double_buffer[y], y + 17, xres);

	/* code 2 put text 4 menu will go in here rsn. */
	if (c_menu != -1)
	{
	    for (y = 0; y < 16; y++)
		memset(&double_buffer[y][theMenus[c_menu].xpos], y + 33, (theMenus[c_menu + 1].xpos - theMenus[c_menu].xpos));

	    /* draw the dropdown for the menu */
	    /* first, makje sure it *has* a pull down :P */
/*        if (theMenus[c_menu].numItems != 0) */
	    {
		int ysize, shade, cshade, dshade;
		/* draw the space for the menu */
		ysize = theMenus[c_menu].numItems * 16;

		/* draw the rectangle for it */
		shade = ysize / 16;
		cshade = 0;
		dshade = 0;
		for (y = 0; y < ysize; y++)
		{
		    cshade++;
		    if (cshade == shade)
		    {
			cshade = 0;
			dshade++;
		    }
		    memset(&double_buffer[y + 16][theMenus[c_menu].xpos], 17 + dshade, theMenus[c_menu].msize);
		}
		/* put select bar here! */
		if (vindex != -1)
		    for (y = 0; y < 16; y++)
			memset(&double_buffer[y + vindex * 16 + 17][theMenus[c_menu].xpos], 33 + y, theMenus[c_menu].msize);
		/* put the text for each menu item */
		for (p = 0; p < theMenus[c_menu].numItems; p++)
		    textOut(theMenus[c_menu].items[p].text, theMenus[c_menu].xpos + 8, (p + 1) * 16);

		/* Check if the value is a active flag, and if so, put the tick! */
		for (p = 0; p < theMenus[c_menu].numItems; p++)
		    if (theMenus[c_menu].items[p].flag != NULL)
			if (*theMenus[c_menu].items[p].flag == true)
			    textOut("%", theMenus[c_menu].xpos, (p + 1) * 16);
	    }
	}
	/* put the text for main menus */
	for (p = 0; p < numMenus; p++)
	{
	    int q;
	    q = 0;
	    textOut(theMenus[p].title, theMenus[p].xpos, 0);
	}

	/* draw the tools */
	for (t = 0; t < 8; t++)
	    for (y = 0; y < 16; y++)
		for (x = 0; x < 16; x++)
		{
		    int tp;
		    tp = tools[t][y][x];
		    if (tp == 38 && tool == t)
			tp -= 16;
		    double_buffer[y + (t + 1) * 20][x + (xres - 16)] = tp;
		}
    }
    draw_dlg();

    /* Put on mouse cursor - not on GUI systems tho :P */
    for (x = 0; x < 8; x++)
	for (y = 0; y < 8; y++)
	{
	    if (mouse[ptr][y][x] != 0)
	    {
		if (mouse[ptr][y][x] == 17)
		    double_buffer[y + mousey + offsy[ptr]][x + mousex + offsx[ptr]] =
			(double_buffer[y + mousey + offsy[ptr]][x + mousex + offsx[ptr]] ^ 1) & 1;
		else
		    double_buffer[y + mousey + offsy[ptr]][x + mousex + offsx[ptr]] = mouse[ptr][y][x];
	    }
	}

}

void
 std_circle(int xp, int yp, int xrad, int yrad)
{
    int tx, ty;
    int ox, oy;
    double tp, ta;
    ox = xp;
    oy = yp + yrad;
    for (ta = 0; ta < 6.24; ta += .01)
    {
	tp = sin(ta);
	tp *= xrad;
	tx = xp + tp;

	tp = cos(ta);
	tp *= yrad;
	ty = yp + tp;
	xorlyne(ox, oy, tx, ty, pencolor);
	ox = tx;
	oy = ty;
    }
}

void
 draw_circle(int xp, int yp, int xrad, int yrad)
{
    int tx, ty;
    int ox, oy;
    double tp, ta;
    ox = xp;
    oy = yp + yrad;
    for (ta = 0; ta < (2 * M_PI); ta += .01)
    {
	tp = sin(ta);
	tp *= xrad;
	tx = xp + tp;

	tp = cos(ta);
	tp *= yrad;
	ty = yp + tp;
	lyne(ox, oy, tx, ty, pencolor);
	ox = tx;
	oy = ty;
    }
    check_pic();
}


void
 textOut(char *inString, short xp, short yp)
{
    int x, y;
    int q;
    for (q = 0; inString[q] != 0; q++)
    {
	for (x = 0; x < 8; x++)
	    for (y = 0; y < 16; y++)
	    {
		char r = myFont[(int) inString[q]][y][x];
		if (r != 0)
		    double_buffer[y + yp][x + xp + q * 8] = r;
	    }
    }
}
void
 check_multicolor(int x, int y, int c)
{
    int x8, y8;
    x8 = (x >> 3);
    y8 = (y >> 3);

    if (c == bg)
	return;
    if (c == mc[0][y8][x8])
	return;
    if (c == mc[1][y8][x8])
	return;
    if (c == mcd800[y8][x8])
	return;

    /* and check for those funkee dups again */
    if (bg == mcd800[y8][x8])
    {
	mcd800[y8][x8] = c;
	return;
    }
    if (bg == mc[0][y8][x8])
    {
	mc[0][y8][x8] = c;
	return;
    }
    if (bg == mc[1][y8][x8])
    {
	mc[1][y8][x8] = c;
	return;
    }
    if (mcd800[y8][x8] == mc[0][x8][y8])
    {
	mc[0][y8][x8] = c;
	return;
    }
    if (mcd800[y8][x8] == mc[1][x8][y8])
    {
	mc[1][y8][x8] = c;
	return;
    }
    if (mc[0][y8][x8] == mc[1][x8][y8])
    {
	mc[1][y8][x8] = c;
	return;
    }
    recheck_multicolor(x8, y8);
}

void
 check_hires(int x, int y, int c)
{
    int x8, y8;
    x8 = (x >> 3);
    y8 = (y >> 3);
    if (c == mc[0][y8][x8])
	return;
    if (c == mc[1][y8][x8])
	return;

    /* and check for those funkee dups again */
    if (mc[0][y8][x8] == mc[1][x8][y8])
    {
	mc[1][y8][x8] = c;
	return;
    }
    recheck_hires(x8, y8);
}


void
 check_MCI(int x, int y, int c)
{
    int x8, y8;
    x8 = (x >> 3);
    y8 = (y >> 3);
    if ((x & 1) == 0)
    {
	if (c == bg)
	    return;
	if (c == mc[0][y8][x8])
	    return;
	if (c == mc[1][y8][x8])
	    return;
	if (c == mcd800[y8][x8])
	    return;
	/* and check for those funkee dups again */
	if (bg == mcd800[y8][x8])
	{
	    mcd800[y8][x8] = c;
	    return;
	}
	if (bg == mc[0][y8][x8])
	{
	    mc[0][y8][x8] = c;
	    return;
	}
	if (bg == mc[1][y8][x8])
	{
	    mc[1][y8][x8] = c;
	    return;
	}
	if (mcd800[y8][x8] == mc[0][x8][y8])
	{
	    mc[0][y8][x8] = c;
	    return;
	}
	if (mcd800[y8][x8] == mc[1][x8][y8])
	{
	    mc[1][y8][x8] = c;
	    return;
	}
	if (mc[0][y8][x8] == mc[1][x8][y8])
	{
	    mc[1][y8][x8] = c;
	    return;
	}
    } else
    {
	if (c == bg)
	    return;
	if (c == mci[0][y8][x8])
	    return;
	if (c == mci[1][y8][x8])
	    return;
	if (c == mcd800[y8][x8])
	    return;
	/* and check for those funkee dups again */
	if (bg == mcd800[y8][x8])
	{
	    mcd800[y8][x8] = c;
	    return;
	}
	if (bg == mci[0][y8][x8])
	{
	    mci[0][y8][x8] = c;
	    return;
	}
	if (bg == mci[1][y8][x8])
	{
	    mci[1][y8][x8] = c;
	    return;
	}
	if (mcd800[y8][x8] == mci[0][x8][y8])
	{
	    mci[0][y8][x8] = c;
	    return;
	}
	if (mcd800[y8][x8] == mci[1][x8][y8])
	{
	    mci[1][y8][x8] = c;
	    return;
	}
	if (mci[0][y8][x8] == mci[1][x8][y8])
	{
	    mci[1][y8][x8] = c;
	    return;
	}
    }
    recheck_MCI(x8, y8);
}


void
 recheck_multicolor(int x8, int y8)
{
    int x2, y2, used[256], x, y, c, max, maxc;
    max = maxc = 0;
    /* get the 3 multicolors for each 8x8 block now */
    for (c = 0; c < 17; c++)
	used[c] = 0;
    for (y2 = 0; y2 < 8; y2++)
	for (x2 = 0; x2 < 8; x2++)
	    used[thePixels.pixels[(y8 << 3) + y2][(x8 << 3) + x2]]++;

    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != bg)
	{
	    max = used[c];
	    maxc = c;
	}
    }

    mcd800[y8][x8] = maxc;
    max = 0;

    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != bg && c != mcd800[y8][x8])
	{
	    max = used[c];
	    maxc = c;
	}
    }

    mc[0][y8][x8] = maxc;
    max = 0;


    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != bg && c != mcd800[y8][x8] && c != mc[0][y8][x8])
	{
	    max = used[c];
	    maxc = c;
	}
    }

    mc[1][y8][x8] = maxc;

    for (y = (y8 << 3); y < ((y8 << 3) + 8); y++)
	for (x = (x8 << 3); x < ((x8 << 3) + 8); x++)
	{
	    if (thePixels.pixels[y][x] != bg && thePixels.pixels[y][x] != mc[0][y8][x8] && thePixels.pixels[y][x] != mc[1][y8][x8] && thePixels.pixels[y][x] != mcd800[y8][x8])
	    {
		thePixels.pixels[y][x] = getcolor(bg, mc[0][y >> 3][x >> 3], mc[1][y >> 3][x >> 3], mcd800[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}

}

void
 recheck_hires(int x8, int y8)
{
    int x2, y2, used[256], x, y, c, max, maxc;
    max = maxc = 0;
    /* get the 3 multicolors for each 8x8 block now */
    for (c = 0; c < 17; c++)
	used[c] = 0;
    for (y2 = 0; y2 < 8; y2++)
	for (x2 = 0; x2 < 8; x2++)
	    used[thePixels.pixels[(y8 << 3) + y2][(x8 << 3) + x2]]++;

    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != bg)
	{
	    max = used[c];
	    maxc = c;
	}
    }

    mc[0][y8][x8] = maxc;
    max = 0;

    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != mc[0][y8][x8])
	{
	    max = used[c];
	    maxc = c;
	}
    }

    mc[1][y8][x8] = maxc;
    max = 0;


    for (y = (y8 << 3); y < ((y8 << 3) + 8); y++)
	for (x = (x8 << 3); x < ((x8 << 3) + 8); x++)
	{
	    if (thePixels.pixels[y][x] != mc[0][y8][x8] && thePixels.pixels[y][x] != mc[1][y8][x8])
	    {
		thePixels.pixels[y][x] = getcolor(mc[0][y >> 3][x >> 3], mc[1][y >> 3][x >> 3], mc[1][y >> 3][x >> 3],mc[1][y >> 3][x >> 3],thePixels.pixels[y][x]);
	    }
	}

}


void
 recheck_MCI(int x8, int y8)
{
    int x2, y2, used[256], x, y, c, max, maxc;
    max = maxc = 0;
    /* get d800 colors first - one of ;) */
    /* (note to loonies reading my code -> it's a bitch to re-code when u designed it for 2 d800
     * table - silly me!! ;) */

    for (c = 0; c < 17; c++)
	used[c] = 0;
    for (y2 = 0; y2 < 8; y2++)
	for (x2 = 0; x2 < 8; x2++)
	    used[thePixels.pixels[(y8 << 3) + y2][(x8 << 3) + x2]]++;
    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != bg)
	{
	    max = used[c];
	    maxc = c;
	}
    }
    mcd800[y8][x8] = maxc;
    max = 0;


    /* get mc's 1 and 2 for plane 1 */
    for (c = 0; c < 17; c++)
	used[c] = 0;
    for (y2 = 0; y2 < 8; y2++)
	for (x2 = 0; x2 < 8; x2 += 2)
	    used[thePixels.pixels[(y8 << 3) + y2][(x8 << 3) + x2]]++;

    max = 0;
    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != bg && c != mcd800[y8][x8])
	{
	    max = used[c];
	    maxc = c;
	}
    }
    mc[0][y8][x8] = maxc;
    max = 0;
    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != bg && c != mc[0][y8][x8] && c != mcd800[y8][x8])
	{
	    max = used[c];
	    maxc = c;
	}
    }
    mc[1][y8][x8] = maxc;

    /* and for plane #2 */
    for (c = 0; c < 17; c++)
	used[c] = 0;
    for (y2 = 0; y2 < 8; y2++)
	for (x2 = 1; x2 < 8; x2 += 2)
	    used[thePixels.pixels[(y8 << 3) + y2][(x8 << 3) + x2]]++;
    max = 0;
    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != bg && c != mcd800[y8][x8])
	{
	    max = used[c];
	    maxc = c;
	}
    }
    mci[0][y8][x8] = maxc;
    max = 0;
    for (c = 0; c < 16; c++)
    {
	if (used[c] > max && c != bg && c != mci[0][y8][x8] && c != mcd800[y8][x8])
	{
	    max = used[c];
	    maxc = c;
	}
    }
    mci[1][y8][x8] = maxc;



    for (y = (y8 << 3); y < ((y8 << 3) + 8); y++)
    {
	for (x = (x8 << 3); x < ((x8 << 3) + 8); x += 2)
	{
	    if (thePixels.pixels[y][x] != bg && thePixels.pixels[y][x] != mc[0][y8][x8] && thePixels.pixels[y][x] != mc[1][y8][x8] && thePixels.pixels[y][x] != mcd800[y8][x8])
	    {
		thePixels.pixels[y][x] = getcolor(bg, mc[0][y >> 3][x >> 3], mc[1][y >> 3][x >> 3], mcd800[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}
	for (x = (x8 << 3) + 1; x < ((x8 << 3) + 8); x += 2)
	{
	    if (thePixels.pixels[y][x] != bg && thePixels.pixels[y][x] != mci[0][y8][x8] && thePixels.pixels[y][x] != mci[1][y8][x8] && thePixels.pixels[y][x] != mcd800[y8][x8])
	    {
		thePixels.pixels[y][x] = getcolor(bg, mci[0][y >> 3][x >> 3], mci[1][y >> 3][x >> 3], mcd800[y >> 3][x >> 3], thePixels.pixels[y][x]);
	    }
	}
    }

}


void
 process_scroll(void)
{
    int txr;
    int tyr;
    txr = (xres >> xzoom);
    tyr = (yres >> yzoom);
    if (thePixels.vinterlace == true)
	tyr *= 2;
    if (thePixels.il3 == true)
	tyr *= 3;

    if (mousex >= (xres - scroller))
    {
	xscroll++;
    } else if (mousex <= scroller)
    {
	xscroll--;
    }
    if (xscroll > (thePixels.xsize - txr))
	xscroll = (thePixels.xsize - txr);
    if (xscroll < 0)
	xscroll = 0;

    if (mousey >= (yres - scroller))
    {
	yscroll++;
    } else if (mousey <= scroller)
    {
	yscroll--;
    }
    if (yscroll > (thePixels.ysize - tyr))
	yscroll = (thePixels.ysize - tyr);
    if (yscroll < 0)
	yscroll = 0;
}

void
 set_pal(void)
{
    int x;
    for (x = 0; x < 16; x++)
    {
	setpal(x, reds[x] >> 2, greens[x] >> 2, blues[x] >> 2);
    }
    for (x = 0; x < 16; x++)
    {
	setpal(x + 17, 0, 0, x << 2);
    }
    for (x = 0; x < 16; x++)
    {
	setpal(x + 33, x << 2, 0, 0);
    }
    for (x = 0; x < 16; x++)
    {
	setpal(x + 64, (reds[x] >> 2) + 10, (greens[x] >> 2) + 10, (blues[x] >> 2) + 10);
    }
}

#define no_color 0
void
 clear_buffer(void)
{
    memset(double_buffer, no_color, yres * 1024);
}

void
 set320x200()
{
    int x;
    xres = 320;
    yres = 200;
    for (x = 0; x < xres; x++)
	colorbar[x] = color_order[((x * numPens) / (xres - 16))];
    x = set320x200mode;
    set_pal();
    /*   printf("Set VGA returned %d\n",x); */
}

void
 set376x282()
{
    int x;
    xres = 376;
    yres = 282;
    for (x = 0; x < xres; x++)
	colorbar[x] = color_order[((x * numPens) / (xres - 16))];
    x = set376x282mode;
    set_pal();
}
void
 set320x400()
{
    int x;
    xres = 320;
    yres = 400;
    for (x = 0; x < xres; x++)
	colorbar[x] = color_order[((x * numPens) / (xres - 16))];
    x = set320x400mode;
    set_pal();
    printf("Set VGA returned %d\n", x);
}

void
 set640x480()
{
    int x;
    xres = 640;
    yres = 480;

    for (x = 0; x < xres; x++)
	colorbar[x] = color_order[((x * numPens) / (xres - 16))];
    x = set640x480mode;
    set_pal();
    /*   printf("Set VGA returned %d\n",x); */
}

void
 set_text()
{
    int x;
    xres = 0;
    xres = 0;
    x = settext;
    /*   printf("Set Text returned %d\n",x);   */
}


void
 load_pic(char *filename)
{
    FILE *infile;
    char t;
    int plg;
    char info[12];
    char cmdline[1000];

    for (plg = 0; plg < numImporters; plg++)
    {
	/* make sure that the file is not loadable by default */
	isLoadable[plg] = 0;
	isTheOne = 999;

	sprintf(cmdline, "plugins/import/%s %s", theImporters[plg].file, filename);
	printf("%s\n", cmdline);
	system(cmdline);

	/* now, read in the data - should move to seperate routine soon 
	 * needs *major* updating to handle multi file formats, too -
	 * getting there :P
	 */
	infile = fopen("res/middle", "rb");
	/* test that it's a import file first!!! */
	fgets(info, 11, infile);
	printf("Import ID: %s\n", info);
	t = fgetc(infile);
	printf("t= %c \n", t);
	switch (t)
	{
	case 'N':
	    printf("Cant Read File! Try next plugin\n");
	    isLoadable[plg] = 0;
	    break;
	    return;
	case 'M':
	    printf("Can Read... not sure... try next plugin\n");
	    isLoadable[plg] = 0;
	    break;
	case 'Y':
	    printf("We have a winner!\n");
	    isLoadable[plg] = 2;
	    isTheOne = plg;
	    plg = 999;
	    break;
	}
	fclose(infile);
    }

    if (isTheOne == 999)
    {
	/* ask the user real soon now... for now, just load the 0th one */
	infile = fopen("res/middle", "rb");
	loadBitmap(infile);
	fclose(infile);
    } else
    {
	/* We have a winner! Load it up! */
	printf("We Win Again!\n");
	infile = fopen("res/middle", "rb");
	loadBitmap(infile);
	fclose(infile);
    }
}

void
 loadBitmap(FILE * infile)
{
    int x, y;
    int xsize = 320;
    int ysize = 200;
    /* read in the bitmap */
    printf("Loading Bitmap...\n");
    fseek(infile, 11, 0);
    xsize = getWord(infile);
    ysize = getWord(infile);
    thePixels.xsize = xsize;
    thePixels.ysize = ysize;
    printf("X: %d Y: %d\n", xsize, ysize);
    x = fgetc(infile);
    printf("Double Pixels: %c\n", x);
    if (x == 'Y')
    {
	set_doublePix();
    } else
    {
	unset_doublePix();
    }
    x = fgetc(infile);
    printf("Colors=%c\n", x);
    if (x == '4')
    {
	thePixels.type = multicolor;
    }
    x = fgetc(infile);		/* not handled yet! */

    /* Read the BorderColor */
    x = fgetc(infile);


    /* read the interlacing */
    x = fgetc(infile);
    if (x == 'H')
	setHinterlace();
    else if (x == 'Y')
	setYinterlace();


    fseek(infile, 20, 0);
    for (y = 0; y < ysize; y++)
	for (x = 0; x < xsize; x++)
	{
	    thePixels.pixels[y][x] = fgetc(infile);
	}
}

/* find the plugins */
void
 getPlugs()
{
    printf("\n\n\nLOADERS\n");
    numImporters = plugin_get(theImporters, "plugins/import.plg");
    printf("\n\n\nIFLI SAVERS\n");
    numIFLIexporters = plugin_get(theIFLIexporters, "plugins/ifli_exp.plg");

    printf("\n\n\nFLI SAVERS\n");
    numFLIexporters = plugin_get(theFLIexporters, "plugins/fli_exp.plg");
    
    printf("\n\n\nAFLI SAVERS\n");
    numAFLIexporters = plugin_get(theAFLIexporters, "plugins/afli_exp.plg");

    printf("\n\n\nMulticolor SAVERS\n");
    numMCexporters = plugin_get(theMCexporters, "plugins/mc_exp.plg");
    
    printf("\n\n\nMulticolor Interlace SAVERS\n");
    numMCIexporters = plugin_get(theMCIexporters, "plugins/mci_exp.plg");    
    
    printf("\n\n\nHires SAVERS\n");
    numHiresexporters = plugin_get(theHiresexporters, "plugins/hir_exp.plg");    

    printf("\n\n\nRGB plugins\n");
    numRGBPlugins = plugin_get(theRGBPlugins, "plugins/rgb_filt.plg");
}

int
 plugin_get(plugin * what, char *where)
{
    FILE *infile;
    char t[1000];
    int x, q;

    infile = fopen(where, "rt");
    if (infile == NULL)
	printf("oops! no %s plugins!\n", where);
    else
    {
	x = 0;
	do
	{
	    fgets(t, 100, infile);
	    if (t[0] != '~')
	    {
		strcpy(what[x].name, t);
		q = strlen(what[x].name);
		what[x].name[q - eos] = 0;
		printf("Name: %s\n", what[x].name);

		fgets(what[x].file, 100, infile);
		q = strlen(what[x].file);
		what[x].file[q - eos] = 0;
		printf("Filename: %s\n", what[x].file);
		x++;
	    }
	}
	while (t[0] != '~');
	return x;
    }
    return 0;

}

int
 getWord(FILE * in)
{
    int q;
    q = fgetc(in) << 8;
    q += fgetc(in);
    return q;
}
/* 
 * this procedure was taken from denthors vga tutor - my normal one
 * didnt work in the new enviro (it was dos4gw asm),
 * and i havnt had time to write a new one.
 */

void
 lyne(int a, int b, int c, int d, int col)
{

    long u, s, v, d1x, d1y, d2x, d2y, m, n;
    int i;

    u = c - a;			/* x2-x1 */
    v = d - b;			/* y2-y1 */
    d1x = lsgn(u);		/* d1x is the sign of u (x2-x1) (VALUE -1,0,1) */
    d1y = lsgn(v);		/* d1y is the sign of v (y2-y1) (VALUE -1,0,1) */
    d2x = lsgn(u);		/* d2x is the sign of u (x2-x1) (VALUE -1,0,1) */
    d2y = 0;
    m = abs(u);			/* m is the distance between x1 and x2 */
    n = abs(v);			/* n is the distance between y1 and y2 */

    if (m <= n)
    {				/* if the x distance is greater than the y distance */
	d2x = 0;
	d2y = lsgn(v);		/* d2y is the sign of v (x2-x1) (VALUE -1,0,1) */
	m = abs(v);		/* m is the distance between y1 and y2 */
	n = abs(u);		/* n is the distance between x1 and x2 */
    }
    s = (int) (m / 2);		/* s is the m distance (either x or y) divided by 2 */
    for (i = 0; i <= m; i++)
    {				/* repeat this loop until it */
	/* is = to m (y or x distance) */
	set_pixel_sized_nocheck(a, b, col);	/* plot a pixel at the original x1, y1 */
	s += n;			/* add n (dis of x or y) to s (dis of x of y) */
	if (s >= m)
	{			/* if s is >= m (distance between y1 and y2) */
	    s -= m;
	    a += d1x;
	    b += d1y;
	} else
	{
	    a += d2x;
	    b += d2y;
	}
    }
}

void
 lynec(int a, int b, int c, int d, int col)
{

    long u, s, v, d1x, d1y, d2x, d2y, m, n;
    int i;

    u = c - a;			/* x2-x1 */
    v = d - b;			/* y2-y1 */
    d1x = lsgn(u);		/* d1x is the sign of u (x2-x1) (VALUE -1,0,1) */
    d1y = lsgn(v);		/* d1y is the sign of v (y2-y1) (VALUE -1,0,1) */
    d2x = lsgn(u);		/* d2x is the sign of u (x2-x1) (VALUE -1,0,1) */
    d2y = 0;
    m = abs(u);			/* m is the distance between x1 and x2 */
    n = abs(v);			/* n is the distance between y1 and y2 */

    if (m <= n)
    {				/* if the x distance is greater than the y distance */
	d2x = 0;
	d2y = lsgn(v);		/* d2y is the sign of v (x2-x1) (VALUE -1,0,1) */
	m = abs(v);		/* m is the distance between y1 and y2 */
	n = abs(u);		/* n is the distance between x1 and x2 */
    }
    s = (int) (m / 2);		/* s is the m distance (either x or y) divided by 2 */
    for (i = 0; i <= m; i++)
    {				/* repeat this loop until it */
	/* is = to m (y or x distance) */
	set_pixel_sized(a, b, col);	/* plot a pixel at the original x1, y1 */
/*      checkpixel(a, b, col); */
	s += n;			/* add n (dis of x or y) to s (dis of x of y) */
	if (s >= m)
	{			/* if s is >= m (distance between y1 and y2) */
	    s -= m;
	    a += d1x;
	    b += d1y;
	} else
	{
	    a += d2x;
	    b += d2y;
	}
    }
}


void
 xorlyne(int a, int b, int c, int d, int col)
{

    long u, s, v, d1x, d1y, d2x, d2y, m, n;
    int i;

    u = c - a;			/* x2-x1 */
    v = d - b;			/* y2-y1 */
    d1x = lsgn(u);		/* d1x is the sign of u (x2-x1) (VALUE -1,0,1) */
    d1y = lsgn(v);		/* d1y is the sign of v (y2-y1) (VALUE -1,0,1) */
    d2x = lsgn(u);		/* d2x is the sign of u (x2-x1) (VALUE -1,0,1) */
    d2y = 0;
    m = abs(u);			/* m is the distance between x1 and x2 */
    n = abs(v);			/* n is the distance between y1 and y2 */

    if (m <= n)
    {				/* if the x distance is greater than the y distance */
	d2x = 0;
	d2y = lsgn(v);		/* d2y is the sign of v (x2-x1) (VALUE -1,0,1) */
	m = abs(v);		/* m is the distance between y1 and y2 */
	n = abs(u);		/* n is the distance between x1 and x2 */
    }
    s = (int) (m / 2);		/* s is the m distance (either x or y) divided by 2 */
    for (i = 0; i <= m; i++)
    {				/* repeat this loop until it */
	/* is = to m (y or x distance) */
	//double_buffer[b][a] = col;
        double_buffer[b][a]++;

	s += n;			/* add n (dis of x or y) to s (dis of x of y) */
	if (s >= m)
	{			/* if s is >= m (distance between y1 and y2) */
	    s -= m;
	    a += d1x;
	    b += d1y;
	} else
	{
	    a += d2x;
	    b += d2y;
	}
    }
}

int
 lsgn(int v)
{
    if (v == 0)
	return 0;
    if (v < 0)
	return -1;
    if (v > 0)
	return 1;
    return 0;
}

double
 dsgn(double v)
{
    if (v == 0)
	return 0;
    if (v < 0)
	return -1;
    if (v > 0)
	return 1;
    return 0;
}


void
 setHinterlace()
{
    unsetYinterlace();
    thePixels.hinterlace = true;
}

void
 unsetHinterlace()
{
    thePixels.hinterlace = false;
}


void
 toggleHinterlace()
{
    if (thePixels.hinterlace == true)
	unsetHinterlace();
    else
	setHinterlace();
}

void
 toggleYinterlace()
{
    if (thePixels.vinterlace == true)
	unsetYinterlace();
    else
	setYinterlace();
}

void
 setYinterlace()
{
    unsetHinterlace();
    thePixels.vinterlace = true;
    vlp = 1;
}

void
 unsetYinterlace()
{
    thePixels.vinterlace = false;
    vlp = 0;
}


void
 wow_window(int x, int y, int xsize, int ysize)
{
    int yp;
    for (yp = 0; yp < ysize; yp++)
	memset(&double_buffer[y + yp][x], 36, xsize);
}

void
 titleBar(int x, int y, int xsize, char *title)
{
    int yp;
    for (yp = 0; yp < 16; yp++)
	memset(&double_buffer[yp + y][x], yp + 17, xsize);
    textOut(title, x + ((xsize / 2) - (strlen(title) * 4)), y);
}

void
 button(int x, int y, char *title)
{
    int yp;
    for (yp = 0; yp < 22; yp++)
    {
	double_buffer[yp + y][x + 68] = double_buffer[yp + y][x + 69] = double_buffer[yp + y][x + 70] = 47;
	double_buffer[yp + y][x + 1] = double_buffer[yp + y][x + 2] = double_buffer[yp + y][x] = 40;
	memset(&double_buffer[y + yp][x + 3], 44, 66);
    }

    memset(&double_buffer[y][x], 40, 71);
    memset(&double_buffer[y + 1][x + 1], 40, 69);
    memset(&double_buffer[y + 2][x + 2], 40, 67);

    memset(&double_buffer[y + 22][x], 47, 71);
    memset(&double_buffer[y + 21][x + 1], 47, 68);
    memset(&double_buffer[y + 20][x + 2], 47, 67);

    textOut(title, x + (35 - (strlen(title) * 4)), y + 4);
}

void
 colorbox(int num)
{
    int y, yp, x, xp, xsize, ysize;
    y = currentDlg->colorboxes[num].ypos + currentDlg->ypos;
    ysize = currentDlg->colorboxes[num].ysize;
    xsize = currentDlg->colorboxes[num].xsize;
    x = currentDlg->colorboxes[num].xpos + currentDlg->xpos;
    for (yp = y; yp < y + ysize; yp++)
    {
	double_buffer[yp][x + xsize - 2] = double_buffer[yp][x + xsize - 1] = double_buffer[yp][x + xsize] = 47;
	double_buffer[yp][x + 1] = double_buffer[yp][x + 2] = double_buffer[yp][x] = 40;
/*      memset(&double_buffer[yp][x + 3], 44, 66);   */
    }
    memset(&double_buffer[y][x], 40, xsize);
    memset(&double_buffer[y + 1][x + 1], 40, xsize - 2);
    memset(&double_buffer[y + 2][x + 2], 40, xsize - 4);

    memset(&double_buffer[y + ysize][x], 47, xsize);
    memset(&double_buffer[y + ysize - 1][x + 1], 47, xsize - 2);
    memset(&double_buffer[y + ysize - 2][x + 2], 47, xsize - 4);
    /* fill in the colors */
    if (currentDlg->colorboxes[num].numColors != 0)
    {
	int cc = 0;
	for (xp = 0; xp < (xsize - 6); xp++)
	{
	    for (yp = y + 3; yp < y + (ysize - 2); yp++)
		double_buffer[yp][xp + x + 3] = currentDlg->colorboxes[num].colors[cc];
	    if (xp > ((xsize - 6) * (cc + 1)) / currentDlg->colorboxes[num].numColors)
	    {
		cc++;
		if (cc >= currentDlg->colorboxes[num].numColors)
		    cc--;
	    }
	}
    }
}
void
 draw_text(int x, int y, int xsize, char *title, char *inbox, char hasFocus)
{
    int yp;
    int l;
    for (yp = 0; yp < 22; yp++)
    {
	double_buffer[yp + y][x + xsize - 2] = double_buffer[yp + y][x + xsize - 1] = double_buffer[yp + y][x + xsize] = 47;
	double_buffer[yp + y][x + 1] = double_buffer[yp + y][x + 2] = double_buffer[yp + y][x] = 44;
	if (hasFocus == false)
	{
	    memset(&double_buffer[y + yp][x + 3], 0, xsize - 5);
	} else
	{
	    memset(&double_buffer[y + yp][x + 3], 40, xsize - 5);
	}
    }

    memset(&double_buffer[y][x], 47, xsize);
    memset(&double_buffer[y + 1][x + 1], 47, xsize - 2);
    memset(&double_buffer[y + 2][x + 2], 47, xsize - 4);

    memset(&double_buffer[y + 22][x], 44, xsize);
    memset(&double_buffer[y + 21][x + 1], 44, xsize - 2);
    memset(&double_buffer[y + 20][x + 2], 44, xsize - 4);
    yp = strlen(title) * 8;

    textOut(title, x - yp, y + 4);
    for (l = 0; inbox[l] != 0; l++);
    textOut(inbox, x + 4, y + 4);
    textOut(&tc[cc], x + 4 + l * 8, y + 4);
}

void
 draw_check(int x, int y, char *text, char status)
{
    int yp;
    for (yp = 3; yp < 12; yp++)
    {
	double_buffer[yp + y][x + 9] = double_buffer[yp + y][x + 10] = 47;
	double_buffer[yp + y][x] = double_buffer[yp + y][x + 1] = 40;
	memset(&double_buffer[y + yp][x + 2], 44, 7);
    }

    memset(&double_buffer[y + 3][x], 40, 11);
    memset(&double_buffer[y + 4][x + 1], 40, 9);
    memset(&double_buffer[y + 11][x + 1], 47, 9);
    memset(&double_buffer[y + 10][x + 2], 47, 7);
    if (status != false)
    {

	for (yp = 5; yp < 10; yp++)
	{
	    double_buffer[y + yp][x + yp - 2] = 1;
	    double_buffer[y + yp][x + 12 - yp] = 1;
	}
    }
    textOut(text, x + 13, y);
}


int
 get_num()
{
    int x;
    int thenum = 0;
    do
    {
	x = getkey();
	if (x >= '0' && x <= '9')
	{
	    thenum *= 10;
	    thenum += (x - 48);
	    printf("%d\n", thenum);
	}
/*        printf("%d\n",x); */
    }
    while (x != '\n' && x != 13);
    return thenum;
}

void
 toggleScroll()
{
    if (doscroll == 1)
    {
	doscroll = false;
    } else
    {
	doscroll = true;
    }
}




void
 toggle_doublePix()
{
    if (thePixels.doublePix == false)
    {
	set_doublePix();
    } else
    {
	unset_doublePix();
    }
}

void
 set_doublePix()
{
    thePixels.doublePix = true;
}

void
 unset_doublePix()
{
    thePixels.doublePix = false;
}

void
 set_ec()
{
    extendedClr = true;
}

void
 unset_ec()
{
    extendedClr = false;
}

void
 toggle_ec()
{
    if (extendedClr == false)
	set_ec();
    else
	unset_ec();
}
