/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * String definitions
 */

#ifndef strings_H
#define strings_H

/*
 * Prototypes
 */
/* Message type handles and strings */
#define EWARNING        0
#define EERROR          1
#define ESERIOUS        2
static char *eType[] = {
  "Warning"      ,
  "Error"        ,
  "Serious error"
};
/* Error messages during assembly */
static char pseNo2ndOutfile     [] = "Output file alreasy chosen";
static char pseNo3rdFile        [] = "Already two input files open";
static char pseCannotOpenOutFile[] = "Cannot open output file";
static char pseCannotOpenSubFile[] = "Cannot open sublevel file";
static char pseCombCA [] = "Illegal combination of command and addressing mode";
static char pseCombCP [] = "Illegal combination of command and postfix";
static char pseDivZero[] = "Division by zero";
static char pseNegExp [] = "Exponent is negative";
static char pseNoPC         [] = "Program counter is unset";
static char pseNotYet       [] = "Sorry, feature not yet implemented";
static char pseNoMemLeft    [] = "Out of memory";
static char pseSyntax       [] = "Syntax error";
static char pseNeedValue    [] = "Value not yet defined";
static char pseLabelTwice   [] = "Label already defined";
static char pseMacroTwice   [] = "Macro already defined";
static char pseOpenQuotes   [] = "Quotes still open at end of line";
static char psePFExceeded   [] = "Value exceeds postfix";
static char pseHighbyteZero [] = "Using oversized addressing mode";
static char pseMissingString[] = "No string given";
static char pseTooBig   [] = "Number too big";
static char pseTooDeep  [] = "Recursion too deep";
static char pseTooFar   [] = "Target out of range";
static char pseTooLate  [] = "Too late for postfix";
static char pseTooLong  [] = "String too long";
static char pseTooMuch  [] = "Produced too much code";
static char pseTooManyMP[] = "Too many macro parameters";
static char pseTooOpen  [] = "Too many '('";
static char pseTooClosed[] = "Too many ')'";
static char pseUkOp    [] = "Unknown operator";
static char pseUkPF    [] = "Illegal postfix";
static char pseUkPO    [] = "Unknown pseudo opcode";
static char pseUkCPU   [] = "Unknown processor";
static char pseUkGroup [] = "Bug in ACME - illegal group index";
static char pseUkMacro [] = "Macro not defined";
static char pseWrongNr [] = "Wrong number of macro parameters";
static char pseWrongCPU[] = "Chosen CPU does not support this command and/or addressing mode";
/* Error messages for block routines */
static char pseeEndOfFile [] = "End of file expected";
static char pseeRightBrace[] = "Missing '}'";
static char pseeLeftBrace [] = "Missing '{'";
/* Error messages on startup or closedown */
static char pseCannotOpenDumpFile[] = "Error: Cannot open dump file\n";
static char pseCannotOpenTopFile [] = "Error: Cannot open toplevel file\n";
static char pseNoTop             [] = "Error: No top level source given\n";
static char pseUkSwitch          [] = "Error: Unknown CLI switch: '%c'\n";
/* Other messages */
static char psvFirst  [] = "First pass...\n";
static char psvFurther[] = "Further pass...\n";
static char psvFind   [] = "Further pass needed to find error...\n";
static char psvOutput [] = "Saving output file...\n";
/* Other strings */
static char psMacro   [] = "Macro";
static char psZone    [] = "Zone";
static char psUntitled[] = "<untitled>";
/* Functions */
static void FN_String_ToLower(ListItem *p, int len);
static void FN_String_ShowCopyright(void);
static void FN_String_ShowUsage(void);

#endif
