/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#ifndef platform_C
#define platform_C

/*
 * Platform specific stuff (in this case, for Linux)
 */

/*
 * Find out the path of ACME's library
 */
static void FN_Platform_FindLib(void) {
  int    c;
  char  *p;

  p = getenv("acme");
  if(p) {
    strncpy(pPathname, p, LNPMAX - 1);/* Minus one because of backslash */
    c = strlen(pPathname);
    pPathname[c++] = '\\';/* Add directory separator at end */
    pPathname[c]   = 0;/* Terminate again */
    psLibPath = (char *) malloc(c + 1);
    if(psLibPath) {
      strcpy(psLibPath, pPathname);
    } else FN_Message(pseNoMemLeft, ESERIOUS);
  } else {
    printf(pseNoVarFound);
    FN_CleanExit(EXIT_FAILURE);
  }
}

#endif
