/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#ifndef platform_H
#define platform_H

/*
 * Platform specific stuff (in this case, for AmigaOS)
 */

typedef short       Sixteen;/* At least 16 bit */
typedef signed long Value;  /* At least 24 bit */

/* Copyright message */
static char psCopyright[] = "\n"
"ACME - the ACME Crossassembler for Multiple Environments\n"
"Release 0.05 beta (9-Jan-1999), Copyright (C) 1998, 1999 Marco Baye.\n"
"Ported to AmigaOS by Christoph Mammitzsch.\n"
"ACME comes with ABSOLUTELY NO WARRANTY; for details read the help file.\n"
"This is free software, and you are welcome to redistribute it\n"
"under certain conditions; as outlined in the GNU General Public License.\n"
"\n";

/* Syntax message */
static char psUsage[] =
"Syntax: acme [-v] [-h] <file>\n"
"Options:\n"
"v(erbose)       Show some extra information\n"
"h(elp)          Show this message\n"
"\n";

/* Integer-to-character conversion routine */
#define PLATFORM_INT2CHAR(x)    \
  x ^= x >> 16;                 \
  x ^= x >>  8;                 \
  x &= 255

/* Character prefixing command line options */
#define PLATFORM_OPTIONPREFIX   '-'

/* Closedown sequence */
#define PLATFORM_EXIT

/* Convert UNIX-style pathname to system-style pathname */
#define PLATFORM_CONVERTPATH(a)

/* Platform specific message output */
#define PLATFORM_FN_MESSAGE(a, b)

/* Maximum length of filenames in sources */
#define LNFMAX          255

/* Maximum length of paths */
#define LNPMAX          4096

/* Setting the created files' types */
#define PLATFORM_SETFILETYPE(a, b)

/* Platform specific command line switches */
#define PLATFORM_SWITCHES

/*
 * Prototypes
 */
static void FN_Platform_FindLib(void);

#endif
