
	processor 6502

	; Note: Possibilities for shortening
	;	- No basic end address set:  8 bytes
	;	- No 2 MHz mode set/reset:   6 bytes
	;	- Complete stack overwrite: ~7 bytes
	;	- No WRAP possibility:      17 bytes


BASEND	EQU $2d		; start of basic variables (updated at EOF)
LZPOS	EQU $2d		; temporary, BASEND *MUST* *BE* *UPDATED* at EOF

bitstr	EQU $f7		; Hint the value beforehand
xstore	EQU $c3		; tape load temp
ystore	EQU $c4		; tape load temp

WRAPBUF	EQU $004b	; 'wrap' buffer, 22 bytes ($02a7 for 89 bytes)

	ORG $0801
	DC.B $0b,8,$ef,0	; '239 SYS2061'
	DC.B $9e,$32,$30,$36
	DC.B $31,0,0,0

	sei
	inc $d030
	inc 1

	ldx #0		;** parameter - # of overlap bytes-1 off $ffff
overlap	lda $aaaa,x	;** parameter start of off-end bytes
	sta WRAPBUF,x
	dex
	bpl overlap

	ldx #block200_end-block200+1	; $54	($59 max)
packlp	lda block200-1,x
	sta block200_-1,x
	dex
	bne packlp

	ldx #block_stack_end-block_stack+1	; $b3	(stack! ~$e8 max)
packlp2	lda block_stack-1,x
	dc.b $9d		; sta $nnnn,x
	dc.w block_stack_-1	; (ZP addressing only addresses ZP!)
	dex
	bne packlp2

	ldy #$aa	;** parameter SIZE high + 1 (max 255 extra bytes)
cploop	dex		; ldx #$ff on the first round
	lda $aaaa,x	;** parameter DATAEND-0x100
	sta $ff00,x	;** parameter ORIG LEN-0x100+ reserved bytes
	txa		;cpx #0
	bne cploop
	dec cploop+6
	dec cploop+3
	dey
	bne cploop
	jmp main


block_stack
#rorg $f7	; $f7 - ~$1e0
block_stack_

bitstr	dc.b $80	; ZP	$80 == Empty
esc	dc.b $00	; ** parameter (saves a byte when here)

OUTPOS = *+1		; ZP
putch	sta $aaaa	; ** parameter
	inc OUTPOS	; ZP
	bne 0$
; $100
	inc OUTPOS+1	; ZP
0$	rts


newesc	ldy esc		; remember the old code (top bits for escaped byte)
	ldx #2		; ** PARAMETER
	jsr getchkf	; get & save the new escape code
	sta esc
	tya		; pre-set the bits
	; Fall through and get the rest of the bits.
noesc	ldx #6		; ** PARAMETER
	jsr getchkf
	jsr putch	; output the escaped/normal byte
	; Fall through and check the escape bits again
main	ldy #0		; Reset to a defined state
	tya		; A = 0
	ldx #2		; ** PARAMETER
	jsr getchkf	; X = 0
	cmp esc
	bne noesc
	; Fall through to packed code

	jsr getval	; X = 0
	sta xstore	; save the length for a later time
	cmp #1		; LEN == 2 ?
	bne lz77	; LEN != 2	-> LZ77
	tya		; A = 0
	jsr get1bit	; X = 0
	lsr		; bit -> C, A = 0
	bcc lz77_2	; A=0 -> LZPOS+1
	;***FALL THRU***

	; e..e01
	jsr get1bit	; X = 0
	lsr		; bit -> C, A = 0
	bcc newesc	; e..e010
	;***FALL THRU***

	; e..e011
srle	iny		; Y is 1 bigger than MSB loops
	jsr getval	; Y is 1, get len, X = 0
	sta xstore	; Save length LSB
	cmp #64		; ** PARAMETER 63-64 -> C clear, 64-64 -> C set..
	bcc chrcode	; short RLE, get bytecode

longrle	ldx #2		; ** PARAMETER	111111xxxxxx
	jsr getbits	; get 3/2/1 more bits to get a full byte, X = 0
	sta xstore	; Save length LSB

	jsr getval	; length MSB, X = 0
	tay		; Y is 1 bigger than MSB loops

chrcode	jsr getval	; Byte Code, X = 0
	tax		; this is executed most of the time anyway
	lda table-1,x	; Saves one jump if done here (loses one txa)

	cpx #32		; 31-32 -> C clear, 32-32 -> C set..
	bcc 1$		; 1..31

	; Not ranks 1..31, -> 11111xxxxx (32..64), get byte..
	txa		; get back the value (5 valid bits)
	ldx #3
	jsr getbits	; get 3 more bits to get a full byte, X = 0

1$	ldx xstore	; get length LSB
	inx		; adjust for cpx#$ff;bne -> bne
dorle	jsr putch
	dex
	bne dorle	; xstore 0..255 -> 1..256
	dey
mainbeq	beq main	; reverse condition -> jump always
	bne dorle	; Y was 1 bigger than wanted originally
	; Just a little obfuscation to have beq/bne instead of bne/beq


lz77	jsr getval	; X = 0
	cmp #127	; ** PARAMETER	Clears carry (is maximum value)
	beq eof		; EOF

	sbc #0		; C is clear -> subtract 1  (1..126 -> 0..125)
	ldx #0		; ** PARAMETER (more bits to get)
	jsr getchkf	; clears Carry, X = 0

lz77_2	sta LZPOS+1	; offset MSB
	ldx #8
	jsr getbits	; clears Carry, X = 0
			; Note: Already eor:ed in the compressor..
	;eor #255	; offset LSB 2's complement -1 (i.e. -X = ~X+1)
	adc OUTPOS	; -offset -1 + curpos (C is clear)
	sta LZPOS

	lda OUTPOS+1
	sbc LZPOS+1	; takes C into account
	sta LZPOS+1	; copy X+1 number of chars from LZPOS to OUTPOS
	;ldy #0		; Y was 0 originally, we don't change it

	ldx xstore	; LZLEN
	inx		; adjust for cpx#$ff;bne -> bne
lzloop	lda (LZPOS),y
	jsr putch
	iny		; Y does not wrap because X=0..255 and Y initially 0
	dex
	bne lzloop	; X loops, (256,1..255)
	beq mainbeq	; jump through another beq (-1 byte, +3 cycles)


	; EOF
eof	lda #$37	; ** could be a PARAMETER
	sta 1
	dec $d030
	lda OUTPOS	; Set the basic prg end address
	sta BASEND
	lda OUTPOS+1
	sta BASEND+1
	cli		; ** could be a PARAMETER
	jmp $aaaa	; ** PARAMETER
#rend
block_stack_end


block200
#rorg 	$200	; $200-$258
block200_

getnew	pha		; 1 Byte/3 cycles
INPOS = *+1
	lda $aaaa	;** parameter
	rol		; Shift in C=1 (last bit marker)
	sta bitstr	; bitstr initial value = $80 == empty
	inc INPOS	; Does not change C!
	bne 0$
	inc INPOS+1	; Does not change C!
	bne 0$

	; This code does not change C!
	lda #WRAPBUF	; Wrap from $ffff->$0000 -> WRAPBUF
	sta INPOS
	;lda #>WRAPBUF
	;sta INPOS+1

0$	pla		; 1 Byte/4 cycles
	rts


; getval : Gets a 'static huffman coded' value
; ** Scratches X, returns the value in A **
getval	ldx #1
	txa		; set the top bit (value is 1..255)
0$	asl bitstr
	bne 1$
	jsr getnew
1$	bcc getchk	; got 0-bit
	inx
	cpx #7		; ** parameter
	bne 0$
	beq getchk	; inverse condition -> jump always

; getbits: Gets X bits from the stream
; ** Scratches X, returns the value in A **
get1bit	inx		;2
getbits	asl bitstr
	bne 1$
	jsr getnew
1$	rol		;2
getchk	dex		;2		more bits to get ?
getchkf	bne getbits	;2/3
	clc		;2		return carry cleared
	rts		;6+6


table	dc.b 0,0,0,0,0,0,0
	dc.b 0,0,0,0,0,0,0,0
	dc.b 0,0,0,0,0,0,0,0
	dc.b 0,0,0,0,0,0,0,0

#rend
block200_end




