; ODPLAY 128 OURCE ODE
; OR INGLE  CHIP, 4 BIT OUTPUT.

.ORG $1500

LONOTE = 1023
HINOTE = 16
NOTEPERL = $02
NOTEPERH = NOTEPERL+4
OLDPERIODL = NOTEPERH+4
OLDPERIODH = OLDPERIODL+4
NOTESTOPL = OLDPERIODH+4
NOTESTOPH = NOTESTOPL+4
SETVOLFLAG = NOTESTOPH+4
PORTAFLAG = SETVOLFLAG+4
VSLIDEDIR = PORTAFLAG+4
PSLIDE = VSLIDEDIR+4
VSLIDE = PSLIDE+4
PORTA = VSLIDE+4
TRACKVOL = PORTA+4
VOL1 = TRACKVOL+4
VOL2 = VOL1+2
VOL3 = VOL2+2
VOL4 = VOL3+2
SAMPLENUM = VOL4+2
ENABLEFLGS = SAMPLENUM+4
TICKS = ENABLEFLGS+1
TEMPOBPM = TICKS+1
TEMPOTPD = TEMPOBPM+1
COMMAND = TEMPOTPD+1
CMDARG = COMMAND+4
OLDCOMMAND = CMDARG+4
LASTKEY = OLDCOMMAND+4
TEMPA = LASTKEY+1
TEMPB = TEMPA+1
TEMPX = TEMPB+1
TEMPPNT1 = TEMPX+1
SECOND = TEMPPNT1+2
THIRD = SECOND+4
FOURTH = THIRD+4
FIFTH = FOURTH+4
SIXTH = FIFTH+4
SEVENTH = SIXTH+4
EIGHTH = SEVENTH+4
PATINDEX = EIGHTH+4
BREAKADDR = PATINDEX+2
PATNUMBER = BREAKADDR+2
ROWNUMBER = PATNUMBER+1
FRACTION = ROWNUMBER+1
STEPL = FRACTION+4
STEPH = STEPL+4
TRKPNTL = STEPH+4
TRKPNTH = TRKPNTL+4
TRKPNTB = TRKPNTH+4
STARTL = TRKPNTB+4
STARTH = STARTL+4
STARTB = STARTH+4
ENDL = STARTB+4
ENDH = ENDL+4
ENDB = ENDH+4
OFFSET = ENDB+4
TEMPPER = OFFSET+4
SAMPNUM = TEMPPER+4
TEMPPNT3 = $FA
TEMPPNT4 = $FC
ABORTFLAG = $3E1
BANK0 = %00111110
TRK1DATA = $0400
TRK2DATA = $0420
TRK3DATA = $0440
TRK4DATA = $0460
BASFILTER = $07EC
BASRESON = $07EE
LSBSADDR = $0D00
MSBSADDR = $0D20
BNKSADDR = $0D40
LSBSEND = $0D60
MSBSEND = $0D80
BNKSEND = $0DA0
LSBLPPNT = $0DC0
MSBLPPNT = $0DE0
BNKLPPNT = $0E00
LSBLPLEN = $0E20
MSBLPLEN = $0E40
BNKLPLEN = $0E60
VOLUMES = $0E80
SCSRCLSB = $0EA0
SCSRCMSB = $0EC0
SCTRGLSB = $0EE0
SCTRGMSB = $0EE4
DIVIDE16 = $0F00
CMDSRCL = $2FC0
CMDSRCH = $2FD0
ECMDSRCL = $2FE0
ECMDSRCH = $2FF0
NTPERIOD = $3000
VOLTABLE = $3800
TEMPOTBL = $7800
TEMPOTBH = $7900
PATTERNBUF = $7A00
PATTERNTOP = $7E00
SONGLENGTH = $81B6
PATTERNTBL = $81B8
NEWPAGE0 = $8300
STEPDIV1 = $8400
STEPDIV2 = $8430
STEPDIV3 = $84_60
STEPDIV4 = $8490
STEPDIV5 = $84C0
STEPDIV6 = $84F0
STEPDIV7 = $8520
CLOCK = $D030
FREQ = $D400
SOUNDOUT = $D402
CLOCKSOUND = $D404
SUS_REL = $D406
FILTER = $D415
FILTVOC_RES = $D417
VOLUME_FMODE = $D418
PAGE0LO = $D507
PAGE0HI = $D508
VDCREG = $D600
VDCDATA = $D601
KEYCOLS = $DC00
KEYROWS = $DC01
TEMPO = $DD04
DMACMD = $DF01
DMAADL = $DF02
DMAADH = $DF03
DMALO = $DF04
DMAHI = $DF05
DMABNK = $DF06
DMADAL = $DF07
DMADAH = $DF08
DMAVER = $DF0A
MMUCR = $FF00
BSOUT = $FFD2

JMP PLAYSONG
JMP INITSOUND
JMP PLAYSAMP
JMP SILENCE

.BYTE "INGLE  HIP - 8 BIT ",13,"  "

; OTAL MUST NOT EXCEED 30 CHARACTERS.

.BYTE 1 ; ILTER CAPABLE? (1 = ES)
.BYTE 1 ; ESONANCE CAPABLE? (1 = ES)
.BYTE 0 ; TEREO  CAPABLE? (1 = ES)
.BYTE 0 ; RIVER YPE (0 = LAYBACK, 1 = XPORT)

REUDATA
 .BYTE 0
MOVE2TRK1
 .BYTE 19,19,9,9,9,9,9,9,9,9,9
MOVEDOWN
 .BYTE 17,17,17,0
MUTETRACK
 .BYTE 28,18,"    ",146,0
ENABLE1
 .BYTE 155,18,"   ",146,0
ENABLE2
 .BYTE 155,18,"  ",146,0
ENABLE3
 .BYTE 155,18,"  ",146,0
ENABLE4
 .BYTE 155,18,"   ",146,0
ENABLE
 .WORD ENABLE1,ENABLE2,ENABLE3,ENABLE4
TRKTOBIT
 .BYTE 1,2,4,8

DEC2HEX
 .BYTE 48,49,50,51,52,53,54,55,56,57,1,2,3,4,5,6
DEC2HEXR
 .BYTE 176,177,178,179,180,181,182,183,184,185,193,194,195,196,197,198
VDISPTBL
 .BYTE 17,97,177,1,1,1,1,2

JUMPTAB1L
 .BYTE <UNUSED
 .BYTE <SLIDEUP
 .BYTE <SLIDEDN
 .BYTE <SLIDE2NT
 .BYTE <UNUSED
 .BYTE <SLIDEVS
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <SOFFSET
 .BYTE <VOLSLIDE
 .BYTE <POSJUMP
 .BYTE <SETVOL
 .BYTE <PATBRK
 .BYTE <UNUSED
 .BYTE <SETSPEED

JUMPTAB1H
 .BYTE >UNUSED
 .BYTE >SLIDEUP
 .BYTE >SLIDEDN
 .BYTE >SLIDE2NT
 .BYTE >UNUSED
 .BYTE >SLIDEVS
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >SOFFSET
 .BYTE >VOLSLIDE
 .BYTE >POSJUMP
 .BYTE >SETVOL
 .BYTE >PATBRK
 .BYTE >UNUSED
 .BYTE >SETSPEED

JUMPTAB2L
 .BYTE <UNUSED
 .BYTE <DSLIDEUP
 .BYTE <DSLIDEDN
 .BYTE <DSLIDE2NT
 .BYTE <UNUSED
 .BYTE <DSLIDEVS
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <DVOLSLIDE
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED
 .BYTE <UNUSED

JUMPTAB2H
 .BYTE >UNUSED
 .BYTE >DSLIDEUP
 .BYTE >DSLIDEDN
 .BYTE >DSLIDE2NT
 .BYTE >UNUSED
 .BYTE >DSLIDEVS
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >DVOLSLIDE
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED
 .BYTE >UNUSED

PLAYSONG
 SEI
 LDA #1
 STA CLOCK
 LDA #0
 STA 53280
 LDA #BANK0
 STA MMUCR
 LDA #0
 LDY #36
 JSR WRITEREG
 LDA #$7F
 STA $DD0D
 LDA #$00
 STA $DD0E
 JSR INITSOUND
 LDA #$26
 STA FREQ+1
 LDA #0
 STA PAGE0HI
 LDA #>NEWPAGE0
 STA PAGE0LO
 LDA #0
 LDX #2
CLRLOOP
 STA $00,X
 INX
 BNE CLRLOOP
 STA ABORTFLAG
 STA DMACMD
 LDA #1
 STA DMADAL
 LDA #0
 STA DMADAH
 LDA #0
 STA DMAVER
 LDA #$0F
 STA ENABLEFLGS
 LDA #125
 STA TEMPOBPM
 LDA #6
 STA TEMPOTPD
 JSR CALCTEMPO
 LDA #<LONOTE
 STA NOTEPERL
 STA NOTEPERL+1
 STA NOTEPERL+2
 STA NOTEPERL+3
 LDA #>LONOTE
 STA NOTEPERH
 STA NOTEPERH+1
 STA NOTEPERH+2
 STA NOTEPERH+3
 LDA #>VOLTABLE
 STA VOL1+1
 STA VOL2+1
 STA VOL3+1
 STA VOL4+1
 LDA #1
 STA STARTB
 STA STARTB+1
 STA STARTB+2
 STA STARTB+3
 STA ENDB
 STA ENDB+1
 STA ENDB+2
 STA ENDB+3
 STA TRKPNTB
 STA TRKPNTB+1
 STA TRKPNTB+2
 STA TRKPNTB+3
 LDA #3
 STA ENDH
 STA ENDH+1
 STA ENDH+2
 STA ENDH+3
 JSR INITSOUND2

NEWPATN
 LDA #0
 STA ROWNUMBER
 STA DMALO
 LDA PATNUMBER
 TAY
 LDX DIVIDE16,Y
 LDA DEC2HEX,X
 STA TEMPA
 TYA
 AND #$0F
 TAX
 LDA DEC2HEX,X
 STA TEMPB
 LDY #19
 LDA #111
 JSR WRITEREG
 DEY
 LDA #0
 JSR WRITEREG
 LDY #31
 LDA TEMPA
 JSR WRITEREG
 LDA TEMPB
 JSR WRITEREG
 LDX PATNUMBER
 LDA PATTERNTBL,X
 TAY
 LDX DIVIDE16,Y
 LDA DEC2HEX,X
 STA TEMPA
 TYA
 AND #$0F
 TAX
 LDA DEC2HEX,X
 STA TEMPB
 LDY #19
 LDA #131
 JSR WRITEREG
 DEY
 LDA #0
 JSR WRITEREG
 LDY #31
 LDA TEMPA
 JSR WRITEREG
 LDA TEMPB
 JSR WRITEREG
 LDX PATNUMBER
 LDA PATTERNTBL,X
 ASL
 ASL
 STA DMAHI
 LDA #0
 ADC #0
 STA DMABNK
 LDA #<PATTERNBUF
 STA DMAADL
 LDA #>PATTERNBUF
 STA DMAADH
 LDA #0
 STA DMAVER
 STA DMADAL
 LDA #4
 STA DMADAH
 LDA #0
 STA CLOCK
 LDA #$95
 STA DMACMD
 LDA #1
 STA CLOCK
 LDA #8
 STA DMADAL
 LDA #0
 STA DMADAH
 STA DMAVER
 STA DMAADH
 LDA #$09
 STA $DD0E
 LDA BREAKADDR+1
 BNE SETBREAK
 LDA #<PATTERNBUF
 STA PATINDEX
 LDA #>PATTERNBUF
 STA PATINDEX+1
 JMP STARTNOTE

SETBREAK
 LDA BREAKADDR
 STA PATINDEX
 LDA BREAKADDR
 STA PATINDEX+1

STARTNOTE
 LDA ROWNUMBER
 TAY
 LDX DIVIDE16,Y
 LDA DEC2HEX,X
 STA TEMPA
 TYA
 AND #$0F
 TAX
 LDA DEC2HEX,X
 STA TEMPB
 LDY #19
 LDA #85
 JSR WRITEREG
 DEY
 LDA #0
 JSR WRITEREG
 LDY #31
 LDA TEMPA
 JSR WRITEREG
 LDA TEMPB
 JSR WRITEREG
 LDA #$FE
 STA KEYCOLS
 LDA KEYROWS
 CMP #$BF
 BNE CHKSPC
 LDA #2 
 STA ABORTFLAG
 JMP STOPSONG

CHKSPC
 LDA #$7F
 STA KEYCOLS
 LDA KEYROWS
 CMP #$EF
 BNE NOSTOP
 LDA #1
 STA ABORTFLAG
 JMP STOPSONG

NOSTOP
 CMP #$FE
 BNE NOTOG1
 JMP TOGGLE1

NOTOG1
 CMP #$F7
 BNE NOTOG2
 JMP TOGGLE2

NOTOG2
 LDA #$FD
 STA KEYCOLS
 LDA KEYROWS
 CMP #$FE
 BNE NOTOG3
 JMP TOGGLE3

NOTOG3
 CMP #$F7
 BNE NOTOG4
 JMP TOGGLE4

NOTOG4
 LDA #$DF
 STA KEYCOLS
 LDA KEYROWS
 CMP #$FD
 BNE NOKEYS
 JMP PAUSE

NOKEYS
 LDA #0
 STA LASTKEY
 JMP ROWCMDS

TOGGLE1
 LDA #1
 CMP LASTKEY
 BNE TGL1
 JMP ROWCMDS

TGL1
 STA LASTKEY
 LDX #0
 JSR TOGGLEDISP
 JMP ROWCMDS

TOGGLE2
 LDA #2
 CMP LASTKEY
 BNE TGL2
 JMP ROWCMDS

TGL2
 STA LASTKEY
 LDX #1
 JSR TOGGLEDISP
 JMP ROWCMDS

TOGGLE3
 LDA #3
 CMP LASTKEY
 BNE TGL3
 JMP ROWCMDS

TGL3
 STA LASTKEY
 LDX #2
 JSR TOGGLEDISP
 JMP ROWCMDS

TOGGLE4
 LDA #4
 CMP LASTKEY
 BNE TGL4
 JMP ROWCMDS

TGL4
 STA LASTKEY
 LDX #3
 JSR TOGGLEDISP
 JMP ROWCMDS

PAUSE
 LDA #5
 CMP LASTKEY
 BEQ ROWCMDS
 STA LASTKEY
 LDA #$DF
 STA KEYCOLS
 LDA #$FD

PAUSEDB
 CMP KEYROWS
 BEQ PAUSEDB
 LDA #$FD

PAUSEWT
 CMP KEYROWS
 BNE PAUSEWT

ROWCMDS LDX #4
 LDA #0

CLRROWLOOP
 DEX
 STA SETVOLFLAG,X
 STA PORTAFLAG,X
 STA VSLIDE,X
 STA PSLIDE,X
 STA OFFSET,X
 BNE CLRROWLOOP
 LDY #2
 LDA (PATINDEX),Y
 TAY
 LDX DIVIDE16,Y
 LDA JUMPTAB1L,X
 STA JSRCMD1+1
 LDA JUMPTAB1H,X
 STA JSRCMD1+2
 LDA COMMAND
 STA OLDCOMMAND
 STX COMMAND
 LDY #3
 LDX #0
 LDA (PATINDEX),Y
 STA CMDARG

JSRCMD1
 JSR $0000
 LDX COMMAND
 BNE DEFFECT1
 LDA CMDARG
 BNE DEFFECT1
 LDX #8

DEFFECT1
 LDA ENABLEFLGS
 AND #1
 BEQ JSR2
 LDA COMMAND
 CMP OLDCOMMAND
 BEQ JSR2
 LDY #19
 STY VDCREG
 LDA #30
 STA VDCDATA
 DEY
 STY VDCREG
 LDA #1
 STA VDCDATA
 LDA #128
 LDY #24
 JSR WRITEREG
 LDY #33
 STY VDCREG
 LDA CMDSRCL,X
 STA VDCDATA
 DEY
 STY VDCREG
 LDA CMDSRCH,X
 STA VDCDATA
 LDY #30
 STY VDCREG
 LDA #23
 STA VDCDATA

JSR2
 LDY #6
 LDA (PATINDEX),Y
 TAY
 LDX DIVIDE16,Y
 LDA JUMPTAB1L,X
 STA JSRCMD2+1
 LDA JUMPTAB1H,X
 STA JSRCMD2+2
 LDA COMMAND+1
 STA OLDCOMMAND+1
 STX COMMAND+1
 LDY #7
 LDX #1
 LDA (PATINDEX),Y
 STA CMDARG+1

JSRCMD2
 JSR $0000
 LDX COMMAND+1
 BNE DEFFECT2
 LDA CMDARG+1
 BNE DEFFECT2
 LDX #8

DEFFECT2
 LDA ENABLEFLGS
 AND #2
 BEQ JSR3
 LDA COMMAND+1
 CMP OLDCOMMAND+1
 BEQ JSR3
 LDA #110
 LDY #19
 JSR WRITEREG
 DEY
 STY VDCREG
 LDA #1
 STA VDCDATA
 LDY #24
 LDA #128
 JSR WRITEREG
 LDY #33
 STY VDCREG
 LDA CMDSRCL,X
 STA VDCDATA
 DEY
 STY VDCREG
 LDA CMDSRCH,X
 STA VDCDATA
 LDY #30
 STY VDCREG
 LDA #23
 STA VDCDATA

JSR3
 LDY #10
 LDA (PATINDEX),Y
 TAY
 LDX DIVIDE16,Y
 LDA JUMPTAB1L,X
 STA JSRCMD3+1
 LDA JUMPTAB1H,X
 STA JSRCMD3+2
 LDA COMMAND+2
 STA OLDCOMMAND+2
 STX COMMAND+2
 LDY #11
 LDX #2
 LDA (PATINDEX),Y
 STA CMDARG+2

JSRCMD3
 JSR $0000
 LDX COMMAND+2
 BNE DEFFECT3
 LDA CMDARG+2
 BNE DEFFECT3
 LDX #8

DEFFECT3
 LDA ENABLEFLGS
 AND #4
 BEQ JSR4
 LDA COMMAND+2
 CMP OLDCOMMAND+2
 BEQ JSR4
 LDA #190
 LDY #19
 JSR WRITEREG
 DEY
 STY VDCREG
 LDA #1
 STA VDCDATA
 LDY #24
 LDA #128
 JSR WRITEREG 
 LDY #33
 STY VDCREG
 LDA CMDSRCL,X
 STA VDCDATA
 DEY
 STY VDCREG
 LDA CMDSRCH,X
 STA VDCDATA
 LDY #30
 STY VDCREG
 LDA #23
 STA VDCDATA

JSR4
 LDY #14
 LDA (PATINDEX),Y
 TAY
 LDX DIVIDE16,Y
 LDA JUMPTAB1L,X
 STA JSRCMD4+1
 LDA JUMPTAB1H,X
 STA JSRCMD4+2
 LDA COMMAND+3
 STA OLDCOMMAND+3
 STX COMMAND+3
 LDY #15
 LDX #3
 LDA (PATINDEX),Y
 STA CMDARG+3

JSRCMD4
 JSR $0000
 LDX COMMAND+3
 BNE DEFFECT4
 LDA CMDARG+3
 BNE DEFFECT4
 LDX #8

DEFFECT4
 LDA ENABLEFLGS
 AND #8
 BEQ SAMPCHK1
 LDA COMMAND+3
 CMP OLDCOMMAND+3
 BEQ SAMPCHK1
 LDA #14
 LDY #19
 JSR WRITEREG
 DEY
 STY VDCREG
 LDA #2
 STA VDCDATA
 LDA #128
 LDY #24
 JSR WRITEREG
 LDY #33
 STY VDCREG
 LDA CMDSRCL,X
 STA VDCDATA
 DEY
 STY VDCREG
 LDA CMDSRCH,X
 STA VDCDATA
 LDY #30
 STY VDCREG
 LDA #23
 STA VDCDATA

SAMPCHK1
 LDY #0
 LDA (PATINDEX),Y
 BEQ FREQCHK1
 LDY PORTAFLAG
 BNE FREQCHK1
 CMP SAMPLENUM
 STA SAMPLENUM
 BNE NS1
 LDY VSLIDE
 BEQ NS1
 LDX SAMPLENUM
 LDA VOLUMES,X
 LDX #0
 JSR SETVOL
 JMP FREQCHK1

NS1
 TAY
 LDX #0
 JSR DISPSAMP
 JSR SETSAMP1

FREQCHK1
 LDY #2
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPA
 DEY
 LDX #0
 ORA (PATINDEX),Y
 BEQ SAMPCHK2
 LDA PORTAFLAG
 BNE SAMPCHK2
 LDA TEMPA
 STA NOTEPERH
 LDA (PATINDEX),Y
 STA NOTEPERL
 JSR STEPCALC
 LDA OFFSET
 BNE NO1
 JSR START1
 LDA SETVOLFLAG
 BNE SAMPCHK2

NO1
 LDX SAMPLENUM
 LDA VOLUMES,X
 LDX #0
 JSR SETVOL

SAMPCHK2
 LDY #4
 LDA (PATINDEX),Y
 BEQ FREQCHK2
 LDY PORTAFLAG+1
 BNE FREQCHK2
 CMP SAMPLENUM+1
 STA SAMPLENUM+1
 BNE NS2
 LDY VSLIDE+1
 BEQ NS2
 LDX SAMPLENUM+1
 LDA VOLUMES,X
 LDX #1
 JSR SETVOL
 JMP FREQCHK2

NS2
 TAY
 LDX #1
 JSR DISPSAMP
 JSR SETSAMP2

FREQCHK2
 LDY #6
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPA
 DEY
 LDX #1
 ORA (PATINDEX),Y
 BEQ SAMPCHK3
 LDA PORTAFLAG+1
 BNE SAMPCHK3
 LDA TEMPA
 STA NOTEPERH+1
 LDA (PATINDEX),Y
 STA NOTEPERL+1
 JSR STEPCALC
 LDA OFFSET+1
 BNE NO2
 JSR START2
 LDA SETVOLFLAG+1
 BNE SAMPCHK3

NO2
 LDX SAMPLENUM+1
 LDA VOLUMES,X
 LDX #1
 JSR SETVOL

SAMPCHK3
 LDY #8
 LDA (PATINDEX),Y
 BEQ FREQCHK3
 LDY PORTAFLAG+2
 BNE FREQCHK3
 CMP SAMPLENUM+2
 STA SAMPLENUM+2
 BNE NS3
 LDY VSLIDE+2
 BEQ NS3
 LDX SAMPLENUM+2
 LDA VOLUMES,X
 LDX #2
 JSR SETVOL
 JMP FREQCHK3

NS3
 TAY
 LDX #2
 JSR DISPSAMP
 JSR SETSAMP3

FREQCHK3
 LDY #10
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPA
 DEY
 LDX #2
 ORA (PATINDEX),Y
 BEQ SAMPCHK4
 LDA PORTAFLAG+2
 BNE SAMPCHK4
 LDA TEMPA
 STA NOTEPERH+2
 LDA (PATINDEX),Y
 STA NOTEPERL+2
 JSR STEPCALC
 LDA OFFSET+2
 BNE NO3
 JSR START3
 LDA SETVOLFLAG+2
 BNE SAMPCHK4

NO3
 LDX SAMPLENUM+2
 LDA VOLUMES,X
 LDX #2
 JSR SETVOL

SAMPCHK4
 LDY #12
 LDA (PATINDEX),Y
 BEQ FREQCHK4
 LDY PORTAFLAG+3
 BNE FREQCHK4
 CMP SAMPLENUM+3
 STA SAMPLENUM+3
 BNE NS4
 LDY VSLIDE+3
 BEQ NS4
 LDX SAMPLENUM+3
 LDA VOLUMES,X
 LDX #3
 JSR SETVOL
 JMP FREQCHK4

NS4
 TAY
 LDX #3
 JSR DISPSAMP
 JSR SETSAMP4

FREQCHK4
 LDY #14
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPA
 DEY
 LDX #3
 ORA (PATINDEX),Y
 BEQ STARTMIXER
 LDA PORTAFLAG+3
 BNE STARTMIXER
 LDA TEMPA
 STA NOTEPERH+3
 LDA (PATINDEX),Y
 STA NOTEPERL+3
 JSR STEPCALC
 LDA OFFSET+3
 BNE NO4
 JSR START4
 LDA SETVOLFLAG+3
 BNE STARTMIXER

NO4
 LDX SAMPLENUM+3
 LDA VOLUMES,X
 LDX #3
 JSR SETVOL

STARTMIXER
 LDA ENABLEFLGS
 AND #1
 BEQ DV2
 LDA SETVOLFLAG
 BEQ DV2
 LDX #0
 JSR DISPVOL

DV2
 LDA ENABLEFLGS
 AND #2
 BEQ DV3
 LDA SETVOLFLAG+1
 BEQ DV3
 LDX #1
 JSR DISPVOL

DV3
 LDA ENABLEFLGS
 AND #4
 BEQ DV4
 LDA SETVOLFLAG+2
 BEQ DV4
 LDX #2
 JSR DISPVOL

DV4
 LDA ENABLEFLGS
 AND #8
 BEQ LOADTEMPO
 LDA SETVOLFLAG+3
 BEQ LOADTEMPO
 LDX #3
 JSR DISPVOL

LOADTEMPO
 LDA TEMPOTPD
 SEC
 SBC #1
 STA TICKS
 LDA #>TRK1DATA
 STA DMAADH

CYCLESND
 JSR MIXER

TIMETICK
 JSR MIXER
 LDA TEMPOTPD
 CMP #1
 BNE TICKCMDS
 JMP CHECKBREAK

TICKCMDS
 LDX COMMAND
 BEQ JS2
 LDA JUMPTAB2L,X
 STA JSRSLIDE1+1
 LDA JUMPTAB2H,X
 STA JSRSLIDE1+2
 TXA
 AND #$0F
 STA COMMAND
 LDX #0

JSRSLIDE1
 JSR $0000

JS2
 LDX COMMAND+1
 BEQ JS3
 LDA JUMPTAB2L,X
 STA JSRSLIDE2+1
 LDA JUMPTAB2H,X
 STA JSRSLIDE2+2
 TXA
 AND #$0F
 STA COMMAND+1
 LDX #1

JSRSLIDE2
 JSR $0000

JS3
 LDX COMMAND+2
 BEQ JS4
 LDA JUMPTAB2L,X
 STA JSRSLIDE3+1
 LDA JUMPTAB2H,X
 STA JSRSLIDE3+2
 TXA
 AND #$0F
 STA COMMAND+2
 LDX #2

JSRSLIDE3
 JSR $0000

JS4
 LDX COMMAND+3
 BEQ NT
 LDA JUMPTAB2L,X
 STA JSRSLIDE4+1
 LDA JUMPTAB2H,X
 STA JSRSLIDE4+2
 TXA
 AND #$0F
 STA COMMAND+3
 LDX #3

JSRSLIDE4
 JSR $0000

NT
 DEC TICKS
 BEQ CHECKBREAK
 JMP TIMETICK

CHECKBREAK
 LDA BREAKADDR+1
 BEQ CHECKPATN
 LDA #0
 STA BREAKADDR
 STA BREAKADDR+1
 JMP NEXTPATN

CHECKPATN
 INC ROWNUMBER
 LDA BREAKADDR+1
 BNE NEXTPATN
 CLC
 LDA PATINDEX
 ADC #16
 STA PATINDEX
 BNE PATNOTDONE
 INC PATINDEX+1
 LDA PATINDEX+1
 CMP #>PATTERNTOP
 BEQ NEXTPATN

PATNOTDONE
 JMP STARTNOTE

NEXTPATN
 INC PATNUMBER
 LDA PATNUMBER
 CMP SONGLENGTH
 BEQ STOPSONG
 JMP NEWPATN

STOPSONG
 LDA #0
 STA PAGE0HI
 STA PAGE0LO
 STA MMUCR
 JSR 65412
 JSR 65511
 JSR 65451
 JSR 65454
 LDA #11
 STA 53265
 LDA #1
 STA CLOCK
 LDA #0
 STA 53280
 LDA #$00
 STA $DD0E
 LDA #$7F
 STA $DD0D
 CLI
 LDA ABORTFLAG

UNUSED
 RTS

; 8-PHASE MIXER

MIXER
 LDA #<TRK1DATA
 STA DMAADL
 CLC
 LDA FRACTION
 ADC STEPL
 STA FRACTION
 LDA TRKPNTL
 ADC STEPH
 STA TRKPNTL
 STA DMALO
 LDA TRKPNTH
 ADC #0
 STA TRKPNTH
 STA DMAHI
 LDA TRKPNTB
 ADC #0
 STA TRKPNTB
 STA DMABNK
 LDA #32
 STA DMADAL
 LDX EIGHTH
 LDY TRK1DATA,X
 CLC
 LDA (VOL1),Y
 LDX SIXTH+1
 LDY TRK2DATA,X
 ADC (VOL2),Y
 LDX FOURTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX SECOND+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 STA SOUNDOUT
 LDA #$49
 LDX #$41
 STA CLOCKSOUND
 STX CLOCKSOUND
 
 LDX #5
DELLOOP1
 DEX
 BNE DELLOOP1 

 LDA #$95
 DEC CLOCK
 STA DMACMD
 STA CLOCK
 LDY TRK1DATA
 CLC
 LDA (VOL1),Y
 LDX SEVENTH+1
 LDY TRK2DATA,X
 ADC (VOL2),Y
 LDX FIFTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX THIRD+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 STA SOUNDOUT
 LDA #$49
 LDX #$41
 STA CLOCKSOUND
 STX CLOCKSOUND

 LDX #6
DELLOOP2
 DEX
 BNE DELLOOP2

 SEC
 LDA TRKPNTL
 SBC ENDL
 LDA TRKPNTH
 SBC ENDH
 LDA TRKPNTB
 SBC ENDB
 BCC UPDATE2
 LDX SAMPLENUM
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE LOOPSAMP1
 TAX
 JSR RETRIG
 LDA #0
 STA SECOND
 STA THIRD
 STA FOURTH
 STA FIFTH
 STA SIXTH
 STA SEVENTH
 STA EIGHTH
 STA STEPL
 STA STEPH
 JSR SV2
 JMP UPDATE2

LOOPSAMP1
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB
 LDA LSBLPLEN,X
 ADC STARTL
 STA ENDL
 LDA MSBLPLEN,X
 ADC STARTH
 STA ENDH
 LDA BNKLPLEN,X
 ADC STARTB
 STA ENDB
 LDX #0
 JSR RETRIG

UPDATE2
 LDA FRACTION+1
 ADC STEPL+1
 STA FRACTION+1
 LDA TRKPNTL+1
 ADC STEPH+1
 STA TRKPNTL+1
 STA DMALO
 LDA TRKPNTH+1
 ADC #0
 STA TRKPNTH+1
 STA DMAHI
 LDA TRKPNTB+1
 ADC #0
 STA TRKPNTB+1
 STA DMABNK
 LDA #32
 STA DMADAL
 CLC
 LDX SECOND
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX EIGHTH+1
 LDY TRK2DATA,X
 ADC (VOL2),Y
 LDX SIXTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX FOURTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 STA SOUNDOUT
 LDA #$49
 LDX #$41
 STA CLOCKSOUND
 STX CLOCKSOUND

 LDX #5
DELLOOP3
 DEX
 BNE DELLOOP3

 LDA #$95
 DEC CLOCK
 STA DMACMD
 STA CLOCK
 CLC
 LDX THIRD
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDY TRK2DATA
 ADC (VOL2),Y
 LDX SEVENTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX FIFTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 STA SOUNDOUT
 LDA #$49
 LDX #$41
 STA CLOCKSOUND
 STX CLOCKSOUND

 LDX #6
DELLOOP4
 DEX
 BNE DELLOOP4

 SEC
 LDA TRKPNTL+1
 SBC ENDL+1
 LDA TRKPNTH+1
 SBC ENDH+1
 LDA TRKPNTB+1
 SBC ENDB+1
 BCC UPDATE3
 LDX SAMPLENUM+1
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE LOOPSAMP2
 LDX #1
 JSR RETRIG
 LDA #0
 STA SECOND+1
 STA THIRD+1
 STA FOURTH+1
 STA FIFTH+1
 STA SIXTH+1
 STA SEVENTH+1
 STA EIGHTH+1
 STA STEPL+1
 STA STEPH+1
 JSR SV2
 JMP UPDATE3

LOOPSAMP2
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+1
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+1
 LDA LSBLPLEN,X
 ADC STARTL
 STA ENDL+1
 LDA MSBLPLEN,X
 ADC STARTH+1
 STA ENDH+1
 LDA BNKLPLEN,X
 ADC STARTB+1
 STA ENDB+1
 LDX #1
 JSR RETRIG

UPDATE3
 LDA FRACTION+2
 ADC STEPL+2
 STA FRACTION+2
 LDA TRKPNTL+2
 ADC STEPH+2
 STA TRKPNTL+2
 STA DMALO
 LDA TRKPNTH+2
 ADC #0
 STA TRKPNTH+2
 STA DMAHI
 LDA TRKPNTB+2
 ADC #0
 STA TRKPNTB+2
 STA DMABNK
 LDA #32
 STA DMADAL
 CLC
 LDX FOURTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX SECOND+1
 LDY TRK2DATA,X
 ADC (VOL2),Y
 LDX EIGHTH+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX SIXTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 STA SOUNDOUT
 LDA #$49
 LDX #$41
 STA CLOCKSOUND
 STX CLOCKSOUND

 LDX #5
DELLOOP5
 DEX
 BNE DELLOOP5

 LDA #$95
 DEC CLOCK
 STA DMACMD
 STA CLOCK
 CLC
 LDX FIFTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX THIRD+1
 LDY TRK2DATA,X
 ADC (VOL2),Y
 LDY TRK3DATA
 ADC (VOL3),Y
 LDX SEVENTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 STA SOUNDOUT
 LDA #$49
 LDX #$41
 STA CLOCKSOUND
 STX CLOCKSOUND

 LDX #6
DELLOOP6
 DEX
 BNE DELLOOP6

 SEC
 LDA TRKPNTL+2
 SBC ENDL+2
 LDA TRKPNTH+2
 SBC ENDH+2
 LDA TRKPNTB+2
 SBC ENDB+2
 BCC UPDATE4
 LDX SAMPLENUM+2
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE LOOPSAMP3
 LDX #2
 JSR RETRIG
 LDA #0
 STA SECOND+2
 STA THIRD+2
 STA FOURTH+2
 STA FIFTH+2
 STA SIXTH+2
 STA SEVENTH+2
 STA EIGHTH+2
 STA STEPL+2
 STA STEPH+2
 JSR SV2
 JMP UPDATE4

LOOPSAMP3
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+2
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+2
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+2
 LDA LSBLPLEN,X
 ADC STARTL+2
 STA ENDL+2
 LDA MSBLPLEN,X
 ADC STARTH+2
 STA ENDH+2
 LDA BNKLPLEN,X
 ADC STARTB+2
 STA ENDB+2
 LDX #2
 JSR RETRIG

UPDATE4
 LDA FRACTION+3
 ADC STEPL+3
 STA FRACTION+3
 LDA TRKPNTL+3
 ADC STEPH+3
 STA TRKPNTL+3
 STA DMALO
 LDA TRKPNTH+3
 ADC #0
 STA TRKPNTH+3
 STA DMAHI
 LDA TRKPNTB+3
 ADC #0
 STA TRKPNTB+3
 STA DMABNK
 LDA #32
 STA DMADAL
 CLC
 LDX SIXTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FOURTH+1
 LDY TRK2DATA,X
 ADC (VOL2),Y
 LDX SECOND+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDX EIGHTH+3
 LDY TRK4DATA,X
 ADC (VOL4),Y
 STA SOUNDOUT
 LDA #$49
 LDX #$41
 STA CLOCKSOUND
 STX CLOCKSOUND

 LDX #5
DELLOOP7
 DEX
 BNE DELLOOP7

 LDA #$95
 DEC CLOCK
 STA DMACMD
 STA CLOCK
 CLC
 LDX SEVENTH
 LDY TRK1DATA,X
 LDA (VOL1),Y
 LDX FIFTH+1
 LDY TRK2DATA,X
 ADC (VOL2),Y
 LDX THIRD+2
 LDY TRK3DATA,X
 ADC (VOL3),Y
 LDY TRK4DATA
 ADC (VOL4),Y
 STA SOUNDOUT
 LDA #$49
 LDX #$41
 STA CLOCKSOUND
 STX CLOCKSOUND
 SEC
 LDA TRKPNTL+3
 SBC ENDL+3
 LDA TRKPNTH+3
 SBC ENDH+3
 LDA TRKPNTB+3
 SBC ENDB+3
 BCC EXITMIXER
 LDX SAMPLENUM+3
 LDA LSBLPLEN,X
 ORA MSBLPLEN,X
 ORA BNKLPLEN,X
 BNE LOOPSAMP4
 LDX #3
 JSR RETRIG
 LDA #0
 STA SECOND+3
 STA THIRD+3
 STA FOURTH+3
 STA FIFTH+3
 STA SIXTH+3
 STA SEVENTH+3
 STA EIGHTH+3
 STA STEPL+3
 STA STEPH+3
 JSR SV2
 JMP EXITMIXER

LOOPSAMP4
 CLC
 LDA LSBSADDR,X
 ADC LSBLPPNT,X
 STA STARTL+3
 LDA MSBSADDR,X
 ADC MSBLPPNT,X
 STA STARTH+3
 LDA BNKSADDR,X
 ADC BNKLPPNT,X
 STA STARTB+3
 LDA LSBLPLEN,X
 ADC STARTL+3
 STA ENDL+3
 LDA MSBLPLEN,X
 ADC STARTH+3
 STA ENDH+3
 LDA BNKLPLEN,X
 ADC STARTB+3
 STA ENDB+3
 LDX #3
 JSR RETRIG

EXITMIXER
 LDA $DD0D
 AND #$01
 BNE EXITM2
 JMP MIXER

EXITM2
 LDA #$20
 STA CLOCKSOUND
 LDA #$09
 STA $DD0E
 RTS

; OW COMMAND INTERPRETERS

SLIDEUP
 STA PSLIDE,X
 LDA #<HINOTE
 STA NOTESTOPL,X
 LDA #>HINOTE
 STA NOTESTOPH,X
 RTS

SLIDEDN
 STA PSLIDE,X
 LDA #<LONOTE
 STA NOTESTOPL,X
 LDA #>LONOTE
 STA NOTESTOPH,X
 RTS

SLIDE2NT
 BNE CKSL2NT

SNT
 LDA PORTA,X

CKSL2NT
 STA PSLIDE,X
 STA PORTA,X
 DEY
 DEY
 LDA (PATINDEX),Y
 STA TEMPPER
 INY
 LDA (PATINDEX),Y
 AND #$0F
 STA TEMPPER+1
 ORA TEMPPER
 BEQ CONTSLIDE
 LDA TEMPPER
 STA NOTESTOPL,X
 LDA TEMPPER+1
 STA NOTESTOPH,X

CONTSLIDE
 SEC
 LDA NOTEPERL,X
 SBC NOTESTOPL,X
 LDA NOTEPERH,X
 SBC NOTESTOPH,X
 LDA #2
 BCC PORDOWN
 LDA #1

PORDOWN
 STA PORTAFLAG,X
 LDA #3
 STA COMMAND,X
 RTS

SLIDEVS
 JSR VOLSLIDE
 JSR SNT
 LDA #5
 STA COMMAND,X
 LDA #1
 STA SETVOLFLAG,X
 RTS

SOFFSET
 STA OFFSET,X
 RTS

VOLSLIDE
 STA TEMPA
 TAY
 LDA DIVIDE16,Y
 BEQ CHKY
 STA VSLIDE,X
 LDA #1
 STA VSLIDEDIR,X
 STA SETVOLFLAG,X
 RTS

CHKY
 LDA TEMPA
 AND #$0F
 BEQ NOVLS
 STA VSLIDE,X
 LDA #0
 STA VSLIDEDIR,X
 LDA #1
 STA SETVOLFLAG,X

NOVLS
 RTS

POSJUMP
 SEC
 CMP SONGLENGTH
 BEQ SETPOS
 BCC SETPOS
 RTS

SETPOS
 SEC
 SBC #1
 STA PATNUMBER
 RTS

SETVOL
 SEC
 CMP #64
 BCC SV
 LDA #63

SV
 STA TRACKVOL,X
 LDA ENABLEFLGS
 AND TRKTOBIT,X
 BEQ NOVOL
 LDA TRACKVOL,X
 LDY #1
 STY SETVOLFLAG,X

SV2
 TAY
 TXA
 ASL
 TAX
 TYA
 CLC
 ADC #>VOLTABLE
 STA VOL1+1,X

NOVOL
 RTS

PATBRK
 STA TEMPA
 AND #$0F
 STA TEMPB
 LDA TEMPA
 AND #$F0
 LSR
 LSR
 STA TEMPA
 LSR
 LSR
 CLC
 ADC TEMPA
 ASL
 ADC TEMPB
 LDX #0
 STX TEMPB
 ASL
 ROL TEMPB
 ASL
 ROL TEMPB
 ASL
 ROL TEMPB
 ASL
 ROL TEMPB
 CLC
 ADC #<PATTERNBUF
 STA BREAKADDR
 LDA TEMPB
 ADC #>PATTERNBUF
 STA BREAKADDR+1
 RTS

SETSPEED
 LDA CMDARG,X
 BNE DOSPD
 RTS

DOSPD
 SEC
 CMP #$20
 BCC SETTICKS
 STA TEMPOBPM
 JMP CALCTEMPO

SETTICKS
 STA TEMPOTPD

CALCTEMPO
 LDX TEMPOBPM
 LDA TEMPOTBH,X
 STA TEMPO+1
 LDA TEMPOTBL,X
 STA TEMPO
 LDA #$49
 STA $DD0E
 LDY TEMPOBPM
 LDX DIVIDE16,Y
 LDA DEC2HEX,X
 STA TEMPA
 TYA
 AND #$0F
 TAX
 STA TEMPB
 LDY #19
 LDA #149
 JSR WRITEREG
 DEY
 LDA #0
 JSR WRITEREG
 LDY #31
 LDA TEMPA
 JSR WRITEREG
 LDA DEC2HEX,X
 JSR WRITEREG
 LDA #'/'
 JSR WRITEREG
 LDY TEMPOTPD
 LDX DIVIDE16,Y
 LDA DEC2HEX,X
 STA TEMPA
 TYA
 AND #$0F
 TAX
 LDA TEMPA
 LDY #31
 JSR WRITEREG
 LDA DEC2HEX,X
 JSR WRITEREG
 RTS

; 'ICK' COMMAND INTERPRETERS

DSLIDEUP
 LDA NOTEPERL,X
 SEC
 SBC PSLIDE,X
 STA NOTEPERL,X
 LDA NOTEPERH,X
 SBC #0
 STA NOTEPERH,X
 BCC ENDOFSUP
 LDA NOTEPERL,X
 SEC
 SBC NOTESTOPL,X
 LDA NOTEPERH,X
 SBC NOTESTOPH,X
 BCC ENDOFSUP
 JSR STEPCALC
 RTS

ENDOFSUP
 LDA NOTESTOPL,X
 STA NOTEPERL,X
 LDA NOTESTOPH,X
 STA NOTEPERH,X
 JSR STEPCALC
 LDA #0
 STA PSLIDE,X
 STA PORTAFLAG,X
 RTS

DSLIDEDN
 LDA NOTEPERL,X
 CLC
 ADC PSLIDE,X
 STA NOTEPERL,X
 LDA NOTEPERH,X
 ADC #0
 STA NOTEPERH,X
 LDA NOTEPERL,X
 SEC
 SBC NOTESTOPL,X
 LDA NOTEPERH,X
 SBC NOTESTOPH,X
 BCS ENDOFSDN
 JSR STEPCALC
 RTS

ENDOFSDN
 LDA NOTESTOPL,X
 STA NOTEPERL,X
 LDA NOTESTOPH,X
 STA NOTEPERH,X
 JSR STEPCALC
 LDA #0
 STA PSLIDE,X
 STA PORTAFLAG,X
 RTS

DSLIDE2NT
 LDA PORTAFLAG,X
 BNE S2NT
 STA PSLIDE,X
 RTS

S2NT
 CMP #1
 BEQ DSLIDEUP
 CMP #2
 BEQ DSLIDEDN
 LDA #0
 STA PSLIDE,X
 STA PORTAFLAG,X
 RTS

DSLIDEVS
 JSR DSLIDE2NT
 JSR DVOLSLIDE
 RTS

DVOLSLIDE
 LDA VSLIDEDIR,X
 STX TEMPX
 BEQ VOLDOWN
 LDA TRACKVOL,X
 CLC
 ADC VSLIDE,X
 SEC
 CMP #64
 BCC SVLUP
 LDA #63

SVLUP
 STA TRACKVOL,X
 LDA ENABLEFLGS
 AND TRKTOBIT,X
 BEQ NOVSLIDE
 LDA #1
 STA SETVOLFLAG,X
 LDA TRACKVOL,X
 TAY
 TXA
 ASL
 TAX
 TYA
 CLC
 ADC #>VOLTABLE
 STA VOL1+1,X

NOVSLIDE
 LDX TEMPX
 RTS

VOLDOWN
 LDA TRACKVOL,X
 SEC
 SBC VSLIDE,X
 BCS SVLDN
 LDA #0

SVLDN
 STA TRACKVOL,X
 LDA ENABLEFLGS
 AND TRKTOBIT,X
 BEQ NOVSLIDE
 LDA #1
 STA SETVOLFLAG,X
 LDA TRACKVOL,X
 TAY
 TXA
 ASL
 TAX
 TYA
 CLC
 ADC #>VOLTABLE
 STA VOL1+1,X
 LDX TEMPX
 RTS

; ISC. OUTINES..

WRITEREG
 STY VDCREG

WR
 BIT VDCREG
 BPL WR
 STA VDCDATA
 RTS

WAITREG
 BIT VDCREG
 BPL WAITREG
 RTS

RETRIG
 LDA STARTL,X
 STA TRKPNTL,X
 LDA STARTH,X
 STA TRKPNTH,X
 LDA STARTB,X
 STA TRKPNTB,X
 RTS

SETSAMP1
 LDY #0
 LDA (PATINDEX),Y
 TAX
 LDA LSBSADDR,X
 STA STARTL
 STA TRKPNTL
 LDA MSBSADDR,X
 STA STARTH
 CLC
 ADC OFFSET
 STA TRKPNTH
 LDA BNKSADDR,X
 STA STARTB
 ADC #0
 STA TRKPNTB
 LDA LSBSEND,X
 STA ENDL
 LDA MSBSEND,X
 STA ENDH
 LDA BNKSEND,X
 STA ENDB
 LDA #0
 STA FRACTION
 LDA SETVOLFLAG
 BNE ES1
 LDX SAMPLENUM
 LDA VOLUMES,X
 LDX #0
 JSR SETVOL

ES1
 RTS

SETSAMP2
 LDY #4
 LDA (PATINDEX),Y
 TAX
 LDA LSBSADDR,X
 STA STARTL+1
 STA TRKPNTL+1
 LDA MSBSADDR,X
 STA STARTH+1
 CLC
 ADC OFFSET+1
 STA TRKPNTH+1
 LDA BNKSADDR,X
 STA STARTB+1
 ADC #0
 STA TRKPNTB+1
 LDA LSBSEND,X
 STA ENDL+1
 LDA MSBSEND,X
 STA ENDH+1
 LDA BNKSEND,X
 STA ENDB+1
 LDA #0
 STA FRACTION+1
 LDA SETVOLFLAG+1
 BNE ES2
 LDX SAMPLENUM+1
 LDA VOLUMES,X
 LDX #1
 JSR SETVOL

ES2
 RTS

SETSAMP3
 LDY #8
 LDA (PATINDEX),Y
 TAX
 LDA LSBSADDR,X
 STA STARTL+2
 STA TRKPNTL+2
 LDA MSBSADDR,X
 STA STARTH+2
 CLC
 ADC OFFSET+2
 STA TRKPNTH+2
 LDA BNKSADDR,X
 STA STARTB+2
 ADC #0
 STA TRKPNTB+2
 LDA LSBSEND,X
 STA ENDL+2
 LDA MSBSEND,X
 STA ENDH+2
 LDA BNKSEND,X
 STA ENDB+2
 LDA #0
 STA FRACTION+2
 LDA SETVOLFLAG+2
 BNE ES3
 LDX SAMPLENUM+2
 LDA VOLUMES,X
 LDX #2
 JSR SETVOL

ES3
 RTS

SETSAMP4
 LDY #12
 LDA (PATINDEX),Y
 TAX
 LDA LSBSADDR,X
 STA STARTL+3
 STA TRKPNTL+3
 LDA MSBSADDR,X
 STA STARTH+3
 CLC
 ADC OFFSET+3
 STA TRKPNTH+3
 LDA BNKSADDR,X
 STA STARTB+3
 ADC #0
 STA TRKPNTB+3
 LDA LSBSEND,X
 STA ENDL+3
 LDA MSBSEND,X
 STA ENDH+3
 LDA BNKSEND,X
 STA ENDB+3
 LDA #0
 STA FRACTION+3
 LDA SETVOLFLAG+3
 BNE ES4
 LDX SAMPLENUM+3
 LDA VOLUMES,X
 LDX #3
 JSR SETVOL

ES4
 RTS

SV3
 SEC
 CMP #64
 BCC SV3B
 LDA #63

SV3B
 STA TRACKVOL,X
 LDA ENABLEFLGS
 AND TRKTOBIT,X
 BEQ NOVOL3
 LDA TRACKVOL,X
 TAY
 TXA
 ASL
 TAX
 TYA
 CLC
 ADC #>VOLTABLE
 STA VOL1+1,X

NOVOL3
 RTS

DISPVOL
 LDY #19
 LDA VDISPTBL,X
 JSR WRITEREG
 DEY
 LDA VDISPTBL+4,X
 JSR WRITEREG
 LDY TRACKVOL,X
 STY TEMPA
 LDX DIVIDE16,Y
 LDY #31
 LDA DEC2HEXR,X
 JSR WRITEREG
 LDA TEMPA
 AND #$0F
 TAX
 LDA DEC2HEXR,X
 JSR WRITEREG
 RTS

DISPSAMP
 LDA ENABLEFLGS
 AND TRKTOBIT,X
 BEQ NODISPSAMP
 STY TEMPA
 LDY #19
 LDA SCTRGLSB,X
 JSR WRITEREG
 DEY
 STY VDCREG
 LDA SCTRGMSB,X
 STA VDCDATA
 LDA #128
 LDY #24
 JSR WRITEREG
 LDX TEMPA
 LDY #33
 STY VDCREG
 LDA SCSRCLSB,X
 STA VDCDATA
 DEY
 STY VDCREG
 LDA SCSRCMSB,X
 STA VDCDATA
 LDY #30
 STY VDCREG
 LDA #26
 STA VDCDATA

NODISPSAMP
 RTS

STEPCALC
 LDA NOTEPERL,X
 CLC
 ADC #<NTPERIOD
 STA TEMPPNT1
 LDA NOTEPERH,X
 ADC #>NTPERIOD
 STA TEMPPNT1+1
 LDY #0
 LDA (TEMPPNT1),Y
 STA STEPL,X
 LDA TEMPPNT1+1
 CLC
 ADC #4
 STA TEMPPNT1+1
 LDA (TEMPPNT1),Y
 STA STEPH,X
 TAY
 LDA STEPDIV1,Y
 STA SECOND,X
 LDA STEPDIV2,Y
 STA THIRD,X
 LDA STEPDIV3,Y
 STA FOURTH,X
 LDA STEPDIV4,Y
 STA FIFTH,X
 LDA STEPDIV5,Y
 STA SIXTH,X
 LDA STEPDIV6,Y
 STA SEVENTH,X
 LDA STEPDIV7,Y
 STA EIGHTH,X
 RTS

START1
 LDA STARTL
 STA TRKPNTL
 LDA STARTH
 STA TRKPNTH
 LDA STARTB
 STA TRKPNTB
 RTS

START2
 LDA STARTL+1
 STA TRKPNTL+1
 LDA STARTH+1
 STA TRKPNTH+1
 LDA STARTB+1
 STA TRKPNTB+1
 RTS

START3
 LDA STARTL+2
 STA TRKPNTL+2
 LDA STARTH+2
 STA TRKPNTH+2
 LDA STARTB+2
 STA TRKPNTB+2
 RTS

START4
 LDA STARTL+3
 STA TRKPNTL+3
 LDA STARTH+3
 STA TRKPNTH+3
 LDA STARTB+3
 STA TRKPNTB+3
 RTS

PRINT
 LDA #0
 STA PAGE0HI
 STA PAGE0LO
 STA MMUCR
 STX TEMPPNT3
 STY TEMPPNT3+1
 TAY

PM
 LDA (TEMPPNT3),Y
 BEQ SP
 JSR BSOUT
 INY
 JMP PM

SP
 LDA #0
 STA PAGE0HI
 LDA #>NEWPAGE0
 STA PAGE0LO
 LDA #BANK0
 STA MMUCR
 RTS

TOGGLEDISP
 STX TEMPX
 LDX #<MOVE2TRK1
 LDY #>MOVE2TRK1
 JSR PRINT
 LDA #3
 SEC
 SBC TEMPX
 CLC
 ADC #<MOVEDOWN
 TAX
 LDA #>MOVEDOWN
 ADC #0
 TAY
 JSR PRINT
 LDA ENABLEFLGS
 LDX TEMPX
 EOR TRKTOBIT,X
 STA ENABLEFLGS
 AND TRKTOBIT,X
 BEQ TRACKOFF
 JMP TRACKON

TRACKOFF
 LDX #<MUTETRACK
 LDY #>MUTETRACK
 JSR PRINT
 LDX TEMPX
 LDA #0
 JSR SV2
 LDX TEMPX
 LDA SCTRGLSB,X
 LDY #19
 JSR WRITEREG
 DEY
 LDA SCTRGMSB,X
 JSR WRITEREG
 LDA #128
 LDY #24
 JSR WRITEREG
 LDY #33
 LDA SCSRCLSB
 JSR WRITEREG
 DEY
 LDA SCSRCMSB
 JSR WRITEREG
 LDY #30
 LDA #26
 JSR WRITEREG
 LDA TEMPX
 BNE C2OFF
 LDA #30
 STA TEMPA
 LDA #1
 STA TEMPB
 JMP TRKOFF

C2OFF
 CMP #1
 BNE C3OFF
 LDA #110
 STA TEMPA
 LDA #1
 STA TEMPB
 JMP TRKOFF

C3OFF
 CMP #2
 BNE C4OFF
 LDA #190
 STA TEMPA
 LDA #1
 STA TEMPB
 JMP TRKOFF

C4OFF
 LDA #14
 STA TEMPA
 LDA #2
 STA TEMPB

TRKOFF
 LDA TEMPA
 LDY #19
 JSR WRITEREG
 DEY
 LDA TEMPB
 JSR WRITEREG
 LDA #128
 LDY #24
 JSR WRITEREG
 LDY #33
 LDA CMDSRCL+8
 JSR WRITEREG
 DEY
 LDA CMDSRCH+8
 JSR WRITEREG
 LDY #30
 LDA #23
 JSR WRITEREG
 LDA TEMPX
 BNE V2OFF
 LDA #17
 STA TEMPA
 LDA #1
 STA TEMPB
 JMP TRKOFF2

V2OFF
 CMP #1
 BNE V3OFF
 LDA #97
 STA TEMPA
 LDA #1
 STA TEMPB
 JMP TRKOFF2

V3OFF
 CMP #2
 BNE V4OFF
 LDA #177
 STA TEMPA
 LDA #1
 STA TEMPB
 JMP TRKOFF2

V4OFF
 LDA #1
 STA TEMPA
 LDA #2
 STA TEMPB

TRKOFF2
 LDA TEMPA
 LDY #19
 JSR WRITEREG
 DEY
 LDA TEMPB
 JSR WRITEREG
 LDY #31
 LDA #160
 JSR WRITEREG
 JSR WRITEREG
 LDX TEMPX
 RTS

TRACKON
 LDA TEMPX
 ASL
 TAX
 LDA ENABLE,X
 STA TEMPA
 LDA ENABLE+1,X
 TAY
 LDX TEMPA
 JSR PRINT
 LDX TEMPX
 LDA TRACKVOL,X
 JSR SV2
 LDX TEMPX
 LDA SCTRGLSB,X
 LDY #19
 JSR WRITEREG
 DEY
 LDA SCTRGMSB,X
 JSR WRITEREG
 LDA #128
 LDY #24
 JSR WRITEREG
 LDA SAMPLENUM,X
 TAX
 LDY #33
 LDA SCSRCLSB,X
 JSR WRITEREG
 DEY
 LDA SCSRCMSB,X
 JSR WRITEREG
 LDY #30
 LDA #26
 JSR WRITEREG
 LDX TEMPX
 JSR DISPVOL
 LDX TEMPX
 RTS

; AMPLE LAYER OUTINES

PLAYSAMP 
 SEI
 STX STEPSA+1
 STY STEPSB+1
 LDX #BANK0
 STX MMUCR
 LDX #0
 STX PAGE0HI
 LDX #>NEWPAGE0
 STX PAGE0LO
 STA SAMPNUM
 TAX
 LDA LSBSADDR,X
 STA STARTSA+1
 LDA MSBSADDR,X
 STA STARTSB+1
 LDA BNKSADDR,X
 STA STARTSC+1
 CLC
 LDA LSBSEND,X
 STA ENDSMPA+1
 LDA MSBSEND,X
 STA ENDSMPB+1
 LDA BNKSEND,X
 STA ENDSMPC+1
 JSR STARTSA
 LDA #<REUDATA
 STA DMAADL
 LDA #>REUDATA
 STA DMAADH
 LDA #$C0
 STA DMAVER
 LDY #0
 JSR INITSOUND2

UPDATES
 CLC
FRACTS LDA #0
STEPSA ADC #0
 STA FRACTS+1
SAMPPNTA LDA #0
STEPSB ADC #0
 STA SAMPPNTA+1
 STA DMALO
SAMPPNTB LDA #0
 ADC #0
 STA SAMPPNTB+1
 STA DMAHI
SAMPPNTC LDA #0
 ADC #0
 STA SAMPPNTC+1
 STA DMABNK
 LDA #1
 STA DMADAL
 LDA #$95
 STY CLOCK
 STA DMACMD
 STA CLOCK
 SEC
 LDA SAMPPNTA+1
ENDSMPA SBC #0
 LDA SAMPPNTB+1
ENDSMPB SBC #0
 LDA SAMPPNTC+1
ENDSMPC SBC #0
 BCC CYCLESMP
 JMP STOPSAMP

CYCLESMP
 LDA REUDATA
 STA SOUNDOUT
 LDA #$49
 LDX #$41
 STA CLOCKSOUND
 STX CLOCKSOUND
 LDA #$7F
 STA KEYCOLS
 LDA KEYROWS
 CMP #$EF
 BEQ STOPSAMP
 JMP UPDATES

STOPSAMP
 LDA #0
 STA DMAVER
 STA MMUCR
 STA PAGE0HI
 STA PAGE0LO
 LDA #49
 STA CLOCKSOUND
 CLI
 RTS

STARTSA LDA #0
 STA SAMPPNTA+1
STARTSB LDA #0
 STA SAMPPNTB+1
STARTSC LDA #0
 STA SAMPPNTC+1
 RTS

INITSOUND
 JSR SILENCE

INITSOUND2
 LDA #$F0
 STA SUS_REL
 LDA #$26
 STA FREQ+1
 LDA BASFILTER         ; GET FILTER VALUE FROM 
 STA FILTER+1
 LDA BASRESON          ; GET RESONANCE VALUE FROM 
 ORA #$0F              ; FILTER ALL VOICES
 STA FILTVOC_RES
 LDA #$9F              ; MAX VOL,  FILTER, CUTOFF VOC 3
 STA VOLUME_FMODE
 RTS 

SILENCE
 LDA #0
 LDX #$20
 
INITLOOP1
 DEX
 STA $D400,X
 BNE INITLOOP1
 RTS

