/* Definitions of target machine for GNU compiler, for the 6502. */
/* Contributed by Dave McWherter at Franklin Electronic Publishers
	(Dave_Mcwherter@franklin.com). */

/* There are changes in the compiler source for the 6502 #ifdef'ed with C6502. */
#define	C6502

/* Some things are specific to the Franklin environment. Non-Franklin users
should comment this out. */
#define	FRANKLIN

/* Define this if your system supports local labels of the form ".nnn". */
#define	LOCAL_LABELS

/* Required - preprocessor pre-defines in cccp.c */
#ifdef	__MWERKS__
#define CPP_PREDEFINES \
	"-DC6502 -D__c6502__ -DMAC -D__MAC__ \
	-Asystem(unix) -Asystem(bsd) -Acpu(c6502) -Amachine(c6502)"
#else
#define CPP_PREDEFINES \
	"-DC6502 -D__c6502__ -DUNIX -D__UNIX__ \
	-Asystem(unix) -Asystem(bsd) -Acpu(c6502) -Amachine(c6502)"
#endif	/* __MWERKS__ */

#ifndef CC1_SPEC
#define CC1_SPEC "-O2"
#endif

/* Override - data type to use for the result of subtracting two pointers -
defaults to "long int" */
#define PTRDIFF_TYPE "unsigned int"

/* Override - data type to use for wide characters - (what the hell is a
wide character?) - defaults to "int" */
#define WCHAR_TYPE "short unsigned int"

/* Override - size in bits of WCHAR_TYPE - used in cpp - defaults to INT_TYPE_SIZE */
#define WCHAR_TYPE_SIZE 16

/* Override - used in cpp - defaults to WCHAR_TYPE_SIZE */
#define MAX_WCHAR_TYPE_SIZE 16

/* Optional - Show we can debug even without a frame pointer. */
#define CAN_DEBUG_WITHOUT_FP

/* Optional - check option selections. Also used for machine-dependent
initialization. */
#define OVERRIDE_OPTIONS	md_init ()

/* Optional - Print subsidiary information on the compiler version in use. */
#define TARGET_VERSION fprintf (stderr, " (6502)");

/* Optional - Generate DBX debugging information. */
#define DBX_DEBUGGING_INFO

/* Optional - Run-time compilation parameters: */
extern int target_flags;

#define	TAR_16BITX	0x0001	/* Don't convert 16-bit indices to 8-bit */
#define	TAR_DOASR	0x0002	/* Don't convert asr's to lsr's */
#define	TAR_FARCALL	0x0004	/* Support Parnell's far call system */

#define	TARGET_16BITX	(target_flags & TAR_16BITX)
#define	TARGET_DOASR	(target_flags & TAR_DOASR)
#define	TARGET_FARCALL	(target_flags & TAR_FARCALL)

/* Macro to define tables used to set the flags.
	This is a list in braces of pairs in braces,
	each pair being { "NAME", VALUE }
	where VALUE is the bits to set or minus the bits to clear.
	An empty string NAME is used to identify the default VALUE. */

#define TARGET_SWITCHES \
	{ \
		{ "16bitx",	TAR_16BITX }, \
		{ "doasr",	TAR_DOASR }, \
		{ "farcall",	TAR_FARCALL }, \
		SUBTARGET_SWITCHES \
		{ "",	TARGET_DEFAULT} \
	}

#define TARGET_DEFAULT	0	/* No default switches. */

extern	char	*md_config_file;
#define	TARGET_OPTIONS \
	{ { "config-", &md_config_file } }	/* Specify a configuration file */

/* This is meant to be redefined in the host dependent files */
#define SUBTARGET_SWITCHES

/* target machine storage layout */

/* Define this if most significant bit is lowest numbered
in instructions that operate on numbered bit-fields. */
#define BITS_BIG_ENDIAN 1

/* Define this if most significant byte of a word is the lowest numbered. */
#define BYTES_BIG_ENDIAN 0

/* Define this if most significant word of a multiword number is the lowest
numbered. */
/* Doubles are stored in memory with the high order word first. This
matters when cross-compiling. */
#define WORDS_BIG_ENDIAN 0

/* number of bits in an addressable storage unit */
#define BITS_PER_UNIT 8

/* Width in bits of a "word", which is the contents of a machine register.
Note that this is not necessarily the width of data type `int';
if using 16-bit ints on a 68000, this would still be 32.
But on a machine with 16-bit registers, this would be 16. */
#define BITS_PER_WORD		24
#define MAX_BITS_PER_WORD	BITS_PER_WORD

/* Width of a word, in units (bytes). */
#define UNITS_PER_WORD		3
#define MAX_UNITS_PER_WORD	3

/* Now define the sizes of the C data types. */

#define SHORT_TYPE_SIZE		16
#define INT_TYPE_SIZE		16
#define LONG_TYPE_SIZE		24

/* Width in bits of a pointer.
See also the macro `Pmode' defined below. */
#define POINTER_SIZE	16

/* Allocation boundary (in *bits*) for storing arguments in argument list. */
#define PARM_BOUNDARY 8

/* Boundary (in *bits*) on which stack pointer should be aligned. */
#define STACK_BOUNDARY 8

/* Allocation boundary (in *bits*) for the code of a function. */
#define FUNCTION_BOUNDARY 8

/* Alignment of field after `int : 0' in a structure. */
#define EMPTY_FIELD_BOUNDARY 8

/* Every structure's size must be a multiple of this. */
#define STRUCTURE_SIZE_BOUNDARY 8

/* No data type wants to be aligned rounder than this. */
#define BIGGEST_ALIGNMENT 8

/* The best alignment to use in cases where we have a choice. */
#define FASTEST_ALIGNMENT 8

/* Set this nonzero if move instructions will actually fail to work
when given unaligned data. */
#define STRICT_ALIGNMENT	0

/******************************************************************************/
/* Register stuff. */

/* Number of actual hardware registers.
	The hardware registers are assigned numbers for the compiler
	from 0 to just below FIRST_PSEUDO_REGISTER.
	All registers that the compiler knows about must be given numbers,
	even those that are not normally considered general registers.

		15 GP registers	0 - 15
		SP		16
		FP		17
				__
				18
	
/* Specify the registers used for certain standard purposes.
	The values of these macros are register numbers. */

/* Register to use for pushing function arguments. */
#define STACK_POINTER_REGNUM 16

/* Base register for access to local variables of the function. */
#define FRAME_POINTER_REGNUM 17

#define FIRST_PSEUDO_REGISTER 18
#define	N_GENERAL_REGS	16
#define	N_BASE_REGS	(N_GENERAL_REGS + 2)	/* Allow gpr + sp + fp */
#define	N_INDEX_REGS	(N_GENERAL_REGS + 2)	/* Allow gpr + sp + fp */
#define	BASE_INCOMING_ARG_REG	0
#define	BASE_PASSING_ARG_REG	0
#define	BASE_RETURN_VALUE_REG	0
#define	BASE_OUTGOING_VALUE_REG	0

/* Define the number of registers that can hold parameters.
	MODE is the mode of the argument.
	All args are passed in r0-r11. */
#define	FIRST_ARG_REG	0
#define	LAST_ARG_REG	11
#define N_ARG_REGS(MODE) \
	(GET_MODE_CLASS (MODE) == MODE_FLOAT ? 0 : (LAST_ARG_REG - FIRST_ARG_REG + 1))

/* 1 for registers that have pervasive standard uses
	and are not available for the register allocator. */

#define FIXED_REGISTERS \
 { \
	0, 0, 0, 0, 0, 0, 0, 0,	/* r0 - r7 */ \
	0, 0, 0, 0, 0, 0, 0, 0,	/* r8 - r15 */ \
	1,			/* r16 - sp */ \
	1			/* r17 - fp */ \
}

/* 1 for registers not available across function calls.
	These must include the FIXED_REGISTERS and also any
	registers that can be used without being saved.
	The latter must include the registers where values are returned
	and the register where structure-value addresses are passed.
	Aside from that, you can include as many other registers as you like. */

#define CALL_USED_REGISTERS \
 { \
	1, 1, 1, 1, 1, 1, 1, 1,	/* r0 - r7 */ \
	0, 0, 0, 0, 0, 0, 0, 0,	/* r8 - r15 */ \
	1,			/* r16 - sp */ \
	1			/* r17 - fp */ \
}

/******************************************************************************/
/* How to refer to registers in assembler output.
	This sequence is indexed by compiler's hard-register-number (see above). */

#define REGISTER_NAMES \
{ \
	"r0" , "r1" , "r2" , "r3" , "r4" , "r5" , "r6" , "r7", \
	"r8" , "r9" , "r10" , "r11" , "r12" , "r13" , "r14" , "r15", \
	"sp" , "fp" \
}

/* Base register for access to arguments of the function. */
#define ARG_POINTER_REGNUM FRAME_POINTER_REGNUM

/* Structure addresses are passed in this register. */
#define	STRUCT_VALUE_REGNUM	0

/* Define the classes of registers for register constraints in the
	machine description. Also define ranges of constants.

	One of the classes must always be named ALL_REGS and include all hard regs.
	If there is more than one class, another class must be named NO_REGS
	and contain no registers.

	The name GENERAL_REGS must be the name of a class (or an alias for
	another name such as ALL_REGS). This is the class of registers
	that is allowed by "g" or "r" in a register constraint.
	Also, registers outside this class are allocated only when
	instructions express preferences for them.

	The classes must be numbered in nondecreasing order; that is,
	a larger-numbered class must never be contained completely
	in a smaller-numbered class.

	For any two classes, it is very desirable that there be another
	class that represents their union. */

enum reg_class {
	NO_REGS,
	STACK_REGS,		/* f, x */
	GPR_REGS,		/* r */
	GENERAL_REGS,		/* r, f, x */
	ALL_REGS,
	LIM_REG_CLASSES
};

#define N_REG_CLASSES (int) LIM_REG_CLASSES

/* Give names of register classes as strings for dump file. */

#define REG_CLASS_NAMES { \
	"NO_REGS", \
	"STACK_REGS", \
	"GPR_REGS", \
	"GENERAL_REGS", \
	"ALL_REGS" \
}

/* Define which registers fit in which classes.
	This is an initializer for a vector of HARD_REG_SET
	of length N_REG_CLASSES. */

#define REG_CLASS_CONTENTS { \
	0,		/* NO_REGS */ \
	0x03FF00,	/* STACK_REGS */ \
	0x00FFFF,	/* GPR_REGS */ \
	0x03FFFF,	/* GENERAL_REGS */ \
	0x03FFFF	/* ALL_REGS */ \
}

/* The same information, inverted:
	Return the class number of the smallest class containing
	reg number REGNO. This could be a conditional expression
	or could index an array. */

#define REGNO_REG_CLASS(REGNO) \
(	((REGNO == STACK_POINTER_REGNUM) || (REGNO == FRAME_POINTER_REGNUM)) \
		? STACK_REGS \
		: GENERAL_REGS \
)

/* The class value for index registers, and the one for base regs. */
#define INDEX_REG_CLASS GENERAL_REGS
#define BASE_REG_CLASS GENERAL_REGS

/* Get reg_class from a letter such as appears in the machine description. */

#define REG_CLASS_FROM_LETTER(C) \
(	(((C) == 'f') || ((C) == 'x')) \
		? STACK_REGS \
		: NO_REGS \
)

/* Return number of consecutive hard regs needed starting at reg REGNO
	to hold something of mode MODE.
	This is ordinarily the length in words of a value of mode MODE
	but can be less for certain modes in special long registers. */

#define HARD_REGNO_NREGS(REGNO, MODE) \
	((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

/* Value is 1 if hard register REGNO can hold a value of machine-mode MODE. */
#define	HARD_REGNO_MODE_OK(REGNO, MODE) \
(	(	(GET_MODE_CLASS(MODE) == MODE_INT) || \
		(GET_MODE_CLASS(MODE) == MODE_PARTIAL_INT) || \
		(GET_MODE_CLASS(MODE) == MODE_COMPLEX_INT) || \
		(GET_MODE_CLASS(MODE) == MODE_CC) \
	) &&\
	(GET_MODE_SIZE(MODE) <= 3) \
)

/* Value is 1 if it is a good idea to tie two pseudo registers
	when one has mode MODE1 and one has mode MODE2.
	If HARD_REGNO_MODE_OK could produce different values for MODE1 and MODE2,
	for any hard reg, then this must be 0 for correct output. */
#define MODES_TIEABLE_P(MODE1, MODE2)	0

/* Given an rtx X being reloaded into a reg required to be
	in class CLASS, return the class of reg to actually use.
	In general this is just CLASS; but on some machines
	in some cases it is preferable to use a more restrictive class. */
#define PREFERRED_RELOAD_CLASS(X,CLASS) GPR_REGS

/* Return the maximum number of consecutive registers
	needed to represent mode MODE in a register of class CLASS. */
/* On the 6502, this is the size of MODE in words. */
#define CLASS_MAX_NREGS(CLASS, MODE) \
	((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

/* Macros to check register numbers against specific register classes. */

/* These assume that REGNO is a hard or pseudo reg number.
	They give nonzero only if REGNO is a hard reg of the suitable class
	or a pseudo reg currently allocated to a suitable hard reg.
	Since they use reg_renumber, they are safe only once reg_renumber
	has been allocated, which happens in local-alloc.c. */

#define REGNO_OK_FOR_INDEX_P(REGNO) \
(	(	(REGNO) < N_INDEX_REGS || \
		(unsigned) reg_renumber[REGNO] < N_INDEX_REGS \
	) \
)

#define REGNO_OK_FOR_BASE_P(REGNO) \
(	(	(REGNO) < N_BASE_REGS || \
		(unsigned) reg_renumber[REGNO] < N_BASE_REGS \
	) \
)

/* Maximum number of registers that can appear in a valid memory address. */

#define MAX_REGS_PER_ADDRESS 2

/******************************************************************************/
/* Stack frame stuff:

/* Value should be nonzero if functions must have frame pointers.
	Zero means the frame pointer need not be set up (and parms
	may be accessed via the stack pointer) in functions that seem suitable.
	This is computed in `reload', in reload1.c.
	Used in flow.c, global.c, and reload1.c. */
#define FRAME_POINTER_REQUIRED	0

/* C statement to store the difference between the frame pointer
	and the stack pointer values immediately after the function prologue. */
#define INITIAL_FRAME_POINTER_OFFSET(VAR) \
	(VAR) = (md_compute_frame_pointer_offset())

/* Define this if pushing a word on the stack
	makes the stack pointer a smaller address. */
#define STACK_GROWS_DOWNWARD

/* Define this if the nominal address of the stack frame
	is at the high-address end of the local variables;
	that is, each additional local variable allocated
	goes at a more negative offset in the frame. */
#define FRAME_GROWS_DOWNWARD

/* Offset within stack frame to start allocating local variables at.
	If FRAME_GROWS_DOWNWARD, this is the offset to the END of the
	first local allocated. Otherwise, it is the offset to the BEGINNING
	of the first local allocated. */
#define STARTING_FRAME_OFFSET	0

/* Generate necessary RTL for __builtin_saveregs().
	ARGLIST is the argument list; see expr.c. */
#define EXPAND_BUILTIN_SAVEREGS(ARGLIST) \
	md_builtin_saveregs (ARGLIST)

/******************************************************************************/
/* Function arguments and return values: */

/* Offset of first parameter from the argument pointer register value. */

#define FIRST_PARM_OFFSET(FNDECL) \
	md_first_parm_offset(FNDECL)

/* Value is the number of bytes of arguments automatically
	popped when returning from a subroutine call.
	FUNTYPE is the data type of the function (as a tree),
	or for a library call it is an identifier node for the subroutine name.
	SIZE is the number of bytes of arguments passed on the stack. */

#define RETURN_POPS_ARGS(FUNDECL,FUNTYPE,STACK_SIZE) 0

/* Define how to find the value returned by a function.
	VALTYPE is the data type of the value (as a tree).
	If the precise function being called is known, FUNC is its FUNCTION_DECL;
	otherwise, FUNC is 0. */

#define FUNCTION_VALUE(VALTYPE, FUNC) \
	gen_rtx (REG, TYPE_MODE (VALTYPE), BASE_RETURN_VALUE_REG)

/* But the called function leaves it in the first "input" register. */

#define FUNCTION_OUTGOING_VALUE(VALTYPE, FUNC) \
	gen_rtx (REG, TYPE_MODE (VALTYPE), BASE_OUTGOING_VALUE_REG)

/* Define how to find the value returned by a library function
	assuming the value has mode MODE. */

#define LIBCALL_VALUE(MODE) \
	gen_rtx (REG, MODE, BASE_RETURN_VALUE_REG)

/* 1 if N is a possible register number for a function value
	as seen by the caller. */

#define FUNCTION_VALUE_REGNO_P(N) ((N) == 0)

/* 1 if N is a possible register number for function argument passing. */

#define FUNCTION_ARG_REGNO_P(N) \
	((N >= FIRST_ARG_REG) && (N <= LAST_ARG_REG))

/* Define a data type for recording info about an argument list
	during the scan of that argument list. This data type should
	hold all necessary information about the function itself
	and about the args processed so far, enough to enable macros
	such as FUNCTION_ARG to determine where the next arg should go. */

#define CUMULATIVE_ARGS int

#define ROUND_REG(CUM, MODE) (CUM)

#define ROUND_ADVANCE(SIZE) \
	((SIZE + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

/* Initialize a variable CUM of type CUMULATIVE_ARGS
	for a call to a function whose data type is FNTYPE.
	For a library call, FNTYPE is 0.

	On the 6502, the offset always starts at 0: the first parm reg is always
	the same reg. */

extern	int	md_n_args;

#define INIT_CUMULATIVE_ARGS(CUM,FNTYPE,LIBNAME) \
	do { \
		((CUM) = 0); \
		md_n_args = 0; \
	} while (0)

/* Update the data in CUM to advance over an argument
	of mode MODE and data type TYPE.
	(TYPE is null for libcalls where that information may not be available.) */

#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED) \
	do { \
		(CUM) += (	(MODE) != BLKmode \
				? ROUND_ADVANCE (GET_MODE_SIZE (MODE)) \
				: ROUND_ADVANCE (int_size_in_bytes (TYPE)) \
			); \
		md_n_args++; \
	} while (0)

/* Return boolean indicating arg of mode MODE will be passed in a reg.
	This macro is only used in this file. */

#define PASS_IN_REG_P(CUM, MODE, TYPE) \
(	(CUM) < N_ARG_REGS (SImode) && \
	(	(TYPE)==0 || \
		! TREE_ADDRESSABLE ((tree)(TYPE)) \
	) && \
	(	(TYPE)==0 || \
		(MODE) != BLKmode || \
		(TYPE_ALIGN (TYPE) % PARM_BOUNDARY == 0) \
	) \
)

/* Determine where to put an argument to a function.
	Value is zero to push the argument on the stack,
	or a hard register in which to store the argument.

	MODE is the argument's machine mode.
	TYPE is the data type of the argument (as a tree).
		This is null for libcalls where that information may
		not be available.
	CUM is a variable of type CUMULATIVE_ARGS which gives info about
		the preceding args and about the function being called.
	NAMED is nonzero if this argument is a named parameter
		(otherwise it is an extra parameter matching an ellipsis). */

#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED) \
(	PASS_IN_REG_P ((CUM), (MODE), (TYPE)) \
	? gen_rtx (REG, (MODE), (BASE_PASSING_ARG_REG + ROUND_REG ((CUM), \
		(MODE)))) \
	: 0 \
)

/* Define where a function finds its arguments.
	This is different from FUNCTION_ARG because of register windows. */

#define FUNCTION_INCOMING_ARG(CUM, MODE, TYPE, NAMED) \
(	PASS_IN_REG_P ((CUM), (MODE), (TYPE)) \
	? gen_rtx (REG, (MODE), (BASE_INCOMING_ARG_REG + ROUND_REG ((CUM), \
		(MODE)))) \
	: 0 \
)

/* For an arg passed partly in registers and partly in memory,
	this is the number of registers used.
	For args passed entirely in registers or entirely in memory, zero. */

#define FUNCTION_ARG_PARTIAL_NREGS(CUM, MODE, TYPE, NAMED)  \
(	PASS_IN_REG_P ((CUM), (MODE), (TYPE)) && \
	(	(CUM) + ((MODE) == BLKmode \
		? ROUND_ADVANCE (int_size_in_bytes (TYPE)) \
		: ROUND_ADVANCE (GET_MODE_SIZE (MODE))) - N_ARG_REGS (SImode) > 0 \
	) \
	? (N_ARG_REGS (SImode) - (CUM)) \
	: 0 \
)

#define	FUNCTION_ARG_PASS_BY_REFERENCE(CUM, MODE, TYPE, NAMED) \
	MUST_PASS_IN_STACK (MODE, TYPE)

/******************************************************************************/
/* Constraint stuff: */

/* The letters I, J, K, L and M in a register constraint string
	can be used to stand for particular ranges of immediate operands.
	This macro defines what the ranges are.
	C is the letter, and VALUE is a constant value.
	Return 1 if VALUE is in the range specified by C.
*/

#define CONST_OK_FOR_LETTER_P(VALUE, C) \
((C) == 'I' \
	? 1 \
	: 0 \
)

/* Similar, but for floating constants, and defining letters G and H.
	Here VALUE is the CONST_DOUBLE rtx itself. */

#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C)	0

/* Recognize any constant value that is a valid address. */

#define CONSTANT_ADDRESS_P(X)	\
	(	GET_CODE (X) == LABEL_REF || \
		GET_CODE (X) == SYMBOL_REF || \
		GET_CODE (X) == CONST_INT || \
		GET_CODE (X) == HIGH || \
		GET_CODE (X) == CONST \
	)

/* Nonzero if the constant value X is a legitimate general operand.
	Anything can be made to work except floating point constants. */

#define LEGITIMATE_CONSTANT_P(X) \
	(1)

/* The macros REG_OK_FOR..._P assume that the arg is a REG rtx
	and check its validity for a certain class.
	We have two alternate definitions for each of them.
	The usual definition accepts all pseudo regs; the other rejects
	them unless they have been allocated suitable hard regs.
	The symbol REG_OK_STRICT causes the latter definition to be used.

	Most source files want to accept pseudo regs in the hope that
	they will get allocated to the class that the insn wants them to be in.
	Source files for reload pass need to be strict.
	After reload, it makes no difference, since pseudo regs have
	been eliminated by then. */

/* Optional extra constraints for this machine. Borrowed from romp.h.

	For the 6502:

	'f' is the frame pointer register FP (not supported).
	'x' is the stack pointer register SP. */

#ifndef REG_OK_STRICT

/* Nonzero if X is a hard reg that can be used as an index
	or if it is a pseudo reg. */
#define REG_OK_FOR_INDEX_P(X) \
(	((unsigned) REGNO (X)) - N_INDEX_REGS >= (FIRST_PSEUDO_REGISTER - N_INDEX_REGS) \
)

/* Nonzero if X is a hard reg that can be used as a base reg
	or if it is a pseudo reg. */
#define REG_OK_FOR_BASE_P(X) \
(	((unsigned) REGNO (X)) - N_BASE_REGS >= (FIRST_PSEUDO_REGISTER - N_BASE_REGS) \
)

/* Nonzero if X is a hard GPR or a pseudo register. */
#define	REG_OK_FOR_GPR(X) \
(	((REGNO(X) >= 0) && (REGNO(X) < N_GENERAL_REGS)) || \
	(REGNO(X) >= FIRST_PSEUDO_REGISTER) \
)

/* Nonzero if X is hard reg FP or a pseudo register. */
#define	REG_OK_FOR_FP(X) \
	((REGNO(X) == FRAME_POINTER_REGNUM) && (GET_CODE(X) == REG))

/* Nonzero if X is hard reg SP or a pseudo register. */
#define	REG_OK_FOR_SP(X) \
	((REGNO(X) == STACK_POINTER_REGNUM) && (GET_CODE(X) == REG))

#define EXTRA_CONSTRAINT(OP, C) \
((C) == 'Q' \
	? (md_mem_op(OP, Pmode)) \
	 : (C) == 'f' \
	 	? (GET_CODE (OP) == REG) && REG_OK_FOR_FP(OP) \
		: (C) == 'x' \
			? (GET_CODE (OP) == REG) && REG_OK_FOR_SP(OP) \
			: 0 \
)
 
#else

/* Nonzero if X is a hard reg that can be used as an index. */
#define REG_OK_FOR_INDEX_P(X) \
	REGNO_OK_FOR_INDEX_P (REGNO (X))

/* Nonzero if X is a hard reg that can be used as a base reg. */
#define REG_OK_FOR_BASE_P(X) \
	REGNO_OK_FOR_BASE_P (REGNO (X))

/* Nonzero if X is a hard GPR. */
#define	REG_OK_FOR_GPR(X) \
	 ((REGNO(X) >= 0) && (REGNO(X) < N_GENERAL_REGS))

/* Nonzero if X is hard reg FP. */
#define	REG_OK_FOR_FP(X) \
	((REGNO(X) == FRAME_POINTER_REGNUM) && (GET_CODE(X) == REG))

/* Nonzero if X is hard reg SP. */
#define	REG_OK_FOR_SP(X) \
	((REGNO(X) == STACK_POINTER_REGNUM) && (GET_CODE(X) == REG))

#define EXTRA_CONSTRAINT(OP, C) \
((C) == 'Q' \
	? (md_mem_op(OP, Pmode)) \
	 : (C) == 'f' \
	 	? (GET_CODE (OP) == REG) && REG_OK_FOR_FP(OP) \
		: (C) == 'x' \
			? (GET_CODE (OP) == REG) && REG_OK_FOR_SP(OP) \
			: 0 \
)
#endif

/* GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression
	that is a valid memory address for an instruction.
	The MODE argument is the machine mode for the MEM expression
	that wants to use this address. */

#define GO_IF_LEGITIMATE_ADDRESS(MODE, X, ADDR) \
	{ \
		int	ok = md_go_if_legitimate_address(X, MODE); \
		if (ok) { \
			goto ADDR; \
		} \
	}

/* Try machine-dependent ways of modifying an illegitimate address
	to be legitimate. If we find one, return the new, valid address.
	This macro is used in only one place: `memory_address' in explow.c.

	OLDX is the address as it was before break_out_memory_refs was called.
	In some cases it is useful to look at this to decide what needs to be done.

	MODE and WIN are passed so that this macro can use
	GO_IF_LEGITIMATE_ADDRESS.

	It is always safe for this macro to do nothing. It exists to recognize
	opportunities to optimize the output. */

#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN) \
	{ \
		rtx	new = md_legitimize_address(X, OLDX, MODE); \
		if (new) { \
			X = new; \
			goto WIN; \
		} \
	}

/* Go to LABEL if ADDR (a legitimate address expression)
	has an effect that depends on the machine mode it is used for.
	On the 6502 this is never true. */

#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR,LABEL)

/******************************************************************************/

/* Define this macro if references to a symbol must be treated differently
	depending on something about the variable or function named by the
	symbol (such as what section it is in). */
#define ENCODE_SECTION_INFO(DECL) \
	md_encode_section_info(DECL)

/* Specify the machine mode that this machine uses
	for the index in the tablejump instruction. */
#define CASE_VECTOR_MODE Pmode

/* Define this if the tablejump instruction expects the table
	to contain offsets from the address of the table.
	Do not define this if the table should contain absolute addresses. */
/* #define CASE_VECTOR_PC_RELATIVE */

/* This is the kind of divide that is easiest to do in the general case. */
#define EASY_DIV_EXPR TRUNC_DIV_EXPR

/* Define this as 1 if `char' should by default be signed; else as 0. */
#define DEFAULT_SIGNED_CHAR 1

/* Max number of bytes we can move from memory to memory
	in one reasonably fast instruction. */
#define MOVE_MAX 3

/* Nonzero if access to memory by bytes is slow and undesirable.
	For RISC chips, it means that access to memory by bytes is no
	better than access by words when possible, so grab a whole word
	and maybe make use of that. */
#define SLOW_BYTE_ACCESS 0

/* We assume that the store-condition-codes instructions store 0 for false
	and some other value for true. This is the value stored for true. */
#define STORE_FLAG_VALUE 1

/* Value is 1 if truncating an integer of INPREC bits to OUTPREC bits
	is done just by pretending it is already truncated. */
#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1

/* Specify the machine mode that pointers have.
	After generation of rtl, the compiler makes no further distinction
	between pointers and any other objects of this machine mode. */
#define Pmode	HImode

/* Generate calls to memcpy, memcmp and memset rather than bcop, bcmp, bset. */
#define TARGET_MEM_FUNCTIONS

/* A function address in a call instruction
	is a byte address (for indexing purposes)
	so give the MEM rtx a byte's mode. */
#define FUNCTION_MODE HImode

/* Define this if addresses of constant functions
	shouldn't be put through pseudo regs where they can be cse'd.
	Desirable on machines where ordinary constants are expensive
	but a CALL with constant address is cheap. */
	/* 6502 defines this because otherwise call addresses end up in
	registers which wastes registers and is more expensive then just
	jsr'ing to the address. */
#define NO_FUNCTION_CSE

/* alloca should avoid clobbering the old register save area. */
#define SETJMP_VIA_SAVE_AREA

/* Define subroutines to call to handle multiply and divide.
	The `*' prevents an underscore from being prepended by the compiler. */

#define DIVSI3_LIBCALL "*__div"
#define UDIVSI3_LIBCALL "*__udiv"
#define MODSI3_LIBCALL "*__rem"
#define UMODSI3_LIBCALL "*__urem"
/* .umul is a little faster than .mul. */
#define MULSI3_LIBCALL "*__umul"

/* Compute the cost of computing a constant rtl expression RTX
	whose rtx-code is CODE. The body of this macro is a portion
	of a switch statement. If the code is computed here,
	return it with a return statement. Otherwise, break from the switch. */
#define CONST_COSTS(RTX,CODE,OUTER_CODE) \
	case CONST_INT: \
	case LABEL_REF: \
	case CONST: \
	case SYMBOL_REF: \
		return 1; \
	case CONST_DOUBLE: \
		return 8;

/* Compute the cost of an address. */
#define ADDRESS_COST(RTX) \
	md_address_cost(RTX)

/* Compute extra cost of moving data between one register class
	and another. */
#define REGISTER_MOVE_COST(CLASS1, CLASS2) \
	md_register_move_cost(CLASS1, CLASS2)

#define	MEMORY_MOVE_COST(M) \
	md_memory_move_cost(M)

/* Provide the costs of a rtl expression. This is in the body of a
	switch on CODE. */
#define RTX_COSTS(X,CODE,OUTER_CODE) \
	default: \
		return md_rtx_costs(X, CODE, OUTER_CODE);

/******************************************************************************/
/* Assembly code output stuff: */

/* Output the label for a function definition. */

#define ASM_DECLARE_FUNCTION_NAME(FILE, NAME, DECL) \
	md_declare_function_name(FILE, NAME, DECL)

/* This macro generates the assembly code for function entry.
	FILE is a stdio stream to output the code to.
	SIZE is an int: how many units of temporary storage to allocate.
	Refer to the array `regs_ever_live' to determine which registers
	to save; `regs_ever_live[I]' is nonzero if register number I
	is ever used in the function. This macro is responsible for
	knowing which registers should not be saved even if used. */

extern int leaf_function;
#define FUNCTION_PROLOGUE(FILE, SIZE) \
	md_output_function_prologue (FILE, SIZE)

/* Output assembler code to FILE to increment profiler label # LABELNO
	for profiling a function entry. */

#define FUNCTION_PROFILER(FILE, LABELNO) \
	md_increment_profiler_label(FILE, LABELNO)

/* Output assembler code to FILE to initialize this source file's
	basic block profiling info, if that has not already been done. */

#define FUNCTION_BLOCK_PROFILER(FILE, LABELNO) \
	md_block_profiler_init(FILE, LABELNO)

/* Output assembler code to FILE to increment the entry-count for
	the BLOCKNO'th basic block in this source file. */

#define BLOCK_PROFILER(FILE, BLOCKNO) \
	md_block_profiler_increment(FILE, BLOCKNO)

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
	the stack pointer does not matter. The value is tested only in
	functions that have frame pointers.
	No definition is equivalent to always zero. */

extern int current_function_calls_alloca;
extern int current_function_outgoing_args_size;

#define EXIT_IGNORE_STACK \
(	get_frame_size () != 0 || \
	current_function_calls_alloca || \
	current_function_outgoing_args_size \
)

/* This macro generates the assembly code for function exit,
	on machines that need it. If FUNCTION_EPILOGUE is not defined
	then individual return instructions are generated for each
	return statement. Args are same as for FUNCTION_PROLOGUE.

	The function epilogue should not depend on the current stack pointer!
	It should use the frame pointer only. This is mandatory because
	of alloca; we also take advantage of it to omit stack adjustments
	before returning. */

/* This declaration is needed due to traditional/ANSI
	incompatibilities which cannot be #ifdefed away
	because they occur inside of macros. Sigh. */
extern union tree_node *current_function_decl;

#define FUNCTION_EPILOGUE(FILE, SIZE) \
	md_output_function_epilogue (FILE, SIZE)

/* Output assembler code for a block containing the constant parts
	of a trampoline, leaving space for the variable parts. */

#define TRAMPOLINE_TEMPLATE(FILE) \
	md_output_trampoline_template(FILE)

/* Length in units of the trampoline for entering a nested function. */
#define TRAMPOLINE_SIZE 20

/* Emit RTL insns to initialize the variable parts of a trampoline.
	FNADDR is an RTX for the address of the function's pure code.
	CXT is an RTX for the static chain value for the function. */

#define INITIALIZE_TRAMPOLINE(TRAMP, FNADDR, CXT) \
	md_initialize_trampoline (TRAMP, FNADDR, CXT)

/* Control the assembler format that we output. */

/* Output at beginning of assembler file. */

#define ASM_FILE_START(FILE) \
	md_file_start(FILE)

#define	ASM_IDENTIFY_GCC(FILE) \
	md_identify_gcc(FILE)

/* Output to assembler file text saying following lines
	may contain character constants, extra white space, comments, etc. */

#define ASM_APP_ON ""

/* Output to assembler file text saying following lines
	no longer contain unusual constructs. */

#define ASM_APP_OFF ""

#define ASM_LONG	"d24"
#define ASM_SHORT	"d16"
#define ASM_BYTE_OP	"d8"

/* Output before read-only data. */

#define TEXT_SECTION_ASM_OP \
	md_text_section_asm_op()

/* Output before writable data. */

#define DATA_SECTION_ASM_OP \
	md_data_section_asm_op()

/* How to renumber registers for dbx and gdb. */

#define DBX_REGISTER_NUMBER(REGNO) (REGNO)

/* This is how to output a note to DBX telling it the line number
	to which the following sequence of instructions corresponds. */

#define ASM_OUTPUT_SOURCE_LINE(FILE, LINE) \
	md_output_source_line(FILE, LINE)

/* This is how to output the definition of a user-level label named NAME,
	such as the label on a static function or variable NAME. */

#define ASM_OUTPUT_LABEL(FILE, NAME) \
	md_output_label(FILE, NAME)

/* This is how to output a command to make the user-level label named NAME
	defined for reference from other files. */

#define ASM_GLOBALIZE_LABEL(FILE,NAME) \
	md_globalize_label(FILE, NAME)

#define	ASM_OUTPUT_EXTERNAL(STREAM, DECL, NAME) \
	md_output_external(STREAM, DECL, NAME)

/* This is how to output a reference to a user-level label named NAME.
	`assemble_name' uses this. */

#define ASM_OUTPUT_LABELREF(FILE,NAME) \
	md_output_labelref(FILE, NAME)

/* This is how to output a definition of an internal numbered label where
	PREFIX is the class of label and NUM is the number within the class. */

#define ASM_OUTPUT_INTERNAL_LABEL(FILE,PREFIX,NUM) \
	md_output_internal_label(FILE, PREFIX, NUM)

/* This is how to store into the string LABEL
	the symbol_ref name of an internal numbered label where
	PREFIX is the class of label and NUM is the number within the class.
	This is suitable for output with `assemble_name'. */

#define ASM_GENERATE_INTERNAL_LABEL(LABEL,PREFIX,NUM) \
	md_generate_internal_label(LABEL, PREFIX, NUM)

/* A C statement (sans semicolon) to output to the stdio stream
	STREAM the assembler definition of a local-common-label named NAME
	whose size is SIZE bytes.  The variable ROUNDED is the size
	rounded up to whatever alignment the caller wants. */

#define	ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED) \
	md_output_local(FILE, NAME, SIZE, ROUNDED)

/* This is how to output an assembler line defining an `int' constant. */

#define ASM_OUTPUT_INT(FILE,VALUE) \
	md_output_int(FILE, VALUE)

/* Likewise for `char' and `short' constants. */

#define ASM_OUTPUT_SHORT(FILE,VALUE) \
	md_output_short(FILE, VALUE)

#define ASM_OUTPUT_CHAR(FILE,VALUE) \
	md_output_char(FILE, VALUE)

/* This is how to output an assembler line for a numeric constant byte. */

#define ASM_OUTPUT_BYTE(FILE,VALUE) \
	md_output_byte(FILE, VALUE)

/* This is how to output an element of a case-vector that is absolute. */

#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE) \
	md_output_addr_vec_elt(FILE, VALUE)

/* This is how to output an assembler line
	that says to advance the location counter
	to a multiple of 2**LOG bytes. */

#define ASM_OUTPUT_ALIGN(FILE,LOG)

#define ASM_OUTPUT_SKIP(FILE,SIZE) \
	md_output_skip(FILE, SIZE)

/* This says how to output an assembler line
	to define a global common symbol. */

#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED) \
	md_output_common(FILE, NAME, SIZE, ROUNDED)

/* Store in OUTPUT a string (made with alloca) containing
	an assembler-name for a local static variable named NAME.
	LABELNO is an integer which is different for each call. */

#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO) \
( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 10), \
	sprintf ((OUTPUT), "%s.%d", (NAME), (LABELNO)))

#define	ASM_OUTPUT_REG_PUSH(STREAM, REGNO) \
	fprintf(STREAM, "\tpush\t%s\n", reg_names[REGNO])

#define	ASM_OUTPUT_REG_POP(STREAM, REGNO) \
	fprintf(STREAM, "\tpop\t%s\n", reg_names[REGNO])

/* Define the parentheses used to group arithmetic operations
	in assembler code. */

#define ASM_OPEN_PAREN "("
#define ASM_CLOSE_PAREN ")"

/* A C statement to output to the stdio stream STREAM an assembler
	instruction to assemble a string constant containing the LEN bytes
	at PTR. PTR will be a C expression of type `char *' and LEN a C
	expression of type `int'. */

#define	ASM_OUTPUT_ASCII(FILE, PTR, LEN) \
	md_output_ascii((FILE), (PTR), (LEN))

/* Define results of standard character escape sequences. */
#define TARGET_BELL 007
#define TARGET_BS 010
#define TARGET_TAB 011
#define TARGET_NEWLINE 012
#define TARGET_VT 013
#define TARGET_FF 014
#define TARGET_CR 015

#define PRINT_OPERAND_PUNCT_VALID_P(CHAR) \
	(	((CHAR) == '#') ||	/* md_call_name */ \
		((CHAR) == ';') ||	/* md_comment */ \
		((CHAR) == '@') ||	/* md_label */ \
		((CHAR) == '$') ||	/* md_sp_label */ \
		((CHAR) == 'L') ||	/* low byte, bits 7-0 */ \
		((CHAR) == 'H') ||	/* high byte, bits 15-8 */ \
		((CHAR) == 'B') ||	/* bank byte, bits 23-16 */ \
		((CHAR) == 'V')		/* unspecified byte */ \
	)

/* Print operand X (an rtx) in assembler syntax to file FILE.
	CODE is a letter or dot (`z' in `%z0') or 0 if no letter was specified.
	For `%' followed by punctuation, CODE is the punctuation and X is null. */

#define PRINT_OPERAND(FILE, X, CODE) md_print_operand (FILE, X, CODE)

/* Print a memory address as an operand to reference that memory location. */

#define PRINT_OPERAND_ADDRESS(FILE, ADDR) \
	md_print_operand_address(FILE, ADDR)

/******************************************************************************/

#define NOTICE_UPDATE_CC(EXP, INSN)	{CC_STATUS_INIT;}

/* A C expression whose value is one if it is always safe to reverse a
	comparison whose mode is MODE.  If `SELECT_CC_MODE' can ever
	return MODE for a floating-point inequality comparison, then
	`REVERSIBLE_CC_MODE (MODE)' must be zero. */
#define	REVERSIBLE_CC_MODE(MODE)	1

/******************************************************************************/

#if	0
#define	DEFAULT_CALLER_SAVES
#endif

#define	CALLER_SAVE_PROFITABLE(REFS, CALLS) \
	md_caller_save_profitable(REFS, CALLS)

/******************************************************************************/
/* We want enum's to only be the largest size necessary */

#define	DEFAULT_SHORT_ENUMS	1

/******************************************************************************/
/* Define 'size_t' */

#define	SIZE_TYPE	"unsigned int"

/******************************************************************************/
/* Force structure assignments to be done with memcpy */

#define MOVE_RATIO (md_move_ratio())

/******************************************************************************/
/* If gcc thinks branches are "expensive", then it converts some simple BOOLEAN
expressions to a sequence of 24-bit negates and shifts. */

#define	BRANCH_COST	0

/******************************************************************************/
/* Used in md file to eliminate some typing */

#define	asm(x)	output_asm_insn(x, operands);

/******************************************************************************/

