/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Strings
 */

#include "strings.h"

/* Convert string to lowercase (not quite right this way, but is only used for
 * keywords anyway) */
static void String_ToLower(ListItem *p, int len) {
  int a;

  for(a = len-1; a >= 0; a--) p->String[a] |= 32;
}

/* Show copyright and usage message if not already shown */
static void String_ShowInfo() {
  if((ffProgram & FPROGRAM_INFOSHOWN) == 0) {
    ffProgram |= FPROGRAM_INFOSHOWN;
    printf(psInfo);
  }
}

/* Show start and end of current segment */
static void String_EndSegment() {
  if(PC_Mem != PC_CPU) Message(pswOffsetOn, EWARNING);
  if(ffPass & FPASSDOONCE) {
    Segment_Link(SegmentStart, PC_Mem-SegmentStart);
    if(lVerbosity > 1) {
      printf(psvSegment, SegmentStart, PC_Mem);
    }
  }
}
