/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

#ifndef platform_H
#define platform_H

/*
 * Platform specific stuff (in this case, for unknown OSes)
 */

typedef int         Sixteen;/* At least 16 bit */
typedef signed long Value;  /* At least 32 bit */

#define PORT_MESSAGE "Platform independent version / general UNIX version.\n"

/* Syntax message */
static char psUsage[] =
"Syntax: acme [-v] [-h] <file>\n"
"Options:\n"
"v(erbose)       Show some extra information\n"
"h(elp)          Show this message\n"
"\n";

/* Integer-to-character conversion routine */
#define PLATFORM_INT2CHAR(x)    \
  x ^= x >> 16;                 \
  x ^= x >>  8;                 \
  x &= 255

/* Character prefixing command line options */
#define PLATFORM_OPTIONPREFIX   '-'

/* Closedown sequence */
#define PLATFORM_EXIT

/* Convert UNIX-style pathname to system-style pathname */
#define PLATFORM_CONVERTPATH(a)

/* Platform specific message output */
#define PLATFORM_FN_MESSAGE(a, b)

/* Maximum length of filenames in sources */
#define LNFMAX          255

/* Maximum length of paths */
#define LNPMAX          4096

/* Setting the created files' types */
#define PLATFORM_SETFILETYPE(a, b)

/* Platform specific command line switches */
#define PLATFORM_SWITCHES

/* Error message to show when "_" variable cannot be found */
static char pseNoVarFound[] = "Error: '_' environment variable not found\n";

/*
 * Prototypes
 */
static void FN_Platform_FindLib(void);

#endif
