/* This program POKEs values in ZX-Spectrum snapshots.
   In case you do not know what a POKE is, get a snapshot
   of Manic Miner, and try to reach level 20.
   You can use it, distribute it, but please, do not tell
   you made it, because it was me who spent 2 hours on this
   If you make changes (for better, I suppose), share them
   with me, and if I ever become rich and/or famous, I will
   share half my fortune with you.

   Send suggestions, improvements, and beer to:
   cotrina@lia01.unizar.es

   or

   Francisco Cotrina
   Pampa, 4-0-2
   50012 Zaragoza
   Spain (Europe)
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int	is_sna, is_sp;
char	name_prog[80];

void	sintaxis(void)
{
printf("sintaxis: %s snapshot  address [value] \n", name_prog );
exit(-1);
}

void	poke_file(FILE *ap, float f_address, float f_value)
{
long	l_address;
int	i_value;

f_address-=16384.0;
if(is_sna)
	{
	f_address+=27.0;
	}
else
	{
	f_address+=38.0;
	}

l_address=(long)f_address;
i_value=(int)f_value;

fseek(ap,l_address,SEEK_SET);
putc(i_value,ap);
fclose(ap);

/* printf("POKEd %l , %i\n" , l_address, i_value ); */
}

void	error(char *cad)
{
perror(cad);
exit(-1);
}

void main(argc, argv)
int argc;
char **argv;
{
FILE	*ap;
float	f_address;
float	f_value;
char	snapshot[80], cad[200], cad2[200], *p;

/* command-line tests	*/
/* argc, argv */

if(argc<3)
	sintaxis();

strcpy(name_prog,argv[0]);
strcpy(snapshot,argv[1]);
p=strrchr(snapshot,'.');
if(p==NULL)	/* without extension */
	{
	strcat(snapshot,".SNA");
	ap=fopen(snapshot,"r+b");
	if(ap==NULL)	/* try with .SP	*/
		{
		strcpy(snapshot,argv[1]);
		strcat(snapshot,".SP");
		if(ap==NULL)
			{
			sprintf(cad,"Can not find  %s.SNA nor  %s.SP ", argv[1], argv[1] );
			error(cad);
			}
		}
	}
else	/* it has extension. check it */
	{
	is_sna=0; is_sp=0;
	if(stricmp(p,".sna") == 0) /* it found it */ /* no case sensitive */
		is_sna=1;
	else if(stricmp(p,".sp") == 0)
		is_sp=1;
	else
		error("Has not extension .SNA nor .SP");
	ap=fopen(snapshot,"r+b");
	if(ap==NULL)
		{
		strcpy(cad,"Can not locate the file ");
		strcat(cad,snapshot);
		error(cad);
		}
	}

/* now f_address */
strcpy(cad,argv[2]);
f_address=atof(cad);
if(f_address<16384.0)
	{
	strcpy(cad2,"Address ");
	strcat(cad2,cad);
	strcat(cad2," is <16384. Can not POKE in ROM");
	error(cad2);
	}
/* the same for values >65535 */
if(f_address>65535.0)
	{
	strcpy(cad2,"Address ");
	strcat(cad2,cad);
	strcat(cad2," is >65535. Can not POKE in over RAM");
	error(cad2);
	}

/* now f_value */
/* let's see if it exists */
if(argc<=3)
	f_value=0;
else
	{
	strcpy(cad, argv[3]);
	f_value=atof(cad);
	if(f_value>65535.0)
		{
		strcpy(cad2,"Value ");
		strcat(cad2,cad);
		strcat(cad2," is >65535. Can not POKE such a big value");
		error(cad2);
		}
		/* similar error than f_address */
	if(f_value<256.0)
		poke_file(ap, f_address, f_value);
	else
		{
		poke_file(ap,f_address, ((int)f_value)%256);
		poke_file(ap,f_address+1, f_value/256);
		}
	}

}