// File from page 790 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: SSHAPE2.CPP -- Alternative to SSHAPE.CPP
#include <iostream.h>
#include "..\14\tstash.h"

class shape {
  shape(shape&); // Prevent copy-construction
protected:
  shape() {} // Prevent stack objects
  // But allow access to derived constructors
public:
  enum type { Circle, Square, Triangle };
  virtual void draw() = 0;
  virtual ~shape() { cout << "~shape\n"; }
  static shape* make(type);
};

class circle : public shape {
  circle(circle&); // No copy-construction
  circle operator=(circle&); // No operator=
protected:
  circle() {};
public:
  void draw() { cout << "circle::draw\n"; }
  ~circle() { cout << "~circle\n"; }
  friend shape* shape::make(type t);
};

class square : public shape {
  square(square&); // No copy-construction
  square operator=(square&); // No operator=
protected:
  square() {};
public:
  void draw() { cout << "square::draw\n"; }
  ~square() { cout << "~square\n"; }
  friend shape* shape::make(type t);
};

class triangle : public shape {
  triangle(triangle&); // No copy-construction
  triangle operator=(triangle&); // Prevent
protected:
  triangle() {};
public:
  void draw() { cout << "triangle::draw\n"; }
  ~triangle() { cout << "~triangle\n"; }
  friend shape* shape::make(type t);
};

shape* shape::make(type t) {
  shape* S;
  switch(t) {
    case Circle: S = new circle; break;
    case Square: S = new square; break;
    case Triangle: S = new triangle; break;
  }
  S->draw(); // Virtual function call
  return S;
}

main() {
  tstash<shape> shapes; // Default to ownership
  shapes.add(shape::make(shape::Circle));
  shapes.add(shape::make(shape::Square));
  shapes.add(shape::make(shape::Triangle));
  cout << "virtual function calls:\n";
  for(int i = 0; i < shapes.count(); i++)
    shapes[i]->draw();
  //Circle c; // error: can't create on stack
}
