// Non-printed example in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: ITS.CPP -- Find "it's" & 2 enclosing words
#include <fstream.h>
#include <string.h>
#include <ctype.h>
#include "..\allege.h"

// Emit count words to cout:
void emitword(char* s, int count = 1) {
  for(int i = 0; i < count; i++) {
    while(!isspace(*s) && *s != 0) cout << *s++;
    while(isspace(*s) && *s != 0) cout << *s++;
  }
}

// Move the argument pointer forward by words:
void forwardword(char*& s, int count = 1) {
  for(int i = 0; i < count; i++) {
    while(!isspace(*s) && *s != 0) s++;
    while(isspace(*s) && *s != 0) s++;
  }
}

// Move the argument pointer back by words:
void backwardword(char*& s, int count = 1) {
  for(int i = 0; i < count; i++) {
    while(!isspace(*s) && *s != 0) s--;
    while(isspace(*s) && *s != 0) s--;
    while(!isspace(*s) && *s != 0) s--;
    s++; // Point to start of word
  }
}
// Char* c; // debug aid
main(int argc, char* argv[]) {
  allege(argc >= 2,
    "usage: its textfile word(=it's) pad(=1)\n"
    "finds the word and the pad words "
    "surrounding it for grammar syntax check");
  const char* word = (argc >= 3 ? argv[2] : "it's");
  const int pad = (argc == 4 ? atoi(argv[3]) : 1);
  ifstream in(argv[1]);
  allegefile(in);
  const sz = 4096;
  char _buf[sz + 10] = {0}; // Set to zero
  char* const buf = _buf + 10; // Pad beginning w/ zeroes
  while(in.getline(buf,sz)) {
    char* c = buf;
    while((c = strstr(c, word)) != 0) {
      backwardword(c, pad);
      emitword(c, 2*pad + 1);
      cout << endl;
      forwardword(c, 2*pad + 1);
    }
  }
}

