// File from page 607 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: VECTOR.H -- "Infinite" vector
#ifndef VECTOR_H_
#define VECTOR_H_
#include <stdlib.h>
#include "..\allege.h"

template<class T>
class vector {
  T** pos;
  int pos_sz;
  T** neg;
  int neg_sz;
  int owns;
  enum {
    chunk = 20, // Min allocation increase
    esz = sizeof(T*), // Element size
  };
  void expand(T**& array,int& size,int index);
public:
  vector(int Owns = 1);
  ~vector();
  T*& operator[](int index);
  int Owns() const { return owns; }
  void Owns(int newOwns) { owns = newOwns; }
};

template<class T>
vector<T>::vector(int Owns)
  : pos(0), pos_sz(0),
    neg(0), neg_sz(0),
    owns(Owns) {}

template<class T>
vector<T>::~vector() {
  if(owns)
    for(int i = 0; i < pos_sz; i++)
      delete pos[i];
  free(pos);
  if(owns)
    for(int j = 0; j < neg_sz; j++)
      delete neg[j];
  free(neg);
}

template<class T>
T*& vector<T>::operator[](int index) {
  if(index < 0) {
    index *= -1;
    if(index >= neg_sz)
      expand(neg, neg_sz, index);
    return neg[index];
  }
  else { // Index >= 0
    if(index >= pos_sz)
      expand(pos, pos_sz, index);
    return pos[index];
  }
}

template<class T> void
vector<T>::expand(T**& array, int& size,
                  int index) {
  const newsize = index + chunk;
  const increment = newsize - size;
  void* v = realloc(array, newsize * esz);
  allegemem(v);
  array = (T**)v;
  memset(&array[size], 0, increment * esz);
  size = index + chunk;
}
#endif // VECTOR_H_
