// File from page 625 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: RECYCLE.CPP -- Containers & polymorphism
#include <fstream.h>
#include <stdlib.h>
#include <time.h>
#include "..\14\tstack.h"
ofstream out("recycle.out");

enum type { Aluminum, Paper, Glass };

class trash {
  float Weight;
public:
  trash(float Wt) : Weight(Wt) {}
  virtual type trashType() const = 0;
  virtual const char* name() const = 0;
  virtual float value() const = 0;
  float weight() const { return Weight; }
  virtual ~trash() {}
};

class aluminum : public trash {
  static float val;
public:
  aluminum(float Wt) : trash(Wt) {}
  type trashType() const { return Aluminum; }
  virtual const char* name() const {
    return "aluminum";
  }
  float value() const { return val; }
  static void value(int newval) {
    val = newval;
  }
};

float aluminum::val = 1.67;

class paper : public trash {
  static float val;
public:
  paper(float Wt) : trash(Wt) {}
  type trashType() const { return Paper; }
  virtual const char* name() const {
    return "paper";
  }
  float value() const { return val; }
  static void value(int newval) {
    val = newval;
  }
};

float paper::val = 0.10;

class glass : public trash {
  static float val;
public:
  glass(float Wt) : trash(Wt) {}
  type trashType() const { return Glass; }
  virtual const char* name() const {
    return "glass";
  }
  float value() const { return val; }
  static void value(int newval) {
    val = newval;
  }
};

float glass::val = 0.23;

// Sums up the value of the trash in a bin:
void SumValue(const tstack<trash>& bin,ostream& os){
  tstackIterator<trash> tally(bin);
  float val = 0;
  while(tally) {
    val += tally->weight() * tally->value();
    os << "weight of " << tally->name()
        << " = " << tally->weight() << endl;
    tally++;
  }
  os << "Total value = " << val << endl;
}

main() {
  // Seed the random number generator
  time_t t;
  srand((unsigned)time(&t));

  tstack<trash> bin; // Default to ownership
  // Fill up the trash bin:
  for(int i = 0; i < 30; i++)
    switch(rand() % 3) {
      case 0 :
        bin.push(new aluminum(rand() % 100));
        break;
      case 1 :
        bin.push(new paper(rand() % 100));
        break;
      case 2 :
        bin.push(new glass(rand() % 100));
        break;
    }
  // Bins to sort into:
  tstack<trash> glassbin(0); // No ownership
  tstack<trash> paperbin(0);
  tstack<trash> ALbin(0);
  tstackIterator<trash> sorter(bin);
  // Sort the trash:
  // (RTTI offers a nicer solution)
  while(sorter) {
    // Smart pointer call:
    switch(sorter->trashType()) {
      case Aluminum:
        ALbin.push(sorter.current());
        break;
      case Paper:
        paperbin.push(sorter.current());
        break;
      case Glass:
        glassbin.push(sorter.current());
        break;
    }
    sorter++;
  }
  SumValue(ALbin, out);
  SumValue(paperbin, out);
  SumValue(glassbin, out);
  SumValue(bin, out);
}
