;*********************************
;***** SymBasic Code Library *****
;*********************************

.SymBasic_VarsinList:		db 	0
.SymBasic_WhereAddr:		dw	0
.SymBasic_Pass_1:			dw  0
.SymBasic_Pass_2:			dw	0

Global	Error%
.SymBasic_FunctionPasser
		pop		hl			;**** Gets the Return Location
;**** Read the first 2 bytes which are the Function Address
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		ld		a,(bc)
		ld		(SymBasic_VarsinList),a
		inc		bc		
		ld		(SymBasic_WhereAddr),bc

		ld		c,l
		ld		b,h

.SymBasic_FuncPass_1
		ld		a,(SymBasic_VarsinList)
		And		a
		jp		z,SymBasic_FunctionPasser_End
		dec		a
		ld		(SymBasic_VarsinList),a
;		BC = Address of List of Types to Convert from stack
		
;**** Gets the Variable from List 
		ld		hl,(SymBasic_WhereAddr)
		push	bc				;Stores
		ld		bc,7	
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		add		hl,bc
		pop		bc				;Retrieves DE
		ld		(SymBasic_WhereAddr),hl
;**** Gets the Type to Pull from Stack
		ld		a,(bc)
		inc		bc
		cp		1
		jp		z,SymBasic_FunctionPassShort
		cp		2
		jp		z,SymBasic_FunctionPassLong
		cp		5
		jp		z,SymBasic_FunctionPassString

		di
.killerbee2		jr	killerbee2		

.symBasic_FunctionPassShort
		pop		hl					;Gets From Stack
		pop		hl
		ex		de,hl				;Swaps so DE=Contents of Stack HL=Location of Variable
		ld		(hl),e
		inc		hl
		ld		(hl),d
		jp		SymBasic_FuncPass_1
		
.SymBasic_FunctionPassLong
		pop		hl
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		ex		de,hl
		pop		hl
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		jp		SymBasic_FuncPass_1

.SymBasic_FunctionPassString
		ld		(SymBasic_Pass_1),bc
		ld		(SymBasic_Pass_2),de
		ld		hl,SymBasic_FunctionPassString_2
		ld		(SymBasic_Temp_1),hl
		jp		SymBasic_StoreStringFromStack_2
.SymBasic_FunctionPassString_2
		ld		bc,(SymBasic_Pass_1)
		ld		de,(SymBasic_Pass_2)
		jp		SymBasic_FuncPass_1
		
.SymBasic_FunctionPasser_End
		push	bc
		ld		hl,(SymBasic_WhereAddr)
		jp		(hl)

.SymBasic_Temp_1
		dw		0
.SymBasic_Temp_2
		dw		0
.SymBasic_Temp_3
		dw		0
.SymBasic_Temp_4
		dw		0
.SymBasic_Temp_5
		dw		0		

.SymBasic_StackLong2Int
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		pop		bc
		pop		bc		
		ld		(hl),c
		inc		hl
		ld		(hl),b
		ex		de,hl
		jp		(hl)
	

;*****************************************		
;**** Get A Direct String from Memory ****
;*****************************************
.SymBasic_GetDirectString
		di
		pop		hl									;**** Return Address
		ld		de,(SymBasic_StringStackTop)		;**** Get Top of Text Stack
		ld		a,(hl)								;**** Gets the number of characters to display
		inc		hl									;**** Incs do HL points at next command
		And		a									;**** Perform check
		jr		z,SymBasic_GetDirectString_Empty	;**** Is it a zero length
		ld		c,a
		ld		b,0									;**** Null B
		push	bc									;**** Push Length to stack
		ld		de,(SymBasic_StringStackTop)		;**** Get start of String Addr
		push	de									;**** Store Start on String on Stack
		ldir										;**** Copy
		ld		(SymBasic_StringStackTop),de		;**** Store the String Text start location
		ei
		jp		(hl)								;**** Back To code
.SymBasic_GetDirectString_Empty
		ld		bc,0								;**** No length	in BC
		push	bc									;**** Store No Lenght
		push	de									;**** Store Text location though Empty
		ei
		jp		(hl)								;**** Back to Code


;*******************************************
;**** Get string From variable Location ****
;*******************************************
.SymBasic_GetVarString
		di
		pop		hl									;**** Return Address
		ld		e,(hl)								;**** Get Low of Variable Address
		inc		hl									;**** Step on one
		ld		d,(hl)								;**** Get High of Variable Address
		inc		hl									;**** Step on so now Pointing at real return address
		ld		(Symbasic_Temp_1),hl				;**** Store return Address
		ex		de,hl								;**** Swap
		ld		e,(hl)								;**** Gets Low Start Address of string
		inc		hl									;**** Move on
		ld		d,(hl)								;**** Gets High Start Address of string
		inc		hl									;**** Move On
		ld		a,(hl)								;**** Get Length
		And		a									;**** Check if Zero			
		jp		z,SymBasic_GetVarString_Empty		;**** If Zero then End
		ld		c,a									;**** c=Length
		ld		b,0									;**** Null B
		push	bc									;**** Push Length onto stack
		inc		de									;**** Step over 2 byte Link List
		inc		de									;****		
		ex		de,hl								;**** Swap so HL = Address to copy from
		ld		de,(SymBasic_StringStackTop)		;**** Get Place to Copy too
		push	de									;**** Store Start of copied text
		ldir										;**** Copy
		ld		(SymBasic_StringStackTop),de		;**** Store New Stack position to copy text
		ld		hl,(SymBasic_Temp_1),hl				;**** Get Return Location
		ei
		jp		(hl)								;**** Return
.SymBasic_GetVarString_Empty
		ld		bc,0								;**** Null Length
		push	bc									;**** Store on Stack
		ld		de,(SymBasic_StringStackTop)		;**** Get Place to Copy too		
		push	de									;**** Store on Stack
		ld		hl,(Symbasic_Temp_1)				;**** Get Return Address
		ei
		jp		(hl)								;**** Return
		






.SymBasic_GetIntVar
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc
		ld		bc,0
		push	bc
		push	de		
		ret

.SymBasic_GetLongVar
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		push	bc
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc
		push	de
		ret

.SymBasic_GetByteVar
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		ld		c,(hl)
		ld		b,0
		push	bc
		ld		c,0
		push	bc
		push	de
		ret

.SymBasic_GetIntArray1
		pop		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		ld		(SymBasic_Temp_1),hl

		pop		hl				;**** Get 32 Bit off stack
		pop		hl
		add		hl,hl			;**** Double it
		add		hl,bc
		ld		bc,8
		add		hl,bc

		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		push	de
		ld		de,0
		push	de

		ld		hl,(SymBasic_Temp_1),hl
		jp		(hl)


.SymBasic_GetLongNum
		pop		hl				;**** Get the Return location from Stack
		ld		e,(hl)			;**** Get First Byte of Integer
		inc		hl				;**** Increase It
		ld		d,(hl)			;**** Get Second Byte of Integer
		inc		hl				;**** Increase It - Now Points to return Location
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc				;**** Push Integer to Stack
		push	de				;****
		push	hl				;**** Push New Return Location to Stack
		ret						;**** Return to code

.SymBasic_CallFunction
		pop		hl
		ld		e,(hl)			;**** Get Address
		inc		hl
		ld		d,(hl)			;**** Get Address
		inc		hl
		ld		c,(hl)
		inc		hl			
		push	hl				;**** HL = Return Address
		ex		de,hl
		jp		(hl)

;**** STRINGCOMPARE = Takes two strings off Stack and compares. Removes strings from Stack
;**** OUT A=0 Equal
;****     A=
.SymBasic_StringCompare
		pop		ix				
		pop		hl				;Get Top Stack String Address
		pop		de				;Get Len
		ld		a,e
		pop		de				;Get Second Stack String Address
		ld		(SymBasic_StringStackTop),de
		pop		bc				;C=Second Len
		ld		b,a				;B=First Len
		cp		c
		jr		z,SymBasic_StringCompare_2
		jr		nc,SymBasic_StringCompare_3
		ld		c,a
;**** Differing Lengths		
.SymBasic_StringCompare_1
		Xor		a
		cp		c
		jr		z,SymBasic_StringCompare_SecondGreater
		dec		c
		ld		a,(de)
		cp		(hl)		
		jr		c,SymBasic_StringCompare_FirstGreater
		jr		nz,SymBasic_StringCompare_SecondGreater
		inc		hl
		inc		de
		jr		SymBasic_StringCompare_1
;**** Differing Lengths		
.SymBasic_StringCompare_3
		Xor		a
		cp		c
		jr		z,SymBasic_StringCompare_FirstGreater
		dec		c
		ld		a,(de)
		cp		(hl)		
		jr		c,SymBasic_StringCompare_FirstGreater
		jr		nz,SymBasic_StringCompare_SecondGreater
		inc		hl
		inc		de
		jr		SymBasic_StringCompare_3
;**** Of same Length
.SymBasic_StringCompare_2
		Xor		a
		cp		c
		jr		z,SymBasic_StringCompare_Equal
		dec		c
		ld		a,(de)
		cp		(hl)		
		jr		c,SymBasic_StringCompare_FirstGreater
		jr		nz,SymBasic_StringCompare_SecondGreater
		inc		hl
		inc		de
		jr		SymBasic_StringCompare_2
SymBasic_StringCompare_FirstGreater
		ld		a,-1
		scf		
		jp		(ix)
SymBasic_StringCompare_SecondGreater
		ld		a,1
		jp		(ix)
SymBasic_StringCompare_Equal
		Xor		a
		jp		(ix)
		
;*********************************************************
;**** EqualStrings = 2 Stack String Compared if Equal ****
;*********************************************************
.SymBasic_EqualsStrings
		pop		iy
		call	SymBasic_StringCompare
		And		a
		jp		z,SymBasic_PositiveResult
		jp		SymBasic_NegativeResult

;*************************************************************
;**** GreaterStrings = 2 Stack String Compared if Greater ****
;*************************************************************
.SymBasic_GreaterStrings
		pop		iy
		call	SymBasic_StringCompare
		cp		1
		jp		z,SymBasic_PositiveResult
		jp		SymBasic_NegativeResult

.SymBasic_NegativeResult
		ld		de,0
		push	de
		push	de
		jp		(iy)		
.SymBasic_PositiveResult
		ld		de,1
		push	de
		ld		e,0
		push	de
		jp		(iy)



;**** Compares 2 32 bit values from stack ****
;**** Input  -> (SP+0)=Value1, (SP+4)=Value2, IY=return address
;**** Output -> A=Result (0 -> Value1=Value2, 1 -> Value1>Value2, -1 -> Value1<Value2), PC=IY
.SymBasic_Compare32
		pop 	de
		pop 	bc      ;BC[h],DE[l] = value1
		pop 	hl      ;HL = value2[l]
		Or 		a
		sbc		hl,de
		ex		de,hl
		pop		hl      ;HL = value2[h]
		sbc		hl,bc   ;HL[h],DE[l] = value2-value1
		ld 		a,l
		Or 		h
		Or 		e
		Or 		d
		jr 		z,SymBasic_Compare32_1
		ld 		a,1
		bit 	7,h
		jr 		nz,SymBasic_Compare32_1
		ld 		a,-1
.SymBasic_Compare32_1
		jp 		(iy)

;****
;**** EQUALS32 = Checks for 2 32 Bit numbers equal each other ****
;****
.SymBasic_Equals32
		pop 	ix
		ld 		iy,SymBasic_Equals32_1
		jp 		SymBasic_Compare32
.SymBasic_Equals32_1
		Or 		a
.SymBasic_Equals32_0
		ld 		hl,0
		ld 		de,0
		jr 		nz,SymBasic_Equals32_2
		inc 	l
.SymBasic_Equals32_2
		push 	de
		push 	hl
		jp 		(ix)

;****
;**** OTHERTHAN32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_OtherThan32
		pop		ix
		ld		iy,Symbasic_OtherThan32_1
		jp		Symbasic_Compare32
.SymBasic_OtherThan32_1
		Or		a
.SymBasic_OtherThan32_0
		ld		hl,0
		ld		de,0
		jr		z,Symbasic_OtherThan32_2
		inc		l
.SymBasic_OtherThan32_2
		push	de
		push	hl
		jp		(ix)

;****
;**** GREATERTHAN32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_GreaterThan32
		pop		ix
		ld		iy,Symbasic_GreaterThan32_1
		jp		Symbasic_Compare32
.SymBasic_GreaterThan32_1
		inc		a
.SymBasic_GreaterThan32_0
		ld		hl,0
		ld		de,0
		jr		nz,Symbasic_GreaterThan32_2
		inc		l
.SymBasic_GreaterThan32_2
		push	de
		push	hl
		jp		(ix)

;****
;**** LESSERTHAN32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_LesserThan32
		pop		ix
		ld		iy,Symbasic_LesserThan32_1
		jp		Symbasic_Compare32
.SymBasic_LesserThan32_1
		dec		a
.SymBasic_LesserThan32_0
		ld		hl,0
		ld		de,0
		jr		nz,Symbasic_LesserThan32_2
		inc		l
.SymBasic_LesserThan32_2
		push	de
		push	hl
		jp		(ix)
	
;****
;**** LESSERTHANEQ32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_LesserThanEQ32
		pop		ix
		ld		iy,Symbasic_LesserThanEQ32_1
		jp		Symbasic_Compare32
.SymBasic_LesserThanEQ32_1
		Or		a
.SymBasic_LesserThanEQ32_0
		ld		hl,0
		ld		de,0
		cp		0
		jr		z,Symbasic_LesserThanEQ32_3
		cp		-1
		jr		z,Symbasic_LesserThanEQ32_2
.SymBasic_LesserThanEQ32_3		
		inc		l
.SymBasic_LesserThanEQ32_2
		push	de
		push	hl
		jp		(ix)

;****
;**** GREATERTHANEQ32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_GreaterThanEQ32
		pop		ix
		ld		iy,Symbasic_GreaterThanEQ32_1
		jp		Symbasic_Compare32
.SymBasic_GreaterThanEQ32_1
		Or		a
.SymBasic_GreaterThanEQ32_0
		ld		hl,0
		ld		de,0
		cp		0
		jr		z,Symbasic_GreaterThanEQ32_3
		cp		1
		jr		z,Symbasic_GreaterThanEQ32_2
.SymBasic_GreaterThanEQ32_3		
		inc		l
.SymBasic_GreaterThanEQ32_2
		push	de
		push	hl
		jp		(ix)

;****
;**** IFCMP32 = Checks Result and If True continues else Jumps to end of If (or else)
;****
.SymBasic_IfCmp32
		pop		hl	
		pop		de
		pop		bc		
		;**** Math Stuff
		Xor 	a
		Or		b
		Or		c
		Or		d
		Or		e
		jr		nz,SymBasic_IfCmp32_1
		;**** Okay so Failed
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		push	de
		ret
.SymBasic_IfCmp32_1
		inc		hl
		inc		hl
		push 	hl
		ret

;****
;**** AND32 = Ands 2 32 Bits number together
;****
.SymBasic_And32
		pop		ix					;14
		pop		bc					;10
		pop		de					;10
		pop		hl					;10
		ld		a,b					;4
		And		h					;4
		ld		b,a					;4
		ld		a,c					;4
		And		l					;4
		ld		c,a					;4
		pop		hl					;10
		ld		a,d					;4
		And		h					;4
		ld		d,a					;4
		ld		a,e					;4
		And		l					;4
		ld		e,a					;4
		push	de					;11
		push	bc					;11
		jp		(ix)				;8

;****
;**** OR32 = ORs 2 32 Bits number together
;****
.SymBasic_Or32
		pop		ix					;
		pop		bc					;
		pop		de					;
		pop		hl					;
		ld		a,b					;
		Or		h					;
		ld		b,a					;
		ld		a,c					;
		Or		l					;
		ld		c,a					;
		pop		hl					;
		ld		a,d					;
		Or		h					;
		ld		d,a					;
		ld		a,e					;
		Or		l					;
		ld		e,a					;
		push	de					;
		push	bc					;
		jp		(ix)				;

;****
;**** XOR32 = XORs 2 32 Bits number together
;****
.SymBasic_Xor32
		pop		ix					;
		pop		bc					;
		pop		de					;
		pop		hl					;
		ld		a,b					;
		Xor		h					;
		ld		b,a					;
		ld		a,c					;
		Xor		l					;
		ld		c,a					;
		pop		hl					;
		ld		a,d					;
		Xor		h					;
		ld		d,a					;
		ld		a,e					;
		Xor		l					;
		ld		e,a					;
		push	de					;
		push	bc					;
		jp		(ix)				;		
		

.SymBasic_StringStackTop:	dw	SymBasic_StringArea
.SymBasic_StringArea:		ds	800
.SymBasic_StringWorkSpace:	ds	256

.SymBasic_StringLoc1:	dw	0
.SymBasic_StringLen1:	db 	0
.SymBasic_StringSlt1:	db 	0
.SymBasic_StringLoc2:	dw	0
.SymBasic_StringLen2:	db 	0
.SymBasic_StringSlt2:	db 	0
.SymBasic_AddStrings
		pop		de										;**** Get Return Address and Store
		ld		(SymBasic_Temp_1),de					;**** Store
		pop		hl
		ld		(SymBasic_StringLoc1),hl
		pop		hl
		ld		(SymBasic_StringLen1),hl
		pop		hl
		ld		(SymBasic_StringLoc2),hl				;This is the where to put new line
		pop		hl
		ld		(SymBasic_StringLen2),hl

		ld		a,(SymBasic_StringLen2)					;**** gets the Length of first copied string
		ld		c,a
		ld		a,(SymBasic_StringLen1)
		add		c
		ld		(SymBasic_StringLen2),a					;**** Now becomes total length

		ld		b,0
		ld		de,SymBasic_StringWorkSpace
		ld		hl,(SymBasic_StringLoc2)
		ldir

		ld		a,(SymBasic_StringLen1)
		ld		c,a
		ld		b,0
		ld		hl,(SymBasic_StringLoc1)
		ldir
		
		ld		a,(SymBasic_StringLen2)
		ld		c,a
		ld		b,0
		ld		hl,SymBasic_StringWorkSpace
		ld		de,(SymBasic_StringLoc2)
		push	bc
		push	de
		ldir
		ld		(SymBasic_StringStackTop),de
		ld		hl,(SymBasic_Temp_1)
		jp		(hl)
.SymBasic_Err_100
		di
		jr		SymBasic_Err_100	


;*********************************
;**** Store String from Stack ****
;*********************************
;**** Puts the Text at the Top of the Stack into a Variable
.SymBasic_StoreStringFromStack
		pop		hl							;**** Get From Stack Return Location
		ld		e,(hl)						;**** Get Lower Address of Var to Store
		inc		hl							;**** Increase Pointer
		ld		d,(hl)						;**** Get Higher Place of String to Store
		inc		hl							;**** Increase Pointer
		ld		(SymBasic_Temp_1),hl		;**** Store Return Address
.SymBasic_StoreStringFromStack_2
		di
		ld		(SymBasic_Temp_2),de		;**** This is the Handler Address
		ex		de,hl						;**** Swap
		ld		e,(hl)						;**** Get Low address of string Start
		inc		hl							;**** Increase
		ld		d,(hl)						;**** DE = Address of start of Text
		ld		(SymBasic_Temp_3),de		;**** This is the Start of the Old Text			
		inc		hl							;**** Increase
		ld		c,(hl)
		ld		(SymBasic_Temp_4),bc		;**** This is the Start of the Old Text Len
		pop		de
		ld		(SymBasic_StringStackTop),de
		pop		bc
		ld		a,c
		ld		(SymBasic_StringLen1),a
		ld		c,(hl)
		ld		b,0
		ld		(hl),a
		cp		c		
		jp		z,SymBasic_StoreStrFromStack_10
		jp		c,SymBasic_StoreStrFromStack_11

;**** Store at Top of string Table
.SymBasic_StoreStrFromStack_9
;**** Do copy from Stack area to string area
		ld		hl,SymBasic_TopString		;**** Where we are copying too
		ld		de,(SymBasic_Temp_2)		;**** Get The Table Handler Address
		ldi
		ldi
		ld		a,(SymBasic_StringLen1)
		ld		(de),a
		ld		de,(SymBasic_TopString)		;**** Where we are copying too
		ld		hl,SymBasic_Temp_2			;**** Get The Table Handler Address
		ldi
		ldi
		ld		hl,(SymBasic_StringStackTop)		;**** Where Data Is
		ld		bc,(SymBasic_StringLen1)			;**** Length to copy
		ldir
		ld		a,0
		ld		(de),a
		inc		de
		ld		(SymBasic_TopString),de
;**** Clear Old Space
		ld		hl,(SymBasic_Temp_3)
		ld		a,(SymBasic_Temp_4)
		ld		b,a
		inc		b
		Xor		a
		ld		(hl),a
		inc		hl
.SymBasic_Gringo_20
		ld		(hl),a
		inc		hl
		djnz	SymBasic_Gringo_20
;**** If A Form Text then replace 
		ld		hl,(SymBasic_Temp_2)
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		inc		hl
		cp		(hl)
		jp		nz,SymBasic_Gringo_21
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		inc		bc
		inc		bc		
		ld		(hl),c
		inc		hl
		ld		(hl),b
;**** Ends the Copying process
.SymBasic_Gringo_21
		scf											;**** Clears the Flag
		ccf
		ld		hl,(SymBasic_StringStackTop)		;**** Where Data Is
		ld		de,(SymBasic_StringLen1)			;**** Get the Length
		sbc		hl,de								;**** Subtract to remove Stack top
		ld		(SymBasic_StringStackTop),hl		;**** Store old Stack Top
		ld		hl,(SymBasic_Temp_1)				;**** Get Return Address
		ei
		jp		(hl)								;**** Exit
;**** This Just Basically copies new onto old as they are same length
.SymBasic_StoreStrFromStack_10
		And		a									;**** If A = 0
		jr		z,SymBasic_Gringo_21				;**** If it is no change so End
		ld		de,(SymBasic_Temp_3)				;**** Start of Old Text
		inc		de
		inc		de
		ld		hl,(SymBasic_StringStackTop)		;**** Where Data Is
		ld		bc,(SymBasic_StringLen1)			;**** Length to copy
		ldir
		jp		SymBasic_Gringo_21
		
;**** Copy into same area and pad out
.SymBasic_StoreStrFromStack_11
		ld		de,(SymBasic_Temp_3)				;**** Start of Old Text
		inc		de
		inc		de
		And		a									;**** A = 0
		jr		z,SymBasic_Gringo_23
		ld		c,a
		ld		hl,(SymBasic_StringStackTop)		;**** Where Data Is
		ldir
		ld		a,(SymBasic_StringLen1)
		ld		c,a
		ld		a,(SymBasic_Temp_4)
		sub		c
		ld		b,a
		Xor		a
.SymBasic_Gringo_22
		ld		(de),A
		inc		de
		djnz	SymBasic_Gringo_22
		jp		SymBasic_Gringo_21
.SymBasic_Gringo_23
		ld		b,c
		jr		SymBasic_Gringo_22



.SymBasic_Sub32
;************************************
; In: HL/DE: eerste getal (low/high)
;     IX/IY: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
		di
		pop		bc				;**** This is the Return Address
		pop		iy				;**** First Number Get Low
		pop		ix				;**** First Number Get High
		pop		de				;**** Second Number Get Low
		pop		hl				;**** Second Number Get High
		push	bc				;**** Push The Return address
		;**** Math Stuff
		push	ix
		pop		bc
		Xor		a
		sbc		hl,bc
		ex		de,hl
		push	iy
		pop		bc
		sbc		hl,bc
		ex		de,hl
		;**** Finish Math stuff
		pop		bc				;**** Get the Return Address
		push	hl				;**** Push Result High 
		push	de				;**** Push Result Low
		push	bc				;**** Push Return Address onto Stack
		ei
		ret


.SymBasic_Mul32
;*******************************************
; In: IY/IX: eerste getal (low/high)
;     HL/BC: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)

		di
		pop		de				;**** This is the Return Address
		pop		bc				;**** First Number Get Low
		pop		hl				;**** First Number Get High
		pop		ix				;**** Second Number Get Low
		pop		iy				;**** Second Number Get High
		push	de				;**** Push The Return address

		exx
		push	bc
		push	de
		push	hl
		exx

		;**** Math Stuff
				exx
                ld      hl,0
                ld      de,0
                exx
SymBasic_Multi32_lp:
				srl     b
                rr      c
                rr      h
                rr      l
                jp      nc,SymBasic_multi32_2
                exx
                push    iy
                pop     bc
                add     hl,bc
                ex      de,hl
                push    ix
                pop     bc
                adc     hl,bc
                ex      de,hl
                exx
SymBasic_multi32_2:
				ld      a,h
                Or      l
                jp      nz,SymBasic_Multi32_3
                ld      a,b
                Or      c
                jp      z,SymBasic_multi32_5
SymBasic_multi32_3:
				add     iy,iy
                jp      nc,SymBasic_multi32_4
                add     ix,ix
                inc     ix
                jp      SymBasic_multi32_lp
SymBasic_multi32_4:
				add     ix,ix
                jp      SymBasic_multi32_lp
SymBasic_multi32_5:
				exx
		;**** Finish Math stuff
		exx
		pop		hl
		pop		de
		pop		bc
		exx

		pop		bc				;**** Get the Return Address
		push	hl				;**** Push Result High 
		push	de				;**** Push Result Low
		push	bc				;**** Push Return Address onto Stack
		ei
		ret

.SymBasic_Div32
;**************************************
; In: HL/DE: teller (low/high)
;     IX/IY: noemer (low/high)
; Uit: HL/DE: resultaat (low/high)
		di
		pop		bc				;**** This is the Return Address
		pop		iy				;**** First Number Get Low
		pop		ix				;**** First Number Get High
		pop		de				;**** Second Number Get Low
		pop		hl				;**** Second Number Get High
		push	bc				;**** Push The Return address

		exx
		push	bc
		push	de
		push	hl
		exx
		
		;**** Math Stuff
		        push    hl
                push    de
                push    ix
                push    iy
                pop     de
                exx
                pop     de
                pop     bc
                pop     iy
                ld      hl,0
                exx
                ld      hl,0
                ld      b,32
.SymBasic_divide32_1
				exx
                add     iy,iy
                rl      c
                rl      b
                adc     hl,hl
                exx
                adc     hl,hl
                exx
                sbc     hl,de
                exx
                sbc     hl,de
                inc     iy
                jp      nc,SymBasic_divide32_2
                dec     iy
                exx
                add     hl,de
                exx
                adc     hl,de
.SymBasic_divide32_2
				djnz    SymBasic_divide32_1
                exx
                push    bc
                exx
                pop     de
                push    iy
                pop     hl
 		;**** Finish Math stuff
		exx
		pop		hl
		pop		de
		pop		bc
		exx

		pop		bc				;**** Get the Return Address
		push	hl				;**** Push Result High 
		push	de				;**** Push Result Low
		push	bc				;**** Push Return Address onto Stack
		ei
		ret


.SymBasic_SetPalette
		pop		bc				;**** Return Address

		pop		hl
		pop		hl
		ld		a,l
		And		%1111
		ld		d,a				;**** Sets the Blue Element
		
		pop		hl
		pop		hl
		ld		a,l
		add		a
		add		a
		add		a
		add		a
		And		%11110000
		Or		d
		ld		d,a

		pop		hl
		pop		hl
		ld		a,l
		And		%1111
		ld		e,a

		pop		hl
		pop		hl
		ld		a,l
		And		%1111
		ld		l,e
		ld		e,a

		push	bc
        ld 		a,DSK_SRV_COLSET
        jp 		SyDesktop_Service
		ret

;*****************************************
;**** Command RefreshObj [Form],[Obj] ****
;*****************************************
.SymBasic_RefreshObj
		pop		ix
		pop		de
		pop		de
		pop		bc
		pop		bc
		ld		hl,SymStudio_FormIDs
		add		hl,bc
		ld		a,(hl)
		push	ix
		push	iy
		call	SyDesktop_WINDIN
		pop		iy
		pop		ix
		jp		(ix)

;***************************
;**** MouseX Function() ****
;***************************
AFunction MouseX()
		rst 	#20
		dw 		#813c
		pop		ix		;**** Get Return point
		ld		hl,0
		push	de
		push	hl
		jp		(ix)
EndF

;***************************
;**** MouseY Function() ****
;***************************
AFunction MouseY()
		rst 	#20
		dw 		#813c
		pop		bc		;**** Get Return point
		ld		de,0
		push	hl
		push	de
		push	bc		;**** Push back on Stack
EndF

Global SymBasicMouse%

AFunction MouseDown(SymBasicMouse)
	rst		#20
	dw		#813f
	pop		bc
	
	ld		de,0
	ld		l,a
	ld		a,(SymBasicMouse+0)
	And		l
	jr		nz,SymBasic_MouseDown1
	ld		hl,0
	push	hl
	push	de
	push	bc
	ret
.SymBasic_MouseDown1
	ld		hl,1
	push	hl
	push	de
	push	bc
EndF	

AFunction KeyDown(SymBasicMouse)
	pop		hl
	ld		(SymBasic_Temp_1),hl
	ld		de,(SymBasicMouse+0)	
	ld		hl,#8145
	rst		#28
	Xor		a
	cp		e
	jr		nz,SymBasic_KeyDown_1
	ld		hl,0
	push	hl
	push	hl
	ld		hl,(SymBasic_Temp_1)
	jp		(hl)
SymBasic_KeyDown_1	
	push	de
	push	de
	ld		hl,(SymBasic_Temp_1)
	jp		(hl)
EndF

AFunction GetMode()
	call	SyDesktop_MODGET
	pop		hl					;Return Address
	ld		d,0
	push	de
	ld		e,0
	push	de
	push	hl
EndF
Global SymBasicPeek1%
AFunction PeekByte(SymBasicPeek1)
	pop		de					;**** Get Rturn Address
	ld		hl,(SymBasicPeek1)	;**** HL contains Peek Target
	ld		c,(hl)				;**** Get Low byte from Target
	ld		b,0					;**** Null second byte
	push	bc					;**** Store on Stack
	ld		c,0					;**** Clear completly
	push	bc					;**** Store on Stack
	push	de					;**** Push Return Address
EndF							;**** Return
AFunction PeekShort(SymBasicPeek1)
	pop		de					;Return
	ld		hl,(SymBasicPeek1)
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	push	bc
	ld		bc,0
	push	bc
	push	de
EndF
AFunction PeekInt(SymBasicPeek1)
	pop		de
	ld		hl,(SymBasicPeek1)
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	inc		hl
	push	bc
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	push	bc
	push	de
EndF
Global SymBasic_TempString$
AFunction Len(SymBasic_TempString)
	pop		hl
	ld		(Symbasic_Temp_1),hl	
	ld		hl,SymBasic_TempString
	inc		hl
	inc		hl
	ld		c,(hl)
	ld		b,0
	push	bc
	ld		c,0
	push	bc
	ld		hl,(Symbasic_Temp_1)
	jp		(hl)


AFunction Upper$(SymBasic_TempString)
	ld		hl,SymBasic_TempString
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	inc		hl
	ld		b,(hl)
	ld		c,0
	inc		de
	inc		de
Symbasic_Upper_1
	ld		a,(de)
	cp		"a"
	jr		c,SymBasic_Upper_2
	cp		"["
	jr		nc,SymBasic_Upper_2
	sub		a,32
	ld		(de),a
Symbasic_Upper_2
	inc		de
	djnz	SymBasic_Upper_1

;*************
;**** ASC ****
;*************
AFunction Asc(SymBasic_TempString$)
	pop		ix
	ld		hl,SymBasic_TempString
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	inc		hl
	ld		b,(hl)
	inc		de
	inc		de
	ld		a,(de)
	ld		l,a
	ld		h,0
	push	hl
	ld		l,0
	push	hl
	jp		(ix)

;*******************************************
;**** Get the Start of My Common String ****
;*******************************************
.Get_SymBasicTempString
	ld		hl,SymBasic_TempString
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	inc		hl
	ld		b,(hl)
	inc		de
	inc		de
	ret

;*****************
;**** AppBank ****
;*****************
AFunction AppBank()
	pop		hl
	ld		e,(AppBnkNum)
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)
	
Global SymBasic_FileTemp%
.SymBasic_File_Temp_Storage:	ds 250
.SymBasic_EofData:ds	8

;******************
;**** OpenFile ****
;******************
AFunction OpenFile(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ex		de,hl
	ld		a,(appBnkNum)
	db		#DD,#67
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_FILOPN
	call	c,SymBasic_Drive_Error	
	pop		hl
	ld		e,a
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)

;*******************
;**** CloseFile ****
;*******************
AFunction CloseFile(SymBasic_FileTemp)
	ld		a,(SymBasic_FileTemp)			;**** Get Passed File number
	call	SySystem_CallFunction			;**** Symbos Close File Function
	db		MSC_SYS_SYSFIL					;
	db		FNC_FIL_FILCLO					;
	call	c,SymBasic_Drive_Error			;**** If error reported jump to Error Set
	pop		hl								;**** Pop Return address
	ld		de,0							;**** Put a Null 32bit Result on Stack
	push	de								;****
	push	de								;****
	jp		(hl)							;**** Return to 


;*********************
;**** EOF Setting ****
;*********************
;IN A = What to set EOF TOO    
.SymBasic_Eof_Setting_Code
	jr		z,SymBasic_Eof_Setting_Code1
	ld		a,1
	jr		SymBasic_Eof_Setting_Code2
.SymBasic_Eof_Setting_Code1
	ld		a,0
.SymBasic_Eof_Setting_Code2
	ld		hl,SymBasic_EofData
	ld		e,(SymBasic_FileTemp)
	ld		d,0
	add		hl,de
	ld		(hl),a
	ret

;*************
;**** EOF ****
;*************
AFunction Eof(SymBasic_FileTemp)
	ld		hl,SymBasic_EofData
	ld		e,(SymBasic_FileTemp)
	ld		d,0
	add		hl,de
	ld		e,(hl)
	ld		d,0
	pop		hl
	push	de
	ld		e,0
	push 	de
	jp		(hl)

;*******************
;**** Read Byte ****
;*******************
AFunction ReadByte(SymBasic_FileTemp)
	ld		a,(AppBnkNum)
	ld		e,a
	ld		hl,SymBasic_File_Temp_Storage
	ld		bc,1
	ld		a,(SymBasic_FileTemp)
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_FILINP


	
	call	SymBasic_Eof_Setting_Code
	pop		hl
	ld		a,(SymBasic_File_Temp_Storage)
	ld		e,a
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)
	
;********************
;**** Read Short ****
;********************
AFunction ReadShort(SymBasic_FileTemp)
	ld		a,(AppBnkNum)
	ld		e,a
	ld		hl,SymBasic_File_Temp_Storage
	ld		bc,2
	ld		a,(SymBasic_FileTemp)
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_FILINP
	call	SymBasic_Eof_Setting_Code	
	pop		hl
	ld		de,(SymBasic_File_Temp_Storage)
	push	de
	ld		de,0
	push	de
	jp		(hl)

;******************
;**** Read Int ****
;******************
AFunction ReadInt(SymBasic_FileTemp)
	ld		a,(AppBnkNum)
	ld		e,a
	ld		hl,SymBasic_File_Temp_Storage
	ld		bc,4
	ld		a,(SymBasic_FileTemp)
	call	SySystem_CallFunction
	call	SymBasic_Eof_Setting_Code	
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_FILINP
	pop		hl
	ld		de,(SymBasic_File_Temp_Storage)
	push	de
	ld		de,(Symbasic_File_Temp_Storage+2)
	push	de
	jp		(hl)

;**********************
;**** Drive Status ****
;**********************
AFunction DriveStatus(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ld		a,(de)
	ld		c,0
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_DIRINF
	call	c,SymBasic_Drive_Error
	pop		hl
	ld		e,a
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)

;********************
;**** Drive Type ****
;********************
AFunction DriveType(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ld		a,(de)
	ld		c,0
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_DIRINF
	call	c,SymBasic_Drive_Error
	pop		hl
	ld		e,b
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)

;*********************
;**** DriveSystem ****
;*********************
AFunction DriveSys(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ld		a,(de)
	ld		c,0
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_DIRINF
	call	c,SymBasic_Drive_Error
	pop		hl
	ld		e,c
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)

;*******************
;**** DriveFree ****
;*******************
AFunction DriveFree(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ld		a,(de)
	ld		c,1
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_DIRINF
	call	c,SymBasic_Drive_Error
	pop		bc
	push	de
	push	hl
	ld		de,512
	ld		hl,0
	push	de
	push	hl
	push	bc
	jp		SymBasic_Mul32
EndF	
	

;********************************
;**** Set The Error Variable ****
;********************************
SymBasic_Drive_Error
	ld		(Error+0),a
	Xor		a
	ld		(Error+1),a
	ret
	
Global SymBasic_Forms%,SymBasic_Forms2%
;*******************
;**** Open Form ****
;*******************
AFunction OpenForm(SymBasic_Forms)
		ld		a,(SymBasic_Forms)
		And		%111
		ld		hl,SymStudio_FormIDs
		ld		e,a
		ld		d,0
		add		hl,de
		Xor		a
		cp		(hl)
		jr		nz,SymBasic_OpenForm_1
		ld		a,e
		call	SymStudio_WindowOpen
.SymBasic_OpenForm_1	
		pop		hl
		ld		bc,0
		push	bc
		push	bc
		jp		(hl)
EndF

;********************
;**** Close Form ****
;********************
AFunction CloseForm(SymBasic_Forms)
		di
		pop		hl
		push	ix
		push	iy
		push	hl
		ld		a,(SymBasic_Forms)
		ld		hl,SymStudio_FormIDs
		ld		e,a
		ld		d,0
		add		hl,de
		ld		a,(hl)
		ld		(hl),d
		call	SyDesktop_WINCLS
		pop		hl
		pop		iy
		pop		ix
		ld		de,0
		push	de
		push	de
		ei
		jp		(hl)
EndF

;***************
;**** Form *****
;***************
.SymBasic_Form:
		pop		ix
		pop		de
		pop		de
		pop		bc
		pop		bc
		ld		hl,SymBasic_Form_7
		ld		a,e
		And		%111
		ld		e,a
		ld		d,0
		add		hl,de
		ld		e,(hl)
		ld		hl,SymStudio_FormIDs
		ld		b,0
		add		hl,bc
		ld		a,(hl)
		cp		0
		jr		z,SymBasic_Form_2
		ld		c,e
		push	ix
        jp 		SyDesktop_SendMessage
.SymBasic_Form_2
		jp		(ix)

;Redraw Menu
;Redraw Title
;Redraw Status
;Set Focus
;Minimise
;Restore
;Maximise
;Slider
SymBasic_Form_7
		db	MSC_DSK_WINMEN,MSC_DSK_WINTIT,MSC_DSK_WINSTA,MSC_DSK_WINTOP
		db  MSC_DSK_WINMIN,MSC_DSK_WINMID,MSC_DSK_WINMAX,MSC_DSK_WINSLD


Global SymBasic_Strs_Number
AFunction Str$(SymBasic_Strs_Number)
		di
		pop		hl
		ld		(Symbasic_Temp_1),hl
		ld		iy,(SymBasic_StringStackTop)
		push	iy
		ld		de,(SymBasic_Strs_Number)
		ld		ix,(SymBasic_Strs_Number+2)		
		
;### CLCN32 -> Converts 32Bit-Integer (unsigned) to ASCII-String (terminated by 0)
;### Eingabe    DE,IX=Value, IY=StringAddress
;### Ausgabe    IY=Addresse of the last char
;### Veraendert AF,BC,DE,HL,IX,IY

 
clcn32  ld (clcn32z),ix
        ld (clcn32z+2),de
        ld ix,clcn32t+36
        ld b,9
        ld c,0
clcn321 ld a,"0"
        Or a
clcn322 ld e,(ix+0):ld d,(ix+1):ld hl,(clcn32z):  sbc hl,de:ld (clcn32z),hl
        ld e,(ix+2):ld d,(ix+3):ld hl,(clcn32z+2):sbc hl,de:ld (clcn32z+2),hl
        jr c,clcn325
        inc c
        inc a
        jr clcn322
clcn325 ld e,(ix+0):ld d,(ix+1):ld hl,(clcn32z):  add hl,de:ld (clcn32z),hl
        ld e,(ix+2):ld d,(ix+3):ld hl,(clcn32z+2):adc hl,de:ld (clcn32z+2),hl
        ld de,-4
        add ix,de
        inc c
        dec c
        jr z,clcn323
        ld (iy+0),a
        inc iy
clcn323 djnz clcn321
        ld a,(clcn32z)
        add "0"
        ld (iy+0),a
        ld (iy+1),0

		inc		iy
		push	iy
		inc		iy
		ld		(SymBasic_StringStackTop),iy
		pop		hl
		pop		de
		sbc		hl,de
		push	hl			;The Length		
		push	de			;The Lower Stack Pointer
		ld		hl,(SymBasic_Temp_1)
		ei
		jp		(hl)
EndF		

clcn32t dw 1,0,     10,0,     100,0,     1000,0,     10000,0
        dw #86a0,1, #4240,#f, #9680,#98, #e100,#5f5, #ca00,#3b9a
clcn32z ds 4
	