
;***************
;**** Code *****
;***************
.AppWin     db   0
.DskPrzN    db   2
.SysPrzN    db   3
.WinDatPrz  equ  3

.V_App_Control_ID		db	0
.V_App_Control_Addr		dw	0
.V_App_Form_ID			db	0
.V_App_Form_Addr		dw 	0
.V_App_Action_ID		db	0
.V_App_OS_Form			db  0
.V_App_In_Use			db 	0

.AppPrz:
;**** Open Primary Window ****
		ld		a,0							;**** Form to Open first
		call	SymStudio_WindowOpen		;**** Form Opener
		;**** Sets up the Timer Stack ****
		ld		hl,SyStudio_TimerStack
		ld		a,(AppBnkNum)
		call	SyKernel_MTADDT
  		jp      c,App_End
       	ld      (PrgPstSpz+AppCodBeg),a
;****************************************
;**** Main Application Control Loop *****
;****************************************
.App_Control_Loop:
		ld		a,(V_App_In_Use)
		And		a
		jr		nz,App_Control_Loop
		call	SymStudio_App_Wait_Message	;**** See what Event has occurred
		jr		nc,App_Control_Loop0		;**** Erm non do again

		cp		MSR_DSK_WCLICK
		jr		nz,App_Control_Loop0
		ld		a,(AppMsgB+2)	   
		cp		DSK_ACT_CLOSE
		jp		z,App_End
		cp		DSK_ACT_MENU
 		jp		z,App_Menu
 		cp		DSK_ACT_CONTENT
 		jp		z,App_Content
		
.App_Control_Loop0:
		Xor		a
		ld		(V_App_In_Use),a
		jr		App_Control_Loop

;**********************
;**** Menu Control ****
;**********************
.App_Menu:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		hl,(AppMsgB+8)
		Xor		a
		cp		h
		jr		nz,App_Call_Set12
		cp		l
		jp		z,App_Control_Loop0
.App_Call_Set12
		Xor		a
		ld		(V_App_In_Use),a
		push	ix
		push	iy
		ld     (App_Call_Set2+1),hl
.App_Call_Set2:
		call   0
		pop		iy
		pop		ix		
		jp     App_Control_Loop

;****************************************
;**** User has clicked on one Object ****
;****************************************
.App_Content:
		call	SymStudio_App_Store_Message	;**** Do Info gathering
		jp		c,App_Control_Loop0			;**** If Object Non existant then Escape
		ld		hl,(V_App_Control_Addr)
		ld		de,2
		add		hl,de
		ld		a,(hl)						;**** Get type
		cp		20
		jp		z,Check_Tabs
.App_Content2:
		ld		hl,(V_App_Control_Addr)
		ld		de,14
		add		hl,de
		Xor		a
		ld		e,(hl)						;**** Get type
		inc		hl
		ld		d,(hl)
		cp		e		
		jr		nz,App_CallUserEvent_2
		cp		d
		jp		z,App_Control_Loop0
App_CallUserEvent_2
		Xor		a
		ld		(V_App_In_Use),a
		push	ix
		push	iy
		ld		(App_Content3+1),de
		ld		a,(AppMsgB+0)				;**** Action ID
.App_Content3:
		call	0
		pop		iy
		pop		ix
		jp		App_Control_Loop

;****************************
;**** Store User Message ****
;****************************
.SymStudio_App_Store_Message:
		ld		a,1								;**** Set Flag In Use
		ld		(V_App_In_Use),a				;****
		ld		a,(AppMsgB+1)
		ld		(V_App_OS_Form),a		
		ld		a,(AppMsgB+9)
		rra
		rra
		rra
		rra
		rra
		And		%111
		ld		(V_App_Form_ID),a
		ld		hl,SymStudio_FormIDs
		ld		e,a
		ld		d,0
		add		hl,de
		Xor		a
		cp		(hl)
		jr		nz,SymStudio_App_Store_Message_2
.SymStudio_App_Store_Message_3		
		scf
		ret
.SymStudio_App_Store_Message_2
		ld		hl,App_Form_List
		ld		a,(V_App_Form_ID)
		add		a
		ld		e,a
		ld		d,0
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		hl,36
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,(AppMsgB+8)		
		ld		(V_App_Control_ID),a		
		And		a
		jr		z,SymStudio_App_Store_Message_3
		inc		a
		ld		l,a
		ld		h,0
		add		hl,hl							;**** Times 2
		add		hl,hl							;**** Times 4
		add		hl,hl							;**** Times 8
		add		hl,hl							;**** Times 16
		add		hl,de							;**** Start of Control Record
		ld		(V_App_Control_Addr),hl
		scf
		ccf
		ret

;********************
;**** Check TABS ****
;********************
.Check_Tabs:
		ld		hl,(V_App_Control_Addr)
		ld		de,#4
		call 	Sys_HL_Addr
;**** Lets update OldValue	
		ld		de,2				;Point to Halue
		add		hl,de				;
		ld		a,(hl)				;a=Value
		ld		de,-4				;Point to OldValue
		add		hl,de				;
		cp		(hl)
		jp		z,YakkiMoron		;Skip cos its the Same
		ld		(hl),a				;Old Value updated
;****
		inc		hl					;Point to VisGroup start
		ld		c,(hl)				;c=Visgroup start
		add		c					;a=Visgroup the be Shown ( Value + VisGroup Start)
		inc		hl					;Point to number of Tabs
		ld		b,(hl)				;B= Number of Tabs
.MatadorShoes
		cp		c
		jr		z,ShowThisTab
.DontShowTab
		call	Sys_Visible_Off
		jr		Yukkie
.ShowThisTab
		call	Sys_Visible_On
.Yukkie
		inc		c
		djnz	MatadorShoes
		ld		hl,Sys_DisplayData
		ld		a,(V_App_Control_ID)
		sub		1
		ld		e,a
		ld		d,0
		add		hl,de
		ld		a,1
		ld		(hl),a
		inc		hl
		ld		(hl),a
		ld		hl,Sys_DisplayData
		ld		b,28
		ld		c,0
.GregorysGirl
		ld		a,(hl)
		cp		0
		jr		z,Gregorys2Girls
		ld		a,c
	
		push	bc
		push	hl
		Call	Sys_Redraw_Object
		pop		hl
		pop		bc
		ld		a,0
		ld		(hl),a
.Gregorys2Girls
		inc		c
		inc		hl
		djnz	GregorysGirl
.Yakkimoron
		jp		App_Content2

;*********************************
;**** SymStudio wait Message *****
;*********************************
.SymStudio_App_Wait_Message:
		rst		#30
		ld		a,(AppPrzN)
        db		#dd:ld l,a
        db		#dd:ld h,-1
        ld		iy,AppMsgB
        rst		#18
        Or		a
        db		#dd:dec l
        ret		nz
        ld		a,(AppMsgB+0)
        Or		a
        jr		z,App_End
		scf
		ret
.App_End:
        ld    a,(AppPrzN)
        db    #dd:ld l,a
        ld    a,(SysPrzN)
        db    #dd:ld h,a
        ld    a,(AppCodBeg+PrgPstNum)
        ld    h,a
        ld    l,MSC_SYS_PRGEND
        ld    (AppMsgB),hl
        ld    iy,AppMsgB
        rst   #10
.App_End0:
        rst   #30
        jr    App_End0

.Sys_Temp1:		dw	0

Sys_DisplayData:
		ds	256

;**** Basically Makes HL the contents of HL+DE
.Sys_HL_Addr
	add		hl,de
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	ex		de,hl
	ret
;**** System Routine ****
.Sys_Visible_On
	push	af
	push	bc
	push	de
	push	hl
;**** In 	C = Visability Group
;			B = Number of times To Loop
	ld		hl,(V_App_Form_Addr)
	ld		de,-16
	add		hl,de
	ld		b,(hl)
	ld		de,17
	add		hl,de
	ld		de,Sys_DisplayData
BwScangMuppet:
	ld		a,(hl)
	inc		hl
	And		%111111
	cp		c
	jr		nz,PhilCoolTugBoat
	ld		a,(hl)
	And		%111111
	ld		(hl),a
	ld		a,1
	ld		(de),a
PhilCoolTugBoat:
	inc		de
	push	de
	ld		de,15
	add		hl,de
	pop		de
	djnz	BwScangMuppet
	pop		hl
	pop		de
	pop		bc
	pop		af	
	ret

;**** System Routine ****
.Sys_Visible_Off
	push	af
	push	bc
	push	de
	push	hl
;**** In 	C = Visability Group
;			B = Number of times To Loop
	ld		hl,(V_App_Form_Addr)
	ld		de,-16
	add		hl,de
	ld		b,(hl)
	ld		de,17
	add		hl,de
	ld		de,15
BwScangMuppet2:
	ld		a,(hl)
	inc		hl
	And		%111111
	cp		c
	jr		nz,PhilCoolTugBoat2
	ld		a,(hl)
	Or		%11000000
	ld		(hl),a
PhilCoolTugBoat2:
	add		hl,de
	djnz	BwScangMuppet2
	pop		hl
	pop		de
	pop		bc
	pop		af
	ret

;**** System Routines ****
.Sys_Set_Visible:
;**** a = 0 \ Visible 1 \ Invisible
;**** b = Object
;**** c = Form
	And		%00000001
	rrca
	ld		e,c							;* e = form number
	ld		d,0							;* d = 0
	ld		hl,AppFormLists				;* Start of each Forms Data
	add		hl,de						;* HL = HL + (DE*2)
	add		hl,de						;
	ld		e,(hl)						;* DE = Address of Form Data
	inc 	hl
	ld		d,(hl)
	ld		(Sys_Temp1),de				;* Store the Base Address Temporarily

	ld		l,b							;* HL = Object
	ld		h,0
	add		hl,hl
	add		hl,hl
	add		hl,hl
	add		hl,hl
	add		hl,de
	inc		hl
	inc		hl							;* HL = Address of Type / Visibility Byte of Object
	ld		c,a
	ld		a,(hl)
	ld		e,a
	And		%01111111
	Or		c
	cp		e
	ret		z
	ld		(hl),a
	ld		a,b
	Call	Sys_Redraw_All
	ret

.Sys_Redraw_All_2
;		ld		IX,(App_IX_Store)
;		ld		IY,(App_IY_Store)
;**** System Routines ****
.Sys_Redraw_All:
		push	ix
		push	iy
		ld		a,-1
		ld		(AppMsgB+2),a		
		ld		a,MSC_DSK_WINDIN
		ld		(AppMsgB+0),a
		ld		a,(V_App_OS_Form)
		ld		(AppMsgB+1),a
		ld		iy,AppMsgB
		rst 	#10
		pop		iy
		pop		ix
		ret
.Sys_Redraw_Object_2
;		ld		IX,(App_IX_Store)
;		ld		IY,(App_IY_Store)	
;**** System Routines ****
.Sys_Redraw_Object:
		push	ix
		push	iy
		ld		(AppMsgB+2),a		
		ld		a,MSC_DSK_WINDIN
		ld		(AppMsgB+0),a
		ld		a,(V_App_OS_Form)
		ld		(AppMsgB+1),a
		ld		iy,AppMsgB
		rst 	#10
		pop		iy
		pop		ix
		ret
;****
.SymStudio_WindowOpen:
	ld		(SymStudio_FormNo),a
	ld		hl,SymStudio_FormIDs			;**** Check if Already Open
	ld		c,a
	ld		e,a
	ld		d,0
	add		hl,de
	ld		a,(hl)
	cp		0
	jr		nz,SymStudio_WindowOpen_2
	ld		a,c
	ld		hl,App_Form_List
	add		a
	ld		e,a
	ld		d,0
	add		hl,de
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	ld		a,(AppPrzN)	
	ld		hl,WinDatPrz
    add		hl,de
	ld		(hl),a
	ld		a,(AppBnkNum)	
	call	SyDesktop_WINOPN
	ld		b,a
	ld		a,(SymStudio_FormNo)
	ld		hl,SymStudio_FormIDs
	ld		e,a
	ld		d,0
	add		hl,de
	ld		(hl),b
.SymStudio_WindowOpen_2	
	ret
.SymStudio_FormNo:	db	0
.SymStudio_FormIDs:	db  0,0,0,0,0,0,0,0


;**** This is a Purely SymStudio contruct ****
.Sys_Timer_Code:
	ld		hl,SyStud_TimerRoutines		;List of where all the Timer data is
.Sys_Timer_Loop_Thing
	ld		e,(hl)						;Get Address from HL into DE
	inc		hl							;
	ld		d,(hl)						;
	inc		hl							;
	Xor		a							;Check if DE=0 cos then No more Timer Check
	cp		d
	jr		nz,Sys_Keep_Going1	
	cp		e
	jr		nz,Sys_Keep_Going1
	rst		#30							;Routine Empty
	jp		Sys_Timer_Code
.Sys_Keep_Going1
	ld		a,(de)						;Check the Timer Active if not 1 ingore
	cp		1
	jr		nz,Sys_Timer_Loop_Thing
	;**** Status clear so can check if Event Happens
	inc		de							;Move onto Timer Status byte
	ld		a,(de)
	cp 		0							;If A=then Active
	jr		nz,Sys_Timer_Loop_Thing
	;**** Okay we have to Do the Counter now
	ex		de,hl
	inc		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	dec		bc
	bit		7,b
	jr		nz,Sys_Timer_Timed_Out
	ld		(hl),b
	dec		hl
	ld		(hl),c
	ex		de,hl
	jr		Sys_Timer_Loop_Thing
.Sys_Timer_Timed_Out:
	inc		hl							;Moves to Low Byte of Max Word
	ld		c,(hl)						;Get
	inc		hl							;Move to High Byte of Max Word
	ld		b,(hl)						;Get
	dec		hl							;Back to Low Byte
	dec		hl							;Back to Hi Byte Counter
	ld		(hl),b						;Store
	dec		hl							;Low Byte Counter
	ld		(hl),c						;Store
	dec		hl							;Back to Status
	push	hl
	ld		a,1
	ld		(hl),a
	inc		hl
	inc		hl							;High Byte Counter
	inc		hl							;Low Byte Max
	inc		hl							;High Byte Max
	inc		hl   						;Jump Address
	ld		a,(hl)
	ld		(Sys_Timer_JumpLoc1+1),a
	inc		hl
	ld		a,(hl)
	ld		(Sys_Timer_JumpLoc1+2),a
	push	de
.Sys_Timer_JumpLoc1
	call	0
	pop		hl
	pop		de
	ld		a,0
	ld		(de),a
	jr		Sys_Timer_Loop_Thing
	