;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@                    S y m b O S   -   C o n s t a n t s                     @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


retro_mode      equ 0   ;flag, if OS is assembled for trex/c-one core/rom/dsk-control
rom_mode        equ 1   ;Rom-Version 1, Disc-Version 0


;P R O C E S S - I D S
PRC_ID_KERNEL   equ 1   ;kernel process
PRC_ID_DESKTOP  equ 2   ;desktop manager process
PRC_ID_SYSTEM   equ 3   ;system manager process


;M E S S A G E S
;General
MSC_GEN_QUIT    equ 0   ;application is beeing asked, to quit itself

;Kernel Commands
MSC_KRL_MTADDP  equ 1   ;add process (P1/2=stack, P3=priority (7 high - 1 low), P4=ram bank (0-8))
MSC_KRL_MTDELP  equ 2   ;delete process (P1=ID)
MSC_KRL_MTADDT  equ 3   ;add timer (P1/2=stack, P4=ram bank (0-8))
MSC_KRL_MTDELT  equ 4   ;delete timer (P1=ID)
MSC_KRL_MTSLPP  equ 5   ;set process to sleep mode
MSC_KRL_MTWAKP  equ 6   ;wake up process
MSC_KRL_TMADDT  equ 7   ;add counter service (P1/2=address, P3=ram bank, P4=process, P5=frequency)
MSC_KRL_TMDELT  equ 8   ;delete counter service (P1/2=address, P3=ram bank)
MSC_KRL_TMDELP  equ 9   ;delete all counter services of one process (P1=process ID)

;Kernel Responses
MSR_KRL_MTADDP  equ 129 ;process has been added (P1=0/1->ok/failed, P2=ID)
MSR_KRL_MTDELP  equ 130 ;process has been deleted
MSR_KRL_MTADDT  equ 131 ;timer process has been deleted (P1=0/1->ok/failed, P2=ID)
MSR_KRL_MTDELT  equ 132 ;timer has been removed
MSR_KRL_MTSLPP  equ 133 ;process is sleeping now
MSR_KRL_MTWAKP  equ 134 ;process has been waked up
MSR_KRL_TMADDT  equ 135 ;counter service has been added (P1=0/1->ok/failed)
MSR_KRL_TMDELT  equ 136 ;counter service has been deleted
MSR_KRL_TMDELP  equ 137 ;all counter services of a process have been deleted

;System Commands
MSC_SYS_PRGRUN  equ 16  ;load application or document (P1/2=address filename, P3=ram bank filename)
MSC_SYS_PRGEND  equ 17  ;quit application (P1=ID)
MSC_SYS_SYSWNX  equ 18  ;open dialogue to change current window (next) (-)
MSC_SYS_SYSWPR  equ 19  ;open dialogue to change current window (previouse) (vorheriges) (-)
MSC_SYS_PRGSTA  equ 20  ;open dialogue to load application or document (-)
MSC_SYS_SYSSEC  equ 21  ;open system secuity dialogue (-)
MSC_SYS_SYSQIT  equ 22  ;open shut shown dialogue (-)
MSC_SYS_SYSOFF  equ 23  ;shut down (-)
MSC_SYS_PRGSET  equ 24  ;start control panel (P1=submodul -> 0=main window, 1=display settings, 2=date/time)
MSC_SYS_PRGTSK  equ 25  ;start taskmanager (-)
MSC_SYS_SYSFIL  equ 26  ;call filemanager function (P1=number, P2-13=AF,BC,DE,HL,IX,IY)
MSC_SYS_SYSKRN  equ 27  ;call kernel function (P1=number, P2-13=AF,BC,DE,HL,IX,IY)
MSC_SYS_SYSCFG  equ 28  ;call config function (P1=number, 0=load, 1=save, 2=reload background)
MSC_SYS_SYSWRN  equ 29  ;open warning window (P1/2=adresse, P3=ram bank, P4=number of buttons)
MSC_SYS_SELOPN  equ 31  ;open fileselect dialogue (P6=filename ram bank, P8/9=filename address, P7=forbidden attributes, P10=max entries, P12=max buffer size)

;System Responses
MSR_SYS_PRGRUN  equ 144 ;application has been started (P1=result -> 0=ok, 1=file doesnt exist, 2=file is not executable, 3=error while loading, 4=memory full)
MSR_SYS_SYSFIL  equ 154 ;filemanager function returned (P1=number, P2-13=AF,BC,DE,HL,IX,IY)
MSR_SYS_SYSKRN  equ 155 ;kernel function returned (P1=number, P2-13=AF,BC,DE,HL,IX,IY)
MSR_SYS_SELOPN  equ 159 ;message from fileselect dialogue (P1 -> 0=Ok, 1=cancel, 2=already in use, 3=no memory free, 4=no window free, -1=open ok, super window has been opened [P2=number])

;Desktop Commands
MSC_DSK_WINOPN  equ 32  ;open window (P1=ram bank, P2/3=address data record)
MSC_DSK_WINMEN  equ 33  ;redraw menu bar (P1=window ID) [only if focus]
MSC_DSK_WININH  equ 34  ;redraw window content (P1=window ID, P2=-1/-Num/Object, P3=Object) [only if focus]
MSC_DSK_WINTOL  equ 35  ;redraw window toolbar (P1=window ID) [only if focus]
MSC_DSK_WINTIT  equ 36  ;redraw window title (P1=window ID) [only if focus]
MSC_DSK_WINSTA  equ 37  ;redraw window status lien (P1=window ID) [only if focus]
MSC_DSK_WINMVX  equ 38  ;set content x offset (P1=window ID, P2/3=XPos) [only if focus]
MSC_DSK_WINMVY  equ 39  ;set content y offset (P1=window ID, P2/3=XPos) [only if focus]
MSC_DSK_WINTOP  equ 40  ;takes window to the front (P1=window ID) [always]
MSC_DSK_WINMAX  equ 41  ;maximize window (P1=window ID) [always]
MSC_DSK_WINMIN  equ 42  ;minimize window (P1=window ID) [always]
MSC_DSK_WINMID  equ 43  ;restore window size (P1=window ID) [always]
MSC_DSK_WINMOV  equ 44  ;moves window to a new position (P1=window ID, P2/3=XPos, P4/5=YPos) [always]
MSC_DSK_WINSIZ  equ 45  ;resize the window (P1=window ID, P2/3=XPos, P4/5=YPos) [always]
MSC_DSK_WINCLS  equ 46  ;closes and removes window (P1=window ID) [always]
MSC_DSK_WINDIN  equ 47  ;redraw window content, even if it hasnt focus (P1=window ID, P2=-1/Objekt) [always]
MSC_DSK_DSKSRV  equ 48  ;desktop service request (P1=type, P2-P5=parameters)
MSC_DSK_WINSLD  equ 49  ;redraw window scrollbars (P1=window ID) [only if focus]
MSC_DSK_WINPIN  equ 50  ;redraw window content part (P1=window ID, P2=-1/-Num/Object, P3=Object, P4/5=Xbeg, P6/7=Ybeg, P8/9=Xlen, P10/11=Xlen) [always]

;Desktop Responses
MSR_DSK_WOPNER  equ 160 ;open window failed; the maximum of 32 windows has been reached
MSR_DSK_WOPNOK  equ 161 ;open window successfull (P4=number)
MSR_DSK_WCLICK  equ 162 ;window has been clicked (P1=window number, P2=action, P3=subspezification, P4/5,P6/7,P8/9=parameters)
MSR_DSK_DSKSRV  equ 163 ;desktop service answer (P1=type, P2-P5=parameters)
MSR_DSK_WFOCUS  equ 164 ;window got/lost focus (P1=window number, P2=type [0=blur, 1=focus])
MSR_DSK_CFOCUS  equ 165 ;control focus changed (P1=window number, P2=control number, P3=reason [0=mouse click/wheel, 1=tab key])

;Shell Commands
MSC_SHL_CHRINP  equ 64  ;char is requested (P1=channel [0=standard, 1=keyboard])
MSC_SHL_STRINP  equ 65  ;line is requested (P1=channel [0=standard, 1=keyboard], P2=ram bank, P3/4=address)
MSC_SHL_CHROUT  equ 66  ;char should be writtten (P1=channel [0=standard, 1=screen], P2=char)
MSC_SHL_STROUT  equ 67  ;line should be writtten (P1=channel [0=standard, 1=screen], P2=ram bank, P3/4=address, P5=length)
MSC_SHL_EXIT    equ 68  ;application released focus or quit itself (P1 -> 0=quit, 1=blur)

;Shell Responses
MSR_SHL_CHRINP  equ 192 ;char has been received (P1=EOF-flag [0=no EOF], P2=char, P3=error status)
MSR_SHL_STRINP  equ 193 ;line has been received (P1=EOF-flag [0=no EOF], P3=error status)
MSR_SHL_CHROUT  equ 194 ;char has been written (P3=error status)
MSR_SHL_STROUT  equ 195 ;line has been written (P3=error status)

;Screensaver Messages
MSC_SAV_INIT    equ 1   ;initialises the screen saver (P1=bank of config data, P2/3=address of config data [64bytes])
MSC_SAV_START   equ 2   ;start screen saver
MSC_SAV_CONFIG  equ 3   ;open screen savers own config window (at the end the screen saver has to send the result back to the sender)
MSR_SAV_CONFIG  equ 4   ;returns user adjusted screen saver config data (P1=bank of config data, P2/3=address of config data [64bytes])


;D E S K T O P - A C T I O N S
DSK_ACT_CLOSE   equ 5   ;close button has been clicked or ALT+F4 has been pressed
DSK_ACT_MENU    equ 6   ;menu entry has been clicked (P8/9=menu entry value)
DSK_ACT_CONTENT equ 14  ;a control of the content has been clicked (P3=sub spec [see dsk_sub...], P4=key or P4/5=Xpos within the window, P6/7=Ypos, P8/9=control value)
DSK_ACT_TOOLBAR equ 15  ;a control of the toolbar has been clicked (see DSK_ACT_CONTENT)
DSK_ACT_KEY     equ 16  ;key has been pressed without touching/modifying a control (P4=Ascii Code)

DSK_SUB_MLCLICK equ 0   ;left mouse button has been clicked
DSK_SUB_MRCLICK equ 1   ;right mouse button has been clicked
DSK_SUB_MDCLICK equ 2   ;double click with the left mouse button
DSK_SUB_MMCLICK equ 3   ;middle mouse button has been clicked
DSK_SUB_KEY     equ 7   ;keyboard has been clicked and did modify/click a control (P4=Ascii Code)
DSK_SUB_MWHEEL  equ 8   ;mouse wheel has been moved (P4=Offset)


;D E S K T O P - S E R V I C E S
DSK_SRV_MODGET  equ 1   ;get screen mode (output P2=mode)
DSK_SRV_MODSET  equ 2   ;set screen mode (input P2=mode)
DSK_SRV_COLGET  equ 3   ;get colour      (input P2=number, output P2=number, P3/4=RGB value)
DSK_SRV_COLSET  equ 4   ;set colour      (input P2=number, P3/4=RGB value)
DSK_SRV_DSKSTP  equ 5   ;freeze desktop  (input P2=type [0=Pen0, 1=Raster, 2=background, 255=no screen modification, switch off mouse])
DSK_SRV_DSKCNT  equ 6   ;continue desktop
DSK_SRV_DSKPNT  equ 7   ;clear desktop   (Eingabe P2=Typ [0=Pen0, 1=Raster, 2=background])
DSK_SRV_DSKBGR  equ 8   ;initialize and redraw desktop background
DSK_SRV_DSKPLT  equ 9   ;redraw the complete desktop


;J U M P S
jmp_memsum  equ #8100 ;MEMSUM
jmp_sysinf  equ #8103 ;SYSINF
jmp_clcnum  equ #8106 ;CLCNUM
jmp_mtgcnt  equ #8109 ;MTGCNT
jmp_timget  equ #810C ;TIMGET
jmp_timset  equ #810F ;TIMSET
jmp_memget  equ #8118 ;MEMGET
jmp_memfre  equ #811B ;MEMFRE
jmp_memsiz  equ #811E ;MEMSIZ
jmp_meminf  equ #8121 ;MEMINF
jmp_bnkrwd  equ #8124 ;BNKRWD
jmp_bnkwwd  equ #8127 ;BNKWWD
jmp_bnkrbt  equ #812A ;BNKRBT
jmp_bnkwbt  equ #812D ;BNKWBT
jmp_bnkcop  equ #8130 ;BNKCOP
jmp_bnkget  equ #8133 ;BNKGET
jmp_filf2t  equ #8136 ;FILF2T
jmp_filt2f  equ #8139 ;FILT2F
jmp_mosget  equ #813C ;MOSGET
jmp_moskey  equ #813F ;MOSKEY
jmp_bnk16c  equ #8142 ;BNK16C
jmp_keytst  equ #8145 ;KEYTST
jmp_keysta  equ #8148 ;KEYSTA
jmp_keyput  equ #814B ;KEYPUT


;Filemanager Functions (call via MSC_SYS_SYSFIL)
FNC_FIL_STOINI  equ 000
FNC_FIL_STONEW  equ 001
FNC_FIL_STORLD  equ 002
FNC_FIL_STODEL  equ 003
FNC_FIL_STOINP  equ 004
FNC_FIL_STOOUT  equ 005
FNC_FIL_STOACT  equ 006
FNC_FIL_STOINF  equ 007

FNC_FIL_DEVDIR  equ 013
FNC_FIL_DEVINI  equ 014
FNC_FIL_DEVSET  equ 015

FNC_FIL_FILINI  equ 016
FNC_FIL_FILNEW  equ 017
FNC_FIL_FILOPN  equ 018
FNC_FIL_FILCLO  equ 019
FNC_FIL_FILINP  equ 020
FNC_FIL_FILOUT  equ 021
FNC_FIL_FILPOI  equ 022
FNC_FIL_FILF2T  equ 023
FNC_FIL_FILT2F  equ 024
FNC_FIL_FILLIN  equ 025

FNC_FIL_DIRDEV  equ 032
FNC_FIL_DIRPTH  equ 033
FNC_FIL_DIRPRS  equ 034
FNC_FIL_DIRPRR  equ 035
FNC_FIL_DIRREN  equ 036
FNC_FIL_DIRNEW  equ 037
FNC_FIL_DIRINP  equ 038
FNC_FIL_DIRDEL  equ 039
FNC_FIL_DIRRMD  equ 040
FNC_FIL_DIRMOV  equ 041
FNC_FIL_DIRINF  equ 042

.PrgDatCod     equ 0	;Code Length including 256 Header
.PrgDatDat     equ 2	;Data Length to a maximum 16k
.PrgDatTra     equ 4   ;Transfer Part Length
.PrgDatOrg     equ 6   ;Original ORG
.PrgDatRel     equ 8   ;Number of Entries in Relocation Table
.PrgDatStk     equ 10  ;Stack Length at start of Transfer
.PrgDatCrn     equ 12	;Crunched Length
.PrgDatCtp     equ 14	;Crunch Typ
.PrgDatNam     equ 15	;Program Name (Always 32 Bytes)+0 33 Byte
.PrgDatIdn     equ 48  ;SymExe10
.PrgDatRes     equ 56  ;Reserve
.PrgDatIsm     equ 90  ;Small Ico
.PrgDatIbg     equ 109 ;Big Ico
.PrgDatLen     equ 256 ;

.PrgPstDat     equ 6   ;
.PrgPstTra     equ 8   ;
.PrgPstSpz     equ 10  ;
.PrgPstBnk     equ 14  ;
.PrgPstMem     equ 48  ;
.PrgPstNum     equ 88  ;
.PrgPstPrz     equ 89  ;
SYMBOS_ORG #100
;**** 256 Application Header ****
.AppCodBeg     dw  AppDatBeg-AppCodBeg      ;Length of Cod
              dw  AppTrnBeg-AppDatBeg      ;Length of Dat
              dw  AppTrnEnd-AppTrnBeg      ;Length of Transfe
.AppDatAdr     dw  #100                    ;Original Origi
.AppTrnAdr     dw  0                        ;Number of Entries In Relocation Tabl
.AppPrzLst     dw  AppStk-AppTrnBeg         ;Stack Lengt
              dw  0                        ;Length of Crunched Dat
.AppBnkNum     db  0                        ;Crunch Typ
.AppNam        db  "SymbOS Application              ",0
.AppMemTab     db  "SymExe10"             ;File Check
              ds  34
.AppIcnSml    
        db 2,8,8
      db 0,0,0,0,0,0,0,0

        db 6,24,24
      db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
      db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
      db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;***************
;**** Code *****
;***************
.AppWin     db   0
.DskPrzN    db   2
.SysPrzN    db   3
.WinDatPrz  equ  3

.V_App_Control_ID		db	0
.V_App_Control_Addr		dw	0
.V_App_Form_ID			db	0
.V_App_Form_Addr		dw 	0
.V_App_Action_ID		db	0
.V_App_OS_Form			db  0
.V_App_In_Use			db 	0

.AppPrz:
;**** Open Primary Window ****
		ld		a,0							;**** Form to Open first
		call	SymStudio_WindowOpen		;**** Form Opener
		;**** Sets up the Timer Stack ****
		ld		hl,SyStudio_TimerStack
		ld		a,(AppBnkNum)
		call	SyKernel_MTADDT
  		jp      c,App_End
       	ld      (PrgPstSpz+AppCodBeg),a
;****************************************
;**** Main Application Control Loop *****
;****************************************
.App_Control_Loop:
		ld		a,(V_App_In_Use)
		And		a
		jr		nz,App_Control_Loop
		call	SymStudio_App_Wait_Message	;**** See what Event has occurred
		jr		nc,App_Control_Loop0		;**** Erm non do again

		cp		MSR_DSK_WCLICK
		jr		nz,App_Control_Loop0
		ld		a,(AppMsgB+2)	   
		cp		DSK_ACT_CLOSE
		jp		z,App_End
		cp		DSK_ACT_MENU
 		jp		z,App_Menu
 		cp		DSK_ACT_CONTENT
 		jp		z,App_Content
		
.App_Control_Loop0:
		Xor		a
		ld		(V_App_In_Use),a
		jr		App_Control_Loop

;**********************
;**** Menu Control ****
;**********************
.App_Menu:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		hl,(AppMsgB+8)
		Xor		a
		cp		h
		jr		nz,App_Call_Set12
		cp		l
		jp		z,App_Control_Loop0
.App_Call_Set12
		Xor		a
		ld		(V_App_In_Use),a
		push	ix
		push	iy
		ld     (App_Call_Set2+1),hl
.App_Call_Set2:
		call   0
		pop		iy
		pop		ix		
		jp     App_Control_Loop

;****************************************
;**** User has clicked on one Object ****
;****************************************
.App_Content:
		call	SymStudio_App_Store_Message	;**** Do Info gathering
		jp		c,App_Control_Loop0			;**** If Object Non existant then Escape
		ld		hl,(V_App_Control_Addr)
		ld		de,2
		add		hl,de
		ld		a,(hl)						;**** Get type
		cp		20
		jp		z,Check_Tabs
.App_Content2:
		ld		hl,(V_App_Control_Addr)
		ld		de,14
		add		hl,de
		Xor		a
		ld		e,(hl)						;**** Get type
		inc		hl
		ld		d,(hl)
		cp		e		
		jr		nz,App_CallUserEvent_2
		cp		d
		jp		z,App_Control_Loop0
App_CallUserEvent_2
		Xor		a
		ld		(V_App_In_Use),a
		push	ix
		push	iy
		ld		(App_Content3+1),de
		ld		a,(AppMsgB+0)				;**** Action ID
.App_Content3:
		call	0
		pop		iy
		pop		ix
		jp		App_Control_Loop

;****************************
;**** Store User Message ****
;****************************
.SymStudio_App_Store_Message:
		ld		a,1								;**** Set Flag In Use
		ld		(V_App_In_Use),a				;****
		ld		a,(AppMsgB+1)
		ld		(V_App_OS_Form),a		
		ld		a,(AppMsgB+9)
		rra
		rra
		rra
		rra
		rra
		And		%111
		ld		(V_App_Form_ID),a
		ld		hl,SymStudio_FormIDs
		ld		e,a
		ld		d,0
		add		hl,de
		Xor		a
		cp		(hl)
		jr		nz,SymStudio_App_Store_Message_2
.SymStudio_App_Store_Message_3		
		scf
		ret
.SymStudio_App_Store_Message_2
		ld		hl,App_Form_List
		ld		a,(V_App_Form_ID)
		add		a
		ld		e,a
		ld		d,0
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		hl,36
		add		hl,de
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,(AppMsgB+8)		
		ld		(V_App_Control_ID),a		
		And		a
		jr		z,SymStudio_App_Store_Message_3
		inc		a
		ld		l,a
		ld		h,0
		add		hl,hl							;**** Times 2
		add		hl,hl							;**** Times 4
		add		hl,hl							;**** Times 8
		add		hl,hl							;**** Times 16
		add		hl,de							;**** Start of Control Record
		ld		(V_App_Control_Addr),hl
		scf
		ccf
		ret

;********************
;**** Check TABS ****
;********************
.Check_Tabs:
		ld		hl,(V_App_Control_Addr)
		ld		de,#4
		call 	Sys_HL_Addr
;**** Lets update OldValue	
		ld		de,2				;Point to Halue
		add		hl,de				;
		ld		a,(hl)				;a=Value
		ld		de,-4				;Point to OldValue
		add		hl,de				;
		cp		(hl)
		jp		z,YakkiMoron		;Skip cos its the Same
		ld		(hl),a				;Old Value updated
;****
		inc		hl					;Point to VisGroup start
		ld		c,(hl)				;c=Visgroup start
		add		c					;a=Visgroup the be Shown ( Value + VisGroup Start)
		inc		hl					;Point to number of Tabs
		ld		b,(hl)				;B= Number of Tabs
.MatadorShoes
		cp		c
		jr		z,ShowThisTab
.DontShowTab
		call	Sys_Visible_Off
		jr		Yukkie
.ShowThisTab
		call	Sys_Visible_On
.Yukkie
		inc		c
		djnz	MatadorShoes
		ld		hl,Sys_DisplayData
		ld		a,(V_App_Control_ID)
		sub		1
		ld		e,a
		ld		d,0
		add		hl,de
		ld		a,1
		ld		(hl),a
		inc		hl
		ld		(hl),a
		ld		hl,Sys_DisplayData
		ld		b,28
		ld		c,0
.GregorysGirl
		ld		a,(hl)
		cp		0
		jr		z,Gregorys2Girls
		ld		a,c
	
		push	bc
		push	hl
		Call	Sys_Redraw_Object
		pop		hl
		pop		bc
		ld		a,0
		ld		(hl),a
.Gregorys2Girls
		inc		c
		inc		hl
		djnz	GregorysGirl
.Yakkimoron
		jp		App_Content2

;*********************************
;**** SymStudio wait Message *****
;*********************************
.SymStudio_App_Wait_Message:
		rst		#30
		ld		a,(AppPrzN)
        db		#dd:ld l,a
        db		#dd:ld h,-1
        ld		iy,AppMsgB
        rst		#18
        Or		a
        db		#dd:dec l
        ret		nz
        ld		a,(AppMsgB+0)
        Or		a
        jr		z,App_End
		scf
		ret
.App_End:
        ld    a,(AppPrzN)
        db    #dd:ld l,a
        ld    a,(SysPrzN)
        db    #dd:ld h,a
        ld    a,(AppCodBeg+PrgPstNum)
        ld    h,a
        ld    l,MSC_SYS_PRGEND
        ld    (AppMsgB),hl
        ld    iy,AppMsgB
        rst   #10
.App_End0:
        rst   #30
        jr    App_End0

.Sys_Temp1:		dw	0

Sys_DisplayData:
		ds	256

;**** Basically Makes HL the contents of HL+DE
.Sys_HL_Addr
	add		hl,de
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	ex		de,hl
	ret
;**** System Routine ****
.Sys_Visible_On
	push	af
	push	bc
	push	de
	push	hl
;**** In 	C = Visability Group
;			B = Number of times To Loop
	ld		hl,(V_App_Form_Addr)
	ld		de,-16
	add		hl,de
	ld		b,(hl)
	ld		de,17
	add		hl,de
	ld		de,Sys_DisplayData
BwScangMuppet:
	ld		a,(hl)
	inc		hl
	And		%111111
	cp		c
	jr		nz,PhilCoolTugBoat
	ld		a,(hl)
	And		%111111
	ld		(hl),a
	ld		a,1
	ld		(de),a
PhilCoolTugBoat:
	inc		de
	push	de
	ld		de,15
	add		hl,de
	pop		de
	djnz	BwScangMuppet
	pop		hl
	pop		de
	pop		bc
	pop		af	
	ret

;**** System Routine ****
.Sys_Visible_Off
	push	af
	push	bc
	push	de
	push	hl
;**** In 	C = Visability Group
;			B = Number of times To Loop
	ld		hl,(V_App_Form_Addr)
	ld		de,-16
	add		hl,de
	ld		b,(hl)
	ld		de,17
	add		hl,de
	ld		de,15
BwScangMuppet2:
	ld		a,(hl)
	inc		hl
	And		%111111
	cp		c
	jr		nz,PhilCoolTugBoat2
	ld		a,(hl)
	Or		%11000000
	ld		(hl),a
PhilCoolTugBoat2:
	add		hl,de
	djnz	BwScangMuppet2
	pop		hl
	pop		de
	pop		bc
	pop		af
	ret

;**** System Routines ****
.Sys_Set_Visible:
;**** a = 0 \ Visible 1 \ Invisible
;**** b = Object
;**** c = Form
	And		%00000001
	rrca
	ld		e,c							;* e = form number
	ld		d,0							;* d = 0
	ld		hl,AppFormLists				;* Start of each Forms Data
	add		hl,de						;* HL = HL + (DE*2)
	add		hl,de						;
	ld		e,(hl)						;* DE = Address of Form Data
	inc 	hl
	ld		d,(hl)
	ld		(Sys_Temp1),de				;* Store the Base Address Temporarily

	ld		l,b							;* HL = Object
	ld		h,0
	add		hl,hl
	add		hl,hl
	add		hl,hl
	add		hl,hl
	add		hl,de
	inc		hl
	inc		hl							;* HL = Address of Type / Visibility Byte of Object
	ld		c,a
	ld		a,(hl)
	ld		e,a
	And		%01111111
	Or		c
	cp		e
	ret		z
	ld		(hl),a
	ld		a,b
	Call	Sys_Redraw_All
	ret

.Sys_Redraw_All_2
;		ld		IX,(App_IX_Store)
;		ld		IY,(App_IY_Store)
;**** System Routines ****
.Sys_Redraw_All:
		push	ix
		push	iy
		ld		a,-1
		ld		(AppMsgB+2),a		
		ld		a,MSC_DSK_WINDIN
		ld		(AppMsgB+0),a
		ld		a,(V_App_OS_Form)
		ld		(AppMsgB+1),a
		ld		iy,AppMsgB
		rst 	#10
		pop		iy
		pop		ix
		ret
.Sys_Redraw_Object_2
;		ld		IX,(App_IX_Store)
;		ld		IY,(App_IY_Store)	
;**** System Routines ****
.Sys_Redraw_Object:
		push	ix
		push	iy
		ld		(AppMsgB+2),a		
		ld		a,MSC_DSK_WINDIN
		ld		(AppMsgB+0),a
		ld		a,(V_App_OS_Form)
		ld		(AppMsgB+1),a
		ld		iy,AppMsgB
		rst 	#10
		pop		iy
		pop		ix
		ret
;****
.SymStudio_WindowOpen:
	ld		(SymStudio_FormNo),a
	ld		hl,SymStudio_FormIDs			;**** Check if Already Open
	ld		c,a
	ld		e,a
	ld		d,0
	add		hl,de
	ld		a,(hl)
	cp		0
	jr		nz,SymStudio_WindowOpen_2
	ld		a,c
	ld		hl,App_Form_List
	add		a
	ld		e,a
	ld		d,0
	add		hl,de
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	ld		a,(AppPrzN)	
	ld		hl,WinDatPrz
    add		hl,de
	ld		(hl),a
	ld		a,(AppBnkNum)	
	call	SyDesktop_WINOPN
	ld		b,a
	ld		a,(SymStudio_FormNo)
	ld		hl,SymStudio_FormIDs
	ld		e,a
	ld		d,0
	add		hl,de
	ld		(hl),b
.SymStudio_WindowOpen_2	
	ret
.SymStudio_FormNo:	db	0
.SymStudio_FormIDs:	db  0,0,0,0,0,0,0,0


;**** This is a Purely SymStudio contruct ****
.Sys_Timer_Code:
	ld		hl,SyStud_TimerRoutines		;List of where all the Timer data is
.Sys_Timer_Loop_Thing
	ld		e,(hl)						;Get Address from HL into DE
	inc		hl							;
	ld		d,(hl)						;
	inc		hl							;
	Xor		a							;Check if DE=0 cos then No more Timer Check
	cp		d
	jr		nz,Sys_Keep_Going1	
	cp		e
	jr		nz,Sys_Keep_Going1
	rst		#30							;Routine Empty
	jp		Sys_Timer_Code
.Sys_Keep_Going1
	ld		a,(de)						;Check the Timer Active if not 1 ingore
	cp		1
	jr		nz,Sys_Timer_Loop_Thing
	;**** Status clear so can check if Event Happens
	inc		de							;Move onto Timer Status byte
	ld		a,(de)
	cp 		0							;If A=then Active
	jr		nz,Sys_Timer_Loop_Thing
	;**** Okay we have to Do the Counter now
	ex		de,hl
	inc		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	dec		bc
	bit		7,b
	jr		nz,Sys_Timer_Timed_Out
	ld		(hl),b
	dec		hl
	ld		(hl),c
	ex		de,hl
	jr		Sys_Timer_Loop_Thing
.Sys_Timer_Timed_Out:
	inc		hl							;Moves to Low Byte of Max Word
	ld		c,(hl)						;Get
	inc		hl							;Move to High Byte of Max Word
	ld		b,(hl)						;Get
	dec		hl							;Back to Low Byte
	dec		hl							;Back to Hi Byte Counter
	ld		(hl),b						;Store
	dec		hl							;Low Byte Counter
	ld		(hl),c						;Store
	dec		hl							;Back to Status
	push	hl
	ld		a,1
	ld		(hl),a
	inc		hl
	inc		hl							;High Byte Counter
	inc		hl							;Low Byte Max
	inc		hl							;High Byte Max
	inc		hl   						;Jump Address
	ld		a,(hl)
	ld		(Sys_Timer_JumpLoc1+1),a
	inc		hl
	ld		a,(hl)
	ld		(Sys_Timer_JumpLoc1+2),a
	push	de
.Sys_Timer_JumpLoc1
	call	0
	pop		hl
	pop		de
	ld		a,0
	ld		(de),a
	jr		Sys_Timer_Loop_Thing
	
;*********************************
;***** SymBasic Code Library *****
;*********************************

.SymBasic_VarsinList:		db 	0
.SymBasic_WhereAddr:		dw	0
.SymBasic_Pass_1:			dw  0
.SymBasic_Pass_2:			dw	0

Global	Error%
.SymBasic_FunctionPasser
		pop		hl			;**** Gets the Return Location
;**** Read the first 2 bytes which are the Function Address
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		ld		a,(bc)
		ld		(SymBasic_VarsinList),a
		inc		bc		
		ld		(SymBasic_WhereAddr),bc

		ld		c,l
		ld		b,h

.SymBasic_FuncPass_1
		ld		a,(SymBasic_VarsinList)
		And		a
		jp		z,SymBasic_FunctionPasser_End
		dec		a
		ld		(SymBasic_VarsinList),a
;		BC = Address of List of Types to Convert from stack
		
;**** Gets the Variable from List 
		ld		hl,(SymBasic_WhereAddr)
		push	bc				;Stores
		ld		bc,7	
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		add		hl,bc
		pop		bc				;Retrieves DE
		ld		(SymBasic_WhereAddr),hl
;**** Gets the Type to Pull from Stack
		ld		a,(bc)
		inc		bc
		cp		1
		jp		z,SymBasic_FunctionPassShort
		cp		2
		jp		z,SymBasic_FunctionPassLong
		cp		5
		jp		z,SymBasic_FunctionPassString

		di
.killerbee2		jr	killerbee2		

.symBasic_FunctionPassShort
		pop		hl					;Gets From Stack
		pop		hl
		ex		de,hl				;Swaps so DE=Contents of Stack HL=Location of Variable
		ld		(hl),e
		inc		hl
		ld		(hl),d
		jp		SymBasic_FuncPass_1
		
.SymBasic_FunctionPassLong
		pop		hl
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		inc		hl
		ex		de,hl
		pop		hl
		ex		de,hl
		ld		(hl),e
		inc		hl
		ld		(hl),d
		jp		SymBasic_FuncPass_1

.SymBasic_FunctionPassString
		ld		(SymBasic_Pass_1),bc
		ld		(SymBasic_Pass_2),de
		ld		hl,SymBasic_FunctionPassString_2
		ld		(SymBasic_Temp_1),hl
		jp		SymBasic_StoreStringFromStack_2
.SymBasic_FunctionPassString_2
		ld		bc,(SymBasic_Pass_1)
		ld		de,(SymBasic_Pass_2)
		jp		SymBasic_FuncPass_1
		
.SymBasic_FunctionPasser_End
		push	bc
		ld		hl,(SymBasic_WhereAddr)
		jp		(hl)

.SymBasic_Temp_1
		dw		0
.SymBasic_Temp_2
		dw		0
.SymBasic_Temp_3
		dw		0
.SymBasic_Temp_4
		dw		0
.SymBasic_Temp_5
		dw		0		

.SymBasic_StackLong2Int
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		pop		bc
		pop		bc		
		ld		(hl),c
		inc		hl
		ld		(hl),b
		ex		de,hl
		jp		(hl)
	

;*****************************************		
;**** Get A Direct String from Memory ****
;*****************************************
.SymBasic_GetDirectString
		di
		pop		hl									;**** Return Address
		ld		de,(SymBasic_StringStackTop)		;**** Get Top of Text Stack
		ld		a,(hl)								;**** Gets the number of characters to display
		inc		hl									;**** Incs do HL points at next command
		And		a									;**** Perform check
		jr		z,SymBasic_GetDirectString_Empty	;**** Is it a zero length
		ld		c,a
		ld		b,0									;**** Null B
		push	bc									;**** Push Length to stack
		ld		de,(SymBasic_StringStackTop)		;**** Get start of String Addr
		push	de									;**** Store Start on String on Stack
		ldir										;**** Copy
		ld		(SymBasic_StringStackTop),de		;**** Store the String Text start location
		ei
		jp		(hl)								;**** Back To code
.SymBasic_GetDirectString_Empty
		ld		bc,0								;**** No length	in BC
		push	bc									;**** Store No Lenght
		push	de									;**** Store Text location though Empty
		ei
		jp		(hl)								;**** Back to Code


;*******************************************
;**** Get string From variable Location ****
;*******************************************
.SymBasic_GetVarString
		di
		pop		hl									;**** Return Address
		ld		e,(hl)								;**** Get Low of Variable Address
		inc		hl									;**** Step on one
		ld		d,(hl)								;**** Get High of Variable Address
		inc		hl									;**** Step on so now Pointing at real return address
		ld		(Symbasic_Temp_1),hl				;**** Store return Address
		ex		de,hl								;**** Swap
		ld		e,(hl)								;**** Gets Low Start Address of string
		inc		hl									;**** Move on
		ld		d,(hl)								;**** Gets High Start Address of string
		inc		hl									;**** Move On
		ld		a,(hl)								;**** Get Length
		And		a									;**** Check if Zero			
		jp		z,SymBasic_GetVarString_Empty		;**** If Zero then End
		ld		c,a									;**** c=Length
		ld		b,0									;**** Null B
		push	bc									;**** Push Length onto stack
		inc		de									;**** Step over 2 byte Link List
		inc		de									;****		
		ex		de,hl								;**** Swap so HL = Address to copy from
		ld		de,(SymBasic_StringStackTop)		;**** Get Place to Copy too
		push	de									;**** Store Start of copied text
		ldir										;**** Copy
		ld		(SymBasic_StringStackTop),de		;**** Store New Stack position to copy text
		ld		hl,(SymBasic_Temp_1),hl				;**** Get Return Location
		ei
		jp		(hl)								;**** Return
.SymBasic_GetVarString_Empty
		ld		bc,0								;**** Null Length
		push	bc									;**** Store on Stack
		ld		de,(SymBasic_StringStackTop)		;**** Get Place to Copy too		
		push	de									;**** Store on Stack
		ld		hl,(Symbasic_Temp_1)				;**** Get Return Address
		ei
		jp		(hl)								;**** Return
		






.SymBasic_GetIntVar
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc
		ld		bc,0
		push	bc
		push	de		
		ret

.SymBasic_GetLongVar
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		push	bc
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc
		push	de
		ret

.SymBasic_GetByteVar
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		ld		c,(hl)
		ld		b,0
		push	bc
		ld		c,0
		push	bc
		push	de
		ret

.SymBasic_GetIntArray1
		pop		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		ld		(SymBasic_Temp_1),hl

		pop		hl				;**** Get 32 Bit off stack
		pop		hl
		add		hl,hl			;**** Double it
		add		hl,bc
		ld		bc,8
		add		hl,bc

		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		push	de
		ld		de,0
		push	de

		ld		hl,(SymBasic_Temp_1),hl
		jp		(hl)


.SymBasic_GetLongNum
		pop		hl				;**** Get the Return location from Stack
		ld		e,(hl)			;**** Get First Byte of Integer
		inc		hl				;**** Increase It
		ld		d,(hl)			;**** Get Second Byte of Integer
		inc		hl				;**** Increase It - Now Points to return Location
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc				;**** Push Integer to Stack
		push	de				;****
		push	hl				;**** Push New Return Location to Stack
		ret						;**** Return to code

.SymBasic_CallFunction
		pop		hl
		ld		e,(hl)			;**** Get Address
		inc		hl
		ld		d,(hl)			;**** Get Address
		inc		hl
		ld		c,(hl)
		inc		hl			
		push	hl				;**** HL = Return Address
		ex		de,hl
		jp		(hl)

;**** STRINGCOMPARE = Takes two strings off Stack and compares. Removes strings from Stack
;**** OUT A=0 Equal
;****     A=
.SymBasic_StringCompare
		pop		ix				
		pop		hl				;Get Top Stack String Address
		pop		de				;Get Len
		ld		a,e
		pop		de				;Get Second Stack String Address
		ld		(SymBasic_StringStackTop),de
		pop		bc				;C=Second Len
		ld		b,a				;B=First Len
		cp		c
		jr		z,SymBasic_StringCompare_2
		jr		nc,SymBasic_StringCompare_3
		ld		c,a
;**** Differing Lengths		
.SymBasic_StringCompare_1
		Xor		a
		cp		c
		jr		z,SymBasic_StringCompare_SecondGreater
		dec		c
		ld		a,(de)
		cp		(hl)		
		jr		c,SymBasic_StringCompare_FirstGreater
		jr		nz,SymBasic_StringCompare_SecondGreater
		inc		hl
		inc		de
		jr		SymBasic_StringCompare_1
;**** Differing Lengths		
.SymBasic_StringCompare_3
		Xor		a
		cp		c
		jr		z,SymBasic_StringCompare_FirstGreater
		dec		c
		ld		a,(de)
		cp		(hl)		
		jr		c,SymBasic_StringCompare_FirstGreater
		jr		nz,SymBasic_StringCompare_SecondGreater
		inc		hl
		inc		de
		jr		SymBasic_StringCompare_3
;**** Of same Length
.SymBasic_StringCompare_2
		Xor		a
		cp		c
		jr		z,SymBasic_StringCompare_Equal
		dec		c
		ld		a,(de)
		cp		(hl)		
		jr		c,SymBasic_StringCompare_FirstGreater
		jr		nz,SymBasic_StringCompare_SecondGreater
		inc		hl
		inc		de
		jr		SymBasic_StringCompare_2
SymBasic_StringCompare_FirstGreater
		ld		a,-1
		scf		
		jp		(ix)
SymBasic_StringCompare_SecondGreater
		ld		a,1
		jp		(ix)
SymBasic_StringCompare_Equal
		Xor		a
		jp		(ix)
		
;*********************************************************
;**** EqualStrings = 2 Stack String Compared if Equal ****
;*********************************************************
.SymBasic_EqualsStrings
		pop		iy
		call	SymBasic_StringCompare
		And		a
		jp		z,SymBasic_PositiveResult
		jp		SymBasic_NegativeResult

;*************************************************************
;**** GreaterStrings = 2 Stack String Compared if Greater ****
;*************************************************************
.SymBasic_GreaterStrings
		pop		iy
		call	SymBasic_StringCompare
		cp		1
		jp		z,SymBasic_PositiveResult
		jp		SymBasic_NegativeResult

.SymBasic_NegativeResult
		ld		de,0
		push	de
		push	de
		jp		(iy)		
.SymBasic_PositiveResult
		ld		de,1
		push	de
		ld		e,0
		push	de
		jp		(iy)



;**** Compares 2 32 bit values from stack ****
;**** Input  -> (SP+0)=Value1, (SP+4)=Value2, IY=return address
;**** Output -> A=Result (0 -> Value1=Value2, 1 -> Value1>Value2, -1 -> Value1<Value2), PC=IY
.SymBasic_Compare32
		pop 	de
		pop 	bc      ;BC[h],DE[l] = value1
		pop 	hl      ;HL = value2[l]
		Or 		a
		sbc		hl,de
		ex		de,hl
		pop		hl      ;HL = value2[h]
		sbc		hl,bc   ;HL[h],DE[l] = value2-value1
		ld 		a,l
		Or 		h
		Or 		e
		Or 		d
		jr 		z,SymBasic_Compare32_1
		ld 		a,1
		bit 	7,h
		jr 		nz,SymBasic_Compare32_1
		ld 		a,-1
.SymBasic_Compare32_1
		jp 		(iy)

;****
;**** EQUALS32 = Checks for 2 32 Bit numbers equal each other ****
;****
.SymBasic_Equals32
		pop 	ix
		ld 		iy,SymBasic_Equals32_1
		jp 		SymBasic_Compare32
.SymBasic_Equals32_1
		Or 		a
.SymBasic_Equals32_0
		ld 		hl,0
		ld 		de,0
		jr 		nz,SymBasic_Equals32_2
		inc 	l
.SymBasic_Equals32_2
		push 	de
		push 	hl
		jp 		(ix)

;****
;**** OTHERTHAN32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_OtherThan32
		pop		ix
		ld		iy,Symbasic_OtherThan32_1
		jp		Symbasic_Compare32
.SymBasic_OtherThan32_1
		Or		a
.SymBasic_OtherThan32_0
		ld		hl,0
		ld		de,0
		jr		z,Symbasic_OtherThan32_2
		inc		l
.SymBasic_OtherThan32_2
		push	de
		push	hl
		jp		(ix)

;****
;**** GREATERTHAN32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_GreaterThan32
		pop		ix
		ld		iy,Symbasic_GreaterThan32_1
		jp		Symbasic_Compare32
.SymBasic_GreaterThan32_1
		inc		a
.SymBasic_GreaterThan32_0
		ld		hl,0
		ld		de,0
		jr		nz,Symbasic_GreaterThan32_2
		inc		l
.SymBasic_GreaterThan32_2
		push	de
		push	hl
		jp		(ix)

;****
;**** LESSERTHAN32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_LesserThan32
		pop		ix
		ld		iy,Symbasic_LesserThan32_1
		jp		Symbasic_Compare32
.SymBasic_LesserThan32_1
		dec		a
.SymBasic_LesserThan32_0
		ld		hl,0
		ld		de,0
		jr		nz,Symbasic_LesserThan32_2
		inc		l
.SymBasic_LesserThan32_2
		push	de
		push	hl
		jp		(ix)
	
;****
;**** LESSERTHANEQ32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_LesserThanEQ32
		pop		ix
		ld		iy,Symbasic_LesserThanEQ32_1
		jp		Symbasic_Compare32
.SymBasic_LesserThanEQ32_1
		Or		a
.SymBasic_LesserThanEQ32_0
		ld		hl,0
		ld		de,0
		cp		0
		jr		z,Symbasic_LesserThanEQ32_3
		cp		-1
		jr		z,Symbasic_LesserThanEQ32_2
.SymBasic_LesserThanEQ32_3		
		inc		l
.SymBasic_LesserThanEQ32_2
		push	de
		push	hl
		jp		(ix)

;****
;**** GREATERTHANEQ32 = Checks 2 32bit numbers are other than eachother
;****
.Symbasic_GreaterThanEQ32
		pop		ix
		ld		iy,Symbasic_GreaterThanEQ32_1
		jp		Symbasic_Compare32
.SymBasic_GreaterThanEQ32_1
		Or		a
.SymBasic_GreaterThanEQ32_0
		ld		hl,0
		ld		de,0
		cp		0
		jr		z,Symbasic_GreaterThanEQ32_3
		cp		1
		jr		z,Symbasic_GreaterThanEQ32_2
.SymBasic_GreaterThanEQ32_3		
		inc		l
.SymBasic_GreaterThanEQ32_2
		push	de
		push	hl
		jp		(ix)

;****
;**** IFCMP32 = Checks Result and If True continues else Jumps to end of If (or else)
;****
.SymBasic_IfCmp32
		pop		hl	
		pop		de
		pop		bc		
		;**** Math Stuff
		Xor 	a
		Or		b
		Or		c
		Or		d
		Or		e
		jr		nz,SymBasic_IfCmp32_1
		;**** Okay so Failed
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		push	de
		ret
.SymBasic_IfCmp32_1
		inc		hl
		inc		hl
		push 	hl
		ret

;****
;**** AND32 = Ands 2 32 Bits number together
;****
.SymBasic_And32
		pop		ix					;14
		pop		bc					;10
		pop		de					;10
		pop		hl					;10
		ld		a,b					;4
		And		h					;4
		ld		b,a					;4
		ld		a,c					;4
		And		l					;4
		ld		c,a					;4
		pop		hl					;10
		ld		a,d					;4
		And		h					;4
		ld		d,a					;4
		ld		a,e					;4
		And		l					;4
		ld		e,a					;4
		push	de					;11
		push	bc					;11
		jp		(ix)				;8

;****
;**** OR32 = ORs 2 32 Bits number together
;****
.SymBasic_Or32
		pop		ix					;
		pop		bc					;
		pop		de					;
		pop		hl					;
		ld		a,b					;
		Or		h					;
		ld		b,a					;
		ld		a,c					;
		Or		l					;
		ld		c,a					;
		pop		hl					;
		ld		a,d					;
		Or		h					;
		ld		d,a					;
		ld		a,e					;
		Or		l					;
		ld		e,a					;
		push	de					;
		push	bc					;
		jp		(ix)				;

;****
;**** XOR32 = XORs 2 32 Bits number together
;****
.SymBasic_Xor32
		pop		ix					;
		pop		bc					;
		pop		de					;
		pop		hl					;
		ld		a,b					;
		Xor		h					;
		ld		b,a					;
		ld		a,c					;
		Xor		l					;
		ld		c,a					;
		pop		hl					;
		ld		a,d					;
		Xor		h					;
		ld		d,a					;
		ld		a,e					;
		Xor		l					;
		ld		e,a					;
		push	de					;
		push	bc					;
		jp		(ix)				;		
		

.SymBasic_StringStackTop:	dw	SymBasic_StringArea
.SymBasic_StringArea:		ds	800
.SymBasic_StringWorkSpace:	ds	256

.SymBasic_StringLoc1:	dw	0
.SymBasic_StringLen1:	db 	0
.SymBasic_StringSlt1:	db 	0
.SymBasic_StringLoc2:	dw	0
.SymBasic_StringLen2:	db 	0
.SymBasic_StringSlt2:	db 	0
.SymBasic_AddStrings
		pop		de										;**** Get Return Address and Store
		ld		(SymBasic_Temp_1),de					;**** Store
		pop		hl
		ld		(SymBasic_StringLoc1),hl
		pop		hl
		ld		(SymBasic_StringLen1),hl
		pop		hl
		ld		(SymBasic_StringLoc2),hl				;This is the where to put new line
		pop		hl
		ld		(SymBasic_StringLen2),hl

		ld		a,(SymBasic_StringLen2)					;**** gets the Length of first copied string
		ld		c,a
		ld		a,(SymBasic_StringLen1)
		add		c
		ld		(SymBasic_StringLen2),a					;**** Now becomes total length

		ld		b,0
		ld		de,SymBasic_StringWorkSpace
		ld		hl,(SymBasic_StringLoc2)
		ldir

		ld		a,(SymBasic_StringLen1)
		ld		c,a
		ld		b,0
		ld		hl,(SymBasic_StringLoc1)
		ldir
		
		ld		a,(SymBasic_StringLen2)
		ld		c,a
		ld		b,0
		ld		hl,SymBasic_StringWorkSpace
		ld		de,(SymBasic_StringLoc2)
		push	bc
		push	de
		ldir
		ld		(SymBasic_StringStackTop),de
		ld		hl,(SymBasic_Temp_1)
		jp		(hl)
.SymBasic_Err_100
		di
		jr		SymBasic_Err_100	


;*********************************
;**** Store String from Stack ****
;*********************************
;**** Puts the Text at the Top of the Stack into a Variable
.SymBasic_StoreStringFromStack
		pop		hl							;**** Get From Stack Return Location
		ld		e,(hl)						;**** Get Lower Address of Var to Store
		inc		hl							;**** Increase Pointer
		ld		d,(hl)						;**** Get Higher Place of String to Store
		inc		hl							;**** Increase Pointer
		ld		(SymBasic_Temp_1),hl		;**** Store Return Address
.SymBasic_StoreStringFromStack_2
		di
		ld		(SymBasic_Temp_2),de		;**** This is the Handler Address
		ex		de,hl						;**** Swap
		ld		e,(hl)						;**** Get Low address of string Start
		inc		hl							;**** Increase
		ld		d,(hl)						;**** DE = Address of start of Text
		ld		(SymBasic_Temp_3),de		;**** This is the Start of the Old Text			
		inc		hl							;**** Increase
		ld		c,(hl)
		ld		(SymBasic_Temp_4),bc		;**** This is the Start of the Old Text Len
		pop		de
		ld		(SymBasic_StringStackTop),de
		pop		bc
		ld		a,c
		ld		(SymBasic_StringLen1),a
		ld		c,(hl)
		ld		b,0
		ld		(hl),a
		cp		c		
		jp		z,SymBasic_StoreStrFromStack_10
		jp		c,SymBasic_StoreStrFromStack_11

;**** Store at Top of string Table
.SymBasic_StoreStrFromStack_9
;**** Do copy from Stack area to string area
		ld		hl,SymBasic_TopString		;**** Where we are copying too
		ld		de,(SymBasic_Temp_2)		;**** Get The Table Handler Address
		ldi
		ldi
		ld		a,(SymBasic_StringLen1)
		ld		(de),a
		ld		de,(SymBasic_TopString)		;**** Where we are copying too
		ld		hl,SymBasic_Temp_2			;**** Get The Table Handler Address
		ldi
		ldi
		ld		hl,(SymBasic_StringStackTop)		;**** Where Data Is
		ld		bc,(SymBasic_StringLen1)			;**** Length to copy
		ldir
		ld		a,0
		ld		(de),a
		inc		de
		ld		(SymBasic_TopString),de
;**** Clear Old Space
		ld		hl,(SymBasic_Temp_3)
		ld		a,(SymBasic_Temp_4)
		ld		b,a
		inc		b
		Xor		a
		ld		(hl),a
		inc		hl
.SymBasic_Gringo_20
		ld		(hl),a
		inc		hl
		djnz	SymBasic_Gringo_20
;**** If A Form Text then replace 
		ld		hl,(SymBasic_Temp_2)
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		inc		hl
		cp		(hl)
		jp		nz,SymBasic_Gringo_21
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ex		de,hl
		inc		bc
		inc		bc		
		ld		(hl),c
		inc		hl
		ld		(hl),b
;**** Ends the Copying process
.SymBasic_Gringo_21
		scf											;**** Clears the Flag
		ccf
		ld		hl,(SymBasic_StringStackTop)		;**** Where Data Is
		ld		de,(SymBasic_StringLen1)			;**** Get the Length
		sbc		hl,de								;**** Subtract to remove Stack top
		ld		(SymBasic_StringStackTop),hl		;**** Store old Stack Top
		ld		hl,(SymBasic_Temp_1)				;**** Get Return Address
		ei
		jp		(hl)								;**** Exit
;**** This Just Basically copies new onto old as they are same length
.SymBasic_StoreStrFromStack_10
		And		a									;**** If A = 0
		jr		z,SymBasic_Gringo_21				;**** If it is no change so End
		ld		de,(SymBasic_Temp_3)				;**** Start of Old Text
		inc		de
		inc		de
		ld		hl,(SymBasic_StringStackTop)		;**** Where Data Is
		ld		bc,(SymBasic_StringLen1)			;**** Length to copy
		ldir
		jp		SymBasic_Gringo_21
		
;**** Copy into same area and pad out
.SymBasic_StoreStrFromStack_11
		ld		de,(SymBasic_Temp_3)				;**** Start of Old Text
		inc		de
		inc		de
		And		a									;**** A = 0
		jr		z,SymBasic_Gringo_23
		ld		c,a
		ld		hl,(SymBasic_StringStackTop)		;**** Where Data Is
		ldir
		ld		a,(SymBasic_StringLen1)
		ld		c,a
		ld		a,(SymBasic_Temp_4)
		sub		c
		ld		b,a
		Xor		a
.SymBasic_Gringo_22
		ld		(de),A
		inc		de
		djnz	SymBasic_Gringo_22
		jp		SymBasic_Gringo_21
.SymBasic_Gringo_23
		ld		b,c
		jr		SymBasic_Gringo_22



.SymBasic_Sub32
;************************************
; In: HL/DE: eerste getal (low/high)
;     IX/IY: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
		di
		pop		bc				;**** This is the Return Address
		pop		iy				;**** First Number Get Low
		pop		ix				;**** First Number Get High
		pop		de				;**** Second Number Get Low
		pop		hl				;**** Second Number Get High
		push	bc				;**** Push The Return address
		;**** Math Stuff
		push	ix
		pop		bc
		Xor		a
		sbc		hl,bc
		ex		de,hl
		push	iy
		pop		bc
		sbc		hl,bc
		ex		de,hl
		;**** Finish Math stuff
		pop		bc				;**** Get the Return Address
		push	hl				;**** Push Result High 
		push	de				;**** Push Result Low
		push	bc				;**** Push Return Address onto Stack
		ei
		ret


.SymBasic_Mul32
;*******************************************
; In: IY/IX: eerste getal (low/high)
;     HL/BC: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)

		di
		pop		de				;**** This is the Return Address
		pop		bc				;**** First Number Get Low
		pop		hl				;**** First Number Get High
		pop		ix				;**** Second Number Get Low
		pop		iy				;**** Second Number Get High
		push	de				;**** Push The Return address

		exx
		push	bc
		push	de
		push	hl
		exx

		;**** Math Stuff
				exx
                ld      hl,0
                ld      de,0
                exx
SymBasic_Multi32_lp:
				srl     b
                rr      c
                rr      h
                rr      l
                jp      nc,SymBasic_multi32_2
                exx
                push    iy
                pop     bc
                add     hl,bc
                ex      de,hl
                push    ix
                pop     bc
                adc     hl,bc
                ex      de,hl
                exx
SymBasic_multi32_2:
				ld      a,h
                Or      l
                jp      nz,SymBasic_Multi32_3
                ld      a,b
                Or      c
                jp      z,SymBasic_multi32_5
SymBasic_multi32_3:
				add     iy,iy
                jp      nc,SymBasic_multi32_4
                add     ix,ix
                inc     ix
                jp      SymBasic_multi32_lp
SymBasic_multi32_4:
				add     ix,ix
                jp      SymBasic_multi32_lp
SymBasic_multi32_5:
				exx
		;**** Finish Math stuff
		exx
		pop		hl
		pop		de
		pop		bc
		exx

		pop		bc				;**** Get the Return Address
		push	hl				;**** Push Result High 
		push	de				;**** Push Result Low
		push	bc				;**** Push Return Address onto Stack
		ei
		ret

.SymBasic_Div32
;**************************************
; In: HL/DE: teller (low/high)
;     IX/IY: noemer (low/high)
; Uit: HL/DE: resultaat (low/high)
		di
		pop		bc				;**** This is the Return Address
		pop		iy				;**** First Number Get Low
		pop		ix				;**** First Number Get High
		pop		de				;**** Second Number Get Low
		pop		hl				;**** Second Number Get High
		push	bc				;**** Push The Return address

		exx
		push	bc
		push	de
		push	hl
		exx
		
		;**** Math Stuff
		        push    hl
                push    de
                push    ix
                push    iy
                pop     de
                exx
                pop     de
                pop     bc
                pop     iy
                ld      hl,0
                exx
                ld      hl,0
                ld      b,32
.SymBasic_divide32_1
				exx
                add     iy,iy
                rl      c
                rl      b
                adc     hl,hl
                exx
                adc     hl,hl
                exx
                sbc     hl,de
                exx
                sbc     hl,de
                inc     iy
                jp      nc,SymBasic_divide32_2
                dec     iy
                exx
                add     hl,de
                exx
                adc     hl,de
.SymBasic_divide32_2
				djnz    SymBasic_divide32_1
                exx
                push    bc
                exx
                pop     de
                push    iy
                pop     hl
 		;**** Finish Math stuff
		exx
		pop		hl
		pop		de
		pop		bc
		exx

		pop		bc				;**** Get the Return Address
		push	hl				;**** Push Result High 
		push	de				;**** Push Result Low
		push	bc				;**** Push Return Address onto Stack
		ei
		ret


.SymBasic_SetPalette
		pop		bc				;**** Return Address

		pop		hl
		pop		hl
		ld		a,l
		And		%1111
		ld		d,a				;**** Sets the Blue Element
		
		pop		hl
		pop		hl
		ld		a,l
		add		a
		add		a
		add		a
		add		a
		And		%11110000
		Or		d
		ld		d,a

		pop		hl
		pop		hl
		ld		a,l
		And		%1111
		ld		e,a

		pop		hl
		pop		hl
		ld		a,l
		And		%1111
		ld		l,e
		ld		e,a

		push	bc
        ld 		a,DSK_SRV_COLSET
        jp 		SyDesktop_Service
		ret

;*****************************************
;**** Command RefreshObj [Form],[Obj] ****
;*****************************************
.SymBasic_RefreshObj
		pop		ix
		pop		de
		pop		de
		pop		bc
		pop		bc
		ld		hl,SymStudio_FormIDs
		add		hl,bc
		ld		a,(hl)
		push	ix
		push	iy
		call	SyDesktop_WINDIN
		pop		iy
		pop		ix
		jp		(ix)

;***************************
;**** MouseX Function() ****
;***************************
AFunction MouseX()
		rst 	#20
		dw 		#813c
		pop		ix		;**** Get Return point
		ld		hl,0
		push	de
		push	hl
		jp		(ix)
EndF

;***************************
;**** MouseY Function() ****
;***************************
AFunction MouseY()
		rst 	#20
		dw 		#813c
		pop		bc		;**** Get Return point
		ld		de,0
		push	hl
		push	de
		push	bc		;**** Push back on Stack
EndF

Global SymBasicMouse%

AFunction MouseDown(SymBasicMouse)
	rst		#20
	dw		#813f
	pop		bc
	
	ld		de,0
	ld		l,a
	ld		a,(SymBasicMouse+0)
	And		l
	jr		nz,SymBasic_MouseDown1
	ld		hl,0
	push	hl
	push	de
	push	bc
	ret
.SymBasic_MouseDown1
	ld		hl,1
	push	hl
	push	de
	push	bc
EndF	

AFunction KeyDown(SymBasicMouse)
	pop		hl
	ld		(SymBasic_Temp_1),hl
	ld		de,(SymBasicMouse+0)	
	ld		hl,#8145
	rst		#28
	Xor		a
	cp		e
	jr		nz,SymBasic_KeyDown_1
	ld		hl,0
	push	hl
	push	hl
	ld		hl,(SymBasic_Temp_1)
	jp		(hl)
SymBasic_KeyDown_1	
	push	de
	push	de
	ld		hl,(SymBasic_Temp_1)
	jp		(hl)
EndF

AFunction GetMode()
	call	SyDesktop_MODGET
	pop		hl					;Return Address
	ld		d,0
	push	de
	ld		e,0
	push	de
	push	hl
EndF
Global SymBasicPeek1%
AFunction PeekByte(SymBasicPeek1)
	pop		de					;**** Get Rturn Address
	ld		hl,(SymBasicPeek1)	;**** HL contains Peek Target
	ld		c,(hl)				;**** Get Low byte from Target
	ld		b,0					;**** Null second byte
	push	bc					;**** Store on Stack
	ld		c,0					;**** Clear completly
	push	bc					;**** Store on Stack
	push	de					;**** Push Return Address
EndF							;**** Return
AFunction PeekShort(SymBasicPeek1)
	pop		de					;Return
	ld		hl,(SymBasicPeek1)
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	push	bc
	ld		bc,0
	push	bc
	push	de
EndF
AFunction PeekInt(SymBasicPeek1)
	pop		de
	ld		hl,(SymBasicPeek1)
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	inc		hl
	push	bc
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	push	bc
	push	de
EndF
Global SymBasic_TempString$
AFunction Len(SymBasic_TempString)
	pop		hl
	ld		(Symbasic_Temp_1),hl	
	ld		hl,SymBasic_TempString
	inc		hl
	inc		hl
	ld		c,(hl)
	ld		b,0
	push	bc
	ld		c,0
	push	bc
	ld		hl,(Symbasic_Temp_1)
	jp		(hl)


AFunction Upper$(SymBasic_TempString)
	ld		hl,SymBasic_TempString
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	inc		hl
	ld		b,(hl)
	ld		c,0
	inc		de
	inc		de
Symbasic_Upper_1
	ld		a,(de)
	cp		"a"
	jr		c,SymBasic_Upper_2
	cp		"["
	jr		nc,SymBasic_Upper_2
	sub		a,32
	ld		(de),a
Symbasic_Upper_2
	inc		de
	djnz	SymBasic_Upper_1

;*************
;**** ASC ****
;*************
AFunction Asc(SymBasic_TempString$)
	pop		ix
	ld		hl,SymBasic_TempString
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	inc		hl
	ld		b,(hl)
	inc		de
	inc		de
	ld		a,(de)
	ld		l,a
	ld		h,0
	push	hl
	ld		l,0
	push	hl
	jp		(ix)

;*******************************************
;**** Get the Start of My Common String ****
;*******************************************
.Get_SymBasicTempString
	ld		hl,SymBasic_TempString
	ld		e,(hl)
	inc		hl
	ld		d,(hl)
	inc		hl
	ld		b,(hl)
	inc		de
	inc		de
	ret

;*****************
;**** AppBank ****
;*****************
AFunction AppBank()
	pop		hl
	ld		e,(AppBnkNum)
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)
	
Global SymBasic_FileTemp%
.SymBasic_File_Temp_Storage:	ds 250
.SymBasic_EofData:ds	8

;******************
;**** OpenFile ****
;******************
AFunction OpenFile(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ex		de,hl
	ld		a,(appBnkNum)
	db		#DD,#67
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_FILOPN
	call	c,SymBasic_Drive_Error	
	pop		hl
	ld		e,a
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)

;*******************
;**** CloseFile ****
;*******************
AFunction CloseFile(SymBasic_FileTemp)
	ld		a,(SymBasic_FileTemp)			;**** Get Passed File number
	call	SySystem_CallFunction			;**** Symbos Close File Function
	db		MSC_SYS_SYSFIL					;
	db		FNC_FIL_FILCLO					;
	call	c,SymBasic_Drive_Error			;**** If error reported jump to Error Set
	pop		hl								;**** Pop Return address
	ld		de,0							;**** Put a Null 32bit Result on Stack
	push	de								;****
	push	de								;****
	jp		(hl)							;**** Return to 


;*********************
;**** EOF Setting ****
;*********************
;IN A = What to set EOF TOO    
.SymBasic_Eof_Setting_Code
	jr		z,SymBasic_Eof_Setting_Code1
	ld		a,1
	jr		SymBasic_Eof_Setting_Code2
.SymBasic_Eof_Setting_Code1
	ld		a,0
.SymBasic_Eof_Setting_Code2
	ld		hl,SymBasic_EofData
	ld		e,(SymBasic_FileTemp)
	ld		d,0
	add		hl,de
	ld		(hl),a
	ret

;*************
;**** EOF ****
;*************
AFunction Eof(SymBasic_FileTemp)
	ld		hl,SymBasic_EofData
	ld		e,(SymBasic_FileTemp)
	ld		d,0
	add		hl,de
	ld		e,(hl)
	ld		d,0
	pop		hl
	push	de
	ld		e,0
	push 	de
	jp		(hl)

;*******************
;**** Read Byte ****
;*******************
AFunction ReadByte(SymBasic_FileTemp)
	ld		a,(AppBnkNum)
	ld		e,a
	ld		hl,SymBasic_File_Temp_Storage
	ld		bc,1
	ld		a,(SymBasic_FileTemp)
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_FILINP


	
	call	SymBasic_Eof_Setting_Code
	pop		hl
	ld		a,(SymBasic_File_Temp_Storage)
	ld		e,a
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)
	
;********************
;**** Read Short ****
;********************
AFunction ReadShort(SymBasic_FileTemp)
	ld		a,(AppBnkNum)
	ld		e,a
	ld		hl,SymBasic_File_Temp_Storage
	ld		bc,2
	ld		a,(SymBasic_FileTemp)
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_FILINP
	call	SymBasic_Eof_Setting_Code	
	pop		hl
	ld		de,(SymBasic_File_Temp_Storage)
	push	de
	ld		de,0
	push	de
	jp		(hl)

;******************
;**** Read Int ****
;******************
AFunction ReadInt(SymBasic_FileTemp)
	ld		a,(AppBnkNum)
	ld		e,a
	ld		hl,SymBasic_File_Temp_Storage
	ld		bc,4
	ld		a,(SymBasic_FileTemp)
	call	SySystem_CallFunction
	call	SymBasic_Eof_Setting_Code	
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_FILINP
	pop		hl
	ld		de,(SymBasic_File_Temp_Storage)
	push	de
	ld		de,(Symbasic_File_Temp_Storage+2)
	push	de
	jp		(hl)

;**********************
;**** Drive Status ****
;**********************
AFunction DriveStatus(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ld		a,(de)
	ld		c,0
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_DIRINF
	call	c,SymBasic_Drive_Error
	pop		hl
	ld		e,a
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)

;********************
;**** Drive Type ****
;********************
AFunction DriveType(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ld		a,(de)
	ld		c,0
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_DIRINF
	call	c,SymBasic_Drive_Error
	pop		hl
	ld		e,b
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)

;*********************
;**** DriveSystem ****
;*********************
AFunction DriveSys(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ld		a,(de)
	ld		c,0
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_DIRINF
	call	c,SymBasic_Drive_Error
	pop		hl
	ld		e,c
	ld		d,0
	push	de
	ld		e,0
	push	de
	jp		(hl)

;*******************
;**** DriveFree ****
;*******************
AFunction DriveFree(SymBasic_TempString$)
	call 	Get_symBasicTempString
	ld		a,(de)
	ld		c,1
	call	SySystem_CallFunction
	db		MSC_SYS_SYSFIL
	db		FNC_FIL_DIRINF
	call	c,SymBasic_Drive_Error
	pop		bc
	push	de
	push	hl
	ld		de,512
	ld		hl,0
	push	de
	push	hl
	push	bc
	jp		SymBasic_Mul32
EndF	
	

;********************************
;**** Set The Error Variable ****
;********************************
SymBasic_Drive_Error
	ld		(Error+0),a
	Xor		a
	ld		(Error+1),a
	ret
	
Global SymBasic_Forms%,SymBasic_Forms2%
;*******************
;**** Open Form ****
;*******************
AFunction OpenForm(SymBasic_Forms)
		ld		a,(SymBasic_Forms)
		And		%111
		ld		hl,SymStudio_FormIDs
		ld		e,a
		ld		d,0
		add		hl,de
		Xor		a
		cp		(hl)
		jr		nz,SymBasic_OpenForm_1
		ld		a,e
		call	SymStudio_WindowOpen
.SymBasic_OpenForm_1	
		pop		hl
		ld		bc,0
		push	bc
		push	bc
		jp		(hl)
EndF

;********************
;**** Close Form ****
;********************
AFunction CloseForm(SymBasic_Forms)
		di
		pop		hl
		push	ix
		push	iy
		push	hl
		ld		a,(SymBasic_Forms)
		ld		hl,SymStudio_FormIDs
		ld		e,a
		ld		d,0
		add		hl,de
		ld		a,(hl)
		ld		(hl),d
		call	SyDesktop_WINCLS
		pop		hl
		pop		iy
		pop		ix
		ld		de,0
		push	de
		push	de
		ei
		jp		(hl)
EndF

;***************
;**** Form *****
;***************
.SymBasic_Form:
		pop		ix
		pop		de
		pop		de
		pop		bc
		pop		bc
		ld		hl,SymBasic_Form_7
		ld		a,e
		And		%111
		ld		e,a
		ld		d,0
		add		hl,de
		ld		e,(hl)
		ld		hl,SymStudio_FormIDs
		ld		b,0
		add		hl,bc
		ld		a,(hl)
		cp		0
		jr		z,SymBasic_Form_2
		ld		c,e
		push	ix
        jp 		SyDesktop_SendMessage
.SymBasic_Form_2
		jp		(ix)

;Redraw Menu
;Redraw Title
;Redraw Status
;Set Focus
;Minimise
;Restore
;Maximise
;Slider
SymBasic_Form_7
		db	MSC_DSK_WINMEN,MSC_DSK_WINTIT,MSC_DSK_WINSTA,MSC_DSK_WINTOP
		db  MSC_DSK_WINMIN,MSC_DSK_WINMID,MSC_DSK_WINMAX,MSC_DSK_WINSLD


Global SymBasic_Strs_Number
AFunction Str$(SymBasic_Strs_Number)
		di
		pop		hl
		ld		(Symbasic_Temp_1),hl
		ld		iy,(SymBasic_StringStackTop)
		push	iy
		ld		de,(SymBasic_Strs_Number)
		ld		ix,(SymBasic_Strs_Number+2)		
		
;### CLCN32 -> Converts 32Bit-Integer (unsigned) to ASCII-String (terminated by 0)
;### Eingabe    DE,IX=Value, IY=StringAddress
;### Ausgabe    IY=Addresse of the last char
;### Veraendert AF,BC,DE,HL,IX,IY

 
clcn32  ld (clcn32z),ix
        ld (clcn32z+2),de
        ld ix,clcn32t+36
        ld b,9
        ld c,0
clcn321 ld a,"0"
        Or a
clcn322 ld e,(ix+0):ld d,(ix+1):ld hl,(clcn32z):  sbc hl,de:ld (clcn32z),hl
        ld e,(ix+2):ld d,(ix+3):ld hl,(clcn32z+2):sbc hl,de:ld (clcn32z+2),hl
        jr c,clcn325
        inc c
        inc a
        jr clcn322
clcn325 ld e,(ix+0):ld d,(ix+1):ld hl,(clcn32z):  add hl,de:ld (clcn32z),hl
        ld e,(ix+2):ld d,(ix+3):ld hl,(clcn32z+2):adc hl,de:ld (clcn32z+2),hl
        ld de,-4
        add ix,de
        inc c
        dec c
        jr z,clcn323
        ld (iy+0),a
        inc iy
clcn323 djnz clcn321
        ld a,(clcn32z)
        add "0"
        ld (iy+0),a
        ld (iy+1),0

		inc		iy
		push	iy
		inc		iy
		ld		(SymBasic_StringStackTop),iy
		pop		hl
		pop		de
		sbc		hl,de
		push	hl			;The Length		
		push	de			;The Lower Stack Pointer
		ld		hl,(SymBasic_Temp_1)
		ei
		jp		(hl)
EndF		

clcn32t dw 1,0,     10,0,     100,0,     1000,0,     10000,0
        dw #86a0,1, #4240,#f, #9680,#98, #e100,#5f5, #ca00,#3b9a
clcn32z ds 4
	
;**** Symbasic_StoreShortFromFloat
;**** Symbasic_StoreLongFromFloat
;**** Symbasic_StoreByteFromFloat

;**** SymBasic_StoreByteFromLong
;**** SymBasic_StoreShortFromLong
;**** SymBasic_StoreLongFromLong
;**** Symbasic_FloatTo32
;**** SymBasic_GetShortNumToFloat
;**** SymBasic_GetFloatVar
;**** SymBasic_GetFloatVar


.SymBasic_Convert_Return	dw	0
;********************************
;**** Store Short from Float ****
;********************************
.Symbasic_Store_It_1		dw 0
.Symbasic_Store_It_2		dw 0
.Symbasic_StoreShortFromFloat
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		(Symbasic_Store_It_1),hl
		ld		(Symbasic_Store_It_2),de		
		Call	SymBasic_StackToStoreHL
		ld		hl,Symbasic_FLO_Stack_HL
		call	FLO_ROUND_FLO_TO_LW
		ld		hl,Symbasic_FLO_Stack_HL
		ld		de,(Symbasic_Store_It_2)
		ldi
		ldi
		ld		hl,(Symbasic_Store_It_1)
		jp		(hl)

;********************************
;**** Store Long from Float ****
;********************************
.Symbasic_StoreLongFromFloat
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		(Symbasic_Store_It_1),hl
		ld		(Symbasic_Store_It_2),de
		Call	SymBasic_StackToStoreHL
		ld		hl,Symbasic_FLO_Stack_HL
		call	FLO_ROUND_FLO_TO_LW
		ld		hl,Symbasic_FLO_Stack_HL
		ld		de,(Symbasic_Store_It_2)
		ldi
		ldi
		ldi
		ldi
		ld		hl,(Symbasic_Store_It_1)
		jp		(hl)

;*******************************
;**** Store Byte from Float ****
;*******************************
.Symbasic_StoreByteFromFloat
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		(Symbasic_Store_It_1),hl
		ld		(Symbasic_Store_It_2),de
		Call	SymBasic_StackToStoreHL
		ld		hl,Symbasic_FLO_Stack_HL
		call	FLO_ROUND_FLO_TO_LW
		ld		hl,Symbasic_FLO_Stack_HL
		ld		de,(Symbasic_Store_It_2)
		ldi
		ld		hl,(Symbasic_Store_It_1)
		jp		(hl)		


;******************************
;**** Store Byte From Long ****
;******************************
.SymBasic_StoreByteFromLong
		pop		hl
		pop		de
		pop		bc
		ld		e,(hl)			;**** Make DE point to Location to store
		inc		hl				;
		ld		d,(hl)			;
		inc		hl				;
		push	hl				;**** Puts the Return Address on Stack
		ex		de,hl			;**** Swaps so Return is in HL
		ld		(hl),c			;**** Put Stack Data into Location
		ret						;**** Finish

;*******************************
;**** Store Short from Long ****
;*******************************
.SymBasic_StoreShortFromLong
		pop		hl				;**** Gets the return Location
		pop		de				;**** Gets the High Result
		pop		bc				;**** Gets the Low Result
		ld		e,(hl)			;**** Make DE point to Location to store
		inc		hl				;
		ld		d,(hl)			;
		inc		hl				;
		push	hl				;**** Puts the Return Address on Stack
		ex		de,hl			;**** Swaps so Return is in HL
		ld		(hl),c			;**** Put Stack Data into Location
		inc		hl				;
		ld		(hl),b			;
		ret						;**** Finish

;******************************
;**** Store Long From Long ****
;******************************
.SymBasic_StoreLongFromLong
		pop		hl				;**** Gets the return Location
		pop		de
		pop		bc				;**** Gets the High Result
		push	de
		ld		e,(hl)			;**** Make DE point to Location to store
		inc		hl				;
		ld		d,(hl)			;
		inc		hl				;
		ex		de,hl			;**** Swaps so Return is in HL
		ld		(hl),c			;**** Put Stack Data into Location
		inc		hl				;
		ld		(hl),b			;
		inc		hl
		pop		bc				;**** Gets the Low Result
		ld		(hl),c
		inc		hl
		ld		(hl),b
		push	de
		ret						;**** Finish

;********************************
;**** Store Float From Float ****
;********************************
.Symbasic_StoreFloatFromFloat
		di
.afiie	jr		afiie

;*******************************
;**** Store Float From Long ****
;*******************************
.SymBasic_StoreFloatFromLong
		pop		hl
		ld		e,(hl)			;**** Make DE point to Location to store
		inc		hl				;
		ld		d,(hl)			;
		inc		hl
		ld		(SymBasic_Temp_1),hl
		ld		(SymBasic_Temp_2),de

		pop		bc
		pop		de

		
		
		ld		(Symbasic_FLO_Stack_HL+0),de
		ld		(Symbasic_FLO_Stack_HL+2),bc
		ld		hl,Symbasic_FLO_Stack_HL		
		call	FLO_KONV_LW_TO_FLO

		ld		hl,Symbasic_FLO_Stack_HL
		ld		de,(SymBasic_Temp_2)
		ldi
		ldi
		ldi
		ldi
		ldi

		ld		hl,(SymBasic_Temp_1)
		jp		(hl)


;**************************
;**** Symbos FloatTo32 ****
;**************************
.Symbasic_FloatTo32
		pop		iy
		Call	SymBasic_StackToStoreHL
		ld		hl,Symbasic_FLO_Stack_HL
		push	iy
		call	FLO_ROUND_FLO_TO_LW
		pop		iy
		call	Symbasic_StoreHLToStack		
		jp		(iy)

;************************
;**** Get Float Var *****
;************************
.SymBasic_GetFloatVar
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		ld		bc,4
		add		hl,bc
		ld		b,0
		ld		c,(hl)		
		dec		hl
		push	bc
		ld		b,(hl)
		dec		hl
		ld		c,(hl)
		dec		hl
		push	bc
		ld		b,(hl)
		dec		hl
		ld		c,(hl)
		push	bc
		ex		de,hl
		jp		(hl)


;*****************************
;**** Get Short Num To 32 ****
;*****************************
.SymBasic_GetShortNumTo32_Conv
		pop		hl				;**** Get the Return location from Stack
		ld		e,(hl)			;**** Get First Byte of Integer
		inc		hl				;**** Increase It
		ld		d,(hl)			;**** Get Second Byte of Integer
		inc		hl				;**** Increase It - Now Points to return Location
		push	de				;**** Push Integer to Stack
		ld		de,0
		push	de
		ld		(SymBasic_Convert_Return),hl		
		jp		SymBasic_StackConvertLongToFloat
.SymBasic_GetShortNumTo32
		pop		hl				;**** Get the Return location from Stack
		ld		e,(hl)			;**** Get First Byte of Integer
		inc		hl				;**** Increase It
		ld		d,(hl)			;**** Get Second Byte of Integer
		inc		hl				;**** Increase It - Now Points to return Location
		push	de				;**** Push Integer to Stack
		ld		de,0
		push	de
		jp		(hl)

;*****************************
;**** Get Short Var to 32 ****
;*****************************
.SymBasic_GetShortVarTo32_Conv
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc
		ld		bc,0
		push	bc
		ld		(SymBasic_Convert_Return),de		
		jp		SymBasic_StackConvertLongToFloat
.SymBasic_GetShortVarTo32
		pop		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ex		de,hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		push	bc
		ld		bc,0
		push	bc
		ex		de,hl
		jp		(hl)		

;*************************************
;**** Stack Convert Long to Float ****
;*************************************
.SymBasic_StackConvertLongToFloat
		pop		bc
		pop		de
		ld		(Symbasic_FLO_Stack_HL+0),de
		ld		(Symbasic_FLO_Stack_HL+2),bc
		ld		hl,Symbasic_FLO_Stack_HL		
		call	FLO_KONV_LW_TO_FLO
		ld		de,(Symbasic_FLO_Stack_HL+4)
		push	de
		ld		de,(Symbasic_FLO_Stack_HL+2)
		push	de
		ld		de,(Symbasic_FLO_Stack_HL+0)
		push	de
		ld		hl,(SymBasic_Convert_Return)
		jp		(hl)


;************************
;**** Stack GET GO's ****
;************************
.SymBasic_StackToStoreHL
		pop		ix
		pop		de
		ld		(Symbasic_FLO_Stack_HL+0),de
		pop		de
		ld		(Symbasic_FLO_Stack_HL+2),de
		pop		de
		ld		(Symbasic_FLO_Stack_HL+4),de
		jp		(ix)
.Symbasic_StoreHLToStack
		pop		ix
		ld		de,(Symbasic_FLO_Stack_HL+4)
		push	de
		ld		de,(Symbasic_FLO_Stack_HL+2)
		push	de
		ld		de,(Symbasic_FLO_Stack_HL+0)
		push	de		
		jp		(ix)


;****************
;**** Add 32 ****
;****************
.SymBasic_Add32_Conv
		pop		bc
		ld		(SymBasic_Convert_Return),bc
		call	SymBasic_Add32
		jp		SymBasic_StackConvertLongToFloat
.SymBasic_Add32
		pop		bc				;**** This is the Return Address
		pop		iy				;**** First Number Get Low
		pop		ix				;**** First Number Get High
		pop		de				;**** Second Number Get Low
		pop		hl				;**** Second Number Get High
		push	bc				;**** Push The Return address
		;**** Math Stuff
		push	ix
		pop		bc
		add		hl,bc
		ex		de,hl
		push	iy
		pop		bc
		adc		hl,bc
		ex		de,hl
		;**** Finish Math Stuff
		pop		ix				;**** Get the Return Address
		push	hl				;**** Push Result High 
		push	de				;**** Push Result Low
		jp		(ix)


;**************************************
;**** Area Where Inputs are Stored ****
;**************************************
.Symbasic_SP		dw	0
.Symbasic_FLO_Stack_HL:	
		db	0,0,0,0,0,0
.Symbasic_FLO_Stack_DE:	
		db	0,0,0,0,0,0

;****************
;**** Get PI ****
;****************
.Symbasic_PI
		pop		hl
		ld		de,(Symbasic_FLO_CONST_PI+4)
		push	de
		ld		de,(Symbasic_FLO_CONST_PI+2)
		push	de
		ld		de,(Symbasic_FLO_CONST_PI+0)
		push	de
		jp		(hl)

;**************************
;**** Symbos Add Float ****
;**************************
.Symbasic_AddFLOAT
		ld 		(Symbasic_SP),sp
		ld 		de,(Symbasic_SP)
		inc		de
		inc		de
		ld 		hl,6
		add	 	hl,de
 		push 	hl
		call	FLO_ADD
		pop		hl
		pop		de
		ld		sp,hl
		ex		de,hl
		jp		(hl)                    

;******************************
;**** Symbos Muliply Float ****
;******************************
.Symbasic_MulFLOAT
 		ld		(Symbasic_SP),sp         	;
 		ld		de,(Symbasic_SP)         	;
		inc		de                    	;
		inc		de                    	;
		ld		hl,6                   	;
		add		hl,de                  	;
		push	hl                     	;
		call 	FLO_MULT		        ;
		pop		hl                      ;
		pop		de                      ;
		ld		sp,hl                  	;
		ex		de,hl                  	;
		jp		(hl)                   	;

;**************************
;**** Symbos Div Float ****
;**************************
.Symbasic_DivFLOAT
		ld 		(Symbasic_SP),sp
		ld 		de,(Symbasic_SP)
		inc		de
		inc		de
		ld 		hl,6
		add	 	hl,de
 		push 	hl
		call	FLO_DIV
		pop		hl
		pop		de
		ld		sp,hl
		ex		de,hl
		jp		(hl)

;**************************
;**** Symbos Sub Float ****
;**************************
.Symbasic_SubFLOAT
		ld 		(Symbasic_SP),sp
		ld 		de,(Symbasic_SP)
		inc		de
		inc		de
		ld 		hl,6
		add	 	hl,de
 		push 	hl
		call	FLO_SUB
		pop		hl
		pop		de
		ld		sp,hl
		ex		de,hl
		jp		(hl) 		


;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@         C P C   -   F l o a t i n g - P o i n t - R o u t i n e s          @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


;--- RANDOM NUMBERS -----------------------------------------------------------
;### FLO_RANDOMIZE0 -> RND seek to 0
;### FLO_RANDOMIZE -> RND seek to (HL)
;### FLO_RND -> Gets next RND value
;### FLO_LAST_RND -> Gets current RND value

;--- OPERATIONS ---------------------------------------------------------------
;### FLO_ADD -> Adds (HL) and (DE) and copies the result in (HL)
;### FLO_SUB -> Substracts (DE) from (HL) and copies the result in (HL)
;### FLO_SUBX -> Substracts (HL) from (DE) and copies the result in (HL)
;### FLO_MULT -> Multiplicates (HL) with (DE) and copies the result in (HL)
;### FLO_DIV -> Divides (HL) by (DE) and copies the result in (HL)
;### FLO_POT -> Raises (HL) to the power of (DE) and copies the result in (HL)
;### FLO_VGL -> Compares (HL) with (DE)

;--- FUNCTIONS ----------------------------------------------------------------
;### FLO_VZW -> Changes the sign of (HL)
;### FLO_SQR -> Extracts the root of (HL)
;### FLO_LOG_NAT -> Gets natural logarythm of (HL)
;### FLO_LOG_DEC -> Gets 10-logarythm of (HL)
;### FLO_POT_E -> (HL)=E^(HL)
;### FLO_SIN -> Calculates the sinus of (HL)
;### FLO_COS -> Calculates the cosinus of (HL)
;### FLO_TAN -> Calculates the tangent of (HL)
;### FLO_ARC_TAN -> Calculates the arcus tangent of (HL)
;### FLO_10A -> (HL)=(HL)*10^A
;### FLO_SGN -> Tests the sign of (HL)

;--- MISCELLANEOUS ------------------------------------------------------------
;### FLO_PI -> Gets PI
;### FLO_MOVE -> Copies Value in (DE) to (HL)
;### FLO_DEGRAD -> Set Deg/Rad

;--- CONVERSION ---------------------------------------------------------------
;### FLO_KONV_HLA_TO_FLO -> Converts 16bit Integer + sign to FLO
;### FLO_KONV_LW_TO_FLO -> Converts 32bit Integer + sign to FLO
;### FLO_ROUND_FLO_TO_HLA -> Rounds FLO value and converts it to 16bit Integer + sign
;### FLO_ROUND_FLO_TO_LW -> Rounds FLO value and converts it to 32bit Integer + sign
;### FLO_FIX_FLO_TO_LW -> Cuts FLO value and converts it to 32bit Integer + sign
;### FLO_INT_FLO_TO_LW -> Cuts FLO value (and decrease if negative) and converts it to 32bit Integer + sign
;### FLO_KONV_HLB_TO_INT -> Converts 16bit integer + sign into 16bit Integer

;--- DISPLAY-PREPARATION ------------------------------------------------------
;### FLO_PREPARE -> Prepares the display of a FLO value


;--- begin routines -----------------------------------------------------------



.l2f7d
		ld		de,FLO_CONST_C
		jr		FLO_MOVE
.l2f87
		ex		de,hl
.l2f88
		ld hl,#b10e
		jr FLO_MOVE
.l2f8d
        ld de,#b104
.l2f90
        ex de,hl




;### FLO_MOVE -> Copies Value in (DE) to (HL)
;### Input      (DE)=Source value, (HL)=Destination
;### Output     (HL)=Value, CF=1
;### Unchanged  BC,DE,HL,IX,IY,(DE)
.FLO_MOVE
        push hl
        push de
        push bc
        ex de,hl
        ld bc,#0005
        ldir
        pop bc
        pop de
        pop hl
        scf
        ret


;### FLO_KONV_HLA_TO_FLO -> Converts 16bit Integer + sign to FLO
;### Input      HL=value, A[bit7]=sign, (DE)=destination
;### Output     HL=DE, (HL)=FLO value
;### Unchanged  BC,IX,IY
.FLO_KONV_HLA_TO_FLO
        push de
        push bc
        Or #7f
        ld b,a
        Xor a
        ld (de),a
        inc de
        ld (de),a
        inc de
        ld c,#90
        Or h
        jr nz,l2fbb
        ld c,a
        Or l
        jr z,l2fbf
        ld l,h
        ld c,#88
        jr l2fbb
.l2fb7
        dec c
        sla l
        adc a
.l2fbb
        jp p,l2fb7
        And b
.l2fbf
        ex de,hl
        ld (hl),e
        inc hl
        ld (hl),a
        inc hl
        ld (hl),c
        pop bc
        pop hl
        ret

;### FLO_KONV_LW_TO_FLO -> Converts 32bit Integer + sign to FLO
;### Input      (HL)=LW, A[bit7]=sign
;### Output     (HL)=FLO value
;### Unchanged  BC,DE,HL,IY
.FLO_KONV_LW_TO_FLO
        push bc
        ld bc,#a000
        call l2fd3
        pop bc
        ret
        ld b,#a8
.l2fd3
        push de
        call l379c
        pop de
        ret

;### FLO_ROUND_FLO_TO_HLA -> Rounds FLO value and converts it to 16bit Integer + sign
;### Input      (HL)=FLO value
;### Output     HL=abs((HL)), A[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  BC,DE,IY
.FLO_ROUND_FLO_TO_HLA
        push hl
        pop ix
        Xor a
        sub (ix+#04)
        jr z,l2ffd
        add #90
        ret nc
        push de
        push bc
        add #10
        call l373d
        sla c
        adc hl,de
        jr z,l2ffa
        ld a,(ix+#03)
        Or a
.l2ff6
        ccf
        pop bc
        pop de
        ret
.l2ffa
        sbc a
        jr l2ff6
.l2ffd
        ld l,a
        ld h,a
        scf
        ret

;### FLO_ROUND_FLO_TO_LW -> Rounds FLO value and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_ROUND_FLO_TO_LW
        call FLO_FIX_FLO_TO_LW
        ret nc
        ret p
.l3006
        push hl
        ld a,c
.l3008
        inc (hl)
        jr nz,l3011
        inc hl
        dec a
        jr nz,l3008
        inc (hl)
        inc c
.l3011
        pop hl
        scf
        ret

;### FLO_FIX_FLO_TO_LW -> Cuts FLO value and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_FIX_FLO_TO_LW
        push hl
        push de
        push hl
        pop ix
        Xor a
        sub (ix+#04)
        jr nz,l3029
        ld b,#04
.l3021
        ld (hl),a
        inc hl
        djnz l3021
        ld c,#01
        jr l3051
.l3029
        add #a0
        jr nc,l3052
        push hl
        call l373d
        Xor a
        cp b
        adc a
        Or c
        ld c,l
        ld b,h
        pop hl
        ld (hl),c
        inc hl
        ld (hl),b
        inc hl
        ld (hl),e
        inc hl
        ld e,a
        ld a,(hl)
        ld (hl),d
        And #80
        ld b,a
        ld c,#04
        Xor a
.l3047
        Or (hl)
        jr nz,l304f
        dec hl
        dec c
        jr nz,l3047
        inc c
.l304f
        ld a,e
        Or a
.l3051
        scf
.l3052
        pop de
        pop hl
        ret

;### FLO_INT_FLO_TO_LW -> Cuts FLO value (and decrease if negative) and converts it to 32bit Integer + sign
;### Input      (HL)=FLO value
;### Output     (HL)=abs((HL)), B[bit7]=sign
;###            CF=0 Overflow
;### Unchanged  DE,HL,IY
.FLO_INT_FLO_TO_LW
        call FLO_FIX_FLO_TO_LW
        ret nc
        ret z
        bit 7,b
        ret z
        jr l3006

;### FLO_PREPARE -> Prepares the display of a FLO value
;### Input      (HL)=FLO value
;### Output     (HL)=LW normed mantissa
;###            B = sign of mantissa
;###            D = sign of exponent
;###            E = exponent/comma position
;###            C = number of significant mantissa bytes (NOT digits!)
;### Unchanged  HL
.FLO_PREPARE
        call FLO_SGN
        ld b,a
        jr z,l30b7
        call m,l3734
        push hl
        ld a,(ix+#04)
        sub #80
        ld e,a
        sbc a
        ld d,a
        ld l,e
        ld h,d
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,de
        add hl,hl
        add hl,de
        add hl,hl
        add hl,hl
        add hl,de
        ld a,h
        sub #09
        ld c,a
        pop hl
        push bc
        call nz,l30c8
.l3085
        ld de,FLO_CONST_A
        call l36e2
        jr nc,l3098
        ld de,FLO_CONST_D1
        call FLO_MULT
        pop de
        dec e
        push de
        jr l3085
.l3098
        ld de,FLO_CONST_B
        call l36e2
        jr c,l30ab
        ld de,FLO_CONST_D1
        call FLO_DIV
        pop de
        inc e
        push de
        jr l3098
.l30ab
        call FLO_ROUND_FLO_TO_LW
        ld a,c
        pop de
.l30b0
        ld b,d
        dec a
        add l
        ld l,a
        ret nc
        inc h
        ret
.l30b7
        ld e,a
        ld (hl),a
        ld c,#01
        ret

;### FLO_KONV_HLB_TO_INT -> Converts 16bit integer + sign into 16bit Integer
;### Input      HL=16 bit integer, B[bit7]=sign
;### Output     HL=signed 16 bit integer
;###            CF=0 Overflow
;### Unchanged  BC,DE,IX,IY
.FLO_KONV_HLB_TO_INT
        ld a,h
        Or a
        jp m,ldd42
        Or b
        jp m,ldded
        scf
        ret
.ldd42
        Xor #80
        Or l
        ret nz
        ld a,b
        scf
        adc a
        ret
.ldded
        Xor a
        sub l
        ld l,a
        sbc h
        sub l
        cp h
        ld h,a
        scf
        ret nz
        cp #01
        ret

;### FLO_10A -> (HL)=(HL)*10^A
;### Input      (HL)=value, A=potence
;### Output     (HL)=(HL)*10^A
;###            CF=0 Overflow
;### Unchanged  HL
.FLO_10A
        cpl
        inc a
.l30c8
        Or a
        scf
        ret z
        ld c,a
        jp p,l30d1
        cpl
        inc a
.l30d1
        ld de,FLO_CONST_D2
        sub #0d
        jr z,l30ed
        jr c,l30e3
        push bc
        push af
        call l30ed
        pop af
        pop bc
        jr l30d1
.l30e3
        ld b,a
        add a
        add a
        add b
        add e
        ld e,a
        ld a,#ff
        adc d
        ld d,a
.l30ed
        ld a,c
        Or a
        jp p,FLO_DIV
        jp FLO_MULT

;### FLO_RANDOMIZE0 -> RND seek to 0
;### Unchanged  AF,BC,DE,IX,IY
.FLO_RANDOMIZE0
        ld hl,#8965
        ld (FLO_VALUE_RND+2),hl
        ld hl,#6c07
        ld (FLO_VALUE_RND),hl
        ret

;### FLO_RANDOMIZE -> RND seek to (HL)
;### Input      (HL)=value
;### Unchanged  C,IY,FLO(HL)
.FLO_RANDOMIZE
        ex de,hl
        call FLO_RANDOMIZE0
        ex de,hl
        call FLO_SGN
        ret z
        ld de,FLO_VALUE_RND
        ld b,#04
.l3151
        ld a,(de)
        Xor (hl)
        ld (de),a
        inc de
        inc hl
        djnz l3151
        ret

;### FLO_RND -> Gets next RND value
;### Input      (HL)=Destination
;### Output     (HL)=new RND
;### Unchanged  HL,IY
.FLO_RND
        push hl
        ld hl,(FLO_VALUE_RND+2)
        ld bc,#6c07
        call l319c
        push hl
        ld hl,(FLO_VALUE_RND)
        ld bc,#8965
        call l319c
        push de
        push hl
        ld hl,(FLO_VALUE_RND+2)
        call l319c
        ex (sp),hl
        add hl,bc
        ld (FLO_VALUE_RND),hl
        pop hl
        ld bc,#6c07
        adc hl,bc
        pop bc
        add hl,bc
        pop bc
        add hl,bc
        ld (FLO_VALUE_RND+2),hl
        pop hl

;### FLO_LAST_RND -> Gets current RND value
;### Input      (HL)=Destination
;### Output     (HL)=current RND
;### Unchanged  HL,IY
.FLO_LAST_RND
        push hl
        pop ix
        ld hl,(FLO_VALUE_RND)
        ld de,(FLO_VALUE_RND+2)
        ld bc,#0000
        ld (ix+#04),#80
        jp l37ac
.l319c
        ex de,hl
        ld hl,#0000
        ld a,#11
.l31a2
        dec a
        ret z
        add hl,hl
        rl e
        rl d
        jr nc,l31a2
        add hl,bc
        jr nc,l31a2
        inc de
        jr l31a2

;### FLO_LOG_DEC -> Gets 10-logarythm of (HL)
;### Input      (HL)=value
;### Output     (HL)=LOG10((HL))
;###            CF=0 error, value zero or negative
;### Unchanged  HL
.FLO_LOG_DEC
        ld de,FLO_CONST_LOGDEC
        jr l31b9

;### FLO_LOG_NAT -> Gets natural logarythm of (HL)
;### Input      (HL)=value
;### Output     (HL)=LOG((HL))
;###            CF=0 error, value zero or negative
;### Unchanged  HL
.FLO_LOG_NAT
        ld de,FLO_CONST_LOGNAT
.l31b9
        call FLO_SGN
        dec a
        cp #01
        ret nc
        push de
        call l36d3
        push af
        ld (ix+#04),#80
        ld de,FLO_CONST_LOG
        call FLO_VGL
        jr nc,l31d7
        inc (ix+#04)
        pop af
        dec a
        push af
.l31d7
        call l2f87
        push de
        ld de,FLO_CONST_C
        push de
        call FLO_ADD
        pop de
        ex (sp),hl
        call FLO_SUB
        pop de
        call FLO_DIV
        call l3440
        db #04
        db #4c,#4b,#57,#5e,#7f
        db #0d,#08,#9b,#13,#80
        db #23,#93,#38,#76,#80
        db #20,#3b,#aa,#38,#82

.l3203
        push de
        call FLO_MULT
        pop de
        ex (sp),hl
        ld a,h
        Or a
        jp p,l3210
        cpl
        inc a
.l3210
        ld l,a
        ld a,h
        ld h,#00
        call FLO_KONV_HLA_TO_FLO
        ex de,hl
        pop hl
        call FLO_ADD
        pop de
        jp FLO_MULT

;### FLO_POT_E -> (HL)=E^(HL)
;### Input      (HL)=value
;### Output     (HL)=E^(HL)
;###            CF=0 Overflow
;### Unchanged  HL
.FLO_POT_E
        ld b,#e1
        call l3492
        jp nc,l2f7d
        ld de,FLO_CONST_POTE2
        call FLO_VGL
        jp p,l37e8
        ld de,FLO_CONST_POTE3
        call FLO_VGL
        jp m,l37e2
        ld de,FLO_CONST_POTE1
        call l3469
        ld a,e
        jp p,l3255
        neg
.l3255
        push af
        call l3570
        call l2f8d
        push de
        call l3443
        db #03
        db #f4,#32,#eb,#0f,#73
        db #08,#b8,#d5,#52,#7b
.FLO_CONST_HALF                     ;=1/2
        db #00,#00,#00,#00,#80

.l3270
        ex (sp),hl
        call l3443
        db #02
        db #09,#60,#de,#01,#78
        db #f8,#17,#72,#31,#7e

.l327f
        call FLO_MULT
        pop de
        push hl
        ex de,hl
        call FLO_SUB
        ex de,hl
        pop hl
        call FLO_DIV
        ld de,FLO_CONST_HALF
        call FLO_ADD
        pop af
        scf
        adc (ix+#04)
        ld (ix+#04),a
        scf
        ret

;### FLO_SQR -> Extracts the root of (HL)
;### Input      (HL)=value
;### Output     (HL)=sqr(HL)
;###            CF=0 error, negative value
;### Unchanged  HL
        ld de,FLO_CONST_HALF

;### FLO_POT -> Raises (HL) to the power of (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)^(DE)
;###            CF=0 Error [S=1 invalid parameter -X^(z/n), P=1 Overflow]
;### Unchanged  HL,FLO(DE)
.FLO_POT
        ex de,hl
        call FLO_SGN
        ex de,hl
        jp z,l2f7d
        push af
        call FLO_SGN
        jr z,l32e2
        ld b,a
        call m,l3734
        push hl
        call l3324
        pop hl
        jr c,l32ed
        ex (sp),hl
        pop hl
        jp m,l32ea
        push bc
        push de
        call FLO_LOG_NAT
        pop de
        call c,FLO_MULT
        call c,FLO_POT_E
.l32d9
        pop bc
        ret nc
        ld a,b
        Or a
        call m,FLO_VZW
        scf
        ret
.l32e2
        pop af
        scf
        ret p
        call l37e8
        Xor a
        ret
.l32ea
        Xor a
        inc a
        ret
.l32ed
        ld c,a
        pop af
        push bc
        push af
        ld a,c
        scf
.l32f3
        adc a
        jr nc,l32f3
        ld b,a
        call l2f8d
        ex de,hl
        ld a,b
.l32fc
        add a
        jr z,l3314
        push af
        call l3570
        jr nc,l331b
        pop af
        jr nc,l32fc
        push af
        ld de,#b104
        call FLO_MULT
        jr nc,l331b
        pop af
        jr l32fc
.l3314
        pop af
        scf
        call m,l35fb
        jr l32d9
.l331b
        pop af
        pop af
        pop bc
        jp m,l37e2
        jp l37ea
.l3324
        push bc
        call l2f88
        call FLO_FIX_FLO_TO_LW
        ld a,c
        pop bc
        jr nc,l3331
        jr z,l3334
.l3331
        ld a,b
        Or a
        ret
.l3334
        ld c,a
        ld a,(hl)
        rra
        sbc a
        And b
        ld b,a
        ld a,c
        cp #02
        sbc a
        ret nc
        ld a,(hl)
        cp #27
        ret c
        Xor a
        ret

;### FLO_DEGRAD -> Set Deg/Rad
;### Input      A=Typ (=0 -> Rad, >0 -> Deg)
;### Unchanged  AF,BC,DE,HL,IX,IY
.FLO_DEGRAD    
        ld (FLO_VALUE_DEGRAD),a
        ret

;### FLO_COS -> Calculates the cosinus of (HL)
;### Input      (HL)=value
;### Output     (HL)=cos(HL)
;###            CF=0 value too big
;### Unchanged  HL
.FLO_COS
        call FLO_SGN
        call m,l3734
        Or #01
        jr l3354

;### FLO_SIN -> Calculates the sinus of (HL)
;### Input      (HL)=value
;### Output     (HL)=sin(HL)
;###            CF=0 value too big
;### Unchanged  HL
.FLO_SIN
        Xor a
.l3354
        push af
        ld de,FLO_CONST_SINA
        ld b,#f0
        ld a,(FLO_VALUE_DEGRAD)
        Or a
        jr z,l3365
        ld de,FLO_CONST_SINB
        ld b,#f6
.l3365
        call l3492
        jr nc,l33a4
        pop af
        call l346a
        ret nc
        ld a,e
        rra
        call c,l3734
        ld b,#e8
        call l3492
        jp nc,l37e2
        inc (ix+#04)
        call l3440
        db #06
        db #1b,#2d,#1a,#e6,#6e
        db #f8,#fb,#07,#28,#74
        db #01,#89,#68,#99,#79
        db #e1,#df,#35,#23,#7d
        db #28,#e7,#5d,#a5,#80
.FLO_CONST_F
        db #a2,#da,#0f,#49,#81

.l33a1
        jp FLO_MULT
.l33a4
        pop af
        jp nz,l2f7d
        ld a,(FLO_VALUE_DEGRAD)
        cp #01
        ret c
        ld de,FLO_CONST_SINC
        jp FLO_MULT

;### FLO_TAN -> Calculates the tangent of (HL)
;### Input      (HL)=value
;### Output     (HL)=tan(HL)
;###            CF=0 error [Z=1 division by zero, S=1 value too big]
;### Unchanged  HL
.FLO_TAN
        call l2f8d
        push de
        call FLO_COS
        ex (sp),hl
        call c,FLO_SIN
        pop de
        jp c,FLO_DIV
        ret

;### FLO_ARC_TAN -> Calculates the arcus tangent of (HL)
;### Input      (HL)=value
;### Output     (HL)=atn(HL)
;### Unchanged  HL
.FLO_ARC_TAN
        call FLO_SGN
        push af
        call m,l3734
        ld b,#f0
        call l3492
        jr nc,l3430
        dec a
        push af
        call p,l35fb
        call l3440
        db #0b
        db #ff,#c1,#03,#0f,#77
        db #83,#fc,#e8,#eb,#79
        db #6f,#ca,#78,#36,#7b
        db #d5,#3e,#b0,#b5,#7c
        db #b0,#c1,#8b,#09,#7d
        db #af,#e8,#32,#b4,#7d
        db #74,#6c,#65,#62,#7d
        db #d1,#f5,#37,#92,#7e
        db #7a,#c3,#cb,#4c,#7e
        db #83,#a7,#aa,#aa,#7f
        db #fe,#ff,#ff,#7f,#80

.l3426
        call FLO_MULT
        pop af
        ld de,FLO_CONST_F
        call p,FLO_SUBX
.l3430
        ld a,(FLO_VALUE_DEGRAD)
        Or a
        ld de,FLO_CONST_TAN
        call nz,FLO_MULT
        pop af
        call m,l3734
        scf
        ret
.l3440
        call l3570
.l3443
        call l2f87
        pop hl
        ld b,(hl)
        inc hl
        call l2f90
.l344c
        inc de
        inc de
        inc de
        inc de
        inc de
        push de
        ld de,#b109
        dec b
        ret z
        push bc
        ld de,#b10e
        call FLO_MULT
        pop bc
        pop de
        push de
        push bc
        call FLO_ADD
        pop bc
        pop de
        jr l344c
.l3469
        Xor a
.l346a
        push af
        call FLO_MULT
        pop af
        ld de,FLO_CONST_HALF
        call nz,FLO_ADD
        push hl
        call FLO_ROUND_FLO_TO_HLA
        jr nc,l348e
        pop de
        push hl
        push af
        push de
        ld de,#b109
        call FLO_KONV_HLA_TO_FLO
        ex de,hl
        pop hl
        call FLO_SUB
        pop af
        pop de
        scf
        ret
.l348e
        pop hl
        Xor a
        inc a
        ret
.l3492
        call l36d3
        ret p
        cp b
        ret z
        ccf
        ret

;### FLO_SUB -> Substracts (DE) from (HL) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)-(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_SUB
        ld a,#01
        jr l34a3

;### FLO_SUBX -> Substracts (HL) from (DE) and copies the result in (HL)
;### Input      (DE)=first value, (HL)=second value
;### Output     (HL)=(DE)-(HL)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_SUBX
        ld a,#80
        jr l34a3

;### FLO_ADD -> Adds (HL) and (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)+(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_ADD
        Xor a
.l34a3
        push hl
        pop ix
        push de
        pop iy
        ld b,(ix+#03)
        ld c,(iy+#03)
        Or a
        jr z,l34bc
        jp m,l34ba
        rrca
        Xor c
        ld c,a
        jr l34bc
.l34ba
        Xor b
        ld b,a
.l34bc
        ld a,(ix+#04)
        cp (iy+#04)
        jr nc,l34d8
        ld d,b
        ld b,c
        ld c,d
        Or a
        ld d,a
        ld a,(iy+#04)
        ld (ix+#04),a
        jr z,l3525
        sub d
        cp #21
        jr nc,l3525
        jr l34e9
.l34d8
        Xor a
        sub (iy+#04)
        jr z,l3537
        add (ix+#04)
        cp #21
        jr nc,l3537
        push hl
        pop iy
        ex de,hl
.l34e9
        ld e,a
        ld a,b
        Xor c
        push af
        push bc
        ld a,e
        call l3743
        ld a,c
        pop bc
        ld c,a
        pop af
        jp m,l353c
        ld a,(iy+#00)
        add l
        ld l,a
        ld a,(iy+#01)
        adc h
        ld h,a
        ld a,(iy+#02)
        adc e
        ld e,a
        ld a,(iy+#03)
        set 7,a
        adc d
        ld d,a
        jp nc,l37b7
        rr d
        rr e
        rr h
        rr l
        rr c
        inc (ix+#04)
        jp nz,l37b7
        jp l37ea
.l3525
        ld a,(iy+#02)
        ld (ix+#02),a
        ld a,(iy+#01)
        ld (ix+#01),a
        ld a,(iy+#00)
        ld (ix+#00),a
.l3537
        ld (ix+#03),b
        scf
        ret
.l353c
        Xor a
        sub c
        ld c,a
        ld a,(iy+#00)
        sbc l
        ld l,a
        ld a,(iy+#01)
        sbc h
        ld h,a
        ld a,(iy+#02)
        sbc e
        ld e,a
        ld a,(iy+#03)
        set 7,a
        sbc d
        ld d,a
        jr nc,l356d
        ld a,b
        cpl
        ld b,a
        Xor a
        sub c
        ld c,a
        ld a,#00
        sbc l
        ld l,a
        ld a,#00
        sbc h
        ld h,a
        ld a,#00
        sbc e
        ld e,a
        ld a,#00
        sbc d
        ld d,a
.l356d
        jp l37ac
.l3570
        ld de,#b109
        call l2f90
        ex de,hl

;### FLO_MULT -> Multiplicates (HL) with (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)*(DE)
;###            CF=0 Overflow
;### Unchanged  HL,FLO(DE)
.FLO_MULT
        push de
        pop iy
        push hl
        pop ix
        ld a,(iy+#04)
        Or a
        jr z,l35ad
        dec a
        call l36af
        jr z,l35ad
        jr nc,l35aa
        push af
        push bc
        call l35b0
        ld a,c
        pop bc
        ld c,a
        pop af
        bit 7,d
        jr nz,l35a3
        dec a
        jr z,l35ad
        sla c
        adc hl,hl
        rl e
        rl d
.l35a3
        ld (ix+#04),a
        Or a
        jp nz,l37b7
.l35aa
        jp l37ea
.l35ad
        jp l37e2
.l35b0
        ld hl,#0000
        ld e,l
        ld d,h
        ld a,(iy+#00)
        call l35f3
        ld a,(iy+#01)
        call l35f3
        ld a,(iy+#02)
        call l35f3
        ld a,(iy+#03)
        Or #80
.l35cc
        ld b,#08
        rra
        ld c,a
.l35d0
        jr nc,l35e6
        ld a,l
        add (ix+#00)
        ld l,a
        ld a,h
        adc (ix+#01)
        ld h,a
        ld a,e
        adc (ix+#02)
        ld e,a
        ld a,d
        adc (ix+#03)
        ld d,a
.l35e6
        rr d
        rr e
        rr h
        rr l
        rr c
        djnz l35d0
        ret
.l35f3
        Or a
        jr nz,l35cc
        ld l,h
        ld h,e
        ld e,d
        ld d,a
        ret
.l35fb
        call l2f87
        ex de,hl
        push de
        call l2f7d
        pop de

;### FLO_DIV -> Divides (HL) by (DE) and copies the result in (HL)
;### Input      (HL)=first value, (DE)=second value
;### Output     (HL)=(HL)/(DE)
;###            CF=0 Overflow (and ZF=1 -> division by zero)
;### Unchanged  HL,FLO(DE)
.FLO_DIV
        push de
        pop iy
        push hl
        pop ix
        Xor a
        sub (iy+#04)
        jr z,l366a
        call l36af
        jp z,l37e2
        jr nc,l3667
        push bc
        ld c,a
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ex de,hl
        ld b,(iy+#03)
        set 7,b
        call l369d
        jr c,l3633
        ld a,c
        Or a
        jr nz,l3639
        jr l3666
.l3633
        dec c
        add hl,hl
        rl e
        rl d
.l3639
        ld (ix+#04),c
        call l3672
        ld (ix+#03),c
        call l3672
        ld (ix+#02),c
        call l3672
        ld (ix+#01),c
        call l3672
        ccf
        call c,l369d
        ccf
        sbc a
        ld l,c
        ld h,(ix+#01)
        ld e,(ix+#02)
        ld d,(ix+#03)
        pop bc
        ld c,a
        jp l37b7
.l3666
        pop bc
.l3667
        jp l37ea
.l366a
        ld b,(ix+#03)
        call l37ea
        Xor a
        ret
.l3672
        ld c,#01
.l3674
        jr c,l367e
        ld a,d
        cp b
.l3678
        call z,l36a0
        ccf
        jr nc,l3691
.l367e
        ld a,l
        sub (iy+#00)
        ld l,a
        ld a,h
        sbc (iy+#01)
        ld h,a
        ld a,e
        sbc (iy+#02)
        ld e,a
        ld a,d
        sbc b
        ld d,a
        scf
.l3691
        rl c
        sbc a
        add hl,hl
        rl e
        rl d
        inc a
        jr nz,l3674
        ret
.l369d
        ld a,d
        cp b
        ret nz
.l36a0
        ld a,e
        cp (iy+#02)
        ret nz
        ld a,h
        cp (iy+#01)
        ret nz
        ld a,l
        cp (iy+#00)
        ret
.l36af
        ld c,a
        ld a,(ix+#03)
        Xor (iy+#03)
        ld b,a
        ld a,(ix+#04)
        Or a
        ret z
        add c
        ld c,a
        rra
        Xor c
        ld a,c
        jp p,l36cf
        set 7,(ix+#03)
        sub #7f
        scf
        ret nz
        cp #01
        ret
.l36cf
        Or a
        ret m
        Xor a
        ret
.l36d3
        push hl
        pop ix
        ld a,(ix+#04)
        Or a
        ret z
        sub #80
        scf
        ret

;### FLO_VGL -> Compares (HL) with (DE)
;### Input      (HL)=first value, (DE)=second value
;### Output     A=Result [-1 -> (HL)<(DE), 0 -> (HL)=(DE), 1 -> (HL)>(DE)]
;###            ZF=1 -> (HL)=(DE), CF=1 -> (HL)<(DE)
;### Unchanged  BC,DE,HL,FLO(HL),FLO(DE)
.FLO_VGL
        push hl
        pop ix
.l36e2
        push de
        pop iy
        ld a,(ix+#04)
        cp (iy+#04)
        jr c,l3719
        jr nz,l3722
        Or a
        ret z
        ld a,(ix+#03)
        Xor (iy+#03)
        jp m,l3722
        ld a,(ix+#03)
        sub (iy+#03)
        jr nz,l3719
        ld a,(ix+#02)
        sub (iy+#02)
        jr nz,l3719
        ld a,(ix+#01)
        sub (iy+#01)
        jr nz,l3719
        ld a,(ix+#00)
        sub (iy+#00)
        ret z
.l3719
        sbc a
        Xor (iy+#03)
.l371d
        add a
        sbc a
        ret c
        inc a
        ret
.l3722
        ld a,(ix+#03)
        jr l371d

;### FLO_SGN -> Tests the sign of (HL)
;### Input      (HL)=value
;### Output     A=sign [-1 -> (HL)<0, 0 -> (HL)=0, 1 -> (HL)>0]
;###            ZF=1 -> (HL)=0, CF=1 -> (HL)<0
;### Unchanged  BC,DE,HL,IY,FLO(HL)
.FLO_SGN
        push hl
        pop ix
        ld a,(ix+#04)
        Or a
        ret z
        jr l3722

;### FLO_VZW -> Changes the sign of (HL)
;### Input      (HL)=value
;### Output     (HL)=-(HL)
;### Unchanged  BC,DE,HL,IY
.FLO_VZW
        push hl
        pop ix
.l3734
        ld a,(ix+#03)
        Xor #80
        ld (ix+#03),a
        ret
.l373d
        cp #21
        jr c,l3743
        ld a,#21
.l3743
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld c,(hl)
        inc hl
        ld h,(hl)
        ld l,c
        ex de,hl
        set 7,d
        ld bc,#0000
        jr l375e
.l3753
        ld c,a
        ld a,b
        Or l
        ld b,a
        ld a,c
        ld c,l
        ld l,h
        ld h,e
        ld e,d
        ld d,#00
.l375e
        sub #08
        jr nc,l3753
        add #08
        ret z
.l3765
        srl d
        rr e
        rr h
        rr l
        rr c
        dec a
        jr nz,l3765
        ret
.l3773
        jr nz,l378c
        ld d,a
        ld a,e
        Or h
        Or l
        Or c
        ret z
        ld a,d
.l377c
        sub #08
        jr c,l379a
        ret z
        ld d,e
        ld e,h
        ld h,l
        ld l,c
        ld c,#00
        inc d
        dec d
        jr z,l377c
        ret m
.l378c
        dec a
        ret z
        sla c
        adc hl,hl
        rl e
        rl d
        jp p,l378c
        ret
.l379a
        Xor a
        ret
.l379c
        push hl
        pop ix
        ld (ix+#04),b
        ld b,a
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ex de,hl
.l37ac
        ld a,(ix+#04)
        dec d
        inc d
        call p,l3773
        ld (ix+#04),a
.l37b7
        sla c
        jr nc,l37cd
        inc l
        jr nz,l37cd
        inc h
        jr nz,l37cd
        inc de
        ld a,d
        Or e
        jr nz,l37cd
        inc (ix+#04)
        jr z,l37ea
        ld d,#80
.l37cd
        ld a,b
        Or #7f
        And d
        ld (ix+#03),a
        ld (ix+#02),e
        ld (ix+#01),h
        ld (ix+#00),l
.l37dd
        push ix
        pop hl
        scf
        ret
.l37e2
        Xor a
        ld (ix+#04),a
        jr l37dd
.l37e8
        ld b,#00
.l37ea
        push ix
        pop hl
        ld a,b
        Or #7f
        ld (ix+#03),a
        Or #ff
        ld (ix+#04),a
        ld (hl),a
        ld (ix+#01),a
        ld (ix+#02),a
        ret

;--- begin variables ----------------------------------------------------------

FLO_VALUE_DEGRAD    db 0
FLO_VALUE_RND       ds 4

;--- begin constants ----------------------------------------------------------

.Symbasic_FLO_CONST_PI		                    ;=PI
        db #a2,#da,#0f,#49,#82,0				;**** Padded out with a Zero

.FLO_CONST_LOG
        db #34,#f3,#04,#35,#80
.FLO_CONST_LOGNAT
        db #f8,#17,#72,#31,#80
.FLO_CONST_LOGDEC
        db #85,#9a,#20,#1a,#7f

.FLO_CONST_POTE1
        db #29,#3b,#aa,#38,#81
.FLO_CONST_POTE2
        db #c7,#33,#0f,#30,#87
.FLO_CONST_POTE3
        db #f8,#17,#72,#b1,#87

.FLO_CONST_SINA
        db #6e,#83,#f9,#22,#7f
.FLO_CONST_SINB
        db #b6,#60,#0b,#36,#79
.FLO_CONST_SINC
        db #13,#35,#fa,#0e,#7b
.FLO_CONST_TAN
        db #d3,#e0,#2e,#65,#86

.FLO_CONST_A
        db #f0,#1f,#bc,#3e,#96
.FLO_CONST_B
        db #fe,#27,#6b,#6e,#9e
.FLO_CONST_C
        db #00,#00,#00,#00,#81

.FLO_CONST_D1
        db #00,#00,#00,#20,#84
        db #00,#00,#00,#48,#87
        db #00,#00,#00,#7a,#8a
        db #00,#00,#40,#1c,#8e
        db #00,#00,#50,#43,#91
        db #00,#00,#24,#74,#94
        db #00,#80,#96,#18,#98
        db #00,#20,#bc,#3e,#9b
        db #00,#28,#6b,#6e,#9e
        db #00,#f9,#02,#15,#a2
        db #40,#b7,#43,#3a,#a5
        db #10,#a5,#d4,#68,#a8
.FLO_CONST_D2
        db #2a,#e7,#84,#11,#ac
			




;**********************
;**** Data Section ****
;**********************
CODE Z80
.AppDatBeg
;**** Define User Variables ****
.Error:   dw 0
.SymBasicMouse:   dw 0
.SymBasicPeek1:   dw 0
.SymBasic_FileTemp:   dw 0
.SymBasic_Forms:   dw 0
.SymBasic_Forms2:   dw 0
.SymBasic_Strs_Number:   dw 0,0
SymBasic_TempString:            dw   SymBasic_UserStringBase+0:db 0
Form1_Text:                     dw   SymBasic_UserStringBase+3:db 6
                                db   0:dw   Form1_TextAddr
Form1_StatusText:               dw   SymBasic_UserStringBase+12:db 0
                                db   0:dw   Form1_StatusTextAddr
.SymBasic_TopString:            dw SymBasic_TopStringData
.SymBasic_UserStringBase:
                                dw SymBasic_TempString:db 0
Form1_Text_Form:                dw Form1_Text:db "Form 1",0
Form1_StatusText_Form:          dw Form1_StatusText:db "",0
.SymBasic_TopStringData:	ds 2033,4
.SymBasic_UserStringTop
.AppFormLists




    dw Form1_ControlWindowData
;**** Form Icon ***
.Form1_Icon:
        db 2,8,8
    db 0,0,0,0,0,0,0,0
.SyStud_TimerRoutines    dw 0

;**************************
;**** Transfer Section ****
;**************************
.AppTrnBeg
          ds    128
.AppStk   ds    6*2
          dw    AppPrz
.AppPrzN  db    0
.AppMsgB  ds    14

;******************************
;**** SymStudio Timer Stack ***
;******************************
           ds 128              ;Stack buffer
.SyStudio_TimerStack
           dw 0                    ;IY
           dw 0                    ;IX
           dw 0                    ;HL
           dw 0                    ;DE
           dw 0                    ;BC
           dw 0                    ;AF
           dw Sys_Timer_Code       ;Start of Timer Routine
           db 0
.App_Form_List
     dw  Form1_Begin
;***
;**** Z80 version of Form Form1 ***
;***
.Form1
.Form1_Addr:                    db 0,0
.Form1_Begin:                   
.Form1_Status:                  db 1
.Form1_Display:                 db 84
.Form1_SizeAdjust:              db 0
.Form1_OwnerID:                 db 0
.Form1_Left:                    dw 16
.Form1_Top:                     dw 36
.Form1_Width:                   dw 200
.Form1_Height:                  dw 121
.Form1_OffsetWidth:             dw 1
.Form1_OffsetHeight:            dw 8
.Form1_ContentWidth:            dw 191
.Form1_ContentHeight:           dw 120
.Form1_MinWidth:                dw 0
.Form1_MinHeight:               dw 0
.Form1_MaxWidth:                dw 320
.Form1_MaxHeight:               dw 192
.Form1_IconAddr:                dw Form1_Icon
.Form1_TextAddr:                dw Form1_Text_Form+2
.Form1_StatusTextAddr:          dw Form1_StatusText_Form+2
.Form1_MenuAddr:                dw Form1_Menu
.Form1_ControlWindowAddr:       dw Form1_ControlWindow
.Form1_ControlToolAddr:         dw 0 ;Form1_ControlTool
.Form1_ToolBarHeight:           dw 8
     ds 136+14
.Form1_Menu:                    
        dw  0
;****
;**** Data Control Record (ControlWindow) ****
;****
.Form1_ControlWindow:           
.Form1_ControlWindowCount:      db 1
.Form1_ControlWindowOwnerID:    db 0
.Form1_ControlWindowDataAddr:   dw Form1_ControlWindowData
.Form1_ControlWindowCalcAddr:   dw 0; Form1_ControlWindowCalc
     db 0,0,0,0,0,0,0,0
.Form1_ControlWindowFocus:      db 0
     db 0
;****
.Form1_ControlWindowData:       
;**** OBject Window Background Data Record ****
dw 0,255*256+0,          2,  0,0,1000,1000,0
;*******************************
;***** Symbos Code Library *****
;*******************************

Library SyStr_LenMax
;*********************************************
;**** Get the Maximum Length of a System String
;**** IN - HL = Start of Text
		dec		hl
		ld		a,(hl)
		inc		hl
		ret
;*********************************************
EndLib

Library SyStr_Len
;*********************************************
;**** Get the Length of a System String
;**** IN - HL = Address Start of Text
;**** OUT - HL = Address End of Text
;****       B = Length
		ld		b,0
.SyStr_Len2
		ld		a,(hl)
		And		a
		ret		z
		inc		hl
		inc		b
		jr		SyStr_Len2	
;*********************************************
EndLib

Library SyStr_Copy
;*********************************************
;**** Copy a String to Another String (without exceeeding Destingation string size)
;**** IN - DE = Addr of Source String
;****      HL = Addr of Destination String
		dec		hl
		ld		a,(hl)
		And		a
		jr		z,SyStr_Copy_2
		ld		b,a
		inc		hl
.SyStr_Copy_1
		ld		a,(de)
		ld		(hl),a
		inc		hl
		inc		de
		And		a
		jr		z,SyStr_Copy_2
		djnz	SyStr_Copy
.SyStr_Copy_2
		ret
;*********************************************
EndLib

Library SyMath_RND16
;*********************************************
;**** Random number generator 16 bit
;**** IN - Nowt
;**** OUT - HL = Random
;**** Corrupts A,DE,F 
		ld		de,(SyMath_RndSeed)		; Seed is usually 0
		ld		a,d
		ld		h,e
		ld		l,253
		Or		a
		sbc		hl,de
		sbc		a,0
		sbc		hl,de
		ld		d,0
		sbc		a,d
		ld		e,a
		sbc		hl,de
		jr		nc,SyMath_Rand
		inc		hl
.SyMath_Rand
		ld		(SyMath_RndSeed),hl
		ret
EndL		
;*******************************************
Library SyMath_RndSeed
;*******************************************
;**** Just the Seeding Word 
		dw	0	
;*******************************************
EndL

;Library SyVar_Num2Str
;*******************************************
;### CLCNUM -> Converts 16Bit-number into an ASCII-string (terminated by 0)
;### Input      IX=Value, E=maximum number of digits
;### Output     IY=points to last char of the string (before 0)
;### Changed    AF,BC,DE,HL,IX,IY
;.SyVar_clcnumt
;		dw 1,10,100,1000,10000
;.SyVar_Num2Str
;		ld d,0
;       ld b,e
;      dec e
;        push ix
;        pop hl
;        ld ix,clcnumt
;        add ix,de
;        add ix,de               ;IX=erster Teiler
;        dec b
;        jr z,clcnum4
;        ld c,0
;clcnum1 ld e,(ix)
;        ld d,(ix+1)
;        dec ix
;        dec ix
;        ld a,"0"
;        Or a
;clcnum2 sbc hl,de
;        jr c,clcnum5
;        inc c
;        inc a
;        jr clcnum2
;clcnum5 add hl,de
;        inc c
;        dec c
;        jr z,clcnum3
;        ld (iy+0),a
;        inc iy
;clcnum3 djnz clcnum1
;clcnum4 ld a,"0"
;        add l
;        ld (iy+0),a
;        ld (iy+1),0
;        ret
;EndLib

Library SyMath_Mult32
;*******************************************
; In: IY/IX: eerste getal (low/high)
;     HL/BC: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
				exx
                ld      hl,0
                ld      de,0
                exx
SyMath_Multi32_lp:
				srl     b
                rr      c
                rr      h
                rr      l
                jp      nc,SyMath_multi32_2
                exx
                push    iy
                pop     bc
                add     hl,bc
                ex      de,hl
                push    ix
                pop     bc
                adc     hl,bc
                ex      de,hl
                exx
SyMath_multi32_2:
				ld      a,h
                Or      l
                jp      nz,SyMath_Multi32_3
                ld      a,b
                Or      c
                jp      z,SyMath_multi32_5
SyMath_multi32_3:
				add     iy,iy
                jp      nc,SyMath_multi32_4
                add     ix,ix
                inc     ix
                jp      SyMath_multi32_lp
SyMath_multi32_4:
				add     ix,ix
                jp      SyMath_multi32_lp
SyMath_multi32_5:
				exx
                ret
;**************************************
EndLib

Library SyMath_Div32
;**************************************
; In: HL/DE: teller (low/high)
;     IX/IY: noemer (low/high)
; Uit: HL/DE: resultaat (low/high)
		        push    hl
                push    de
                push    ix
                push    iy
                pop     de
                exx
                pop     de
                pop     bc
                pop     iy
                ld      hl,0
                exx
                ld      hl,0
                ld      b,32
.SyMath_divide32_1
				exx
                add     iy,iy
                rl      c
                rl      b
                adc     hl,hl
                exx
                adc     hl,hl
                exx
                sbc     hl,de
                exx
                sbc     hl,de
                inc     iy
                jp      nc,SyMath_divide32_2
                dec     iy
                exx
                add     hl,de
                exx
                adc     hl,de
.SyMath_divide32_2
				djnz    SyMath_divide32_1
                exx
                push    bc
                exx
                pop     de
                push    iy
                pop     hl
                ret
;*************************************
EndLib

Library SyMath_Add32
;*************************************
; In: HL/DE: eerste getal (low/high)
;     IX/IY: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
				push    ix
                pop     bc
                add     hl,bc
                ex      de,hl
                push    iy
                pop     bc
                adc     hl,bc
                ex      de,hl
                ret
;************************************
EndLib

Library SyMath_Sub32
;************************************
; In: HL/DE: eerste getal (low/high)
;     IX/IY: tweede getal (low/high)
; Uit: HL/DE: resultaat (low/high)
				push    ix
                pop     bc
                Xor     a
                sbc     hl,bc
                ex      de,hl
                push    iy
                pop     bc
                sbc     hl,bc
                ex      de,hl
                ret
;************************************
EndLib
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@              S Y M S T U D I O   S Y S T E M   L I B R A R Y               @
;@                     - SYMBOS MICRO KERNEL FUNCTIONS -                      @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;Author: Prodatron / Symbiosis
;Date:   28.10.2005

;The kernel is the heart of SymbOS and controls the core resources of the
;system.
;This library supports you in using the kernel functions regarding processes
;and timers.
;The existance of "AppPrzN" (a byte, where the ID of the applications process
;is stored) and "AppMsgB" (the message buffer, 14 bytes, which are placed in
;the transfer ram area) is required.


Library SyKernel_MTADDP
;******************************************************************************
;*** Name           Multitasking_Add_Process_Command
;*** Input          HL = Stack address (see notes below)
;***                A  = Ram bank (0-8)
;***                E  = Priority (1=highest, 7=lowest)
;*** Output         A  = Process ID
;***                CF = Success status
;***                     0 = OK
;***                     1 = the process couldn't been added, as the maximum
;***                         number of processes (32) has been reached
;*** Destroyed      BC,DE,HL,IX,IY
;*** Description    Adds a new process with a given priority and starts it
;***                immediately.
;***                Application processes usually will be started with priority 4.
;***                Note, that the desktop manager process runs with priority 1,
;***                the system manager process with 2. If you start a process,
;***                which should do some long and intensive calculation, you should
;***                choose a priority greater than 4, so that other applications
;***                will not be disturbed.
;***                The stack must always be placed between #C000 and #FFFF
;***                (transfer ram area). It must contain the start address of the
;***                process (or timer) routine at offset 12 and may contain the
;***                initial values of the registers. You can choose the size of the
;***                stack buffer by yourself, just be sure, that it is large
;***                enough.
;***                At offset 13 there must be a free byte. In this byte the kernel
;***                will write the ID of the process (or timer) after it has been
;***                started.
;*** Example(stack)                ds 128              ;Stack buffer
;***                stack_pointer: dw 0                ;initial value for IY
;***                               dw 0                ;initial value for IX
;***                               dw 0                ;initial value for HL
;***                               dw 0                ;initial value for DE
;***                               dw 0                ;initial value for BC
;***                               dw 0                ;initial value for AF
;***                               dw process_start    ;process start address
;***                process_id:    db 0                ;kernel writes the ID here
;******************************************************************************
        ld c,MSC_KRL_MTADDP
        call SyKernel_Message
        Xor a
        cp l
        ld a,h
        ret
EndLib

Library SyKernel_MTDELP
;******************************************************************************
;*** Name           Multitasking_Delete_Process_Command
;*** Input          A  = Process ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Stops an existing process and deletes it.
;******************************************************************************
        ld c,MSC_KRL_MTDELP
        ld l,a
        jp SyKernel_Message
EndLib

Library SyKernel_MTADDT
;******************************************************************************
;*** Name           Multitasking_Add_Timer_Command
;*** Input          HL = Stack address (see notes below)
;***                A  = Ram bank (0-8)
;*** Output         A  = Timer ID
;***                CF = Success status
;***                     0 = OK
;***                     1 = the timer couldn't been added, as the maximum
;***                         number of timers (32) has been reached
;*** Destroyed      BC,DE,HL,IX,IY
;*** Description    Adds a new timer and starts it immediately. Timers will be
;***                called 50times per second. Please see MSC_KRL_MTADDP for
;***                information about the stack.
;******************************************************************************
        ld c,MSC_KRL_MTADDT
        call SyKernel_Message
        Xor a
        cp l
        ld a,h
        ret
EndLib

Library SyKernel_MTDELT
;******************************************************************************
;*** Name           Multitasking_Delete_Timer_Command
;*** Input          A  = Timer ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Stops an existing timer and deletes it.
;******************************************************************************
        ld c,MSC_KRL_MTDELT
        ld l,a
        jp SyKernel_Message
EndLib

Library SyKernel_MTSLPP
;******************************************************************************
;*** Name           Multitasking_Sleep_Process_Command
;*** Input          A  = Process ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Puts an existing process into the sleep mode. It is stopped and
;***                does not run anymore, until it receives a message, or until it
;***                will be wacked up again (see MSC_KRL_MTWAKP).
;***                Usually this command is not needed, as a process can put itself
;***                into the sleep mode with the MSGSLP restart (see above).
;******************************************************************************
        ld c,MSC_KRL_MTSLPP
        ld l,a
        jp SyKernel_Message
EndLib

Library SyKernel_MTWAKP
;******************************************************************************
;*** Name           Multitasking_WakeUp_Process_Command
;*** Input          A  = Process ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Wakes up a process, which was sleeping before. A process will
;***                be wacked up, too, when another process is sending a message to
;***                it.
;******************************************************************************
        ld c,MSC_KRL_MTWAKP
        ld l,a
        jp SyKernel_Message
EndLib

Library SyKernel_TMADDT
;******************************************************************************
;*** Name           Timer_Add_Counter_Command
;*** Input          HL = Counter byte address
;***                E  = Counter byte ram bank (0-8)
;***                A  = Process ID
;***                B  = Speed (counter will be increased every x/50 second)
;*** Output         CF = Success status
;***                     0 = OK
;***                     1 = the timer couldn't been added, as the maximum
;***                         number of counter (16) has been reached
;*** Description    Adds a counter for a process. You need to specify a byte
;***                anywhere in the memory. This byte then will be increased every
;***                B/50 seconds. So if you want, that the kernel increases it once
;***                per second, you have to set B to 50.
;***                As an example you could check this byte regulary, and if it has
;***                been changed you call an event routine. This is much easier and
;***                faster than setting up an own timer.
;******************************************************************************
        ld c,MSC_KRL_TMADDT
        call SyKernel_Message
        Xor a
        cp l
        ret
EndLib

Library SyKernel_TMDELT
;******************************************************************************
;*** Name           Timer_Delete_Counter_Command
;*** Input          HL = Counter byte address
;***                E  = Counter byte ram bank (0-8)
;*** Output         -
;*** Description    Stops the specified counter. Please note, that this will be
;***                done automatically, if the process should be deleted.
;******************************************************************************
        ld c,MSC_KRL_TMDELT
        jp SyKernel_Message
EndLib

Library SyKernel_TMDELP
;******************************************************************************
;*** Name           Timer_Delete_AllProcessCounters_Command
;*** Input          A  = Process ID
;*** Output         -
;*** Description    Stops all counters of one process. Please note, that this will
;***                be done automatically, if the process should be deleted.
;******************************************************************************
        ld c,MSC_KRL_TMDELP
        ld l,a
        jp SyKernel_Message
EndLib


;### SUB ROUTINES #############################################################

Library SyKernel_Message
;******************************************************************************
;*** Input          C        = Command
;***                HL,E,A,B = Additional parameters
;*** Output         HL       = returned parameters
;*** Destroyed      AF,BC,DE,IX,IY
;*** Description    Sends a message to the kernel, waits for the answer and
;***                returns the result
;******************************************************************************
        ld iy,AppMsgB
        ld (iy+0),c
        ld (iy+1),l
        ld (iy+2),h
        ld (iy+3),e
        ld (iy+4),a
        ld (iy+5),b
        ld a,c
        add 128
        ld (SyKMsgN),a
        db #dd:ld h,1       ;1 is the number of the kernel process
        ld a,(AppPrzN)
        db #dd:ld l,a
        rst #10
SyKMsg1 db #dd:ld h,1       ;1 is the number of the kernel process
        ld a,(AppPrzN)
        db #dd:ld l,a
        rst #08             ;wait for a kernel message
        db #dd:dec l
        jr nz,SyKMsg1
        ld a,(SyKMsgN)
        cp (iy+0)
        jr nz,SyKMsg1
        ld l,(iy+1)
        ld h,(iy+2)
        ret
SyKMsgN db 0
EndLib
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@              S Y M S T U D I O   S Y S T E M   L I B R A R Y               @
;@                     - SYMBOS FILE MANAGER FUNCTIONS -                      @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;Author: Prodatron / Symbiosis
;Date:   30.04.2006

;This library supports you in using the file manager functions.
;Instead of including the following routines in your application code you may
;use the "SySystem_CallFunction" routine directly, so that you would save some
;overhead. In this case you can see this library just as an example, how to
;access the file manager.
;The existance of "AppPrzN" (a byte, where the ID of the applications process
;is stored) and "AppMsgB" (the message buffer, 14 bytes, which are placed in
;the transfer ram area) is required.


Library SyFile_FILNEW
;******************************************************************************
;*** Name           File_New
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;***                A    = Attributes
;***                       Bit0 = 1 -> Read only
;***                       Bit1 = 1 -> Hidden
;***                       Bit2 = 1 -> System
;***                       Bit5 = 1 -> Archive
;*** Output         A    = Filehandler ID
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Creates a new file and opens it for read/write access. If the
;***                file was already existing, it will be emptied first. For
;***                additional information see 018 (FILOPN).
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILNEW
        ret
EndLib

Library SyFile_FILOPN
;******************************************************************************
;*** Name           File_Open
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;*** Output         A    = Filehandler ID
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Opens an existing file for read/write access. This means, that
;***                you can read and write in the file like you want. You can open
;***                up to 8 different files at the same time.
;***                For more information about the file path see the introduction
;***                of the DIRECTORY MANAGEMENT FUNCTIONS.
;***                The media will be reloaded first, if the device is set to
;***                "removeable media" and there is no other open file on the same
;***                device.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILOPN
        ret
EndLib

Library SyFile_FILCLO
;******************************************************************************
;*** Name           File_Close
;*** Input          A    = Filehandler ID
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Closes an opened file. If there is unwritten data in the sector
;***                cache, it will be written to disc at once.
;***                This command closes a file in any case, even if an error
;***                occured.
;***                If an error occured during file reading/writing you must close
;***                the file, too, to have the filehandler free again!
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILCLO
        ret
EndLib

Library SyFile_FILINP
;******************************************************************************
;*** Name           File_Input
;*** Input          A    = Filehandler ID
;***                HL   = Destination address
;***                E    = Destination ram bank (0-8)
;***                BC   = Number of bytes
;*** Output         BC   = Number of read bytes
;***                ZF   = 1 -> All requested bytes have been read
;***                       0 -> The end of the file has been reached, and less
;***                            bytes than requested have been read (check BC)
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,HL,IX,IY
;*** Description    Reads a specified amount of bytes out of an opened file. After
;***                this operation the file pointer will be moved behind the last
;***                read byte. This means, that it is possible to read several
;***                blocks with different sizes out of an opened file. It doesn't
;***                matter, if you already did write operations, too.
;***                If you try to read more bytes than available, the zero flag
;***                will be reset. In any case BC contains the amount of read
;***                bytes.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILINP
        ret
EndLib

Library SyFile_FILOUT
;******************************************************************************
;*** Name           File_Output
;*** Input          A    = Filehandler ID
;***                HL   = Source address
;***                E    = Source ram bank (0-8)
;***                BC   = Number of bytes
;*** Output         BC   = Number of written bytes
;***                A    = 0 -> All bytes have been written
;***                       1 -> The device is full, and less bytes have been
;***                            written (check BC)
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,HL,IX,IY
;*** Description    Writes a specified amount of bytes into an opened file. After
;***                this operation the file pointer will be moved behind the last
;***                written byte. If the file pointer has been somewhere in the
;***                middle of the file before this operation, the data at this
;***                place will be overwritten. If you have been at the end of the
;***                file, its length will be extended.
;***                You can write several blocks with different sizes, and it
;***                doesn't matter if you already read from the file before.
;***                It's possible, that not all bytes have been written, if the
;***                device is full. Register A will be 1 in this case. In any case
;***                BC contains the amount of written bytes.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILOUT
        ret
EndLib

Library SyFile_FILPOI
;******************************************************************************
;*** Name           File_Pointer
;*** Input          A    = Filehandler ID
;***                IY,IX= Difference
;***                C    = Reference point
;***                       0 = File begin
;***                       1 = Actual pointer position
;***                       2 = File end
;*** Output         IY,IX= new absolute pointer position
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL
;*** Description    Moves the file pointer to another position. The difference is
;***                specified with IY and IX, IY is the high word, IX the low word
;***                (difference = 65536 * IY + IX).
;***                You can also use this function to find out the length of an
;***                opened file. Just set IY,IX to 0 and choose 2 as the reference
;***                point type. The pointer will be placed behind the last byte of
;***                the file, so you will get its length in IY,IX.
;*** Examples       IY = 0,     IX = 1,   C = 1 -> Increases the position by 1
;***                IY = 65535, IX = -10, C = 2 -> Sets the pointer before the last
;***                                               10 bytes of the file
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILPOI
        ret
EndLib

Library SyFile_FILF2T
;******************************************************************************
;*** Name           File_Decode_Timestamp
;*** Input          BC   = Time code
;***                       bit  0- 4 = second/2
;***                       bit  5-10 = minute
;***                       bit 11-15 = hour
;***                DE   = Date code
;***                       bit  0- 4 = day (starting from 1)
;***                       bit  5- 8 = month (starting from 1)
;***                       bit  9-15 = year-1980
;*** Output         A    = second
;***                B    = minute
;***                C    = hour
;***                D    = day (starting from 1)
;***                E    = month (starting from 1)
;***                HL   = year
;*** Destroyed      F
;*** Description    Decodes the file timestamp, which is used for the file system.
;***                You can use this function after reading the timestamp of a
;***                file with 035 (DIRPRR) or 038 (DIRINP).
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILF2T
        ret
EndLib

Library SyFile_FILT2F
;******************************************************************************
;*** Name           File_Encode_Timestamp
;*** Input          A    = second
;***                B    = minute
;***                C    = hour
;***                D    = day (starting from 1)
;***                E    = month (starting from 1)
;***                HL   = year
;*** Output         BC   = Time code (see FILF2T)
;***                DE   = Date code (see FILF2T)
;*** Destroyed      AF,HL,IX,IY
;*** Description    Encodes the file timestamp, which is used for the file system.
;***                You can use this function before changing the timestamp of a
;***                file with 034 (DIRPRS).
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILT2F
        ret
EndLib

Library SyFile_FILLIN
;******************************************************************************
;*** Name           File_LineInput
;*** Input          A    = Filehandler ID
;***                HL   = Destination buffer address (size must be 255 bytes)
;***                E    = Destination buffer ram bank (0-8)
;*** Output         BC   = Number of read bytes (without terminator)
;***                ZF   = 0 -> 1 or more bytes have been loaded
;***                       1 -> EOF reached, nothing has been loaded
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,HL,IX,IY
;*** Description    Reads one text line out of an opened file. A text line is
;***                terminated by a single 13, a single 10, a combination of 13+10,
;***                a combination of 10+13 or by a single 26 ("end of file" code).
;***                The line terminator will not be copied to the destination line
;***                buffer, but a 0 will be added behind the last char of the line.
;***                This function allows you to read a text file line by line at a
;***                very high speed, because you don't need to read single chars
;***                and check for line feeds by yourself.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_FILLIN
        ret
EndLib


Library SyFile_DIRDEV
;******************************************************************************
;*** Name           Directory_Device
;*** Input          A    = Driveletter ("A"-"Z")
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Selects the actual drive.
;***                As your application is running in a multitasking environment,
;***                unfortunately this command does not make many sense, as other
;***                applications could select an other drive again.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRDEV
        ret
EndLib

Library SyFile_DIRPTH
;******************************************************************************
;*** Name           Directory_Path
;*** Input          IXH  = File path ram bank (0-8)
;***                HL   = File path address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Selects the actual path for the actual or a different drive.
;***                As your application is running in a multitasking environment,
;***                unfortunately this command does not make many sense, as other
;***                applications could select an other path again.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRPTH
        ret
EndLib

Library SyFile_DIRPRS
;******************************************************************************
;*** Name           Directory_Property_Set
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;***                A    = Property type
;***                       0 = Attribute          -> C  = attribute
;***                                                      Bit0 = 1 -> Read only
;***                                                      Bit1 = 1 -> Hidden
;***                                                      Bit2 = 1 -> System
;***                                                      Bit5 = 1 -> Archive
;***                       1 = Timestamp modified -> BC = time code, DE = date code
;***                       2 = Timestamp created  -> BC = time code, DE = date code
;***                BC,DE= see above
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Changes a property of a file or a directory. You can set the
;***                attribute, the "created" time and the "modified" time.
;***                For more information about the time and date code see 023
;***                (FILF2T).
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRPRS
        ret
EndLib

Library SyFile_DIRPRR
;******************************************************************************
;*** Name           Directory_Property_Get
;*** Input          IXH  = File path and name ram bank (0-8)
;***                HL   = File path and name address
;***                A    = Property type
;***                       0 = Attribute
;***                       1 = Timestamp modified
;***                       2 = Timestamp created
;*** Output         C    = Attributes (if requested)
;***                       Bit0 = 1 -> Read only
;***                       Bit1 = 1 -> Hidden
;***                       Bit2 = 1 -> System
;***                       Bit3 = 1 -> Volume ID
;***                       Bit4 = 1 -> Directory
;***                       Bit5 = 1 -> Archive
;***                BC,DE= Time and date code (if requested)
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,HL,IX,IY
;*** Description    Reads a property of a file or a directory.
;***                For more information about the time and date code see 023
;***                (FILF2T).
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRPRR
        ret
EndLib

Library SyFile_DIRREN
;******************************************************************************
;*** Name           Directory_Rename
;*** Input          IXH  = Ram bank (0-8) of old and new file name
;***                HL   = Address of file path and old file name
;***                DE   = Address of new file name
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Renames a file or a directory. The new file name must not
;***                include a path. The function will fail, if a file or directory
;***                with the new name already exists.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRREN
        ret
EndLib

Library SyFile_DIRNEW
;******************************************************************************
;*** Name           Directory_New
;*** Input          IXH  = Directory path and name ram bank (0-8)
;***                HL   = Directory path and name address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Creates a new directory. The function will fail, if a file or
;***                directory with the same name already exists.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRNEW
        ret
EndLib

Library SyFile_DIRINP
;******************************************************************************
;*** Name           Directory_Input
;*** Input          IXH  = Directory path ram bank (0-8)
;***                HL   = Directory path address (may include a search mask)
;***                IXL  = forbidden attributes
;***                       Bit0 = 1 -> don't show read only files
;***                       Bit1 = 1 -> don't show hidden files
;***                       Bit2 = 1 -> don't show system files
;***                       Bit3 = 1 -> don't show volume ID entries
;***                       Bit4 = 1 -> don't show directories
;***                       Bit5 = 1 -> don't show archive files
;***                A    = Destination buffer ram bank (0-8)
;***                DE   = Destination buffer address
;***                BC   = Destination buffer length
;***                IY   = Number of entries, which should be skipped
;*** Output         HL   = Number of read entries
;***                BC   = Remaining unused space in the destination buffer
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,DE,IX,IY
;*** Data structure 00  4B  File length (32bit double word)
;***                04  1W  Date code, see 023 (FILF2T)
;***                06  1W  Time code, see 023 (FILF2T)
;***                08  1B  Attributes, see 035 (DIRPRR)
;***                09  ?B  File or sub directory name
;***                ??  1B  0 terminator
;*** Description    Reads the content of a directory. You can specify a name filter
;***                filter by adding a file mask to the path (* and ? are allowed)
;***                and an attribute filter. We recommend always to set Bit3
;***                (volume ID) of the attribute filter byte.
;***                The system skips the specified amount of entries first and
;***                then loads as many entries as exist or as there is place in the
;***                destination buffer. Please note, that the entries will not be
;***                sorted. Depending on its name every entry in the destination
;***                buffer can have a different length and is terminated with 0
;***                behind the file name. Filenames don't contain spaces.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRINP
        ret
EndLib

Library SyFile_DIRDEL
;******************************************************************************
;*** Name           Directory_DeleteFile
;*** Input          IXH  = File path and name/mask ram bank (0-8)
;***                HL   = File path and name/mask address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Deletes one or more files. You can delete multiple files by
;***                using a file mask (* and ? are allowed).
;***                This function can't be used for deleting directories.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRDEL
        ret
EndLib

Library SyFile_DIRRMD
;******************************************************************************
;*** Name           Directory_DeleteDirectory
;*** Input          IXH  = Directory path and name ram bank (0-8)
;***                HL   = Directory path and name address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Deletes a sub directory. The sub directory has to be empty
;***                and not read only, otherwise the operation will be aborted.
;***                You can specify the directory with or without "/" at the
;***                end of the full path.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRRMD
        ret
EndLib

Library SyFile_DIRMOV
;******************************************************************************
;*** Name           Directory_Move
;*** Input          IXH  = File/directory old and new path ram bank (0-8)
;***                HL   = File/directory source path and name address
;***                DE   = File/directory destination path address
;*** Output         CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Moves a file or sub directory into another directory of the
;***                same drive. That means, that the drive letter of the source
;***                path must be the same like the drive letter of the
;***                destination path, otherwise the operation will be aborted.
;***                You can either move files or sub directories with this
;***                function, in both cases the source path+name must not end
;***                with a "/".
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRMOV
        ret
EndLib

Library SyFile_DIRINF
;******************************************************************************
;*** Name           Directory_DriveInformation
;*** Input          A    = Driveletter ("A"-"Z")
;***                C    = Information type
;***                       0 = general drive information
;***                       1 = free and total amount of memory
;*** Output         - Information type 0:
;***                A    = Type
;***                       00 = Device does not exist
;***                       01 = Device is ready
;***                       02 = Device is not initialized
;***                       03 = Device is corrupt
;***                B    = Medium
;***                       01 = Floppy disc single side (Amsdos)
;***                       02 = Floppy disc double side (Fat 12)
;***                       08 = Ram disc
;***                       16 = IDE hard disc or CF card (Fat 16, Fat 32)
;***                C    = File system
;***                       01 = Amsdos Data
;***                       02 = Amsdos System
;***                       16 = Fat 12
;***                       17 = Fat 16
;***                       18 = Fat 32
;***                D    = Sectors per cluster
;***                IY,IX= Total number of clusters
;***                - Information type 1:
;***                HL,DE= Number of free 512Byte sectors
;***                IY,IX= Total number of clusters
;***                C    = Sectors per cluster
;***                - Information type 0 and 1:
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      F
;*** Description    Returns information about one drive. This function can be
;***                used to find out the amount of free memory on one drive.
;***                Please note, that calculating the free amount of memory on
;***                a FAT16 device may take a while, as everytime the whole FAT
;***                (up to 128KB) needs to be scanned.
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DIRINF
        ret
EndLib

Library SyFile_DEVDIR
;******************************************************************************
;*** Name           Directory_Input_Extended
;*** Input          A    = [bit0-3] Destination buffer ram bank (0-8)
;***                       [bit4-7] Directory path ram bank (0-8)
;***                HL   = Directory path address (may include a search mask)
;***                DE   = Destination buffer address. This must first contain two
;***                       words with additional information at the beginning:
;***                       00  1W  Address of list control table
;***                       02  1W  Maximum number of entries
;***                       This function will overwrite this information and fill
;***                       the buffer with the directory data.
;***                BC   = Maximum size of destination buffer
;***                IXL  = forbidden attributes
;***                       Bit0 = 1 -> don't show read only files
;***                       Bit1 = 1 -> don't show hidden files
;***                       Bit2 = 1 -> don't show system files
;***                       Bit3 = 1 -> don't show volume ID entries
;***                       Bit4 = 1 -> don't show directories
;***                       Bit5 = 1 -> don't show archive files
;***                IY   = Number of entries, which should be skipped
;***                IXH  = Additional columns
;***                       Bit0 = 1 -> File size
;***                       Bit1 = 1 -> Date and time (last modified)
;***                       Bit2 = 1 -> Attributes
;*** Output         HL   = Number of read entries
;***                CF   = Error state (0 = ok, 1 = error; A = error code)
;*** Destroyed      AF,BC,DE,IX,IY
;*** Description    This is a very powerful extension of the directory input
;***                (DIRINP) function. It reads the content of a directory and
;***                converts it into ready to use list control data. So if your
;***                application wants to display the content of a directory inside
;***                a list control, it can use this function and doesn't need to do
;***                any conversion jobs by itself. Also the list control itself can
;***                do the sorting of the directory.
;***                First you have to reserve two memory areas in the same ram
;***                bank. One area needs to be reserved inside the data ram area.
;***                It will contain the texts (file names, dates etc.) and numbers
;***                (file sizes) for the list control. You can choose any size, but
;***                we recommend at least 4000 Bytes. BC must contain its size,
;***                when you call the function. DE contains the address, and the
;***                low nibble of A the ram bank number.
;***                The second area needs to be reserved inside the transfer ram
;***                area of the same bank. It contains the data structure of the
;***                list control. It size is calculated like this:
;***                Size = Maximum_number_of_entries * (4 + Additional_columns * 2)
;***                So when you have two additional columns (like date and
;***                attributes) and want to load up to 100 entries, you need to
;***                reserve 800 bytes.
;***                As there are no more Z80-registers available, the address of
;***                this memory area and the maximum number of entries must be
;***                written to the beginning of the other memory area.
;***                For additional information about reading directories see 038
;***                (DIRINP).
;******************************************************************************
        call SySystem_CallFunction
        db MSC_SYS_SYSFIL
        db FNC_FIL_DEVDIR
        ret
EndLib


;### SUB ROUTINES #############################################################

Library SySystem_CallFunction
;******************************************************************************
;*** Name           System_CallFunction
;*** Input          ((SP+0)) = System manager command
;***                ((SP+1)) = Function ID
;***                AF,BC,DE,HL,IX,IY = Input for the function
;*** Output         AF,BC,DE,HL,IX,IY = Output from the function
;*** Destroyed      -
;*** Description    Calls a function via the system manager. This function is
;***                needed to have access to the file manager.
;******************************************************************************
        ld (AppMsgB+04),bc      ;copy registers into the message buffer
        ld (AppMsgB+06),de
        ld (AppMsgB+08),hl
        ld (AppMsgB+10),ix
        ld (AppMsgB+12),iy
        push af
        pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld e,(hl)
        inc hl
        ld d,(hl)
        inc hl
        push hl
        ld (AppMsgB+00),de      ;module und funktion number
        ld a,e
        ld (SyCallN),a
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #10                 ;send message
SyCall1 rst #30
        ld iy,AppMsgB
        ld a,(AppPrzN)
        db #dd:ld l,a
        ld a,3
        db #dd:ld h,a
        rst #18                 ;wait for answer
        db #dd:dec l
        jr nz,SyCall1
        ld a,(AppMsgB)
        sub 128
        ld e,a
        ld a,(SyCallN)
        cp e
        jr nz,SyCall1
        ld hl,(AppMsgB+02)      ;get registers out of the message buffer
        push hl
        pop af
        ld bc,(AppMsgB+04)
        ld de,(AppMsgB+06)
        ld hl,(AppMsgB+08)
        ld ix,(AppMsgB+10)
        ld iy,(AppMsgB+12)
        ret
SyCallN db 0
EndLib
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@              S Y M S T U D I O   S Y S T E M   L I B R A R Y               @
;@                    - SYMBOS SYSTEM MANAGER FUNCTIONS -                     @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;Author: Prodatron / Symbiosis
;Date:   28.10.2005

;The system manager is responsible for starting and stopping applications and
;it also provides several dialogue services.
;This library supports you in using the system manager functions.
;The existance of "AppPrzN" (a byte, where the ID of the applications process
;is stored) and "AppMsgB" (the message buffer, 14 bytes, which are placed in
;the transfer ram area) is required.


Library SySystem_PRGRUN
;******************************************************************************
;*** Name           Program_Run_Command
;*** Input          HL = File path and name address
;***                A  = [Bit0-3] File path and name ram bank (0-8)
;***                     [Bit7  ] Flag, if system error message should be
;***                              suppressed
;*** Output         A  = Success status
;***                     0 = OK
;***                     1 = File does not exist
;***                     2 = File is not an executable and its type is not
;***                         associated with an application
;***                     3 = Error while loading (see P8 for error code)
;***                     4 = Memory full
;***                - If success status is 0:
;***                L  = Application ID
;***                H  = Process ID (the applications main process)
;***                - If success status is 3:
;***                L  = File manager error code
;*** Destroyed      F,BC,DE,IX,IY
;*** Description    Loads and starts an application or opens a document with a
;***                known type by loading the associated application first.
;***                If Bit7 of A is not set, the system will open a message box,
;***                if an error occurs during the loading process.
;***                If the operation was successful, you will find the
;***                application ID and the process ID in L and H. If it failed
;***                because of loading problems L contains the file manager
;***                error code.
;******************************************************************************
        ld c,MSC_SYS_PRGRUN
        call SySystem_SendMessage
SySPRn1 call SySystem_WaitMessage
        cp MSR_SYS_PRGRUN
        jr nz,SySPRn1
        ld a,(iy+1)
        ld l,(iy+8)
        ld h,(iy+9)
        ret
EndLib

Library SySystem_PRGEND
;******************************************************************************
;*** Name           Program_End_Command
;*** Input          L  = Application ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Stops an application and releases all its used system
;***                resources. This command first stops all processes of the
;***                application. After this all open windows will be closed and the
;***                reserved memory will be released.
;***                Please note, that this command can't release memory, stop
;***                processes and timers or close windows, which are not
;***                registered for the application. Such resources first have
;***                to be released by the application itself.
;******************************************************************************
        ld c,MSC_SYS_PRGEND
        jp SySystem_SendMessage
EndLib

Library SySystem_SYSWRN
;******************************************************************************
;*** Name           Dialogue_Infobox_Command
;*** Input          HL = Content data address (#C000-#FFFF)
;***                A  = Content data ram bank (0-8)
;***                E  = [Bit0-6] Number of buttons (MUST BY ALWAYS 1)
;***                     [Bit7  ] Box type
;***                              0 = warning (default warning symbol)
;***                              1 = info (own symbol will be used)
;*** Content data   00  1W  Address of text line 1
;***                02  1W  4 * [text line 1 pen] + 2
;***                04  1W  Address of text line 2
;***                06  1W  4 * [text line 2 pen] + 2
;***                08  1W  Address of text line 3
;***                10  1W  4 * [text line 3 pen] + 2
;***                - if E[bit7] is 1:
;***                12  1W  Address of symbol (24x24 pixel SymbOS graphic format)
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Opens an info or warning box and displays three line of text
;***                and one "OK" button. If Bit7 of E is set to 1 you can specify
;***                an own symbol, which will be showed left to the text. If this
;***                bit is not set, a "!"-warning symbol will be displayed.
;***                Currently multiple choice alert boxes are not supported, which
;***                means, that the number of buttons always have to be set to 1.
;***                Please note, that the content data must always be placed in the
;***                transfer ram area (#C000-#FFFF). The texts itself and the
;***                optional graphic must always be placed inside a 16K (data ram
;***                area).
;***                As the text line pen, you should choose 1, so 6 would be the
;***                correct value.
;***                For more information about the mentioned memory types (data,
;***                transfer) see the "applications" chapter.
;***                For more information about the SymbOS graphic format see the
;***                "desktop manager data records" chapter.
;******************************************************************************
        ld c,MSC_SYS_SYSWRN
        jp SySystem_SendMessage
EndLib

Library SySystem_SELOPN
;******************************************************************************
;*** Name           Dialogue_FileSelector_Command
;*** Input          HL = File mask, path and name address (#C000-#FFFF)
;***                     00  3B  File extension filter (e.g. "*  ")
;***                     03  1B  0
;***                     04 256B path and filename
;***                A  = File mask, path and name ram bank (0-8)
;***                C  = Attribute filter
;***                     Bit0 = 1 -> don't show read only files
;***                     Bit1 = 1 -> don't show hidden files
;***                     Bit2 = 1 -> don't show system files
;***                     Bit3 = 1 -> don't show volume ID entries
;***                     Bit4 = 1 -> don't show directories
;***                     Bit5 = 1 -> don't show archive files
;***                IX = Maximum number of directory entries
;***                IY = Maximum size of directory data buffer
;***                DE = Data record of the caller window; the file selector
;***                     window will be a super window of it, during its open)
;*** Output         A  = Success status
;***                     0 -> The user choosed a file and closed the dialogue
;***                          with "OK". The complete file path and name can be
;***                          found in the filepath buffer of the application.
;***                     1 -> The user aborted the file selection. The content
;***                          of the applications filepath buffer is unchanged.
;***                     2 -> The file selection dialogue is currently used by
;***                          another application. It can only be opened once
;***                          at the same time. The user should close the
;***                          dialogue first before it can be opened again by
;***                          the application.
;***                     3 -> Memory full. There was not enough memory
;***                          available for the directory buffer and/or the
;***                          list data structure.
;***                     4 -> No window available. The desktop manager couldn't
;***                          open a new window for the dialogue, as the
;***                          maximum number of windows (32) has already been
;***                          reached.
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Opens the file selection dialogue. In this dialogue the user
;***                can move through the directory structure, change the drive and
;***                search and select a file.
;***                If you specify a path, the dialogue will start directly in the
;***                directory. If you append a filename, too, it will be used as
;***                the preselected file.
;***                You can filter the entries of the directory by attributes and
;***                filename extension. We recommend always to set Bit3 of the
;***                attribute filter byte.
;***                The File mask/path/name string (260 bytes) must always be
;***                placed in the transfer ram area (#C000-#FFFF). For more
;***                information about this memory types see the "applications"
;***                chapter.
;***                Please note, that the system will reserve memory to store the
;***                listed directory entries and the data structure of the list.
;***                With IX and IY you can choose, how much memory should be used.
;***                We recommend to set the number of entries between 100 and 200
;***                (Amsdos supports a maximum amount of 64 entries) and to set the
;***                data buffer between 5000 and 10000.
;******************************************************************************
        ld (SySSOpW),de
        push iy
        ld iy,AppMsgB
        ld (iy+6),a
        ld (iy+7),c
        ld (iy+8),l
        ld (iy+9),h
        db #dd:ld a,l
        ld (iy+10),a
        db #dd:ld a,h
        ld (iy+11),a
        pop de
        ld (iy+12),e
        ld (iy+13),d
        ld c,MSC_SYS_SELOPN
        call SySystem_SendMessage
SySSOp1 call SySystem_WaitMessage
        cp MSR_SYS_SELOPN
        jr nz,SySSOp1
        ld a,(iy+1)
        cp -1
        ret nz
        ld ix,(SySSOpW)
        ld a,(iy+2)
        ld (ix+51),a
        jr SySSOp1
SySSOpW dw 0
EndLib


;### SUB ROUTINES #############################################################

Library SySystem_SendMessage
;******************************************************************************
;*** Input          C       = Command
;***                HL,A,DE = additional Parameters
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sends a message to the system manager
;******************************************************************************
        ld iy,AppMsgB
        ld (iy+0),c
        ld (iy+1),l
        ld (iy+2),h
        ld (iy+3),a
        ld (iy+4),e
        ld (iy+5),d
        db #dd:ld h,3       ;3 is the number of the system manager process
        ld a,(AppPrzN)
        db #dd:ld l,a
        rst #10
        ret
EndLib

Library SySystem_WaitMessage
;******************************************************************************
;*** Input          -
;*** Output         IY = message buffer
;***                A  = first byte in the Message buffer (IY+0)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sends a message to the desktop manager, which includes the
;***                window ID and additional parameters
;******************************************************************************
        ld iy,AppMsgB
SySWMs1 db #dd:ld h,3       ;3 is the number of the system manager process
        ld a,(AppPrzN)
        db #dd:ld l,a
        rst #08             ;wait for a system manager message
        db #dd:dec l
        jr nz,SySWMs1
        ld a,(iy+0)
        ret
EndLib
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@                                                                            @
;@              S Y M S T U D I O   S Y S T E M   L I B R A R Y               @
;@                    - SYMBOS DESKTOP MANAGER FUNCTIONS -                    @
;@                                                                            @
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;Author: Prodatron / Symbiosis
;Date:   27.10.2005

;The desktop manager is responsible for all actions, which are taking place on
;the video screen. Especially the handling of the application windows is done
;by the desktop manager.
;This library supports you in using the desktop manager functions.
;The existance of "AppPrzN" (a byte, where the ID of the applications process
;is stored) and "AppMsgB" (the message buffer, 14 bytes, which are placed in
;the transfer ram area) is required.


Library SyDesktop_WINOPN
;******************************************************************************
;*** Name           Window_Open_Command
;*** Input          A  = Window data record ram bank (0-8)
;***                DE = Window data record address (#C000-#FFFF)
;*** Output         A  = Window ID (only, if CF=0)
;***                CF = Success status
;***                     0 = OK
;***                     1 = window couldn't be opened, as the maximum number
;***                         of windows (32) has been reached
;*** Destroyed      BC,DE,HL,IX,IY
;*** Description    Opens a new window. Its data record must be placed in the
;***                transfer ram area (between #c000 and #ffff).
;***                For more information about the window data record see the
;***                chapter "desktop manager data records".
;***                For more information about the transfer ram memory types see
;***                the "applications" chapter.
;******************************************************************************
        ld b,a
        db #dd:ld l,e
        db #dd:ld h,d
        ld a,(AppPrzN)      ;register window for the application process
        ld (ix+3),a
        ld a,b
        ld c,MSC_DSK_WINOPN
        call SyDesktop_SendMessage
SyWOpn1 call SyDesktop_WaitMessage
        cp MSR_DSK_WOPNER
        scf
        ret z               ;return with set carry flag, if window couldn't be opened
        cp MSR_DSK_WOPNOK
        jr nz,SyWOpn1       ;different message than "open ok" -> continue waiting
        ld a,(iy+4)         ;get window ID and return with cleared carry flag
        ret
EndLib

Library SyDesktop_WINMEN
;******************************************************************************
;*** Name           Window_Redraw_Menu_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws the menu bar of a window. If you changed your menus you
;***                should call this command to update the screen display.
;******************************************************************************
        ld c,MSC_DSK_WINMEN
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WININH
;******************************************************************************
;*** Name           Window_Redraw_Content_Command
;*** Input          A  = Window ID
;***                E  = -1, control ID or negative number of controls
;***                     000 - 239 -> the control with the specified ID will be
;***                                  redrawed.
;***                     240 - 254 -> redraws -P2 controls, starting from
;***                                  control P3. As an example, if P2 is -3
;***                                  (253) and P3 is 5, the controls 5, 6 and 7
;***                                  will be redrawed.
;***                     255       -> redraws all controls inside the window
;***                                  content.
;***                - if E is between 240 and 254:
;***                D = ID of the first control, which should be redrawed.
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws one, all or a specified number of controls inside the
;***                window content. This command is very important, if you make
;***                changes and want to display them.
;***                This command is identical with MSC_DSK_WINDIN with the
;***                exception, that it only works, if the window has focus. Because
;***                of this, it is a little bit faster, as the desktop manager
;***                doesn't need to take care about other windows, which could hide
;***                some parts of the window.
;******************************************************************************
        ld c,MSC_DSK_WININH
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINTOL
;******************************************************************************
;*** Name           Window_Redraw_Toolbar_Command
;*** Input          A  = Window ID
;***                E  = -1, control ID or negative number of controls
;***                     000 - 239 -> the control with the specified ID will be
;***                                  redrawed.
;***                     240 - 254 -> redraws -P2 controls, starting from
;***                                  control P3. As an example, if P2 is -3
;***                                  (253) and P3 is 5, the controls 5, 6 and 7
;***                                  will be redrawed.
;***                     255       -> redraws all controls inside the window
;***                                  toolbar.
;***                - if E is between 240 and 254:
;***                D = ID of the first control, which should be redrawed.
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws one, all or a specified number of controls inside the
;***                window toolbar. Use this command to update the screen display,
;***                if you made changes in the toolbar.
;******************************************************************************
        ld c,MSC_DSK_WINTOL
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINTIT
;******************************************************************************
;*** Name           Window_Redraw_Title_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws the title bar of a window. Use this command to update
;***                the screen display, if you changed the text of the window
;***                title.
;******************************************************************************
        ld c,MSC_DSK_WINTIT
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINSTA
;******************************************************************************
;*** Name           Window_Redraw_Statusbar_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws the status bar of a window. Use this command to update
;***                the screen display, if you changed the text of the status bar.
;******************************************************************************
        ld c,MSC_DSK_WINSTA
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINMVX
;******************************************************************************
;*** Name           Window_Set_ContentX_Command
;*** Input          A  = Window ID
;***                DE = new X offset of the visible window content
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    If the size of the window content is larger than the visible
;***                part, you can scroll its X offset with this command. The
;***                command works also, if the window is not resizeable by the
;***                user.
;******************************************************************************
        ld c,MSC_DSK_WINMVX
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINMVY
;******************************************************************************
;*** Name           Window_Set_ContentY_Command
;*** Input          A  = Window ID
;***                DE = new Y offset of the visible window content
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    If the size of the window content is larger than the visible
;***                part, you can scroll its Y offset with this command. The
;***                command works also, if the window is not resizeable by the
;***                user.
;******************************************************************************
        ld c,MSC_DSK_WINMVY
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINTOP
;******************************************************************************
;*** Name           Window_Focus_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    Takes the window to the front position on the screen.
;******************************************************************************
        ld c,MSC_DSK_WINTOP
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINMAX
;******************************************************************************
;*** Name           Window_Size_Maximize_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if the window is minimized or restored
;*** Description    Maximizes a window. A maximized window has a special status,
;***                where it can't be moved to another screen position.
;******************************************************************************
        ld c,MSC_DSK_WINMAX
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINMIN
;******************************************************************************
;*** Name           Window_Size_Minimize_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if the window is maximized or restored
;*** Description    Minimizes a window. It will disappear from the screen and can
;***                only be accessed by the user via the task bar.
;******************************************************************************
        ld c,MSC_DSK_WINMIN
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINMID
;******************************************************************************
;*** Name           Window_Size_Restore_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if the window is maximized or minimized
;*** Description    Restores the window or the size of the window, if it was
;***                minimized or maximized before.
;******************************************************************************
        ld c,MSC_DSK_WINMID
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINMOV
;******************************************************************************
;*** Name           Window_Set_Position_Command
;*** Input          A  = Window ID
;***                DE = new X window position
;***                HL = new Y window position
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if the window is not maximized
;*** Description    Moves the window to another position on the screen. This will
;***                not work, if the window is maximized.
;******************************************************************************
        ld c,MSC_DSK_WINMOV
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINSIZ
;******************************************************************************
;*** Name           Window_Set_Size_Command
;*** Input          A  = Window ID
;***                DE = new window width
;***                HL = new window height
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    Resizes a window. This command will always work, even if the
;***                window is not resizeable by the user.
;***                Please note, that the size always refers to the visible content
;***                of the window, not to the whole window including the control
;***                elements. So with title bar, scroll bars etc. a window can have
;***                a bigger size on the screen.
;******************************************************************************
        ld c,MSC_DSK_WINSIZ
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINCLS
;******************************************************************************
;*** Name           Window_Close_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    Closes the window. The desktop manager will remove it from the
;***                screen.
;******************************************************************************
        ld c,MSC_DSK_WINCLS
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINDIN
;******************************************************************************
;*** Name           Window_Redraw_ContentExtended_Command
;*** Input          A  = Window ID
;***                E  = -1, control ID or negative number of controls
;***                     000 - 239 -> the control with the specified ID will be
;***                                  redrawed.
;***                     240 - 254 -> redraws -P2 controls, starting from
;***                                  control P3. As an example, if P2 is -3
;***                                  (253) and P3 is 5, the controls 5, 6 and 7
;***                                  will be redrawed.
;***                     255       -> redraws all controls inside the window
;***                                  content.
;***                - if E is between 240 and 254:
;***                D = ID of the first control, which should be redrawed.
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    Redraws one, all or a specified number of controls inside the
;***                window content. This command is identical with MSC_DSK_WININH
;***                with the exception, that it always works but with less speed.
;***                For more information see MSC_DSK_WININH.
;******************************************************************************
        ld c,MSC_DSK_WINDIN
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINSLD
;******************************************************************************
;*** Name           Window_Redraw_Slider_Command
;*** Input          A  = Window ID
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works only, if window has focus
;*** Description    Redraws the two slider of the window, with which the user can
;***                scroll the content. Sliders will only be displayed, if the
;***                window is resizeable.
;***                Usally you should use MSC_DSK_WINMVX and MSC_DSK_WINMVY to
;***                scroll the content of the window. These commands will update
;***                the sliders by themself.
;***                If you manipulate the content position in the window data
;***                record by yourself, you can use this command to update the
;***                screen display.
;******************************************************************************
        ld c,MSC_DSK_WINSLD
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_WINPIN
;******************************************************************************
;*** Name           Window_Redraw_ContentArea_Command
;*** Input          A  = Window ID
;***                E  = -1, control ID or negative number of controls
;***                     000 - 239 -> the control with the specified ID will be
;***                                  redrawed.
;***                     240 - 254 -> redraws -P2 controls, starting from
;***                                  control P3. As an example, if P2 is -3
;***                                  (253) and P3 is 5, the controls 5, 6 and 7
;***                                  will be redrawed.
;***                     255       -> redraws all controls inside the window
;***                                  content.
;***                HL = Area X begin inside the window content
;***                BC = Area Y begin
;***                IX = Area X length
;***                IY = Area Y length
;***                - if E is between 240 and 254:
;***                D = ID of the first control, which should be redrawed.
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Limitation     works always
;*** Description    This command works like MSC_DSK_WINDIN, but it updates only a
;***                specified area inside the window content. Changes outside the
;***                area won't be updated. This command is especially useful for
;***                updating large graphics, if only a part of the graphic should
;***                be updated, and you don't want to loose performance with
;***                updating the other parts of it, too.
;***                For more information see MSC_DSK_WINDIN and MSC_DSK_WININH.
;******************************************************************************
        ld (AppMsgB+06),bc
        ld (AppMsgB+08),ix
        ld (AppMsgB+10),iy
        ld c,MSC_DSK_WINPIN
        jp SyDesktop_SendMessage
EndLib

Library SyDesktop_MODGET
;******************************************************************************
;*** Name           DesktopService_ScreenModeGet
;*** Input          -
;*** Output         E  = Screen mode
;***                     0 = 160 x 200, 16 colours
;***                     1 = 320 x 200,  4 colours (standard mode)
;***                     2 = 640 x 200,  2 colours
;*** Destroyed      F,BC,DE,HL,IX,IY
;*** Description    Returns the actual screen resolution and number of possible
;***                colours.
;******************************************************************************
        ld a,DSK_SRV_MODGET
        jp SyDesktop_Service
EndLib

Library SyDesktop_MODSET
;******************************************************************************
;*** Name           DesktopService_ScreenModeSet
;*** Input          E  = Screen mode
;***                     0 = 160 x 200, 16 colours
;***                     1 = 320 x 200,  4 colours (standard mode)
;***                     2 = 640 x 200,  2 colours
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sets the screen resolution and number of possible colours.
;******************************************************************************
        ld a,DSK_SRV_MODSET
        jp SyDesktop_Service
EndLib

Library SyDesktop_COLGET
;******************************************************************************
;*** Name           DesktopService_ColourGet
;*** Input          E  = Colour number (0-15)
;*** Output         D  = Bit[0-3] blue  component (0-15)
;***                     Bit[4-7] green component (0-15)
;***                L  = Bit[0-3] red   component (0-15)
;*** Destroyed      AF,BC,E,H,IX,IY
;*** Description    Returns the definition of a colours. Please note, that you
;***                always have a range of 4096, even if the computer is not a CPC
;***                PLUS, as the system recalculates the colour for standard CPCs
;***                (factor 5,33 for each component).
;******************************************************************************
        ld a,DSK_SRV_COLGET
        jp SyDesktop_Service
EndLib

Library SyDesktop_COLSET
;******************************************************************************
;*** Name           DesktopService_ColourSet
;*** Input          E  = Colour number (0-15)
;***                D  = Bit[0-3] blue  component (0-15)
;***                     Bit[4-7] green component (0-15)
;***                L  = Bit[0-3] red   component (0-15)
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Defines one colour. Please note, that you always have a range
;***                of 4096, even if the computer is not a CPC PLUS, as the system
;***                recalculates the colour for standard CPCs (factor 5,33 for each
;***                component).
;******************************************************************************
        ld a,DSK_SRV_COLSET
        jp SyDesktop_Service
EndLib

Library SyDesktop_DSKBGR
;******************************************************************************
;*** Name           DesktopService_RedrawBackground
;*** Input          -
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Redraws the desktop background.
;******************************************************************************
        ld a,DSK_SRV_DSKBGR
        jp SyDesktop_Service
EndLib

Library SyDesktop_DSKPLT
;******************************************************************************
;*** Name           DesktopService_RedrawComplete
;*** Input          -
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Redraws the complete screen. The background, the task bar and
;***                all windows will be updated.
;******************************************************************************
        ld a,DSK_SRV_DSKPLT
        jp SyDesktop_Service
EndLib


;### SUB ROUTINES #############################################################

Library SyDesktop_Service
;******************************************************************************
;*** Input          A     = Function
;***                DE,HL = additional parameters
;*** Output         DE,HL = returned parameters
;*** Destroyed      AF,BC,IX,IY
;*** Description    Sends a service request message to the desktop manager,
;***                waits for the answer and returns with the result
;******************************************************************************
        ld c,MSC_DSK_DSKSRV
        ld (SyDSrvN),a
        push af
        call SyDesktop_SendMessage
        pop af
        cp 1
        jr z,SyDSrv1
        cp 3
        jr z,SyDSrv1
        cp 5
        ret nz
SyDSrv1 call SyDesktop_WaitMessage
        cp MSR_DSK_DSKSRV
        jr nz,SyDSrv1
        ld a,(SyDSrvN)
        cp (iy+1)
        jr nz,SyDSrv1
        ld e,(iy+2)
        ld d,(iy+3)
        ld l,(iy+4)
        ld h,(iy+5)
        ret
SyDSrvN db 0
EndLib

Library SyDesktop_SendMessage
;******************************************************************************
;*** Input          C  = Command
;***                A  = Window ID
;***                DE,HL = additional parameters
;*** Output         -
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sends a message to the desktop manager, which includes the
;***                window ID and additional parameters
;******************************************************************************
        ld iy,AppMsgB
        ld (iy+0),c
        ld (iy+1),a
        ld (iy+2),e
        ld (iy+3),d
        ld (iy+4),l
        ld (iy+5),h
        db #dd:ld h,2       ;2 is the number of the desktop manager process
        ld a,(AppPrzN)
        db #dd:ld l,a
        rst #10
        ret
EndLib

Library SyDesktop_WaitMessage
;******************************************************************************
;*** Input          -
;*** Output         IY = message buffer
;***                A  = first byte in the Message buffer (IY+0)
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    Sends a message to the desktop manager, which includes the
;***                window ID and additional parameters
;******************************************************************************
        ld iy,AppMsgB
SyDWMs1 db #dd:ld h,2       ;2 is the number of the desktop manager process
        ld a,(AppPrzN)
        db #dd:ld l,a
        rst #08             ;wait for a desktop manager message
        db #dd:dec l
        jr nz,SyDWMs1
        ld a,(iy+0)
        ret
EndLib
.AppTrnEnd


