; CPE - The Amstrad CPC Emulator
; tape handling routines
; Copyright (c) 1991-96 by Bernd Schmidt
; modifications Copyright (c) 1995-97 by Ulrich Doewich

;	Apr.  7, 1997 - 22:50	reformatted source to use variable tabs
;	Apr.  8, 1997 - 23:34	tape loading works again

IDEAL
P386

INCLUDE		"macros.inc"

; from ipe1.asm
EXTRN		sysstat:BYTE
;EXTRN		TapeBuffer:WORD, TapeLoadBuf:WORD

; from ipe2.asm
EXTRN		simstack:WORD, simz80l:PROC, sz80performret:PROC, sz80performpushhl:PROC
EXTRN		sz80wbhlAL:PROC, sz80InitPCSeg:PROC

; from files.asm
extrn		buffer:BYTE

; from comp386.asm
EXTRN		UnpackArea:PROC, PackArea:PROC

; ........................................................................

PUBLIC		InitTape, CloseTape, GetTapeDir
PUBLIC		CASInOpen, CASRead, CASWrite, CASCheck, CAScont, CASInH
PUBLIC		TapeBuffer, tables_end

GROUP DGROUP	_stack, _data

SEGMENT _text	PAGE PUBLIC 'CODE'
ASSUME		CS:_text
ASSUME		DS:DGROUP

; ________________________________________________________________________

GetTapeDir:
		PUSHAD
		PUSH	ES

		mov	dx, offset buffer
		mov	ax, 1a00h			; set DTA address
		int	21h

		MOV	DX, SEG tapetbl
		MOV	ES, DX

		XOR	DI, DI
		mov	ax, ds
		MOV	FS, AX
		MOV	DX, OFFSET tapecard
		MOV	AX, 4E00h			; find first file
		XOR	CX, CX
		INT	21h
		JC	GTD_End
		MOV	EBX, OFFSET tapetbl
GTD_Loop:
		MOV	CX, offset buffer
		ADD	CX, 1eh
		INC	DI
		XOR	ESI, ESI
		MOV	[DWORD PTR ES:EBX], 0
		MOV	[DWORD PTR ES:EBX+4], 0
		MOV	[DWORD PTR ES:EBX+8], 0
GTD_Copy:
		MOV	AL, [FS:ECX+ESI]
		OR	AL, AL
		JE	GTD_Copied
		MOV	[ES:BX+SI], AL
		INC	SI
		CMP	SI, 12
		JE	GTD_Copied
		JMP	GTD_Copy
GTD_Copied:
		MOV	EAX, [FS:ECX-4]
		MOV	[ES:BX+12], EAX
		ADD	BX, 16
		MOV	AX, 4F00h			; find next file
		INT	21h
		JC	GTD_End
		CMP	DI, 1000
		JC	GTD_Loop
GTD_End:
		MOV	[tfilcnt], DI

		MOV	BX, OFFSET tapetbl
GTD_CheckArcs:
		MOV	EAX, [ES:BX]
		MOV	[DWORD PTR tapname], EAX
		MOV	EAX, [ES:BX+4]
		MOV	[DWORD PTR tapname+4], EAX
		MOV	EAX, [ES:BX+8]
		MOV	[DWORD PTR tapname+8], EAX

		PUSH	BX

		MOV	BX, OFFSET tapname
GTD_CheckTAR:
		CMP	[BYTE PTR BX], 0
		JE	GTD_NoTAR
		INC	BX
		CMP	[DWORD PTR BX-1], 'RAT.'
		JNE	GTD_CheckTAR

		MOV	DX, OFFSET tapedir
		MOV	AX, 3d02h
		INT	21h
		JC	GTD_NoArc
		MOV	[tapeha], AX

		MOV	CX, 8
		MOV	BX, [tapeha]
		MOV	DX, OFFSET tfilheader
		MOV	AX, 3F00h
		INT	21h
		JC	GTD_NoArc
		CMP	[DWORD PTR tfilheader], 'XURC'
		JNE	GTD_NoArc
		CMP	[DWORD PTR tfilheader+4], 'CRAT'
		JNE	GTD_NoArc
		POP	BX
		MOV	[DWORD PTR ES:BX+12], 0ffffffffh
		PUSH	BX
GTD_NoArc:
		MOV	BX, [tapeha]
		MOV	AX, 3e00h
		INT	21h
GTD_NoTAR:
		POP	BX
		ADD	BX, 16
		CMP	[DWORD PTR ES:BX], 0
		JNE	GTD_CheckArcs

		POP	ES
		POPAD
		RET

; ________________________________________________________________________

InitTape:
		MOV	[tfilptr], 0
		MOV	[tapeha], 0ffffh
		CALL	GetTapeFile
		RET

; ________________________________________________________________________

GetTapeFile:
		CMP	[tfilcnt], 0
		JE	GTFI_Ret
		PUSH	ES
		PUSHAD
		CALL	CloseTape
		MOV	DX, SEG tapetbl
		MOV	ES, DX
		MOV	[tfiloff], 0
		MOV	AX, [tfilptr]
		CMP	AX, [tfilcnt]
		JC	GTFI_NumOk
		XOR	AX, AX
		MOV	[tfilptr], 0
GTFI_NumOk:
		MOV	BX, AX
		SHL	BX, 4
		ADD	BX, OFFSET tapetbl

		MOV	EAX, [ES:BX]
		MOV	[DWORD PTR tapname], EAX
		MOV	EAX, [DWORD PTR ES:BX+4]
		MOV	[DWORD PTR tapname+4], EAX
		MOV	EAX, [DWORD PTR ES:BX+8]
		MOV	[DWORD PTR tapname+8], EAX

		MOV	EAX, [DWORD PTR ES:BX+12]
		MOV	[tfillen], EAX
		XOR	EAX, EAX
		MOV	[tapeha], 0ffffh

		MOV	DX, OFFSET tapedir
		MOV	AX, 3d02h
		INT	21h
		JC	GTFI_End
		MOV	[tapeha], AX

		CMP	[tfillen], 128
		JC	GTFI_NoHeader

		MOV	CX, 128
		MOV	BX, [tapeha]
		MOV	DX, OFFSET tfilheader
		MOV	AX, 3F00h
		INT	21h
		JC	GTFI_End
		CMP	[DWORD PTR tfilheader], 'XURC'
		JNE	GTFI_NoArchive
		CMP	[DWORD PTR tfilheader+4], 'CRAT'
		JNE	GTFI_NoArchive
		MOV	[tarcdiroffs], 12
		MOV	[tarcfilenum], 0
		MOV	[tfisarc], 1
		CALL	GetTArchivedFile
		JMP	GTFI_End
GTFI_NoArchive:
		MOV	[tfisarc], 0
		MOV	AX, 0
		MOV	BX, OFFSET tfilheader
		XOR	CH, CH
GTFI_CalcChksum:
		MOV	CL, [BX]
		ADD	AX, CX
		INC	BX
		CMP	BX, OFFSET tfilheader+43h
		JNE	GTFI_CalcChksum
		CMP	AX, [BX]
		JNE	GTFI_NoHeader
		SUB	[tfillen], 128
		JMP	GTFI_HeaderOK
GTFI_NoHeader:
		MOV	BX, [tapeha]
		XOR	CX, CX
		XOR	DX, DX
		MOV	AX, 4200h
		INT	21h
		MOV	[BYTE PTR tfilheader+12h], 16h
		MOV	AX, [WORD PTR tfillen]
		MOV	[WORD PTR tfilheader+18h], AX
GTFI_HeaderOK:
		MOV	AX, [WORD PTR tfilheader+18h]
		MOV	[WORD PTR tfillen], AX

		MOV	[lasthdread], 0
		MOV	[WORD PTR tfilheader+13h], 2048
		CMP	[tfillen], 2048
		JNC	GTFI_BlockLenLess
		MOV	AX, [WORD PTR tfillen]
		MOV	[WORD PTR tfilheader+13h], AX
GTFI_BlockLenLess:
		MOV	[BYTE PTR tfilheader+17h], 0ffh
		MOV	[BYTE PTR tfilheader+11h], 0
		CMP	[tfillen], 2049
		JNC	GTFI_NotLast
		MOV	[BYTE PTR tfilheader+11h], 0ffh
GTFI_NotLast:
		MOV	[BYTE PTR tfilheader+10h], 1
		MOV	EAX, [DWORD PTR tapname]
		MOV	[DWORD PTR tfilheader], EAX
		MOV	EAX, [DWORD PTR tapname+4]
		MOV	[DWORD PTR tfilheader+4], EAX
		MOV	EAX, [DWORD PTR tapname+8]
		MOV	[DWORD PTR tfilheader+8], EAX
		MOV	[DWORD PTR tfilheader+12], 0
		XOR	EAX, EAX
		MOV	BX, OFFSET tfilheader+11
GTFI_KillSpaces:
		CMP	[BYTE PTR BX], 32
		JNE	GTFI_SpacesKilled
		MOV	[BYTE PTR BX], 0
		DEC	BX
		JNE	GTFI_KillSpaces
GTFI_SpacesKilled:
GTFI_End:
		POPAD
		POP	ES
GTFI_Ret:
		RET

; ________________________________________________________________________

GetNextTArcFile:
		PUSHAW
		INC	[tarcfilenum]
		CMP	[tarcfilenum], 32
		JNE	TARC_FilNumOK
		MOV	BX, [tapeha]
		MOV	AX, 4200h
		MOV	CX, [WORD PTR tarcdiroffs+2]
		MOV	DX, [WORD PTR tarcdiroffs]
		INT	21h
		MOV	AX, 3f00h
		MOV	CX, 4
		MOV	DX, OFFSET tarcdiroffs
		INT	21h
		CMP	[tarcdiroffs], 0
		JE	TARC_ArchiveEnd
		MOV	[tarcfilenum], 0
TARC_FilNumOK:
		CALL	GetTArchivedFile
		POPAW
		RET

; ________________________________________________________________________

GetTArchivedFile:
		MOV	BX, [tapeha]
		MOV	CX, [WORD PTR tarcdiroffs+2]
		MOV	DX, [WORD PTR tarcdiroffs]
		MOV	AL, [tarcfilenum]
		MOV	AH, 24
		MUL	AH
		ADD	AX, 4
		ADD	DX, AX
		ADC	CX, 0
		MOV	AX, 4200h
		INT	21h
		MOV	AX, 3f00h
		MOV	CX, 24
		MOV	DX, OFFSET TapeBuffer
		INT	21h
		CMP	[BYTE PTR TapeBuffer], 0
		JE	TARC_ArchiveEnd
		MOV	SI, OFFSET TapeBuffer
		MOV	DI, OFFSET tfilheader
		MOV	CX, 12
		PUSH	ES
		PUSH	DS
		POP	ES
		REP	MOVSB
		POP	ES
		MOV	[DWORD PTR DI], 0
		MOV	AL, [SI]
		MOV	[BYTE PTR tfilheader+012h], AL
		MOV	EAX, [SI+1]
		AND	EAX, 000ffffffh
		MOV	[DWORD PTR tfilheader+40h], EAX
		MOV	[WORD PTR tfilheader+18h], AX
		MOV	AX, [SI+4]
		MOV	[WORD PTR tfilheader+15h], AX
		MOV	AX, [SI+6]
		MOV	[WORD PTR tfilheader+1Ah], AX
		MOV	EAX, [SI+8]
		MOV	[tarcdataptr], EAX

		XOR	EAX, EAX
		MOV	AX, [WORD PTR tfilheader+18h]
		MOV	[tfillen], EAX

		MOV	[lasthdread], 0
		MOV	[WORD PTR tfilheader+13h], 2048
		CMP	[tfillen], 2048
		JNC	TARC_BlockLenLess
		MOV	AX, [WORD PTR tfillen]
		MOV	[WORD PTR tfilheader+13h], AX
TARC_BlockLenLess:
		MOV	[BYTE PTR tfilheader+17h], 0ffh
		MOV	[BYTE PTR tfilheader+11h], 0
		CMP	[tfillen], 2049
		JNC	TARC_NotLast
		MOV	[BYTE PTR tfilheader+11h], 0ffh
TARC_NotLast:
		MOV	[BYTE PTR tfilheader+10h], 1

		XOR	EAX, EAX
		MOV	BX, OFFSET tfilheader
		MOV	CX, 42h
		XOR	DX, DX
TARC_BuildChk:
		LODSB
		ADD	DX, AX
		LOOP	TARC_BuildChk
		MOV	[WORD PTR tfilheader+43h], DX

		RET

TARC_ArchiveEnd:
		INC	[tfilptr]
		CALL	GetTapeFile
		RET

; ________________________________________________________________________

CloseTape:
		CMP	[tapeha], 0ffffh
		JE	CLTA_End
		PUSHAD
		MOV	BX, [tapeha]
		MOV	AX, 3e00h
		INT	21h
		POPAD
CLTA_End:
		RET

; ________________________________________________________________________

CASInOpen:
		MOV	sFree, [WORD PTR sysstat]
		AND	sFree, 4
		JNZ	CASOops
		BT	AX, 8
		JC	CAIO_COK
		CALL	sz80performret
		JMP	simz80l
CAIO_COK:
		CALL	sz80performpushhl

		PUSHAD
		MOV	BX, [CASInH]
		MOV	DX, 0
CAIO_TestLess12:
		MOV	AL, [BYTE PTR ES:BX]
		CMP	AL, 0
		JE	CAIO_Less12
		CMP	AL, 32
		JNE	CAIO_TL12_NoSpace
		CMP	[BYTE PTR ES:BX+1], 32		; we can compact 2 spaces to one,  since
		JE	CAIO_TL12_Space			; neither combination is allowed in DOS
		CMP	[BYTE PTR ES:BX+1], '.'
		JE	CAIO_TL12_Space
		CMP	[BYTE PTR ES:BX+1], 0
		JNE	CAIO_TL12_NoSpace
CAIO_TL12_Space:
		PUSH	BX
		MOV	DI, BX
		INC	BX
CAIO_TL12_SPCLoop:
		MOV	AL, [ES:BX]
		MOV	[ES:DI], AL
		INC	DI
		INC	BX
		CMP	AL, 0
		JNE	CAIO_TL12_SPCLoop
		POP	BX
		DEC	BX
		DEC	DX
CAIO_TL12_NoSpace:
		INC	DX
		INC	BX
		CMP	DX, 13
		JNE	CAIO_TestLess12
		JMP	CAIO_End
CAIO_Less12:
		MOV	[CASNameLen], DX

		MOV	DI, [CASInH]

		PUSH	DX
		CALL	CAIO_SearchName
		POP	DX
		CMP	BX, 0ffffh
		JNE	CAIO_Found

		MOV	DX, [CASNameLen]
		CMP	DX, 9
		JNC	CAIO_CheckArcs
		MOV	[DWORD PTR ES:EDI+EDX], 'SAB.'
		PUSH	DX
		CALL	CAIO_SearchName
		POP	DX
		CMP	BX, 0ffffh
		JNE	CAIO_Found

		MOV	DX, [CASNameLen]
		CMP	DX, 9
		JNC	CAIO_End
		MOV	[DWORD PTR ES:EDI+EDX], 'NIB.'

		PUSH	DX
		CALL	CAIO_SearchName
		POP	DX
		CMP	BX, 0ffffh
		JNE	CAIO_Found
CAIO_CheckArcs:
		MOV	BX, [tfilptr]
		MOV	[oldtfilptr], BX
		MOV	DX, [CASNameLen]
		MOV	[DWORD PTR ES:EDI+EDX], 0
		PUSH	DX
		CALL	CAIO_SearchInArcs
		POP	DX
		CMP	BX, 0ffffh
		JNE	CAIO_End

		MOV	[DWORD PTR ES:EDI+EDX], 'SAB.'
		PUSH	DX
		CALL	CAIO_SearchInArcs
		POP	DX
		CMP	BX, 0ffffh
		JNE	CAIO_End

		MOV	[DWORD PTR ES:EDI+EDX], 'NIB.'
		PUSH	DX
		CALL	CAIO_SearchInArcs
		POP	DX
		CMP	BX, 0ffffh
		JNE	CAIO_End

		MOV	[DWORD PTR ES:EDI+EDX], 0
		MOV	BX, [oldtfilptr]
		MOV	[tfilptr], BX
		CALL	GetTapeFile
		JMP	CAIO_End
CAIO_Found:
		MOV	[tfilptr], BX
		CALL	GetTapeFile
CAIO_End:
		POPAD
		JMP	simz80l

; ________________________________________________________________________

CAIO_SearchName:					; assumes ES: == rambase ???
		MOV	SI, OFFSET tapetbl
		MOV	CX, [tfilcnt]
		MOV	BX, 0
CAIO_SN_Loop:
		PUSH	DS
		MOV	DX, SEG tapetbl
		MOV	DS, DX
		PUSH	SI
		PUSH	DI
		MOV	DX, 0
		CMP	[DWORD PTR DS:SI+12], 0ffffffffh	; avoid tarcs
		JE	CAIO_SN_NotEqual
CAIO_SN_Cmp:
		CMP	DX, 12
		JE	CAIO_SN_Found
		MOV	AL, [DS:SI]
		CMPSB
		JNE	CAIO_SN_NotEqual
		CMP	AL, 0
		JE	CAIO_SN_Found
		INC	DX
		JMP	CAIO_SN_Cmp
CAIO_SN_NotEqual:
		POP	DI
		POP	SI
		POP	DS
		ADD	SI, 16
		INC	BX
		LOOP	CAIO_SN_Loop
		MOV	BX, 0ffffh
		RET
CAIO_SN_Found:
		POP	DI
		POP	SI
		POP	DS
		RET

; ________________________________________________________________________

CAIO_SearchInArcs:
		PUSH	FS
		MOV	SI, SEG tapetbl
		MOV	FS, SI

		MOV	SI, OFFSET tapetbl
		MOV	CX, [tfilcnt]
		MOV	BX, 0
CAIO_SIA_Loop:
		CMP	[DWORD PTR FS:SI+12], 0ffffffffh	; only tarcs
		JNE	CAIO_SIA_NextFile
		MOV	[tfilptr], BX
		CALL	GetTapeFile
CAIO_SIA_CheckArc:
		CMP	[tfilptr], BX
		JNE	CAIO_SIA_NextFile
		MOV	DX, 0
		PUSH	SI
		PUSH	DI
		MOV	SI, OFFSET tfilheader
CAIO_SIA_Cmp:
		CMP	DX, 12
		JE	CAIO_SIA_Found
		MOV	AL, [SI]
		CMPSB
		JNE	CAIO_SIA_NotEqual
		CMP	AL, 0
		JE	CAIO_SIA_Found
		INC	DX
		JMP	CAIO_SIA_Cmp
CAIO_SIA_NotEqual:
		POP	DI
		POP	SI
		CALL	GetNextTarcFile
		JMP	CAIO_SIA_CheckArc
CAIO_SIA_NextFile:
		ADD	SI, 16
		INC	BX
		LOOP	CAIO_SIA_Loop
		MOV	BX, 0ffffh
		POP	FS
		RET
CAIO_SIA_Found:
		POP	DI
		POP	SI
		POP	FS
		RET

; ________________________________________________________________________

CASRead:
		MOV	sFree, [WORD PTR sysstat]
		AND	sFree, 4
		JNZ	CASOops
		CMP	[tapeha], 0ffffh
		JE	CAS_Err
		CMP	AL, 2ch
		JE	CASR_Header
		CMP	AL, 16h
		JE	CASR_Block
CASR_Block:
		CMP	[tfisarc], 0
		JE	CASR_Block_Norm
		PUSHAD
		MOV	CX, [WORD PTR tarcdataptr+2]
		MOV	DX, [WORD PTR tarcdataptr]
		MOV	BX, [tapeha]
		MOV	AX, 4200h
		INT	21h
		MOV	CX, 840h
		MOV	DX, OFFSET TapeLoadBuf+6
		MOV	BX, [tapeha]
		MOV	AX, 3F00h
		INT	21h
		XOR	ECX, ECX
		MOV	CX, [WORD PTR TapeLoadBuf+6]
		ADD	[tarcdataptr], ECX
		CMP	CX, 840h
		JNC	CASR_BlockRead
		MOV	[DWORD PTR TapeLoadBuf], 'XURC'
		MOV	[DWORD PTR TapeLoadBuf+4], 'KCAP'
		PUSH	ES
		PUSH	DS
		POP	ES
		MOV	SI, OFFSET TapeLoadBuf
		MOV	DI, OFFSET TapeBuffer
		MOV	CX, 800h
		CALL	FAR UnpackArea
		POP	ES
		POPAD
		JMP	CASR_BlockRead
CASR_Block_Norm:
		PUSHAD
		MOV	CX, [WORD PTR tfilheader+13h]
		MOV	DX, OFFSET TapeBuffer
		MOV	BX, [tapeha]
		MOV	AX, 3F00h
		INT	21h
		POPAD
CASR_BlockRead:
		PUSHAD
		MOV	SI, OFFSET TapeBuffer
		CMP	sDE, 0
		JNE	CASR_CopyBlock
		MOV	sDE, [WORD PTR tfilheader+13h]
		JCXZ	CASR_BlockCopied
CASR_CopyBlock:
		MOV	AL, [SI]
		CALL	sz80wbhlAL
		INC	SI
		INC	nsHL
		DEC	sDE
		JNE	CASR_CopyBlock
CASR_BlockCopied:
		CALL	AdjustHeader
		POPAD
		JMP	CASR_End

; ________________________________________________________________________

CASR_Header:
		PUSHAD
		CMP	[lasthdread], 0
		JE	CASR_FilePosOK
		CMP	[tfillen], 2048
		JC	CASR_Adjust
		MOV	BX, [tapeha]
		MOV	AX, 4201h
		XOR	CX, CX
		MOV	DX, 2048
		INT	21h
		POPAD
		PUSHAD
CASR_Adjust:
		CALL	AdjustHeader
CASR_FilePosOK:
		MOV	[lasthdread], 1
		MOV	SI, OFFSET tfilheader
CASR_CopyHeader:
		MOV	AL, [SI]
		CALL	sz80wbhlAL
		INC	SI
		INC	nsHL
		DEC	sDE
		JNE	CASR_CopyHeader
		POPAD
CASR_End:
		OR	AH, 1
		MOV	sBC, 1
		MOV	sPC, [CAScont]
		CALL	sz80InitPCSeg
		JMP	simz80l

; ________________________________________________________________________

AdjustHeader:
		PUSH	AX
		SUB	[tfillen], 2048
		JZ	ADJH_NewFile
		JC	ADJH_NewFile
		MOV	AX, [WORD PTR tfilheader+13h]
		MOV	[BYTE PTR tfilheader+17h], 0
		MOV	[BYTE PTR tfilheader+11h], 0
		CMP	[tfillen], 2049
		JNC	ADJH_NotLast
		MOV	[BYTE PTR tfilheader+11h], 0ffh
ADJH_NotLast:
		MOV	AX, [WORD PTR tfillen]
		CMP	AX, 2048
		JNC	ADJH_BlockLenLess
		MOV	[WORD PTR tfilheader+13h], AX
ADJH_BlockLenLess:
		INC	[BYTE PTR tfilheader+10h]
		JMP	ADJH_End
ADJH_NewFile:
		CMP	[tfisarc], 0
		JE	ADJH_NormFile
		CALL	GetNextTarcFile
		JMP	ADJH_End
ADJH_NormFile:
		INC	[tfilptr]
		CALL	GetTapeFile
ADJH_End:
		POP	AX
		MOV	[lasthdread], 0
		RET

; ________________________________________________________________________

CAS_Err:
		MOV	AX, 100h
		CALL	sz80performret
		JMP	simz80l

; ________________________________________________________________________

CASWrite:
		MOV	sFree, [WORD PTR sysstat]
		AND	sFree, 4
		JNZ	CASOops
		XOR	AL, AL
		AND	AH, 0feh
		CALL	sz80performret
		JMP	simz80l

; ________________________________________________________________________

CASCheck:
		MOV	sFree, [WORD PTR sysstat]
		AND	sFree, 4
		JNZ	CASOops
		XOR	AL, AL
		AND	AH, 0feh
		CALL	sz80performret
		JMP	simz80l

; ________________________________________________________________________

CASOops:
		JMP	simz80l

; ________________________________________________________________________

ENDS

SEGMENT _data	PAGE PUBLIC 'DATA'

tapedir		db 'tape\'
tapname		db 16 DUP (0)

tapecard	db 'tape\*.*', 0

		EVEN
tapeha		dw 0
tfilcnt		dw 0

		EVEN
CAScont		dw	2a72h
CASInH		dw	0b807h
CASNameLen	dw	0

tfilptr		dw	0
tfiloff		dw	0
tfilheader	db	128 DUP (1)
tfillen		dd	0
lasthdread	dw	0

tfisarc		db	0
tarcfilenum	db	0
tarcdiroffs	dd	0
tarcdataptr	dd	0
oldtfilptr	dw	0

TapeBuffer	dw	800h DUP (?)
TapeLoadBuf	dw	800h DUP (?)

; ________________________________________________________________________

ENDS

SEGMENT _stack	PARA STACK 'STACK'

; ________________________________________________________________________

ENDS

SEGMENT tables	PRIVATE PARA

tapetbl		dd 4000 DUP (?)

tables_end	dw	?

ENDS

END
