; AY-3-8912 Programmable Sound Generator emulation for CPE
; SoundBlaster module
; Copyright (c) 1996,97 by Ulrich Doewich
; cyrel@interlog.com

;  v0.01       Jun. 20, 1996 - 23:10
;  v0.02       Jun. 21, 1996 - 23:35
;  v0.03       Jun. 25, 1996 - 21:44   noise emulation + tone period = 0 case
;  v0.04       Jun. 25, 1996 - 23:51   improved tone/noise frequency emulation
;  v0.05       Jun. 26, 1996 - 23:41   envelope emulation completed
;  v0.06       Jun. 27, 1996 - 22:51   cleanup + jump table
;  v0.07       Jun. 28, 1996 - 20:38   logarithmic amplitude table
;  v0.08       Jun. 30, 1996 - 11:44   corrected envelopes
;  v0.09       Jul.  6, 1996 - 13:15   rewrote mixing engine

;  v1.00       Jul.  6, 1996 - 13:43   ready for 1st public release
;  v1.01       Jul.  9, 1996 - 12:27   fixed audible tone period range
;  v1.02       Aug. 16, 1996 - 15:35   moved DMA buffer to stack segment
;  v1.03       Aug. 24, 1996 - 12:12   eliminated mixingblock
;  v1.04       Aug. 26, 1996 - 23:25   made DMA buffer length user definable
;  v1.05       Oct.  7, 1996 - 15:34   DMA output paused after starting DAC
;  v1.06       Nov. 13, 1996 - 22:10   support for all DSP versions
;  v1.07       Nov. 25, 1996 - 21:31   fixed DSP v4.xx code
;  v1.08       Jan. 26, 1997 - 19:52   removed DSP v2.01-3.xx specific code
;  v1.09       Mar. 24, 1997 - 16:55   pause & continue now check usesound

ideal
P386

TC_22kHzMONO   equ     0d3h            ; 256 - (1000000 / 22050)
TC_22kHzSTEREO equ     0e9h            ; 256 - (1000000 / (2 * 22050))
TC_44kHzMONO   equ     0e9h            ; 256 - (1000000 / 44100)
TC_44kHzSTEREO equ     0f4h            ; 256 - (1000000 / (2 * 44100))

DMA_MASKPORT   equ     0ah

RESET_PORT     equ     06h
READ_PORT      equ     0ah
WRITE_PORT     equ     0ch
POLL_PORT      equ     0eh

; from ipe1.asm
extrn          SCinstalled:WORD, SCport:WORD, SCirq:WORD, SCdma:WORD
extrn          DMAblocklen:WORD, SCsrate:WORD, stereo_flag:WORD, usesound:WORD

; from snd.asm
extrn          init_SC:PROC, setup_DMA:PROC, init_mixing:PROC
extrn          install_handler:PROC, uninstall_handler:PROC
extrn          DMA_stopmask:BYTE

public         SB_reset, SB_shutdown, SB_pause, SB_continue, SB_clrINT

group          DGROUP _stack, _data

segment        _text page public 'CODE'
assume         cs:_text
assume         ds:DGROUP

; ________________________________________________________________________

;  read_DSP    retrieve value from SB DSP

; OUT:
;      al      value read from SB DSP

; USES:
;      al, dx

read_DSP:
               mov     dx, [SCport]
               add     dx, POLL_PORT
readDSP_loop:
               in      al, dx
               or      al, al
               jns     readDSP_loop
               sub     dl, 4
               in      al, dx
               ret

; ________________________________________________________________________

;  write_DSP   write given value to SB DSP

; IN:
;      al      parameter to be written to SB DSP

; USES:
;      al, bl, dx

write_DSP:
               mov     bl, al
               mov     dx, [SCport]
               add     dx, WRITE_PORT
writeDSP_loop:
               in      al, dx
               or      al, al
               js      writeDSP_loop
               mov     al, bl
               out     dx, al
               ret

; ________________________________________________________________________

;  reset_DSP   reset SB DSP to default state

; OUT:
;      carry   set if failed

; USES:
;      al, cx, dx

reset_DSP:
               mov     dx, [SCport]
               add     dx, RESET_PORT
               mov     al, 1
               out     dx, al
               sub     al, al
delay:
               dec     al
               jnz     delay
               out     dx, al
               sub     cx, cx
resetDSP_loop:
               call    read_DSP
               cmp     al, 0aah
               je      resetDSP_done
               loop    resetDSP_loop
resetDSP_failed:
               stc
               ret
resetDSP_done:
               clc
               ret

; ________________________________________________________________________

;  init_SB     reset SB DSP and determine DSP version

; OUT:
;      carry   set if failed

init_SB:
               call    reset_DSP
               jnc     initSB_resetOK                   ; failed to reset DSP?
initSB_failed:
               mov     [SCinstalled], 0
               ret
initSB_resetOK:
               mov     ax, 0e1h                         ; get DSP version
               call    write_DSP
               call    read_DSP                         ; read major..
               mov     ah, al
               call    read_DSP                         ; ..and minor number
               cmp     ax, 200h                         ; at least v2.00?
               jge     initSB_validDSP
               stc
               jmp     initSB_failed
initSB_validDSP:
               mov     [SB_type], ax
               jmp     init_SC

; ________________________________________________________________________

start_DAC:
               call    setup_DMA

               cmp     [SB_type], 400h
               jb      sDAC_below400
sDAC_400:
               mov     al, 41h                          ; set DSP transfer rate
               call    write_DSP
               mov     ax, 2256h                        ; 22kHz
               cmp     [SCsrate], 0
               je      sDAC_400setrate
               mov     ax, 44ach                        ; 44kHz
sDAC_400setrate:
               call    write_DSP
               mov     al, ah
               call    write_DSP

               mov     al, 0c6h                         ; 8 bit output
               call    write_DSP
               mov     al, 0                            ; unsigned mono
               cmp     [stereo_flag], 0
               je      sDAC_400cont
               mov     al, 20h                          ; unsigned stereo
sDAC_400cont:
               call    write_DSP
               mov     ax, [DMAblocklen]
               dec     ax
               call    write_DSP                        ; set DSP transfer size
               mov     al, ah
               call    write_DSP
               jmp     sDAC_exit

; ........................................................................

sDAC_below400:
               mov     al, 40h                          ; set DSP transfer time
               call    write_DSP                        ;  constant
               cmp     [stereo_flag], 0
               jne     sDAC_b400stereo
               mov     al, TC_22kHzMONO
               cmp     [SCsrate], 0
               je      sDAC_b400loadTC
               mov     al, TC_44kHzMONO
               jmp     sDAC_b400loadTC
sDAC_b400stereo:
               mov     al, TC_22kHzSTEREO
               cmp     [SCsrate], 0
               je      sDAC_b400loadTC
               mov     al, TC_44kHzSTEREO
sDAC_b400loadTC:
               call    write_DSP

               mov     al, 48h                          ; set DSP block transfer
               call    write_DSP                        ;  size
               mov     ax, [DMAblocklen]
               cmp     [stereo_flag], 0
               je      sDAC_b400DMAsize
               shr     ax, 1
sDAC_b400DMAsize:
               dec     ax
               call    write_DSP
               mov     al, ah
               call    write_DSP

               cmp     [stereo_flag], 0
               je      sDAC_b400cont
               mov     dx, [SCport]
               add     dx, 4
               mov     al, 0eh                          ; set stereo mode
               out     dx, al
               inc     dx
               in      al, dx
               mov     [output_filter], al
               or      al, 2
               out     dx, al

;               mov     al, 14h                          ; output silent byte
;               call    write_DSP
;               mov     al, 0
;               call    write_DSP
;               mov     al, 0
;               call    write_DSP

               mov     dx, [SCport]
               add     dx, 4
               mov     al, 0eh                          ; preserve filter status
               out     dx, al
               inc     dx
               in      al, dx
               or      al, 20h                          ; turn filter off
               out     dx, al
sDAC_b400cont:
               mov     al, 1ch                          ; start auto-init DMA
               call    write_DSP                        ;  transfer
SDAC_exit:
               jmp     SB_pause

; ________________________________________________________________________

stop_DAC:
               mov     al, 0d3h                         ; turn DAC speaker off
               call    write_DSP

               cmp     [SB_type], 400h
               jb      stopDAC_normal
               cmp     [stereo_flag], 0
               je      stopDAC_normal
               mov     dx, [SCport]
               add     dx, 4
               mov     al, 0eh
               out     dx, al
               inc     dx
               mov     al, [output_filter]
               and     al, 0fdh                         ; set mono mode
               out     dx, al
stopDAC_normal:
               mov     al, 0dah                         ; exit auto-init DMA
               call    write_DSP                        ;  mode
stopDAC_exit:
               mov     dx, DMA_MASKPORT
               mov     al, [DMA_stopmask]
               out     dx, al                           ; stop DMA controller
               ret

; ________________________________________________________________________

SB_reset:
               call    init_SB
               jc      SBr_exit

               call    init_mixing
               call    install_handler

               call    start_DAC
SBr_exit:
               ret

; ________________________________________________________________________

SB_shutdown:
               cmp     [SCinstalled], 0
               je      SBs_exit

               call    stop_DAC
               call    uninstall_handler
               call    reset_DSP
SBs_exit:
               ret

; ________________________________________________________________________

SB_pause:
               cmp     [usesound], 0
               je      SBp_exit

               pushad
               mov     al, 0d3h                         ; turn DAC speaker off
               call    write_DSP
               mov     al, 0d0h                         ; pause DMA transfer
               call    write_DSP
               popad
SBp_exit:
               ret

; ________________________________________________________________________

SB_continue:
               cmp     [usesound], 0
               je      SBc_exit

               pushad
               mov     al, 0d1h                         ; turn DAC speaker on
               call    write_DSP
               mov     al, 0d4h                         ; resume DMA transfer
               call    write_DSP
SBc_cont:
               popad
SBc_exit:
               ret

; ________________________________________________________________________

SB_clrINT:
               mov     dx, [SCport]                     ; acknowledge interrupt
               add     dx, POLL_PORT                    ;  with SB DSP
               in      al, dx
               ret

; ________________________________________________________________________

ends

segment        _data page public 'DATA'

SB_type        dw      0
output_filter  db      0

ends

; ________________________________________________________________________

segment        _stack para stack 'STACK'
ends

end

