10 INK 1,26:INK 0,0:PAPER 1:PEN 0:MODE 2:CLS:BORDER 10
20 PRINT "Do you want to send the assembler help file to screen or printer (S/P)"
30 i$=INKEY$:IF i$="" THEN 30
40 IF UPPER$(i$)="P"THEN n=8 ELSE IF UPPER$(i$)<>"S"THEN 30
50 CLS:PRINT#n,"                                  ASSEMBLER
60 PRINT#n,"
70 PRINT#n,"The Assembler is available for 464 and 6128/664, and each machine has versions
80 PRINT#n,"to load at &9000 (for stand-alone use) or &6000 (for use with the MONitor code
90 PRINT#n,"present).
100 PRINT#n,"
110 PRINT#n,"The loader program 'ASSEMBLE.BAS' will test machine type and HIMEM, and if the
120 PRINT#n,"latter permits, allow a choice of loading the code high or low. From this
130 PRINT#n,"choice, or from the results of the testing, the loader will install an
140 PRINT#n,"appropriate version of the code and initialise the RSXs |ASMBL and |LISTLBLS.
150 PRINT#n,"The code occupies &F00 bytes, so if MEMORY has been set too low (below &6F00),
160 PRINT#n,"a warning message will be displayed and the code not loaded; MEMORY should be
170 PRINT#n,"reset above &6EFF (the 464 will have to be reset for this), and 'ASSEMBLE'
180 PRINT#n,"re-run.
190 PRINT#n,"
200 PRINT#n,"The code can also be loaded manually after setting MEMORY to &8FFF or &5FFF for
210 PRINT#n,"the &9000 or &6000 versions respectively. The Code files are: 'ASMB9000.464',
220 PRINT#n,"ASMB6000.464', ASMB9000.128', ASMB6000.128'; the loading point is given by the
230 PRINT#n,"4 digits in the Filename, and the computer type by the Extension (use '.128'
240 PRINT#n,"versions for 664 machines). To initialise the RSXs, just use CALL &9000 or
250 PRINT#n,"&6000 as the case may be.
260 PRINT#n,"
270 PRINT#n,"FEATURES
280 PRINT#n,"
290 PRINT#n,"The Assembler is an updated version of the one supplied on Disc with the first
300 PRINT#n,"Birthday issue of PRINT-OUT and provides an easy way to enter machine code
310 PRINT#n,"programs into memory. 
320 PRINT#n,"
330 PRINT#n,"Although a simple implementation, it is a powerful tool, able to handle all Z80
340 PRINT#n,"instructions including those considered 'illegal', ie. those operating on the
350 PRINT#n,"high and low bytes of the Index Registers IX and IY, plus the extra rotation
360 PRINT#n,"instructions (which are designated as SLL).
370 PRINT#n,"
380 PRINT#n,"In addition to m/c instructions, the Assembler also allows ASCII, DEFW (words)
390 PRINT#n,"and DEFB (bytes) to be assembled, and even mixed lists of all three without
400 PRINT#n,"changing the Directive (see below for precise details). An extension of these
410 PRINT#n,"is to assemble ASCII with bit 7 set in the last character of each name entered.
420 PRINT#n,"
430 PRINT#n,"It has certain short-cuts built in to make the task of typing-in slightly less
440 PRINT#n,"arduous; eg. these allow a final bracket to be left off, or a comma or space to
450 PRINT#n,"be omitted provided there is an opening or closing bracket or & at that point.
460 PRINT#n,"
470 PRINT#n,"Only simple maths (+ or -) are catered for but with no limit on the number of
480 PRINT#n,"terms involved (apart from that of the length of a BASIC line).
490 PRINT#n,"
500 PRINT#n,"ASSEMBLY LANGUAGE PROGRAMS
510 PRINT#n,"
520 PRINT#n,"Assembly Language programs (ALPs) are entered in a BASIC program as a sequence
530 PRINT#n,"of statements preceded by the short REM ('). Upper or lower case can be used -
540 PRINT#n,"Instructions and Directives are changed to upper case and Labels to lower on
550 PRINT#n,"assembling.
560 PRINT#n,"
570 PRINT#n,"An Assembler statement consists of the following sequence of fields (any of
580 PRINT#n,"which may be omitted):
590 PRINT#n,"  1 a label (preceded by a . )
600 PRINT#n,"  2 a complete Z80 Instruction, or a Directive with parameters or list, or a   
610 PRINT#n,"    label assignment
620 PRINT#n,"  3 a comment of any reasonable length starting with a ; and ending at a : or  
630 PRINT#n,"    the end of the BASIC line (whichever occurs first)
640 PRINT#n,"Below is an sample Assembly Language program for printing the word "CHR$(34)"Hello"CHR$(34)":
650 PRINT#n,"
660 PRINT#n,"10 MEMORY &7FFF
670 PRINT#n,"20 |ASMBL
680 PRINT#n,"30 'ORG &8000
690 PRINT#n,"40 '.prtchr EQU &BB5A     ;the Firmware's TXT OUTPUT call
700 PRINT#n,"50 '.prtstr LD HL,text
710 PRINT#n,"60 '.nxtchr LD A,(HL)
720 PRINT#n,"70 'OR A
730 PRINT#n,"80 'RET Z                 ;to BASIC if all characters have been printed
740 PRINT#n,"90 'CALL prtchr
750 PRINT#n,"100 'INC HL
760 PRINT#n,"110 'JR nxtchr
770 PRINT#n,"120 '.text DEFM "CHR$(34)"Hello"CHR$(34)",0
780 PRINT#n,"130 'END
790 PRINT#n,"140 PRINT
800 PRINT#n,"150 CALL &8000            ;calls the assembled program from BASIC
810 PRINT#n,"
820 PRINT#n,"Although this example shows one statement per line, multiple statements can be
830 PRINT#n,"included in a line with : used as separators (an Assembler statement must not
840 PRINT#n,"straddle a line number or a : ). Each line of statements must be preceded by
850 PRINT#n,"the ' (not each statement).
860 PRINT#n,"When assembling within a BASIC program, the ALP must directly follow an |ASMBL
870 PRINT#n,"command, either on the next line as shown in the example above, or on the same
880 PRINT#n,"line using a BASIC : .
890 PRINT#n,"The first item of the ALP following the |ASMBL must be an ORG assignment. The
900 PRINT#n,"whole of the ALP must follow with no intervening BASIC statements. At the end
910 PRINT#n,"of the ALP, there must be an END directive within a ' statement.
920 PRINT#n,"Several ALPs can be present in various parts of a BASIC program, with BASIC
930 PRINT#n,"statements between, or if a more structured look is required, each ALP can be
940 PRINT#n,"in a sub-routine to be called (using GOSUB) from the main part. If this latter
950 PRINT#n,"form is used, remember that the |ASMBL command will have to be part of the
960 PRINT#n,"sub-routine in order for the ALP to follow it immediately.
970 PRINT#n,"To assemble using |ASMBL as a Direct Command, the ALP must start at the first
980 PRINT#n,"line of the program (eg lines 10 and 20 above cannot be included).
990 PRINT#n,"It is also possible to assemble a short program, with |ASMBL and all the ALP
1000 PRINT#n,"statements present in a Direct Command and not in a BASIC program; again, the
1010 PRINT#n,"ALP must immediately follow the |ASMBL.
1020 PRINT#n,"An ALP in program form can be saved as a BASIC program.
1030 PRINT#n,"
1040 PRINT#n,"The ORG directive takes one or two addresses as parameters. If you provide only
1050 PRINT#n,"one address, the code will be assembled there and any labels incidental to the
1060 PRINT#n,"code will relate to the actual locations where the code is assembled. If a
1070 PRINT#n,"second parameter is present however, the code will be assembled starting at the
1080 PRINT#n,"second address, but all incidental labels will relate as if the code had
1090 PRINT#n,"actually been assembled at the first address; this is essential if the code is
1100 PRINT#n,"intended to be finally located at the first address, but due to something else
1110 PRINT#n,"occupying that area while the assembling is taking place, must temporarily be
1120 PRINT#n,"assembled elsewhere. A typical example is with code intended to be used in a
1130 PRINT#n,"ROM (the final location of this code will be above &C000 which is the area
1140 PRINT#n,"usually occupied by Screen memory).
1150 PRINT#n,"Within one ALP, several ORGs can be used to direct different blocks of code to
1160 PRINT#n,"different destinations. The values used with ORG must not equate to 0, so a
1170 PRINT#n,"Label cannot be used for the first ORG in an ALP.
1180 PRINT#n,"
1190 PRINT#n,"As well as standard mnemonics (the Assembler also acknowledges HIX, LIX, HIY
1200 PRINT#n,"and LIY plus SLL as the illegal registers/instructions), the following
1210 PRINT#n,"Directives are accepted:
1220 PRINT#n,"EQU or =  for assigning values to labels (these values are absolute and not    
1230 PRINT#n,"      varied by the presence of two ORG parameters).
1240 PRINT#n,"DEFW  to show a (list of) two byte value(s) and/or string(s) follows.
1250 PRINT#n,"DEFB  to show a (list of) single byte value(s) and/or string(s) follows.
1260 PRINT#n,"DEFM  to show a (list of) single and/or two byte values and/or strings follows.
1270 PRINT#n,"      Single byte values will be assigned one byte when assembled, and two byte
1280 PRINT#n,"      values will be assigned two (compare this to DEFB and DEFW which only    
1290 PRINT#n,"      assign one or two bytes respectively for each value listed).
1300 PRINT#n,"DEFT  as for DEFM, but last character of each string has bit 7 set (ie
1310 PRINT#n,"      +&80 or +128).
1320 PRINT#n,"DEFS  reserve bytes of room (maximum 255); can be followed by an optional      
1330 PRINT#n,"      second parameter value with which to fill these bytes (defaults to &00)
1340 PRINT#n,"#  to precede a (sequence of) 2 character Hex byte value(s); separators
1350 PRINT#n,"      between values are not necessary, but commas or spaces can be used but   
1360 PRINT#n,"      not & or #.
1370 PRINT#n,"      All other Hex values should be preceded by & or # (a following H or h    
1380 PRINT#n,"      should not be used).
1390 PRINT#n,"$  to signify the address of the start of the current Instruction.
1400 PRINT#n,";  to allow a REM type comment; all characters from the ; to the : or the end  
1410 PRINT#n,"      of the line (whichever occurs first), will be ignored.
1420 PRINT#n,"
1430 PRINT#n,"Strings must be delimited with double inverted commas.
1440 PRINT#n,"Commas should be used as separators between DEFW, DEFB, DEFM and DEFT items,
1450 PRINT#n,"and between ORG and DEFS parameters if two are present. Spaces should be used
1460 PRINT#n,"as separators between labels and Instructions/Directives and comments, and
1470 PRINT#n,"between the two parts of most Instructions.
1480 PRINT#n,"
1490 PRINT#n,"The A register can be omitted from Instructions where no ambiguity can occur
1500 PRINT#n,"(eg ADD D instead of ADD A,D).
1510 PRINT#n,"
1520 PRINT#n,"For any value, simple arithmetic using + and - is allowed with any number of
1530 PRINT#n,"terms (using values, labels, single character strings or $); precedence is
1540 PRINT#n,"strictly left to right. If a single byte value is expected, any excess of 8
1550 PRINT#n,"bits is ignored.
1560 PRINT#n,"
1570 PRINT#n,"A displacement for JR or DJNZ can be entered as an address value, label, or
1580 PRINT#n,"simple offset from the following Instruction.
1590 PRINT#n,"A displacement for (IX+ or (IY+ should be entered as an offset only (ie. not as
1600 PRINT#n,"an address label); the value entered is taken MOD 256 and 2's complement (ie.
1610 PRINT#n,"after reduction of the offset to 8 bits, a value greater than &7F equates to
1620 PRINT#n,"negative).
1630 PRINT#n,"
1640 PRINT#n,"RST instructions require a first parameter from one of the following ranges:
1650 PRINT#n," 0 to 7;       0,8,16,24,32,40,48,56;        &00,&08,&10,&18,&20,&28,&30,&38
1660 PRINT#n,"Some RSTs also require a further address parameter in keeping with CPC usage:
1670 PRINT#n,"these are RST 1, RST 2, RST 3 and RST 5 (or their equivalents).
1680 PRINT#n,"
1690 PRINT#n,"Labels can be of any length, and made up of letters or digits, with the first
1700 PRINT#n,"character a letter. A maximum of 255 labels is allowed with a possible further
1710 PRINT#n,"restraint imposed by lack of space for the Label Table. A leading . is only
1720 PRINT#n,"required when the label is the first field in a statement.
1730 PRINT#n,"
1740 PRINT#n,"LIST OF Z80 INSTRUCTIONS
1750 PRINT#n,"
1760 PRINT#n,"ADC       CPI       EXX       JP        OR        RET       RRA       SLL
1770 PRINT#n,"ADD       CPIR      HALT      JR        OTDR      RETI      RRC       SRA
1780 PRINT#n,"AND       CPL       IM        LD        OTIR      RETN      RRCA      SRL
1790 PRINT#n,"BIT       DAA       IN        LDD       OUT       RL        RRD       SUB
1800 PRINT#n,"CALL      DEC       INC       LDDR      OUTD      RLA       RST       XOR
1810 PRINT#n,"CCF       DI        IND       LDI       OUTI      RLC       SBC
1820 PRINT#n,"CP        DJNZ      INDR      LDIR      POP       RLCA      SCF
1830 PRINT#n,"CPD       EI        INI       NEG       PUSH      RLD       SET
1840 PRINT#n,"CPDR      EX        INIR      NOP       RES       RR        SLA
1850 PRINT#n,"
1860 PRINT#n,"LIST OF REGISTERS
1870 PRINT#n,"
1880 PRINT#n,"A         B         C         D         E         H         L         (HL)
1890 PRINT#n,"AF        BC        DE        HL        SP        IX        IY
1900 PRINT#n,"(BC)      (DE)      (IX)      (IY)      (SP)
1910 PRINT#n,"(IX+displacement)   (IY+displacement)
1920 PRINT#n,"HIX       LIX       HIY       LIY
1930 PRINT#n,"(C)       F         R         I
1940 PRINT#n,"
1950 PRINT#n,"LIST OF CONDITIONS
1960 PRINT#n,"
1970 PRINT#n,"C         NC        Z         NZ        M         P         PE        PO
1980 PRINT#n,"
1990 PRINT#n,"LIST OF CONSTANTS (these need to be entered as actual values or labels etc)
2000 PRINT#n,"
2010 PRINT#n,"n                 single byte (eight bit) value (-255 to +255)
2020 PRINT#n,"nn                address or two byte (sixteen bit) value (-65535 to +65535)
2030 PRINT#n,"(n)               part address of an Input/Output Port
2040 PRINT#n,"(nn)              address used as source or destination for data
2050 PRINT#n,"+/- displacement) used with (IX  or (IY ; should be within -128 to + 127
2060 PRINT#n,"displacement      used with JR or DJNZ; should equate to within -128 to +127   
2070 PRINT#n,"                   bytes of following instruction
2080 PRINT#n,"
2090 PRINT#n,"USING THE ASSEMBLER
2100 PRINT#n,"
2110 PRINT#n,"On using '|ASMBL' a two pass assembly will be attempted.
2120 PRINT#n,"On the second pass, as each block of code within the ALP is completed, its
2130 PRINT#n,"start address will be displayed together with the address of the byte following
2140 PRINT#n,"its end; to turn off this printing (eg. within a BASIC program) use:
2150 PRINT#n,"'|ASMBL, <anything>'.
2160 PRINT#n,"If a serious error is present within the ALP, the assembly will stop at the
2170 PRINT#n,"point of failure during the first pass and print the line number where the
2180 PRINT#n,"error occurs together with an error message. On EDITing that line, a block
2190 PRINT#n,"character (a shaded character for the 464) will be printed over or just after
2200 PRINT#n,"most errors; after correction, this block must be deleted, the original
2210 PRINT#n,"character re-inserted if necessary, and '|ASMBL' used again. Line 0 signifies
2220 PRINT#n,"that the error occurs in the Direct Command as there is no ALP present as a
2230 PRINT#n,"program.
2240 PRINT#n,"If the error is the over- or non-use of a label, a list of such labels will be
2250 PRINT#n,"printed before the second pass. Although assembly will be completed, the label
2260 PRINT#n,"errors 'Undefined' and 'Redefined' must be rectified and '|ASMBL' re-used.
2270 PRINT#n,"
2280 PRINT#n,"LIST OF ERRORS
2290 PRINT#n,"
2300 PRINT#n,"No ORG                  No ORG at start of ALP, or address equates to &0000
2310 PRINT#n,"No REM                  No ' at start of a program line, or no ALP present
2320 PRINT#n,"No END                  END missing
2330 PRINT#n,"Bad Instr               Incorrect mnemonic used
2340 PRINT#n,"Bad Reg                 Invalid Register entered for Instruction
2350 PRINT#n,"Bad Number              Decimal/Hex number is too big or has wrong characters
2360 PRINT#n,"No Table Room           more than 255 labels, or all Label Table room used up
2370 PRINT#n,"                          or table overwritten by other BASIC operations
2380 PRINT#n,"Displ Too Great         JR or DJNZ displacement outside range -128 to + 127
2390 PRINT#n,"Unused                  Label defined but not used (acceptable)
2400 PRINT#n,"Undefined               Label used but not defined by assignment or occurrence
2410 PRINT#n,"Redefined               Label defined more than once
2420 PRINT#n,"
2430 PRINT#n,"LISTING LABELS
2440 PRINT#n,"
2450 PRINT#n,"A list of labels together with their assigned values/addresses, can be shown by
2460 PRINT#n,"using '|LISTLBLS'. The display is temporarily halted after each screenful is
2470 PRINT#n,"printed - any key will display the next screenful or ESC will exit to BASIC.
