;; Tarzan - Martech - 1986
;; 
;; speedlock v1 style blocks with a v2 style block
;; in the middle

bb2e d1        pop     de
bb2f 08        ex      af,af'
bb30 fe01      cp      $01				;; check if error has occured

bb32 067f      ld      b,$7f			;; set border to black
bb34 3e10      ld      a,$10	
bb36 ed79      out     (c),a
bb38 3e54      ld      a,$54
bb3a ed79      out     (c),a
bb3c d8        ret     c

;; load failed
bb3d 06f6      ld      b,$f6
bb3f af        xor     a
bb40 ed79      out     (c),a			;; stop cassette

bb42 dd360000  ld      (ix+$00),$00		;; fill memory
bb46 dd2b      dec     ix
bb48 18f8      jr      $bb42            

;;---------------------------------------------------
;; get edge

bb4a 3d        dec     a
bb4b 20fd      jr      nz,$bb4a         ; (-$03)
bb4d a7        and     a
bb4e 24        inc     h
bb4f c8        ret     z

bb50 06f5      ld      b,$f5
bb52 ed78      in      a,(c)
bb54 a9        xor     c
bb55 e680      and     $80
bb57 28f5      jr      z,$bb4e          ; (-$0b)
bb59 067f      ld      b,$7f
bb5b 3e10      ld      a,$10
bb5d ed79      out     (c),a
bb5f 79        ld      a,c
bb60 2f        cpl     
bb61 4f        ld      c,a
bb62 79        ld      a,c
bb63 1f        rra     
bb64 3e2a      ld      a,$2a
bb66 17        rla     
bb67 ed79      out     (c),a
bb69 37        scf     
bb6a c9        ret     

;;--------------------------------------------------

bb6b 06f6      ld      b,$f6
bb6d 3e10      ld      a,$10
bb6f ed79      out     (c),a			;; start cassette motor

bb71 2132bb    ld      hl,$bb32
bb74 e5        push    hl
bb75 06f5      ld      b,$f5
bb77 ed78      in      a,(c)
bb79 e680      and     $80
bb7b 4f        ld      c,a
bb7c cd4abb    call    $bb4a
bb7f 30fb      jr      nc,$bb7c         ; (-$05)
bb81 211504    ld      hl,$0415
bb84 10fe      djnz    $bb84            ; (-$02)
bb86 2b        dec     hl
bb87 7c        ld      a,h
bb88 b5        or      l
bb89 20f9      jr      nz,$bb84         ; (-$07)
bb8b 3e0a      ld      a,$0a
bb8d cd4abb    call    $bb4a
bb90 30ea      jr      nc,$bb7c         ; (-$16)
bb92 26c4      ld      h,$c4
bb94 3e1c      ld      a,$1c
bb96 cd4abb    call    $bb4a
bb99 30e1      jr      nc,$bb7c         ; (-$1f)
bb9b 3eda      ld      a,$da
bb9d bc        cp      h
bb9e 38f2      jr      c,$bb92          ; (-$0e)
bba0 26c4      ld      h,$c4
bba2 3e1c      ld      a,$1c
bba4 cd4abb    call    $bb4a
bba7 30d3      jr      nc,$bb7c         ; (-$2d)
bba9 3eda      ld      a,$da
bbab bc        cp      h
bbac 38e4      jr      c,$bb92          ; (-$1c)
bbae fd2165bd  ld      iy,$bd65
bbb2 fd6e00    ld      l,(iy+$00)
bbb5 26c4      ld      h,$c4
bbb7 3e1c      ld      a,$1c
bbb9 cd4abb    call    $bb4a
bbbc 30be      jr      nc,$bb7c         ; (-$42)
bbbe 3ed7      ld      a,$d7
bbc0 bc        cp      h
bbc1 30dd      jr      nc,$bba0         ; (-$23)
bbc3 2c        inc     l
bbc4 20ef      jr      nz,$bbb5         ; (-$11)
bbc6 2670      ld      h,$70
bbc8 3e1c      ld      a,$1c
bbca cd4abb    call    $bb4a
bbcd 30ad      jr      nc,$bb7c         ; (-$53)
bbcf 3e1c      ld      a,$1c
bbd1 cd4abb    call    $bb4a
bbd4 30a6      jr      nc,$bb7c         ; (-$5a)
bbd6 7c        ld      a,h
bbd7 fecd      cp      $cd
bbd9 300e      jr      nc,$bbe9         ; (+$0e)
bbdb fe9c      cp      $9c
bbdd 30cf      jr      nc,$bbae         ; (-$31)
bbdf fd23      inc     iy
bbe1 fd7d      ld      a,iyl
bbe3 fe69      cp      $69
bbe5 20cb      jr      nz,$bbb2         ; (-$35)
bbe7 18c5      jr      $bbae            ; (-$3b)
bbe9 3e0b      ld      a,$0b
bbeb 26b0      ld      h,$b0
bbed 2e08      ld      l,$08
bbef 3e0b      ld      a,$0b
bbf1 1802      jr      $bbf5            ; (+$02)
bbf3 3e0c      ld      a,$0c
bbf5 cd4abb    call    $bb4a
bbf8 d0        ret     nc

bbf9 00        nop     
bbfa 00        nop     
bbfb 3e0e      ld      a,$0e
bbfd cd4abb    call    $bb4a
bc00 d0        ret     nc

bc01 3ec5      ld      a,$c5
bc03 bc        cp      h
bc04 cb15      rl      l
bc06 26b0      ld      h,$b0
bc08 d2f3bb    jp      nc,$bbf3
bc0b 3e1d      ld      a,$1d
bc0d bd        cp      l
bc0e c23dbb    jp      nz,$bb3d
bc11 00        nop     
bc12 af        xor     a
bc13 08        ex      af,af'
bc14 26c4      ld      h,$c4
bc16 2e01      ld      l,$01
bc18 fd216abd  ld      iy,$bd6a
bc1c 3e07      ld      a,$07
bc1e 1817      jr      $bc37            ; (+$17)

bc20 3e92      ld      a,$92			;; decrypt block data
bc22 ad        xor     l
bc23 c6a9      add     a,$a9
bc25 dd7700    ld      (ix+$00),a		;; store byte
bc28 dd23      inc     ix				;; increment pointer
bc2a 1b        dec     de				;; decrement count
bc2b 26c4      ld      h,$c4
bc2d 2e01      ld      l,$01
bc2f 2e01      ld      l,$01
bc31 3e04      ld      a,$04
bc33 1802      jr      $bc37            ; (+$02)
bc35 3e0c      ld      a,$0c
bc37 cd4abb    call    $bb4a
bc3a d0        ret     nc

bc3b 00        nop     
bc3c 00        nop     
bc3d 3e0e      ld      a,$0e
bc3f cd4abb    call    $bb4a
bc42 d0        ret     nc

bc43 3ed9      ld      a,$d9
bc45 bc        cp      h
bc46 cb15      rl      l
bc48 26c4      ld      h,$c4
bc4a d235bc    jp      nc,$bc35
bc4d 08        ex      af,af'
bc4e ad        xor     l
bc4f 08        ex      af,af'
bc50 7a        ld      a,d
bc51 b3        or      e
bc52 20cc      jr      nz,$bc20         ; (-$34)
bc54 c32ebb    jp      $bb2e

bc57 3e92      ld      a,$92		;; decrypt block data
bc59 ad        xor     l
bc5a c6a9      add     a,$a9
bc5c dd7700    ld      (ix+$00),a	;; write to memory
bc5f dd23      inc     ix			;; increment pointer
bc61 1b        dec     de			;; decrement count

bc62 2e02      ld      l,$02		;; get 7 bits
bc64 3e04      ld      a,$04
bc66 26b3      ld      h,$b3
bc68 cdd3bc    call    $bcd3
bc6b d0        ret     nc

bc6c fd7e04    ld      a,(iy+$04)	;; any more blocks?
bc6f b7        or      a
bc70 2859      jr      z,$bccb          ; (+$59)
bc72 69        ld      l,c
bc73 01007f    ld      bc,$7f00
bc76 00        nop     
bc77 00        nop     
bc78 00        nop     

bc79 fd4e00    ld      c,(iy+$00)		;; get block destination
bc7c fd4601    ld      b,(iy+$01)
bc7f dd210000  ld      ix,$0000
bc83 dd09      add     ix,bc
bc85 4d        ld      c,l

bc86 3e01      ld      a,$01
bc88 2e02      ld      l,$02			;; read 7 bits
bc8a 26b3      ld      h,$b3
bc8c cdd3bc    call    $bcd3
bc8f d0        ret     nc

bc90 3e7f      ld      a,$7f
bc92 bd        cp      l
bc93 2803      jr      z,$bc98          ; (+$03)
;; set copyprotection flag
bc95 3264bd    ld      ($bd64),a

bc98 2e02      ld      l,$02			;; read 7 bits
bc9a 3e08      ld      a,$08
bc9c 26b3      ld      h,$b3
bc9e cdd3bc    call    $bcd3
bca1 d0        ret     nc

bca2 fd5e02    ld      e,(iy+$02)		;; get block length
bca5 fd5603    ld      d,(iy+$03)
bca8 69        ld      l,c
bca9 010500    ld      bc,$0005			;; each entry in the table is 5 bytes in length
bcac fd09      add     iy,bc

bcae 4d        ld      c,l
bcaf 7b        ld      a,e
bcb0 b2        or      d
bcb1 26c4      ld      h,$c4
bcb3 2e01      ld      l,$01
bcb5 3e04      ld      a,$04
bcb7 c237bc    jp      nz,$bc37
bcba 112ebb    ld      de,$bb2e
bcbd ed5355bc  ld      ($bc55),de
bcc1 113abc    ld      de,$bc3a
bcc4 d5        push    de
bcc5 11de0e    ld      de,$0ede
bcc8 c34ebb    jp      $bb4e
bccb 3e06      ld      a,$06
bccd 00        nop     
bcce 00        nop     
bccf 18b7      jr      $bc88            ; (-$49)

bcd1 3e0d      ld      a,$0d
bcd3 cd4abb    call    $bb4a
bcd6 3e10      ld      a,$10
bcd8 cd4abb    call    $bb4a
bcdb d0        ret     nc

bcdc 3edb      ld      a,$db
bcde bc        cp      h
bcdf cb15      rl      l
bce1 26b3      ld      h,$b3
bce3 d2d1bc    jp      nc,$bcd1
bce6 c9        ret     

bce7 cd6bbb    call    $bb6b
bcea 210080    ld      hl,$8000
bced 06ff      ld      b,$ff
bcef c5        push    bc
bcf0 1e00      ld      e,$00
bcf2 4b        ld      c,e
bcf3 16ff      ld      d,$ff
bcf5 06f5      ld      b,$f5
bcf7 ed78      in      a,(c)
bcf9 e680      and     $80
bcfb a9        xor     c
bcfc 2851      jr      z,$bd4f          ; (+$51)
bcfe 1c        inc     e
bcff 79        ld      a,c
bd00 2f        cpl     
bd01 e680      and     $80
bd03 4f        ld      c,a
bd04 15        dec     d
bd05 c2f5bc    jp      nz,$bcf5
bd08 73        ld      (hl),e
bd09 23        inc     hl
bd0a c1        pop     bc
bd0b 10e2      djnz    $bcef            ; (-$1e)
bd0d 210000    ld      hl,$0000
bd10 113280    ld      de,$8032
bd13 0632      ld      b,$32
bd15 c5        push    bc
bd16 1a        ld      a,(de)
bd17 0600      ld      b,$00
bd19 4f        ld      c,a
bd1a 09        add     hl,bc
bd1b 13        inc     de
bd1c c1        pop     bc
bd1d 10f6      djnz    $bd15            ; (-$0a)
bd1f e5        push    hl
bd20 210000    ld      hl,$0000
bd23 11cd80    ld      de,$80cd
bd26 0632      ld      b,$32
bd28 c5        push    bc
bd29 1a        ld      a,(de)
bd2a 0600      ld      b,$00
bd2c 4f        ld      c,a
bd2d 09        add     hl,bc
bd2e 13        inc     de
bd2f c1        pop     bc
bd30 10f6      djnz    $bd28            ; (-$0a)
bd32 c1        pop     bc
bd33 7c        ld      a,h
bd34 fe00      cp      $00
bd36 2013      jr      nz,$bd4b         ; (+$13)
bd38 a7        and     a
bd39 ed42      sbc     hl,bc
bd3b 013200    ld      bc,$0032
bd3e a7        and     a
bd3f ed42      sbc     hl,bc
bd41 d8        ret     c

bd42 09        add     hl,bc
bd43 01cdff    ld      bc,$ffcd
bd46 a7        and     a
bd47 ed42      sbc     hl,bc
bd49 d0        ret     nc

bd4a 3c        inc     a
bd4b 3264bd    ld      ($bd64),a
bd4e c9        ret     

bd4f 00        nop     
bd50 00        nop     
bd51 c304bd    jp      $bd04

;; colours
bd54 44        ld      b,h
bd55 56        ld      d,(hl)
bd56 4b        ld      c,e
bd57 5c        ld      e,h
bd58 4c        ld      c,h
bd59 40        ld      b,b
bd5a 52        ld      d,d
bd5b 59        ld      e,c
bd5c 55        ld      d,l
bd5d 45        ld      b,l
bd5e 5e        ld      e,(hl)
bd5f 47        ld      b,a
bd60 4e        ld      c,(hl)
bd61 43        ld      b,e
bd62 54        ld      d,h
bd63 54        ld      d,h

;; flag to indicate if there was an error loading
bd64 00        nop     

bd65 181e      jr      $bd85            ; (+$1e)
bd67 1c        inc     e
bd68 2001      jr      nz,$bd6b         ; (+$01)

;; table of blocks to load
defw &3880, &2004
defb &80
defw &bc20, &0001
defb &80
defw &bc57, &0003
defb &80
defw &be28, &0008
defb &80
defw &5880, &38a5
defb &80
defb 0

bd84 00        nop     
bd85 00        nop     
bd86 00        nop     
bd87 00        nop     
bd88 08        ex      af,af'

;;----------------------------------------------------------
;; starts here to load data
bd89 dd214000  ld      ix,$0040
bd8d 111400    ld      de,$0014
bd90 cde7bc    call    $bce7			;; speedlock v1 style block

bd93 dd210040  ld      ix,$4000
bd97 110040    ld      de,$4000
bd9a cd6bbb    call    $bb6b			;; speedlock v1 style block (screen)

bd9d 210040    ld      hl,$4000
bda0 1100c0    ld      de,$c000
bda3 010040    ld      bc,$4000			;; display screen
bda6 edb0      ldir    

bda8 dd210002  ld      ix,$0200			;; position to load first sub-block
bdac 118f36    ld      de,$368f			;; size of first sub-block

;; enable v2 loading from table
bdaf 2157bc    ld      hl,$bc57
bdb2 2255bc    ld      ($bc55),hl

bdb5 cd6bbb    call    $bb6b			;; speedlock v2 type

;; at this point, the loading has been reset to speedlock v1 style

bdb8 2100c0    ld      hl,$c000
bdbb 1101c0    ld      de,$c001
bdbe 36ff      ld      (hl),$ff
bdc0 01ff3f    ld      bc,$3fff
bdc3 edb0      ldir						;; blank screen

;; initialise smaller display

bdc5 3e09      ld      a,$09			;; char height in scan-lines
bdc7 0100bc    ld      bc,$bc00
bdca ed79      out     (c),a
bdcc 04        inc     b
bdcd 3e03      ld      a,$03
bdcf ed79      out     (c),a			;; chars are 4 scanlines tall

bdd1 3c        inc     a				;; A = 4; crtc frame height in char-lines
bdd2 05        dec     b				
bdd3 ed79      out     (c),a

bdd5 04        inc     b
bdd6 3e4d      ld      a,$4d
bdd8 ed79      out     (c),a			;; crtc frame is 77 char-lines tall

bdda 3e07      ld      a,$07			;; number of displayed character-lines
bddc 05        dec     b
bddd ed79      out     (c),a
bddf 04        inc     b
bde0 3e38      ld      a,$38			;; 56 char-lines display; 4 scan-lines for
										;; each char-line
bde2 ed79      out     (c),a			;; 224 lines

;; initialise colours
bde4 2154bd    ld      hl,$bd54
bde7 0610      ld      b,$10
bde9 af        xor     a
bdea c5        push    bc
bdeb 4e        ld      c,(hl)
bdec 23        inc     hl
bded 067f      ld      b,$7f
bdef ed79      out     (c),a			;; pen number
bdf1 ed49      out     (c),c			;; pen colour (defined using hardware colour palette id)
bdf3 3c        inc     a
bdf4 c1        pop     bc
bdf5 10f3      djnz    $bdea            

;; load small screen and some data
bdf7 dd2100c0  ld      ix,$c000
bdfb 110040    ld      de,$4000
bdfe cd6bbb    call    $bb6b	

be01 3e09      ld      a,$09			;; char height in scan-lines
be03 0100bc    ld      bc,$bc00
be06 ed79      out     (c),a
be08 04        inc     b
be09 3e07      ld      a,$07
be0b ed79      out     (c),a			;; each character is 8 scanlines tall

be0d 3e04      ld      a,$04			;; crtc frame height in character-lines
be0f 05        dec     b
be10 ed79      out     (c),a
be12 3e26      ld      a,$26			;; 38 char-lines tall
be14 04        inc     b
be15 ed79      out     (c),a			

be17 3e07      ld      a,$07			;; number of char-lines displayed
be19 05        dec     b
be1a ed79      out     (c),a
be1c 3e1e      ld      a,$1e			;; 30 char-lines display
be1e 04        inc     b
be1f ed79      out     (c),a

;; check copy flag
be21 3a64bd    ld      a,($bd64)
be24 b7        or      a
be25 c23dbb    jp      nz,$bb3d

;; loaded ok...
be28 067f      ld      b,$7f
be2a 3e8c      ld      a,$8c
be2c ed79      out     (c),a			;; set mode 0

;; execute program
be2e c35093    jp      $9350
