
;; level data loading routine on Rastan
;; IX = load address
;; DE = length

;; data structure:
;;
;; a sequence of 1 bits (at least 32)
;; then 2 sync pulses 
;; then data as 8-bits

265a d5        push    de
265b dde5      push    ix
;; load one extra byte (extra byte is checksum)
265d 13        inc     de
;; checksum is stored first
265e dd2b      dec     ix

2660 dde5      push    ix
2662 d5        push    de
;; start cassette motor & delay
2663 3e10      ld      a,$10
2665 cdf226    call    $26f2

2668 f3        di      
2669 d9        exx     
266a d1        pop     de
266b d9        exx     
266c e1        pop     hl

266d 06f5      ld      b,$f5
266f ed78      in      a,(c)
2671 4f        ld      c,a

;; look for 32 1 bits
2672 1e20      ld      e,$20

2674 165b      ld      d,$5b		;; timing constant
2676 3e09      ld      a,$09		;; 140T-state delay 
2678 cdce26    call    $26ce		;; get wave
267b 30f5      jr      nc,$2672         ; (-$0b)

267d 3e91      ld      a,$91		;; if >=$91 then 0 bit, if <$91 then 1 bit
									;; this is normally 1 (1/4) the length of a 1 bit

									;; 54 difference
267f ba        cp      d
2680 30f0      jr      nc,$2672         ; (-$10)

2682 1d        dec     e
2683 20ef      jr      nz,$2674         ; (-$11)

;; look for first sync pulse - keep looping while pilot
2685 165b      ld      d,$5b
2687 cdd226    call    $26d2
268a 30e6      jr      nc,$2672         ; (-$1a)

268c 3e70      ld      a,$70			; 21 difference
268e ba        cp      d
268f 38f4      jr      c,$2685          ; (-$0c)

;; get second sync pulse
2691 cdd226    call    $26d2			;; get pulse
2694 30dc      jr      nc,$2672         ; (-$24)

;; E = data fetch mask
;; D = timing constant
2696 1101b8    ld      de,$b801

;; instruction timings are in []. These define time in microsecond
;; units. The T state timings are: microsecond timing * 4
;;

;; when D overflows (i.e. it counts to $ff then $00)
;; carry will be clear and there has been an error loading.
;; 
;; $100-$B8 = $48 (72)
;;
;; for the waveform to be accepted
;; $48 is the maximum measured time for *both* pulses of the wave

;; total time:

;; 140T-state delay, a * 56T, 92T,  172T-state delay, b * 56T, 92T
;; a and b are the pulse timings for each part of the wave.
;; 
;; a and b are normally approximatly the same therefore:
;; 
;; the number of T states to the comparison point is:
;;
;; total = 140T + (a*56T) + 92 + 172T + (a*56T)
;; total = 402 + (a*112T)

;; 3538T in this example
;; /2 = 1769T per pulse MAX 
;; 0.875
;; 1327
3500000

2699 3e09      ld      a,$09			;; [2] 140T-state delay
269b cdce26    call    $26ce			;; [5] get wave
269e 3016      jr      nc,$26b6         ;; [3]


26a0 3ed4      ld      a,$d4			;; [2]
26a2 ba        cp      d				;; [1]
;; if D<A then carry is set, and a 1 bit has been measured
;; if D>=A then carry is clear, and a 0 bit has been measured
;; 
;; the duration of a 0 waveform is greater than the duration of a 1 waveform
;; for 0 bit, D>=$D4, for 1 bit D<$D4
;;
;; the comparison value is normally 5/4 * length of shortest pulse
;;
;; in this case, the 1 bit
;;
;; $D4-$B8 = $1C (28)
;; 

26a3 cb13      rl      e				;; [2]
26a5 16b8      ld      d,$b8			;; [2]
26a7 30f0      jr      nc,$2699         ;; [3] = [13] = 52T

26a9 73        ld      (hl),e			; write byte
26aa 23        inc     hl

;; initialise data-fetch-mask
26ab 1e01      ld      e,$01
26ad d9        exx     
26ae 1b        dec     de
26af 7a        ld      a,d
26b0 b3        or      e
26b1 d9        exx     
26b2 3e06      ld      a,$06
26b4 20e5      jr      nz,$269b         ; (-$1b)

;; checksum
;; add all bytes except for last; then compare against last byte
26b6 af        xor     a
26b7 e1        pop     hl
26b8 d1        pop     de

26b9 e5        push    hl

26ba 86        add     a,(hl)
26bb 23        inc     hl
26bc 1b        dec     de
26bd 4f        ld      c,a
26be 7a        ld      a,d
26bf b3        or      e
26c0 79        ld      a,c
26c1 20f7      jr      nz,$26ba         ; (-$09)

26c3 e1        pop     hl
26c4 2b        dec     hl
26c5 be        cp      (hl)
26c6 202a      jr      nz,$26f2         ; (+$2a)

;; stop cassette motor and delay
26c8 af        xor     a
26c9 cdf226    call    $26f2
26cc 37        scf     
26cd c9        ret     

;;======================================================================
;; get wave
;; if carry clear, then D has overflowed (a pulse has not occured within time)
;; if carry set, then D is the measurement in 56Tstate units and pulse has occured

26ce cdd426    call    $26d4			;; get pulse
26d1 d0        ret     nc

26d2 3e0b      ld      a,$0b			;; 172T states delay

;; delay = ((A-1)*16T) + 12T
26d4 3d        dec     a				; [1]
26d5 20fd      jr      nz,$26d4         ; [3/2] = 4 microseconds = 16Tstates

26d7 14        inc     d				; [1]
26d8 c8        ret     z				; [3]
26d9 06f5      ld      b,$f5			; [2]
26db ed78      in      a,(c)			; [4]
26dd a9        xor     c				; [1]
26de f2d726    jp      p,$26d7			; [3] = 14microseconds = 56Tstatess

26e1 067f      ld      b,$7f			; [2]
26e3 3e10      ld      a,$10			; [2]
26e5 ed79      out     (c),a			; [4]
26e7 79        ld      a,c				; [1]
26e8 2f        cpl						; [1]
26e9 4f        ld      c,a				; [1]
26ea 1f        rra						; [1]
26eb 3e2a      ld      a,$2a			; [2]
26ed 17        rla						; [1]
26ee ed79      out     (c),a			; [4]
26f0 37        scf						; [1]
26f1 c9        ret						; [3] = 23microseconds = 92T states

;;================================================================
;; start or stop cassette motor & pause
26f2 06f6      ld      b,$f6
26f4 ed79      out     (c),a

;; pause
26f6 210000    ld      hl,$0000
26f9 2b        dec     hl
26fa 7d        ld      a,l
26fb b4        or      h
26fc 20fb      jr      nz,$26f9         ; (-$05)
26fe c9        ret     

;;================================================================
