;; Micro-Key loader disassembly
;; (This version is from Ranarama)
;;
;; message in loader: Micro-Key-Systems (C) 1986
;;
;; - based on standard Amstrad ROM loader
;;   (split into 256 byte blocks, each with 2 byte crc. Crc calculated using
;;    same algorithm as system)	  
;; - pilot is timed to calculate bit 0 and bit 1 rate for sync byte (and adjusted for data)
;; - data is stored as pulses
;; - initial calculated timing is used to fetch sync byte, the timing
;;   is then adjusted by a fixed amount for the remaining data bytes

;; Ranarama - Hewson
;; original release
;;
;; - 1 block protected basic file which displays "Loading: please wait!"
;; and then loads second loader file
;; - 2nd loader file is a encrypted 1 block binary loader.
;;
;; Night Gunner - Digital Integration
;;
;; 1st file is called "NIGHT GUNNER" and is a 1 block protected binary file.
;; 2nd file is called "!AMSTRAD" and is a 1 block protected binary file.
;;
;; On the whole, the loader is identical. Except Night Gunner loads 2 data blocks,
;; compared to Ranarama which loads 1. Differences are noted.

9a00 211e9a    ld      hl,$9a1e			; routine to call if loading fails
9a03 d1        pop     de
9a04 d5        push    de
9a05 012000    ld      bc,$0020
9a08 edb0      ldir    
9a0a 210f9a    ld      hl,$9a0f			; routine to call to load data blocks
9a0d e3        ex      (sp),hl
9a0e e9        jp      (hl)

;;----------------------------------------------------------------------

9a0f 210019    ld      hl,$1900			; load address
9a12 110080    ld      de,$8000			; length
9a15 3e66      ld      a,$66			; sync byte
9a17 cd3c9a    call    $9a3c
9a1a 3819      jr      c,$9a35          ; 
9a1c 18f1      jr      $9a0f            ; 

;;----------------------------------------------------------------------
;; for Night Gunner this is at the end of the loader file

9a1e 01897f    ld      bc,$7f89
9a21 ed49      out     (c),c
9a23 210000    ld      hl,$0000
9a26 110000    ld      de,$0000
9a29 013f00    ld      bc,$003f
9a2c edb0      ldir    
9a2e 01817f    ld      bc,$7f81
9a31 ed49      out     (c),c
9a33 fb        ei      
9a34 c9        ret     

;;----------------------------------------------------------------------
;; this doesn't exist in the Night Gunner loader
;; (I think this executes the Ranarama game)
9a35 0eff      ld      c,$ff
9a37 cdb55a    call    $5ab5
9a3a 18f9      jr      $9a35            

;;----------------------------------------------------------------------
;; start of the loader

9a3c cd689a    call    $9a68
9a3f f5        push    af
9a40 21ad9a    ld      hl,$9aad
9a43 e5        push    hl
9a44 cdda9a    call    $9ada			; get pilot and sync byte
9a47 e1        pop     hl
9a48 300b      jr      nc,$9a55         ; (+$0b)

;; adjust timing for data bits 

9a4a 3a8f9b    ld      a,($9b8f)
9a4d d63f      sub     $3f
9a4f 328f9b    ld      ($9b8f),a

;;Night Gunner version:

;;a44f  3aaba5    ld      a,(#a5ab)
;;a452  d61f      sub     #1f
;;a454  32aba5    ld      (#a5ab),a

9a52 cd929a    call    $9a92


9a55 d1        pop     de
9a56 f5        push    af
9a57 0182f7    ld      bc,$f782
9a5a ed49      out     (c),c
9a5c 0110f6    ld      bc,$f610
9a5f ed49      out     (c),c
9a61 fb        ei      
9a62 7a        ld      a,d
9a63 cd74bc    call    $bc74
9a66 f1        pop     af
9a67 c9        ret     

;;----------------------------------------------------------------------

9a68 328d9b    ld      ($9b8d),a
9a6b 1b        dec     de
9a6c 1c        inc     e
9a6d e5        push    hl
9a6e d5        push    de
9a6f cda7bc    call    $bca7
9a72 d1        pop     de
9a73 dde1      pop     ix
9a75 cd6ebc    call    $bc6e
9a78 f3        di      
9a79 010ef4    ld      bc,$f40e
9a7c ed49      out     (c),c
9a7e 01d0f6    ld      bc,$f6d0
9a81 ed49      out     (c),c
9a83 0e10      ld      c,$10
9a85 ed49      out     (c),c
9a87 0192f7    ld      bc,$f792
9a8a ed49      out     (c),c
9a8c 0158f6    ld      bc,$f658
9a8f ed49      out     (c),c
9a91 c9        ret     

;;----------------------------------------------------------------------

9a92 7a        ld      a,d
9a93 b7        or      a
9a94 280d      jr      z,$9aa3          ; (+$0d)
9a96 e5        push    hl
9a97 d5        push    de
9a98 1e00      ld      e,$00
9a9a cda39a    call    $9aa3
9a9d d1        pop     de
9a9e e1        pop     hl
9a9f d0        ret     nc
9aa0 15        dec     d
9aa1 20f3      jr      nz,$9a96         ; (-$0d)

;;----------------------------------------------------------------------
;; get block

;; initialise crc (same for Night Gunner)
9aa3 01ffff    ld      bc,$ffff
9aa6 ed43909b  ld      ($9b90),bc

9aaa 1601      ld      d,$01
9aac e9        jp      (hl)

;;----------------------------------------------------------------------

;; read 256 bytes

9aad cd459b    call    $9b45			; read byte
9ab0 d0        ret     nc
9ab1 dd7700    ld      (ix+$00),a		; put byte to memory
9ab4 dd23      inc     ix				; increment memory pointer
9ab6 15        dec     d
9ab7 1d        dec     e
9ab8 20f3      jr      nz,$9aad         ; 

9aba 1800      jr      $9abc            ; (+$00)

;;----------------------------------------------------------------------
;; read remaining bytes

9abc 15        dec     d
9abd 2806      jr      z,$9ac5          ; read crc and check

9abf cd459b    call    $9b45			; get byte
9ac2 d0        ret     nc
9ac3 18f7      jr      $9abc            

;;----------------------------------------------------------------------

9ac5 cd3b9b    call    $9b3b			; complement crc
9ac8 cd459b    call    $9b45			; get byte
9acb d0        ret     nc

9acc aa        xor     d				; test high byte of crc
9acd 2007      jr      nz,$9ad6         

9acf cd459b    call    $9b45			; get byte
9ad2 d0        ret     nc

9ad3 ab        xor     e				; test low byte of crc
9ad4 37        scf     
9ad5 c8        ret     z

;;----------------------------------------
;; crc check failed

9ad6 3e02      ld      a,$02
9ad8 b7        or      a
9ad9 c9        ret     

;;----------------------------------------------------------------------


9ada d5        push    de
9adb cde49a    call    $9ae4
9ade d1        pop     de
9adf d8        ret     c
9ae0 b7        or      a
9ae1 c8        ret     z
9ae2 18f6      jr      $9ada            ; (-$0a)

;;----------------------------------------------------------------------


9ae4 2e55      ld      l,$55
9ae6 cd629b    call    $9b62			; get edge
9ae9 d0        ret     nc

9aea 110000    ld      de,$0000
9aed 62        ld      h,d
9aee cd629b    call    $9b62			; get edge
9af1 d0        ret     nc
9af2 eb        ex      de,hl
9af3 0600      ld      b,$00
9af5 09        add     hl,bc
9af6 eb        ex      de,hl
9af7 25        dec     h
9af8 20f4      jr      nz,$9aee         ; (-$0c)

9afa 61        ld      h,c
9afb 79        ld      a,c
9afc 92        sub     d
9afd 4f        ld      c,a
9afe 9f        sbc     a,a
9aff 47        ld      b,a
9b00 eb        ex      de,hl
9b01 09        add     hl,bc
9b02 eb        ex      de,hl
9b03 cd629b    call    $9b62			; get edge
9b06 d0        ret     nc
9b07 7a        ld      a,d
9b08 cb3f      srl     a
9b0a cb3f      srl     a
9b0c 8a        adc     a,d
9b0d 94        sub     h
9b0e 38ea      jr      c,$9afa          ; (-$16)
9b10 91        sub     c
9b11 38e7      jr      c,$9afa          ; (-$19)
9b13 7a        ld      a,d
9b14 1f        rra     
9b15 8a        adc     a,d
9b16 67        ld      h,a
9b17 228e9b    ld      ($9b8e),hl

;;--------------------------------------------------------------

9b1a cd459b    call    $9b45			; get byte
9b1d d0        ret     nc

9b1e 218d9b    ld      hl,$9b8d			; sync byte
9b21 ae        xor     (hl)				; compare
9b22 c0        ret     nz
;; sync byte is correct
9b23 37        scf     
9b24 c9        ret     

;;----------------------------------------------------------------------
;; update crc

9b25 2a909b    ld      hl,($9b90)
9b28 ac        xor     h
9b29 f2359b    jp      p,$9b35
9b2c 7c        ld      a,h
9b2d ee08      xor     $08
9b2f 67        ld      h,a
9b30 7d        ld      a,l
9b31 ee10      xor     $10
9b33 6f        ld      l,a
9b34 37        scf     
9b35 ed6a      adc     hl,hl
9b37 22909b    ld      ($9b90),hl
9b3a c9        ret     

;;----------------------------------------------------------------------
;; complement crc

9b3b 2a909b    ld      hl,($9b90)
9b3e 7d        ld      a,l
9b3f 2f        cpl     
9b40 5f        ld      e,a
9b41 7c        ld      a,h
9b42 2f        cpl     
9b43 57        ld      d,a
9b44 c9        ret     

;;----------------------------------------------------------------------
;; get byte

9b45 d5        push    de
9b46 1e08      ld      e,$08			; number of bits

9b48 2a8e9b    ld      hl,($9b8e)
9b4b cd699b    call    $9b69			; get edge
9b4e dc729b    call    c,$9b72			; get edge
9b51 300d      jr      nc,$9b60   
      
9b53 7c        ld      a,h				; ideal time
9b54 91        sub     c				; measured time
										; if c<h then h-c is +ve
										; if c>h then h-c is -ve
9b55 9f        sbc     a,a
9b56 cb12      rl      d

;; update crc
9b58 cd259b    call    $9b25
9b5b 1d        dec     e
9b5c 20ea      jr      nz,$9b48         ; (-$16)

9b5e 7a        ld      a,d
9b5f 37        scf     
9b60 d1        pop     de
9b61 c9        ret     

;;----------------------------------------------------------------------

9b62 06f4      ld      b,$f4
9b64 ed78      in      a,(c)
9b66 e604      and     $04
9b68 c8        ret     z

9b69 ed5f      ld      a,r
9b6b c603      add     a,$03
9b6d 0f        rrca    
9b6e 0f        rrca    
9b6f e61f      and     $1f
9b71 4f        ld      c,a
9b72 06f5      ld      b,$f5
9b74 79        ld      a,c
9b75 c602      add     a,$02
9b77 4f        ld      c,a
9b78 380e      jr      c,$9b88          ; (+$0e)
9b7a ed78      in      a,(c)
9b7c ad        xor     l
9b7d e680      and     $80
9b7f 20f3      jr      nz,$9b74         ; (-$0d)
9b81 af        xor     a
9b82 ed4f      ld      r,a
9b84 cb0d      rrc     l
9b86 37        scf     
9b87 c9        ret     

;;----------------------------------------------------------------------

9b88 af        xor     a
9b89 ed4f      ld      r,a
9b8b 3c        inc     a
9b8c c9        ret     

;;----------------------------------------------------------------------

