;; Thrust
;;
;;
;; title underlined with '-'s
;; e.g.
;; THRUST
;; ------
;;
;; - timing for 0 and 1 pulses is fixed
;; - signal structure:
;; n * pilot pulses (256 minimum)
;; 2 * sync pulses
;; sync byte
;; data bytes

;; 256 data bytes
;; 1 byte block number

3600 cd1a37    call    371ah			;; start cassette motor
3603 3e02      ld      a,02h
3605 cdb4bb    call    0bbb4h
3608 3e02      ld      a,02h
360a cd90bb    call    0bb90h
360d 1600      ld      d,00h
360f cd7937    call    3779h			;; display searching
3612 3e08      ld      a,08h
3614 324632    ld      (3246h),a

3617 cde036    call    36e0h			;; calc block size
361a cd8236    call    3682h			;; fetch block
361d 3a3232    ld      a,(3232h)		;; number of block read
3620 ba        cp      d				;; number of block wanted
3621 2805      jr      z,3628h

3623 cd4a37    call    374ah
3626 18ea      jr      3612h

;;----------------------------------------------------------------------

3628 cdeb36    call    36ebh			;; checksum block
362b be        cp      (hl)
362c 2821      jr      z,364fh
362e cd4a37    call    374ah
3631 18df      jr      3612h

;;----------------------------------------------------------------------

3633 cde036    call    36e0h			;; calc block size
3636 cd8236    call    3682h			;; fetch block
3639 3a3232    ld      a,(3232h)		;; number of block read
363c ba        cp      d				;; number of block wanted
363d 2805      jr      z,3644h

363f cd4a37    call    374ah
3642 18ef      jr      3633h

;;----------------------------------------------------------------------

3644 cdeb36    call    36ebh			;; checksum block
3647 be        cp      (hl)
3648 2805      jr      z,364fh

364a cd4a37    call    374ah
364d 18e4      jr      3633h

;;----------------------------------------------------------------------

364f cd6d36    call    366dh			;; copy block to destination
3652 cd2237    call    3722h
3655 213532    ld      hl,3235h
3658 7e        ld      a,(hl)
3659 23        inc     hl
365a 3d        dec     a
365b 20fc      jr      nz,3659h
365d 23        inc     hl
365e 23        inc     hl
365f 23        inc     hl
3660 23        inc     hl
3661 7e        ld      a,(hl)
3662 2b        dec     hl
3663 2b        dec     hl
3664 2b        dec     hl
3665 e607      and     07h
3667 3c        inc     a
3668 324632    ld      (3246h),a
366b 14        inc     d
366c e9        jp      (hl)
;;---------------------------------------------------------------------
366d d5        push    de
366e e5        push    hl
366f ed5b3332  ld      de,(3233h)
3673 213231    ld      hl,3132h
3676 010001    ld      bc,0100h
3679 edb0      ldir    
367b e1        pop     hl
367c d1        pop     de
367d fde1      pop     iy
367f fde5      push    iy
3681 c9        ret     
;;---------------------------------------------------------------------
;; load data block
;;
;; BC = length of block

3682 f3        di      
3683 d5        push    de
3684 e5        push    hl
3685 c5        push    bc
;;---------------------------------------------------------------------
				  
;; get 256 pulses
3686 0600      ld      b,00h
3688 cdd036    call    36d0h
368b 3e21      ld      a,21h
368d bb        cp      e
368e 30f6      jr      nc,3686h
3690 10f6      djnz    3688h
;;---------------------------------------------------------------------
;; wait for end of pilot and get first sync pulse
3692 cdd036    call    36d0h
3695 3e21      ld      a,21h
3697 bb        cp      e
3698 38f8      jr      c,3692h

;; get 2nd sync pulse
369a cdd036    call    36d0h
369d 3e21      ld      a,21h
369f bb        cp      e
36a0 38e4      jr      c,3686h

;; get sync byte
36a2 cdbd36    call    36bdh
36a5 fe64      cp      64h
36a7 20dd      jr      nz,3686h

;; read block bytes
36a9 213231    ld      hl,3132h
36ac c1        pop     bc
36ad c5        push    bc
;; HL = location
;; BC = length

;; read data byte
36ae cdbd36    call    36bdh
;; store
36b1 77        ld      (hl),a
36b2 23        inc     hl
36b3 0b        dec     bc
36b4 78        ld      a,b
36b5 b1        or      c
36b6 20f6      jr      nz,36aeh
36b8 c1        pop     bc
36b9 e1        pop     hl
36ba d1        pop     de
36bb fb        ei      
36bc c9        ret     



;;---------------------------------------------------------------------
;; read data-byte
;;
;; A = data byte 

36bd d5        push    de
36be 1601      ld      d,01h
36c0 cdd036    call    36d0h
36c3 cdd236    call    36d2h
36c6 3e45      ld      a,45h
36c8 bb        cp      e
36c9 cb12      rl      d
36cb 30f3      jr      nc,36c0h
36cd 7a        ld      a,d
36ce d1        pop     de
36cf c9        ret     

;;---------------------------------------------------------------------
;; time pulse
;; E = timed value
36d0 1e00      ld      e,00h
;;---------------------------------------------------------------------
36d2 c5        push    bc
36d3 06f5      ld      b,0f5h
36d5 ed48      in      c,(c)

36d7 1c        inc     e			; [1]
36d8 ed78      in      a,(c)		; [4]
36da a9        xor     c			; [1]
36db f2d736    jp      p,36d7h		; [3]
36de c1        pop     bc
36df c9        ret     
;;---------------------------------------------------------------------

36e0 3a4632    ld      a,(3246h)
36e3 010801    ld      bc,0108h
36e6 03        inc     bc
36e7 3d        dec     a
36e8 20fc      jr      nz,36e6h
36ea c9        ret     

;;---------------------------------------------------------------------
;; checksum block
36eb d5        push    de
36ec cde036    call    36e0h
36ef 0b        dec     bc
36f0 213231    ld      hl,3132h
36f3 ae        xor     (hl)
36f4 5f        ld      e,a
36f5 23        inc     hl
36f6 0b        dec     bc
36f7 78        ld      a,b
36f8 b1        or      c
36f9 7b        ld      a,e
36fa 20f7      jr      nz,36f3h
36fc d1        pop     de
36fd c9        ret     
;;---------------------------------------------------------------------


36fe 213232    ld      hl,3232h
3701 7e        ld      a,(hl)
3702 34        inc     (hl)

;; display hex number 
3703 f5        push    af
3704 07        rlca    
3705 07        rlca    
3706 07        rlca    
3707 07        rlca    
3708 cd0c37    call    370ch
370b f1        pop     af
370c e60f      and     0fh
370e f630      or      30h
3710 fe3a      cp      3ah
3712 3802      jr      c,3716h
3714 c607      add     a,07h
3716 cd5abb    call    0bb5ah
3719 c9        ret     
;;---------------------------------------------------------------------

371a c5        push    bc
371b 0110f6    ld      bc,0f610h
371e ed49      out     (c),c
3720 c1        pop     bc
3721 c9        ret     
;;---------------------------------------------------------------------

3722 e5        push    hl
3723 d5        push    de
3724 3e02      ld      a,02h
3726 cdb4bb    call    0bbb4h
3729 cd6cbb    call    0bb6ch
372c 3e01      ld      a,01h
372e cdb4bb    call    0bbb4h
3731 3e02      ld      a,02h
3733 cd90bb    call    0bb90h
3736 cda237    call    37a2h
3739 0d        dec     c
373a 4c        ld      c,h
373b 6f        ld      l,a
373c 61        ld      h,c
373d 64        ld      h,h
373e 69        ld      l,c
373f 6e        ld      l,(hl)
3740 67        ld      h,a
3741 2020      jr      nz,3763h
3743 2000      jr      nz,3745h
3745 d1        pop     de
3746 e1        pop     hl
3747 c3fe36    jp      36feh
;;---------------------------------------------------------------------
374a e5        push    hl
374b 5f        ld      e,a
374c d5        push    de
374d 3e01      ld      a,01h
374f cdb4bb    call    0bbb4h
3752 3e03      ld      a,03h
3754 cd90bb    call    0bb90h
3757 cda237    call    37a2h
375a 0d        dec     c
375b 42        ld      b,d
375c 6c        ld      l,h
375d 6f        ld      l,a
375e 63        ld      h,e
375f 6b        ld      l,e
3760 203f      jr      nz,37a1h
3762 2020      jr      nz,3784h
3764 2000      jr      nz,3766h
3766 cdfe36    call    36feh
3769 3e02      ld      a,02h
376b cdb4bb    call    0bbb4h
376e 3e03      ld      a,03h
3770 cd90bb    call    0bb90h
3773 d1        pop     de
3774 7b        ld      a,e
3775 ba        cp      d
3776 3016      jr      nc,378eh
3778 e1        pop     hl

3779 e5        push    hl
377a cda237    call    37a2h
377d 0d        dec     c
377e 53        ld      d,e
377f 65        ld      h,l
3780 61        ld      h,c
3781 72        ld      (hl),d
3782 63        ld      h,e
3783 68        ld      l,b
3784 69        ld      l,c
3785 6e        ld      l,(hl)
3786 67        ld      h,a
3787 2000      jr      nz,3789h
3789 7a        ld      a,d
378a e1        pop     hl
378b c30337    jp      3703h
;;---------------------------------------------------------------------
378e cda237    call    37a2h
3791 0d        dec     c
3792 52        ld      d,d
3793 65        ld      h,l
3794 77        ld      (hl),a
3795 69        ld      l,c
3796 6e        ld      l,(hl)
3797 64        ld      h,h
3798 2074      jr      nz,380eh
379a 6f        ld      l,a
379b 2000      jr      nz,379dh
379d 7a        ld      a,d
379e e1        pop     hl
379f c30337    jp      3703h
37a2 e1        pop     hl
37a3 7e        ld      a,(hl)
37a4 23        inc     hl
37a5 fe00      cp      00h
37a7 c45abb    call    nz,0bb5ah
37aa 20f7      jr      nz,37a3h
37ac e5        push    hl
37ad c9        ret     
