;; SHADOW DANCER cassette loader
;;
;; U.S. GOLD

loader:

- single file, with BASIC stub and BINARY loader
- stored as protected BASIC file. When CAT command is executed, file type is '%'.
- load address 4170, execution address 170, length 435 
- listing of BASIC part:
	10 CALL &180 : REM

  therefore BINARY part actually starts at &180
- BINARY part is encrypted
- border flashes cyan and red for pilot and pastel yellow and blue for data

checksum:

- checksum is initialised with 0, and generated from the sum of all bytes read (before decryption)
this includes sync bytes, data and final checksum byte

data:

- data is encrypted
- data *can* be run-length encoded

data format of each block:
 
2 bytes (sync bytes * 2)
n bytes (data)
1 byte checksum

- there is a small header block (defines decryption bytes, compression scheme, length etc)
followed by a larger data block

signal:

pilot: 2303
sync0: 1001
sync1: 539
data0: 639
data1: 1278

;; loader dissassembly:

0170 34        inc     (hl)			; ??
0171 34        inc     (hl)			; ??
0172 defw &000a ;; line number
0174 defb &83   ;; call keyword
0175 defb &20   ;; space 
0176 defb &1c	;; hex number following
0177 defw &0180 ;; hex number
0179 defb &20	;; space

01    ld      bc,$0120
017b 20c5      jr      nz,$0142

;; end of line
017d 00        nop     
;; ??
017e 2a2a

0180 f3        di
0181 316d01    ld      sp,$016d

;; decrypt binary data
0184 0e22      ld      c,$22
0186 219401    ld      hl,$0194
0189 118004    ld      de,$0480
018c 79        ld      a,c
018d ae        xor     (hl)
018e 77        ld      (hl),a
018f 23        inc     hl
0190 1b        dec     de
0191 7a        ld      a,d
0192 b3        or      e
0193 20f7      jr      nz,$018c

;; copy to destination address
0195 21a201    ld      hl,$01a2
0198 1100a2    ld      de,$a200
019b 010004    ld      bc,$0400
019e d5        push    de
019f edb0      ldir    
01a1 c9        ret     

;;----------------------------------------------------------------------
;; copied from &1a2
a200 3e00      ld      a,$00
a202 21e1e9    ld      hl,$e9e1
a205 220080    ld      ($8000),hl
a208 cd0080    call    $8000
a20b 118d02    ld      de,$028d
a20e 19        add     hl,de
a20f 1198a4    ld      de,$a498
a212 019902    ld      bc,$0299
a215 edb8      lddr    
a217 c32aa2    jp      $a22a

;; colours (stored in reverse order, colour 15 to colour 0)
a21a defb &00,&0a,&0d,&17,&02,&01,&19,&18,&05,&06,&03,&02,&01,&10,&03,&1a

a22a 3100c0    ld      sp,$c000
a22d f5        push    af

;; set display mode 1
a22e 3e01      ld      a,$01
a230 cd0ebc    call    $bc0e			;; firmware function: scr set mode

;; set border to black
a233 010000    ld      bc,$0000
a236 cd38bc    call    $bc38			;; firmware function: scr set border

;; set all colours to black
a239 cdb1a2    call    $a2b1

;; load screen
a23c 3e22      ld      a,$22
a23e dd2100c0  ld      ix,$c000
a242 cdc9a2    call    $a2c9

;; set colours
a245 fb        ei      
a246 212aa2    ld      hl,$a22a
a249 3e10      ld      a,$10
a24b 2b        dec     hl
a24c 3d        dec     a
a24d f5        push    af
a24e e5        push    hl
a24f 46        ld      b,(hl)
a250 48        ld      c,b
a251 cd32bc    call    $bc32				;; firmware function: scr set ink
a254 e1        pop     hl
a255 f1        pop     af
a256 20f3      jr      nz,$a24b

;; wait for firmware to set colours
a258 cdbea2    call    $a2be

;; delay so screen is visible for some time
;; delay is approx 3.3 seconds

a25b 21e803    ld      hl,$03e8
a25e 76        halt    
a25f 2b        dec     hl
a260 7c        ld      a,h
a261 b5        or      l
a262 20fa      jr      nz,$a25e

;; set display mode to 0 
a264 3e00      ld      a,$00
a266 cd0ebc    call    $bc0e				;; firmware function: scr set mode

;; set colours to black
a269 cdb1a2    call    $a2b1

a26c f1        pop     af
a26d 4f        ld      c,a
a26e e60f      and     $0f
a270 3289a4    ld      ($a489),a
a273 b9        cp      c

a274 3e01      ld      a,$01
a276 dd2100c0  ld      ix,$c000
a27a ccc9a2    call    z,$a2c9

;; set colours
a27d fb        ei      
a27e 212aa2    ld      hl,$a22a
a281 3e10      ld      a,$10
a283 2b        dec     hl
a284 3d        dec     a
a285 f5        push    af
a286 e5        push    hl
a287 46        ld      b,(hl)
a288 48        ld      c,b
a289 cd32bc    call    $bc32				;; firmware function: scr set ink
a28c e1        pop     hl
a28d f1        pop     af
a28e 20f3      jr      nz,$a283

;; wait for firmware to set colours
a290 cdbea2    call    $a2be

a293 3e21      ld      a,$21
a295 dd2100b0  ld      ix,$b000
a299 cdc9a2    call    $a2c9

a29c 3a89a4    ld      a,($a489)
a29f 322c4f    ld      ($4f2c),a

a2a2 3e20      ld      a,$20
a2a4 dd219002  ld      ix,$0290
a2a8 cdc9a2    call    $a2c9

a2ab 3100c0    ld      sp,$c000
a2ae c38aa4    jp      $a48a


;;---------------------------------------------------------------------------
;; initialise all colours to black

a2b1 3e10      ld      a,$10
a2b3 010000    ld      bc,$0000
a2b6 3d        dec     a
a2b7 f5        push    af
a2b8 cd32bc    call    $bc32			;; firmware function: scr set ink
a2bb f1        pop     af
a2bc 20f5      jr      nz,$a2b3

;; wait for firmware to set colours
a2be cd41bc    call    $bc41			;; firmware function: scr get flashing
a2c1 2c        inc     l
a2c2 45        ld      b,l
a2c3 cd19bd    call    $bd19			;; firmware function: mc wait flyback
a2c6 10fb      djnz    $a2c3
a2c8 c9        ret     

;;---------------------------------------------------------------------------
;; load block
;; 
;; A = sync byte
;; IX = start address

;; header
;; 0 (&a47d) = sync byte
;; 1,2 (&a47e) = length
;; 3 (&a480) = run-length compression marker
;; 4 (&a481) = decryption initial value
;; 5,6 (&a482) = decryption opcodes
;; 7 (&a484) = bit 7 set if data is compressed with run-length encoding
;; 8,9 (&a485) = length

a2c9 32e6a2    ld      ($a2e6),a
a2cc dd22eba2  ld      ($a2eb),ix

;; load header block
a2d0 3eff      ld      a,$ff
a2d2 dd217da4  ld      ix,$a47d
a2d6 110a00    ld      de,$000a
a2d9 cd60a3    call    $a360
a2dc d25aa3    jp      nc,$a35a				;; load fail
a2df c25aa3    jp      nz,$a35a				;; load fail

a2e2 3a7da4    ld      a,($a47d)			;; loaded sync byte
a2e5 fe22      cp      $22					;; sync byte to compare against
a2e7 c25aa3    jp      nz,$a35a

a2ea 2100c0    ld      hl,$c000
a2ed ed5b85a4  ld      de,($a485)
a2f1 19        add     hl,de
a2f2 ed5b7ea4  ld      de,($a47e)
a2f6 a7        and     a
a2f7 ed52      sbc     hl,de
a2f9 e5        push    hl
a2fa dde1      pop     ix
a2fc cd60a3    call    $a360				;; load data

a2ff d25aa3    jp      nc,$a35a				;; load fail
a302 c25aa3    jp      nz,$a35a				;; load fail

a305 3a81a4    ld      a,($a481)
a308 321ba3    ld      ($a31b),a
a30b 2a82a4    ld      hl,($a482)
a30e 221da3    ld      ($a31d),hl
a311 ed5b7ea4  ld      de,($a47e)
a315 2a23a4    ld      hl,($a423)
a318 d5        push    de
a319 e5        push    hl

;; decrypt loaded data
a31a 0e00      ld      c,$00
a31c 7e        ld      a,(hl)
a31d ab        xor     e
a31e a9        xor     c
a31f 77        ld      (hl),a
a320 23        inc     hl
a321 1b        dec     de
a322 7a        ld      a,d
a323 b3        or      e
a324 20f6      jr      nz,$a31c

a326 e1        pop     hl
a327 d1        pop     de
a328 3a80a4    ld      a,($a480)
a32b 3239a3    ld      ($a339),a

a32e dd2aeba2  ld      ix,($a2eb)
a332 3a84a4    ld      a,($a484)
a335 17        rla     
a336 3020      jr      nc,$a358

;; run-length decompress
;; marker, 00 -> output marker
;; marker, count, value -> repeat value count times
;; !=marker -> output value

a338 0e00      ld      c,$00
a33a 0601      ld      b,$01

a33c 7e        ld      a,(hl)
a33d b9        cp      c			;; marker?
a33e 200b      jr      nz,$a34b
a340 23        inc     hl
a341 1b        dec     de
a342 7e        ld      a,(hl)
a343 b7        or      a
a344 79        ld      a,c
a345 2804      jr      z,$a34b
a347 46        ld      b,(hl)
a348 23        inc     hl
a349 1b        dec     de
a34a 7e        ld      a,(hl)

a34b dd7700    ld      (ix+$00),a
a34e dd23      inc     ix
a350 10f9      djnz    $a34b

a352 23        inc     hl
a353 1b        dec     de
a354 7a        ld      a,d
a355 b3        or      e
a356 20e2      jr      nz,$a33a
a358 37        scf     
a359 c9        ret     

;;-------------------------------------------------------;
;; do reset

;; enable lower rom
a35a 01807f    ld      bc,$7f80
a35d ed49      out     (c),c
;; restart CPC
a35f c7        rst     $00

;;-------------------------------------------------------;
;; IX = load address
;; DE = length
;; A = sync byte
;;
;; successful load:
;; C set, A = 0

;; data format:
;; 
;; 2 bytes (sync bytes * 2)
;; n bytes (data)
;; 1 byte checksum

a360 f3        di      
a361 ed531fa4  ld      ($a41f),de
a365 dd2223a4  ld      ($a423),ix
a369 6f        ld      l,a
a36a 67        ld      h,a
a36b 2210a4    ld      ($a410),hl
a36e d9        exx     
a36f c5        push    bc
a370 d5        push    de
a371 01107f    ld      bc,$7f10			
a374 11015b    ld      de,$5b01
a377 d9        exx     

a378 97        sub     a
a379 3243a4    ld      ($a443),a			;; initialise checksum

a37c 3e57      ld      a,$57
a37e 327ca4    ld      ($a47c),a

a381 210ca4    ld      hl,$a40c
a384 220aa4    ld      ($a40a),hl

a387 0110f6    ld      bc,$f610
a38a ed49      out     (c),c				;; cassette motor on

;; look for at least 50 pilot pulses of required duration
a38c 2632      ld      h,$32				;; 50 pilot pulses
a38e 069c      ld      b,$9c
a390 3e16      ld      a,$16
a392 cd58a4    call    $a458				;; read wave
a395 30f5      jr      nc,$a38c
a397 3ec6      ld      a,$c6
a399 b8        cp      b
a39a 30f0      jr      nc,$a38c
a39c 25        dec     h
a39d 20ef      jr      nz,$a38e
;; keep looping until pilot pulses are over
;; and check for valid sync wave
a39f 06c9      ld      b,$c9
a3a1 cd5ca4    call    $a45c				;; read pulse
a3a4 30e6      jr      nc,$a38c
a3a6 78        ld      a,b
a3a7 fed4      cp      $d4
a3a9 30f4      jr      nc,$a39f
a3ab cd5ca4    call    $a45c				;; read pulse
a3ae 30dc      jr      nc,$a38c

a3b0 d9        exx     
a3b1 1643      ld      d,$43
a3b3 d9        exx     

;; initially load 2 sync bytes
a3b4 dd210da4  ld      ix,$a40d			
a3b8 110200    ld      de,$0002

a3bb 0612      ld      b,$12				;; timing

;; read signal and convert to bits
;; read a whole byte at a time
a3bd 2e01      ld      l,$01
a3bf 78        ld      a,b
a3c0 06d7      ld      b,$d7
a3c2 cd58a4    call    $a458
a3c5 d247a4    jp      nc,$a447
a3c8 3ee7      ld      a,$e7
a3ca b8        cp      b
a3cb cb15      rl      l
a3cd 3e15      ld      a,$15
a3cf d2c0a3    jp      nc,$a3c0
;; L = data byte

a3d2 dd23      inc     ix
a3d4 dd2b      dec     ix

;; update checksum (checksum is sum of bytes)
a3d6 3a43a4    ld      a,($a443)
a3d9 85        add     a,l
a3da 3243a4    ld      ($a443),a

;; decode byte and write to RAM
a3dd 3a7ca4    ld      a,($a47c)	
a3e0 aa        xor     d
a3e1 ab        xor     e			
a3e2 ad        xor     l			;; encoded data byte read from cassette
a3e3 dd7700    ld      (ix+$00),a

a3e6 0609      ld      b,$09
a3e8 cb63      bit     4,e
a3ea 280d      jr      z,$a3f9

a3ec 3a7ca4    ld      a,($a47c)
a3ef c67b      add     a,$7b
a3f1 83        add     a,e
a3f2 92        sub     d
a3f3 327ca4    ld      ($a47c),a
a3f6 05        dec     b
a3f7 05        dec     b
a3f8 05        dec     b

a3f9 3a7ca4    ld      a,($a47c)
a3fc c6ef      add     a,$ef
a3fe 327ca4    ld      ($a47c),a

a401 dd23      inc     ix
a403 1b        dec     de
a404 7a        ld      a,d
a405 b3        or      e
a406 c2bda3    jp      nz,$a3bd

;; jump to next function
a409 c30ca4    jp      $a40c

;;-------------------------------------------------------------
;; check the loaded syncs are the expected syncs

a40c 210000    ld      hl,$0000
a40f 11ffff    ld      de,$ffff
a412 ed52      sbc     hl,de
a414 c248a4    jp      nz,$a448				;; stop tape
a417 1b        dec     de

;; read data

a418 212aa4    ld      hl,$a42a				;; read checksum after this data block
a41b 220aa4    ld      ($a40a),hl

a41e 110a00    ld      de,$000a				;; length of data
a421 dd217da4  ld      ix,$a47d				;; load address of data
a425 0601      ld      b,$01
a427 c3bda3    jp      $a3bd

;;--------------------------------------------------------------
;; read checksum

a42a 113fa4    ld      de,$a43f			;; checksum comparison routine
a42d ed530aa4  ld      ($a40a),de

a431 ed4a      adc     hl,bc

;; read checksum adjustment byte
a433 110100    ld      de,$0001			;; read 1 byte
a436 dd2141a4  ld      ix,$a441			;; load address
a43a 0603      ld      b,$03			;; timing delay
a43c c3bda3    jp      $a3bd

;;--------------------------------------------------------------
;; compare loaded checksum against generated checksum
;;
;; L = data byte loaded
;; checksum (&a443) has been updated with L 
;; (&a441) has been updated with L xor D xor E xor (&a47c)

a43f 7d        ld      a,l				;; get checksum byte just read 
a440 c600      add     a,$00			;; adjust checksum adjustment byte
a442 fe00      cp      $00				;; generated checksum
a444 37        scf     
a445 2801      jr      z,$a448
;; ok
a447 97        sub     a

;; stop tape motor
a448 0100f6    ld      bc,$f600
a44b ed49      out     (c),c
a44d d9        exx

;; reset border colour to black     
a44e 3e54      ld      a,$54
a450 ed49      out     (c),c
a452 ed79      out     (c),a

a454 d1        pop     de
a455 c1        pop     bc
a456 d9        exx     
a457 c9        ret     

;;--------------------------------------------------------------

a458 cd5ea4    call    $a45e
a45b d0        ret     nc

;; delay
a45c 3e16      ld      a,$16
a45e 3d        dec     a
a45f 20fd      jr      nz,$a45e


;; wait for cassette data input to change state
;; B is counter for duration

a461 a7        and     a
a462 04        inc     b
a463 c8        ret     z

a464 3ef5      ld      a,$f5		;; PPI port B
a466 dbff      in      a,($ff)	;; read cassette input state
a468 1f        rra     			;; bit 0 = VSYNC
a469 c8        ret     z

a46a a9        xor     c		;; previous value
a46b e640      and     $40
a46d 28f3      jr      z,$a462

a46f 79        ld      a,c		;; change previous value to new state
a470 2f        cpl     
a471 4f        ld      c,a

;; change border colour
a472 d9        exx     
a473 a3        and     e
a474 82        add     a,d
a475 ed49      out     (c),c		;; select border
a477 ed79      out     (c),a		;; change border colour
a479 d9        exx     
a47a 37        scf     
a47b c9        ret     

;;-------------------------------------------------

a47c
defs 14

;;-------------------------------------------------

a48a 2100b0    ld      hl,$b000
a48d 112a4f    ld      de,$4f2a
a490 01a401    ld      bc,$01a4
a493 edb0      ldir    
a495 c33ca0    jp      $a03c
