/************************************************************************

    JOYCE v2.1.0 - Amstrad PCW emulator

    Copyright (C) 1996, 2001-2  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

#include "Pcw.hxx"
#include <list>
#include "PcKeyboard.hxx"

#define KB_PARITY 0x80
#define KB_STOP   0x40
#define KB_START  0x20
#define KB_BUSY   0x10
#define KB_RESET  0x04
#define KB_CLOCK  0x02
#define KB_TX     0x01

#define ST_NORMAL 0x00
#define ST_WRDATA 0x01
#define ST_STROBE 0x02
#define ST_OUTPUT 0x03

/* Untranslated scancodes (the PCW16 doesn't translate them)
 * Ordered by UK keyboard layout 
 * Only "Codes 1" is correct at the moment */
static unsigned int kc_maps[] = 
{
//	 SDL key 	  Codes 1 	   Codes 2 	    Codes 3 
	SDLK_ESCAPE,	  0x76, 0xF076,	   0x76, 0xF076,    0x01,   0x81,
	SDLK_F1,	  0x05, 0xF005,    0x3B,   0xBB,    0x3B,   0xBB,
	SDLK_F2,	  0x06, 0xF006,    0x3C,   0xBC,    0x3C,   0xBC,
	SDLK_F3,	  0x04, 0xF004,    0x3D,   0xBD,    0x3D,   0xBD,
	SDLK_F4,	  0x0C, 0xF00C,    0x3E,   0xBE,    0x3E,   0xBE,
	SDLK_F5,	  0x03, 0xF003,    0x3F,   0xBF,    0x3F,   0xBF,
	SDLK_F6,	  0x0B, 0xF00B,    0x40,   0xC0,    0x40,   0xC0,
	SDLK_F7,	  0x83, 0xF083,    0x41,   0xC1,    0x41,   0xC1,
	SDLK_F8,	  0x0A, 0xF00A,    0x42,   0xC2,    0x42,   0xC2,
	SDLK_F9,	  0x01, 0xF001,    0x43,   0xC3,    0x43,   0xC3,
	SDLK_F10,	  0x09, 0xF009,    0x44,   0xC4,    0x44,   0xC4,
	SDLK_F11,	  0x78, 0xF078,    0x78, 0xF078,    0x57,   0xD7,
	SDLK_F12,	  0x07, 0xF007,    0x07, 0xF007,    0x58,   0xD8,
	SDLK_PRINT,   0xE012E07C, 0xFFFFFFE, 0xFFFFFFFD, 0xFFFFFFFC, 0xFFFFFFFB, 0xFFFFFFFA,
	SDLK_SYSREQ,  0xE012E07C, 0xFFFFFFE, 0xFFFFFFFD, 0xFFFFFFFC, 0xFFFFFFFB, 0xFFFFFFFA,
	SDLK_SCROLLOCK,	  0x7E, 0xF07E,    0x7E, 0xF07E,    0x7E, 0xF07E,
	SDLK_BREAK,   0xFFFFFFF9, 0xFFFFFF8, 0xFFFFFFF7, 0xFFFFFFF6, 0xFFFFFFF5, 0xFFFFFFF4,
	SDLK_BACKQUOTE,	  0x0E, 0xF00E,	   0x0E, 0xF00E,    0x0E, 0xF00E,
	SDLK_1,           0x16, 0xF016,    0x16, 0xF016,    0x16, 0xF016,
	SDLK_2,           0x1E, 0xF01E,    0x1E, 0xF01E,    0x1E, 0xF01E,
	SDLK_3,           0x26, 0xF026,    0x26, 0xF026,    0x26, 0xF026,
	SDLK_4,           0x25, 0xF025,    0x25, 0xF025,    0x25, 0xF025,
	SDLK_5,           0x2E, 0xF02E,    0x2E, 0xF02E,    0x2E, 0xF02E,
	SDLK_6,           0x36, 0xF036,    0x36, 0xF036,    0x36, 0xF036,
	SDLK_7,           0x3D, 0xF03D,    0x3D, 0xF03D,    0x3D, 0xF03D,
	SDLK_8,           0x3E, 0xF03E,    0x3E, 0xF03E,    0x3E, 0xF03E,
	SDLK_9,           0x46, 0xF046,    0x46, 0xF046,    0x46, 0xF046,
	SDLK_0,           0x45, 0xF045,    0x45, 0xF045,    0x45, 0xF045,	SDLK_TAB,	  0x0D, 0xF00E,    0x0D, 0xF00D,    0x0F,   0x8F,
	SDLK_MINUS,       0x4E, 0xF04E,    0x4D, 0xF04D,    0x4D, 0xF04D,	SDLK_0,           0x45, 0xF016,    0x16, 0xF016,    0x16, 0xF016,	SDLK_0,           0x45, 0xF016,    0x16, 0xF016,    0x16, 0xF016,
	SDLK_EQUALS,      0x55, 0xF055,    0x54, 0xF054,    0x54, 0xF054,
	SDLK_BACKSPACE,	  0x66, 0xF066,    0x58, 0xF058,    0x58, 0xF058,
	
	SDLK_TAB,         0x0D, 0xF00D,    0x0D, 0xF00D,    0x0D, 0xF00D,
	SDLK_q,		  0x15, 0xF016,    0x15, 0xF016,    0x10,   0x90,
	SDLK_w,		  0x1D, 0xF01D,    0x1D, 0xF01D,    0x11,   0x91,
	SDLK_e,		  0x24, 0xF024,    0x24, 0xF024,    0x12,   0x92,
	SDLK_r,		  0x2D, 0xF02D,    0x2D, 0xF02D,    0x13,   0x93,
	SDLK_t,		  0x2C, 0xF02C,    0x2C, 0xF02C,    0x14,   0x94,
	SDLK_y,		  0x35, 0xF035,    0x2C, 0xF02C,    0x14,   0x94,
	SDLK_u,		  0x3C, 0xF03C,    0x2C, 0xF02C,    0x14,   0x94,
	SDLK_i,		  0x43, 0xF043,    0x2C, 0xF02C,    0x14,   0x94,
	SDLK_o,		  0x44, 0xF044,    0x2C, 0xF02C,    0x14,   0x94,
	SDLK_p,		  0x4D, 0xF04D,    0x2C, 0xF02C,    0x14,   0x94,
	SDLK_LEFTBRACKET, 0x54, 0xF054,    0x2C, 0xF02C,    0x14,   0x94,
	SDLK_RIGHTBRACKET,0x59, 0xF059,    0x2C, 0xF02C,    0x14,   0x94,
	SDLK_CAPSLOCK,	  0x58, 0xF058,    0x58, 0xF058,    0x14,   0x94,
	SDLK_a,           0x1C, 0xF01C,    0x1C, 0xF01C,    0x1C, 0xF01C,
	SDLK_s,           0x1B, 0xF01B,    0x1B, 0xF01B,    0x1C, 0xF01C,
	SDLK_d,           0x23, 0xF023,    0x23, 0xF023,    0x1C, 0xF01C,
	SDLK_f,           0x2B, 0xF02B,    0x2B, 0xF02B,    0x1C, 0xF01C,
	SDLK_g,           0x34, 0xF034,    0x34, 0xF034,    0x1C, 0xF01C,
	SDLK_h,           0x33, 0xF033,    0x33, 0xF033,    0x1C, 0xF01C,
	SDLK_j,           0x3B, 0xF03B,    0x3B, 0xF03B,    0x1C, 0xF01C,
	SDLK_k,           0x42, 0xF042,    0x42, 0xF042,    0x1C, 0xF01C,
	SDLK_l,           0x4B, 0xF04B,    0x4B, 0xF04B,    0x1C, 0xF01C,
	SDLK_SEMICOLON,   0x4C, 0xF04C,    0x4C, 0xF04C,    0x4C, 0xF04C,
	SDLK_QUOTE,       0x52, 0xF052,    0x52, 0xF052,    0x52, 0xF052,
	SDLK_HASH,        0x5D, 0xF05D,    0x5D, 0xF05D,    0x5D, 0xF05D,
	SDLK_RETURN,      0x5A, 0xF05A,    0x5A, 0xF05A,    0x5A, 0xF05A,
	SDLK_LSHIFT,      0x12, 0xF012,    0x12, 0xF012,    0x12, 0xF012,
	SDLK_BACKSLASH,	  0x61, 0xF061,    0x61, 0xF061,    0x61, 0xF061,
	SDLK_z,           0x1A, 0xF01A,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_x,           0x22, 0xF022,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_c,           0x21, 0xF021,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_v,           0x2A, 0xF02A,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_b,           0x32, 0xF032,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_n,           0x31, 0xF031,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_m,           0x3A, 0xF03A,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_COMMA,       0x41, 0xF041,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_PERIOD,      0x49, 0xF049,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_SLASH,       0x4A, 0xF04A,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_RSHIFT,      0x59, 0xF059,    0x1A, 0xF01A,    0x1A, 0xF01A,
	SDLK_LCTRL,	  0x14, 0xF014,	   0x14, 0xF014,    0x1D,   0x9D,
	SDLK_LALT,	  0x11, 0xF011,	   0x11, 0xF011,    0x38,   0xB8,
	SDLK_SPACE,	  0x29, 0xF029,    0x29, 0xF029,    0x39,   0xB9,
	SDLK_RALT,	0xE011, 0xE0F011,  0xE011, 0xE0F011,0x38,   0xB8,
	SDLK_RCTRL,	0xE014, 0xE0F014,  0xE014, 0xE0F014,0x1D,   0x9D,

	SDLK_UP,	0xE075, 0xE0F075, 0xE075, 0xE0F075, 0xE075, 0xE0F075,
	SDLK_DOWN,	0xE072, 0xE0F072, 0xE072, 0xE0F072, 0xE072, 0xE0F072,
	SDLK_LEFT,	0xE06B, 0xE0F06B, 0xE06B, 0xE0F06B, 0xE06B, 0xE0F06B,
	SDLK_RIGHT,	0xE074, 0xE0F074, 0xE074, 0xE0F074, 0xE074, 0xE0F074,
};

/* Translated scancodes */
/*
static int kc_maps[] = 
{
//	 SDL key 	  Codes 1 	   Codes 2 	    Codes 3 
	SDLK_ESCAPE,	  0x01,   0x81,	   0x01,   0x81,    0x01,   0x81,

	SDLK_TAB,	  0x0F,   0x8F,    0x0F,   0x8F,    0x0F,   0x8F,
	SDLK_q,		  0x10,   0x90,    0x10,   0x90,    0x10,   0x90,
	SDLK_w,		  0x11,   0x91,    0x11,   0x91,    0x11,   0x91,
	SDLK_e,		  0x12,   0x92,    0x12,   0x92,    0x12,   0x92,
	SDLK_r,		  0x13,   0x93,    0x13,   0x93,    0x13,   0x93,
	SDLK_t,		  0x14,   0x94,    0x14,   0x94,    0x14,   0x94,
	SDLK_LCTRL,	  0x1D,   0x9D,	   0x1D,   0x9D,    0x1D,   0x9D,
	SDLK_LALT,	  0x38,   0xB8,	   0x38,   0xB8,    0x38,   0xB8,
	SDLK_SPACE,	  0x39,   0xB9,    0x39,   0xB9,    0x39,   0xB9,
	SDLK_F1,	  0x3B,   0xBB,    0x3B,   0xBB,    0x3B,   0xBB,
	SDLK_F2,	  0x3C,   0xBC,    0x3C,   0xBC,    0x3C,   0xBC,
	SDLK_F3,	  0x3D,   0xBD,    0x3D,   0xBD,    0x3D,   0xBD,
	SDLK_F4,	  0x3E,   0xBE,    0x3E,   0xBE,    0x3E,   0xBE,
	SDLK_F5,	  0x3F,   0xBF,    0x3F,   0xBF,    0x3F,   0xBF,
	SDLK_F6,	  0x40,   0xC0,    0x40,   0xC0,    0x40,   0xC0,
	SDLK_F7,	  0x41,   0xC1,    0x41,   0xC1,    0x41,   0xC1,
	SDLK_F8,	  0x42,   0xC2,    0x42,   0xC2,    0x42,   0xC2,
	SDLK_F9,	  0x43,   0xC3,    0x43,   0xC3,    0x43,   0xC3,
	SDLK_F10,	  0x44,   0xC4,    0x44,   0xC4,    0x44,   0xC4,
	
	SDLK_F11,	  0x57,   0xD7,    0x57,   0xD7,    0x57,   0xD7,
	SDLK_F12,	  0x58,   0xD8,    0x58,   0xD8,    0x58,   0xD8,

	SDLK_RALT,	0xE038, 0xE0B8,  0xE038, 0xE0B8,  0xE038, 0xE0B8,
	SDLK_RCTRL,	0xE01D, 0xE09D,  0xE01D, 0xE09D,  0xE01D, 0xE09D,
};
*/



PcKeyboard::PcKeyboard(PcwSystem *s) :
        PcwDevice("keyboard", "pc102"), PcwInput(s)
{
        reset();
}


PcKeyboard::~PcKeyboard()
{

}

void PcKeyboard::reset(void)
{
	clearKeys();
	m_queue.clear();
	m_cmdActive = 0;
	m_scanSet = 1;
	m_typematic = 0x2C;
	m_enabled = true;
}

int PcKeyboard::handleEvent(SDL_Event &e)
{
        bool b = false;
        int rv = 0;
	int n;
        Uint16 *km;
        SDLKey keysym = SDLK_UNKNOWN;

        if (e.type == SDL_KEYDOWN || e.type == SDL_KEYUP)
        {
                b = (e.type == SDL_KEYDOWN);
                keysym = e.key.keysym.sym;
     
		for (n = 0; n < sizeof(kc_maps); n += 7)
		{
			if (keysym == kc_maps[n])
			{
				n++;
				if (!b) n++;
				n = kc_maps[n];
				switch(n)	/* Special cases... */
				{
					case 0xFFFFFFFE:	// PrtSc up
					pushKey(0xE0);
					pushKey(0xF0);
					pushKey(0x12);
					pushKey(0xE0);
					pushKey(0xF0);
					pushKey(0x7C);
					return 1;	

					case 0xFFFFFFF9:	// PAUSE down
					pushKey(0xE1);
					pushKey(0x14);
					pushKey(0x77);
					pushKey(0xE1);
					pushKey(0xF0);
					pushKey(0x14);
					pushKey(0xF0);
					pushKey(0x77);
					return 1;	
					case 0xFFFFFFF8:	// PAUSE up
					return 1;
				}	
				if (n & 0xFF000000) 
				{
					pushKey((n >> 24) & 0xFF);
					n &= 0xFFFFFF;	
				}
				if (n & 0xFF0000) 
				{
					pushKey((n >> 16) & 0xFF);
					n &= 0xFFFF;	
				}
				if (n & 0xFF00) 
				{
					pushKey((n >> 8) & 0xFF);
					n &= 0xFF;
				}
				pushKey(n);
				return 1;
			}
		}
	}

        switch(e.type)
        {
                case SDL_QUIT: rv = -99; break;
                case SDL_KEYDOWN:
                	//m_keyPress = true;
                        rv = 1;
                        break;
                case SDL_KEYUP:
                        //m_keyPress = true;
                        rv = 1;
                        break;
        }
	return 0;
}
//
// Settings functions.
// See if this device has user-settable options. If it does, populates
// "key" and "caption" and returns true; else, returns false.
//
bool PcKeyboard::hasSettings(SDLKey *key, string &caption)
{
        *key     = SDLK_k;
        caption = "  Keyboard  ";
        return true;
}
//
// Display settings screen
// 
UiEvent PcKeyboard::settings(UiDrawer *d)
{
	return UIE_CONTINUE;
}
//
// Implement the JOYCE "Assign key" calls
//
void PcKeyboard::assignKey(Uint16 key, Uint8 l, Uint8 h)
{

}


void PcKeyboard::edfe(Z80 *R)
{

}


void PcKeyboard::clearKeys(void)
{
	m_queue.clear();
}


bool PcKeyboard::parseNode(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
	return true;
}

bool PcKeyboard::storeNode(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
	return true;
}

void PcKeyboard::setRange(int *R, byte a, byte b, byte c, byte d)
{

}


void PcKeyboard::keySet(void)
{

}


void PcKeyboard::pushKey(byte kc)
{
	m_queue.push_back(kc);
}

void PcKeyboard::onCommand()
{
	fprintf(stderr, "PcKeyboard::onCommand(%02x)\n", m_command);

	/* Are we in the middle of an existing command? */
	switch(m_cmdActive)
	{
		case 0xED:	m_cmdActive = 0;
				if (!(m_command & 0x80))
				{
					pushKey(0xFA);
					m_leds = m_command;
					updateLEDs();
					return;
				}
				break;
		case 0xF0:	m_cmdActive = 0;
				if (m_command < 4)
				{
					pushKey(0xFA);
					if (m_command == 0) pushKey(m_scanSet);
					else m_scanSet = m_command;
					return;	
				}
				pushKey(0xFE);
				return;
		case 0xF3:	m_cmdActive = 0;
				if (!(m_command & 0x80))
				{
					pushKey(0xFA);
					m_typematic = m_command;
					// XXX SDL_set_typematic	
					return;
				}
				break;
		
	}

	switch(m_command)
	{
		case 0xED:	pushKey(0xFA);	// Acknowledge
				m_cmdActive = 0xED;
				break;
		case 0xEE:	pushKey(0xEE);	// Diagnostic echo
				break;
		case 0xF0:	pushKey(0xFA);
				m_cmdActive = 0xF0;	// Set scancode set
				break;
		case 0xF2:	pushKey(0xFA);	// Get keyboard ID
				pushKey(0xAB);
				pushKey(0x83);
				break;	
		case 0xF3:	pushKey(0xFA);	// Set rate/delay
				m_cmdActive = 0xF3;
				break;
		case 0xF4:	m_queue.clear(); // Clear queue
				m_enabled = true;
				pushKey(0xFA);	// Acknowledge command
				break;
		case 0xF5:	m_enabled = false;	// Disable
				// Fall through to
		case 0xF6:	reset();		// Set defaults
				pushKey(0xFA);
				break;
		case 0xFF: // Full keyboard reset
				reset();
				pushKey(0xFA);	// Acknowledge command
				pushKey(0xAA);	// Self-test OK
				break;
		default:	pushKey(0xFE);	// Unknown command
				fprintf(stderr, "Unknown kbd command %02x\n", m_command);
				break;
		
	}
}



/* Default implementation doesn't touch the LEDs */
void PcKeyboard::updateLEDs(void)
{
}

