/*
    RTC Flash - Firmware updater for the M3002 RTC replacement 'Re3002'.
    Copyright (C) 2013  Oliver Tscherwitschke <oliver@tscherwitschke.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <conio.h>
#include <bios.h>

#include "rtc.h"
#include "main.h"


// The IO Port address of the M3002
unsigned int rtc_io_port = RTC_IO;



void rtcSync(void)
{
    inp(rtc_io_port);
	inp(rtc_io_port);
}

unsigned char rtcRead(unsigned char adr, unsigned char* data)
{
	unsigned char data1, data2;
    unsigned int retry;

    for (retry = 1000; retry > 0; retry--)
    {
    	data1 = inp(rtc_io_port) & 0x0F;
        if (data1 == 0)
            break;
	}
//    putchar('.');

    if (data1 != 0)
        return ERROR;

    rtcSync();

#if 0
	outp(rtc_io_port, adr);
    data1 = inp(rtc_io_port);
	data2 = inp(rtc_io_port);
#else
    asm {
        mov dx, rtc_io_port
        mov al, adr
        out dx, al
        in al, dx
        mov bl, al
        in al, dx

        mov data1, bl
        mov data2, al
    }
#endif

    *data = (data1 << 4) | (data2 & 0x0F);
    return OK;
}

unsigned char rtcWrite(unsigned char adr, unsigned char data)
{
	unsigned char data1, data2;
    unsigned int retry;
    unsigned char ready;

    data1 = data >> 4;
    data2 = data & 0x0F;

    for (retry = 1000; retry > 0; retry--)
    {
    	ready = inp(rtc_io_port) & 0x0F;
        if (ready == 0)
            break;
	}
    if (ready != 0)
        return ERROR;       // timeout

    rtcSync();

#if 0
	outp(rtc_io_port, adr);
    outp(rtc_io_port, data1);
	outp(rtc_io_port, data2);
#else
    asm {
        mov dx, rtc_io_port
        mov al, adr
        out dx, al
        mov al, data1
        out dx, al
        mov al, data2
        out dx, al
    }
#endif

    return OK;
}



void rtcWait(void)
{
	unsigned char data;
    long startTicks;
    long t;

    startTicks = biostime(0, 0);
    do
    {
    	data = inp(rtc_io_port) & 0x0F;
        t = biostime(0, 0) - startTicks;
	}
    while (data != 0x0F && t <= _BIOS_CLOCKS_PER_SEC);

    startTicks = biostime(0, 0);
    do
    {
    	data = inp(rtc_io_port) & 0x0F;
        t = biostime(0, 0) - startTicks;
	}
    while (data != 0x00 && t <= _BIOS_CLOCKS_PER_SEC);
}
