/*
    Re3002 - An M3002 RTC replacement
    Copyright (C) 2013  Oliver Tscherwitschke <oliver@tscherwitschke.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


; ==============================================================
; TWI Status codes

; Common Status codes for Master Transmitter and Receiver Mode
.EQU START          = 0x08
.EQU REP_START      = 0x10

; Status codes for Master Transmitter Mode
.EQU MT_SLAW_ACK    = 0x18
.EQU MT_DATA_ACK    = 0x28


; Status codes for Master Receiver Mode
.EQU MR_SLAR_ACK    = 0x40
.EQU MR_DATA_NACK   = 0x58


; ==============================================================
; Poll TWCR and wait until TWINT flag is set, indicating that
; the previous action was completed.
.MACRO TWINT_WAIT
_wait:
    lds temp, TWCR
    sbrs temp, TWINT
    rjmp _wait
.ENDMACRO


; ==============================================================
; Send START condition and wait until it was sent
; OUT:  R24 = TWI Status after data was sent
; 
twi_start:
    ; Send START
    ldi temp, (1 << TWINT) | (1 << TWSTA) | (1 << TWEN)
    sts TWCR, temp

    ; Wait for completion
    TWINT_WAIT

    ; Read TWI Status Register and return the status code
    lds R24, TWSR
    andi R24, 0xF8
    ret


; ==============================================================
; Send one byte and return status.
; IN:   R24 = Data to be sent
; OUT:  R24 = TWI Status after data was sent
;
twi_send:
    ; Send data
    sts TWDR, R24
    ldi temp, (1 << TWINT) | (1 << TWEN)
    sts TWCR, temp

    ; Wait for completion
    TWINT_WAIT

    ; Read TWI Status Register and return the status code
    lds R24, TWSR
    andi R24, 0xF8
    ret


; ==============================================================
; Send STOP condition
;
twi_stop:
    ldi temp, (1 << TWINT) | (1 << TWEN) | (1 << TWSTO)
    sts TWCR, temp

    ; Wait until STOP was sent (TWSTO bit is cleared)
stop_wait:
    lds temp, TWCR
    sbrc temp, TWSTO
    rjmp stop_wait
    
    ret

