; AY-3-8912 Programmable Sound Generator emulation for CPE
; Gravis Ultrasound module
; Copyright (c) 1995-97 by Ulrich Doewich
; cyrel@interlog.com

;	v0.01	Jun. 11, 1995 - 17:32
;	v0.02	Jun. 14, 1995 - 14:53
;	v0.03	Jun. 15, 1995 - 11:14
;	v0.04	Jun. 15, 1995 - 21:31
;	v0.05	Jun. 16, 1995 - 19:25
;	v0.06	Jun. 16, 1995 - 23:48
;	v0.07	Jun. 17, 1995 - 17:53
;	v0.08	Jun. 19, 1995 - 10:53
;	v0.09	Jun. 19, 1995 - 20:32
;	v0.10	Jun. 21, 1995 - 17:34
;	v0.11	Jun. 25, 1995 - 23:05
;	v0.12	Jun. 27, 1995 - 12:39
;	v0.13	Jul.  2, 1995 - 11:14
;	v0.14	Jul.  3, 1995 - 13:09
;	v0.15	Jul.  6, 1995 - 14:57
;	v0.16	Jul.  7, 1995 - 21:17
;	v0.17	Jul. 12, 1995 - 14:52
;	v0.18	Jul. 17, 1995 - 10:25
;	v0.19	Jul. 18, 1995 - 19:36
;	v0.20	Jul. 21, 1995 - 21:29

;	v1.00	Jul. 23, 1995 - 18:48	first public release!
;	v1.01	Sep.  9, 1995 - 17:26	fixed enable sound toggle
;	v1.02	Sep. 15, 1995 - 12:33	attempting to speed up sound code
;	v1.03	Nov.  9, 1995 - 18:07	reduced volume table by factor of 8
;	v1.04	Nov. 30, 1995 - 12:12	installed IRQ setup/ cleanup routines
;	v1.05	Dec. 10, 1995 - 10:47	envelope routines seem to work fine..
;					except IRQ handler is still not being
;					called!
;	v1.06	Jan. 12, 1996 - 15:46	Finally got the IRQ handler working!
;	v1.07	Jan. 17, 1996 - 10:32	totally rewrote volume/envelope handling
;	v1.08	Jan. 25, 1996 - 09:40	fixed IRQ install bug + installed new
;					envelope period calculation
;	v1.09	Jan. 25, 1996 - 19:08	fixed the 'missing sound' bug
;	v1.10	Jan. 27, 1996 - 13:06	tidied up code
;	v1.11	Oct.  6, 1996 - 14:12	added sound output pause & resume code

;	v2.00	Nov. 27, 1996 - 23:04	changed GUS code to DMA based driver
;	v2.01	Nov. 30, 1996 - 20:40
;	v2.02	Apr. 12, 1997 - 13:25	converted to variable tab stops
;	v2.03	Apr. 27, 1997 - 19:23	changed to mono driver + rollover
;	v2.04	Apr. 28, 1997 - 21:31	single shot DMA code

ideal
P386

PAGE_REG	equ	102h
SEL_REG		equ	103h
GDATA_LOW	equ	104h
GDATA_HIGH	equ	105h

VOICECTRL_REG	equ	00h
FREQCTRL_REG	equ	01h
STARTHI_REG	equ	02h
STARTLOW_REG	equ	03h
ENDHI_REG	equ	04h
ENDLOW_REG	equ	05h
VOLUME_REG	equ	09h
CURRHI_REG	equ	0ah
CURRLOW_REG	equ	0bh
PANPOS_REG	equ	0ch
VOLRAMPCTRL_REG	equ	0dh
VOICES_REG	equ	0eh
DMACTRL_REG	equ	41h
DMAADDR_REG	equ	42h
SAMPCTRL_REG	equ	49h
RESET_REG	equ	4ch
IRQSOURCE_REG	equ	8fh

DMA_MASKPORT	equ	0ah
DMA_CLEARPORT	equ	0ch

; from ipe1.asm
extrn		SCinstalled:WORD, SCport:WORD, SCirq:WORD, SCdma:WORD
extrn		DMAblocklen:WORD, SCsrate:WORD, stereo_flag:WORD, usesound:WORD

; from snd.asm
extrn		init_SC:PROC, setup_DMA:PROC, init_mixing:PROC
extrn		install_handler:PROC, uninstall_handler:PROC
extrn		buffer_addr:WORD, DMA_addrport:BYTE, DMA_countport:BYTE, DMA_mode:BYTE
extrn		DMA_stopmask:BYTE

public		GUS_reset, GUS_shutdown, GUS_pause, GUS_continue, GUS_clrINT

group		DGROUP _stack, _data

segment	_text	page public 'CODE'
assume		cs:_text
assume		ds:DGROUP

; ________________________________________________________________________

; USES:
;	cx

delay:
		push	ax
		push	dx
		mov	cx, 7
		mov	dx, [SCport]
delay_loop:
		in	al, dx
		loop	delay_loop
		pop	dx
		pop	ax
		ret		

; ________________________________________________________________________

; IN:
;	al	register
;	ah	value

; USES:
;	ax dx

write_8bit:
		mov	dx, [SCport]
		add	dx, SEL_REG
		out	dx, al
		add	dx, 2				; global data high
		mov	al, ah
		out	dx, al
		call	delay
		out	dx, al
		ret

; ________________________________________________________________________

; IN:
;	al	register
;	bx	value

; USES:
;	ax dx

write_16bit:
		mov	dx, [SCport]
		add	dx, SEL_REG
		out	dx, al
		inc	dx				; global data low
		mov	ax, bx
		out	dx, ax
		call	delay
		out	dx, ax
		ret

; ________________________________________________________________________

GUS_reset:
		call	init_SC				; setup IRQ/DMA vars
		call	init_mixing			; setup DMA buffer

		mov	al, RESET_REG
		mov	ah, 0				; enable reset mode
		call	write_8bit
		mov	al, RESET_REG
		mov	ah, 1				; disable reset mode
		call	write_8bit

		mov	dx, [SCport]			; mix control register
		mov	al, 4bh				; IRQ setup..
		out	dx, al
		xor	cx, cx
		mov	cl, [IRQ_table]
		mov	bx, 1
		mov	ah, [byte ptr SCirq]
GUSr_lp1:
		mov	al, [IRQ_table + bx]
		cmp	al, ah
		je	GUSr_gotIRQ
		inc	bx
		loop	GUSr_lp1
		jmp	GUSr_error
GUSr_gotIRQ:
		dec	cx
		mov	dx, [SCport]
		add	dx, 0bh				; IRQ/DMA control
		mov	al, cl
		or	al, 40h
		out	dx, al

		mov	dx, [SCport]			; mix control register
		mov	al, 0bh				; DMA setup..
		out	dx, al
		xor	cx, cx
		mov	cl, [DMA_table]
		mov	bx, 1
		mov	ah, [byte ptr SCdma]
GUSr_lp2:
		mov	al, [DMA_table + bx]
		cmp	al, ah
		je	GUSr_gotDMA
		inc	bx
		loop	GUSr_lp2
		jmp	GUSr_error
GUSr_gotDMA:
		dec	cx
		mov	al, 40h
		or	al, cl
		mov	dx, [SCport]
		add	dx, 0bh				; IRQ/DMA control
		out	dx, al

		call	install_handler			; install INT handler

		mov	al, VOICES_REG
		mov	ah, 13				; 14 voices for 44kHz
		cmp	[SCsrate], 0
		jne	GUSr_setvoices
		mov	ah, 27				; 28 voices for 22kHz
GUSr_setvoices:
		or	ah, 0c0h			; set bits 6 & 7
		call	write_8bit

		mov	bx, 31
GUSr_cvloop:
		mov	dx, [SCport]
		add	dx, PAGE_REG
		mov	ax, bx				; select voice
		out	dx, al
		mov	al, VOICECTRL_REG
		mov	ah, 3				; stop voice
		call	write_8bit
		dec	bx				; loop for all voices
		jns	GUSr_cvloop

		mov	dx, [SCport]
		add	dx, PAGE_REG
		xor	al, al				; select voice 0
		out	dx, al
		mov	al, FREQCTRL_REG
		mov	bx, 1				; 22/44kHz
		call	write_16bit
		mov	al, STARTHI_REG
		mov	bx, 0				; start address high
		call	write_16bit
		mov	al, STARTLOW_REG
		mov	bx, 0				; start address low
		call	write_16bit
		mov	al, CURRHI_REG
		mov	bx, 0				; current address high
		call	write_16bit
		mov	al, CURRLOW_REG
		mov	bx, 0				; current address low
		call	write_16bit
		mov	al, ENDHI_REG
		mov	bx, 0				; end address high
		call	write_16bit
		mov	al, ENDLOW_REG
		mov	bx, [DMAblocklen]		; end address low
		dec	bx
		call	write_16bit
		mov	al, PANPOS_REG
		mov	ah, 7				; center position
		call	write_8bit
		mov	al, VOLUME_REG
		mov	bx, 0be00h
		call	write_16bit
		mov	al, VOLRAMPCTRL_REG
		mov	ah, 4				; enable rollover
		call	write_8bit

		and	[DMA_mode], 0efh		; disable auto init
		call	setup_DMA			; setup DMA controller
		mov	ax, [buffer_addr]
		mov	[DMA_1stbuffer], ax
		add	ax, [DMAblocklen]
		mov	[DMA_2ndbuffer], ax

		mov	dx, [SCport]			; mix control register
		mov	al, 9				; enable Line Out
		out	dx, al
		ret
GUSr_error:
		mov	[SCinstalled], 0
		ret

; ________________________________________________________________________

GUS_shutdown:
		cmp	[SCinstalled], 0
		jne	GUSsd_cont
		ret
GUSsd_cont:
		mov	al, DMACTRL_REG
		mov	ah, 20h				; stop DMA transfer
		call	write_8bit
		mov	dx, DMA_MASKPORT
		mov	al, [DMA_stopmask]
		out	dx, al				; stop DMA controller

		mov	dx, [SCport]
		add	dx, PAGE_REG
		mov	al, 0				; select voice 0
		out	dx, al
		mov	al, VOICECTRL_REG
		mov	ah, 3				; stop voice
		call	write_8bit

		jmp	uninstall_handler

; ________________________________________________________________________

GUS_pause:
		cmp	[usesound], 0
		je	GUSp_exit

		cli
		pushad
		mov	al, RESET_REG
		mov	ah, 1				; disable DACs
		call	write_8bit
		mov	dx, [SCport]
		add	dx, PAGE_REG
		xor	al, al				; select voice 0
		out	dx, al
		mov	al, VOICECTRL_REG
		mov	ah, 3				; stop voice
		call	write_8bit
		popad
		sti
GUSp_exit:
		ret

; ________________________________________________________________________

GUS_continue:
		cmp	[usesound], 0
		je	GUSc_exit

		cli
		pushad
		mov	dx, [SCport]
		add	dx, PAGE_REG
		xor	al, al				; select voice 0
		out	dx, al
		mov	al, VOICECTRL_REG
		mov	ah, 20h				; start voice
		cmp	[rollover], 1
		je	GUSc_cont
		mov	ah, 28h				; enable loop
GUSc_cont:
		call	write_8bit
		mov	al, RESET_REG
		mov	ah, 7				; enable DACs
		call	write_8bit
		popad
		sti
GUSc_exit:
		ret

; ________________________________________________________________________

GUS_clrINT:
		mov	dx, [SCport]
		add	dx, SEL_REG
		mov	al, IRQSOURCE_REG
		out	dx, al
		add	dx, 2
		in	al, dx				; clear all IRQs

		cmp	[rollover], 1			; rollover INT?
		jne	GUSci_cont
		mov	[rollover], 0

		xor	al, al
		out	DMA_CLEARPORT, al
		movzx	dx, [DMA_addrport]
		mov	ax, [DMA_1stbuffer]
		out	dx, al
		mov	al, ah
		out	dx, al
		movzx	dx, [DMA_countport]
		mov	ax, [DMAblocklen]
		dec	ax
		out	dx, al
		mov	al, ah
		out	dx, al

		mov	dx, [SCport]
		add	dx, PAGE_REG
		xor	al, al				; select voice 0
		out	dx, al
		inc	dx				; select register
		mov	al, VOLRAMPCTRL_REG
		out	dx, al
		add	dx, 2				; global data high
		mov	al, 0				; disable rollover
		out	dx, al
		sub	dx, 2				; select register
		mov	al, VOICECTRL_REG
		out	dx, al
		add	dx, 2				; global data high
		mov	al, 28h				; enable loop
		out	dx, al
		sub	dx, 2				; select register
		mov	al, ENDLOW_REG
		out	dx, al
		inc	dx				; global data low
		mov	ax, [DMAblocklen]
		shl	ax, 1
		dec	ax
		out	dx, ax

		dec	dx				; select register
		mov	al, DMAADDR_REG
		out	dx, al
		inc	dx				; global data low
		mov	ax, 0				; 1st DMA buffer
		out	dx, ax
		dec	dx				; select register
		mov	al, DMACTRL_REG
		out	dx, al
		add	dx, 2
		mov	al, 1				; start DMA
		out	dx, al
		ret
GUSci_cont:
		mov	[rollover], 1

		xor	al, al
		out	DMA_CLEARPORT, al
		movzx	dx, [DMA_addrport]
		mov	ax, [DMA_2ndbuffer]
		out	dx, al
		mov	al, ah
		out	dx, al
		movzx	dx, [DMA_countport]
		mov	ax, [DMAblocklen]
		dec	ax
		out	dx, al
		mov	al, ah
		out	dx, al

		mov	dx, [SCport]
		add	dx, PAGE_REG
		xor	al, al				; select voice 0
		out	dx, al
		inc	dx				; select register
		mov	al, VOLRAMPCTRL_REG
		out	dx, al
		add	dx, 2				; global data high
		mov	al, 4				; enable rollover
		out	dx, al
		sub	dx, 2				; select register
		mov	al, VOICECTRL_REG
		out	dx, al
		add	dx, 2				; global data high
		mov	al, 20h				; disable loop
		out	dx, al
		sub	dx, 2				; select register
		mov	al, ENDLOW_REG
		out	dx, al
		inc	dx				; global data low
		mov	ax, [DMAblocklen]
		dec	ax
		out	dx, ax

		dec	dx				; select register
		mov	al, DMAADDR_REG
		out	dx, al
		inc	dx				; global data low
		mov	ax, [DMAblocklen]		; 2nd DMA buffer
		dec	ax
		out	dx, ax
		dec	dx				; select register
		mov	al, DMACTRL_REG
		out	dx, al
		add	dx, 2
		mov	al, 1				; start DMA
		out	dx, al
		ret

; ________________________________________________________________________

ends

segment	_data page public 'DATA'

rollover	dw	1
DMA_1stbuffer	dw	0
DMA_2ndbuffer	dw	0

IRQ_table	db	8, 15, 12, 11, 7, 3, 5, 2, 0
DMA_table	db	6, 7, 6, 5, 3, 1, 0

ends

; ________________________________________________________________________

segment	_stack para stack 'STACK'
ends

end

