/*	parse.c		Parsing subroutines
				Copyright (c) 1996 by Ulrich Doewich

	v1.00	Mar. 25, 1996 - 11:08
	v1.01	Nov. 10, 1996 - 01:07	general cleanup
*/

#include "parse.h"

// .......................................................................

char *find_eol (char *source)
{
	for (; *source && *source!=0x0a && *source!=0x0d; source++);
	return (source);
}

// .......................................................................

char *find_next_line (char *source)
{
	for (; *source==0x0a || *source==0x0d; source++);
	return (source);
}

// .......................................................................

char *skip_spaces (char *source)
{
	for (; *source==' ' || *source==0x09 || *source==','; source++);
	return (source);
}

// .......................................................................

char *skip_string (char *source)
{
	for (; *source!=' ' && *source!=0x09; source++);
	return (source);
}

// .......................................................................

int check_remark (char *first, char *current)
{
	int	flag = 0;

	do {
		flag |= *current == ';' ? 1 : 0;
		current--;
	}
	while (current >= first && *current && *current != 0x0a && *current != 0x0d);
	return (flag);
}

// .......................................................................

char *search_command (char *source, char *check)
{
	char *p;
	p = strstr(source, check);
	if (!p)
		return (p);
	else {
		if (!check_remark(source, p)) {
			p = skip_string(p);
			return (skip_spaces(p));
		}
		else
			return (FALSE);
	}
}

// .......................................................................

void copy_argument (char *source, char *dest, int cntr)
{
	if (!cntr) {
		for (; *source && *source!=0x09
					   && *source!=0x0a
					   && *source!=0x0d
					   && *source!=' '
					   && *source!=','; *dest++=*source++);
	}
	else
		for (; cntr; cntr--)
			*dest++ = *source++;
	*dest = 0;
}

// .......................................................................

char *store_string (char *dest, char *source)
{
	for (; *source; *dest++ = *source++);
	return (dest);
}
