/* 	CPESETUP - Setup Utility for CPE
	Copyright (c) 1995,96 by Bernd Schmidt
	C port and additions Copyright (c) 1996,97 by Ulrich Doewich

	v0.01	Nov.  2, 1996 - 17:00
	v0.02	Nov.  3, 1996 - 11:58	everything done except joystick calibration
	v0.03	Nov.  3, 1996 - 19:51	reorganized data file and added new options
	v0.04	Nov.  4, 1996 - 23:46	automatic detection of SB & GUS parameters
	v0.05	Nov.  5, 1996 - 22:04	ESS parameter detection
	v0.06	Nov.  6, 1996 - 22:47	joystick calibration
	v0.07	Nov. 10, 1996 - 13:54	colour table import option
	v0.08	Nov. 18, 1996 - 18:48	hex value display fixed
	v0.09	Jan. 19, 1997 - 21:11	preliminary file system setup menu
	v0.10	Jan. 26, 1997 - 19:58	all sound settings available to SB users
	v0.11	Feb.  1, 1997 - 18:44	reworked file system setup
	v0.12	Feb. 23, 1997 - 19:18	removed joystick calibration
	v0.13	Apr. 19, 1997 - 00:11	removed CPE.EXE specific settings
	v0.14	Apr. 19, 1997 - 22:12	default to "bright" colour table
	v0.15	Apr. 19, 1997 - 22:40	determine default paths for file system
	v0.16	Apr. 28, 1997 - 10:45	first checks for TEMP environment variable
*/

#include <conio.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "parse.h"

#define OPTIONS		23
#define VER_NUM		"v5.2"

#define	FALSE		0
#define	TRUE		!FALSE

#define YES			1
#define NO			0

#define SCport		7
#define SCWport		8
#define	SCMirq		9
#define SCirq		10
#define SCdma		11
#define DMAbuflen	12
#define SCsrate		13
#define SCstereo	14
#define usesound	20

typedef	unsigned char	byte;
typedef	unsigned int	word;
typedef	unsigned long	dword;

enum pref_group {
	general, cpe2
};
enum pref_type {
	dec_value, hex_value, yes_no, cpc_type, printer_port, sc_type, kbd_type,
	sc_srate
};

struct t_prefs {
	enum pref_group	group;
	byte			text[40];
	enum pref_type	type;
	word			def_value,
					value;
	byte			status;
};

struct t_prefs prefs[OPTIONS] = {
	cpe2, 	 "Screen refresh rate", dec_value, 0, 0, YES,
	cpe2, 	 "Use 800x600 VESA mode", yes_no, 0, 0, YES,
	cpe2, 	 "Use small screen in VESA mode", yes_no, 0, 0, YES,
	cpe2, 	 "Use graphical menus in VESA mode", yes_no, 0xffff, 0, YES,
	general, "CPC model", cpc_type, 3, 0, YES,
	general, "Keyboard language", kbd_type, 0, 0, YES,
	general, "Sound card", sc_type, 0, 0, YES,
	general, "Sound card base port", hex_value, 0, 0, NO,
	general, "Sound card wave port", hex_value, 0x534, 0, NO,
	general, "Sound card MIDI IRQ", dec_value, 9, 0, NO,
	general, "Sound card IRQ", dec_value, 0, 0, NO,
	general, "Sound card DMA", dec_value, 0, 0, NO,
	general, "DMA buffer length", dec_value, 0x80, 0, NO,
	general, "Audio sample rate", sc_srate, 0, 0, NO,
	general, "Stereo sound", yes_no, 0, 0, NO,
	general, "Use EMS memory", yes_no, 0xffff, 0, YES,
	general, "Printer port", printer_port, 1, 0, YES,
	general, "Quiet tape mode", yes_no, 0xffff, 0, YES,

	cpe2, 	 "Use borders in VESA mode", yes_no, 0xffff, 0, YES,
	general, "Emulate green monitor", yes_no, 0, 0, YES,
	general, "Enable sound output", yes_no, 0, 0, NO,
	general, "Utilize joystick 1", yes_no, 0, 0, YES,
	general, "Utilize joystick 2", yes_no, 0, 0, YES
};

byte def_status[OPTIONS] = {
	YES, YES, YES, YES, YES, YES, YES,
	 NO,  NO,  NO,  NO,  NO,  NO,  NO,  NO, YES, YES,
	YES, YES, YES,  NO, YES, YES
};

dword def_ctable[32] = {
	0x001f1f1f, 0x001f1f1f, 0x00003f1f, 0x003f3f1f,
	0x0000001f, 0x003f001f, 0x00001f1f, 0x003f1f1f,
	0x003f001f, 0x003f3f1f, 0x003f3f00, 0x003f3f3f,
	0x003f0000, 0x003f003f, 0x003f1f00, 0x003f1f3f,
	0x0000001f, 0x00003f1f, 0x00003f00, 0x00003f3f,
	0x00000000, 0x0000003f, 0x00001f00, 0x00001f3f,
	0x001f001f, 0x001f3f1f, 0x001f3f00, 0x001f3f3f,
	0x001f0000, 0x001f003f, 0x001f1f00, 0x001f1f3f
};

dword colour_table[32] = {
	0x002f2f2f, 0x002f2f2f, 0x00003f2f, 0x003f3f2f,
	0x0000002f, 0x003f002f, 0x00002f2f, 0x003f2f2f,
	0x003f002f, 0x003f3f2f, 0x003f3f00, 0x003f3f3f,
	0x003f0000, 0x003f003f, 0x003f2f00, 0x003f2f3f,
	0x0000002f, 0x00003f2f, 0x00003f00, 0x00003f3f,
	0x00000000, 0x0000003f, 0x00002f00, 0x00002f3f,
	0x002f002f, 0x002f3f2f, 0x002f3f00, 0x002f3f3f,
	0x002f0000, 0x002f003f, 0x002f2f00, 0x002f2f3f
};

byte CPCa_path[80];
byte CPCb_path[80];
byte snappath[80];
byte temppath[80];
byte archiver[80];

char *dec_nums = "0123456789";
char *hex_nums = "0123456789abcdef";
char str[40], tmp[10], input_file[40];
FILE *stream;


// _______________________________________________________________________

int find_char (char *line, char ch)
{
	int	len, num;

	len = strlen(line);
	num = 0;
	while ((*line++ != ch) && (num < len))
		num++;
	if (num < len)
		return (num);
	else
		return (-1);
}

// _______________________________________________________________________

int input (char *str, int num, char *valid)
{
	char *ptr, ch;
	int	pos;

	pos = 0;
	ptr = &str[0];
	*ptr = 0;

	while((ch = getch()) != 0xd) {
		if(ch == 8 && pos > 0) {
			cprintf("\010 \010");
			pos--;
			ptr--;
		}
		if(ch == 0x1b)
			return 0;
		if((pos < num) && (find_char(valid, ch) != -1)) {
			putch(ch);
			pos++;
			*ptr++ = ch;
		}
	}
	*ptr = 0;
	return 1;
}

// _______________________________________________________________________

char *hex(word val)
{
	char *ptr;

	str[39] = 0;
	ptr = &str[38];
	do {
		*ptr-- = hex_nums[val & 15];
		val = val >> 4;
	} while (val);
	*ptr-- = 'x';
	*ptr = '0';

	return (ptr);
}

// _______________________________________________________________________

char *yesno(word val)
{
	if (!val)
		return ("No");
	else
		return ("Yes");
}

// _______________________________________________________________________

char *scard(word val)
{
	switch (val) {
		case 0: return("None");
		case 1: return("SoundBlaster");
		case 2: return("Gravis Ultrasound");
		case 3: return("Ensoniq Soundscape");
	}
	return ("Unkown..");
}

// _______________________________________________________________________

char *cpc(word val)
{
	switch (val) {
		case 1: return("464");
		case 2: return("664");
		case 3: return("6128");
	}
	return ("Unkown..");
}

// _______________________________________________________________________

char *kbd(word val)
{
	switch (val) {
		case 0: return("English (UK)");
		case 1: return("French");
		case 2: return("German");
	}
	return ("Unkown..");
}

// _______________________________________________________________________

char *srate(word val)
{
	if (!val)
		return ("22kHz");
	else
		return ("44kHz");
}

// _______________________________________________________________________

void get_dec(word *val)
{
	cprintf("Enter new value: ");
	if(input(str, 3, dec_nums))
		*val = atoi(str);
}

// _______________________________________________________________________

void get_hex(word *val)
{
	cprintf("Enter new value in HEXadecimal notation: ");
	if(input(str, 4, hex_nums))
		*val = (word)strtol(str, NULL, 16);
}

// _______________________________________________________________________

void get_yesno(word *val)
{
	if (*val)
		*val = 0;
	else
		*val = 0xffff;
}

// _______________________________________________________________________

byte read_DSP(void)
{
	word port;

	port = prefs[SCport].value;
	while (!(inp(port + 0xe) & 0x80)) ;
	return (inp(port + 0xa));
}

// _______________________________________________________________________

void write_DSP(byte val)
{
	word port;

	port = prefs[SCport].value;
	while (inp(port + 0xc) & 0x80) ;
	outp(port + 0xc, val);
}

// _______________________________________________________________________

int check_SB(void)
{
	char err_flag, *ptr, *end_ptr, flags;
	word ver;

	err_flag = FALSE;
	if ((ptr = getenv("BLASTER")) == NULL)
		err_flag = TRUE;
	else {
		strcpy(str, ptr);
		end_ptr = str + strlen(str) - 1;
		ptr = str;
		flags = 0;
		while (ptr != end_ptr) {
			switch(*ptr++) {
				case 'A':	copy_argument(ptr, tmp, 0);
							prefs[SCport].value = (word)strtol(tmp, NULL, 16);
							flags |= 1;
							break;
				case 'I':	copy_argument(ptr, tmp, 0);
							prefs[SCirq].value = atoi(tmp);
							flags |= 2;
							break;
				case 'D':	copy_argument(ptr, tmp, 0);
							prefs[SCdma].value = atoi(tmp);
							flags |= 4;
							break;
			}
		}

		if (flags != 7)
			err_flag = TRUE;

		else {
			write_DSP(0xe1); // get DSP version
			ver = (read_DSP() * 100) + read_DSP();
			if (ver < 200) {
				cprintf("\r\nSoundBlaster with at least DSP v2.00 required! Sorry..");
				getch();
				return (0);
			}
			prefs[SCsrate].status = YES;
			prefs[SCstereo].status = YES;
			prefs[SCport].status = YES;
			prefs[SCirq].status = YES;
			prefs[SCdma].status = YES;
			prefs[DMAbuflen].status = YES;
			prefs[usesound].value = YES;
			prefs[usesound].status = YES;
		}
	}

	if (err_flag) {
		cprintf("\r\nSoundBlaster not found.. make sure the BLASTER environment variable is set!");
		getch();
		return (0);
	}
	else
		return (1);
}

// _______________________________________________________________________

int check_GUS(void)
{
	char err_flag, *ptr;

	err_flag = FALSE;
	if ((ptr = getenv("ULTRASND")) == NULL)
		err_flag = TRUE;
	else {
		strcpy(str, ptr);
		ptr = str;
		copy_argument(ptr, tmp, 0);
		prefs[SCport].value = (word)strtol(tmp, NULL, 16);

		while(*ptr != 0 && *ptr++ != ',') ;
		copy_argument(ptr, tmp, 0);
		if (tmp[0])
			prefs[SCdma].value = atoi(tmp);
		else
			err_flag = TRUE;

		while(*ptr != 0 && *ptr++ != ',') ;
		copy_argument(ptr, tmp, 0); // skip record DMA
		while(*ptr != 0 && *ptr++ != ',') ;
		copy_argument(ptr, tmp, 0);
		if (tmp[0])
			prefs[SCirq].value = atoi(tmp);
		else
			err_flag = TRUE;
	}

	if (err_flag) {
		cprintf("\r\nUltrasound not found.. make sure the ULTRASND environment variable is set!");
		getch();
		return (0);
	}
	else {
		prefs[SCport].status = YES;
		prefs[SCirq].status = YES;
		prefs[SCdma].status = YES;
		prefs[DMAbuflen].status = YES;
		prefs[SCsrate].status = YES;
		prefs[SCstereo].value = 0; // 0xffff;
		prefs[SCstereo].status = NO;
		prefs[usesound].value = YES;
		prefs[usesound].status = YES;
		return (1);
	}
}

// _______________________________________________________________________

int get_entry(char *entry, char *dest)
{
	char static keyword[40], tmp_str[40], *ptr;

	strcpy(keyword, entry);
	strupr(keyword);
	rewind(stream);
	for (;;) {
		fgets(tmp_str, 40, stream);
		if (feof(stream))
			return (0);
		for (ptr = tmp_str; *ptr != 0; ++ptr) {
			if (*ptr == ' ' || *ptr == '\t' || *ptr == 0x0a || *ptr == 0x0d) {
				*ptr = 0;
				break;
			}
		}
		if (!(ptr = strchr(tmp_str, '=')))
			continue;
		*ptr = 0;
		strupr(tmp_str);
		if (strcmp(tmp_str, keyword))
			continue;
		for(ptr = tmp_str + strlen(tmp_str) + 1; (*dest++ = *ptr++) != 0;) ;
		break;
	}
	return (1);
}

// _______________________________________________________________________

int check_ESS(void)
{
	char err_flag, *ptr;

	err_flag = FALSE;
	if ((ptr = getenv("SNDSCAPE")) == NULL)
		err_flag = TRUE;
	else {
		strcpy(str, ptr);
		if (str[strlen(str) - 1] == '\\')
			str[strlen(str) - 1] = 0;
		strcat(str, "\\SNDSCAPE.INI");
		if ((stream = fopen(str, "r")) == NULL)
			err_flag = TRUE;
		else {
			if(!(get_entry("Port", str)))
				err_flag = TRUE;
			else
				prefs[SCport].value = (word)strtol(str, NULL, 16);
			if(!(get_entry("WavePort", str)))
				err_flag = TRUE;
			else
				prefs[SCWport].value = (word)strtol(str, NULL, 16);
			if(!(get_entry("IRQ", str)))
				err_flag = TRUE;
			else
				prefs[SCMirq].value = atoi(str);
			if(!(get_entry("SBIRQ", str)))
				err_flag = TRUE;
			else
				prefs[SCirq].value = atoi(str);
			if(!(get_entry("DMA", str)))
				err_flag = TRUE;
			else
				prefs[SCdma].value = atoi(str);
		}
	}
	if(stream)
		fclose(stream);

	if (err_flag) {
		cprintf("\r\nSoundscape not found.. make sure the SNDSCAPE environment variable is set!");
		getch();
		return (0);
	}
	else {
		prefs[SCport].status = YES;
		prefs[SCWport].status = YES;
		prefs[SCMirq].status = YES;
		prefs[SCirq].status = YES;
		prefs[SCdma].status = YES;
		prefs[DMAbuflen].status = YES;
		prefs[SCsrate].status = YES;
		prefs[SCstereo].status = YES;
		prefs[usesound].value = YES;
		prefs[usesound].status = YES;
		return (1);
	}
}

// _______________________________________________________________________

void get_scard(word *val)
{
	word t, n;

	cprintf("  0) None\r\n");
	cprintf("  1) SoundBlaster\r\n");
	cprintf("  2) Gravis Ultrasound\r\n");
	cprintf("  3) Ensoniq Soundscape\r\n");

	do {
		cprintf("\r\nPlease choose.. ");
		if (!input(str, 1, dec_nums))
			return;
	} while ((t = atoi(str)) > 3);

	for (n = 0; n < OPTIONS; n++)
	prefs[n].status = def_status[n];

	*val = 0;
	switch (t) {
		case 1: 	if (!check_SB())
						return;
					break;
		case 2:		if (!check_GUS())
						return;
					break;
		case 3:     if (!check_ESS())
						return;
					break;
	}
	*val = t;
}

// _______________________________________________________________________

void get_cpc(word *val)
{
	word t;

	cprintf("  1) 464\r\n");
	cprintf("  2) 664\r\n");
	cprintf("  3) 6128\r\n");

	do {
		cprintf("\r\nPlease choose.. ");
		if (!input(str, 1, dec_nums))
			return;
	} while (((t = atoi(str)) > 3) || (t < 1));
	*val = t;
}

// _______________________________________________________________________

void get_kbd(word *val)
{
	word t;

	cprintf("  0) English (UK)\r\n");
	cprintf("  1) French\r\n");
	cprintf("  2) German\r\n");

	do {
		cprintf("\r\nPlease choose.. ");
		if (!input(str, 1, dec_nums))
			return;
	} while ((t = atoi(str)) > 2);
	*val = t;
}

// _______________________________________________________________________

int parse_ctable(void)
{
	char *buffer, *buffer_pos, temp_string[80], *colour_ptr, err_flag;
	int done, cfg_len, n, offs;
	struct ffblk ffblk;

	done = findfirst(input_file, &ffblk, 0);
	if (done)
		return 0;
	cfg_len = (int)ffblk.ff_fsize;
	if (!(buffer = (char *)malloc(cfg_len)))
		return 0;
	if (!(stream = fopen(input_file, "rb")))
		return 0;
	fread(buffer, cfg_len, 1, stream);
	buffer[cfg_len] = 0;

	err_flag = FALSE;
	buffer_pos = search_command(buffer, "RGB_PAL_COLOUR");
	if (buffer_pos)	{
		buffer_pos = skip_string(buffer_pos);
		colour_ptr = (char *)&colour_table;
		for (n = 0, offs = 2; n < (32 * 3); n++) {
			buffer_pos = skip_spaces(buffer_pos);
			copy_argument(buffer_pos, temp_string, 0);
			buffer_pos = skip_string(buffer_pos);
			*(colour_ptr + offs) = (byte)strtol(temp_string, NULL, 16);
			if (!offs--) {
				colour_ptr += 4;
				offs = 2;
			}
		}
	}
	else
		err_flag = TRUE;

	fclose(stream);
	free(buffer);

	if(err_flag)
		return 0;
	else
		return 1;
}

// _______________________________________________________________________

void colour_menu(void)
{
	byte choice, n;

	for(;;) {
		clrscr();
		cprintf("CPE %s Setup Utility\r\n\r\n", VER_NUM);
		cprintf("  1) Import colours from CPCEMU style colour table\r\n");
		cprintf("  2) Original CPE colour table\r\n\r\n");
		cprintf("ESC) Return to main menu\r\n\r\n");

		if ((choice = getch()) == 27)
			return;
		if (choice >= 'a')
			choice -= ' ';

		switch (choice) {
			case '1':	cprintf("Enter filename (eg. colours.dat): ");
						gets(input_file);
						for (n = 0; n < 32; n++)
							colour_table[n] = def_ctable[n];
						if(!parse_ctable()) {
							cprintf("Error parsing file.. any key to continue.");
							getch();
						}
						else {
							cprintf("Colour table imported successfully.. any key to continue.");
							getch();
						}
						break;
			case '2':	for (n = 0; n < 32; n++)
							colour_table[n] = def_ctable[n];
						cprintf("Useing original CPE colour table.. any key to continue.");
						getch();
						break;
		}
	}
}

// _______________________________________________________________________

char *gcdir(char *path)
{
   strcpy(path, "X:\\");
   path[0] = 'A' + getdisk();
   getcurdir(0, path+3);
   return(path);
}

// _______________________________________________________________________

void filesys_menu(void)
{
	byte choice;
	char temp_str[MAXPATH];
	struct ffblk ffblk;

	gcdir(temp_str);
	for(;;) {
		clrscr();
		cprintf("CPE %s Setup Utility\r\n\r\n", VER_NUM);
		cprintf("  1) Set initial path for CPC drive A\r\n");
		cprintf("     %s\r\n", CPCa_path);
		cprintf("  2) Set initial path for CPC drive B\r\n");
		cprintf("     %s\r\n", CPCb_path);
		cprintf("  3) Set initial path for snapshots\r\n");
		cprintf("     %s\r\n", snappath);
		cprintf("  4) Set temporary archive extraction path\r\n");
		cprintf("     %s\r\n", temppath);
		cprintf("  5) Set archiver executable path\r\n");
		cprintf("     %s\r\n\r\n", archiver);
		cprintf("ESC) Return to main menu\r\n\r\n");

		if ((choice = getch()) == 27) {
			chdir(temp_str);
			return;
		}
		if (choice >= 'a')
			choice -= ' ';

		switch (choice) {
			case '1':	cprintf("Enter drive + path (eg. D:\\CPC\\DISK): ");
						gets(CPCa_path);
						strupr(CPCa_path);
						if (chdir(CPCa_path) == -1) {
							strcpy(CPCa_path, temp_str);
							cprintf("\r\nERROR: Invalid path specified..");
							getch();
						}
						break;
			case '2':	cprintf("Enter drive + path (eg. D:\\CPC\\DISK): ");
						gets(CPCb_path);
						strupr(CPCb_path);
						if (chdir(CPCb_path) == -1) {
							strcpy(CPCb_path, temp_str);
							cprintf("\r\nERROR: Invalid path specified..");
							getch();
						}
						break;
			case '3':	cprintf("Enter drive + path (eg. D:\\CPC\\SNAP): ");
						gets(snappath);
						strupr(snappath);
						if (chdir(snappath) == -1) {
							strcpy(snappath, temp_str);
							cprintf("\r\nERROR: Invalid path specified..");
							getch();
						}
						break;
			case '4':	cprintf("Enter drive + path (eg. D:\\CPC\\TEMP): ");
						gets(temppath);
						strupr(temppath);
						if (chdir(temppath) == -1) {
							temppath[0] = 0;
							cprintf("\r\nERROR: Invalid path specified..");
							getch();
						}
						break;
			case '5':	cprintf("\r\nEnter drive + path + filename of archiver (eg. C:\\UTILS\\PKUNZIP.EXE):\r\n");
						gets(archiver);
						strupr(archiver);
						if (findfirst(archiver, &ffblk, 0) == -1) {
							archiver[0] = 0;
							cprintf("\r\nERROR: File not found..");
							getch();
						}
						break;
		}
	}
}

// _______________________________________________________________________

void write_prefs(void)
{
	char err_flag, n;

	err_flag = FALSE;
	if ((stream = fopen("PREFS.CPE", "wb")) == NULL)
		err_flag = TRUE;
	else {
		for (n = 0; n < OPTIONS; n++)
			if (fwrite(&prefs[n].value, 2, 1, stream) != 1) {
				err_flag = TRUE;
				break;
			}
		for (n = 0; n < 32; n++)
			if (fwrite(&colour_table[n], 4, 1, stream) != 1) {
				err_flag = TRUE;
				break;
			}

		if (fwrite(&CPCa_path, 80, 1, stream) != 1)
			err_flag = TRUE;
		if (fwrite(&CPCb_path, 80, 1, stream) != 1)
			err_flag = TRUE;
		if (fwrite(&snappath, 80, 1, stream) != 1)
			err_flag = TRUE;
		if (fwrite(&temppath, 80, 1, stream) != 1)
			err_flag = TRUE;
		if (fwrite(&archiver, 80, 1, stream) != 1)
			err_flag = TRUE;

		for (n = 0; n < OPTIONS; n++)
			if (fwrite(&prefs[n].status, 1, 1, stream) != 1) {
				err_flag = TRUE;
				break;
			}
		fclose(stream);
	}
	if (err_flag) {
		cprintf("Error writing PREFS.CPE\r\n");
		exit(0);
	}
}

// _______________________________________________________________________

void main(void)
{
	char err_flag, m, n, choice;
	char curdir[MAXPATH], tdir[MAXPATH];
	char *tfile;
	enum pref_group	selection;

	err_flag = FALSE;
	if ((stream = fopen("PREFS.CPE", "rb")) == NULL)
		err_flag = TRUE;
	else {
		cprintf("Reading old setup..\r\n");
		for (n = 0; n < OPTIONS; n++)
			if (fread(&prefs[n].value, 2, 1, stream) != 1) {
				err_flag = TRUE;
				break;
			}
		for (n = 0; n < 32; n++)
			if (fread(&colour_table[n], 4, 1, stream) != 1) {
				err_flag = TRUE;
				break;
			}

		if (fread(&CPCa_path, 80, 1, stream) != 1)
			err_flag = TRUE;
		if (fread(&CPCb_path, 80, 1, stream) != 1)
			err_flag = TRUE;
		if (fread(&snappath, 80, 1, stream) != 1)
			err_flag = TRUE;
		if (fread(&temppath, 80, 1, stream) != 1)
			err_flag = TRUE;
		if (fread(&archiver, 80, 1, stream) != 1)
			err_flag = TRUE;

		for (n = 0; n < OPTIONS; n++)
			if (fread(&prefs[n].status, 1, 1, stream) != 1) {
				err_flag = TRUE;
				break;
			}
		fclose(stream);
	}
	if (err_flag) {
		cprintf("Error loading file.. creating new PREFS.CPE\r\n");
		for (n = 0; n < OPTIONS; n++) {
			prefs[n].value = prefs[n].def_value;
			prefs[n].status = def_status[n];
		}
//		for (n = 0; n < 32; n++)
//			colour_table[n] = def_ctable[n];
		gcdir(curdir);
		strcpy(tdir, curdir);
		strcat(tdir, "\\DISK");
		if (!chdir(tdir)) {
			strcpy(CPCa_path, tdir);
			strcpy(CPCb_path, tdir);
		}
		strcpy(tdir, curdir);
		strcat(tdir, "\\SNAP");
		if (!chdir(tdir))
			strcpy(snappath, tdir);
		tfile = getenv("TEMP");
		if (!chdir(tfile))
			strcpy(temppath, tfile);
		else {
			strcpy(tdir, curdir);
			strcat(tdir, "\\TEMP");
			if (!chdir(tdir))
				strcpy(temppath, tdir);
		}
		chdir(curdir);
		tfile = searchpath("PKUNZIP.EXE");
		if (tfile)
			strcpy(archiver, tfile);
	}

	for(;;) {
		clrscr();
		cprintf("CPE %s Setup Utility\r\n\r\n", VER_NUM);
		cprintf("  1) General settings\r\n");
		cprintf("  2) Video mode options\r\n");
		cprintf("  3) Change colour table\r\n");
		cprintf("  4) File system setup\r\n\r\n");
		cprintf("ESC) Save configuration and exit\r\n");

		if ((choice = getch()) == 27) {
			write_prefs();
			exit(1);
		}
		if (choice >= 'a')
			choice -= ' ';

		switch (choice) {
			case '1':	selection = general;
						break;
			case '2':	selection = cpe2;
						break;
			case '3':	colour_menu();
						choice = 0;
						break;
			case '4':	filesys_menu();
			default :	choice = 0;
		}

		if (choice) {
			for (;;) {
				clrscr();
				cprintf("CPE %s Setup Utility\r\n\r\n", VER_NUM);
				for (n = 0, m = 0; n < OPTIONS; n++) {
					if ((prefs[n].group == selection) && (prefs[n].status == YES)) {
						cprintf("  %c) %-32s  ", m + 'A', prefs[n].text);
						switch (prefs[n].type) {
							case dec_value:		cprintf("%d", prefs[n].value);
												break;
							case hex_value:		cprintf("%s", hex(prefs[n].value));
												break;
							case yes_no:		cprintf("%s", yesno(prefs[n].value));
												break;
							case sc_type:		cprintf("%s", scard(prefs[n].value));
												break;
							case printer_port:	cprintf("LPT%c", '0' + prefs[n].value);
												break;
							case cpc_type:		cprintf("%s", cpc(prefs[n].value));
												break;
							case kbd_type:		cprintf("%s", kbd(prefs[n].value));
												break;
							case sc_srate:		cprintf("%s", srate(prefs[n].value));
												break;
						}
						cprintf("\r\n");
						m++;
					}
				}
				cprintf("\r\nESC) Return to main menu\r\n\r\n");

				if ((choice = getch()) == 27)
					break;
				if (choice >= 'a')
					choice -= ' ';
				choice -= 'A';
				for (n = 0, m = 0; n < OPTIONS; n++) {
					if ((prefs[n].group == selection) && (prefs[n].status == YES)) {
						if (choice == m)
							switch (prefs[n].type) {
								case dec_value:
								case printer_port:	get_dec(&prefs[n].value);
													break;
								case hex_value:     get_hex(&prefs[n].value);
													break;
								case sc_srate:
								case yes_no:		get_yesno(&prefs[n].value);
													break;
								case sc_type:		get_scard(&prefs[n].value);
													break;
								case cpc_type:		get_cpc(&prefs[n].value);
													break;
								case kbd_type:		get_kbd(&prefs[n].value);
													break;
							}
						m++;
					}
				}
			}
		}
	}
}
