 ; routines for loading/saving tape/disk/snapshot files

	IDEAL
	INCLUDE "cpe2\macros.inc"

EXTRN simstack:WORD,simz80l:PROC,sz80performret:PROC,sz80performpushhl:PROC
EXTRN sz80wbhlAL:PROC,sz80InitPCSeg:PROC,sysstat:BYTE

EXTRN ClearKeymap:PROC
EXTRN LoadSnap:PROC,DiskChange:WORD
EXTRN KeyCode:BYTE
EXTRN RestoreScreen:PROC,PutChar:PROC,OpenTextScr:PROC
EXTRN SB_Pause:PROC,SB_continue:PROC

; *** Code from comp386.asm

EXTRN UnpackArea:PROC,PackArea:PROC

; *** exports

PUBLIC FILES_Init,GotoNormDir,GotoDiskDir
PUBLIC GetDirs,GetSnapDir,SelFile,SelSnap,GetSaveSnapName,InitTape,CloseTape
PUBLIC CASInOpen,CASRead,CASWrite,CASCheck,CAScont,CASInH
PUBLIC snapha,snapdir,snaname,dradir,draname,mvadir,mvaname

P386

GROUP   DGROUP _stack,_data

SEGMENT _text PAGE PUBLIC 'CODE'
ASSUME CS:_text
ASSUME DS:DGROUP

FILES_Init:
	MOV     AH,47h
	MOV     DL,0
	MOV     SI,OFFSET currdir+2
	INT     21h
	MOV     [currdir+1],'\'
	MOV     AH,47h
	MOV     DL,0
	MOV     SI,OFFSET diskdir+2
	INT     21h
	MOV     [diskdir+1],'\'
	CALL    GetDiskDirEnd
	MOV     DI,SI
	PUSH    ES
	PUSH    DS
	POP     ES
	MOV     SI,OFFSET diskinitdir
	MOV     AL,'\'
	STOSB
FILES_Loop:
	LODSB
	STOSB
	OR      AL,AL
	JNZ     FILES_Loop
	POP     ES
	RET

UpdateDiskDir:
	CALL    GotoDiskDir
	MOV     AH,47h          ; truncate '\CPE\..' to '\'
	MOV     DL,0
	MOV     SI,OFFSET diskdir+2
	INT     21h
	CALL    GetDir
	CALL    GotoNormDir
	RET

GetDiskDirEnd:
	MOV     SI,OFFSET diskdir+2
GDDE_Loop:
	LODSB
	OR      AL,AL
	JNZ     GDDE_Loop
	DEC     SI
	RET

GotoDiskDir:
	MOV     AH,3Bh
	MOV     DX,OFFSET diskdir+1
	INT     21h
	RET

GotoNormDir:
	MOV     AH,3Bh
	MOV     DX,OFFSET currdir+1
	INT     21h
	RET

GetDirs:
	CALL    FILES_Init
	MOV     AX,2f00h
	INT     21h
	MOV     [dtaoff],BX
	MOV     BX,ES
	MOV     [dtaseg],BX

	CALL    GetDir
	CALL    GetSnapDir
	CALL    GetTapeDir

	MOV     [lastsnap],0
	MOV     [lastfile],0

	RET

GetDir:
	PUSH    ES
	PUSHAD

	CALL    GotoDiskDir

	MOV     DX,SEG nametbl
	MOV     ES,DX
	XOR     DI,DI
	MOV     AX,[dtaseg]
	MOV     FS,AX

	MOV     DX,OFFSET fullcard
	MOV     AX,4E00h
	MOV     CX,10h
	INT     21h
	MOV     EBX,OFFSET nametbl
	JC      GD_NoDirs ; can't happen

	CALL    GD_DirLoop

GD_NoDirs:
	MOV     [dircnt],DI
	MOV     [filenametbl],BX
	PUSH    EBX
	MOV     DX,OFFSET wildcard
	MOV     AX,4E00h
	XOR     CX,CX
	INT     21h
	POP     EBX
	JC      GD_Whoops

	CALL    GD_Loop
GD_Whoops:
	PUSH    EBX
	MOV     DX,OFFSET wildcar2
	MOV     AX,4E00h
	XOR     CX,CX
	INT     21h
	POP     EBX
	JC      GD_Whoops2

	CALL    GD_Loop
GD_Whoops2:

	MOV     [filcnt],DI
	MOV     BX,[filenametbl]
	CALL    SortDir

	CALL    GotoNormDir
	POPAD
	POP     ES
	RET
GD_Loop:
	MOV     CX,[dtaoff]
	ADD     CX,1eh
	INC     DI
	XOR     ESI,ESI
GD_Copy:
	MOV     AL,[FS:ECX+ESI]
	OR      AL,AL
	JE      GD_Copied
	CMP     AL,'.'
	JE      GD_Copied
	MOV     [ES:BX+SI],AL
	INC     SI
	JMP     GD_Copy
GD_Copied:
	MOV     [BYTE PTR ES:BX+SI],0
	ADD     BX,8
        MOV     [DWORD PTR ES:BX],0
        MOV     [DWORD PTR ES:BX+4],0
	MOV     AX,4F00h
	INT     21h
	JC      GD_End
	JMP     GD_Loop
GD_End:
	RET

GD_DirLoop:
	MOV     CX,[dtaoff]
	ADD     CX,1eh
	INC     DI
	XOR     ESI,ESI
GDD_Copy:
	MOV     AL,[FS:ECX+ESI]
	OR      AL,AL
	JE      GDD_Copied
	MOV     [ES:BX+SI],AL
	INC     SI
	JMP     GDD_Copy
GDD_Copied:
	MOV     [BYTE PTR ES:BX+SI],0
	ADD     BX,8
GDD_GetNext:
	MOV     AX,4F00h
	INT     21h
	JC      GDD_End
	MOV     CX,[dtaoff]
	MOV     AL,[FS:ECX+015h]
	AND     AL,10h
	JZ      GDD_GetNext
	JMP     GD_DirLoop
GDD_End:
	RET

GetSnapDir:
	PUSHAD
	PUSH    DS
	PUSH    ES
	MOV     DX,SEG snaptbl
	MOV     ES,DX
	XOR     DI,DI
	MOV     AX,[dtaseg]
	MOV     FS,AX
	MOV     DX,OFFSET snapcard
	MOV     AX,4E00h
	XOR     CX,CX
	INT     21h
	JC      GSD_End
	MOV     EBX,OFFSET snaptbl
GSD_Loop:
	MOV     CX,[dtaoff]
	ADD     CX,1eh
	INC     DI
	XOR     ESI,ESI
GSD_Copy:
	MOV     AL,[FS:ECX+ESI]
	OR      AL,AL
	JE      GSD_Copied
	CMP     AL,46          ; Punkt
	JE      GSD_Copied
	MOV     [ES:BX+SI],AL
	INC     SI
	JMP     GSD_Copy
GSD_Copied:
	MOV     [BYTE PTR ES:BX+SI],0
	ADD     BX,8
	MOV     AX,4F00h
	INT     21h
	JC      GSD_End
	JMP     GSD_Loop
GSD_End:
	MOV     [snapcnt],DI
	MOV     BX,OFFSET snaptbl
	CALL    SortDir
	POP     ES
	POP     DS
	POPAD
	RET

SortDir:                        ; in: BX: name table
	CMP     [BYTE PTR ES:BX],0
	JE      SDIR_End
SDIR_Loop1:
	MOV     CX,BX
	MOV     DX,BX
	ADD     DX,8
	CMP     [BYTE PTR ES:EDX],0
	JE      SDIR_End
SDIR_Loop2:
	CMP     [BYTE PTR ES:EDX],0
	JE      SDIR_Loop2OK
	MOV     SI,CX
	MOV     DI,DX
SDIR_Loop3:
	MOV     AL,[ES:SI]
	MOV     AH,[ES:DI]
	INC     SI
	INC     DI
	CMP     AL,AH
	JE      SDIR_Loop3
	JC      SDIR_CXOK
	MOV     CX,DX
SDIR_CXOK:
	ADD     DX,8
	JMP     SDIR_Loop2
SDIR_Loop2OK:
	MOV     DX,CX
	MOV     CX,8
SDIR_Ex:
	MOV     AL,[ES:EBX]
	MOV     AH,[ES:EDX]
	MOV     [ES:EDX],AL
	MOV     [ES:EBX],AH
	INC     BX
	INC     DX
	LOOP    SDIR_Ex
	JMP     SDIR_Loop1
SDIR_End:
	RET

GetTapeDir:
	PUSHAD
	PUSH    ES
	MOV     DX,SEG tapetbl
	MOV     ES,DX

	XOR     DI,DI
	MOV     AX,[dtaseg]
	MOV     FS,AX
	MOV     DX,OFFSET tapecard
	MOV     AX,4E00h
	XOR     CX,CX
	INT     21h
	JC      GTD_End
	MOV     EBX,OFFSET tapetbl
GTD_Loop:
	MOV     CX,[dtaoff]
	ADD     CX,1eh
	INC     DI
	XOR     ESI,ESI
	MOV     [DWORD PTR ES:EBX],0
	MOV     [DWORD PTR ES:EBX+4],0
	MOV     [DWORD PTR ES:EBX+8],0
GTD_Copy:
	MOV     AL,[FS:ECX+ESI]
	OR      AL,AL
	JE      GTD_Copied
	MOV     [ES:BX+SI],AL
	INC     SI
	CMP     SI,12
	JE      GTD_Copied
	JMP     GTD_Copy
GTD_Copied:
	MOV     EAX,[FS:ECX-4]
	MOV     [ES:BX+12],EAX
	ADD     BX,16
	MOV     AX,4F00h
	INT     21h
	JC      GTD_End
	CMP     DI,1000
	JC      GTD_Loop
GTD_End:
	MOV     [tfilcnt],DI

	MOV     BX,OFFSET tapetbl
GTD_CheckArcs:
	MOV     EAX,[ES:BX]
	MOV     [DWORD PTR tapname],EAX
	MOV     EAX,[ES:BX+4]
	MOV     [DWORD PTR tapname+4],EAX
	MOV     EAX,[ES:BX+8]
	MOV     [DWORD PTR tapname+8],EAX

	PUSH    BX

	MOV     BX,OFFSET tapname
GTD_CheckTAR:
	CMP     [BYTE PTR BX],0
	JE      GTD_NoTAR
	INC     BX
	CMP     [DWORD PTR BX-1],'RAT.'
	JNE     GTD_CheckTAR

	MOV     DX,OFFSET tapedir
	MOV     AX,3d02h
	INT     21h
	JC      GTD_NoArc
	MOV     [tapeha],AX

	MOV     CX,8
	MOV     BX,[tapeha]
	MOV     DX,OFFSET tfilheader
	MOV     AX,3F00h
	INT     21h
	JC      GTD_NoArc
	CMP     [DWORD PTR tfilheader],'XURC'
	JNE     GTD_NoArc
	CMP     [DWORD PTR tfilheader+4],'CRAT'
	JNE     GTD_NoArc
	POP     BX
	MOV     [DWORD PTR ES:BX+12],0ffffffffh
	PUSH    BX
GTD_NoArc:
	MOV     BX,[tapeha]
	MOV     AX,3e00h
	INT     21h
GTD_NoTAR:
	POP     BX
	ADD     BX,16
	CMP     [DWORD PTR ES:BX],0
	JNE     GTD_CheckArcs

	POP     ES
	POPAD
	RET

InitTape:
	MOV     [tfilptr],0
	MOV     [tapeha],0ffffh
	CALL    GetTapeFile
	RET

GetTapeFile:
	CMP     [tfilcnt],0
	JE      GTFI_Ret
	PUSH    ES
	PUSHAD
	CALL    CloseTape
	MOV     DX,SEG tapetbl
	MOV     ES,DX
	MOV     [tfiloff],0
	MOV     AX,[tfilptr]
	CMP     AX,[tfilcnt]
	JC      GTFI_NumOk
	XOR     AX,AX
	MOV     [tfilptr],0
GTFI_NumOk:
	MOV     BX,AX
	SHL     BX,4
	ADD     BX,OFFSET tapetbl

	MOV     EAX,[ES:BX]
	MOV     [DWORD PTR tapname],EAX
	MOV     EAX,[DWORD PTR ES:BX+4]
	MOV     [DWORD PTR tapname+4],EAX
	MOV     EAX,[DWORD PTR ES:BX+8]
	MOV     [DWORD PTR tapname+8],EAX

	MOV     EAX,[DWORD PTR ES:BX+12]
	MOV     [tfillen],EAX
	XOR     EAX,EAX
	MOV     [tapeha],0ffffh

	MOV     DX,OFFSET tapedir
	MOV     AX,3d02h
	INT     21h
	JC      GTFI_End
	MOV     [tapeha],AX

	CMP     [tfillen],128
	JC      GTFI_NoHeader

	MOV     CX,128
	MOV     BX,[tapeha]
	MOV     DX,OFFSET tfilheader
	MOV     AX,3F00h
	INT     21h
	JC      GTFI_End
	CMP     [DWORD PTR tfilheader],'XURC'
	JNE     GTFI_NoArchive
	CMP     [DWORD PTR tfilheader+4],'CRAT'
	JNE     GTFI_NoArchive
	MOV     [tarcdiroffs],12
	MOV     [tarcfilenum],0
	MOV     [tfisarc],1
	CALL    GetTArchivedFile
	JMP     GTFI_End
GTFI_NoArchive:
	MOV     [tfisarc],0
	MOV     AX,0
	MOV     BX,OFFSET tfilheader
	XOR     CH,CH
GTFI_CalcChksum:
	MOV     CL,[BX]
	ADD     AX,CX
	INC     BX
	CMP     BX,OFFSET tfilheader+43h
	JNE     GTFI_CalcChksum
	CMP     AX,[BX]
	JNE     GTFI_NoHeader
	SUB     [tfillen],128
	JMP     GTFI_HeaderOK
GTFI_NoHeader:
	MOV     BX,[tapeha]
	XOR     CX,CX
	XOR     DX,DX
	MOV     AX,4200h
	INT     21h
	MOV     [BYTE PTR tfilheader+12h],16h
	MOV     AX,[WORD PTR tfillen]
	MOV     [WORD PTR tfilheader+18h],AX
GTFI_HeaderOK:
	MOV     AX,[WORD PTR tfilheader+18h]
	MOV     [WORD PTR tfillen],AX

	MOV     [lasthdread],0
	MOV     [WORD PTR tfilheader+13h],2048
	CMP     [tfillen],2048
	JNC     GTFI_BlockLenLess
	MOV     AX,[WORD PTR tfillen]
	MOV     [WORD PTR tfilheader+13h],AX
GTFI_BlockLenLess:
	MOV     [BYTE PTR tfilheader+17h],0ffh
	MOV     [BYTE PTR tfilheader+11h],0
	CMP     [tfillen],2049
	JNC     GTFI_NotLast
	MOV     [BYTE PTR tfilheader+11h],0ffh
GTFI_NotLast:
	MOV     [BYTE PTR tfilheader+10h],1
	MOV     EAX,[DWORD PTR tapname]
	MOV     [DWORD PTR tfilheader],EAX
	MOV     EAX,[DWORD PTR tapname+4]
	MOV     [DWORD PTR tfilheader+4],EAX
	MOV     EAX,[DWORD PTR tapname+8]
	MOV     [DWORD PTR tfilheader+8],EAX
	MOV     [DWORD PTR tfilheader+12],0
	XOR     EAX,EAX
	MOV     BX,OFFSET tfilheader+11
GTFI_KillSpaces:
	CMP     [BYTE PTR BX],32
	JNE     GTFI_SpacesKilled
	MOV     [BYTE PTR BX],0
	DEC     BX
	JNE     GTFI_KillSpaces
GTFI_SpacesKilled:
GTFI_End:
	POPAD
	POP     ES
GTFI_Ret:
	RET

GetNextTArcFile:
	PUSHAW
	INC     [tarcfilenum]
	CMP     [tarcfilenum],32
	JNE     TARC_FilNumOK
	MOV     BX,[tapeha]
	MOV     AX,4200h
	MOV     CX,[WORD PTR tarcdiroffs+2]
	MOV     DX,[WORD PTR tarcdiroffs]
	INT     21h
	MOV     AX,3f00h
	MOV     CX,4
	MOV     DX,OFFSET tarcdiroffs
	INT     21h
	CMP     [tarcdiroffs],0
	JE      TARC_ArchiveEnd
	MOV     [tarcfilenum],0
TARC_FilNumOK:
	CALL    GetTArchivedFile
	POPAW
	RET

GetTArchivedFile:
	MOV     BX,[tapeha]
	MOV     CX,[WORD PTR tarcdiroffs+2]
	MOV     DX,[WORD PTR tarcdiroffs]
	MOV     AL,[tarcfilenum]
	MOV     AH,24
	MUL     AH
	ADD     AX,4
	ADD     DX,AX
	ADC     CX,0
	MOV     AX,4200h
	INT     21h
	MOV     AX,3f00h
	MOV     CX,24
	MOV     DX,OFFSET TapeBuffer
	INT     21h
	CMP     [BYTE PTR TapeBuffer],0
	JE      TARC_ArchiveEnd
	MOV     SI,OFFSET TapeBuffer
	MOV     DI,OFFSET tfilheader
	MOV     CX,12
	PUSH    ES
	PUSH    DS
	POP     ES
	REP     MOVSB
	POP     ES
	MOV     [DWORD PTR DI],0
	MOV     AL,[SI]
	MOV     [BYTE PTR tfilheader+012h],AL
	MOV     EAX,[SI+1]
	AND     EAX,000ffffffh
	MOV     [DWORD PTR tfilheader+40h],EAX
	MOV     [WORD PTR tfilheader+18h],AX
	MOV     AX,[SI+4]
	MOV     [WORD PTR tfilheader+15h],AX
	MOV     AX,[SI+6]
	MOV     [WORD PTR tfilheader+1Ah],AX
	MOV     EAX,[SI+8]
	MOV     [tarcdataptr],EAX

	XOR     EAX,EAX
	MOV     AX,[WORD PTR tfilheader+18h]
	MOV     [tfillen],EAX

	MOV     [lasthdread],0
	MOV     [WORD PTR tfilheader+13h],2048
	CMP     [tfillen],2048
	JNC     TARC_BlockLenLess
	MOV     AX,[WORD PTR tfillen]
	MOV     [WORD PTR tfilheader+13h],AX
TARC_BlockLenLess:
	MOV     [BYTE PTR tfilheader+17h],0ffh
	MOV     [BYTE PTR tfilheader+11h],0
	CMP     [tfillen],2049
	JNC     TARC_NotLast
	MOV     [BYTE PTR tfilheader+11h],0ffh
TARC_NotLast:
	MOV     [BYTE PTR tfilheader+10h],1

	XOR     EAX,EAX
	MOV     BX,OFFSET tfilheader
	MOV     CX,42h
	XOR     DX,DX
TARC_BuildChk:
	LODSB
	ADD     DX,AX
	LOOP    TARC_BuildChk
	MOV     [WORD PTR tfilheader+43h],DX

	RET

TARC_ArchiveEnd:
	INC     [tfilptr]
	CALL    GetTapeFile
	RET

CloseTape:
	CMP     [tapeha],0ffffh
	JE      CLTA_End
	PUSHAD
	MOV     BX,[tapeha]
	MOV     AX,3e00h
	INT     21h
	POPAD
CLTA_End:
	RET

CASInOpen:
	MOV     sFree,[WORD PTR sysstat]
	AND     sFree,4
	JNZ     CASOops
	BT      AX,8
	JC      CAIO_COK
	CALL    sz80performret
	JMP     simz80l
CAIO_COK:
	CALL    sz80performpushhl

	PUSHAD
	MOV     BX,[CASInH]
	MOV     DX,0
CAIO_TestLess12:
	MOV     AL,[BYTE PTR ES:BX]
	CMP     AL,0
	JE      CAIO_Less12
	CMP     AL,32
	JNE     CAIO_TL12_NoSpace
	CMP     [BYTE PTR ES:BX+1],32 ; we can compact 2 spaces to one, since
	JE      CAIO_TL12_Space       ; neither combination is allowed in DOS
	CMP     [BYTE PTR ES:BX+1],'.'
	JE      CAIO_TL12_Space
	CMP     [BYTE PTR ES:BX+1],0
	JNE     CAIO_TL12_NoSpace
CAIO_TL12_Space:
	PUSH    BX
	MOV     DI,BX
	INC     BX
CAIO_TL12_SPCLoop:
	MOV     AL,[ES:BX]
	MOV     [ES:DI],AL
	INC     DI
	INC     BX
	CMP     AL,0
	JNE     CAIO_TL12_SPCLoop
	POP     BX
	DEC     BX
	DEC     DX
CAIO_TL12_NoSpace:
	INC     DX
	INC     BX
	CMP     DX,13
	JNE     CAIO_TestLess12
	JMP     CAIO_End
CAIO_Less12:
	MOV     [CASNameLen],DX

	MOV     DI,[CASInH]

	PUSH    DX
	CALL    CAIO_SearchName
	POP     DX
	CMP     BX,0ffffh
	JNE     CAIO_Found

	MOV     DX,[CASNameLen]
	CMP     DX,9
	JNC     CAIO_CheckArcs
	MOV     [DWORD PTR ES:EDI+EDX],'SAB.'
	PUSH    DX
	CALL    CAIO_SearchName
	POP     DX
	CMP     BX,0ffffh
	JNE     CAIO_Found

	MOV     DX,[CASNameLen]
	CMP     DX,9
	JNC     CAIO_End
	MOV     [DWORD PTR ES:EDI+EDX],'NIB.'

	PUSH    DX
	CALL    CAIO_SearchName
	POP     DX
	CMP     BX,0ffffh
	JNE     CAIO_Found
CAIO_CheckArcs:
	MOV     BX,[tfilptr]
	MOV     [oldtfilptr],BX
	MOV     DX,[CASNameLen]
	MOV     [DWORD PTR ES:EDI+EDX],0
	PUSH    DX
	CALL    CAIO_SearchInArcs
	POP     DX
	CMP     BX,0ffffh
	JNE     CAIO_End

	MOV     [DWORD PTR ES:EDI+EDX],'SAB.'
	PUSH    DX
	CALL    CAIO_SearchInArcs
	POP     DX
	CMP     BX,0ffffh
	JNE     CAIO_End

	MOV     [DWORD PTR ES:EDI+EDX],'NIB.'
	PUSH    DX
	CALL    CAIO_SearchInArcs
	POP     DX
	CMP     BX,0ffffh
	JNE     CAIO_End

	MOV     [DWORD PTR ES:EDI+EDX],0
	MOV     BX,[oldtfilptr]
	MOV     [tfilptr],BX
	CALL    GetTapeFile
	JMP     CAIO_End
CAIO_Found:
	MOV     [tfilptr],BX
	CALL    GetTapeFile
CAIO_End:
	POPAD
	JMP     simz80l

CAIO_SearchName:                        ; assumes ES: == rambase ???
	MOV     SI,OFFSET tapetbl
	MOV     CX,[tfilcnt]
	MOV     BX,0
CAIO_SN_Loop:
	PUSH    DS
	MOV     DX,SEG tapetbl
	MOV     DS,DX
	PUSH    SI
	PUSH    DI
	MOV     DX,0
	CMP     [DWORD PTR DS:SI+12],0ffffffffh    ; avoid tarcs
	JE      CAIO_SN_NotEqual
CAIO_SN_Cmp:
	CMP     DX,12
	JE      CAIO_SN_Found
	MOV     AL,[DS:SI]
	CMPSB
	JNE     CAIO_SN_NotEqual
	CMP     AL,0
	JE      CAIO_SN_Found
	INC     DX
	JMP     CAIO_SN_Cmp
CAIO_SN_NotEqual:
	POP     DI
	POP     SI
	POP     DS
	ADD     SI,16
	INC     BX
	LOOP    CAIO_SN_Loop
	MOV     BX,0ffffh
	RET
CAIO_SN_Found:
	POP     DI
	POP     SI
	POP     DS
	RET

CAIO_SearchInArcs:
	PUSH    FS
	MOV     SI,SEG tapetbl
	MOV     FS,SI

	MOV     SI,OFFSET tapetbl
	MOV     CX,[tfilcnt]
	MOV     BX,0
CAIO_SIA_Loop:
	CMP     [DWORD PTR FS:SI+12],0ffffffffh    ; only tarcs
	JNE     CAIO_SIA_NextFile
	MOV     [tfilptr],BX
	CALL    GetTapeFile
CAIO_SIA_CheckArc:
	CMP     [tfilptr],BX
	JNE     CAIO_SIA_NextFile
	MOV     DX,0
	PUSH    SI
	PUSH    DI
	MOV     SI,OFFSET tfilheader
CAIO_SIA_Cmp:
	CMP     DX,12
	JE      CAIO_SIA_Found
	MOV     AL,[SI]
	CMPSB
	JNE     CAIO_SIA_NotEqual
	CMP     AL,0
	JE      CAIO_SIA_Found
	INC     DX
	JMP     CAIO_SIA_Cmp
CAIO_SIA_NotEqual:
	POP     DI
	POP     SI
	CALL    GetNextTarcFile
	JMP     CAIO_SIA_CheckArc
CAIO_SIA_NextFile:
	ADD     SI,16
	INC     BX
	LOOP    CAIO_SIA_Loop
	MOV     BX,0ffffh
	POP     FS
	RET
CAIO_SIA_Found:
	POP     DI
	POP     SI
	POP     FS
	RET

CASRead:
	MOV     sFree,[WORD PTR sysstat]
	AND     sFree,4
	JNZ     CASOops
	CMP     [tapeha],0ffffh
	JE      CAS_Err
	CMP     AL,2ch
	JE      CASR_Header
	CMP     AL,16h
	JE      CASR_Block
CASR_Block:
	CMP     [tfisarc],0
	JE      CASR_Block_Norm
	PUSHAD
	MOV     CX,[WORD PTR tarcdataptr+2]
	MOV     DX,[WORD PTR tarcdataptr]
	MOV     BX,[tapeha]
	MOV     AX,4200h
	INT     21h
	MOV     CX,840h
	MOV     DX,OFFSET TapeLoadBuf+6
	MOV     BX,[tapeha]
	MOV     AX,3F00h
	INT     21h
	XOR     ECX,ECX
	MOV     CX,[WORD PTR TapeLoadBuf+6]
	ADD     [tarcdataptr],ECX
	CMP     CX,840h
	JNC     CASR_BlockRead
	MOV     [DWORD PTR TapeLoadBuf],'XURC'
	MOV     [DWORD PTR TapeLoadBuf+4],'KCAP'
	PUSH    ES
	PUSH    DS
	POP     ES
	MOV     SI,OFFSET TapeLoadBuf
	MOV     DI,OFFSET TapeBuffer
	MOV     CX,800h
	CALL    FAR UnpackArea
	POP     ES
	POPAD
	JMP     CASR_BlockRead
CASR_Block_Norm:
	PUSHAD
	MOV     CX,[WORD PTR tfilheader+13h]
	MOV     DX,OFFSET TapeBuffer
	MOV     BX,[tapeha]
	MOV     AX,3F00h
	INT     21h
	POPAD
CASR_BlockRead:
	PUSHAD
	MOV     SI,OFFSET TapeBuffer
	CMP     sDE,0
	JNE     CASR_CopyBlock
	MOV     sDE,[WORD PTR tfilheader+13h]
	JCXZ    CASR_BlockCopied
CASR_CopyBlock:
	MOV     AL,[SI]
	CALL    sz80wbhlAL
	INC     SI
	INC     nsHL
	DEC     sDE
	JNE     CASR_CopyBlock
CASR_BlockCopied:
	CALL    AdjustHeader
	POPAD
	JMP     CASR_End

CASR_Header:
	PUSHAD
	CMP     [lasthdread],0
	JE      CASR_FilePosOK
	CMP     [tfillen],2048
	JC      CASR_Adjust
	MOV     BX,[tapeha]
	MOV     AX,4201h
	XOR     CX,CX
	MOV     DX,2048
	INT     21h
	POPAD
	PUSHAD
CASR_Adjust:
	CALL    AdjustHeader
CASR_FilePosOK:
	MOV     [lasthdread],1
	MOV     SI,OFFSET tfilheader
CASR_CopyHeader:
	MOV     AL,[SI]
	CALL    sz80wbhlAL
	INC     SI
	INC     nsHL
	DEC     sDE
	JNE     CASR_CopyHeader
	POPAD
CASR_End:
	OR      AH,1
	MOV     sBC,1
	MOV     sPC,[CAScont]
	CALL    sz80InitPCSeg
	JMP     simz80l

AdjustHeader:
	PUSH    AX
	SUB     [tfillen],2048
	JZ      ADJH_NewFile
	JC      ADJH_NewFile
	MOV     AX,[WORD PTR tfilheader+13h]
	MOV     [BYTE PTR tfilheader+17h],0
	MOV     [BYTE PTR tfilheader+11h],0
	CMP     [tfillen],2049
	JNC     ADJH_NotLast
	MOV     [BYTE PTR tfilheader+11h],0ffh
ADJH_NotLast:
	MOV     AX,[WORD PTR tfillen]
	CMP     AX,2048
	JNC     ADJH_BlockLenLess
	MOV     [WORD PTR tfilheader+13h],AX
ADJH_BlockLenLess:
	INC     [BYTE PTR tfilheader+10h]
	JMP     ADJH_End
ADJH_NewFile:
	CMP     [tfisarc],0
	JE      ADJH_NormFile
	CALL    GetNextTarcFile
	JMP     ADJH_End
ADJH_NormFile:
	INC     [tfilptr]
	CALL    GetTapeFile
ADJH_End:
	POP     AX
	MOV     [lasthdread],0
	RET

CAS_Err:
	MOV     AX,100h
	CALL    sz80performret
	JMP     simz80l

CASWrite:
	MOV     sFree,[WORD PTR sysstat]
	AND     sFree,4
	JNZ     CASOops
	XOR     AL,AL
	AND     AH,0feh
	CALL    sz80performret
	JMP     simz80l

CASCheck:
	MOV     sFree,[WORD PTR sysstat]
	AND     sFree,4
	JNZ     CASOops
	XOR     AL,AL
	AND     AH,0feh
	CALL    sz80performret
	JMP     simz80l

CASOops:
	JMP     simz80l

SelectDisk:
	CALL    SelectSomething
	CMP     [selsucc],0
	JE      SELD_OK
	MOV     BP,[sellast]    ; now check whether it's a directory
	CMP     BP,[dircnt]
	JNC     SELD_OK

	PUSHAD
	PUSH    ES

	MOV     BX,BP
	SHL     BX,3
	ADD     BX,[seltabl]
	MOV     DX,SEG nametbl
	MOV     ES,DX
	CALL    GetDiskDirEnd
	MOV     AL,'\'
SELD_CopyLoop:
	MOV     [SI],AL
	INC     SI
	OR      AL,AL
	JZ      SELD_Copied
	MOV     AL,[ES:BX]
	INC     BX
	JMP     SELD_CopyLoop
SELD_Copied:
	POP     ES
	CALL    UpdateDiskDir
	POPAD

;	MOV     AX,[lastfile]
;	MOV     [sellast],AX
;	MOV     [lastfile],0
	MOV     [sellast],0
	MOV     AX,[filcnt]
	MOV     [selcnt],AX

	JMP     SelectDisk
SELD_OK:
	RET

SelectSomething:
	MOV     [selsucc],0
	CMP     [selcnt],0
	JE      SELC_Ret
	PUSH    ES
	PUSHAD
	MOV     DX,SEG nametbl
	MOV     ES,DX

	CALL    OpenTextScr

	MOV     BX,[selhead]
	XOR     DX,DX
	MOV     AH,15
SELC_Header:
	MOV     AL,[BX]
	OR      AL,AL
	JE      SELC_HeaderOK
	CALL    PutChar
	INC     BX
	INC     DX
	JMP     SELC_Header
SELC_HeaderOK:

	MOV     [keycode],0
	XOR     AX,AX
	MOV     EDX,162
	XOR     EBX,EBX
	MOV     BX,[seltabl]
SELC_Display:
	XOR     SI,SI
	MOV     EAX,[ES:EBX]
	OR      EAX,EAX
	JE      SELC_Displayed
	XOR     EAX,EAX
	MOV     AH,15
	PUSH    DX
SELC_NameLoop:
	MOV     AL,[ES:EBX+ESI]
	OR      AL,AL
	JE      SELC_NameOK
	CALL    PutChar
	INC     DX
	INC     SI
	CMP     SI,8
	JNE     SELC_NameLoop
SELC_NameOK:
	POP     DX
	ADD     DX,10
	ADD     BX,8
	JMP     SELC_Display
SELC_Displayed:
	MOV     BX,[sellast]
SELC_Loop:
	MOV     AX,BX
	SHR     AX,3
	MOV     CX,80
	MUL     CX
	MOV     CX,BX
	AND     CX,7
	ADD     CX,CX
	MOV     DX,CX
	ADD     DX,DX
	ADD     DX,DX
	ADD     CX,DX
	ADD     AX,CX
	ADD     AX,161
	MOV     DX,AX
	MOV     AX,0F10h
	CALL    PutChar
	CMP     [keycode],0
	JE      SELC_Loop
	CMP     [keycode],28
	JE      SELC_Affirmative
	CMP     [keycode],1
	JE      SELC_End
	MOV     AX,020h
	CALL    PutChar
	CMP     [keycode],4bh
	JNE     SELC_nlf
	CMP     BX,0
	JE      SELC_LoopEnd
	DEC     BX
	JMP     SELC_LoopEnd
SELC_nlf:
	CMP     [keycode],4dh
	JNE     SELC_nrt
	INC     BX
	CMP     BX,[selcnt]
	JC      SELC_LoopEnd
	DEC     BX
	JMP     SELC_LoopEnd
SELC_nrt:
	CMP     [keycode],48h
	JNE     SELC_nup
	SUB     BX,8
	JNC     SELC_LoopEnd
	XOR     BX,BX
	JMP     SELC_LoopEnd
SELC_nup:
	CMP     [keycode],50h
	JNE     SELC_ndn
	ADD     BX,8
	CMP     BX,[selcnt]
	JC      SELC_LoopEnd
	MOV     BX,[selcnt]
	SUB     BX,1
	JMP     SELC_LoopEnd
SELC_ndn:
	MOVZX   BP,[keycode]
	ADD     BP,OFFSET typekeytab
	MOV     AL,[BP]
	OR      AL,AL
	JE      SELC_LoopEnd
	MOV     CX,BX
	XOR     EBX,EBX
	XOR     EBP,EBP
SELC_FindPressedChar:
	MOV     BP,[seltabl]
	LEA     EBP,[EBX*8+EBP]
	CMP     [ES:BP],AL
	JE      SELC_LoopEnd
	INC     BX
	CMP     BX,[selcnt]
	JC      SELC_FindPressedChar
	MOV     BX,CX
SELC_LoopEnd:
	MOV     [keycode],0
	JMP     SELC_Loop
SELC_Affirmative:
	MOV     [sellast],BX
	MOV     DX,[selnapt]
	SHL     BX,3
	ADD     BX,[seltabl]
	XOR     SI,SI
SELC_GenName:
	MOV     AL,[ES:EBX]
	OR      AL,AL
	JE      SELC_GenExt
	MOV     [EDX],AL
	INC     BX
	INC     DX
	INC     SI
	CMP     SI,8
	JNE     SELC_GenName
SELC_GenExt:
	MOV     EAX,[selext]
	MOV     [DWORD PTR EDX],EAX
	XOR     EAX,EAX
	ADD     DX,4
	MOV     [BYTE PTR EDX],0
	MOV     [selsucc],1
SELC_End:

	POPAD
	POP     ES
	CALL    RestoreScreen
	CALL    ClearKeyMap
	MOV     [keycode],0
SELC_Ret:
	RET

GetSaveSnapName:
	PUSH    ES
	PUSHAD
	CALL    OpenTextScr

	MOV     DX,SEG nametbl
	MOV     ES,DX

	MOV     BX,OFFSET SnLsTitle
	XOR     DX,DX
	MOV     AH,15
GSSN_Header:
	MOV     AL,[BX]
	OR      AL,AL
	JE      GSSN_HeaderOK
	CALL    PutChar
	INC     BX
	INC     DX
	JMP     GSSN_Header
GSSN_HeaderOK:

	MOV     BX,OFFSET SSnaTitle
	MOV     DX,80*23
	MOV     AH,15
GSSN_Prompt:
	MOV     AL,[BX]
	OR      AL,AL
	JE      GSSN_PromptOK
	CALL    PutChar
	INC     BX
	INC     DX
	JMP     GSSN_Prompt
GSSN_PromptOK:

	XOR     AX,AX
	MOV     EDX,162
	XOR     EBX,EBX
	MOV     BX,OFFSET SnapTbl
GSSN_ShowFiles:
	XOR     SI,SI
	MOV     EAX,[ES:BX]
	OR      EAX,EAX
	JE      GSSN_FilesShown
	XOR     EAX,EAX
	MOV     AH,15
	PUSH    DX
GSSN_NameLoop:
	MOV     AL,[ES:EBX+ESI]
	OR      AL,AL
	JE      GSSN_NameOK
	CALL    PutChar
	INC     DX
	INC     SI
	CMP     SI,8
	JNE     GSSN_NameLoop
GSSN_NameOK:
	POP     DX
	ADD     DX,10
	ADD     BX,8
	JMP     GSSN_ShowFiles
GSSN_FilesShown:

	MOV     [keycode],0
	XOR     AX,AX
	MOV     BX,AX
	MOV     AH,0Fh
	MOV     [snaname],0
GSSN_Loop:
	MOV     EDX,24*80
	XOR     ECX,ECX
GSSN_Display:
	MOV     AL,[snaname+ECX]
	OR      AL,AL
	JZ      GSSN_DisplayOK
	CALL    PutChar
	INC     CX
	INC     DX
	JMP     GSSN_Display
GSSN_DisplayOK:
	MOV     AL,'_'
	CALL    PutChar
	INC     DX
	MOV     AL,' '
	CALL    PutChar

GSSN_WaitKey:
	CMP     [keycode],0
	JE      GSSN_WaitKey

	CMP     [keycode],1
	JE      GSSN_Break
	CMP     [keycode],28
	JE      GSSN_GotAName
	OR      BX,BX
	JZ      GSSN_NoDel
	CMP     [keycode],14
	JNE     GSSN_NoDel
	DEC     BX
	MOV     [BX+snaname],0
GSSN_NoDel:
	CMP     BX,8
	JE      GSSN_LoopEnd

	MOVZX   BP,[keycode]
	ADD     BP,OFFSET typekeytab
	MOV     AL,[BP]
	OR      AL,AL
	JE      GSSN_LoopEnd
	MOV     [BX+snaname],AL
	MOV     AH,0fh
	LEA     EDX,[EBX+24*80]
	CALL    PutChar
	INC     BX
	MOV     [BX+snaname],0
GSSN_LoopEnd:
	MOV     [keycode],0
	JMP     GSSN_Loop

GSSN_Break:
	MOV     [snaname],0
	JMP     GSSN_End
GSSN_GotAName:
	MOV     [DWORD BX+snaname],'ANS.'
	MOV     [BX+snaname+4],0
GSSN_End:
	POPAD
	POP     ES
	CALL    RestoreScreen
	CALL    ClearKeyMap
	RET

SelFile:
	PUSHAD
        CALL    SB_Pause
	MOV     AX,[filcnt]
	MOV     [selcnt],AX
	MOV     AX,[lastfile]
	MOV     [sellast],AX
	MOV     [selnapt],OFFSET draname
	MOV     [seltabl],OFFSET nametbl
	MOV     [selhead],OFFSET DiskTitle
	MOV     [selext],'DPC.'
	CALL    SelectDisk
	MOV     AX,[sellast]
	MOV     [lastfile],AX
	CMP     [selsucc],0
	JE      SFIL_End
	MOV     [diskchange],1
SFIL_End:
        CALL    SB_continue
	POPAD
	RET

SelSnap:
	PUSHAD
        CALL    SB_Pause
	MOV     AX,[snapcnt]
	MOV     [selcnt],AX
	MOV     AX,[lastsnap]
	MOV     [sellast],AX
	MOV     [selnapt],OFFSET snaname
	MOV     [seltabl],OFFSET snaptbl
	MOV     [selhead],OFFSET SnapTitle
	MOV     [selext],'ANS.'
	CALL    SelectSomething
	MOV     AX,[sellast]
	MOV     [lastsnap],AX
	CMP     [selsucc],0
	JE      SSNA_End
	CALL    LoadSnap
SSNA_End:
        CALL    SB_continue
	POPAD
	RET

ENDS

SEGMENT _data PAGE PUBLIC 'DATA'

snapdir db 'snap\'
snaname db 'snapshot.sna',0,0

LABEL dradir BYTE ;db 'disks\'
draname db 'drivea  .cpd',0,0
	dd 0

LABEL mvadir BYTE ; db 'disc\'
mvaname db 'drivea  .dsk',0,0
	dd 0

currdir db 256 DUP (0)
diskdir db 256 DUP (0)

diskinitdir db 'disks',0

tapedir db 'tape\'
tapname db 16 DUP (0)

wildcard db '*.cpd',0
fullcard db '*.*',0
wildcar2 db '*.dsk',0
tapecard db 'tape\*.*',0
snapcard db 'snap\*.*',0

DiskTitle db '     Select the diskfile you want to insert into drive A:',0
SnapTitle db '     Select a snapshot to load:',0
SnLsTitle db '     List of snapshot files:',0
SsnaTitle db '     Type a name for the snapshot file:',0

	EVEN
tapeha  dw 0
snapha  dw 0

dtaoff  dw 0
dtaseg  dw 0

filenametbl dw 0
dircnt  dw 0
filcnt  dw 0
tfilcnt dw 0
snapcnt dw 0

selcnt  dw 0
selext  dd 0
selnapt dw 0
seltabl dw 0
selsucc dw 0
selhead dw 0

sellast dw 0

LABEL TypeKeyTab BYTE
 ;                ESC  1   2   3   4   5   6   7   8   9   0        DEL TAB
	db    00h,00h,'1','2','3','4','5','6','7','8','9','0',000,000,000,000
 ;             Q   W   E   R   T   Z   U   I   O   P      +   CR CTL  A   S
	db    'Q','W','E','R','T','Y','U','I','O','P',000,000,013,000,'A','S'
 ;             D   F   G   H   J   K   L           LSH  #'  Y   X   C   V
	db    'D','F','G','H','J','K','L',000,000,000,000,000,'Z','X','C','V'
 ;             B    N    M
	db    'B','N','M',0,12 DUP (0)
	db    4*16 DUP (0)

 ; ************************************************ Tape
	    EVEN
CAScont     dw    2a72h
CASInH      dw    0b807h
CASNameLen  dw    0

tfilptr     dw    0
tfiloff     dw    0
tfilheader  db    128 DUP (1)
tfillen     dd    0
lasthdread  dw    0

tfisarc     db    0
tarcfilenum db    0
tarcdiroffs dd    0
tarcdataptr dd    0
oldtfilptr  dw    0

lastsnap    dw    0
lastfile    dw    0

ENDS

SEGMENT _stack PARA STACK 'STACK'

TapeBuffer  dw    800h DUP (?)
TapeLoadBuf dw    800h DUP (?)

ENDS

SEGMENT tables PRIVATE PARA

nametbl dd 1000 DUP (?)
tapetbl dd 4000 DUP (?)
snaptbl dd 1000 DUP (?)

ENDS

END
