;*************************************************************************
;*                                                                       *
;*       Z-80 emulation routines                                         *
;*                                                                       *
;*************************************************************************

IDEAL

P386

PUBLIC simz80,simz80l,sz80_instend,interrupt,sz80gb,intflag,count52
PUBLIC sRF,simstack,sAFx,sBCx,sDEx,sHLx,srI,sRFhi,imode,sIFF1,sIFF2,ix,iy
PUBLIC ClearInterruptCounter

PUBLIC sz80performret,sz80performpushhl,sz80wbhlAL,sz80InitPCSeg,inpiob

EXTRN scrbankpt:DWORD,normramseg:WORD,DoJoystick:PROC
EXTRN scradd:DWORD,ScrAdConv:WORD,outp:PROC,inp:PROC,memmap:WORD
EXTRN intreq:WORD,dowait:WORD,intcount:WORD
EXTRN keycode:BYTE,refreshrate:WORD,usevesa:WORD,smallvesa:WORD,borders:WORD
EXTRN RethinkCRTC:PROC
EXTRN cleanup:PROC,colmode:BYTE,SetColors:PROC
EXTRN reset:PROC
EXTRN SelFile:PROC
EXTRN Menu:PROC
EXTRN CASInOpen:PROC,CASRead:PROC,CASWrite:PROC,CASCheck:PROC
EXTRN RethinkPSG:PROC,PSGcount:WORD
EXTRN SelSnap:PROC,SaveSnap:PROC
EXTRN crtcscrwidth:BYTE
EXTRN scrbase:WORD,scroff:WORD,CRTCregs:BYTE,ffly:WORD
EXTRN crtchsync:WORD,crtc32state:WORD
EXTRN modetab:DWORD,GenModeTab:PROC,needmodetab:WORD
EXTRN pcrtcscrwidth:BYTE,doublelinmode:WORD
EXTRN ResetVesaPage:PROC,IncVesaPage:PROC

GROUP   DGROUP _stack,_data

      INCLUDE "macros.inc"

SEGMENT _text PAGE PUBLIC 'CODE'
ASSUME CS:_text
ASSUME DS:DGROUP

instalign       EQU 1

MACRO   instheader iname,radd
ALIGN   instalign
r_&iname:
IFIDN   <radd>,<2>
	INC     [sRF]
ELSE
	ADD     [sRF],radd/2
ENDIF
iname:
ENDM

sz80InitPCSeg:
        InitPCSeg
        RET
sz80wbhlAL:
        wbhl    AL
        RET
sz80performret:
	MOV     BP,[simstack]
	gwordBP sPC
	ADD     BP,2
	MOV     [simstack],BP
        InitPCSeg
        RET
sz80performpushhl:
	MOV     BP,[simstack]           ;E5 PUSH HL
	SUB     BP,2
	MOV     [simstack],BP
	wword   nSHL
        RET

ClearInterruptCounter:           ; pure guesswork
        MOV     [intreq],0
        AND     [intflag],9fffh
        AND     [count52],1fh
;        MOV    [intadj],0
        RET

inpioB: MOV     AL,01Eh     ; Firmenname: AMSTRAD, Freq: 50HZ
        MOV     BP,[ffly]
        OR      BP,BP
        JZ      inpioB_OK
        DEC     BP
        JNZ     inpioB_ffly
        CMP     [clocks],10     ; Voyage 93 needs something special here
        JL      inpioB_OK
inpioB_ffly:
	OR      AL,1
inpioB_OK:
	RET

SpecialOccasion:
	MOV     sFree,[intflag]   ; * intflag : 4000 int,
	TEST    sFree,100h        ; * 0002: EI
	JZ      SPOC_nokeyreq     ; * 0004: RethinkPSG
	CALL    keys
	AND     [intflag],0feffh
SPOC_nokeyreq:
	TEST    sFree,2000h
	JZ      SPOC_norealint
	AND     [intflag],0dfffh
	CMP     [haltactive],0
	JE      SPOC_NoHalt
	INC     sPC
	MOV     [haltactive],0
SPOC_NoHalt:
	CMP     [sIFF1],0
	JE      SHORT SPOC_intdisable
	PUSH    sFree
	CALL    interrupt
	POP     sFree
	MOV     [intreq],0
	JMP     SPOC_noint
SPOC_intdisable:
	MOV     [intreq],1
	JMP     SPOC_noint
SPOC_norealint:
	TEST    sFree,4000h
	JZ      SPOC_noint
	AND     [intflag],09fffh
	OR      [intflag],02000h
SPOC_noint:
	BT      sFree,1
	JNC     SHORT SPOC_noEI
	MOV     [sIFF1],1
	MOV     [sIFF2],1
	AND     [intflag],0FFFDh
	CMP     [intreq],0
	JE      SHORT SPOC_noEI
	OR      [intflag],2000h
SPOC_noEI:
	BT      sFree,2
	JNC     SHORT SPOC_noPSG
        MOV     BP,[PSGcount]
        OR      BP,BP
        JZ      SPOC_PSG
        DEC     BP
        MOV     [PSGcount],BP
        JMP     SPOC_noPSG
SPOC_PSG:
	CALL    RethinkPSG
	AND     [intflag],0FFFBh
SPOC_noPSG:
	JMP     sz80gb

 ; ************************************************** Z80 entry

Z80_reset:
        MOV     DX,[normramseg]
	MOV     ES,DX
	MOV     [intflag],0
	MOV     [clocks],64
        MOV     [ffly],0
	MOV     [count52],0
;        MOV     [intadj],0
	InitPCSeg

	MOV     BP,[refreshrate]
	MOV     [drawing],BP

        MOV     [hscroll],0
        MOV     [vscroll],0

        MOV     [intcount],0

        CALL    StartNewCPCFrame

        MOV     [scrline],0
	MOV     [scrptr],0

        MOV     [synccount],0

        CMP     [usevesa],0
        JE      reset_end
        CALL    ResetVesaPage
reset_end:
        RET

RethinkDrawing:
        CALL    DoJoystick

	MOV     BP,[refreshrate]
        OR      BP,BP
        JNE     RTDR_normal
        MOV     [drawing],0

        PUSH    AX
        PUSH    DX
        MOV     AX,[synccount]
        AND     AX,0fffh      ; prevent nasty overflows
        MOV     DX,52
        DIV     DL
        MOVZX   BP,AH
        MOV     [synccount],BP
        XOR     AH,AH
        CLI
        SUB     [intcount],AX
        JS      RTDR_needtowait
        MOV     [drawing],1     ; if we took longer, we omit the next frame.
;        MOV     [synccount],0
        STI
        JMP     RTDR_synced

RTDR_normal:
	DEC     [drawing]
	JNS     RTDR_end

	ADD     [drawing],BP

        PUSH    AX
        PUSH    DX
        MOV     AX,[synccount]
        AND     AX,0fffh      ; prevent nasty overflows
        MOV     DX,52
        DIV     DL
        MOVZX   BP,AH
        MOV     [synccount],BP
        XOR     AH,AH
        CLI
        SUB     [intcount],AX
        JS      RTDR_needtowait
        MOV     [synccount],0
        MOV     [intcount],-1   ; wait at least one int
RTDR_needtowait:
        STI
RTDR_wait:
        MOV     BP,[intcount]
        OR      BP,BP
        JNZ     RTDR_wait
RTDR_synced:
        POP     DX
        POP     AX
RTDR_end:
        RET

StartNewCPCFrame:
	CALL    RethinkCRTC

	MOV     BP,[scrbase]
	ADD     BP,[scroff]
	MOV     [cpclinbase],0
	MOV     [cpcptr],BP
	MOV     [rasterline],0

        MOV     [linescount],0ffffh
        MOV     [hadffly],0
        MOV     [charline],0
        MOV     [inborder],0

        CALL    StartNewCPCLine
        RET

StartNewCPCLine:
        PUSH    AX
        MOVZX   BP,[CRTCregs+9]
        MOV     [crtcmaxslin],BP

        MOVZX   AX,[CRTCregs+1]
        CMP     [pcrtcscrwidth],AL
        JNC     SNCL_WidthCalculated
        MOVZX   AX,[pcrtcscrwidth]
SNCL_WidthCalculated:
        MOV     [drawwidth],AX

        MOV     AL,[BYTE PTR CRTCregs+1] ; calculate the left border width
        CMP     [crtcscrwidth],AL
        JE      SNCL_hsyncvalid

        MOV     [crtcscrwidth],AL
        AND     AX,63
        NEG     AX
        ADD     AX,51
        ADD     AX,AX
        ADD     AX,AX
        MOV     BP,[drawwidth]
        ADD     BP,BP
        ADD     BP,BP
        SUB     BP,200
        NEG     BP
        SHR     BP,1
        CMP     AX,BP
        JC      SNCL_hsyncok
        MOV     AX,BP
SNCL_hsyncok:
        MOV     [crtchsync],AX
SNCL_hsyncvalid:

        MOVZX   BP,[BYTE PTR CRTCregs+7]
        MOV     [crtcvsync],BP
        POP     AX
        RET

simz80:
        CALL    Z80_reset
sz80_instend:
simz80l:
	TEST    [intflag],0ffffh
	JNZ     SpecialOccasion
sz80gb:
IF     DEBUG EQ 1
        CMP     sPC,0100h
        JE      break80
ENDIF
sz80l_gbytepc:
	gbpc
	MOV     BP,[EsFree*2+opclogs]
	SUB     [clocks],BP
	JS      sz80_underflow
sz80_jump:
	JMP     [EsFree*2+opcodes]

sz80_underflow:
	PUSH    sFree
	ADD     [clocks],64     ; we don't support variable line lengths,
                                ; since they blow up the CPC monitor anyway
        CMP     [intreq],0
        JE      sz80_nointreq
        INC     [count52]
        CMP     [count52],52
        JC      sz80clocksok
        MOV     [count52],0

        JMP     sz80clocksok

sz80_nointreq:
	INC     [count52]
        CMP     [count52],52
	JC      sz80clocksok

	MOV     [count52],0
	OR      [intflag],4000h

sz80clocksok:
        CMP     [ffly],0
        JE      sz80_fflyok
        INC     [ffly]

        CMP     [ffly],4
        JNE     sz80_fflyok
        MOV     BP,[count52]
 	MOV     [count52],0
;       MOV     [intadj],0
        CMP     BP,20h
        JC      sz80_fflyok
        OR      [intflag],4000h
sz80_fflyok:

        MOVZX   BP,[CRTCregs+9]
        CMP     [rasterline],BP
        JC      sz80_nonewcharline

        INC     [charline]
        MOV     [rasterline],-1
        CALL    StartNewCPCLine

sz80_nonewcharline:
        INC     [rasterline]

        INC     [synccount]

        CMP     [drawing],0
        JNE     sz80_instend_omitline

        CMP     [smallvesa],0
        JNE     sz80_smallscreen

 ; if we get here, we have a full screen VESA mode. We forget about
 ; some of the things calculated for the other modes.

        INC     [scrline]

        CMP     [inborder],0
        JNE     sz80_800x600_inborder
        CMP     [ffly],0
        JNE     sz80_800x600_inborder

	PUSHAW
	PUSH    ES
	CMP     [needmodetab],0
	JE      sz80_800x600_DontNeedMT
	CALL    GenModeTab
sz80_800x600_DontNeedMT:
	MOV     DI,[scrptr]
	PUSH    0a000h
	POP     ES

        CMP     [crtc32state],0C00h
        JNE     sz80_thankgod_no32k

 ; Bletch. We have a 32K screen. We do only the slow update.

 ; take care of the left border if necessary

        CMP     [borders],0
        JE      sz80_32k_mainpic
        MOV     DX,[crtchsync]

        OR      DX,DX
        JZ      sz80_32k_mainpic

        MOV     EAX,[modetab+2048]
sz80_32k_leftbor:
        STOSD
        OR      DI,DI
        JNE     sz80_32k_leftbor_ok
        CALL    IncVesaPage
sz80_32k_leftbor_ok:
        DEC     DX
        JNE     sz80_32k_leftbor

 ; draw the main picture

sz80_32k_mainpic:
	MOV     CX,[drawwidth]
	ADD     CX,CX

	LFS     BX,[scrbankpt]
	MOV     AX,[cpclinbase]
	AND     AX,3800h
	ADD     BX,AX
	MOV     BP,[cpcptr]
        MOV     [pageinc],0
        OR      CX,CX
        JZ      sz80_32k_mainpic_done

sz80_32k_drawloop:
        MOV     DX,BP
        MOV     SI,BP
        INC     BP
        AND     SI,07FFh
        AND     DX,0800h
        JNZ     sz80_32k_draw_2ndbank
	MOV     DL,[FS:EBX+ESI]
        JMP     sz80_32k_draw_gotbyte
sz80_32k_draw_2ndbank:
	MOVZX   DX,[FS:EBX+ESI+04000h]
sz80_32k_draw_gotbyte:
	MOV     EAX,[EDX*8+modetab]
	STOSD
	MOV     EAX,[EDX*8+modetab+4]
	STOSD
        OR      DI,DI
        JNE     sz80_32k_contdraw
        CALL    IncVesaPage
        MOV     [pageinc],1
sz80_32k_contdraw:
	LOOP    sz80_32k_drawloop
sz80_32k_mainpic_done:

 ; take care of the right border if necessary

        CMP     [borders],0
        JE      sz80_32k_finished
        MOV     CX,[drawwidth]
        ADD     CX,CX
        ADD     CX,CX
        ADD     CX,[crtchsync]
        NEG     CX
        ADD     CX,200
        JZ      sz80_32k_rightbor_done
        MOV     EAX,[modetab+2048]
sz80_32k_rightbor:
        STOSD
        OR      DI,DI
        JNE     sz80_32k_rightbor_ok
        CALL    IncVesaPage
sz80_32k_rightbor_ok:
        LOOP    sz80_32k_rightbor
sz80_32k_rightbor_done:
        MOV     [scrptr],DI
        XOR     EAX,EAX
        JMP     sz80_drawn

sz80_32k_finished:
	XOR     EAX,EAX

	MOVZX   DI,[pcrtcscrwidth]
	SHL     DI,4
	ADD     [scrptr],DI
        JNC     sz80_drawn
        CMP     [pageinc],0
        JNE     sz80_drawn
        CALL    IncVesaPage
        JMP     sz80_drawn

 ; Phew. Just a nice, normal 16K screen.

sz80_thankgod_no32k:
        CMP     DI,0F800h   ; @@@ with safety padding
        JC      sz80_800x600_safe

 ; First, the unsafe versions: An overflow may occur

 ; take care of the left border if necessary

        CMP     [borders],0
        JE      sz80_800x600_mainpic
        MOV     DX,[crtchsync]

        OR      DX,DX
        JZ      sz80_800x600_mainpic

        MOV     EAX,[modetab+2048]
sz80_800x600_leftbor:
        STOSD
        OR      DI,DI
        JNE     sz80_800x600_leftbor_ok
        CALL    IncVesaPage
sz80_800x600_leftbor_ok:
        DEC     DX
        JNE     sz80_800x600_leftbor

 ; draw the main picture

sz80_800x600_mainpic:
	MOV     CX,[drawwidth]
	ADD     CX,CX

	LFS     BX,[scrbankpt]
	MOV     AX,[cpclinbase]
	AND     AX,3800h
	ADD     BX,AX
	MOV     BP,[cpcptr]
	MOV     SI,7ffh
	XOR     DX,DX
        MOV     [pageinc],0
        OR      CX,CX
        JZ      sz80_800x600_mainpic_done

sz80_800x600_drawloop:
	AND     BP,SI
	MOV     DL,[FS:EBX+EBP]
	INC     BP
	MOV     EAX,[EDX*8+modetab]
	STOSD
	MOV     EAX,[EDX*8+modetab+4]
	STOSD
        OR      DI,DI
        JNE     sz80_800x600_contdraw
        CALL    IncVesaPage
        MOV     [pageinc],1
sz80_800x600_contdraw:
	LOOP    sz80_800x600_drawloop
sz80_800x600_mainpic_done:

 ; take care of the right border if necessary

        CMP     [borders],0
        JE      sz80_800x600_finished
        MOV     CX,[drawwidth]
        ADD     CX,CX
        ADD     CX,CX
        ADD     CX,[crtchsync]
        NEG     CX
        ADD     CX,200
        JZ      sz80_800x600_rightbor_done
        MOV     EAX,[modetab+2048]
sz80_800x600_rightbor:
        STOSD
        OR      DI,DI
        JNE     sz80_800x600_rightbor_ok
        CALL    IncVesaPage
sz80_800x600_rightbor_ok:
        LOOP    sz80_800x600_rightbor
sz80_800x600_rightbor_done:
        MOV     [scrptr],DI
        XOR     EAX,EAX
        JMP     sz80_drawn

sz80_800x600_finished:
	XOR     EAX,EAX

	MOVZX   DI,[pcrtcscrwidth]
	SHL     DI,4
	ADD     [scrptr],DI
        JNC     sz80_drawn
        CMP     [pageinc],0
        JNE     sz80_drawn
        CALL    IncVesaPage
        JMP     sz80_drawn

 ; Now, the same thing again, this time if there's no danger of overflow

sz80_800x600_safe:
 ; take care of the left border if necessary

        CMP     [borders],0
        JE      sz80_800x600_safe_mainpic
        MOV     CX,[crtchsync]
        OR      CX,CX
        JZ      sz80_800x600_safe_mainpic

        MOV     EAX,[modetab+2048]
        REP     STOSD

 ; draw the main picture

sz80_800x600_safe_mainpic:
	MOV     CX,[drawwidth]
        ADD     CX,CX

	LFS     BX,[scrbankpt]
	MOV     AX,[cpclinbase]
	AND     AX,3800h
	ADD     BX,AX
	MOV     BP,[cpcptr]
	MOV     SI,7ffh
	XOR     DX,DX
        OR      CX,CX
        JZ      sz80_800x600_safe_mainpicdone

sz80_800x600_safe_drawloop:
	AND     BP,SI
	MOV     DL,[FS:EBX+EBP]
	INC     BP
	MOV     EAX,[EDX*8+modetab]
	STOSD
	MOV     EAX,[EDX*8+modetab+4]
	STOSD
	LOOP    sz80_800x600_safe_drawloop
sz80_800x600_safe_mainpicdone:
 ; take care of the right border if necessary

        CMP     [borders],0
        JE      sz80_800x600_safe_finished
        MOV     CX,[drawwidth]
        ADD     CX,CX
        ADD     CX,CX
        ADD     CX,[crtchsync]
        NEG     CX
        ADD     CX,200
        JZ      sz80_800x600_safe_rightbor_done
        MOV     EAX,[modetab+2048]
        REP     STOSD
sz80_800x600_safe_rightbor_done:
        MOV     [scrptr],DI
        XOR     EAX,EAX
        JMP     sz80_drawn

sz80_800x600_safe_finished:
	XOR     EAX,EAX

	MOVZX   DI,[pcrtcscrwidth]
	SHL     DI,4
	ADD     [scrptr],DI
        JMP     sz80_drawn

 ; Now, the border-filling stuff, also in two versions

sz80_800x600_inborder:
        CMP     [borders],0
        JE      sz80_instend_omitline

        PUSH    EAX
        PUSH    ECX
        PUSH    EDI
        PUSH    ES

        MOVZX   CX,[pcrtcscrwidth]
        ADD     CX,CX
        ADD     CX,CX
        MOV     EAX,[modetab+2048]
        PUSH    0A000h
        POP     ES

        MOV     DI,[scrptr]
        CMP     DI,0F800h  ; @@@
        JC      sz80_800x600_safe_borderloop
sz80_800x600_borderloop:
        STOSD
        OR      DI,DI
        JNE     sz80_800x600_borderloop_ok
        CALL    IncVesaPage
sz80_800x600_borderloop_ok:
        LOOP    sz80_800x600_borderloop
        MOV     [scrptr],DI

        POP     ES
        POP     EDI
        POP     ECX
        POP     EAX
        JMP     sz80_instend_omitline

sz80_800x600_safe_borderloop:
        REP     STOSD
        XOR     EAX,EAX
        MOV     [scrptr],DI

        POP     ES
        POP     EDI
        POP     ECX
        POP     EAX
        JMP     sz80_instend_omitline

sz80_smallscreen:
        CMP     [inborder],0
        JNE     sz80_instend_omitline
        INC     [scrline]
        CMP     [usevesa],0
        JNE     sz80_dontstopafter200
        CMP     [doublelinmode],0
        JE      sz80_dontstopafter200
        CMP     [scrline],201
        JNC     sz80_instend_omitline
sz80_dontstopafter200:

	PUSHAW
	PUSH    ES
	CMP     [needmodetab],0
	JE      sz80_DontNeedMT
	CALL    GenModeTab
sz80_DontNeedMT:
	MOV     DI,[scrptr]
	PUSH    0a000h
	POP     ES
	MOV     CX,[drawwidth]
        ADD     CX,CX
	JZ      sz80_drawn

	LFS     BX,[scrbankpt]
	MOV     AX,[cpclinbase]
	AND     AX,3800h
	ADD     BX,AX
	MOV     BP,[cpcptr]
	MOV     SI,7ffh
	XOR     DX,DX

        CMP     [usevesa],0
        JE      sz80_draw_320x200

        MOV     [pageinc],0

        CMP     [crtc32state],0C00h
        JNE     sz80_vesa_normal

 ; arrghh. 32K screen.

sz80_small32k_drawloop:
        MOV     DX,BP
        MOV     SI,BP
        INC     BP
        AND     SI,07FFh
        AND     DX,0800h
        JNZ     sz80_small32k_draw_2ndbank
	MOV     DL,[FS:EBX+ESI]
        JMP     sz80_small32k_draw_gotbyte
sz80_small32k_draw_2ndbank:
	MOVZX   DX,[FS:EBX+ESI+04000h]
sz80_small32k_draw_gotbyte:
	MOV     EAX,[EDX*4+modetab]
	STOSD
        OR      DI,DI
        JNE     sz80_small32k_contdraw
        CALL    IncVesaPage
        MOV     [pageinc],1
sz80_small32k_contdraw:
	LOOP    sz80_small32k_drawloop
        JMP     sz80_vesa_fixscrptr

sz80_vesa_normal:
sz80_vesa_drawloop:
	AND     BP,SI
	MOV     DL,[FS:EBX+EBP]
	INC     BP
	MOV     EAX,[EDX*4+modetab]
	STOSD
        OR      DI,DI
        JNE     sz80_vesa_contdraw
        CALL    IncVesaPage
        MOV     [pageinc],1
sz80_vesa_contdraw:
	LOOP    sz80_vesa_drawloop
	XOR     EAX,EAX

sz80_vesa_fixscrptr:
	MOVZX   DI,[pcrtcscrwidth]
	SHL     DI,4
	ADD     [scrptr],DI
        JNC     sz80_drawn
        CMP     [pageinc],0
        JNE     sz80_drawn
        CALL    IncVesaPage
        JMP     sz80_drawn

sz80_draw_320x200:
        ADD     BP,[hscroll]
sz80_drawloop:
	AND     BP,SI
	MOV     DL,[FS:EBX+EBP]
	INC     BP
	MOV     EAX,[EDX*4+modetab]
	STOSD
sz80_contdraw:
	LOOP    sz80_drawloop

	XOR     EAX,EAX
        MOV     AX,[skiplines]
        OR      AX,AX
        JE      sz80_noskiplines
        DEC     AX
        MOV     [skiplines],AX
        DEC     [scrline]               ; to prevent the drawing from stopping
        JMP     sz80_skipline
sz80_noskiplines:
	MOVZX   DI,[pcrtcscrwidth]
	SHL     DI,3
	ADD     [scrptr],DI
sz80_skipline:

sz80_drawn:
	POP     ES
	POPAW

sz80_instend_omitline:
        CMP     [inborder],0
        JNE     sz80_rlinok
	ADD     [cpclinbase],800h
        CMP     [rasterline],0
	JNE     sz80_rlinok
        AND     [cpclinbase],07ffh
	MOV     BP,[cpcptr]
        PUSH    AX
	MOVZX   AX,[crtcscrwidth]
	ADD     BP,AX
	ADD     BP,AX
        POP     AX
	AND     BP,0fffh
	MOV     [cpcptr],BP

sz80_rlinok:
        MOV     BP,[linescount]         ; check whether the frame is finished
        OR      BP,BP
        JNS     sz80_neartheend

; This is apparently wrong (Voyage 93)
;        CMP     [rasterline],0          ; only check all the stuff at the top
;        JNE     sz80_instend_end        ; of a character

        MOVZX   BP,[CRTCregs+4]
        AND     BP,7fh
        INC     BP
        CMP     [charline],BP
        JC      sz80_nowhereneartheend
        MOV     [linescount],0
        MOVZX   BP,[BYTE PTR CRTCregs+5]
        MOV     [crtcvtadj],BP
sz80_neartheend:
        MOV     BP,[crtcvtadj]
        AND     BP,1fh
        CMP     [linescount],BP
        JC      sz80_notyetendofframe

        CALL    StartNewCPCFrame
        JMP     sz80_nowhereneartheend

sz80_notyetendofframe:
        INC     [linescount]

sz80_nowhereneartheend:
        MOVZX   BP,[CRTCregs+6]         ; check whether Vertical Displayed
        AND     BP,7fh                  ; is used up
        CMP     [charline],BP
        JC      sz80_notinborder
        MOV     [inborder],1

sz80_notinborder:                       ; check whether Vertical Sync Pos
        CMP     [hadffly],0        ; is used up
        JNE     sz80_instend_end

        CMP     [ffly],0
        JE      sz80_fflyunset

        CMP     [ffly],9                ; my real CRTC 2 generates these
        JC      sz80_instend_end        ; independent of reg 9
        MOV     [ffly],0
        MOV     [hadffly],1

        CALL    RethinkDrawing

        MOV     [scrline],0            ; at this point, we restart to draw
        MOV     [scrptr],0             ; the VGA frame

        MOV     BP,[vscroll]
        MOV     [skiplines],BP

        CALL    ResetVesaPage
        JMP     sz80_instend_end

sz80_fflyunset:
        MOV     BP,[crtcvsync]
        AND     BP,7fh
        CMP     [charline],BP
        JNE     sz80_instend_end

        MOV     [ffly],1
;        MOV     BP,[count52]
;        CMP     BP,1dh
;        JC      sz80_instend_end
;        MOV     [count52],49

sz80_instend_end:
	POP     sFree
	JMP     sz80_jump

break80:
        INT     3
	JMP     sz80l_gbytepc

interrupt:
        MOV     BP,[count52]
        SUB     BP,32
        JC      int_c52ok
        MOV     [count52],BP
int_c52ok:
;        AND     [count52],01Fh ;*
	SUB     [clocks],5
	INC     [sRF]
	MOV     [sIFF1],0
	MOV     [sIFF2],0
	CMP     [imode],2
	JE      int_mode2
	MOV     BP,[simstack]
	SUB     BP,2
	MOV     [simstack],BP
	wword   sPC
	MOV     sPC,38h
	InitPCSeg
	RET
int_mode2:
	MOV     BP,[simstack]
	SUB     BP,2
	MOV     [simstack],BP
	wword   sPC
	PUSH    nsHL
	PUSH    AX
	MOV     sH,[BYTE PTR srI]
	MOV     sL,0ffh
	gbhl    AL
	INC     nsHL
	gbhl    AH
	MOV     sPC,AX
	POP     AX
	POP     nsHL
	InitPCSeg
	RET

keys:
	CMP     [keycode],0
	JE      keys_ret

	CMP     [keycode],68            ; F10: bye bye
	JE      cleanup
	CMP     [keycode],63            ; F5: hard reset CPC
	JNE     SHORT keys_noreset
        MOV     [hscroll],0
        MOV     [vscroll],0
	CALL    reset
        CALL    Z80_reset
	XOR     sFree,sFree
keys_noreset:
	CMP     [keycode],64            ; F6: select diskfile
	JNE     SHORT keys_noselfile
	CALL    SelFile
keys_noselfile:                         ; F7: menu
	CMP     [keycode],65
	JNE     SHORT keys_nomenu
	CALL    Menu
keys_nomenu:
	CMP     [keycode],59            ; F1: Load snapshot
	JNE     SHORT keys_nosnap
        CALL    Z80_reset
	CALL    SelSnap
keys_nosnap:
	CMP     [keycode],61            ; F3: Save snapshot
	JNE     SHORT keys_nosavesnap
	CALL    SaveSnap
keys_nosavesnap:
	CMP     [keycode],87            ; F11: hscroll
	JNE     SHORT keys_nof11
        DEC     [hscroll]
        JNS     keys_nof11
        MOV     [hscroll],0
keys_nof11:
	CMP     [keycode],88            ; F12: hscroll
	JNE     SHORT keys_nof12
        INC     [hscroll]
keys_nof12:
	CMP     [keycode],66            ; F8: vscroll
	JNE     SHORT keys_nof8
        INC     [vscroll]
keys_nof8:
	CMP     [keycode],67            ; F9: vscroll
	JNE     SHORT keys_nof9
        DEC     [vscroll]
        JNS     keys_nof9
        MOV     [vscroll],0
keys_nof9:
 ; F2 doesn't do anything here - 50Hz mode seems to be impossible in 256
 ; color mode.
	CMP     [keycode],62
	JNE     keys_nobreak
	NOP
IF DEBUG EQ 1
        INT     3
ENDIF
keys_nobreak:
	MOV     [keycode],0
keys_ret:
	RET

;*************************************************************************
;*                                                                       *
;*       Opcode simulation routines                                      *
;*                                                                       *
;*************************************************************************

ALIGN   2
instheader nop00,2
	instend                         ;00 NOP

instheader lxib,2
	gwpc    sBC                     ;01 LD BC,nnnn
	instend

instheader staxb,2
	wbytead EsBC,AL                 ;02 LD (BC),A
	instend

instheader inxb,2
	INC     sBC                     ;03 INC BC
	instend

instheader inrb,2
	z80inc  sB                      ;04 INC B

instheader dcrb,2
	z80dec  sB                      ;05 DEC B

instheader mvib,2
	gbytePC sB                      ;06 LD B,nn
	instend

instheader rlc,2
	ROL     AL,1                    ;07 RLCA
	docyf

instheader exaf,2
	XCHG    AX,[sAFx]               ;08 EX AF,AF'
	instend

instheader dadb,2
	ADD     nSHL,sBC                ;09 ADD HL,BC
	docyf

instheader ldaxb,2
	gbytead EsBC,AL                 ;0A LD A,(BC)
	instend

instheader dcxb,2
	DEC     sBC                     ;0B DEC BC
	instend

instheader inrc,2
	z80inc  sC                      ;0C INC C

instheader dcrc,2
	z80dec  sC                      ;0D DEC C

instheader mvic,2
	gbytePC sC                      ;0E LD C,nn
	instend

instheader rrc,2
	ROR     AL,1                    ;0F RRCA
	docyf

instheader djnz,2
	gsbpc                           ;10 DJNZ dd
	DEC     sB
	JZ      sz80_instend
	jrd0

instheader lxid,2
	gwpc    sDE                     ;11 LD DE,nnnn
	instend

instheader staxd,2
	wbytead EsDE,AL                 ;12 LD (DE),A
	instend

instheader inxd,2
	INC     sDE                     ;13 INC DE
	instend

instheader inrd,2
	z80inc  sD                      ;14 INC D

instheader dcrd,2
	z80dec  sD                      ;15 DEC D

instheader mvid,2
	gbytePC sD                      ;16 LD D,nn
	instend

instheader ral,2
	SAHF                            ;17 RLA *flags* (ok)
	RCL     AL,1
	docyf

instheader jr,2
	gsbpc                           ;18 JR dd
	jrd0

instheader dadd,2
	ADD     nSHL,sDE                ;19 ADD HL,DE
	docyf

instheader ldaxd,2
	gbytead EsDE,AL                 ;1A LD A,(DE)
	instend

instheader dcxd,2
	DEC     sDE                     ;1B DEC DE
	instend

instheader inre,2
	z80inc  sE                      ;1C INC E

instheader dcre,2
	z80dec  sE                      ;1D DEC E

instheader mvie,2
	gbytePC sE                      ;1E LD E,nn
	instend

instheader rar,2
	SAHF                            ;1F RRA
	RCR     AL,1
	docyf

instheader jrnz,2
	gsbpc                           ;20 JR NZ,dd
	BT      AX,14
	JC      sz80_instend
	jrd0

instheader lxih,2
	gwpc    nSHL                    ;21 LD HL,nnnn
	instend

instheader shldz,2
	gwpc    BP                      ;22 LD (nnnn),HL
	wword   nSHL
	instend

instheader inxh,2
	INC     nSHL                    ;23 INC HL
	instend

instheader inrh,2
	z80inc  sH                      ;24 INC H

instheader dcrh,2
	z80dec  sH                      ;25 DEC H

instheader mvih,2
	gbytePC sH                      ;26 LD H,nn
	instend

instheader daaz,2
	BT      AX,9                    ;27 DAA
	JC      SHORT daa_sub
	SAHF
	DAA
	MOV     BP,AX
	LAHF
	AND     BP,200h
	AND     AH,0fdh
	OR      AX,BP
	instend
daa_sub:
	SAHF
	DAS
	MOV     BP,AX
	LAHF
	AND     BP,200h
	AND     AH,0fdh
	OR      AX,BP
	instend

instheader jrz,2
	gsbpc                           ;28 JR Z,dd
	BT      AX,14
	JNC     sz80_instend
	jrd0

instheader dadh,2
	ADD     nSHL,nSHL               ;29 ADD HL,HL
	docyf

instheader lhld,2
	gwpc    BP                      ;2A LD HL,(nnnn)
	gwordBP nSHL
	instend

instheader dcxh,2
	DEC     nSHL                    ;2B DEC HL
	instend

instheader inrl,2
	z80inc  sL                      ;2C INC L

instheader dcrl,2
	z80dec  sL                      ;2D DEC L

instheader mvil,2
	gbytePC sL                      ;2E LD L,nn
	instend

instheader cma,2
	NOT     AL                      ;2F CPL
	instend

instheader jrnc,2
	gsbpc                           ;30 JR NC,dd
	BT      AX,8
	JC      sz80_instend
	jrd0

instheader lxis,2
	gwpc    BP                      ;31 LD SP,nnnn
	MOV     [simstack],BP
	instend

instheader sta,2
	gwpc    BP                      ;32 LD (nnnn),A
	wbyte   AL
	instend

instheader inxs,2
	INC     [simstack]              ;33 INC SP
	instend

instheader inrm,2
	PUSH    sBC                     ;34 INC (HL)
	gbhl    sC
	z80inco sC
	wbhl    sC
	POP     sBC
	instend

instheader dcrm,2
	PUSH    sBC                     ;35 DEC (HL)
	gbhl    sC
	z80deco sC
	wbhl    sC
	POP     sBC
	instend

instheader mvim,2
	PUSH    sBC                     ;36 LD (HL),nn
	gbytePC sC
	wbhl    sC
	POP     sBC
	instend

instheader stcz,2
	OR      AH,1                    ;37 SCF
	AND     AH,0EDh
	instend

instheader jrc,2
	gsbpc                           ;38 JR C,dd
	BT      AX,8
	JNC     sz80_instend
	jrd0

instheader dads,2
	ADD     nSHL,[simstack]         ;39 ADD HL,SP
	docyf

instheader lda,2
	gwpc    BP                      ;3A LD A,(nnnn)
	gbyteBP AL
	instend

instheader dcxs,2
	DEC     [simstack]              ;3B DEC SP
	instend

instheader inra,2
	z80inc  AL                      ;3C INC A

instheader dcra,2
	z80dec  AL                      ;3D DEC A

instheader mvia,2
	gbytePC AL                      ;3E LD A,nn
	instend

instheader cmcz,2
	AND     AH,0FDh                 ;3F CCF
	XOR     AH,11h
	instend

instheader movebb,2
	instend                         ;40 LD B,B

instheader movebc,2
	MOV     sB,sC                   ;41 LD B,C
	instend

instheader movebd,2
	MOV     sB,sD                   ;42 LD B,D
	instend

instheader movebe,2
	MOV     sB,sE                   ;43 LD B,E
	instend

instheader movebh,2
	MOV     sB,sH                   ;44 LD B,H
	instend

instheader movebl,2
	MOV     sB,sL                   ;45 LD B,L
	instend

instheader movebm,2
	gbhl    sB                      ;46 LD B,(HL)
	instend

instheader moveba,2
	MOV     sB,AL                   ;47 LD B,A
	instend

instheader movecb,2
	MOV     sC,sB                   ;48 LD C,B
	instend

instheader movecc,2
	instend                         ;49 LD C,C

instheader movecd,2
	MOV     sC,sD                   ;4A LD C,D
	instend

instheader movece,2
	MOV     sC,sE                   ;4B LD C,E
	instend

instheader movech,2
	MOV     sC,sH                   ;4C LD C,H
	instend

instheader movecl,2
	MOV     sC,sL                   ;4D LD C,L
	instend

instheader movecm,2
	gbhl    sC                      ;4E LD C,(HL)
	instend

instheader moveca,2
	MOV     sC,AL                   ;4F LD C,A
	instend

instheader movedb,2
	MOV     sD,sB                   ;50 LD D,B
	instend

instheader movedc,2
	MOV     sD,sC                   ;51 LD D,C
	instend

instheader movedd,2
	instend                         ;52 LD D,D

instheader movede,2
	MOV     sD,sE                   ;53 LD D,E
	instend

instheader movedh,2
	MOV     sD,sH                   ;54 LD D,H
	instend

instheader movedl,2
	MOV     sD,sL                   ;55 LD D,L
	instend

instheader movedm,2
	gbhl    sD                      ;56 LD D,(HL)
	instend

instheader moveda,2
	MOV     sD,AL                   ;57 LD D,A
	instend

instheader moveeb,2
	MOV     sE,sB                   ;58 LD E,B
	instend

instheader moveec,2
	MOV     sE,sC                   ;59 LD E,C
	instend

instheader moveed,2
	MOV     sE,sD                   ;5A LD E,D
	instend

instheader moveee,2
	instend                         ;5B LD E,E

instheader moveeh,2
	MOV     sE,sH                   ;5C LD E,H
	instend

instheader moveel,2
	MOV     sE,sL                   ;5D LD E,L
	instend

instheader moveem,2
	gbhl    sE                      ;5E LD E,(HL)
	instend

instheader moveea,2
	MOV     sE,AL                   ;5F LD E,A
	instend

instheader movehb,2
	MOV     sH,sB                   ;60 LD H,B
	instend

instheader movehc,2
	MOV     sH,sC                   ;61 LD H,C
	instend

instheader movehd,2
	MOV     sH,sD                   ;62 LD H,D
	instend

instheader movehe,2
	MOV     sH,sE                   ;63 LD H,E
	instend

instheader movehh,2
	instend                         ;64 LD H,H

instheader movehl,2
	MOV     sH,sL                   ;65 LD H,L
	instend

instheader movehm,2
	gbhl    sH                      ;66 LD H,(HL)
	instend

instheader moveha,2
	MOV     sH,AL                   ;67 LD H,A
	instend

instheader movelb,2
	MOV     sL,sB                   ;68 LD L,B
	instend

instheader movelc,2
	MOV     sL,sC                   ;69 LD L,C
	instend

instheader moveld,2
	MOV     sL,sD                   ;6A LD L,D
	instend

instheader movele,2
	MOV     sL,sE                   ;6B LD L,E
	instend

instheader movelh,2
	MOV     sL,sH                   ;6C LD L,H
	instend

instheader movell,2
	instend                         ;6D LD L,L

instheader movelm,2
	gbhl    sL                      ;6E LD L,(HL)
	instend

instheader movela,2
	MOV     sL,AL                   ;6F LD L,A
	instend

instheader movemb,2
	wbhl    sB                      ;70 LD (HL),B
	instend

instheader movemc,2
	wbhl    sC                      ;71 LD (HL),C
	instend

instheader movemd,2
	wbhl    sD                      ;72 LD (HL),D
	instend

instheader moveme,2
	wbhl    sE                      ;73 LD (HL),E
	instend

instheader movemh,2
	wbhl    sH                      ;74 LD (HL),H
	instend

instheader moveml,2
	wbhl    sL                      ;75 LD (HL),L
	instend

instheader halt,2
	CMP     [sIFF1],1
	JE      haltnorm
	NOP
haltnorm:
	MOV     [haltactive],1          ;76 HALT
	DEC     sPC
	instend

instheader movema,2
	wbhl    AL                      ;77 LD (HL),A
	instend

instheader moveab,2
	MOV     AL,sB                   ;78 LD A,B
	instend

instheader moveac,2
	MOV     AL,sC                   ;79 LD A,C
	instend

instheader movead,2
	MOV     AL,sD                   ;7A LD A,D
	instend

instheader moveae,2
	MOV     AL,sE                   ;7B LD A,E
	instend

instheader moveah,2
	MOV     AL,sH                   ;7C LD A,H
	instend

instheader moveal,2
	MOV     AL,sL                   ;7D LD A,L
	instend

instheader moveam,2
	gbhl    AL                      ;7E LD A,(HL)
	instend

instheader moveaa,2
	instend                         ;7F LD A,A

instheader addb,2
	ADD     AL,sB                   ;80 ADD A,B
	flagsetN0

instheader addc,2
	ADD     AL,sC                   ;81 ADD A,C
	flagsetN0

instheader addd,2
	ADD     AL,sD                   ;82 ADD A,D
	flagsetN0

instheader adde,2
	ADD     AL,sE                   ;83 ADD A,E
	flagsetN0

instheader addh,2
	ADD     AL,sH                   ;84 ADD A,H
	flagsetN0

instheader addl,2
	ADD     AL,sL                   ;85 ADD A,L
	flagsetN0

instheader addm,2
	gbhl    AH                      ;86 ADD A,(HL)
	ADD     AL,AH                   ; don't push AH, gets killed anyway
	flagsetN0                       ; in macro

instheader adda,2
	ADD     AL,AL                   ;87 ADD A,A
	flagsetN0

instheader adcb,2
	SAHF                            ;88 ADC A,B
	ADC     AL,sB
	flagsetN0

instheader adcc,2
	SAHF                            ;89 ADC A,C
	ADC     AL,sC
	flagsetN0

instheader adcd,2
	SAHF                            ;8A ADC A,D
	ADC     AL,sD
	flagsetN0

instheader adce,2
	SAHF                            ;8B ADC A,E
	ADC     AL,sE
	flagsetN0

instheader adch,2
	SAHF                            ;8C ADC A,H
	ADC     AL,sH
	flagsetN0

instheader adcl,2
	SAHF                            ;8D ADC A,L
	ADC     AL,sL
	flagsetN0

instheader adcm,2
	PUSH    sBC                     ;8E ADC A,(HL)
	gbhl    sB
	SAHF
	ADC     AL,sB
	POP     sBC
	flagsetN0

instheader adca,2
	SAHF                            ;8F ADC A,A
	ADC     AL,AL
	flagsetN0

instheader subb,2
	SUB     AL,sB                   ;90 SUB A,B
	flagsetN1

instheader subc,2
	SUB     AL,sC                   ;91 SUB A,C
	flagsetN1

instheader subd,2
	SUB     AL,sD                   ;92 SUB A,D
	flagsetN1

instheader sube,2
	SUB     AL,sE                   ;93 SUB A,E
	flagsetN1

instheader subh,2
	SUB     AL,sH                   ;94 SUB A,H
	flagsetN1

instheader subl,2
	SUB     AL,sL                   ;95 SUB A,L
	flagsetN1

instheader subm,2
	gbhl    AH                      ;96 SUB A,(HL)
	SUB     AL,AH
	flagsetN1

instheader suba,2
	SUB     AL,AL                   ;97 SUB A,A
	flagsetN1

instheader sbbb,2
	SAHF                            ;98 SBC A,B
	SBB     AL,sB
	flagsetN1

instheader sbbc,2
	SAHF                            ;99 SBC A,C
	SBB     AL,sC
	flagsetN1

instheader sbbd,2
	SAHF                            ;9A SBC A,D
	SBB     AL,sD
	flagsetN1

instheader sbbe,2
	SAHF                            ;9B SBC A,E
	SBB     AL,sE
	flagsetN1

instheader sbbh,2
	SAHF                            ;9C SBC A,H
	SBB     AL,sH
	flagsetN1

instheader sbbl,2
	SAHF                            ;9D SBC A,L
	SBB     AL,sL
	flagsetN1

instheader sbbm,2
	PUSH    sBC                     ;9E SBC A,(HL)
	gbhl    sB
	SAHF
	SBB     AL,sB
	POP     sBC
	flagsetN1

instheader sbba,2
	SAHF                            ;9F SBC A,A
	SBB     AL,AL
	flagsetN1

instheader andb,2
	AND     AL,sB                   ;A0 AND A,B
	LAHF
	AND     AH,0EDh
	OR      AH,10h
	instend

instheader andc,2
	AND     AL,sC                   ;A1 AND A,C
	LAHF
	AND     AH,0EDh
	OR      AH,10h
	instend

instheader andd,2
	AND     AL,sD                   ;A2 AND A,D
	LAHF
	AND     AH,0EDh
	OR      AH,10h
	instend

instheader ande,2
	AND     AL,sE                   ;A3 AND A,E
	LAHF
	AND     AH,0EDh
	OR      AH,10h
	instend

instheader andh,2
	AND     AL,sH                   ;A4 AND A,H
	LAHF
	AND     AH,0EDh
	OR      AH,10h
	instend

instheader andl,2
	AND     AL,sL                   ;A5 AND A,L
	LAHF
	AND     AH,0EDh
	OR      AH,10h
	instend

instheader andm,2
	gbhl    AH                      ;A6 AND A,(HL)
	AND     AL,AH
	LAHF
	AND     AH,0EDh
	OR      AH,10h
	instend

instheader anda,2
	AND     AL,AL                   ;A7 AND A,A
	LAHF
	AND     AH,0EDh
	OR      AH,10h
	instend

instheader xrab,2
	XOR     AL,sB                   ;A8 XOR A,B
	LAHF
	AND     AH,0EDh
	instend

instheader xrac,2
	XOR     AL,sC                   ;A9 XOR A,C
	LAHF
	AND     AH,0EDh
	instend

instheader xrad,2
	XOR     AL,sD                   ;AA XOR A,D
	LAHF
	AND     AH,0EDh
	instend

instheader xrae,2
	XOR     AL,sE                   ;AB XOR A,E
	LAHF
	AND     AH,0EDh
	instend

instheader xrah,2
	XOR     AL,sH                   ;AC XOR A,H
	LAHF
	AND     AH,0EDh
	instend

instheader xral,2
	XOR     AL,sL                   ;AD XOR A,L
	LAHF
	AND     AH,0EDh
	instend

instheader xram,2
	gbhl    AH                      ;AE XOR A,(HL)
	XOR     AL,AH
	LAHF
	AND     AH,0EDh
	instend

instheader xraa,2
	XOR     AL,AL                   ;AF XOR A,A
	LAHF
	AND     AH,0EDh
	instend

instheader orab,2
	OR      AL,sB                   ;B0 OR A,B
	LAHF
	AND     AH,0EDh
	instend

instheader orac,2
	OR      AL,sC                   ;B1 OR A,C
	LAHF
	AND     AH,0EDh
	instend

instheader orad,2
	OR      AL,sD                   ;B2 OR A,D
	LAHF
	AND     AH,0EDh
	instend

instheader orae,2
	OR      AL,sE                   ;B3 OR A,E
	LAHF
	AND     AH,0EDh
	instend

instheader orah,2
	OR      AL,sH                   ;B4 OR A,H
	LAHF
	AND     AH,0EDh
	instend

instheader oral,2
	OR      AL,sL                   ;B5 OR A,L
	LAHF
	AND     AH,0EDh
	instend

instheader oram,2
	gbhl    AH                      ;B6 OR A,(HL)
	OR      AL,AH
	LAHF
	AND     AH,0EDh
	instend

instheader oraa,2
	OR      AL,AL                   ;B7 OR A,A
	LAHF
	AND     AH,0EDh
	instend

instheader cmpb,2
	CMP     AL,sB                   ;B8 CP B
	flagsetN1

instheader cmpc,2
	CMP     AL,sC                   ;B9 CP C
	flagsetN1

instheader cmpd,2
	CMP     AL,sD                   ;BA CP D
	flagsetN1

instheader cmpe,2
	CMP     AL,sE                   ;BB CP E
	flagsetN1

instheader cmph,2
	CMP     AL,sH                   ;BC CP H
	flagsetN1

instheader cmpl,2
	CMP     AL,sL                   ;BD CP L
	flagsetN1

instheader cmpam,2
	gbhl    AH                      ;BE CP (HL)
	CMP     AL,AH
	flagsetN1

instheader cmpaa,2
	CMP     AL,AL                   ;BF CP A
	flagsetN1

instheader rnz,2
	BT      AX,14                   ;C0 RET NZ
	JC      sz80_instend
	ret80

instheader popb,2
	MOV     BP,[simstack]           ;C1 POP BC
	gwordBP sBC
	ADD     BP,2
	MOV     [simstack],BP
	instend

instheader jnzz,2
	BT      AX,14                   ;C2 JP NZ,addr
	JC      SHORT jnzx
	getPC
	instend
jnzx:   ADD     sPC,2
	instend

instheader jmpa,2
	getPC                           ;C3 JP addr
	instend

instheader cnz,2
	BT      AX,14                   ;C4 CALL NZ,addr
	JNC     SHORT cnzdo
	ADD     sPC,2
	instend
cnzdo:  call80

instheader pushb,2
	MOV     BP,[simstack]           ;C5 PUSH BC
	SUB     BP,2
	MOV     [simstack],BP
	wword   sBC
	instend

instheader adi,2
	gbytePC AH                      ;C6 ADD A,nn
	ADD     AL,AH
	flagsetN0

instheader rst0,2
	rst80   0                       ;C7 RST 0

instheader rz,2
	BT      AX,14                   ;C8 RET Z
	JNC     sz80_instend
	ret80

instheader retz,2
	ret80                           ;C9 RET

instheader jzz,2
	BT      AX,14                   ;CA JP Z,addr
	JNC     SHORT jzx
	getPC
	instend
jzx:    ADD     sPC,2
	instend

instheader cz,2
	BT      AX,14                   ;CC CALL Z,addr
	JC      SHORT czdo
	ADD     sPC,2
	instend
czdo:   call80

instheader callz,2
	call80                          ;CD CALL addr

instheader aci,2
	SAHF                            ;CE ADC A,nn
	gbytePC AH    ; does not modify C flag! **
	ADC     AL,AH
	flagsetN0

instheader rst1,2
	rst80   8                       ;CF RST 1

instheader rnc,2
	BT      AX,8                    ;D0 RET NC
	JC      sz80_instend
	ret80

instheader popd,2
	MOV     BP,[simstack]           ;D1 POP DE
	gwordBP sDE
	ADD     BP,2
	MOV     [simstack],BP
	instend

instheader jncz,2
	BT      AX,8                    ;D2 JP NC,addr
	JC      SHORT jncx
	getPC
	instend
jncx:   ADD     sPC,2
	instend

instheader outz,2
	PUSH    AX                      ;D3 OUT (nn),A
	MOV     AH,AL
	PUSH    sBC
	gbytePC sC
	CALL    outp
	POP     sBC
	POP     AX
	instend

instheader cnc,2
	BT      AX,8                    ;D4 CALL NC,addr
	JNC     SHORT cncdo
	ADD     sPC,2
	instend
cncdo:  call80

instheader pushd,2
	MOV     BP,[simstack]           ;D5 PUSH DE
	SUB     BP,2
	MOV     [simstack],BP
	wword   sDE
	instend

instheader sui,2
	gbytePC AH                      ;D6 SUB A,nn
	SUB     AL,AH
	flagsetN1

instheader rst2,2
	rst80   10h                     ;D7 RST,2

instheader rc,2
	BT      AX,8                    ;D8 RET C
	JNC     sz80_instend
	ret80

instheader exx,2
	XCHG    sBC,[sBCx]              ;D9 EXX
	XCHG    sDE,[sDEx]
	XCHG    nSHL,[sHLx]
	instend

instheader jcz,2
	BT      AX,8                    ;DA JP C,addr
	JNC     SHORT jcx
	getPC
	instend
jcx:    ADD     sPC,2
	instend

instheader inz,2
	PUSH    AX                      ;DB IN A,(nn)
	MOV AH,AL
	PUSH    sBC
	gbytePC sC
	CALL    inp
	POP     sBC
	MOVZX   BP,AL
	POP     AX
	XOR     AL,AL
	OR      AX,BP
	instend

instheader cc,2
	BT      AX,8                    ;DC CALL C,addr
	JC      SHORT ccdo
	ADD     sPC,2
	instend
ccdo:   call80

instheader sbi,2
	SAHF                            ;DE SBC A,nn
	gbytePC AH
	SBB     AL,AH
	flagsetN1

instheader rst3,2
	rst80   18h                     ;DF RST 3

instheader rpo,2
	BT      AX,10                   ;E0 RET PO
	JC      sz80_instend
	ret80

instheader poph,2
	MOV     BP,[simstack]           ;E1 POP HL
	gwordBP nSHL
	ADD     BP,2
	MOV     [simstack],BP
	instend

instheader jpoz,2
	BT      AX,10                   ;E2 JP PO,addr
	JC      SHORT jpox
	getPC
	instend
jpox:   ADD     sPC,2
	instend

instheader xthl,2
	MOV     BP,[simstack]           ;E3 EX (SP),HL
	gwordBP sFree
	PUSH    sFree
	wword   nSHL
	POP     nSHL
	instend

instheader cpo,2
	BT      AX,10                   ;E4 CALL PO,addr
	JNC     SHORT cpodo
	ADD     sPC,2
	instend
cpodo:  call80

instheader pushh,2
	MOV     BP,[simstack]           ;E5 PUSH HL
	SUB     BP,2
	MOV     [simstack],BP
	wword   nSHL
	instend

instheader ani,2
	gbytePC AH                      ;E6 AND nn
	AND     AL,AH
	LAHF
	instend

instheader rst4,2
	rst80   20h                     ;E7 RST 4

instheader rpe,2
	BT      AX,10                   ;E8 RET PE
	JNC     sz80_instend
	ret80

instheader pchl,2
	MOV     sPC,nSHL                ;E9 JP (HL)
	InitPCSeg
	instend

instheader jpez,2
	BT      AX,10                   ;EA JP PE,addr
	JNC     SHORT jpex
	getPC
	instend
jpex:   ADD     sPC,2
	instend

instheader xchgz,2
	XCHG    nSHL,sDE                ;EB EX DE,HL
	instend

instheader cpe,2
	BT      AX,10                   ;EC CALL PE,addr
	JC      SHORT cpedo
	ADD     sPC,2
	instend
cpedo:  call80

instheader xri,2
	gbytePC AH                      ;EE XOR nn
	XOR     AL,AH
	LAHF
	AND     AH,0EDh
	instend

instheader rst5,2
	rst80   28h                     ;EF RST 5

instheader rp,2
	BT      AX,15                   ;F0 RET P
	JC      sz80_instend
	ret80

instheader popp,2
	MOV     BP,[simstack]           ;F1 POP AF
	gwordBP AX
	ROL     AX,8
	ADD     BP,2
	MOV     [simstack],BP
	instend

instheader jpz,2
	BT      AX,15                   ;F2 JP P,addr
	JC      SHORT jpx
	getPC
	instend
jpx:    ADD     sPC,2
	instend

instheader diz,2
	MOV     [sIFF1],0               ;F3 DI
	MOV     [sIFF2],0
	instend

instheader cp,2
	BT      AX,15                   ;F4 CALL P,addr
	JNC     SHORT cpdo
	ADD     sPC,2
	instend
cpdo:   call80

instheader pushp,2
	MOV     BP,[simstack]           ;F5 PUSH AF
	SUB     BP,2
	MOV     [simstack],BP
	ROL     AX,8
	wword   AX
	ROL     AX,8
	instend

instheader oria,2
	gbytePC AH                      ;F6 OR nn
	OR      AL,AH
	LAHF
	AND     AH,0EDh        ; *do this everywhere
	instend

instheader rst6,2
	rst80   30h                     ;F7 RST 6

instheader rm,2
	BT      AX,15                   ;F8 RET M
	JNC     sz80_instend
	ret80

instheader sphl,2
	MOV     [simstack],nSHL         ;F9 LD SP,HL
	instend

instheader jmz,2
	BT      AX,15                   ;FA JP M,addr
	JNC     SHORT jmx
	getPC
	instend
jmx:    ADD     sPC,2
	instend

instheader ei,2
	OR      [intflag],2             ;FB EI
	instend

instheader cm,2
	BT      AX,15                   ;FC CALL M,addr
	JC      SHORT cmdo
	ADD     sPC,2
	instend
cmdo:   call80

instheader cpi,2
	gbytePC AH                      ;FE CP nn
	CMP     AL,AH
	flagsetN1

instheader rst7,2
	rst80   38h                     ;FF RST 7

;*************************************************************************
;*                                                                       *
;*       Z-80 opcode simulation routines                                 *
;*                                                                       *
;*************************************************************************

preCB:  gbpc                            ;Grab sub-opcode.
	JMP     [EsFree*2+CBoptab]

preDD:  gbpc
	MOV     BP,[EsFree*2+opclogs]
	SUB     [clocks],BP
	JMP     [EsFree*2+DDoptab]

prDDCB: calcind ix                      ;Calculate operand address.
        DEC     [clocks]
	PUSH    sFree
	gbpc                            ;Sub-sub-opcode
	JMP     [EsFree*2+DDCBopt]

preED:  gbpc
	MOV     BP,[EsFree*2+edclogs]
	SUB     [clocks],BP
	JMP     [EsFree*2+EDoptab]

preFD:  gbpc
	MOV     BP,[EsFree*2+opclogs]
	SUB     [clocks],BP
	JMP     [EsFree*2+FDoptab]

prFDCB: calcind iy                      ;Calculate operand address.
        DEC     [clocks]
	PUSH    sFree
	gbpc                            ;Sub-sub-opcode
	JMP     [EsFree*2+DDCBopt]

iDDCB:  POP     BP
	DEC     sPC
illgED: instend

r_iDDCB:
	POP     BP
r_illgED:
	ADD     [sRF],2
	instend

 ; *******************************************************************

instheader rlcb,4
	ROL     sB,1                    ;CB00 RLC B
	LAHF
	addtoc  sB,sFree
	instend

instheader rlcc,4
	ROL     sC,1                    ;CB01 RLC C
	LAHF
	addtoc  sC,sFree
	instend

instheader rlcd,4
	ROL     sD,1                    ;CB02 RLC D
	LAHF
	addtoc  sD,sFree
	instend

instheader rlce,4
	ROL     sE,1                    ;CB03 RLC E
	LAHF
	addtoc  sE,sFree
	instend

instheader rlch,4
	ROL     sH,1                    ;CB04 RLC H
	LAHF
	addtoc  sH,sFree
	instend

instheader rlcl,4
	ROL     sL,1                    ;CB05 RLC L
	LAHF
	addtoc  sL,sFree
	instend

instheader rlcm,4
	PUSH    sBC                     ;CB06 RLC (HL)
	gbhl    sC
	ROL     sC,1
	LAHF
	addtoc  sC,sFree
	wbhl    sC
	POP     sBC
	instend

instheader rlca,4
	ROL     AL,1                    ;CB07 RLC A
	LAHF
	addtoc  AL,sFree
	instend

instheader rrcb,4
	ROR     sB,1                    ;CB08 RRC B
	LAHF
	addtoc  sB,sFree
	instend

instheader rrcc,4
	ROR     sC,1                    ;CB09 RRC C
	LAHF
	addtoc  sC,sFree
	instend

instheader rrcd,4
	ROR     sD,1                    ;CB0A RRC D
	LAHF
	addtoc  sD,sFree
	instend

instheader rrce,4
	ROR     sE,1                    ;CB0B RRC E
	LAHF
	addtoc  sE,sFree
	instend

instheader rrch,4
	ROR     sH,1                    ;CB0C RRC H
	LAHF
	addtoc  sH,BP
	instend

instheader rrcl,4
	ROR     sL,1                    ;CB0D RRC L
	LAHF
	addtoc  sL,sFree
	instend

instheader rrcm,4
	PUSH    sBC                     ;CB0E RRC (HL)
	gbhl    sC
	ROR     sC,1
	LAHF
	addtoc  sC,sFree
	wbhl    sC
	POP     sBC
	instend

instheader rrca,4
	ROR     AL,1                    ;CB0F RRC A
	LAHF
	addtoc  AL,sFree
	instend

instheader rlrb,4
	SAHF                            ;CB10 RL B
	RCL     sB,1
	LAHF
	addtoc  sB,sFree
	instend

instheader rlrc,4
	SAHF                            ;CB11 RL C
	RCL     sC,1
	LAHF
	addtoc  sC,sFree
	instend

instheader rlrd,4
	SAHF                            ;CB12 RL D
	RCL     sD,1
	LAHF
	addtoc  sD,sFree
	instend

instheader rlre,4
	SAHF                            ;CB13 RL E
	RCL     sE,1
	LAHF
	addtoc  sE,sFree
	instend

instheader rlrh,4
	SAHF                            ;CB14 RL H
	RCL     sH,1
	LAHF
	addtoc  sH,sFree
	instend

instheader rlrl,4
	SAHF                            ;CB15 RL L
	RCL     sL,1
	LAHF
	addtoc  sL,sFree
	instend

instheader rlrm,4
	PUSH    sBC                     ;CB16 RL (HL)
	gbhl    sC
	SAHF
	RCL     sC,1
	LAHF
	addtoc  sC,sFree
	wbhl    sC
	POP     sBC
	instend

instheader rlra,4
	SAHF                            ;CB17 RL A
	RCL     AL,1
	LAHF
	addtoc  AL,sFree
	instend

instheader rrrb,4
	SAHF                            ;CB18 RR B
	RCR     sB,1
	LAHF
	addtoc  sB,sFree
	instend

instheader rrrc,4
	SAHF                            ;CB19 RR C
	RCR     sC,1
	LAHF
	addtoc  sC,sFree
	instend

instheader rrrd,4
	SAHF                            ;CB1A RR D
	RCR     sD,1
	LAHF
	addtoc  sD,sFree
	instend

instheader rrre,4
	SAHF                            ;CB1B RR E
	RCR     sE,1
	LAHF
	addtoc  sE,sFree
	instend

instheader rrrh,4
	SAHF                            ;CB1C RR H
	RCR     sH,1
	LAHF
	addtoc  sH,sFree
	instend

instheader rrrl,4
	SAHF                            ;CB1D RR L
	RCR     sL,1
	LAHF
	addtoc  sL,sFree
	instend

instheader rrrm,4
	PUSH    sBC                     ;CB1E RR (HL)
	gbhl    sC
	SAHF
	RCR     sC,1
	LAHF
	addtoc  sC,sFree
	wbhl    sC
	POP     sBC
	instend

instheader rrra,4
	SAHF                            ;CB1F RR A
	RCR     AL,1
	LAHF
	addtoc  AL,sFree
	instend

instheader slab,4
	SAL     sB,1                    ;CB20 SLA B
	LAHF
	instend

instheader slac,4
	SAL     sC,1                    ;CB21 SLA C
	LAHF
	instend

instheader slad,4
	SAL     sD,1                    ;CB22 SLA D
	LAHF
	instend

instheader slae,4
	SAL     sE,1                    ;CB23 SLA E
	LAHF
	instend

instheader slah,4
	SAL     sH,1                    ;CB24 SLA H
	LAHF
	instend

instheader slal,4
	SAL     sL,1                    ;CB25 SLA L
	LAHF
	instend

instheader slam,4
	PUSH    sBC                     ;CB26 SLA (HL)
	gbhl    sC
	SAL     sC,1
	LAHF
	wbhl    sC
	POP     sBC
	instend

instheader slaa,4
	SAL     AL,1                    ;CB27 SLA A
	LAHF
	instend

instheader srab,4
	SAR     sB,1                    ;CB28 SRA B
	LAHF
	instend

instheader srac,4
	SAR     sC,1                    ;CB29 SRA C
	LAHF
	instend

instheader srad,4
	SAR     sD,1                    ;CB2A SRA D
	LAHF
	instend

instheader srae,4
	SAR     sE,1                    ;CB2B SRA E
	LAHF
	instend

instheader srah,4
	SAR     sH,1                    ;CB2C SRA H
	LAHF
	instend

instheader sral,4
	SAR     sL,1                    ;CB2D SRA L
	LAHF
	instend

instheader sram,4
	PUSH    sBC                     ;CB2E SRA (HL)
	gbhl    sC
	SAR     sC,1
	LAHF
	wbhl    sC
	POP     sBC
	instend

instheader sraa,4
	SAR     AL,1                    ;CB2F SRA A
	LAHF
	instend

instheader sllb,4
	SAL     sB,1                    ;CB30 SLL B
	LAHF
	OR      sB,1
	instend

instheader sllc,4
	SAL     sC,1                    ;CB31 SLL C
	LAHF
	OR      sC,1
	instend

instheader slld,4
	SAL     sD,1                    ;CB32 SLL D
	LAHF
	OR      sD,1
	instend

instheader slle,4
	SAL     sE,1                    ;CB33 SLL E
	LAHF
	OR      sE,1
	instend

instheader sllh,4
	SAL     sH,1                    ;CB34 SLL H
	LAHF
	OR      sH,1
	instend

instheader slll,4
	SAL     sL,1                    ;CB35 SLL L
	LAHF
	OR      sL,1
	instend

instheader sllm,4
	PUSH    sBC                     ;CB36 SLL (HL)
	gbhl    sC
	SAL     sC,1
	LAHF
	OR      sC,1
	wbhl    sC
	POP     sBC
	instend

instheader slla,4
	SAL     AL,1                    ;CB37 SLL A
	LAHF
	OR      AL,1
	instend

instheader srlb,4
	SHR     sB,1                    ;CB38 SRL B
	LAHF
	instend

instheader srlc,4
	SHR     sC,1                    ;CB39 SRL C
	LAHF
	instend

instheader srld,4
	SHR     sD,1                    ;CB3A SRL D
	LAHF
	instend

instheader srle,4
	SHR     sE,1                    ;CB3B SRL E
	LAHF
	instend

instheader srlh,4
	SHR     sH,1                    ;CB3C SRL H
	LAHF
	instend

instheader srll,4
	SHR     sL,1                    ;CB3D SRL L
	LAHF
	instend

instheader srlm,4
	PUSH    sBC                     ;CB3E SRL (HL)
	gbhl    sC
	SHR     sC,1
	LAHF
	wbhl    sC
	POP     sBC
	instend

instheader srla,4
	SHR     AL,1                    ;CB3F SRL A
	LAHF
	instend

instheader bit0b,4
	BT      sBC,8                   ;CB40 BIT 0,B
	dozf

instheader bit0c,4
	BT      sBC,0                   ;CB41 BIT 0,C
	dozf

instheader bit0d,4
	BT      sDE,8                   ;CB42 BIT 0,D
	dozf

instheader bit0e,4
	BT      sDE,0                   ;CB43 BIT 0,E
	dozf

instheader bit0h,4
	BT      nSHL,8                  ;CB44 BIT 0,H
	dozf

instheader bit0l,4
	BT      nSHL,0                  ;CB45 BIT 0,L
	dozf

instheader bit0m,4
	gwordhl BP                      ;CB46 BIT 0,(HL)
	BT      BP,0
	dozf

instheader bit0a,4
	BT      AX,0                    ;CB47 BIT 0,A
	dozf

instheader bit1b,4
	BT      sBC,9                   ;CB48 BIT 1,B
	dozf

instheader bit1c,4
	BT      sBC,1                   ;CB49 BIT 1,C
	dozf

instheader bit1d,4
	BT      sDE,9                   ;CB4A BIT 1,D
	dozf

instheader bit1e,4
	BT      sDE,1                   ;CB4B BIT 1,E
	dozf

instheader bit1h,4
	BT      nSHL,9                  ;CB4C BIT 1,H
	dozf

instheader bit1l,4
	BT      nsHL,1                  ;CB4D BIT 1,L
	dozf

instheader bit1m,4
	gwordhl BP                      ;CB4E BIT 1,(HL)
	BT      BP,1
	dozf

instheader bit1a,4
	BT      AX,1                    ;CB4F BIT 1,A
	dozf

instheader bit2b,4
	BT      sBC,10                  ;CB50 BIT 2,B
	dozf

instheader bit2c,4
	BT      sBC,2                   ;CB51 BIT 2,C
	dozf

instheader bit2d,4
	BT      sDE,10                  ;CB52 BIT 2,D
	dozf

instheader bit2e,4
	BT      sDE,2                   ;CB53 BIT 2,E
	dozf

instheader bit2h,4
	BT      nSHL,10                 ;CB54 BIT 2,H
	dozf

instheader bit2l,4
	BT      nSHL,2                  ;CB55 BIT 2,L
	dozf

instheader bit2m,4
	gwordhl BP                      ;CB56 BIT 2,(HL)
	BT      BP,2
	dozf

instheader bit2a,4
	BT      AX,2                    ;CB57 BIT 2,A
	dozf

instheader bit3b,4
	BT      sBC,11                  ;CB58 BIT 3,B
	dozf

instheader bit3c,4
	BT      sBC,3                   ;CB59 BIT 3,C
	dozf

instheader bit3d,4
	BT      sDE,11                  ;CB5A BIT 3,D
	dozf

instheader bit3e,4
	BT      sDE,3                   ;CB5B BIT 3,E
	dozf

instheader bit3h,4
	BT      nSHL,11                 ;CB5C BIT 3,H
	dozf

instheader bit3l,4
	BT      nSHL,3                  ;CB5D BIT 3,L
	dozf

instheader bit3m,4
	gwordhl BP                      ;CB5E BIT 3,(HL)
	BT      BP,3
	dozf

instheader bit3a,4
	BT      AX,3                    ;CB5F BIT 3,A
	dozf

instheader bit4b,4
	BT      sBC,12                  ;CB60 BIT 4,B
	dozf

instheader bit4c,4
	BT      sBC,4                   ;CB61 BIT 4,C
	dozf

instheader bit4d,4
	BT      sDE,12                  ;CB62 BIT 4,D
	dozf

instheader bit4e,4
	BT      sDE,4                   ;CB63 BIT 4,E
	dozf

instheader bit4h,4
	BT      nSHL,12                 ;CB64 BIT 4,H
	dozf

instheader bit4l,4
	BT      nSHL,4                  ;CB65 BIT 4,L
	dozf

instheader bit4m,4
	gwordhl BP                      ;CB66 BIT 4,(HL)
	BT      BP,4
	dozf

instheader bit4a,4
	BT      AX,4                    ;CB67 BIT 4,A
	dozf

instheader bit5b,4
	BT      sBC,13                  ;CB68 BIT 5,B
	dozf

instheader bit5c,4
	BT      sBC,5                   ;CB69 BIT 5,C
	dozf

instheader bit5d,4
	BT      sDE,13                  ;CB6A BIT 5,D
	dozf

instheader bit5e,4
	BT      sDE,5                   ;CB6B BIT 5,E
	dozf

instheader bit5h,4
	BT      nSHL,13                 ;CB6C BIT 5,H
	dozf

instheader bit5l,4
	BT      nSHL,5                  ;CB6D BIT 5,L
	dozf

instheader bit5m,4
	gwordhl BP                      ;CB6E BIT 5,(HL)
	BT      BP,5
	dozf

instheader bit5a,4
	BT      AX,5                    ;CB6F BIT 5,A
	dozf

instheader bit6b,4
	BT      sBC,14                  ;CB70 BIT 6,B
	dozf

instheader bit6c,4
	BT      sBC,6                   ;CB71 BIT 6,C
	dozf

instheader bit6d,4
	BT      sDE,14                  ;CB72 BIT 6,D
	dozf

instheader bit6e,4
	BT      sDE,6                   ;CB73 BIT 6,E
	dozf

instheader bit6h,4
	BT      nSHL,14                 ;CB74 BIT 6,H
	dozf

instheader bit6l,4
	BT      nSHL,6                  ;CB75 BIT 6,L
	dozf

instheader bit6m,4
	gwordhl BP                      ;CB76 BIT 6,(HL)
	BT      BP,6
	dozf

instheader bit6a,4
	BT      AX,6                    ;CB77 BIT 6,A
	dozf

instheader bit7b,4
	BT      sBC,15                  ;CB78 BIT 7,B
	dozmf

instheader bit7c,4
	BT      sBC,7                   ;CB79 BIT 7,C
	dozmf

instheader bit7d,4
	BT      sDE,15                  ;CB7A BIT 7,D
	dozmf

instheader bit7e,4
	BT      sDE,7                   ;CB7B BIT 7,E
	dozmf

instheader bit7h,4
	BT      nSHL,15                 ;CB7C BIT 7,H
	dozmf

instheader bit7l,4
	BT      nSHL,7                  ;CB7D BIT 7,L
	dozmf

instheader bit7m,4
	gwordhl BP                      ;CB7E BIT 7,(HL)
	BT      BP,7
	dozmf

instheader bit7a,4
	BT      AX,7                    ;CB7F BIT 7,A
	dozmf

instheader res0b,4
	AND     sB,0FEh                 ;CB80 RES 0,B
	instend

instheader res0c,4
	AND     sC,0FEh                 ;CB81 RES 0,C
	instend

instheader res0d,4
	AND     sD,0FEh                 ;CB82 RES 0,D
	instend

instheader res0e,4
	AND     sE,0FEh                 ;CB83 RES 0,E
	instend

instheader res0h,4
	AND     sH,0FEh                 ;CB84 RES 0,H
	instend

instheader res0l,4
	AND     sL,0FEh                 ;CB85 RES 0,L
	instend

instheader res0m,4
	PUSH    AX                      ;CB86 RES 0,(HL)
	gbhl    AL
	AND     AL,0FEh
	wbhl    AL
	POP     AX
	instend

instheader res0a,4
	AND     AL,0FEh                 ;CB87 RES 0,A
	instend

instheader res1b,4
	AND     sB,0FDh                 ;CB88 RES 1,B
	instend

instheader res1c,4
	AND     sC,0FDh                 ;CB89 RES 1,C
	instend

instheader res1d,4
	AND     sD,0FDh                 ;CB8A RES 1,D
	instend

instheader res1e,4
	AND     sE,0FDh                 ;CB8B RES 1,E
	instend

instheader res1h,4
	AND     sH,0FDh                 ;CB8C RES 1,H
	instend

instheader res1l,4
	AND     sL,0FDh                 ;CB8D RES 1,L
	instend

instheader res1m,4
	PUSH    AX                      ;CB8E RES 1,(HL)
	gbhl    AL
	AND     AL,0FDh
	wbhl    AL
	POP     AX
	instend

instheader res1a,4
	AND     AL,0FDh                 ;CB8F RES 1,A
	instend

instheader res2b,4
	AND     sB,0FBh                 ;CB90 RES 2,B
	instend

instheader res2c,4
	AND     sC,0FBh                 ;CB91 RES 2,C
	instend

instheader res2d,4
	AND     sD,0FBh                 ;CB92 RES 2,D
	instend

instheader res2e,4
	AND     sE,0FBh                 ;CB93 RES 2,E
	instend

instheader res2h,4
	AND     sH,0FBh                 ;CB94 RES 2,H
	instend

instheader res2l,4
	AND     sL,0FBh                 ;CB95 RES 2,L
	instend

instheader res2m,4
	PUSH    AX                      ;CB96 RES 2,(HL)
	gbhl    AL
	AND     AL,0FBh
	wbhl    AL
	POP     AX
	instend

instheader res2a,4
	AND     AL,0FBh                 ;CB97 RES 3,A
	instend

instheader res3b,4
	AND     sB,0F7h                 ;CB98 RES 3,B
	instend

instheader res3c,4
	AND     sC,0F7h                 ;CB99 RES 3,C
	instend

instheader res3d,4
	AND     sD,0F7h                 ;CB9A RES 3,D
	instend

instheader res3e,4
	AND     sE,0F7h                 ;CB9B RES 3,E
	instend

instheader res3h,4
	AND     sH,0F7h                 ;CB9C RES 3,H
	instend

instheader res3l,4
	AND     sL,0F7h                 ;CB9D RES 3,L
	instend

instheader res3m,4
	PUSH    AX                      ;CB9E RES 3,(HL)
	gbhl    AL
	AND     AL,0F7h
	wbhl    AL
	POP     AX
	instend

instheader res3a,4
	AND     AL,0F7h                 ;CB9F RES 3,A
	instend

instheader res4b,4
	AND     sB,0EFh                 ;CBA0 RES 4,B
	instend

instheader res4c,4
	AND     sC,0EFh                 ;CBA1 RES 4,C
	instend

instheader res4d,4
	AND     sD,0EFh                 ;CBA2 RES 4,D
	instend

instheader res4e,4
	AND     sE,0EFh                 ;CBA3 RES 4,E
	instend

instheader res4h,4
	AND     sH,0EFh                 ;CBA4 RES 4,H
	instend

instheader res4l,4
	AND     sL,0EFh                 ;CBA5 RES 4,L
	instend

instheader res4m,4
	PUSH    AX                      ;CBA6 RES 4,(HL)
	gbhl    AL
	AND     AL,0EFh
	wbhl    AL
	POP     AX
	instend

instheader res4a,4
	AND     AL,0EFh                 ;CBA7 RES 4,A
	instend

instheader res5b,4
	AND     sB,0DFh                 ;CBA8 RES 5,B
	instend

instheader res5c,4
	AND     sC,0DFh                 ;CBA9 RES 5,C
	instend

instheader res5d,4
	AND     sD,0DFh                 ;CBAA RES 5,D
	instend

instheader res5e,4
	AND     sE,0DFh                 ;CBAB RES 5,E
	instend

instheader res5h,4
	AND     sH,0DFh                 ;CBAC RES 5,H
	instend

instheader res5l,4
	AND     sL,0DFh                 ;CBAD RES 5,L
	instend

instheader res5m,4
	PUSH    AX                      ;CBAE RES 5,(HL)
	gbhl    AL
	AND     AL,0DFh
	wbhl    AL
	POP     AX
	instend

instheader res5a,4
	AND     AL,0DFh                 ;CBAF RES 5,A
	instend

instheader res6b,4
	AND     sB,0BFh                 ;CBB0 RES 6,B
	instend

instheader res6c,4
	AND     sC,0BFh                 ;CBB1 RES 6,C
	instend

instheader res6d,4
	AND     sD,0BFh                 ;CBB2 RES 6,D
	instend

instheader res6e,4
	AND     sE,0BFh                 ;CBB3 RES 6,E
	instend

instheader res6h,4
	AND     sH,0BFh                 ;CBB4 RES 6,H
	instend

instheader res6l,4
	AND     sL,0BFh                 ;CBB5 RES 6,L
	instend

instheader res6m,4
	PUSH    AX                      ;CBB6 RES 6,(HL)
	gbhl    AL
	AND     AL,0BFh
	wbhl    AL
	POP     AX
	instend

instheader res6a,4
	AND     AL,0BFh                 ;CBB7 RES 6,A
	instend

instheader res7b,4
	AND     sB,07Fh                 ;CBB8 RES 7,B
	instend

instheader res7c,4
	AND     sC,07Fh                 ;CBB9 RES 7,C
	instend

instheader res7d,4
	AND     sD,07Fh                 ;CBBA RES 7,D
	instend

instheader res7e,4
	AND     sE,07Fh                 ;CBBB RES 7,E
	instend

instheader res7h,4
	AND     sH,07Fh                 ;CBBC RES 7,H
	instend

instheader res7l,4
	AND     sL,07Fh                 ;CBBD RES 7,L
	instend

instheader res7m,4
	PUSH    AX                      ;CBBE RES 7,(HL)
	gbhl    AL
	AND     AL,07Fh
	wbhl    AL
	POP     AX
	instend

instheader res7a,4
	AND     AL,07Fh                 ;CBBF RES 7,A
	instend

instheader set0b,4
	OR      sB,1                    ;CBC0 SET 0,B
	instend

instheader set0c,4
	OR      sC,1                    ;CBC1 SET 0,C
	instend

instheader set0d,4
	OR      sD,1                    ;CBC2 SET 0,D
	instend

instheader set0e,4
	OR      sE,1                    ;CBC3 SET 0,E
	instend

instheader set0h,4
	OR      sH,1                    ;CBC4 SET 0,H
	instend

instheader set0l,4
	OR      sL,1                    ;CBC5 SET 0,L
	instend

instheader set0m,4
	PUSH    AX                      ;CBC6 SET 0,(HL)
	gbhl    AL
	OR      AL,1
	wbhl    AL
	POP     AX
	instend

instheader set0a,4
	OR      AL,1                    ;CBC7 SET 0,A
	instend

instheader set1b,4
	OR      sB,2                    ;CBC8 SET 1,B
	instend

instheader set1c,4
	OR      sC,2                    ;CBC9 SET 1,C
	instend

instheader set1d,4
	OR      sD,2                    ;CBCA SET 1,D
	instend

instheader set1e,4
	OR      sE,2                    ;CBCB SET 1,E
	instend

instheader set1h,4
	OR      sH,2                    ;CBCC SET 1,H
	instend

instheader set1l,4
	OR      sL,2                    ;CBCD SET 1,L
	instend

instheader set1m,4
	PUSH    AX                      ;CBCE SET 1,(HL)
	gbhl    AL
	OR      AL,2
	wbhl    AL
	POP     AX
	instend

instheader set1a,4
	OR      AL,2                    ;CBCF SET 1,A
	instend

instheader set2b,4
	OR      sB,4                    ;CBD0 SET 2,B
	instend

instheader set2c,4
	OR      sC,4                    ;CBD1 SET 2,C
	instend

instheader set2d,4
	OR      sD,4                    ;CBD2 SET 2,D
	instend

instheader set2e,4
	OR      sE,4                    ;CBD3 SET 2,E
	instend

instheader set2h,4
	OR      sH,4                    ;CBD4 SET 2,H
	instend

instheader set2l,4
	OR      sL,4                    ;CBD5 SET 2,L
	instend

instheader set2m,4
	PUSH    AX                      ;CBD6 SET 2,(HL)
	gbhl    AL
	OR      AL,4
	wbhl    AL
	POP     AX
	instend

instheader set2a,4
	OR      AL,4                    ;CBD7 SET 2,A
	instend

instheader set3b,4
	OR      sB,8                    ;CBD8 SET 3,B
	instend

instheader set3c,4
	OR      sC,8                    ;CBD9 SET 3,C
	instend

instheader set3d,4
	OR      sD,8                    ;CBDA SET 3,D
	instend

instheader set3e,4
	OR      sE,8                    ;CBDB SET 3,E
	instend

instheader set3h,4
	OR      sH,8                    ;CBDC SET 3,H
	instend

instheader set3l,4
	OR      sL,8                    ;CBDD SET 3,L
	instend

instheader set3m,4
	PUSH    AX                      ;CBDE SET 3,(HL)
	gbhl    AL
	OR      AL,8
	wbhl    AL
	POP     AX
	instend

instheader set3a,4
	OR      AL,8                    ;CBDF SET 3,A
	instend

instheader set4b,4
	OR      sB,16                   ;CBE0 SET 4,B
	instend

instheader set4c,4
	OR      sC,16                   ;CBE1 SET 4,C
	instend

instheader set4d,4
	OR      sD,16                   ;CBE2 SET 4,D
	instend

instheader set4e,4
	OR      sE,16                   ;CBE3 SET 4,E
	instend

instheader set4h,4
	OR      sH,16                   ;CBE4 SET 4,H
	instend

instheader set4l,4
	OR      sL,16                   ;CBE5 SET 4,L
	instend

instheader set4m,4
	PUSH    AX                      ;CBE6 SET 4,(HL)
	gbhl    AL
	OR      AL,16
	wbhl    AL
	POP     AX
	instend

instheader set4a,4
	OR      AL,16                   ;CBE7 SET 4,A
	instend

instheader set5b,4
	OR      sB,32                   ;CBE8 SET 5,B
	instend

instheader set5c,4
	OR      sC,32                   ;CBE9 SET 5,C
	instend

instheader set5d,4
	OR      sD,32                   ;CBEA SET 5,D
	instend

instheader set5e,4
	OR      sE,32                   ;CBEB SET 5,E
	instend

instheader set5h,4
	OR      sH,32                   ;CBEC SET 5,H
	instend

instheader set5l,4
	OR      sL,32                   ;CBED SET 5,L
	instend

instheader set5m,4
	PUSH    AX                      ;CBEE SET 5,(HL)
	gbhl    AL
	OR      AL,32
	wbhl    AL
	POP     AX
	instend

instheader set5a,4
	OR      AL,32                   ;CBEF SET 5,A
	instend

instheader set6b,4
	OR      sB,64                   ;CBE0 SET 6,B
	instend

instheader set6c,4
	OR      sC,64                   ;CBF1 SET 6,C
	instend

instheader set6d,4
	OR      sD,64                   ;CBF2 SET 6,D
	instend

instheader set6e,4
	OR      sE,64                   ;CBF3 SET 6,E
	instend

instheader set6h,4
	OR      sH,64                   ;CBF4 SET 6,H
	instend

instheader set6l,4
	OR      sL,64                   ;CBF5 SET 6,L
	instend

instheader set6m,4
	PUSH    AX                      ;CBF6 SET 6,(HL)
	gbhl    AL
	OR      AL,64
	wbhl    AL
	POP     AX
	instend

instheader set6a,4
	OR      AL,64                   ;CBF7 SET 6,A
	instend

instheader set7b,4
	OR      sB,128                  ;CBF8 SET 7,B
	instend

instheader set7c,4
	OR      sC,128                  ;CBF9 SET 7,C
	instend

instheader set7d,4
	OR      sD,128                  ;CBFA SET 7,D
	instend

instheader set7e,4
	OR      sE,128                  ;CBFB SET 7,E
	instend

instheader set7h,4
	OR      sH,128                  ;CBFC SET 7,H
	instend

instheader set7l,4
	OR      sL,128                  ;CBFD SET 7,L
	instend

instheader set7m,4
	PUSH    AX                      ;CBFE SET 7,(HL)
	gbhl    AL
	OR      AL,128
	wbhl    AL
	POP     AX
	instend

instheader set7a,4
	OR      AL,128                  ;CBFF SET 7,A
	instend

instheader dadixb,4
	ADD     [ix],sBC                ;DD09 ADD IX,BC
	docyf

instheader dadixd,4
	ADD     [ix],sDE                ;DD19 ADD IX,DE
	docyf

instheader lxiix,4
	gwpc    BP                      ;DD21 LD IX,nnnn
	MOV     [ix],BP
	instend

instheader sixd,4
	PUSH    sDE                     ;DD22 LD (addr),IX
	gwpc    BP
	MOV     sDE,[ix]
	wword   sDE
	POP     sDE
	instend

instheader inxix,4
	INC     [ix]                    ;DD23 INC IX
	instend

instheader inrxh,4
	z80inc  [xh]                    ;DD24 INC XH (undocumented)

instheader dcrxh,4
	z80dec  [xh]                    ;DD25 DEC XH (undocumented)

instheader mvixh,4
	PUSH    AX                      ;DD26 LD XH,nn (undocumented)
	gbytePC AL
	MOV     [xh],AL
	POP     AX
	instend

instheader dadixx,4
	MOV     BP,[ix]                 ;DD29 ADD IX,IX
	ADD     [ix],BP
	docyf

instheader lixd,4
	gwpc    BP                      ;DD2A LD IX,(addr)
	gwordBP BP
	MOV     [ix],BP
	instend

instheader dcxix,4
	DEC     [ix]                    ;DD2B DEC IX
	instend

instheader inrxl,4
	z80inc  [xl]                    ;DD2C INC XL (undocumented)

instheader dcrxl,4
	z80dec  [xl]                    ;DD2D DEC XL (undocumented)

instheader mvixl,4
	PUSH    AX                      ;DD2E LD XL,nn (undocumented)
	gbytePC AL
	MOV     [xl],AL
	POP     AX
	instend

instheader inrix,4
	calcind ix                      ;DD34 INC (IX+d)
	PUSH    sBC
	gbytefr sC
	z80inco sC
	wbytefr sC
	POP     sBC
	instend

instheader dcrix,4
	calcind ix                      ;DD35 DEC (IX+d)
	PUSH    sBC
	gbytefr sC
	z80deco sC
	wbytefr sC
	POP     sBC
	instend

instheader mviix,4
	calcind ix                      ;DD36 LD (IX+d),nn
	PUSH    AX
	gbytePC AL
	wbytefr AL
	POP     AX
	instend

instheader dadixs,4
	MOV     BP,[simstack]           ;DD39 ADD IX,SP
	ADD     [ix],BP
	docyf

instheader movbxh,4
	MOV     sB,[xh]                 ;DD44 LD B,XH (undocumented)
	instend

instheader movbxl,4
	MOV     sB,[xl]                 ;DD45 LD B,XL (undocumented)
	instend

instheader movbix,4
	calcind ix                      ;DD46 LD B,(IX+d)
	gbytefr sB
	instend

instheader movcxh,4
	MOV     sC,[xh]                 ;DD4C LD C,XH (undocumented)
	instend

instheader movcxl,4
	MOV     sC,[xl]                 ;DD4D LD C,XL (undocumented)
	instend

instheader movcix,4
	calcind ix                      ;DD4E LD C,(IX+d)
	gbytefr sC
	instend

instheader movdxh,4
	MOV     sD,[xh]                 ;DD54 LD D,XH (undocumented)
	instend

instheader movdxl,4
	MOV     sD,[xl]                 ;DD55 LD D,XL (undocumented)
	instend

instheader movdix,4
	calcind ix                      ;DD56 LD D,(IX+d)
	gbytefr sD
	instend

instheader movexh,4
	MOV     sE,[xh]                 ;DD5C LD E,XH (undocumented)
	instend

instheader movexl,4
	MOV     sE,[xl]                 ;DD5D LD E,XL (undocumented)
	instend

instheader moveix,4
	calcind ix                      ;DD5E LD E,(IX+d)
	gbytefr sE
	instend

instheader movxhb,4
	MOV     [xh],sB                 ;DD60 LD XH,B (undocumented)
	instend

instheader movxhc,4
	MOV     [xh],sC                 ;DD61 LD XH,C (undocumented)
	instend

instheader movxhd,4
	MOV     [xh],sD                 ;DD62 LD XH,D (undocumented)
	instend

instheader movxhe,4
	MOV     [xh],sE                 ;DD63 LD XH,E (undocumented)
	instend

instheader mvxhxh,4
	instend                         ;DD64 LD XH,XH (undocumented)

instheader mvxhxl,4
	PUSH    AX                      ;DD65 LD XH,XL (undocumented)
	MOV     AL,[xl]
	MOV     [xh],AL
	POP     AX
	instend

instheader movhix,4
	calcind ix                      ;DD66 LD H,(IX+d)
	gbytefr sH
	instend

instheader movxha,4
	MOV     [xh],AL                 ;DD67 LD XH,A
	instend

instheader movxlb,4
	MOV     [xl],sB                 ;DD68 LD XL,B (undocumented)
	instend

instheader movxlc,4
	MOV     [xl],sC                 ;DD69 LD XL,C (undocumented)
	instend

instheader movxld,4
	MOV     [xl],sD                 ;DD6A LD XL,D (undocumented)
	instend

instheader movxle,4
	MOV     [xl],sE                 ;DD6B LD XL,E (undocumented)
	instend

instheader mvxlxh,4
	PUSH    AX                      ;DD6C LD XL,XH (undocumented)
	MOV     AL,[xh]
	MOV     [xl],AL
	POP     AX
	instend

instheader mvxlxl,4
	instend                         ;DD6D LD XL,XL (undocumented)

instheader movlix,4
	calcind ix                      ;DD6E LD L,(IX+d)
	gbytefr sL
	instend

instheader movxla,4
	MOV     [xl],AL                 ;DD6F LD XL,A
	instend

instheader movixb,4
	calcind ix                      ;DD70 LD (IX+d),B
	wbytefr sB
	instend

instheader movixc,4
	calcind ix                      ;DD71 LD (IX+d),C
	wbytefr sC
	instend

instheader movixd,4
	calcind ix                      ;DD72 LD (IX+d),D
	wbytefr sD
	instend

instheader movixe,4
	calcind ix                      ;DD73 LD (IX+d),E
	wbytefr sE
	instend

instheader movixh,4
	calcind ix                      ;DD74 LD (IX+d),H
	wbytefr sH
	instend

instheader movixl,4
	calcind ix                      ;DD75 LD (IX+d),L
	wbytefr sL
	instend

instheader movixa,4
	calcind ix                      ;DD77 LD (IX+d),A
	wbytefr AL
	instend

instheader movaxh,4
	MOV     AL,[xh]                 ;DD7C LD A,XH (undocumented)
	instend

instheader movaxl,4
	MOV     AL,[xl]                 ;DD7D LD A,XL (undocumented)
	instend

instheader movaix,4
	calcind ix                      ;DD7E LD A,(IX+d)
	gbytefr AL
	instend

instheader addxh,4
	ADD     AL,[xh]                 ;DD84 ADD A,XH (undocumented)
	flagsetN0

instheader addxl,4
	ADD     AL,[xl]                 ;DD85 ADD A,XL (undocumented)
	flagsetN0

instheader addix,4
	calcind ix                      ;DD86 ADD A,(IX+d)
	gbytefr AH
	ADD     AL,AH
	flagsetN0

instheader adcxh,4
	SAHF                            ;DD8C ADC A,XH (undocumented)
	ADC     AL,[xh]
	flagsetN0

instheader adcxl,4
	SAHF                            ;DD8E ADC A,XL (undocumented)
	ADC     AL,[xl]
	flagsetN0

instheader adcix,4
	calcind ix                      ;DD8E ADC A,(IX+d)
	PUSH    sBC
	gbytefr sC
	SAHF
	ADC     AL,sC
	POP     sBC
	flagsetN0

instheader subxh,4
	SUB     AL,[xh]                 ;DD94 SUB A,XH (undocumented)
	flagsetN1

instheader subxl,4
	SUB     AL,[xl]                 ;DD95 SUB A,XL (undocumented)
	flagsetN1

instheader subix,4
	calcind ix                      ;DD96 SUB A,(IX+d)
	gbytefr AH
	SUB     AL,AH
	flagsetN1

instheader sbbxh,4
	SAHF                            ;DD9C SBC A,XH (undocumented)
	SBB     AL,[xh]
	flagsetN1

instheader sbbxl,4
	SAHF                            ;DD9D SBC A,XL (undocumented)
	SBB     AL,[xl]
	flagsetN1

instheader sbbix,4
	calcind ix                      ;DD9E SBC A,(IX+d)
	PUSH    sBC
	gbytefr sC
	SAHF
	SBB     AL,sC
	POP     sBC
	flagsetN1

instheader anaxh,4
	AND     AL,[xh]                 ;DDA4 AND A,XH (undocumented)
	LAHF
	instend

instheader anaxl,4
	AND     AL,[xl]                 ;DDA5 AND A,XL (undocumented)
	LAHF
	instend

instheader anaix,4
	calcind ix                      ;DDA6 AND A,(IX+d)
	gbytefr AH
	AND     AL,AH
	LAHF
	instend

instheader xraxh,4
	XOR     AL,[xh]                 ;DDAC XOR A,XH (undocumented)
	LAHF
	instend

instheader xraxl,4
	XOR     AL,[xl]                 ;DDAD XOR A,XL (undocumented)
	LAHF
	instend

instheader xraix,4
	calcind ix                      ;DDAE XOR A,(IX+d)
	gbytefr AH
	XOR     AL,AH
	LAHF
	instend

instheader oraxh,4
	OR      AL,[xh]                 ;DDB4 OR A,XH (undocumented)
	LAHF
	instend

instheader oraxl,4
	OR      AL,[xl]                 ;DDB5 OR A,XL (undocumented)
	LAHF
	instend

instheader oraix,4
	calcind ix                      ;DDB6 OR A,(IX+d)
	gbytefr AH
	OR      AL,AH
	LAHF
	instend

instheader cmpxh,4
	CMP     AL,[xh]                 ;DDBC CP XH (undocumented)
	flagsetN1

instheader cmpxl,4
	CMP     AL,[xl]                 ;DDBD CP XL (undocumented)
	flagsetN1

instheader cmpix,4
	calcind ix                      ;DDBE CP (IX+d)
	gbytefr AH
	CMP     AL,AH
	flagsetN1

instheader rlcib,4
	POP     BP                      ;DDCB00 RLC (IX+d) > B
	gbyteBP sB
	ROL     sB,1
	LAHF
	addtoc  sB,sFree
	instend

instheader rlcic,4
	POP     BP                      ;DDCB01 RLC (IX+d) > C
	gbyteBP sC
	ROL     sC,1
	LAHF
	addtoc  sC,sFree
	instend

instheader rlcid,4
	POP     BP                      ;DDCB01 RLC (IX+d) > D
	gbyteBP sD
	ROL     sD,1
	LAHF
	addtoc  sD,sFree
	instend

instheader rlcie,4
	POP     BP                      ;DDCB03 RLC (IX+d) > E
	gbyteBP sE
	ROL     sE,1
	LAHF
	addtoc  sE,sFree
	instend

instheader rlcih,4
	POP     BP                      ;DDCB04 RLC (IX+d) > H
	gbyteBP sH
	ROL     sH,1
	LAHF
	addtoc  sH,sFree
	instend

instheader rlcil,4
	POP     BP                      ;DDCB05 RLC (IX+d) > L
	gbyteBP sL
	ROL     sL,1
	LAHF
	addtoc  sL,sFree
	instend

instheader rlcix,4
	POP     BP                      ;DDCB06 RLC (IX+d)
	PUSH    sBC
	gbyteBP sC
	ROL     sC,1
	LAHF
	addtoc  sC,sFree
	wbyte   sC
	POP     sBC
	instend

instheader rlcia,4
	POP     BP                      ;DDCB07 RLC (IX+d) > A
	gbyteBP AL
	ROL     AL,1
	LAHF
	addtoc  AL,sFree
	instend

instheader rrcib,4
	POP     BP                      ;DDCB08 RRC (IX+d) > B
	gbyteBP sB
	ROR     sB,1
	LAHF
	addtoc  sB,sFree
	instend

instheader rrcic,4
	POP     BP                      ;DDCB09 RRC (IX+d) > C
	gbyteBP sC
	ROR     sC,1
	LAHF
	addtoc  sC,sFree
	instend

instheader rrcid,4
	POP     BP                      ;DDCB0A RRC (IX+d) > D
	gbyteBP sD
	ROR     sD,1
	LAHF
	addtoc  sD,sFree
	instend

instheader rrcie,4
	POP     BP                      ;DDCB0B RRC (IX+d) > E
	gbyteBP sE
	ROR     sE,1
	LAHF
	addtoc  sE,sFree
	instend

instheader rrcih,4
	POP     BP                      ;DDCB0C RRC (IX+d) > H
	gbyteBP sH
	ROR     sH,1
	LAHF
	addtoc  sH,sFree
	instend

instheader rrcil,4
	POP     BP                      ;DDCB0D RRC (IX+d) > L
	gbyteBP sL
	ROR     sL,1
	LAHF
	addtoc  sL,sFree
	instend

instheader rrcix,4
	POP     BP                      ;DDCB0E RRC (IX+d)
	PUSH    sBC
	gbyteBP sC
	ROR     sC,1
	LAHF
	addtoc  sC,sFree
	wbyte   sC
	POP     sBC
	instend

instheader rrcia,4
	POP     BP                      ;DDCB0F RRC (IX+d) > A
	gbyteBP AL
	ROR     AL,1
	LAHF
	addtoc  AL,sFree
	instend

instheader rlib,4
	POP     BP                      ;DDCB10 RL (IX+d) > B
	gbyteBP sB
	RCL     sB,1
	LAHF
	addtoc  sB,sFree
	instend

instheader rlic,4
	POP     BP                      ;DDCB11 RL (IX+d) > C
	gbyteBP sC
	RCL     sC,1
	LAHF
	addtoc  sC,sFree
	instend

instheader rlid,4
	POP     BP                      ;DDCB12 RL (IX+d) > D
	gbyteBP sD
	RCL     sD,1
	LAHF
	addtoc  sD,sFree
	instend

instheader rlie,4
	POP     BP                      ;DDCB13 RL (IX+d) > E
	gbyteBP sE
	RCL     sE,1
	LAHF
	addtoc  sE,sFree
	instend

instheader rlih,4
	POP     BP                      ;DDCB14 RL (IX+d) > H
	gbyteBP sH
	RCL     sH,1
	LAHF
	addtoc  sH,sFree
	instend

instheader rlil,4
	POP     BP                      ;DDCB15 RL (IX+d) > L
	gbyteBP sL
	RCL     sL,1
	LAHF
	addtoc  sL,sFree
	instend

instheader rlix,4
	POP     BP                      ;DDCB16 RL (IX+d)
	PUSH    sBC
	gbyteBP sC
	SAHF
	RCL     sC,1
	LAHF
	addtoc  sC,sFree
	wbyte   sC
	POP     sBC
	instend

instheader rlia,4
	POP     BP                      ;DDCB17 RL (IX+d) > A
	gbyteBP AL
	RCL     AL,1
	LAHF
	addtoc  AL,sFree
	instend

instheader rrib,4
	POP     BP                      ;DDCB18 RR (IX+d) > B
	gbyteBP sB
	RCR     sB,1
	LAHF
	addtoc  sB,sFree
	instend

instheader rric,4
	POP     BP                      ;DDCB19 RR (IX+d) > C
	gbyteBP sC
	RCR     sC,1
	LAHF
	addtoc  sC,sFree
	instend

instheader rrid,4
	POP     BP                      ;DDCB1A RR (IX+d) > D
	gbyteBP sD
	RCR     sD,1
	LAHF
	addtoc  sD,sFree
	instend

instheader rrie,4
	POP     BP                      ;DDCB1B RR (IX+d) > E
	gbyteBP sE
	RCR     sE,1
	LAHF
	addtoc  sE,sFree
	instend

instheader rrih,4
	POP     BP                      ;DDCB1C RR (IX+d) > H
	gbyteBP sH
	RCR     sH,1
	LAHF
	addtoc  sH,sFree
	instend

instheader rril,4
	POP     BP                      ;DDCB1D RR (IX+d) > L
	gbyteBP sL
	RCR     sL,1
	LAHF
	addtoc  sL,sFree
	instend

instheader rrix,4
	POP     BP                      ;DDCB1E RR (IX+d)
	PUSH    sBC
	gbyteBP sC
	SAHF
	RCR     sC,1
	LAHF
	addtoc  sC,sFree
	wbyte   sC
	POP     sBC
	instend

instheader rria,4
	POP     BP                      ;DDCB1F RR (IX+d) > A
	gbyteBP AL
	RCR     AL,1
	LAHF
	addtoc  AL,sFree
	instend

instheader slaib,4
	POP     BP                      ;DDCB20 SLA (IX+d) > B
	gbyteBP sB
	SAL     sB,1
	LAHF
	instend

instheader slaic,4
	POP     BP                      ;DDCB21 SLA (IX+d) > C
	gbyteBP sC
	SAL     sC,1
	LAHF
	instend

instheader slaid,4
	POP     BP                      ;DDCB22 SLA (IX+d) > D
	gbyteBP sD
	SAL     sD,1
	LAHF
	instend

instheader slaie,4
	POP     BP                      ;DDCB23 SLA (IX+d) > E
	gbyteBP sE
	SAL     sE,1
	LAHF
	instend

instheader slaih,4
	POP     BP                      ;DDCB24 SLA (IX+d) > H
	gbyteBP sH
	SAL     sH,1
	LAHF
	instend

instheader slail,4
	POP     BP                      ;DDCB25 SLA (IX+d) > L
	gbyteBP sL
	SAL     sL,1
	LAHF
	instend

instheader slaix,4
	POP     BP                      ;DDCB26 SLA (IX+d)
	PUSH    sBC
	gbyteBP sC
	SAL     sC,1
	LAHF
	wbyte   sC
	POP     sBC
	AND     AH,0EDh        ;*clear N/H
	instend

instheader slaia,4
	POP     BP                      ;DDCB27 SLA (IX+d) > A
	gbyteBP AL
	SAL     AL,1
	LAHF
	instend

instheader sraib,4
	POP     BP                      ;DDCB28 SRA (IX+d) > B
	gbyteBP sB
	SAR     sB,1
	LAHF
	instend

instheader sraic,4
	POP     BP                      ;DDCB29 SRA (IX+d) > C
	gbyteBP sC
	SAR     sC,1
	LAHF
	instend

instheader sraid,4
	POP     BP                      ;DDCB2A SRA (IX+d) > D
	gbyteBP sD
	SAR     sD,1
	LAHF
	instend

instheader sraie,4
	POP     BP                      ;DDCB2B SRA (IX+d) > E
	gbyteBP sE
	SAR     sE,1
	LAHF
	instend

instheader sraih,4
	POP     BP                      ;DDCB2C SRA (IX+d) > H
	gbyteBP sH
	SAR     sH,1
	LAHF
	instend

instheader srail,4
	POP     BP                      ;DDCB2D SRA (IX+d) > L
	gbyteBP sL
	SAR     sL,1
	LAHF
	instend

instheader sraix,4
	POP     BP                      ;DDCB2E SRA (IX+d)
	PUSH    sBC
	gbyteBP sC
	SAR     sC,1
	LAHF
	wbyte   sC
	POP     sBC
	AND     AH,0EDh        ;*clear N/H
	instend

instheader sraia,4
	POP     BP                      ;DDCB2F SRA (IX+d) > A
	gbyteBP AL
	SAR     AL,1
	LAHF
	instend

instheader sllib,4
	POP     BP                      ;DDCB30 SLL (IX+d) > B
	gbyteBP sB
	SHL     sB,1
	LAHF
	OR      sB,1
	instend

instheader sllic,4
	POP     BP                      ;DDCB31 SLL (IX+d) > C
	gbyteBP sC
	SHL     sC,1
	LAHF
	OR      sC,1
	instend

instheader sllid,4
	POP     BP                      ;DDCB32 SLL (IX+d) > D
	gbyteBP sD
	SHL     sD,1
	LAHF
	OR      sD,1
	instend

instheader sllie,4
	POP     BP                      ;DDCB33 SLL (IX+d) > E
	gbyteBP sE
	SHL     sE,1
	LAHF
	OR      sE,1
	instend

instheader sllih,4
	POP     BP                      ;DDCB34 SLL (IX+d) > H
	gbyteBP sH
	SHL     sH,1
	LAHF
	OR      sH,1
	instend

instheader sllil,4
	POP     BP                      ;DDCB35 SLL (IX+d) > L
	gbyteBP sL
	SHL     sL,1
	LAHF
	OR      sL,1
	instend

instheader sllix,4
	POP     BP                      ;DDCB36 SLL (IX+d) (undocumented)
	PUSH    sBC
	gbyteBP sC
	SHL     sC,1
	LAHF
	OR      sC,1
	wbyte   sC
	POP     sBC
	AND     AH,0EDh        ;*clear N/H
	instend

instheader sllia,4
	POP     BP                      ;DDCB37 SLL (IX+d) > A
	gbyteBP AL
	SHL     AL,1
	LAHF
	OR      AL,1
	instend

instheader srlib,4
	POP     BP                      ;DDCB38 SRL (IX+d) > B
	gbyteBP sB
	SHR     sB,1
	LAHF
	instend

instheader srlic,4
	POP     BP                      ;DDCB39 SRL (IX+d) > C
	gbyteBP sC
	SHR     sC,1
	LAHF
	instend

instheader srlid,4
	POP     BP                      ;DDCB3A SRL (IX+d) > D
	gbyteBP sD
	SHR     sD,1
	LAHF
	instend

instheader srlie,4
	POP     BP                      ;DDCB3B SRL (IX+d) > E
	gbyteBP sE
	SHR     sE,1
	LAHF
	instend

instheader srlih,4
	POP     BP                      ;DDCB3C SRL (IX+d) > H
	gbyteBP sH
	SHR     sH,1
	LAHF
	instend

instheader srlil,4
	POP     BP                      ;DDCB3D SRL (IX+d) > L
	gbyteBP sL
	SHR     sL,1
	LAHF
	instend

instheader srlix,4
	POP     BP                      ;DDCB3E SRL (IX+d)
	PUSH    sBC
	gbyteBP sC
	SHR     sC,1
	LAHF
	wbyte   sC
	POP     sBC
	AND     AH,0EDh        ;*clear N/H
	instend

instheader srlia,4
	POP     BP                      ;DDCB3F SRL (IX+d) > A
	gbyteBP AL
	SHR     AL,1
	LAHF
	instend

instheader bit0ix,4
	POP     BP                      ;DDCB46 BIT 0,(IX+d)
	gwordBP BP
	BT      BP,0
	dozf

instheader bit1ix,4
	POP     BP                      ;DDCB4E BIT 1,(IX+d)
	gwordBP BP
	BT      BP,1
	dozf

instheader bit2ix,4
	POP     BP                      ;DDCB56 BIT 2,(IX+d)
	gwordBP BP
	BT      BP,2
	dozf

instheader bit3ix,4
	POP     BP                      ;DDCB5E BIT 3,(IX+d)
	gwordBP BP
	BT      BP,3
	dozf

instheader bit4ix,4
	POP     BP                      ;DDCB66 BIT 4,(IX+d)
	gwordBP BP
	BT      BP,4
	dozf

instheader bit5ix,4
	POP     BP                      ;DDCB6E BIT 5,(IX+d)
	gwordBP BP
	BT      BP,5
	dozf

instheader bit6ix,4
	POP     BP                      ;DDCB76 BIT 6,(IX+d)
	gwordBP BP
	BT      BP,6
	dozf

instheader bit7ix,4
	POP     BP                      ;DDCB7E BIT 7,(IX+d)
	gwordBP BP
	BT      BP,7
	dozmf

instheader res0ix,4
	POP     BP                      ;DDCB86 RES 0,(IX+d)
	PUSH    sBC
	gbyteBP sB
	AND     sB,0FEh
	wbyte   sB
	POP     sBC
	instend

instheader res1ix,4
	POP     BP                      ;DDCB8E RES 1,(IX+d)
	PUSH    sBC
	gbyteBP sB
	AND     sB,0FDh
	wbyte   sB
	POP     sBC
	instend

instheader res2ix,4
	POP     BP                      ;DDCB96 RES 2,(IX+d)
	PUSH    sBC
	gbyteBP sB
	AND     sB,0FBh
	wbyte   sB
	POP     sBC
	instend

instheader res3ix,4
	POP     BP                      ;DDCB9E RES 3,(IX+d)
	PUSH    sBC
	gbyteBP sB
	AND     sB,0F7h
	wbyte   sB
	POP     sBC
	instend

instheader res4ix,4
	POP     BP                      ;DDCBA6 RES 4,(IX+d)
	PUSH    sBC
	gbyteBP sB
	AND     sB,0EFh
	wbyte   sB
	POP     sBC
	instend

instheader res5ix,4
	POP     BP                      ;DDCBAE RES 5,(IX+d)
	PUSH    sBC
	gbyteBP sB
	AND     sB,0DFh
	wbyte   sB
	POP     sBC
	instend

instheader res6ix,4
	POP     BP                      ;DDCBB6 RES 6,(IX+d)
	PUSH    sBC
	gbyteBP sB
	AND     sB,0BFh
	wbyte   sB
	POP     sBC
	instend

instheader res7ix,4
	POP     BP                      ;DDCBBE RES 7,(IX+d)
	PUSH    sBC
	gbyteBP sB
	AND     sB,07Fh
	wbyte   sB
	POP     sBC
	instend

instheader set0ix,4
	POP     BP                      ;DDCBC6 SET 0,(IX+d)
	PUSH    sBC
	gbyteBP sB
	OR      sB,01h
	wbyte   sB
	POP     sBC
	instend

instheader set1ix,4
	POP     BP                      ;DDCBCE SET 1,(IX+d)
	PUSH    sBC
	gbyteBP sB
	OR      sB,02h
	wbyte   sB
	POP     sBC
	instend

instheader set2ix,4
	POP     BP                      ;DDCBD6 SET 2,(IX+d)
	PUSH    sBC
	gbyteBP sB
	OR      sB,04h
	wbyte   sB
	POP     sBC
	instend

instheader set3ix,4
	POP     BP                      ;DDCBDE SET 3,(IX+d)
	PUSH    sBC
	gbyteBP sB
	OR      sB,08h
	wbyte   sB
	POP     sBC
	instend

instheader set4ix,4
	POP     BP                      ;DDCBE6 SET 4,(IX+d)
	PUSH    sBC
	gbyteBP sB
	OR      sB,10h
	wbyte   sB
	POP     sBC
	instend

instheader set5ix,4
	POP     BP                      ;DDCBEE SET 5,(IX+d)
	PUSH    sBC
	gbyteBP sB
	OR      sB,20h
	wbyte   sB
	POP     sBC
	instend

instheader set6ix,4
	POP     BP                      ;DDCBF6 SET 6,(IX+d)
	PUSH    sBC
	gbyteBP sB
	OR      sB,40h
	wbyte   sB
	POP     sBC
	instend

instheader set7ix,4
	POP     BP                      ;DDCBFE SET 7,(IX+d)
	PUSH    sBC
	gbyteBP sB
	OR      sB,80h
	wbyte   sB
	POP     sBC
	instend

instheader popix,4
	MOV     BP,[simstack]           ;DDE1 POP IX
	gwordBP sFree
	MOV     [ix],sFree
	ADD     BP,2
	MOV     [simstack],BP
	instend

instheader xtix,4
	MOV     BP,[simstack]           ;DDE3 EX (SP),IX
	gwordBP sFree
	PUSH    sBC
	MOV     sBC,[ix]
	MOV     [ix],sFree
	wword   sBC
	POP     sBC
	instend

instheader pushix,4
	MOV     BP,[simstack]           ;DDE5 PUSH IX
	SUB     BP,2
	MOV     [simstack],BP
	PUSH    sBC
	MOV     sBC,[ix]
	wword   sBC
	POP     sBC
	instend

instheader pcix,4
	MOV     sPC,[ix]                ;DDE9 JP IX
	InitPCSeg
	instend

instheader spix,4
	MOV     BP,[ix]                 ;DDF9 LD SP,IX
	MOV     [simstack],BP
	instend

instheader inbc,4
	PUSH    AX                      ;ED40 IN B,(C)
	MOV     AH,sB
	CALL    inp
	MOV     sB,AL
	POP     AX
	OR      sB,sB
	MOV     BP,AX
	LAHF            ; flags setzen
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	instend

instheader outcb,4
	PUSH    AX                      ;ED41 OUT (C),B
	MOV     AH,sB
	MOV     AL,sB
	CALL    outp
	POP     AX
	instend

instheader dsbbb,4
	SAHF                            ;ED42 SBC HL,BC
	SBB     nSHL,sBC
	flagsetN1

instheader sbcd,4
	gwpc    BP                      ;ED43 LD (addr),BC
	wword   sBC
	instend

instheader nega,4
	NEG     AL                      ;ED44 NEG
	flagsetN1

instheader zretn,4
	ret80                           ;ED45 RETN (treated as RET)

instheader im0,4
	MOV     [imode],0               ;ED46 IM0
	instend

instheader moveia,4
	MOV     [BYTE PTR srI],AL       ;ED47 LD I,A
	instend

instheader incc,4
	PUSH    AX                      ;ED48 IN C,(C)
	MOV     AH,sB
	CALL    inp
	MOV     sC,AL
	POP     AX
	OR      sC,sC
	MOV     BP,AX
	LAHF            ; flags setzen
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	instend

instheader outcc,4
	PUSH    AX                      ;ED49 OUT (C),C
	MOV     AX,sBC
	CALL    outp
	POP     AX
	instend

instheader dadcb,4
	SAHF                            ;ED4A ADC HL,BC
	ADC     nSHL,sBC
	flagsetN0

instheader lbcd,4
	gwpc    BP                      ;ED4B LD BC,(addr)
	gwordBP sBC
	instend

instheader reti,4
	ret80                           ;ED4D RETI (treated as RET)

instheader movera,4
	MOV     [BYTE PTR sRF],AL       ;ED4F LD R,A
	MOV     [BYTE PTR sRFhi],AL
	instend

instheader indc,4
	PUSH    AX                      ;ED50 IN D,(C)
	MOV     AH,sB
	CALL    inp
	MOV     sD,AL
	POP     AX
	OR      sD,sD
	MOV     BP,AX
	LAHF            ; flags setzen
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	instend

instheader outcd,4
	PUSH    AX                      ;ED51 OUT (C),D
	MOV     AL,sD
	MOV     AH,sB
	CALL    outp
	POP     AX
	instend

instheader dsbbd,4
	SAHF                            ;ED52 SBC HL,DE
	SBB     nSHL,sDE
	flagsetN1

instheader sded,4
	gwpc    BP                      ;ED53 LD (addr),DE
	wword   sDE
	instend

instheader im1,4
	MOV     [imode],1               ;ED56 IM1
	instend

instheader moveai,4
	MOV     AL,[sIFF2]              ;ED57 LD A,I
	SHL     AL,2
	AND     AH,1
	OR      AH,AL
	MOV     AL,[BYTE PTR srI]
	PUSH    AX
	OR      AL,AL
	LAHF
	POP     BP
	AND     AX,0C000h
	OR      AX,BP
	instend

instheader inec,4
	PUSH    AX                      ;ED58 IN E,(C)
	MOV     AH,sB
	CALL    inp
	MOV     sE,AL
	POP     AX
	OR      sE,sE
	MOV     BP,AX
	LAHF            ; flags setzen
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	instend

instheader outce,4
	PUSH    AX                      ;ED59 OUT (C),E
	MOV     AL,sE
	MOV     AH,sB
	CALL    outp
	POP     AX
	instend

instheader dadcd,4
	SAHF                            ;ED5A ADC HL,DE
	ADC     nSHL,sDE
	flagsetN0

instheader lded,4
	gwpc    BP                      ;ED5B LD DE,(addr)
	gwordBP sDE
	instend

instheader im2,4
	MOV     [imode],2               ;ED5E IM2
	instend

instheader movear,4
	AND     [sRF],7fh               ;ED5F LD A,R
	AND     [sRFhi],80h
	MOV     AL,[sIFF2]
	SHL     AL,2
	AND     AH,1
	OR      AH,AL
	MOV     AL,[BYTE PTR sRF]
	OR      AL,[BYTE PTR sRFhi]
	PUSH    AX
	OR      AL,AL
	LAHF
	POP     BP
	AND     AX,0C000h
	OR      AX,BP
	instend

instheader inhc,4
	PUSH    AX                      ;ED60 IN H,(C)
	MOV     AH,sB
	CALL    inp
	MOV     sH,AL
	POP     AX
	OR      sH,sH
	MOV     BP,AX
	LAHF            ; flags setzen
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	instend

instheader outch,4
	PUSH    AX                      ;ED61 OUT (C),H
	MOV     AL,sH
	MOV     AH,sB
	CALL    outp
	POP     AX
	instend

instheader dsbbh,4
	SAHF                            ;ED62 SBC HL,HL
	SBB     nSHL,nSHL
	flagsetN1
;                                       ;ED63 LD (addr),HL

instheader rrd,4
	PUSH    sBC                     ;ED67 RRD *flags! *?*
	gbhl    sC
	PUSH    sDE
	PUSH    sBC
	MOV     sE,AL
	AND     sE,0Fh
	AND     sC,0F0h
	OR      sC,sE
	ROL     sC,4
	wbhl    sC
	POP     sBC
	POP     sDE
	AND     AL,0F0h
	AND     sC,0Fh
	OR      AL,sC
	POP     sBC
	MOV     BP,AX           ; set flags
	OR      AL,AL
	LAHF
	AND     AH,0C4h
	AND     BP,100h
	OR      AX,BP
	instend

instheader inlc,4
	PUSH    AX                      ;ED68 IN L,(C)
	MOV     AH,sB
	CALL    inp
	MOV     sL,AL
	POP     AX
	OR      sL,sL
	MOV     BP,AX
	LAHF            ; flags setzen
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	instend

instheader outcl,4
	PUSH    AX                      ;ED69 OUT (C),L
	MOV     AH,sB
	MOV     AL,sL
	CALL    outp
	POP     AX
	instend

instheader dadch,4
	SAHF                            ;ED6A ADC HL,HL
	ADC     nSHL,nSHL
	flagsetN0

;                                       ;ED6B LD HL,(addr)

instheader rld,4
	PUSH    sBC                     ;ED6F RLD *flags! *?*
	gbhl    sC
	PUSH    sDE
	PUSH    sBC
	SHL     sC,4
	MOV     sE,AL
	AND     sE,0fh
	OR      sC,sE
	wbhl    sC
	POP     sBC
	POP     sDE
	SHR     sC,4
	AND     AL,0f0h
	OR      AL,sC
	POP     sBC
	MOV     BP,AX           ; set flags
	OR      AL,AL
	LAHF
	AND     AH,0C4h
	AND     BP,100h
	OR      AX,BP
	instend

instheader inmc,4
	PUSH    AX                      ;ED70 IN (HL),(C)
	MOV     AH,sB
	CALL    inp
;       wbhl    AL
	OR      AL,AL
	MOV     BP,AX
	LAHF            ; flags setzen
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	POP     BP
	AND     BP,0FFh
	XOR     AL,AL
	OR      AX,BP
	instend

instheader outcm,4
	PUSH    AX                      ;ED71 OUT (C),(HL)
	gbhl    AL
	MOV     AH,sB
	CALL    outp
	POP     AX
	instend

instheader dsbbs,4
	SAHF                            ;ED72 SBC HL,SP
	SBB     nSHL,[simstack]
	flagsetN1

instheader sspd,4
	PUSH    sDE                     ;ED73 LD (addr),SP
	MOV     sDE,[simstack]
	gwpc    BP
	wword   sDE
	POP     sDE
	instend

instheader inac,4
	PUSH    AX                      ;ED78 IN A,(C)
	MOV     AH,sB
	CALL    inp
	MOV     BP,AX
	AND     BP,0ffh
	POP     AX
	XOR     AL,AL
	OR      AX,BP
	OR      AL,AL
	LAHF            ; flags setzen
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	instend

instheader outca,4
	PUSH    AX                      ;ED79 OUT (C),A
	MOV     AH,sB
	CALL    outp
	POP     AX
	instend

instheader dadcs,4
	SAHF                            ;ED7A ADC HL,SP
	ADC     nSHL,[simstack]
	flagsetN0

instheader lspd,4
	gwpc    BP                      ;ED7B LD SP,(addr)
	gwordBP BP
	MOV     [simstack],BP
	instend

instheader ldi,4
	PUSH    AX                      ;EDA0 LDI
	gbhl    AL
	wbytead EsDE,AL
	POP     AX
	INC     sDE
	INC     nSHL
	DEC     sBC
	JE      SHORT ldi1
	OR      AH,4
	AND     AH,0EDh
	instend
ldi1:   AND     AH,0E9h
	instend

instheader cmpi,4
	MOV     BP,AX
	AND     BP,100h
	PUSH    BP
	PUSH    sBC                     ;EDA1 CPI
	gbhl    sC
	CMP     AL,sC
	LAHF
	POP     sBC
	AND     AH,0f8h
	POP     BP
	OR      AX,BP
	INC     nSHL
	DEC     sBC
	JE      SHORT cmpi1
	OR      AH,6
	instend
cmpi1:  OR      AH,2
	instend

instheader ini,4
	PUSH    AX                      ;EDA2 INI
	MOV     AH,sB
	CALL    inp
	wbhl    AL
	OR      AL,AL
	MOV     BP,AX
	LAHF
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	POP     BP
	AND     BP,0FFh
	XOR     AL,AL
	OR      AX,BP
	DEC     sB
	INC     nsHL
	instend

instheader outi,4
	DEC     sB
	PUSH    AX                      ;EDA3 OUTI
	gbhl    AL
	MOV     AH,sB
	CALL    outp
	POP     AX
	INC     nsHL
	instend

instheader ldd,4
	PUSH    AX                      ;EDA8 LDD
	gbhl    AL
	MOV     BP,sDE
	wbyte   AL
	POP     AX
	DEC     nSHL
	DEC     sDE
	DEC     sBC
	JE      SHORT ldd1
	OR      AH,4
	AND     AH,0EDh
	instend
ldd1:   AND     AH,0E9h
	instend

instheader cpd,4
	MOV     BP,AX                   ;EDA9 CPD
	AND     BP,100h
	PUSH    BP
	PUSH    sBC
	gbhl    sC
	CMP     AL,sC
	LAHF
	POP     sBC
	AND     AH,0f8h
	POP     BP
	OR      AX,BP
	DEC     nSHL
	DEC     sBC
	JE      SHORT cpd1
	OR      AH,6
	instend
cpd1:   OR      AH,2
	instend

instheader ind,4
	PUSH    AX                      ;EDAA IND
	MOV     AH,sB
	CALL    inp
	wbhl    AL
	OR      AL,AL
	MOV     BP,AX
	LAHF
	AND     AH,0FEh
	AND     BP,100h
	OR      AX,BP
	POP     BP
	AND     BP,0FFh
	XOR     AL,AL
	OR      AX,BP
	DEC     sB
	DEC     nsHL
	instend

instheader outd,4
	DEC     sB
	PUSH    AX                      ;EDAB OUTD
	gbhl    AL
	MOV     AH,sB
	CALL    outp
	POP     AX
	DEC     nsHL
	instend

instheader ldir,4
	PUSH    AX                      ;EDB0 LDIR
ldir_loop:
	gbhl    AL
	wbytead EsDE,AL
	INC     nsHL
	INC     sDE
	DEC     sBC
	JZ      ldirend
	TEST    [intflag],0ffffh
	JNZ     ldir_spock
	gprevbpc
	CMP     sFree,0B0h
	JNE     ldir_whatsthisthen
	SUB     [clocks],6
	JS      ldir_underflow
	JMP     ldir_loop
ldir_underflow:
	DEC     sPC
	POP     AX
	MOV     sFree,0EDh
	JMP     sz80_underflow
ldir_whatsthisthen:
	DEC     sPC
	POP     AX
	JMP     preED
ldir_spock:
	POP     AX
	SUB     sPC,2
	JMP     SpecialOccasion
ldirend:
	INC     [clocks]
	POP     AX
	AND     AH,0C1h
	instend

instheader cpir,4
	JMP      okcpir
	PUSH    sDE
	gbhl    sE
	INC     nsHL
	DEC     sBC
	CMP     AL,sE
	JE      cpir_ok
	CMP     sBC,0
	JNE     cpir_notok
	POP     sDE
	AND     AH,1
	OR      AH,2
	instend
cpir_notok:
	POP     sDE
	SUB     sPC,2
	instend
cpir_ok:
	POP     sDE
	AND     AH,1
	OR      AH,42h
	CMP     sBC,0
	JE      sz80_instend
	OR      AH,4
	instend
okcpir:
	PUSH    sDE                      ;EDB1 CPIR *flags! *?*
cpirloop:
	gbhl    sE
	INC     nSHL
	DEC     sBC
	CMP     AL,sE
	JE      SHORT cpirfound
	CMP     sBC,0
	JNE     cpirloop
	POP     sDE
	AND     AH,1
	OR      AH,2
	instend
cpirfound:
	POP     sDE
	AND     AH,1
	OR      AH,42h
	CMP     sBC,0
	JE      sz80_instend
	OR      AH,4
	instend

instheader inir,4
	instend                         ;EDB2 INIR

instheader otir,4
	instend                         ;EDB3 OTIR

instheader lddr,4
	PUSH    AX                      ;EDB8 LDDR
	gbhl    AL
	wbytead EsDE,AL
	DEC     nsHL
	DEC     sDE
	DEC     sBC
	JZ      lddrend
	SUB     sPC,2
	POP     AX
	instend
lddrend:
	INC     [clocks]
	POP     AX
	AND     AH,0c1h
	instend

instheader cpdr,4
	PUSH    sDE
	gbhl    sE
	DEC     nsHL
	DEC     sBC
	CMP     AL,sE
	JE      cpdr_ok
	CMP     sBC,0
	JNE     cpdr_notok
	POP     sDE
	AND     AH,1
	OR      AH,2
	instend
cpdr_notok:
	POP     sDE
	SUB     sPC,2
	instend
cpdr_ok:
	POP     sDE
	AND     AH,1
	OR      AH,42h
	CMP     sBC,0
	JE      sz80_instend
	OR      AH,4
	instend

	PUSH    sDE                      ;EDB9 CPDR
cpdrloop:
	gbhl    sE
	DEC     nSHL
	DEC     sBC
	CMP     AL,sE
	JE      SHORT cpdrfound
	CMP     sBC,0
	JNE     cpdrloop
	POP     sDE
	AND     AH,1
	OR      AH,2
	instend
cpdrfound:
	POP     sDE
	AND     AH,1
	OR      AH,42h
	CMP     sBC,0
	JE      sz80_instend
	OR      AH,4
	instend

instheader indr,4
	instend                         ;EDBA INDR

instheader otdr,4
	instend                         ;EDBB OTDR

instheader spced,4
	instend

instheader dadiyb,4
	ADD     [iy],sBC                ;FD09 ADD IY,BC
	docyf

instheader dadiyd,4
	ADD     [iy],sDE                ;FD19 ADD IY,DE
	docyf

instheader lxiiy,4
	gwpc    BP                      ;FD21 LD IY,nnnn
	MOV     [iy],BP
	instend

instheader siyd,4
	PUSH    sDE                     ;FD22 LD (addr),IY
	gwpc    BP
	MOV     sDE,[iy]
	wword   sDE
	POP     sDE
	instend

instheader inxiy,4
	INC     [iy]                    ;FD23 INC IY
	instend

instheader inryh,4
	z80inc  [yh]                    ;FD24 INC YH (undocumented)

instheader dcryh,4
	z80dec  [yh]                    ;FD25 DEC YH (undocumented)

instheader mviyh,4
	PUSH    AX                      ;FD26 LD YH,nn (undocumented)
	gbytePC AL
	MOV     [yh],AL
	POP     AX
	instend

instheader dadiyy,4
	MOV     BP,[iy]                 ;FD29 ADD IY,IY
	ADD     [iy],BP
	docyf

instheader liyd,4
	gwpc    BP                      ;FD2A LD IY,(addr)
	gwordBP BP
	MOV     [iy],BP
	instend

instheader dcxiy,4
	DEC     [iy]                    ;FD2B DEC IY
	instend

instheader inryl,4
	z80inc  [yl]                    ;FD2C INC YL (undocumented)

instheader dcryl,4
	z80dec  [yl]                    ;FD2D DEC YL (undocumented)

instheader mviyl,4
	PUSH    AX                      ;FD2E LD YL,nn (undocumented)
	gbytePC AL
	MOV     [yl],AL
	POP     AX
	instend

instheader inriy,4
	calcind iy                      ;FD34 INC (IY+d)
	PUSH    sBC
	gbytefr sC
	z80inco sC
	wbytefr sC
	POP     sBC
	instend

instheader dcriy,4
	calcind iy                      ;FD35 DEC (IY+d)
	PUSH    sBC
	gbytefr sC
	z80deco sC
	wbytefr sC
	POP     sBC
	instend

instheader mviiy,4
	calcind iy                      ;FD36 LD (IY+d),nn
	PUSH    AX
	gbytePC AL
	wbytefr AL
	POP     AX
	instend

instheader dadiys,4
	MOV     BP,[simstack]           ;FD39 ADD IY,SP
	ADD     [iy],BP
	docyf

instheader movbyh,4
	MOV     sB,[yh]                 ;FD44 LD B,YH (undocumented)
	instend

instheader movbyl,4
	MOV     sB,[yl]                 ;FD45 LD B,YL (undocumented)
	instend

instheader movbiy,4
	calcind iy                      ;FD46 LD B,(IY+d)
	gbytefr sB
	instend

instheader movcyh,4
	MOV     sC,[yh]                 ;FD4C LD C,YH (undocumented)
	instend

instheader movcyl,4
	MOV     sC,[yl]                 ;FD4D LD C,YL (undocumented)
	instend

instheader movciy,4
	calcind iy                      ;FD4E LD C,(IY+d)
	gbytefr sC
	instend

instheader movdyh,4
	MOV     sD,[yh]                 ;FD54 LD D,YH (undocumented)
	instend

instheader movdyl,4
	MOV     sD,[yl]                 ;FD55 LD D,YL (undocumented)
	instend

instheader movdiy,4
	calcind iy                      ;FD56 LD D,(IY+d)
	gbytefr sD
	instend

instheader moveyh,4
	MOV     sE,[yh]                 ;FD5C LD E,YH (undocumented)
	instend

instheader moveyl,4
	MOV     sE,[yl]                 ;FD5D LD E,YL (undocumented)
	instend

instheader moveiy,4
	calcind iy                      ;FD5E LD E,(IY+d)
	gbytefr sE
	instend

instheader movyhb,4
	MOV     [yh],sB                 ;FD60 LD YH,B (undocumented)
	instend

instheader movyhc,4
	MOV     [yh],sC                 ;FD61 LD YH,C (undocumented)
	instend

instheader movyhd,4
	MOV     [yh],sD                 ;FD62 LD YH,D (undocumented)
	instend

instheader movyhe,4
	MOV     [yh],sE                 ;FD63 LD YH,E (undocumented)
	instend

instheader mvyhyh,4
	instend                         ;FD64 LD YH,YH (undocumented)

instheader mvyhyl,4
	PUSH    AX                      ;FD65 LD YH,YL (undocumented)
	MOV     AL,[yl]
	MOV     [yh],AL
	POP     AX
	instend

instheader movhiy,4
	calcind iy                      ;FD66 LD H,(IY+d)
	gbytefr sH
	instend

instheader movyha,4
	MOV     [yh],AL                 ;FD67 LD YH,A
	instend

instheader movylb,4
	MOV     [yl],sB                 ;FD68 LD YL,B (undocumented)
	instend

instheader movylc,4
	MOV     [yl],sC                 ;FD69 LD YL,C (undocumented)
	instend

instheader movyld,4
	MOV     [yl],sD                 ;FD6A LD YL,D (undocumented)
	instend

instheader movyle,4
	MOV     [yl],sE                 ;FD6B LD YL,E (undocumented)
	instend

instheader mvylyh,4
	PUSH    AX                      ;FD6C LD YL,YH (undocumented)
	MOV     AL,[yh]
	MOV     [yl],AL
	POP     AX
	instend

instheader mvylyl,4
	instend                         ;FD6D LD YL,YL (undocumented)

instheader movliy,4
	calcind iy                      ;FD6E LD L,(IY+d)
	gbytefr sL
	instend

instheader movyla,4
	MOV     [yl],AL                 ;FD6F LD YL,A
	instend

instheader moviyb,4
	calcind iy                      ;FD70 LD (IY+d),B
	wbytefr sB
	instend

instheader moviyc,4
	calcind iy                      ;FD71 LD (IY+d),C
	wbytefr sC
	instend

instheader moviyd,4
	calcind iy                      ;FD72 LD (IY+d),D
	wbytefr sD
	instend

instheader moviye,4
	calcind iy                      ;FD73 LD (IY+d),E
	wbytefr sE
	instend

instheader moviyh,4
	calcind iy                      ;FD74 LD (IY+d),H
	wbytefr sH
	instend

instheader moviyl,4
	calcind iy                      ;FD75 LD (IY+d),L
	wbytefr sL
	instend

instheader moviya,4
	calcind iy                      ;FD77 LD (IY+d),A
	wbytefr AL
	instend

instheader movayh,4
	MOV     AL,[yh]                 ;FD7C LD A,YH (undocumented)
	instend

instheader movayl,4
	MOV     AL,[yl]                 ;FD7D LD A,YL (undocumented)
	instend

instheader movaiy,4
	calcind iy                      ;FD7E LD A,(IY+d)
	gbytefr AL
	instend

instheader addyh,4
	ADD     AL,[yh]                 ;FD84 ADD A,YH (undocumented)
	flagsetN0

instheader addyl,4
	ADD     AL,[yl]                 ;FD85 ADD A,YL (undocumented)
	flagsetN0

instheader addiy,4
	calcind iy                      ;FD86 ADD A,(IY+d)
	gbytefr AH
	ADD     AL,AH
	flagsetN0

instheader adcyh,4
	SAHF                            ;FD8C ADC A,YH (undocumented)
	ADC     AL,[yh]
	flagsetN0

instheader adcyl,4
	SAHF                            ;FD8E ADC A,YL (undocumented)
	ADC     AL,[yl]
	flagsetN0

instheader adciy,4
	calcind iy                      ;FD8E ADC A,(IY+d)
	PUSH    sBC
	gbytefr sC
	SAHF
	ADC     AL,sC
	POP     sBC
	flagsetN0

instheader subyh,4
	SUB     AL,[yh]                 ;FD94 SUB A,YH (undocumented)
	flagsetN1

instheader subyl,4
	SUB     AL,[yl]                 ;FD95 SUB A,YL (undocumented)
	flagsetN1

instheader subiy,4
	calcind iy                      ;FD96 SUB A,(IY+d)
	gbytefr AH
	SUB     AL,AH
	flagsetN1

instheader sbbyh,4
	SAHF                            ;FD9C SBC A,YH (undocumented)
	SBB     AL,[yh]
	flagsetN1

instheader sbbyl,4
	SAHF                            ;FD9D SBC A,YL (undocumented)
	SBB     AL,[yl]
	flagsetN1

instheader sbbiy,4
	calcind iy                      ;FD9E SBC A,(IY+d)
	PUSH    sBC
	gbytefr sC
	SAHF
	SBB     AL,sC
	POP     sBC
	flagsetN1

instheader anayh,4
	AND     AL,[yh]                 ;FDA4 AND A,YH (undocumented)
	LAHF
	instend

instheader anayl,4
	AND     AL,[yl]                 ;FDA5 AND A,YL (undocumented)
	LAHF
	instend

instheader anaiy,4
	calcind iy                      ;FDA6 AND A,(IY+d)
	gbytefr AH
	AND     AL,AH
	LAHF
	instend

instheader xrayh,4
	XOR     AL,[yh]                 ;FDAC XOR A,YH (undocumented)
	LAHF
	instend

instheader xrayl,4
	XOR     AL,[yl]                 ;FDAD XOR A,YL (undocumented)
	LAHF
	instend

instheader xraiy,4
	calcind iy                      ;FDAE XOR A,(IY+d)
	gbytefr AH
	XOR     AL,AH
	LAHF
	instend

instheader orayh,4
	OR      AL,[yh]                 ;FDB4 OR A,YH (undocumented)
	LAHF
	instend

instheader orayl,4
	OR      AL,[yl]                 ;FDB5 OR A,YL (undocumented)
	LAHF
	instend

instheader oraiy,4
	calcind iy                      ;FDB6 OR A,(IY+d)
	gbytefr AH
	OR      AL,AH
	LAHF
	instend

instheader cmpyh,4
	CMP     AL,[yh]                 ;FDBC CP YH (undocumented)
	flagsetN1

instheader cmpyl,4
	CMP     AL,[yl]                 ;FDBD CP YL (undocumented)
	flagsetN1

instheader cmpiy,4
	calcind iy                      ;FDBE CP (IY+d)
	gbytefr AH
	CMP     AL,AH
	flagsetN1

;* FDCB-prefix instructions can use the DDCB-prefix routines

instheader popiy,4
	MOV     BP,[simstack]           ;FDE1 POP IY
	gwordBP sFree
	MOV     [iy],sFree
	ADD     BP,2
	MOV     [simstack],BP
	instend

instheader xtiy,4
	MOV     BP,[simstack]           ;FDE3 EX (SP),IY
	gwordBP sFree
	PUSH    sBC
	MOV     sBC,[iy]
	MOV     [iy],sFree
	wword   sBC
	POP     sBC
	instend

instheader pushiy,4
	MOV     BP,[simstack]           ;FDE5 PUSH IY
	SUB     BP,2
	MOV     [simstack],BP
	PUSH    sBC
	MOV     sBC,[iy]
	wword   sBC
	POP     sBC
	instend

instheader pciy,4
	MOV     sPC,[iy]                ;FDE9 JP IY
	InitPCSeg
	instend

instheader spiy,4
	MOV     BP,[iy]                 ;FDF9 LD SP,IY
	MOV     [simstack],BP
	instend

ENDS

;*************************************************************************
;*                                                                       *
;*       Opcode dispatch table                                           *
;*                                                                       *
;*************************************************************************

SEGMENT _data DWORD PUBLIC 'DATA'

opclogs DW    1,3,2,2,1,1,2,1,1,3,2,2,1,1,2,1
	DW    3,3,2,2,1,1,2,1,2,3,2,2,1,1,2,1
	DW    2,3,5,2,1,1,2,1,2,3,5,2,1,1,2,1
	DW    2,3,5,2,3,3,3,1,2,3,4,2,1,1,2,1 ; maybe 4 on 3A
	DW    1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1
	DW    1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1
	DW    1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1
	DW    2,2,2,2,2,2,1,2,1,1,1,1,1,1,2,1
	DW    1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1
	DW    1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1
	DW    1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1
	DW    1,1,1,1,1,1,2,1,1,1,1,1,1,1,2,1
	DW    2,3,3,3,3,4,2,3,2,1,3,2,3,3,2,3
	DW    2,3,3,3,3,4,2,3,2,1,3,3,3,2,2,3
	DW    2,3,3,6,3,4,2,3,2,1,3,1,3,2,2,3
	DW    2,3,3,1,3,4,2,3,2,2,3,1,3,2,2,3

edclogs DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW    2,2,2,4,0,0,0,1,2,2,2,4,0,0,0,1
	DW    2,2,2,4,0,0,0,1,2,2,2,4,0,0,0,1
	DW    2,2,2,4,0,0,0,0,2,2,2,4,0,0,0,0
	DW    2,2,2,4,0,0,0,0,2,2,2,4,0,0,0,0
	DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW    3,2,0,0,0,0,0,0,3,2,0,0,0,0,0,0
	DW    4,4,0,0,0,0,0,0,4,4,0,0,0,0,0,0
	DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

opcodes DW    r_nop00,r_lxib,r_staxb,r_inxb,r_inrb,r_dcrb,r_mvib,r_rlc
	DW    r_exaf,r_dadb,r_ldaxb,r_dcxb,r_inrc,r_dcrc,r_mvic,r_rrc
	DW    r_djnz,r_lxid,r_staxd,r_inxd,r_inrd,r_dcrd,r_mvid,r_ral
	DW    r_jr,r_dadd,r_ldaxd,r_dcxd,r_inre,r_dcre,r_mvie,r_rar
	DW    r_jrnz,r_lxih,r_shldz,r_inxh,r_inrh,r_dcrh,r_mvih,r_daaz
	DW    r_jrz,r_dadh,r_lhld,r_dcxh,r_inrl,r_dcrl,r_mvil,r_cma
	DW    r_jrnc,r_lxis,r_sta,r_inxs,r_inrm,r_dcrm,r_mvim,r_stcz
	DW    r_jrc,r_dads,r_lda,r_dcxs,r_inra,r_dcra,r_mvia,r_cmcz
	DW    r_movebb,r_movebc,r_movebd,r_movebe,r_movebh,r_movebl,r_movebm,r_moveba
	DW    r_movecb,r_movecc,r_movecd,r_movece,r_movech,r_movecl,r_movecm,r_moveca
	DW    r_movedb,r_movedc,r_movedd,r_movede,r_movedh,r_movedl,r_movedm,r_moveda
	DW    r_moveeb,r_moveec,r_moveed,r_moveee,r_moveeh,r_moveel,r_moveem,r_moveea
	DW    r_movehb,r_movehc,r_movehd,r_movehe,r_movehh,r_movehl,r_movehm,r_moveha
	DW    r_movelb,r_movelc,r_moveld,r_movele,r_movelh,r_movell,r_movelm,r_movela
	DW    r_movemb,r_movemc,r_movemd,r_moveme,r_movemh,r_moveml,r_halt,r_movema
	DW    r_moveab,r_moveac,r_movead,r_moveae,r_moveah,r_moveal,r_moveam,r_moveaa
	DW    r_addb,r_addc,r_addd,r_adde,r_addh,r_addl,r_addm,r_adda
	DW    r_adcb,r_adcc,r_adcd,r_adce,r_adch,r_adcl,r_adcm,r_adca
	DW    r_subb,r_subc,r_subd,r_sube,r_subh,r_subl,r_subm,r_suba
	DW    r_sbbb,r_sbbc,r_sbbd,r_sbbe,r_sbbh,r_sbbl,r_sbbm,r_sbba
	DW    r_andb,r_andc,r_andd,r_ande,r_andh,r_andl,r_andm,r_anda
	DW    r_xrab,r_xrac,r_xrad,r_xrae,r_xrah,r_xral,r_xram,r_xraa
	DW    r_orab,r_orac,r_orad,r_orae,r_orah,r_oral,r_oram,r_oraa
	DW    r_cmpb,r_cmpc,r_cmpd,r_cmpe,r_cmph,r_cmpl,r_cmpam,r_cmpaa
	DW    r_rnz,r_popb,r_jnzz,r_jmpa,r_cnz,r_pushb,r_adi,r_rst0
	DW    r_rz,r_retz,r_jzz,preCB,r_cz,r_callz,r_aci,r_rst1
	DW    r_rnc,r_popd,r_jncz,r_outz,r_cnc,r_pushd,r_sui,r_rst2
	DW    r_rc,r_exx,r_jcz,r_inz,r_cc,preDD,r_sbi,r_rst3
	DW    r_rpo,r_poph,r_jpoz,r_xthl,r_cpo,r_pushh,r_ani,r_rst4
	DW    r_rpe,r_pchl,r_jpez,r_xchgz,r_cpe,preED,r_xri,r_rst5
	DW    r_rp,r_popp,r_jpz,r_diz,r_cp,r_pushp,r_oria,r_rst6
	DW    r_rm,r_sphl,r_jmz,r_ei,r_cm,preFD,r_cpi,r_rst7

LABEL CBoptab WORD
	DW    r_rlcb,r_rlcc,r_rlcd,r_rlce,r_rlch,r_rlcl,r_rlcm,r_rlca                 ;CB00
	DW    r_rrcb,r_rrcc,r_rrcd,r_rrce,r_rrch,r_rrcl,r_rrcm,r_rrca                 ;CB08
	DW    r_rlrb,r_rlrc,r_rlrd,r_rlre,r_rlrh,r_rlrl,r_rlrm,r_rlra                 ;CB10
	DW    r_rrrb,r_rrrc,r_rrrd,r_rrre,r_rrrh,r_rrrl,r_rrrm,r_rrra                 ;CB18
	DW    r_slab,r_slac,r_slad,r_slae,r_slah,r_slal,r_slam,r_slaa                 ;CB20
	DW    r_srab,r_srac,r_srad,r_srae,r_srah,r_sral,r_sram,r_sraa                 ;CB28
	DW    r_sllb,r_sllc,r_slld,r_slle,r_sllh,r_slll,r_sllm,r_slla                 ;CB30
	DW    r_srlb,r_srlc,r_srld,r_srle,r_srlh,r_srll,r_srlm,r_srla                 ;CB38
	DW    r_bit0b,r_bit0c,r_bit0d,r_bit0e,r_bit0h,r_bit0l,r_bit0m,r_bit0a         ;CB40
	DW    r_bit1b,r_bit1c,r_bit1d,r_bit1e,r_bit1h,r_bit1l,r_bit1m,r_bit1a         ;CB48
	DW    r_bit2b,r_bit2c,r_bit2d,r_bit2e,r_bit2h,r_bit2l,r_bit2m,r_bit2a         ;CB50
	DW    r_bit3b,r_bit3c,r_bit3d,r_bit3e,r_bit3h,r_bit3l,r_bit3m,r_bit3a         ;CB58
	DW    r_bit4b,r_bit4c,r_bit4d,r_bit4e,r_bit4h,r_bit4l,r_bit4m,r_bit4a         ;CB60
	DW    r_bit5b,r_bit5c,r_bit5d,r_bit5e,r_bit5h,r_bit5l,r_bit5m,r_bit5a         ;CB68
	DW    r_bit6b,r_bit6c,r_bit6d,r_bit6e,r_bit6h,r_bit6l,r_bit6m,r_bit6a         ;CB70
	DW    r_bit7b,r_bit7c,r_bit7d,r_bit7e,r_bit7h,r_bit7l,r_bit7m,r_bit7a         ;CB78
	DW    r_res0b,r_res0c,r_res0d,r_res0e,r_res0h,r_res0l,r_res0m,r_res0a         ;CB80
	DW    r_res1b,r_res1c,r_res1d,r_res1e,r_res1h,r_res1l,r_res1m,r_res1a         ;CB88
	DW    r_res2b,r_res2c,r_res2d,r_res2e,r_res2h,r_res2l,r_res2m,r_res2a         ;CB90
	DW    r_res3b,r_res3c,r_res3d,r_res3e,r_res3h,r_res3l,r_res3m,r_res3a         ;CB98
	DW    r_res4b,r_res4c,r_res4d,r_res4e,r_res4h,r_res4l,r_res4m,r_res4a         ;CBA0
	DW    r_res5b,r_res5c,r_res5d,r_res5e,r_res5h,r_res5l,r_res5m,r_res5a         ;CBA8
	DW    r_res6b,r_res6c,r_res6d,r_res6e,r_res6h,r_res6l,r_res6m,r_res6a         ;CBB0
	DW    r_res7b,r_res7c,r_res7d,r_res7e,r_res7h,r_res7l,r_res7m,r_res7a         ;CBB8
	DW    r_set0b,r_set0c,r_set0d,r_set0e,r_set0h,r_set0l,r_set0m,r_set0a         ;CBC0
	DW    r_set1b,r_set1c,r_set1d,r_set1e,r_set1h,r_set1l,r_set1m,r_set1a         ;CBC8
	DW    r_set2b,r_set2c,r_set2d,r_set2e,r_set2h,r_set2l,r_set2m,r_set2a         ;CBD0
	DW    r_set3b,r_set3c,r_set3d,r_set3e,r_set3h,r_set3l,r_set3m,r_set3a         ;CBD8
	DW    r_set4b,r_set4c,r_set4d,r_set4e,r_set4h,r_set4l,r_set4m,r_set4a         ;CBE0
	DW    r_set5b,r_set5c,r_set5d,r_set5e,r_set5h,r_set5l,r_set5m,r_set5a         ;CBE8
	DW    r_set6b,r_set6c,r_set6d,r_set6e,r_set6h,r_set6l,r_set6m,r_set6a         ;CBF0
	DW    r_set7b,r_set7c,r_set7d,r_set7e,r_set7h,r_set7l,r_set7m,r_set7a         ;CBF8

LABEL DDoptab WORD
	DW    r_nop00,r_lxib,r_staxb,r_inxb,r_inrb,r_dcrb,r_mvih,r_rlc                ;DD00
	DW    r_exaf,r_dadixb,r_ldaxb,r_dcxb,r_inrc,r_dcrc,r_mvic,r_rrc               ;DD08
	DW    r_djnz,r_lxid,r_staxd,r_inxd,r_inrd,r_dcrd,r_mvid,r_ral                 ;DD10
	DW    r_jr,r_dadixd,r_ldaxd,r_dcxd,r_inre,r_dcre,r_mvie,r_rar                 ;DD18
	DW    r_jrnz,r_lxiix,r_sixd,r_inxix,r_inrxh,r_dcrxh,r_mvixh,r_daaz            ;DD20
	DW    r_jrz,r_dadixx,r_lixd,r_dcxix,r_inrxl,r_dcrxl,r_mvixl,r_cma             ;DD28
	DW    r_jrnc,r_lxis,r_sta,r_inxs,r_inrix,r_dcrix,r_mviix,r_stcz               ;DD30
	DW    r_jrc,r_dadixs,r_lda,r_dcxs,r_inra,r_dcra,r_mvia,r_cmcz                 ;DD38
	DW    r_movebb,r_movebc,r_movebd,r_movebe,r_movbxh,r_movbxl,r_movbix,r_moveba ;DD40
	DW    r_movecb,r_movecc,r_movecd,r_movece,r_movcxh,r_movcxl,r_movcix,r_moveca ;DD48
	DW    r_movedb,r_movedc,r_movedd,r_movede,r_movdxh,r_movdxl,r_movdix,r_moveda ;DD50
	DW    r_moveeb,r_moveec,r_moveed,r_moveee,r_movexh,r_movexl,r_moveix,r_moveea ;DD58
	DW    r_movxhb,r_movxhc,r_movxhd,r_movxhe,r_mvxhxh,r_mvxhxl,r_movhix,r_movxha ;DD60
	DW    r_movxlb,r_movxlc,r_movxld,r_movxle,r_mvxlxh,r_mvxlxl,r_movlix,r_movxla ;DD68
	DW    r_movixb,r_movixc,r_movixd,r_movixe,r_movixh,r_movixl,r_halt,r_movixa   ;DD70
	DW    r_moveab,r_moveac,r_movead,r_moveae,r_movaxh,r_movaxl,r_movaix,r_moveaa ;DD78
	DW    r_addb,r_addc,r_addd,r_adde,r_addxh,r_addxl,r_addix,r_adda              ;DD80
	DW    r_adcb,r_adcc,r_adcd,r_adce,r_adcxh,r_adcxl,r_adcix,r_adca              ;DD88
	DW    r_subb,r_subc,r_subd,r_sube,r_subxh,r_subxl,r_subix,r_suba              ;DD90
	DW    r_sbbb,r_sbbc,r_sbbd,r_sbbe,r_sbbxh,r_sbbxl,r_sbbix,r_sbba              ;DD98
	DW    r_andb,r_andc,r_andd,r_ande,r_anaxh,r_anaxl,r_anaix,r_anda              ;DDA0
	DW    r_xrab,r_xrac,r_xrad,r_xrae,r_xraxh,r_xraxl,r_xraix,r_xraa              ;DDA8
	DW    r_orab,r_orac,r_orad,r_orae,r_oraxh,r_oraxl,r_oraix,r_oraa              ;DDB0
	DW    r_cmpb,r_cmpc,r_cmpd,r_cmpe,r_cmpxh,r_cmpxl,r_cmpix,r_cmpaa             ;DDB8
	DW    r_rnz,r_popb,r_jnzz,r_jmpa,r_cnz,r_pushb,r_adi,r_rst0                   ;DDC0
	DW    r_rz,r_retz,r_jzz,prDDCB,r_cz,r_callz,r_aci,r_rst1                    ;DDC8
	DW    r_rnc,r_popd,r_jncz,r_outz,r_cnc,r_pushd,r_sui,r_rst2                   ;DDD0
	DW    r_rc,r_exx,r_jcz,r_inz,r_cc,preDD,r_sbi,r_rst3                        ;DDD8
	DW    r_rpo,r_popix,r_jpoz,r_xtix,r_cpo,r_pushix,r_ani,r_rst4                 ;DDE0
	DW    r_rpe,r_pcix,r_jpez,r_xchgz,r_cpe,preED,r_xri,r_rst5                  ;DDE8
	DW    r_rp,r_popp,r_jpz,r_diz,r_cp,r_pushp,r_oria,r_rst6                      ;DDF0
	DW    r_rm,r_spix,r_jmz,r_ei,r_cm,preFD,r_cpi,r_rst7                        ;DDF8

LABEL DDCBopt WORD
	DW    r_rlcib,r_rlcic,r_rlcid,r_rlcie,r_rlcih,r_rlcil,r_rlcix,r_rlcia         ;DDCB00
	DW    r_rrcib,r_rrcic,r_rrcid,r_rrcie,r_rrcih,r_rrcil,r_rrcix,r_rrcia         ;DDCB08
	DW    r_rlib,r_rlic,r_rlid,r_rlie,r_rlih,r_rlil,r_rlix,r_rlia                 ;DDCB10
	DW    r_rrib,r_rric,r_rrid,r_rrie,r_rrih,r_rril,r_rrix,r_rria                 ;DDCB18
	DW    r_slaib,r_slaic,r_slaid,r_slaie,r_slaih,r_slail,r_slaix,r_slaia         ;DDCB20
	DW    r_sraib,r_sraic,r_sraid,r_sraie,r_sraih,r_srail,r_sraix,r_sraia         ;DDCB28
	DW    r_sllib,r_sllic,r_sllid,r_sllie,r_sllih,r_sllil,r_sllix,r_sllia         ;DDCB30
	DW    r_srlib,r_srlic,r_srlid,r_srlie,r_srlih,r_srlil,r_srlix,r_srlia         ;DDCB38
	DW    r_bit0ix,r_bit0ix,r_bit0ix,r_bit0ix,r_bit0ix,r_bit0ix,r_bit0ix,r_bit0ix ;DDCB40
	DW    r_bit1ix,r_bit1ix,r_bit1ix,r_bit1ix,r_bit1ix,r_bit1ix,r_bit1ix,r_bit1ix ;DDCB48
	DW    r_bit2ix,r_bit2ix,r_bit2ix,r_bit2ix,r_bit2ix,r_bit2ix,r_bit2ix,r_bit2ix ;DDCB50
	DW    r_bit3ix,r_bit3ix,r_bit3ix,r_bit3ix,r_bit3ix,r_bit3ix,r_bit3ix,r_bit3ix ;DDCB58
	DW    r_bit4ix,r_bit4ix,r_bit4ix,r_bit4ix,r_bit4ix,r_bit4ix,r_bit4ix,r_bit4ix ;DDCB60
	DW    r_bit5ix,r_bit5ix,r_bit5ix,r_bit5ix,r_bit5ix,r_bit5ix,r_bit5ix,r_bit5ix ;DDCB68
	DW    r_bit6ix,r_bit6ix,r_bit6ix,r_bit6ix,r_bit6ix,r_bit6ix,r_bit6ix,r_bit6ix ;DDCB70
	DW    r_bit7ix,r_bit7ix,r_bit7ix,r_bit7ix,r_bit7ix,r_bit7ix,r_bit7ix,r_bit7ix ;DDCB78
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_res0ix,r_iDDCB        ;DDCB80
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_res1ix,r_iDDCB        ;DDCB88
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_res2ix,r_iDDCB        ;DDCB90
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_res3ix,r_iDDCB        ;DDCB98
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_res4ix,r_iDDCB        ;DDCBA0
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_res5ix,r_iDDCB        ;DDCBA8
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_res6ix,r_iDDCB        ;DDCBB0
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_res7ix,r_iDDCB        ;DDCBB8
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_set0ix,r_iDDCB        ;DDCBC0
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_set1ix,r_iDDCB        ;DDCBC8
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_set2ix,r_iDDCB        ;DDCBD0
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_set3ix,r_iDDCB        ;DDCBD8
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_set4ix,r_iDDCB        ;DDCBE0
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_set5ix,r_iDDCB        ;DDCBE8
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_set6ix,r_iDDCB        ;DDCBF0
	DW    r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_iDDCB,r_set7ix,r_iDDCB        ;DDCBF8

LABEL EDoptab WORD
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED00
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED08
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED10
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED18
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED20
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED28
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED30
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED38
	DW    r_inbc,r_outcb,r_dsbbb,r_sbcd,r_nega,r_zretn,r_im0,r_moveia             ;ED40
	DW    r_incc,r_outcc,r_dadcb,r_lbcd,r_nega,r_reti,r_illgED,r_movera           ;ED48
	DW    r_indc,r_outcd,r_dsbbd,r_sded,r_nega,r_illgED,r_im1,r_moveai            ;ED50
	DW    r_inec,r_outce,r_dadcd,r_lded,r_nega,r_illgED,r_im2,r_movear            ;ED58
	DW    r_inhc,r_outch,r_dsbbh,r_shldz,r_nega,r_illgED,r_illgED,r_rrd           ;ED60
	DW    r_inlc,r_outcl,r_dadch,r_lhld,r_nega,r_illgED,r_illgED,r_rld            ;ED68
	DW    r_inmc,r_outcm,r_dsbbs,r_sspd,r_nega,r_illgED,r_illgED,r_illgED         ;ED70
	DW    r_inac,r_outca,r_dadcs,r_lspd,r_nega,r_illgED,r_illgED,r_illgED         ;ED78
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED80
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED88
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED90
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;ED98
	DW    r_ldi,r_cmpi,r_ini,r_outi,r_illgED,r_illgED,r_illgED,r_illgED           ;EDA0
	DW    r_ldd,r_cpd,r_ind,r_outd,r_illgED,r_illgED,r_illgED,r_illgED            ;EDA8
	DW    r_ldir,r_cpir,r_inir,r_otir,r_illgED,r_illgED,r_illgED,r_illgED         ;EDB0
	DW    r_lddr,r_cpdr,r_indr,r_otdr,r_illgED,r_illgED,r_illgED,r_illgED         ;EDB8
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;EDC0
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;EDC8
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;EDD0
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;EDD8
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;EDE0
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;EDE8
	DW    r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED,r_illgED ;EDF0
	DW    r_illgED,r_illgED,r_illgED,CASInOpen,CASCheck,CASWrite,CASRead,r_spcED  ;EDF8

LABEL FDoptab WORD
	DW    r_nop00,r_lxib,r_staxb,r_inxb,r_inrb,r_dcrb,r_mvih,r_rlc                ;DD00
	DW    r_exaf,r_dadiyb,r_ldaxb,r_dcxb,r_inrc,r_dcrc,r_mvic,r_rrc               ;DD08
	DW    r_djnz,r_lxid,r_staxd,r_inxd,r_inrd,r_dcrd,r_mvid,r_ral                 ;DD10
	DW    r_jr,r_dadiyd,r_ldaxd,r_dcxd,r_inre,r_dcre,r_mvie,r_rar                 ;DD18
	DW    r_jrnz,r_lxiiy,r_siyd,r_inxiy,r_inryh,r_dcryh,r_mviyh,r_daaz            ;DD20
	DW    r_jrz,r_dadiyy,r_liyd,r_dcxiy,r_inryl,r_dcryl,r_mviyl,r_cma             ;DD28
	DW    r_jrnc,r_lxis,r_sta,r_inxs,r_inriy,r_dcriy,r_mviiy,r_stcz               ;DD30
	DW    r_jrc,r_dadiys,r_lda,r_dcxs,r_inra,r_dcra,r_mvia,r_cmcz                 ;DD38
	DW    r_movebb,r_movebc,r_movebd,r_movebe,r_movbyh,r_movbyl,r_movbiy,r_moveba ;DD40
	DW    r_movecb,r_movecc,r_movecd,r_movece,r_movcyh,r_movcyl,r_movciy,r_moveca ;DD48
	DW    r_movedb,r_movedc,r_movedd,r_movede,r_movdyh,r_movdyl,r_movdiy,r_moveda ;DD50
	DW    r_moveeb,r_moveec,r_moveed,r_moveee,r_moveyh,r_moveyl,r_moveiy,r_moveea ;DD58
	DW    r_movyhb,r_movyhc,r_movyhd,r_movyhe,r_mvyhyh,r_mvyhyl,r_movhiy,r_movyha ;DD60
	DW    r_movylb,r_movylc,r_movyld,r_movyle,r_mvylyh,r_mvylyl,r_movliy,r_movyla ;DD68
	DW    r_moviyb,r_moviyc,r_moviyd,r_moviye,r_moviyh,r_moviyl,r_halt,r_moviya   ;DD70
	DW    r_moveab,r_moveac,r_movead,r_moveae,r_movayh,r_movayl,r_movaiy,r_moveaa ;DD78
	DW    r_addb,r_addc,r_addd,r_adde,r_addyh,r_addyl,r_addiy,r_adda              ;DD80
	DW    r_adcb,r_adcc,r_adcd,r_adce,r_adcyh,r_adcyl,r_adciy,r_adca              ;DD88
	DW    r_subb,r_subc,r_subd,r_sube,r_subyh,r_subyl,r_subiy,r_suba              ;DD90
	DW    r_sbbb,r_sbbc,r_sbbd,r_sbbe,r_sbbyh,r_sbbyl,r_sbbiy,r_sbba              ;DD98
	DW    r_andb,r_andc,r_andd,r_ande,r_anayh,r_anayl,r_anaiy,r_anda              ;DDA0
	DW    r_xrab,r_xrac,r_xrad,r_xrae,r_xrayh,r_xrayl,r_xraiy,r_xraa              ;DDA8
	DW    r_orab,r_orac,r_orad,r_orae,r_orayh,r_orayl,r_oraiy,r_oraa              ;DDB0
	DW    r_cmpb,r_cmpc,r_cmpd,r_cmpe,r_cmpyh,r_cmpyl,r_cmpiy,r_cmpaa             ;DDB8
	DW    r_rnz,r_popb,r_jnzz,r_jmpa,r_cnz,r_pushb,r_adi,r_rst0                   ;DDC0
	DW    r_rz,r_retz,r_jzz,prFDCB,r_cz,r_callz,r_aci,r_rst1                      ;DDC8
	DW    r_rnc,r_popd,r_jncz,r_outz,r_cnc,r_pushd,r_sui,r_rst2                   ;DDD0
	DW    r_rc,r_exx,r_jcz,r_inz,r_cc,preDD,r_sbi,r_rst3                          ;DDD8
	DW    r_rpo,r_popiy,r_jpoz,r_xtiy,r_cpo,r_pushiy,r_ani,r_rst4                 ;DDE0
	DW    r_rpe,r_pciy,r_jpez,r_xchgz,r_cpe,preED,r_xri,r_rst5                    ;DDE8
	DW    r_rp,r_popp,r_jpz,r_diz,r_cp,r_pushp,r_oria,r_rst6                      ;DDF0
	DW    r_rm,r_spiy,r_jmz,r_ei,r_cm,preFD,r_cpi,r_rst7                          ;DDF8

sAFx    dw      1
sBCx    dw      1
sDEx    dw      1
sHLx    dw      1
sRF     dw      1
srFhi   dw      0
srI     dw      0

imode   dw      0

LABEL ix WORD
xl      db      ?
xh      db      ?

LABEL iy WORD
yl      db      ?
yh      db      ?

sIFF1   db      0
sIFF2   db      0

simstack dw     ?

intflag dw      0
haltactive dw   0

maxints    dw   0       ; kludge value

linescount dw   0
scrline    dw   0       ; only for full screen VESA mode

clocks     dw   0
count52    dw   0
missed     dw   0
hadffly    dw   0
scrptr     dw   0
cpcptr     dw   0
cpclinbase dw   0
rasterline dw   0
charline   dw   0
inborder   dw   0

drawing    dw   0
drawstop   dw   0

hscroll    dw   0
vscroll    dw   0
skiplines  dw   0
pageinc    dw   0

synccount  dw   0

crtcvsync   dw  0
crtcmaxslin dw  0
crtcvtadj   dw  0
drawwidth   dw  0

;intadj      dw  0

ENDS
SEGMENT _stack PARA STACK 'STACK'
ENDS

END

