' VB Script to view ACE on File System and Active Directory objects           '
'                                                                             '
' Version 1.00 - Alain Lissoir                                                '
' Compaq Computer Corporation - Professional Services - Belgium -             '
'                                                                             '
' Any comments or questions:                   EMail:alain.lissoir@compaq.com '

Option Explicit

' -----------------------------------------------------------------------------------------------------------------
Public Sub ViewRights (strObject, strObjectType)

        Dim objSecurity
        Dim objADObject
        Dim objSD

        Select Case strObjectType
               Case FS_OBJECT
                    Set objSecurity = CreateObject("ADsSecurity")
                    Set objSD = objSecurity.GetSecurityDescriptor("FILE://" & strObject)
                    WScript.DisconnectObject objSecurity
                    Set objSecurity = Nothing
               Case AD_OBJECT
                    Set objADObject = GetObject("LDAP://" & strObject)
                    Set objSD = objADObject.Get("ntSecurityDescriptor")
                    WScript.DisconnectObject objADObject
                    Set objADObject = Nothing
               Case Else
                    Exit Sub
        End Select

        WScript.Echo "Deciphering Security Descriptor " & _
                     "'ntSecurityDescriptor'" & vbCRLF & _
                     "of Object '" & strObject & "'" & vbCRLF
        Call Decipher_SD (strObjectType, objSD)

        ' Complete, deallocate object bindings
        Set objSD = Nothing

End Sub

' -----------------------------------------------------------------------------------------------------------------
Private Sub Decipher_SD (strObjectType, objSD)

        Dim objDACL

        ' ---------------------------------------------------------------------------------------------------------
        ' Security Descriptor
        WScript.Echo "Security Descriptor Owner: '" & objSD.Owner & "'"
        WScript.Echo "Security Descriptor Group: '" & objSD.Group & "'"
        WScript.Echo "Security Descriptor Revision: '" & objSD.Revision & "'"

        '---- SECURITY_DESCRIPTOR_CONTROL ----
        WScript.Echo "Security Descriptor Control: '0x" & Hex(objSD.Control) & "'"

        If (objSD.Control And SE_OWNER_DEFAULTED) Then
           WScript.Echo "-SE_OWNER_DEFAULTED"
        End If
        If (objSD.Control And SE_GROUP_DEFAULTED) Then
           WScript.Echo "-SE_GROUP_DEFAULTED"
        End If
        If (objSD.Control And SE_DACL_PRESENT) Then
           WScript.Echo "-SE_DACL_PRESENT"
        End If
        If (objSD.Control And SE_DACL_DEFAULTED) Then
           WScript.Echo "-SE_DACL_DEFAULTED"
        End If
        If (objSD.Control And SE_SACL_PRESENT) Then
           WScript.Echo "-SE_SACL_PRESENT"
        End If
        If (objSD.Control And SE_SACL_DEFAULTED) Then
           WScript.Echo "-SE_SACL_DEFAULTED"
        End If
        If (objSD.Control And SE_DACL_AUTO_INHERIT_REQ) Then
           WScript.Echo "-SE_DACL_AUTO_INHERIT_REQ"
        End If
        If (objSD.Control And SE_SACL_AUTO_INHERIT_REQ) Then
           WScript.Echo "-SE_SACL_AUTO_INHERIT_REQ"
        End If
        If (objSD.Control And SE_DACL_AUTO_INHERITED) Then
           WScript.Echo "-SE_DACL_AUTO_INHERITED"
        End If
        If (objSD.Control And SE_SACL_AUTO_INHERITED) Then
           WScript.Echo "-SE_SACL_AUTO_INHERITED"
        End If
        If (objSD.Control And SE_DACL_PROTECTED) Then
           WScript.Echo "-SE_DACL_PROTECTED"
        End If
        If (objSD.Control And SE_SACL_PROTECTED) Then
           WScript.Echo "-SE_SACL_PROTECTED"
        End If
        If (objSD.Control And SE_SELF_RELATIVE) Then
           WScript.Echo "-SE_SELF_RELATIVE"
        End If

        WScript.Echo "Security Descriptor OwnerDefaulted: '" & objSD.OwnerDefaulted & "'"
        WScript.Echo "Security Descriptor GroupDefaulted: '" & objSD.GroupDefaulted & "'"
        WScript.Echo "Security Descriptor DaclDefaulted: '" & objSD.DaclDefaulted & "'"
        WScript.Echo "Security Descriptor SaclDefaulted: '" & objSD.SaclDefaulted & "'" & vbCRLF

        ' ---------------------------------------------------------------------------------------------------------
        ' Discretionary ACL
        Set objDACL = objSD.DiscretionaryAcl

        Select Case strObjectType
               Case FS_OBJECT
                    Call DecipherFS_ACE (objDACL)
               Case AD_OBJECT
                    Call DecipherAD_ACE (objDACL)
        End Select

        ' Show the number of trustees present in DACL
        WScript.Echo "ACL Revision: " & objDACL.ACLRevision
        WScript.Echo "ACE Count: " & objDACL.AceCount
        WScript.Echo

        ' Complete, deallocate object bindings
        Set objDACL = Nothing

End Sub

' -----------------------------------------------------------------------------------------------------------------
Private Sub DecipherAD_ACE (objDACL)

        Dim objACE

        For Each objACE In objDACL
            WScript.Echo "Trustee: '" & objACE.Trustee & "'"
            WScript.Echo " ACE Type: '" & objACE.AceType & "'"

            '---- ADS_ACETYPE_ENUM -----
            Select Case objACE.AceType
                   Case ADS_ACETYPE_ACCESS_ALLOWED
                        WScript.Echo " -ADS_ACETYPE_ACCESS_ALLOWED"
                   Case ADS_ACETYPE_ACCESS_DENIED
                        WScript.Echo " -ADS_ACETYPE_ACCESS_DENIED"
                   Case ADS_ACETYPE_SYSTEM_AUDIT
                        WScript.Echo " -ADS_ACETYPE_SYSTEM_AUDIT"
                   Case ADS_ACETYPE_ACCESS_ALLOWED_OBJECT
                        WScript.Echo " -ADS_ACETYPE_ACCESS_ALLOWED_OBJECT"
                   Case ADS_ACETYPE_ACCESS_DENIED_OBJECT
                        WScript.Echo " -ADS_ACETYPE_ACCESS_DENIED_OBJECT"
                   Case ADS_ACETYPE_SYSTEM_AUDIT_OBJECT
                        WScript.Echo " -ADS_ACETYPE_SYSTEM_AUDIT_OBJECT"
                   Case Else

            End Select

            '--- ADS_RIGHTS_ENUM ------
            WScript.Echo " Access Mask: '0x" & Hex(objACE.AccessMask) & "'"

            If (objACE.AccessMask = ADS_RIGHT_GENERIC_READ) Then
               WScript.Echo " -ADS_RIGHT_GENERIC_READ"
            End If
            If (objACE.AccessMask = ADS_RIGHT_GENERIC_WRITE) Then
               WScript.Echo " -ADS_RIGHT_GENERIC_WRITE"
            End If
            If (objACE.AccessMask = ADS_RIGHT_GENERIC_EXECUTE) Then
               WScript.Echo " -ADS_RIGHT_GENERIC_EXECUTE"
            End If
            If (objACE.AccessMask = ADS_RIGHT_GENERIC_ALL) Then
               WScript.Echo " -ADS_RIGHT_GENERIC_ALL"
            End If

            If (objACE.AccessMask And ADS_RIGHT_DELETE) Then
               WScript.Echo " -ADS_RIGHT_DELETE"
            End If
            If (objACE.AccessMask And ADS_RIGHT_READ_CONTROL) Then
               WScript.Echo " -ADS_RIGHT_READ_CONTROL"
            End If
            If (objACE.AccessMask And ADS_RIGHT_WRITE_DAC) Then
               WScript.Echo " -ADS_RIGHT_WRITE_DAC"
            End If
            If (objACE.AccessMask And ADS_RIGHT_WRITE_OWNER) Then
               WScript.Echo " -ADS_RIGHT_WRITE_OWNER"
            End If
            If (objACE.AccessMask And ADS_RIGHT_SYNCHRONIZE) Then
               WScript.Echo " -ADS_RIGHT_SYNCHRONIZE"
            End If
            If (objACE.AccessMask And ADS_RIGHT_ACCESS_SYSTEM_SECURITY) Then
               WScript.Echo " -ADS_RIGHT_ACCESS_SYSTEM_SECURITY"
            End If
            If (objACE.AccessMask And ADS_RIGHT_GENERIC_READ) Then
               WScript.Echo " -ADS_RIGHT_GENERIC_READ"
            End If
            If (objACE.AccessMask And ADS_RIGHT_GENERIC_WRITE) Then
               WScript.Echo " -ADS_RIGHT_GENERIC_WRITE"
            End If
            If (objACE.AccessMask And ADS_RIGHT_GENERIC_EXECUTE) Then
               WScript.Echo " -ADS_RIGHT_GENERIC_EXECUTE"
            End If
            If (objACE.AccessMask And ADS_RIGHT_GENERIC_ALL) Then
               WScript.Echo " -ADS_RIGHT_GENERIC_ALL"
            End If
            If (objACE.AccessMask And ADS_RIGHT_DS_CREATE_CHILD) Then
               WScript.Echo " -ADS_RIGHT_DS_CREATE_CHILD"
            End If
            If (objACE.AccessMask And ADS_RIGHT_DS_DELETE_CHILD) Then
               WScript.Echo " -ADS_RIGHT_DS_DELETE_CHILD"
            End If
            If (objACE.AccessMask And ADS_RIGHT_ACTRL_DS_LIST) Then
               WScript.Echo " -ADS_RIGHT_ACTRL_DS_LIST"
            End If
            If (objACE.AccessMask And ADS_RIGHT_DS_SELF) Then
               WScript.Echo " -ADS_RIGHT_DS_SELF"
            End If
            If (objACE.AccessMask And ADS_RIGHT_DS_READ_PROP) Then
               WScript.Echo " -ADS_RIGHT_DS_READ_PROP"
            End If
            If (objACE.AccessMask And ADS_RIGHT_DS_WRITE_PROP) Then
               WScript.Echo " -ADS_RIGHT_DS_WRITE_PROP"
            End If
            If (objACE.AccessMask And ADS_RIGHT_DS_DELETE_TREE) Then
               WScript.Echo " -ADS_RIGHT_DS_DELETE_TREE"
            End If
            If (objACE.AccessMask And ADS_RIGHT_DS_LIST_OBJECT) Then
               WScript.Echo " -ADS_RIGHT_DS_LIST_OBJECT"
            End If
            If (objACE.AccessMask And ADS_RIGHT_DS_CONTROL_ACCESS) Then
               WScript.Echo " -ADS_RIGHT_DS_CONTROL_ACCESS"
            End If

            '--- ACE FLAGS ------
            WScript.Echo " ACE Flags: '" & objACE.AceFlags & "'"

            If (objACE.AceFlags And OBJECT_INHERIT_ACE) Then
               WScript.Echo " -OBJECT_INHERIT_ACE"
            End If
            If (objACE.AceFlags And CONTAINER_INHERIT_ACE) Then
               WScript.Echo " -CONTAINER_INHERIT_ACE"
            End If
            If (objACE.AceFlags And NO_PROPAGATE_INHERIT_ACE) Then
               WScript.Echo " -NO_PROPAGATE_INHERIT_ACE"
            End If
            If (objACE.AceFlags And INHERIT_ONLY_ACE) Then
               WScript.Echo " -INHERIT_ONLY_ACE"
            End If
            If (objACE.AceFlags And INHERITED_ACE) Then
               WScript.Echo " -INHERITED_ACE"
            End If
            If (objACE.AceFlags = VALID_INHERIT_FLAGS) Then
               WScript.Echo " -VALID_INHERIT_FLAGS"
            End If
            If (objACE.AceFlags And SUCCESSFUL_ACCESS_ACE_FLAG) Then
               WScript.Echo " -SUCCESSFUL_ACCESS_ACE_FLAG"
            End If
            If (objACE.AceFlags And FAILED_ACCESS_ACE_FLAG) Then
               WScript.Echo " -FAILED_ACCESS_ACE_FLAG"
            End If

            '--- ADS_FLAGTYPE_ENUM ------
            WScript.Echo " Flag Type: '" & objACE.Flags & "'"

            If (objACE.Flags And ADS_FLAG_OBJECT_TYPE_PRESENT) Then
               WScript.Echo " -ADS_FLAG_OBJECT_TYPE_PRESENT"
            End If
            If (objACE.Flags And ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT) Then
               WScript.Echo " -ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT"
            End If

            WScript.Echo " Object Type: '" & objACE.ObjectType & "'"
            WScript.Echo " Object Inherited Type: '" & objACE.InheritedObjectType & "'" & vbCRLF
        Next

End Sub

' -----------------------------------------------------------------------------------------------------------------
Private Sub DecipherFS_ACE (objDACL)

        Dim objACE

        For Each objACE In objDACL
            WScript.Echo "Trustee: '" & objACE.Trustee & "'"
            WScript.Echo " ACE Type: '" & objACE.AceType & "'"

            '---- FILE_ACETYPE_ENUM -----
            Select Case objACE.AceType
                   Case ACCESS_ALLOWED_ACE_TYPE
                        WScript.Echo " -ACCESS_ALLOWED_ACE_TYPE"
                   Case ACCESS_DENIED_ACE_TYPE
                        WScript.Echo " -ACCESS_DENIED_ACE_TYPE"
                   Case SYSTEM_AUDIT_ACE_TYPE
                        WScript.Echo " -SYSTEM_AUDIT_ACE_TYPE"
                   Case SYSTEM_ALARM_ACE_TYPE
                        WScript.Echo " -SYSTEM_ALARM_ACE_TYPE"
                   Case Else

            End Select

            '--- FILE_RIGHTS_ENUM ------
            WScript.Echo " Access Mask: '0x" & Hex(objACE.AccessMask) & "'"

            If (objACE.AccessMask = FILE_ALL_ACCESS) Then
               WScript.Echo " -FILE_ALL_ACCESS"
            End If
            If (objACE.AccessMask = FILE_GENERIC_EXECUTE) Then
               WScript.Echo " -FILE_GENERIC_EXECUTE"
            End If
            If (objACE.AccessMask = FILE_GENERIC_READ) Then
               WScript.Echo " -FILE_GENERIC_READ"
            End If
            If (objACE.AccessMask = FILE_GENERIC_WRITE) Then
               WScript.Echo " -FILE_GENERIC_WRITE"
            End If
            If (objACE.AccessMask And FILE_READ_DATA) Then
               WScript.Echo " -FILE_READ_DATA"
            End If

            If (objACE.AccessMask And FILE_LIST_DIRECTORY) Then
               WScript.Echo " -FILE_LIST_DIRECTORY"
            End If
            If (objACE.AccessMask And FILE_WRITE_DATA) Then
               WScript.Echo " -FILE_WRITE_DATA"
            End If
            If (objACE.AccessMask And FILE_ADD_FILE) Then
               WScript.Echo " -FILE_ADD_FILE"
            End If
            If (objACE.AccessMask And FILE_APPEND_DATA) Then
               WScript.Echo " -FILE_APPEND_DATA"
            End If
            If (objACE.AccessMask And FILE_ADD_SUBDIRECTORY) Then
               WScript.Echo " -FILE_ADD_SUBDIRECTORY"
            End If
            If (objACE.AccessMask And FILE_READ_EA) Then
               WScript.Echo " -FILE_READ_EA"
            End If
            If (objACE.AccessMask And FILE_WRITE_EA) Then
               WScript.Echo " -FILE_WRITE_EA"
            End If
            If (objACE.AccessMask And FILE_EXECUTE) Then
               WScript.Echo " -FILE_EXECUTE"
            End If
            If (objACE.AccessMask And FILE_TRAVERSE) Then
               WScript.Echo " -FILE_TRAVERSE"
            End If
            If (objACE.AccessMask And FILE_DELETE_CHILD) Then
               WScript.Echo " -FILE_DELETE_CHILD"
            End If
            If (objACE.AccessMask And FILE_READ_ATTRIBUTES) Then
               WScript.Echo " -FILE_READ_ATTRIBUTES"
            End If
            If (objACE.AccessMask And FILE_WRITE_ATTRIBUTES) Then
               WScript.Echo " -FILE_WRITE_ATTRIBUTES"
            End If
            If (objACE.AccessMask And FILE_DELETE) Then
               WScript.Echo " -FILE_DELETE"
            End If
            If (objACE.AccessMask And FILE_READ_CONTROL) Then
               WScript.Echo " -FILE_READ_CONTROL"
            End If
            If (objACE.AccessMask And FILE_WRITE_DAC) Then
               WScript.Echo " -FILE_WRITE_DAC"
            End If
            If (objACE.AccessMask And FILE_WRITE_OWNER) Then
               WScript.Echo " -FILE_WRITE_OWNER"
            End If
            If (objACE.AccessMask And FILE_SYNCHRONIZE) Then
               WScript.Echo " -FILE_SYNCHRONIZE"
            End If

            '--- ACE FLAGS ------
            WScript.Echo " ACE Flags: '" & objACE.AceFlags & "'"

            If (objACE.AceFlags And OBJECT_INHERIT_ACE) Then
               WScript.Echo " -OBJECT_INHERIT_ACE"
            End If
            If (objACE.AceFlags And CONTAINER_INHERIT_ACE) Then
               WScript.Echo " -CONTAINER_INHERIT_ACE"
            End If
            If (objACE.AceFlags And NO_PROPAGATE_INHERIT_ACE) Then
               WScript.Echo " -NO_PROPAGATE_INHERIT_ACE"
            End If
            If (objACE.AceFlags And INHERIT_ONLY_ACE) Then
               WScript.Echo " -INHERIT_ONLY_ACE"
            End If
            If (objACE.AceFlags And INHERITED_ACE) Then
               WScript.Echo " -INHERITED_ACE"
            End If
            If (objACE.AceFlags = VALID_INHERIT_FLAGS) Then
               WScript.Echo " -VALID_INHERIT_FLAGS"
            End If
            If (objACE.AceFlags And SUCCESSFUL_ACCESS_ACE_FLAG) Then
               WScript.Echo " -SUCCESSFUL_ACCESS_ACE_FLAG"
            End If
            If (objACE.AceFlags And FAILED_ACCESS_ACE_FLAG) Then
               WScript.Echo " -FAILED_ACCESS_ACE_FLAG"
            End If

            '--- ADS_FLAGTYPE_ENUM ------
            WScript.Echo " Flag Type: '" & objACE.Flags & "'"
            WScript.Echo " Object Type: '" & objACE.ObjectType & "'"
            WScript.Echo " Object Inherited Type: '" & objACE.InheritedObjectType & "'" & vbCRLF
        Next

End Sub