' VB Script defining all constants used in miscellaneous functions '
'                                                                  '
' Version 1.00 - Alain Lissoir                                     '
' Compaq Computer Corporation - Professional Services - Belgium -  '
'                                                                  '
' Any comments or questions:        EMail:alain.lissoir@compaq.com '

' **************************************************************** '
'                                                                  '
' BE SURE TO CHECK THE Iads.h include file in the Windows 2000 SDK '
'                                                                  '
' **************************************************************** '

' -------------------------------------------------------------------------------------------------
' Available options for the IADsObjectOptions interface
Const ADS_OPTION_SERVERNAME     		= 0
Const ADS_OPTION_REFERRALS      		= 1
Const ADS_OPTION_PAGE_SIZE     		 	= 2
Const ADS_OPTION_SECURITY_MASK  		= 3    

' -------------------------------------------------------------------------------------------------
' Security Descriptor Control Flags definition  (SECURITY_DESCRIPTOR_CONTROL)
Const SE_OWNER_DEFAULTED        		= &h0001
Const SE_GROUP_DEFAULTED        		= &h0002
Const SE_DACL_PRESENT           		= &h0004
Const SE_DACL_DEFAULTED         		= &h0008
Const SE_SACL_PRESENT           		= &h0010
Const SE_SACL_DEFAULTED         		= &h0020
Const SE_DACL_AUTO_INHERIT_REQ 			= &h0100
Const SE_SACL_AUTO_INHERIT_REQ  		= &h0200
Const SE_DACL_AUTO_INHERITED    		= &h0400
Const SE_SACL_AUTO_INHERITED    		= &h0800
Const SE_DACL_PROTECTED         		= &h1000
Const SE_SACL_PROTECTED         		= &h2000
Const SE_SELF_RELATIVE          		= &h8000

' -------------------------------------------------------------------------------------------------
' Active Directory Service ACEType definition (ADS_ACETYPE_ENUM)
Const ADS_ACETYPE_ACCESS_ALLOWED                = &h0
Const ADS_ACETYPE_ACCESS_DENIED                 = &h1
Const ADS_ACETYPE_SYSTEM_AUDIT                  = &h2
Const ADS_ACETYPE_ACCESS_ALLOWED_OBJECT         = &h5
Const ADS_ACETYPE_ACCESS_DENIED_OBJECT          = &h6
Const ADS_ACETYPE_SYSTEM_AUDIT_OBJECT           = &h7

' -------------------------------------------------------------------------------------------------
' File System ACEType definition (ADS_ACETYPE_ENUM)
Const ACCESS_ALLOWED_ACE_TYPE   		= &H0
Const ACCESS_DENIED_ACE_TYPE    		= &H1
Const SYSTEM_AUDIT_ACE_TYPE     		= &H2
Const SYSTEM_ALARM_ACE_TYPE     		= &H3

' -------------------------------------------------------------------------------------------------
' Active Directory Rights definition (ADS_RIGHTS_ENUM)
Const ADS_RIGHT_DELETE                  	= &h00010000
Const ADS_RIGHT_READ_CONTROL            	= &h00020000
Const ADS_RIGHT_WRITE_DAC               	= &h00040000
Const ADS_RIGHT_WRITE_OWNER             	= &h00080000
Const ADS_RIGHT_SYNCHRONIZE             	= &h00100000
Const ADS_RIGHT_ACCESS_SYSTEM_SECURITY  	= &h01000000

Const ADS_RIGHT_GENERIC_READ            	= &h80000000
Const ADS_RIGHT_GENERIC_WRITE           	= &h40000000
Const ADS_RIGHT_GENERIC_EXECUTE         	= &h20000000
Const ADS_RIGHT_GENERIC_ALL             	= &h10000000
Const ADS_RIGHT_DS_CREATE_CHILD         	= &h00000001
Const ADS_RIGHT_DS_DELETE_CHILD         	= &h00000002
Const ADS_RIGHT_ACTRL_DS_LIST           	= &h00000004
Const ADS_RIGHT_DS_SELF                 	= &h00000008
Const ADS_RIGHT_DS_READ_PROP            	= &h00000010
Const ADS_RIGHT_DS_WRITE_PROP           	= &h00000020
Const ADS_RIGHT_DS_DELETE_TREE          	= &h00000040
Const ADS_RIGHT_DS_LIST_OBJECT          	= &h00000080
Const ADS_RIGHT_DS_CONTROL_ACCESS       	= &h00000100

' -------------------------------------------------------------------------------------------------
' File System Rights definition
Const FILE_DELETE                    		= &H010000
Const FILE_READ_CONTROL              		= &H020000
Const FILE_WRITE_DAC                 		= &H040000
Const FILE_WRITE_OWNER               		= &H080000
Const FILE_SYNCHRONIZE               		= &H100000

Const FILE_READ_DATA            		= &H000001
Const FILE_LIST_DIRECTORY       		= &H000001
Const FILE_WRITE_DATA           		= &H000002
Const FILE_ADD_FILE             		= &H000002
Const FILE_APPEND_DATA          		= &H000004
Const FILE_ADD_SUBDIRECTORY     		= &H000004
Const FILE_READ_EA              		= &H000008
Const FILE_WRITE_EA             		= &H000010
Const FILE_EXECUTE              		= &H000020
Const FILE_TRAVERSE             		= &H000020
Const FILE_DELETE_CHILD         		= &H000040
Const FILE_READ_ATTRIBUTES      		= &H000080
Const FILE_WRITE_ATTRIBUTES     		= &H000100
Const FILE_ALL_ACCESS           		= &H1F01FF
Const FILE_GENERIC_READ         		= &H120089
Const FILE_GENERIC_WRITE        		= &H100116
Const FILE_GENERIC_EXECUTE      		= &h1200A9

' -------------------------------------------------------------------------------------------------
' Microsoft Exchange 2000 Mailbox Right definition (MB_RIGHTS_ENUM)
' Warning: These values are not official. The given values were found by deciphering
'          mailbox ACE under Windows 2000 RTM and Exchange 2000 Beta RTM.
Const RIGHT_MB_FULL_MB_ACCESS                  	= &H00001
Const RIGHT_MB_SEND_AS                  	= &H00002
Const RIGHT_MB_EXTERNAL_ACCOUNT            	= &H00004
Const RIGHT_MB_DELETE                   	= &h10000
Const RIGHT_MB_READ_PERMISSIONS         	= &h20000
Const RIGHT_MB_CHANGE_PERMISSIONS       	= &h40000
Const RIGHT_MB_TAKE_OWNERSHIP           	= &h80000

' -------------------------------------------------------------------------------------------------
' Active Directory AceFlag definition (ADS_ACEFLAG_ENUM)
' File System AceFlag definition.
Const OBJECT_INHERIT_ACE                	= &h01
Const CONTAINER_INHERIT_ACE             	= &h02
Const NO_PROPAGATE_INHERIT_ACE          	= &h04
Const INHERIT_ONLY_ACE                  	= &h08
Const INHERITED_ACE                     	= &h10
Const VALID_INHERIT_FLAGS               	= &h1F
Const SUCCESSFUL_ACCESS_ACE_FLAG        	= &h40
Const FAILED_ACCESS_ACE_FLAG            	= &h80

' -------------------------------------------------------------------------------------------------
' Active Directory FlagType definition (ADS_FLAGTYPE_ENUM)
Const ADS_FLAG_OBJECT_TYPE_PRESENT              = &h1
Const ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT    = &h2

' -------------------------------------------------------------------------------------------------
' Security Descriptor and Access Control List Revision Number
Const ADS_SD_REVISION_DS        		= 4
Const ADS_ACL_REVISION_DS       		= 4

' -------------------------------------------------------------------------------------------------
' Constants used for multivalued properties operations via .PutEx method
Const ADS_PROPERTY_CLEAR        		= 1
Const ADS_PROPERTY_UPDATE       		= 2
Const ADS_PROPERTY_APPEND       		= 3
Const ADS_PROPERTY_DELETE       		= 4

' -------------------------------------------------------------------------------------------------
' User Account security settings for user creation
Const ADS_UF_SCRIPT                         	= &h000001
Const ADS_UF_ACCOUNTDISABLE                 	= &h000002
Const ADS_UF_HOMEDIR_REQUIRED               	= &h000008
Const ADS_UF_LOCKOUT                        	= &h000010
Const ADS_UF_PASSWD_NOTREQD                 	= &h000020
Const ADS_UF_PASSWD_CANT_CHANGE             	= &h000040
Const ADS_UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED	= &h000080
Const ADS_UF_TEMP_DUPLICATE_ACCOUNT		= &h000100
Const ADS_UF_ENCRYPTED_CLEAR_TEXT           	= &h000200
Const ADS_UF_INTERDOMAIN_TRUST_ACCOUNT		= &h000800
Const ADS_UF_WORKSTATION_TRUST_ACCOUNT		= &h001000
Const ADS_UF_SERVER_TRUST_ACCOUNT		= &h002000
Const ADS_UF_DONT_EXPIRE_PASSWD             	= &h010000
Const ADS_UF_MNS_LOGON_ACCOUNT	            	= &h020000
Const ADS_UF_SMARTCARD_REQUIRED             	= &h040000
Const ADS_UF_TRUSTED_FOR_DELEGATION         	= &h080000
Const ADS_UF_NOT_DELEGATED		    	= &h100000
Const ADS_UF_DES_ENCRYPTION                 	= &h200000
Const ADS_UF_DONT_REQUIRE_KERBEROS          	= &h400000

' -------------------------------------------------------------------------------------------------
' Constant used for the group type definition at creation
Const ADS_GROUP_TYPE_GLOBAL_GROUP               = &h00000002
Const ADS_GROUP_TYPE_DOMAIN_LOCAL_GROUP         = &h00000004
Const ADS_GROUP_TYPE_LOCAL_GROUP		= &h00000004
Const ADS_GROUP_TYPE_UNIVERSAL_GROUP            = &h00000008
Const ADS_GROUP_TYPE_SECURITY_ENABLED           = &h80000000

' -------------------------------------------------------------------------------------------------
' System Flags definition for schema analysis
Const ADS_SYSTEMFLAG_DISALLOW_DELETE             = &h80000000
Const ADS_SYSTEMFLAG_CONFIG_ALLOW_RENAME         = &h40000000
Const ADS_SYSTEMFLAG_CONFIG_ALLOW_MOVE           = &h20000000
Const ADS_SYSTEMFLAG_CONFIG_ALLOW_LIMITED_MOVE   = &h10000000

Const ADS_SYSTEMFLAG_DOMAIN_DISALLOW_RENAME      = &h08000000
Const ADS_SYSTEMFLAG_DOMAIN_DISALLOW_MOVE        = &h04000000
Const ADS_SYSTEMFLAG_CR_NTDS_NC                  = &h00000001
Const ADS_SYSTEMFLAG_CR_NTDS_DOMAIN              = &h00000002
Const ADS_SYSTEMFLAG_ATTR_NOT_REPLICATED         = &h00000001
Const ADS_SYSTEMFLAG_ATTR_IS_CONTRUCTED          = &h00000004

' -------------------------------------------------------------------------------------------------
' Internal constants for misc. property type values reading
Const ADSTYPE_INVALID                   	= 0
Const ADSTYPE_DN_STRING                 	= 1
Const ADSTYPE_CASE_EXACT_STRING         	= 2
Const ADSTYPE_CASE_IGNORE_STRING        	= 3
Const ADSTYPE_PRINTABLE_STRING          	= 4
Const ADSTYPE_NUMERIC_STRING            	= 5
Const ADSTYPE_BOOLEAN                   	= 6
Const ADSTYPE_INTEGER                   	= 7
Const ADSTYPE_OCTET_STRING              	= 8
Const ADSTYPE_UTC_TIME                  	= 9
Const ADSTYPE_LARGE_INTEGER             	= 10
Const ADSTYPE_PROV_SPECIFIC             	= 11
Const ADSTYPE_OBJECT_CLASS              	= 12
Const ADSTYPE_CASEIGNORE_LIST           	= 13
Const ADSTYPE_OCTET_LIST                	= 14
Const ADSTYPE_PATH                      	= 15
Const ADSTYPE_POSTALADDRESS             	= 16
Const ADSTYPE_TIMESTAMP                 	= 17
Const ADSTYPE_BACKLINK                  	= 18
Const ADSTYPE_TYPEDNAME                 	= 19
Const ADSTYPE_HOLD                      	= 20
Const ADSTYPE_NETADDRESS                	= 21
Const ADSTYPE_REPLICAPOINTER            	= 22
Const ADSTYPE_FAXNUMBER                 	= 23
Const ADSTYPE_EMAIL                     	= 24
Const ADSTYPE_NT_SECURITY_DESCRIPTOR    	= 25
Const ADSTYPE_UNKNOWN                   	= 26

' -----------------------------------------------------------------------------------------------------------------------
'Popup box buttons, icons and mouse click answer definitions
Const cOKButton                 		= 0
Const cOkCancelButton           		= 1
Const cAbortRetryIgnoreButton   		= 2
Const cYesNoCancelButton        		= 3
Const cYesNoButton              		= 4
Const cRetryCancelButton        		= 5

Const cStopMarkIcon             		= 16
Const cQuestionMarkIcon         		= 32
Const cExclamationMarkIcon      		= 48
Const cInformationMarkIcon      		= 64

Const cOKClick                  		= 1
Const cCancelClick              		= 2
Const cAbortClick               		= 3
Const cRetryClick               		= 4
Const cIgnoreClick              		= 5
Const cYesClick                 		= 6
Const cNoClick                  		= 7

' -------------------------------------------------------------------------------------------------
' Internal constants to determine FileSystem access
' or Active Directory access when accessing security descriptors
Const FS_OBJECT = 0
Const AD_OBJECT = 1
Const MB_OBJECT = 2