' VB Script creating a File System share via the WinNT: namespace if the given '
' share name does not exist.                                                   '
'                                                                              '
' Version 1.00 - Alain Lissoir                                                 '
' Compaq Computer Corporation - Professional Services - Belgium -              '
'                                                                              '
' Any comments or questions:                    EMail:alain.lissoir@compaq.com '

Option Explicit

Const WINNT_SHARE_NOT_EXIST = &h80070906

' ------------------------------------------------------------------------------------------------------
Private Sub CreateShare (strComputer, strShareName, _
                         strDirLocalAccess, strShareCount, _
                         strShareDescription)

        ' Add the home directory share for the user on the given server
        Dim objShareSrv
        Dim objShare
        Dim strSharePath

        strSharePath = "WinNT://" & strComputer & "/LanManServer"
        Set objShareSrv = GetObject(strSharePath)

        ' Continue even if the share doesn't exists
        On Error Resume Next
        ' Clear any prior error to avoid confusion during next test
        Err.Clear

        Set objShare = objShareSrv.GetObject ("FileShare", strShareName)
        If Err.Number = WINNT_SHARE_NOT_EXIST Then
           On Error Goto 0
           Set objShare = objShareSrv.Create ("FileShare", strShareName)

           objShare.Path = strDirLocalAccess
           objShare.MaxUserCount = strShareCount
           objShare.Description = strShareDescription

           objShare.SetInfo

           Wscript.Echo "  Successfully created Directory Share '\\" & _
                        strComputer & "\" & strShareName & "'."
        Else
           Wscript.Echo "  Directory Share '\\" & strComputer & _
                        "\" & strShareName & "' already exists."
        End If

        WScript.DisconnectObject objShareSrv
        Set objShareSrv = Nothing

        WScript.DisconnectObject objShare
        Set objShare = Nothing

End Sub