' VB Script to add ACE on File System and Active Directory objects           '
'                                                                            '
' Version 1.00 - Alain Lissoir                                               '
' Compaq Computer Corporation - Professional Services - Belgium -            '
'                                                                            '
' Any comments or questions:                  EMail:alain.lissoir@compaq.com '

Option Explicit

' -------------------------------------------------------------------------------------------------
Public Sub AddRights(strObject, strTrustee, intACEType, intAccessMask, intACEFlags, strObjectType)

        Dim objSecurity
        Dim objADObject
        Dim objSD
        Dim objDACL
        Dim objACE
        Dim objNewACE

        Select Case strObjectType
               Case FS_OBJECT
                    Set objSecurity = CreateObject("ADsSecurity")
                    Set objSD = objSecurity.GetSecurityDescriptor("FILE://" & strObject)
               Case AD_OBJECT
                    Set objADObject = GetObject("LDAP://" & strObject)
                    Set objSD = objADObject.Get("ntSecurityDescriptor")
               Case Else
                    Exit Sub
        End Select

        Set objDACL = objSD.DiscretionaryAcl

        Set objNewACE = CreateObject("AccessControlEntry")

        ' Add the new Trustee with his specific rights
        objNewACE.Trustee = strTrustee
        objNewACE.AceType = intACEType
        objNewACE.AccessMask = intAccessMask
        objNewACE.AceFlags = intACEFlags

        objDACL.AddAce objNewACE
        objSD.DiscretionaryAcl = objDACL

        Select Case strObjectType
               Case FS_OBJECT
                    objSecurity.SetSecurityDescriptor objSD
                    WScript.DisconnectObject objSecurity
                    Set objSecurity = Nothing
               Case AD_OBJECT
                    objADObject.Put "ntSecurityDescriptor", objSD
                    objADObject.SetInfo
                    WScript.DisconnectObject objADObject
                    Set objADObject = Nothing
        End Select

        Wscript.Echo "  Trustee '" & strTrustee & "' has been added to '" & strObject & "'"

        ' Complete, deallocate object bindings
        Set objDACL = Nothing
        Set objSD = Nothing

        WScript.DisconnectObject objNewACE
        Set objNewACE = Nothing

End Sub